/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class UserListDialog
extends ToggleDialog
implements DataSelectionListener,
MainLayerManager.ActiveLayerChangeListener {
    private JTable userTable;
    private UserTableModel model;
    private SelectUsersPrimitivesAction selectionUsersPrimitivesAction;
    private final JPopupMenu popupMenu = new JPopupMenu();

    public UserListDialog() {
        super(I18n.tr("Authors", new Object[0]), "userlist", I18n.tr("Open a list of people working on the selected objects.", new Object[0]), Shortcut.registerShortcut("subwindow:authors", I18n.tr("Windows: {0}", I18n.tr("Authors", new Object[0])), 65, 5007), 150);
        this.build();
    }

    @Override
    public void showNotify() {
        SelectionEventManager.getInstance().addSelectionListenerForEdt(this);
        MainApplication.getLayerManager().addActiveLayerChangeListener(this);
    }

    @Override
    public void hideNotify() {
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this);
        SelectionEventManager.getInstance().removeSelectionListener(this);
    }

    protected void build() {
        this.model = new UserTableModel();
        this.userTable = new JTable(this.model);
        this.userTable.setSelectionMode(2);
        this.userTable.addMouseListener(new DoubleClickAdapter());
        this.selectionUsersPrimitivesAction = new SelectUsersPrimitivesAction();
        this.userTable.getSelectionModel().addListSelectionListener(this.selectionUsersPrimitivesAction);
        ShowUserInfoAction showUserInfoAction = new ShowUserInfoAction();
        this.userTable.getSelectionModel().addListSelectionListener(showUserInfoAction);
        this.createLayout(this.userTable, true, Arrays.asList(new SideButton(this.selectionUsersPrimitivesAction), new SideButton(showUserInfoAction)));
        this.popupMenu.add(new AbstractAction(I18n.tr("Copy", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClipboardUtils.copyString(UserListDialog.this.getSelectedUsers().stream().map(User::getName).collect(Collectors.joining(", ")));
            }
        });
        this.userTable.addMouseListener(new PopupMenuLauncher(this.popupMenu));
    }

    @Override
    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        this.refresh(event.getSelection());
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        Layer activeLayer = e.getSource().getActiveLayer();
        this.refreshForActiveLayer(activeLayer);
    }

    private void refreshForActiveLayer(Layer activeLayer) {
        if (activeLayer instanceof OsmDataLayer) {
            this.refresh(((OsmDataLayer)activeLayer).data.getAllSelected());
        } else {
            this.refresh(null);
        }
    }

    public void refresh(Collection<? extends OsmPrimitive> fromPrimitives) {
        GuiHelper.runInEDT(() -> {
            this.model.populate(fromPrimitives);
            if (this.model.getRowCount() != 0) {
                this.setTitle(I18n.trn("{0} Author", "{0} Authors", this.model.getRowCount(), this.model.getRowCount()));
            } else {
                this.setTitle(I18n.tr("Authors", new Object[0]));
            }
        });
    }

    @Override
    public void showDialog() {
        super.showDialog();
        this.refreshForActiveLayer(MainApplication.getLayerManager().getActiveLayer());
    }

    private List<User> getSelectedUsers() {
        int[] rows = this.userTable.getSelectedRows();
        return this.model.getSelectedUsers(rows);
    }

    static class UserTableModel
    extends DefaultTableModel {
        private final transient List<UserInfo> data;

        UserTableModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr("Author", new Object[0]), I18n.tr("# Objects", new Object[0]), "%"});
            this.data = new ArrayList<UserInfo>();
        }

        protected Map<User, Integer> computeStatistics(Collection<? extends OsmPrimitive> primitives) {
            HashMap<User, Integer> ret = new HashMap<User, Integer>();
            if (Utils.isEmpty(primitives)) {
                return ret;
            }
            for (OsmPrimitive osmPrimitive : primitives) {
                if (ret.containsKey(osmPrimitive.getUser())) {
                    ret.put(osmPrimitive.getUser(), (Integer)ret.get(osmPrimitive.getUser()) + 1);
                    continue;
                }
                ret.put(osmPrimitive.getUser(), 1);
            }
            return ret;
        }

        public void populate(Collection<? extends OsmPrimitive> primitives) {
            GuiHelper.assertCallFromEdt();
            Map<User, Integer> statistics = this.computeStatistics(primitives);
            this.data.clear();
            if (primitives != null) {
                for (Map.Entry<User, Integer> entry : statistics.entrySet()) {
                    this.data.add(new UserInfo(entry.getKey(), entry.getValue(), (double)entry.getValue().intValue() / (double)primitives.size()));
                }
            }
            Collections.sort(this.data);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            UserInfo info = this.data.get(row);
            switch (column) {
                case 0: {
                    return info.getName() == null ? "" : info.getName();
                }
                case 1: {
                    return info.count;
                }
                case 2: {
                    return NumberFormat.getPercentInstance().format(info.percent);
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void selectPrimitivesOwnedBy(int ... rows) {
            Set users = Arrays.stream(rows).mapToObj(index -> this.data.get((int)index).user).collect(Collectors.toSet());
            OsmData<?, ?, ?, ?> ds = MainApplication.getLayerManager().getActiveData();
            Collection<?> selected = ds.getAllSelected();
            Collection byUser = selected.stream().filter(p -> users.contains(p.getUser())).collect(Collectors.toList());
            ds.setSelected(byUser);
        }

        public List<User> getSelectedUsers(int ... rows) {
            if (rows == null || rows.length == 0) {
                return Collections.emptyList();
            }
            return Arrays.stream(rows).filter(row -> this.data.get((int)row).user != null).mapToObj(row -> this.data.get((int)row).user).collect(Collectors.toList());
        }
    }

    private static class UserInfo
    implements Comparable<UserInfo> {
        public final User user;
        public final int count;
        public final double percent;

        UserInfo(User user, int count, double percent) {
            this.user = user;
            this.count = count;
            this.percent = percent;
        }

        @Override
        public int compareTo(UserInfo o) {
            if (this.count < o.count) {
                return 1;
            }
            if (this.count > o.count) {
                return -1;
            }
            if (this.user == null || this.user.getName() == null) {
                return 1;
            }
            if (o.user == null || o.user.getName() == null) {
                return -1;
            }
            return this.user.getName().compareTo(o.user.getName());
        }

        public String getName() {
            if (this.user == null) {
                return I18n.tr("<new object>", new Object[0]);
            }
            return this.user.getName();
        }
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                UserListDialog.this.selectionUsersPrimitivesAction.select();
            }
        }
    }

    class ShowUserInfoAction
    extends AbstractInfoAction
    implements ListSelectionListener {
        ShowUserInfoAction() {
            super(I18n.tr("Show info", new Object[0]), "help/internet", I18n.tr("Launches a browser with information about the user", new Object[0]), Shortcut.registerShortcut("user:open_in_browser", I18n.tr("User: Show info in browser", new Object[0]), 0, 5000), false, null, false);
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String url;
            List users = UserListDialog.this.getSelectedUsers();
            if (users.isEmpty()) {
                return;
            }
            if (users.size() > 10) {
                Logging.warn(I18n.tr("Only launching info browsers for the first {0} of {1} selected users", 10, users.size()));
            }
            Iterator it = users.iterator();
            for (int num = Math.min(10, users.size()); it.hasNext() && num > 0 && (url = this.createInfoUrl(it.next())) != null; --num) {
                OpenBrowser.displayUrl(url);
            }
        }

        @Override
        protected String createInfoUrl(Object infoObject) {
            if (infoObject instanceof User) {
                User user = (User)infoObject;
                return Config.getUrls().getBaseUserUrl() + '/' + Utils.encodeUrl(user.getName()).replace("+", "%20");
            }
            return null;
        }

        @Override
        protected void updateEnabledState() {
            this.setEnabled(UserListDialog.this.userTable != null && UserListDialog.this.userTable.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class SelectUsersPrimitivesAction
    extends JosmAction
    implements ListSelectionListener {
        SelectUsersPrimitivesAction() {
            super(I18n.tr("Select", new Object[0]), "dialogs/select", I18n.tr("Select objects submitted by this user", new Object[0]), Shortcut.registerShortcut("user:select_primitives", I18n.tr("User: objects submitted by selected user", new Object[0]), 0, 5000), false, false);
            this.updateEnabledState();
        }

        public void select() {
            int[] indexes = UserListDialog.this.userTable.getSelectedRows();
            if (indexes.length == 0) {
                return;
            }
            UserListDialog.this.model.selectPrimitivesOwnedBy(UserListDialog.this.userTable.getSelectedRows());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.select();
        }

        @Override
        protected void updateEnabledState() {
            this.setEnabled(UserListDialog.this.userTable != null && UserListDialog.this.userTable.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }
}

