/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import java.util.Hashtable;
import java.util.Map;
import javajs.export.PDFCreator;
import javajs.img.ImageEncoder;

public class PdfEncoder
extends ImageEncoder {
    private boolean isLandscape;
    private PDFCreator pdf;
    private String comment;

    @Override
    protected void setParams(Map<String, Object> params) {
        this.isLandscape = this.quality > 1;
        this.comment = "Jmol " + (String)params.get("comment");
    }

    @Override
    protected void generate() throws Exception {
        this.pdf = new PDFCreator();
        int pageWidth = 576;
        int pageHeight = 792;
        this.pdf.setOutputStream(this.out);
        this.pdf.newDocument(pageWidth, pageHeight, this.isLandscape);
        this.addMyImage(pageWidth, pageHeight);
        Hashtable<String, String> ht = new Hashtable<String, String>();
        if (this.comment != null) {
            ht.put("Producer", this.comment);
        }
        ht.put("Author", "JMol");
        ht.put("CreationDate", this.date);
        this.pdf.addInfo(ht);
        this.pdf.closeDocument();
    }

    private void addMyImage(int pageWidth, int pageHeight) {
        this.pdf.addImageResource("img1", this.width, this.height, this.pixels, true);
        int w = this.isLandscape ? pageHeight : pageWidth;
        int h = this.isLandscape ? pageWidth : pageHeight;
        int iw = this.width;
        int ih = this.height;
        if ((double)iw > 0.9 * (double)w) {
            ih = (int)((double)ih * 0.9 * (double)w / (double)iw);
            iw = (int)((double)w * 0.9);
        }
        if ((double)ih > 0.9 * (double)h) {
            iw = (int)((double)iw * 0.9 * (double)h / (double)ih);
            ih = (int)((double)h * 0.9);
        }
        int x = 0;
        int y = 0;
        int x1 = iw;
        int y1 = ih;
        if (w > iw) {
            x = (w - iw) / 2;
            x1 = iw + x;
        }
        if (h > ih) {
            y = (h - ih) / 2;
            y1 = ih + y;
        }
        this.pdf.drawImage("img1", x, y, x1, y1, 0, 0, this.width, this.height);
    }
}

