//
// Copyright (c) 2017, Intel Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// Redistributions of source code must retain the above copyright notice, this
// list of conditions and the following disclaimer.
//
// Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
//
// Neither the name of the Intel Corporation nor the names of its contributors
// may be used to endorse or promote products derived from this software
// without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

/**
 * \file types.h
 * \brief Type defintions for MPF
 */

#ifndef __FPGA_MPF_TYPES_H__
#define __FPGA_MPF_TYPES_H__

// Macro for defining symbol visibility
#ifdef _WIN32
#define __MPF_API__ __declspec(dllexport)
#else
#define __MPF_API__ __attribute__((visibility("default")))
#endif

/** Handle to open MPF instance */
typedef void* mpf_handle_t;

/** Flags for controlling MPF behavior.  These are bitwise ORed together
 *  and passed to mpfConnect().
 */
enum mpf_flags_t
{
    MPF_FLAG_NONE = 0,
    MPF_FLAG_DEBUG = 1,
    MPF_FLAG_FEATURE_ID = 2
};

// Size of a cache line in CCI
#ifndef CL
# define CL(x)                       ((x) * 64)
#endif

#endif // __FPGA_MPF_TYPES_H__
