# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_hq_global_optspecs
	string join \n server-dir= colors= output-mode= debug h/help V/version
end

function __fish_hq_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_hq_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_hq_using_subcommand
	set -l cmd (__fish_hq_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c hq -n "__fish_hq_needs_command" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_needs_command" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_needs_command" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_needs_command" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_needs_command" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_needs_command" -s V -l version -d 'Print version'
complete -c hq -n "__fish_hq_needs_command" -f -a "server" -d 'Commands for the server'
complete -c hq -n "__fish_hq_needs_command" -f -a "job" -d 'Commands for jobs'
complete -c hq -n "__fish_hq_needs_command" -f -a "task" -d 'Commands for tasks'
complete -c hq -n "__fish_hq_needs_command" -f -a "submit" -d 'Submits a new job'
complete -c hq -n "__fish_hq_needs_command" -f -a "worker" -d 'Commands for workers'
complete -c hq -n "__fish_hq_needs_command" -f -a "output-log" -d 'Operations for streaming logs'
complete -c hq -n "__fish_hq_needs_command" -f -a "alloc" -d 'Automatic allocation management'
complete -c hq -n "__fish_hq_needs_command" -f -a "journal" -d 'Journal management'
complete -c hq -n "__fish_hq_needs_command" -f -a "data" -d 'Data object management inside a task'
complete -c hq -n "__fish_hq_needs_command" -f -a "dashboard" -d 'Starts CLI dashboard'
complete -c hq -n "__fish_hq_needs_command" -f -a "doc" -d 'Shows documentation'
complete -c hq -n "__fish_hq_needs_command" -f -a "generate-completion" -d 'Generates shell completion script'
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -f -a "start" -d 'Start the server'
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -f -a "stop" -d 'Stop the server'
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -f -a "info" -d 'Show info of a running server'
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -f -a "generate-access" -d 'Generate an access file without starting the server'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l host -d 'Hostname/IP of the machine under which is visible to others' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l idle-timeout -d 'Duration after which will an idle worker automatically stop.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l client-port -d 'The port for client connections' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l worker-port -d 'The port for worker connections' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l journal -d 'The path to a journal file' -r -F
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l journal-flush-period -d 'Configure how often should be the journal written.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l access-file -d 'The path to an access file' -r -F
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l disable-client-authentication-and-encryption -d 'If set, the client connection will NOT be AUTHENTICATED and ENCRYPTED'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l disable-worker-authentication-and-encryption -d 'If set, the worker connection will NOT be AUTHENTICATED and ENCRYPTED'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from stop" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from stop" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from stop" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from stop" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from stop" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from info" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from info" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from info" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from info" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l client-file -d 'The filename of the generated client\'s access file' -r -F
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l worker-file -d 'The filename of the generated worker\'s access file' -r -F
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l host -d 'Override the target host name' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l client-host -d 'Override target host name for clients' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l worker-host -d 'Override target host name for workers' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l client-port -d 'The port for connecting client' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l worker-port -d 'The port for connecting workers' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "list" -d 'Displays information about jobs'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "summary" -d 'Displays a summary with the number of jobs'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "info" -d 'Displays detailed information of a job'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "cancel" -d 'Cancels a job'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "forget" -d 'Forget a job'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "cat" -d 'Shows task(s) stdout and stderr'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "submit" -d 'Submit a new job'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "submit-file" -d 'Submits a job by a job definition file'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "wait" -d 'Waits until a job is finished'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "progress" -d 'Shows a progressbar with tasks/jobs'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "task-ids" -d 'Prints task ids for a job'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "open" -d 'Opens a new job (without attaching any tasks yet)'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "close" -d 'Closes an open job'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from list" -l filter -d 'Display only jobs with the given states' -r -f -a "waiting\t''
running\t''
finished\t''
failed\t''
canceled\t''
opened\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from list" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from list" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from list" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from list" -l all -d 'Display all jobs'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from list" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from summary" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from summary" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from summary" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from summary" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from summary" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from info" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from info" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from info" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from info" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cancel" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cancel" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cancel" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cancel" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cancel" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from forget" -l filter -d 'Forget only jobs with the given states' -r -f -a "finished\t''
failed\t''
canceled\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from forget" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from forget" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from forget" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from forget" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from forget" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cat" -l tasks -d 'Filter task(s) by ID' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cat" -l task-status -d 'Filter task(s) by status. You can use multiple states separated by a comma' -r -f -a "waiting\t''
running\t''
finished\t''
failed\t''
canceled\t''
opened\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cat" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cat" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cat" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cat" -l print-task-header -d 'Add task headers to the output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cat" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cat" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l name -d 'The name of the job' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l max-fails -d 'Maximum number tasks that may fail in the job' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l nodes -d 'The number of nodes' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l cpus -d 'The number and placement of CPUs for each job' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l resource -d 'The request of resources in the form <NAME>=<AMOUNT>' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l time-request -d 'Minimal lifetime of the worker needed to start the job  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l pin -d 'Pins the job to the cores specified in `--cpus`' -r -f -a "taskset\t''
omp\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l cwd -d 'Working directory for submitted tasks' -r -F
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l stdout -d 'Where to store the standard output of tasks' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l stderr -d 'Where to store the standard error output of tasks' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l env -d 'Additional environment variable for tasks' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l each-line -d 'Creates a task for each line of the given file' -r -F
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l from-json -d 'Creates a task for each item of JSON array in the given file' -r -F
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l array -d 'Creates a task array' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l priority -d 'Tasks priority' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l time-limit -d 'Time limit per task. E.g. --time-limit=10min  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l stream -d 'Stream the output of tasks into the given log file' -r -F
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l crash-limit -d 'Sets the crash counter limit' -r -f -a "never-restart\t''
unlimited\t''
<number>\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l job -d 'Attach a submission to an open job' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l directives -d 'Select directives parsing mode' -r -f -a "auto\t''
file\t''
stdin\t''
off\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l task-dir -d 'Create a temporary directory for task(s)'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l wait -d 'Wait for the job to finish'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l progress -d 'Shows a progressbar'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l stdin -d 'Attach the stdin to the task'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit-file" -l job -d 'Attach a submission to an open job' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit-file" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit-file" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit-file" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit-file" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit-file" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from wait" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from wait" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from wait" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from wait" -l without-close -d 'Waits until all tasks are completed, even if the job is still open'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from wait" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from wait" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from progress" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from progress" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from progress" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from progress" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from progress" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from task-ids" -l filter -d 'Selects only tasks with the given state(s)' -r -f -a "waiting\t''
running\t''
finished\t''
failed\t''
canceled\t''
opened\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from task-ids" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from task-ids" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from task-ids" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from task-ids" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from task-ids" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from open" -l name -d 'The name of the job' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from open" -l max-fails -d 'Maximum number tasks that may fail in the job' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from open" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from open" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from open" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from open" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from open" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from close" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from close" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from close" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from close" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from close" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand task; and not __fish_seen_subcommand_from list info explain" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand task; and not __fish_seen_subcommand_from list info explain" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand task; and not __fish_seen_subcommand_from list info explain" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand task; and not __fish_seen_subcommand_from list info explain" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand task; and not __fish_seen_subcommand_from list info explain" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand task; and not __fish_seen_subcommand_from list info explain" -f -a "list" -d 'Displays task(s) associated with selected job(s)'
complete -c hq -n "__fish_hq_using_subcommand task; and not __fish_seen_subcommand_from list info explain" -f -a "info" -d 'Displays detailed task info'
complete -c hq -n "__fish_hq_using_subcommand task; and not __fish_seen_subcommand_from list info explain" -f -a "explain" -d 'Explain if task can run on a selected worker'
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from list" -l tasks -d 'Filter task(s) by ID' -r
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from list" -l task-status -d 'Filter task(s) by status. You can use multiple states separated by a comma' -r -f -a "waiting\t''
running\t''
finished\t''
failed\t''
canceled\t''
opened\t''"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from list" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from list" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from list" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from list" -s v -d 'Use this flag to enable verbose output'
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from list" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from info" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from info" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from info" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from info" -s v -d 'Use this flag to enable verbose output'
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from info" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from explain" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from explain" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from explain" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from explain" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from explain" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand submit" -l name -d 'The name of the job' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l max-fails -d 'Maximum number tasks that may fail in the job' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l nodes -d 'The number of nodes' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l cpus -d 'The number and placement of CPUs for each job' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l resource -d 'The request of resources in the form <NAME>=<AMOUNT>' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l time-request -d 'Minimal lifetime of the worker needed to start the job  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l pin -d 'Pins the job to the cores specified in `--cpus`' -r -f -a "taskset\t''
omp\t''"
complete -c hq -n "__fish_hq_using_subcommand submit" -l cwd -d 'Working directory for submitted tasks' -r -F
complete -c hq -n "__fish_hq_using_subcommand submit" -l stdout -d 'Where to store the standard output of tasks' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l stderr -d 'Where to store the standard error output of tasks' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l env -d 'Additional environment variable for tasks' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l each-line -d 'Creates a task for each line of the given file' -r -F
complete -c hq -n "__fish_hq_using_subcommand submit" -l from-json -d 'Creates a task for each item of JSON array in the given file' -r -F
complete -c hq -n "__fish_hq_using_subcommand submit" -l array -d 'Creates a task array' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l priority -d 'Tasks priority' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l time-limit -d 'Time limit per task. E.g. --time-limit=10min  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l stream -d 'Stream the output of tasks into the given log file' -r -F
complete -c hq -n "__fish_hq_using_subcommand submit" -l crash-limit -d 'Sets the crash counter limit' -r -f -a "never-restart\t''
unlimited\t''
<number>\t''"
complete -c hq -n "__fish_hq_using_subcommand submit" -l job -d 'Attach a submission to an open job' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l directives -d 'Select directives parsing mode' -r -f -a "auto\t''
file\t''
stdin\t''
off\t''"
complete -c hq -n "__fish_hq_using_subcommand submit" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand submit" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand submit" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand submit" -l task-dir -d 'Create a temporary directory for task(s)'
complete -c hq -n "__fish_hq_using_subcommand submit" -l wait -d 'Wait for the job to finish'
complete -c hq -n "__fish_hq_using_subcommand submit" -l progress -d 'Shows a progressbar'
complete -c hq -n "__fish_hq_using_subcommand submit" -l stdin -d 'Attach the stdin to the task'
complete -c hq -n "__fish_hq_using_subcommand submit" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand submit" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -f -a "start" -d 'Starts a worker'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -f -a "stop" -d 'Stops a worker'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -f -a "list" -d 'Displays information about workers'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -f -a "hwdetect" -d 'Performs hardware detection'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -f -a "info" -d 'Displays information about a worker'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -f -a "address" -d 'Displays worker\'s hostname'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -f -a "wait" -d 'Waits on the connection of worker(s)'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -f -a "deploy-ssh" -d 'Deploys a set of workers using SSH'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l cpus -d 'The cores assigned to the worker' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l resource -d 'Resources provided by the worker' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l group -d 'Sets worker\'s group' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l idle-timeout -d 'Duration after which will an idle worker automatically stop  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l overview-interval -d 'The period of reporting the overview to the server' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l heartbeat -d 'How often heartbeats are sent  Heartbeats are used to detect worker\'s liveness. If the worker does not send a heartbeat for given time, then the worker is considered as lost.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l time-limit -d 'Worker time limit  Worker exits after given time.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l manager -d 'Sets HPC job manager for the worker' -r -f -a "detect\t''
none\t''
pbs\t''
slurm\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l hostname -d 'Overwrites worker hostname' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l on-server-lost -d 'The policy when a connection to a server is lost' -r -f -a "stop\t''
finish-running\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l work-dir -d 'Sets the working directory for the worker' -r -F
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l max-parallel-downloads -d 'The maximal parallel downloads for data objects' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l max-download-tries -d 'The maximal data object download tries' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l wait-between-download-tries -d 'The delay between download attempts  Sets how long to wait between failed downloads of data object. This time is multiplied by the number of previous retries. Therefore between 4th and 5th retry it waits 4 * the given duration  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l no-detect-resources -d 'Disables auto-detection of resources'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l no-hyper-threading -d 'Ignores hyper-threading while detecting CPU cores'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from stop" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from stop" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from stop" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from stop" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from stop" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from list" -l filter -d 'Select only workers in the given state' -r -f -a "running\t''
offline\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from list" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from list" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from list" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from list" -l all -d 'Display all workers'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from list" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from hwdetect" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from hwdetect" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from hwdetect" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from hwdetect" -l no-hyper-threading -d 'Detect only physical cores'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from hwdetect" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from hwdetect" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from info" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from info" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from info" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from info" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from address" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from address" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from address" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from address" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from address" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from wait" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from wait" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from wait" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from wait" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from wait" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from deploy-ssh" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from deploy-ssh" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from deploy-ssh" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from deploy-ssh" -l show-output -d 'Show log output of the spawned worker(s)'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from deploy-ssh" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from deploy-ssh" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -l server-uid -d 'Filter files for the given server instance' -r
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -a "summary" -d 'Prints summary of the log file'
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -a "jobs" -d 'Prints job ids in the stream'
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -a "show" -d 'Prints the stream content ordered by time'
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -a "cat" -d 'Prints the content of a stream\'s channel'
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -a "export" -d 'Exports stream into JSON'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from summary" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from summary" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from summary" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from summary" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from summary" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from jobs" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from jobs" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from jobs" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from jobs" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from jobs" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from show" -l job -d 'JobId' -r
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from show" -l channel -d 'Show only the specific channel' -r -f -a "stdout\t''
stderr\t''"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from show" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from show" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from show" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from show" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from show" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from cat" -l task -d 'Prints only outputs of the selected tasks' -r
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from cat" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from cat" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from cat" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from cat" -l allow-unfinished -d 'Allow unfinished channels'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from cat" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from cat" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from export" -l task -d 'Exports only output of the selected tasks' -r
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from export" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from export" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from export" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from export" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from export" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -f -a "list" -d 'Displays allocation queues'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -f -a "info" -d 'Display allocations of the specified allocation queue'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -f -a "add" -d 'Add a new allocation queue'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -f -a "pause" -d 'Pause an existing allocation queue'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -f -a "resume" -d 'Resume a previously paused allocation queue'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -f -a "dry-run" -d 'Try to submit an allocation to test allocation parameters'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -f -a "remove" -d 'Removes an allocation queue with the given ID'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from list" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from list" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from list" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from list" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from info" -l filter -d 'Display only allocations with the given state' -r -f -a "queued\t''
running\t''
finished\t''
failed\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from info" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from info" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from info" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from info" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from add" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from add" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from add" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from add" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from add" -f -a "pbs" -d 'Create a PBS allocation queue'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from add" -f -a "slurm" -d 'Create a SLURM allocation queue'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from pause" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from pause" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from pause" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from pause" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from pause" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from resume" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from resume" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from resume" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from resume" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from resume" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from dry-run" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from dry-run" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from dry-run" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from dry-run" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from dry-run" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from dry-run" -f -a "pbs" -d 'Try to create a PBS allocation'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from dry-run" -f -a "slurm" -d 'Try to create a SLURM allocation'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from remove" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from remove" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from remove" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from remove" -l force -d 'Remove the queue even if there are currently running jobs'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from remove" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -f -a "export" -d 'Export events from a journal file'
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -f -a "stream" -d 'Replays all events from the start of the server, then streams new events'
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -f -a "replay" -d 'Replays all events from the start of the server, then terminate'
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -f -a "prune" -d 'Prune a journal of a running server'
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -f -a "flush" -d 'Forces a running server to flush its journal to the disk'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from export" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from export" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from export" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from export" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from export" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from stream" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from stream" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from stream" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from stream" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from stream" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from replay" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from replay" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from replay" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from replay" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from replay" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from prune" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from prune" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from prune" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from prune" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from prune" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from flush" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from flush" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from flush" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from flush" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from flush" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand data; and not __fish_seen_subcommand_from put get" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand data; and not __fish_seen_subcommand_from put get" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand data; and not __fish_seen_subcommand_from put get" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand data; and not __fish_seen_subcommand_from put get" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand data; and not __fish_seen_subcommand_from put get" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand data; and not __fish_seen_subcommand_from put get" -f -a "put" -d 'Inside a task, put a data object into the local datanode'
complete -c hq -n "__fish_hq_using_subcommand data; and not __fish_seen_subcommand_from put get" -f -a "get" -d 'Inside a task, get an input data object into the local datanode'
complete -c hq -n "__fish_hq_using_subcommand data; and __fish_seen_subcommand_from put" -l mime-type -d 'DataId of task output' -r
complete -c hq -n "__fish_hq_using_subcommand data; and __fish_seen_subcommand_from put" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand data; and __fish_seen_subcommand_from put" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand data; and __fish_seen_subcommand_from put" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand data; and __fish_seen_subcommand_from put" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand data; and __fish_seen_subcommand_from put" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand data; and __fish_seen_subcommand_from get" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand data; and __fish_seen_subcommand_from get" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand data; and __fish_seen_subcommand_from get" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand data; and __fish_seen_subcommand_from get" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand data; and __fish_seen_subcommand_from get" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand dashboard; and not __fish_seen_subcommand_from stream replay" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and not __fish_seen_subcommand_from stream replay" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and not __fish_seen_subcommand_from stream replay" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and not __fish_seen_subcommand_from stream replay" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand dashboard; and not __fish_seen_subcommand_from stream replay" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand dashboard; and not __fish_seen_subcommand_from stream replay" -f -a "stream" -d 'Streams events from a server'
complete -c hq -n "__fish_hq_using_subcommand dashboard; and not __fish_seen_subcommand_from stream replay" -f -a "replay" -d 'Replays events from a journal file'
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from stream" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from stream" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from stream" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from stream" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from stream" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from replay" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from replay" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from replay" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from replay" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from replay" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "job" -d 'Submitting and examining tasks and jobs'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "jobs" -d 'Submitting and examining tasks and jobs'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "tasks" -d 'Submitting and examining tasks and jobs'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "taskarray" -d 'Jobs containing large amounts of similar tasks'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "resources" -d 'CPU and generic resources of tasks'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "worker" -d 'Deployment of workers'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "workers" -d 'Deployment of workers'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "autoalloc" -d 'Automatic allocator subsystem'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "pbs" -d 'Automatic allocator subsystem'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "slurm" -d 'Automatic allocator subsystem'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "python-api" -d 'Python API'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "python" -d 'Python API'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "cheatsheet" -d 'Cheatsheet with the most common HyperQueue commands'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "changelog" -d 'Changelog'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "faq" -d 'Frequently asked questions about HyperQueue'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from job" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from job" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from job" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from job" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from job" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from job" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from jobs" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from jobs" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from jobs" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from jobs" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from jobs" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from jobs" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from tasks" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from tasks" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from tasks" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from tasks" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from tasks" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from tasks" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from taskarray" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from taskarray" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from taskarray" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from taskarray" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from taskarray" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from taskarray" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from resources" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from resources" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from resources" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from resources" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from resources" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from resources" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from worker" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from worker" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from worker" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from worker" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from worker" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from worker" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from workers" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from workers" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from workers" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from workers" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from workers" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from workers" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from autoalloc" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from autoalloc" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from autoalloc" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from autoalloc" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from autoalloc" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from autoalloc" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from pbs" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from pbs" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from pbs" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from pbs" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from pbs" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from pbs" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from slurm" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from slurm" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from slurm" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from slurm" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from slurm" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from slurm" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python-api" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python-api" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python-api" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python-api" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python-api" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python-api" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from cheatsheet" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from cheatsheet" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from cheatsheet" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from cheatsheet" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from cheatsheet" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from cheatsheet" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from changelog" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from changelog" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from changelog" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from changelog" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from changelog" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from changelog" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from faq" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from faq" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from faq" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from faq" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from faq" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from faq" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand generate-completion" -l server-dir -d 'The path where access files are stored' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand generate-completion" -l colors -d 'Sets console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand generate-completion" -l output-mode -d 'Sets output formatting' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand generate-completion" -l debug -d 'Enables more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand generate-completion" -s h -l help -d 'Print help (see more with \'--help\')'
