/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.io.FileInputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.vmplugin.v7.IndyInterface;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.RelativePath;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Pair;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.classpath.InstrumentingBackwardsCompatibilityVisitor;
import org.gradle.internal.hash.Hasher;
import org.gradle.model.internal.asm.MethodVisitorScope;
import org.gradle.process.CommandLineArgumentProvider;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class InstrumentingTransformer
implements CachedClasspathTransformer.Transform {
    private static final int DECORATION_FORMAT = 20;
    private static final Type SYSTEM_TYPE = Type.getType(System.class);
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final Type INTEGER_TYPE = Type.getType(Integer.class);
    private static final Type INSTRUMENTED_TYPE = Type.getType(Instrumented.class);
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final Type SERIALIZED_LAMBDA_TYPE = Type.getType(SerializedLambda.class);
    private static final Type LONG_TYPE = Type.getType(Long.class);
    private static final Type BOOLEAN_TYPE = Type.getType(Boolean.class);
    public static final Type PROPERTIES_TYPE = Type.getType(Properties.class);
    private static final String RETURN_STRING = Type.getMethodDescriptor((Type)STRING_TYPE, (Type[])new Type[0]);
    private static final String RETURN_STRING_FROM_STRING = Type.getMethodDescriptor((Type)STRING_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_STRING_FROM_STRING_STRING = Type.getMethodDescriptor((Type)STRING_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE});
    private static final String RETURN_STRING_FROM_STRING_STRING_STRING = Type.getMethodDescriptor((Type)STRING_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE, STRING_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_INT = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE, Type.INT_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_INTEGER = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE, INTEGER_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_STRING = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_INT_STRING = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE, Type.INT_TYPE, STRING_TYPE});
    private static final String RETURN_INTEGER_FROM_STRING_INTEGER_STRING = Type.getMethodDescriptor((Type)INTEGER_TYPE, (Type[])new Type[]{STRING_TYPE, INTEGER_TYPE, STRING_TYPE});
    private static final String RETURN_LONG_FROM_STRING = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_LONG_FROM_STRING_PRIMITIVE_LONG = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE, Type.LONG_TYPE});
    private static final String RETURN_LONG_FROM_STRING_LONG = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE, LONG_TYPE});
    private static final String RETURN_LONG_FROM_STRING_STRING = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE});
    private static final String RETURN_LONG_FROM_STRING_PRIMITIVE_LONG_STRING = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE, Type.LONG_TYPE, STRING_TYPE});
    private static final String RETURN_LONG_FROM_STRING_LONG_STRING = Type.getMethodDescriptor((Type)LONG_TYPE, (Type[])new Type[]{STRING_TYPE, LONG_TYPE, STRING_TYPE});
    private static final String RETURN_PRIMITIVE_BOOLEAN_FROM_STRING = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_PRIMITIVE_BOOLEAN_FROM_STRING_STRING = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE});
    private static final String RETURN_OBJECT_FROM_INT = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{Type.INT_TYPE});
    private static final String RETURN_BOOLEAN_FROM_OBJECT = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{OBJECT_TYPE});
    private static final String RETURN_PROPERTIES = Type.getMethodDescriptor((Type)PROPERTIES_TYPE, (Type[])new Type[0]);
    private static final String RETURN_PROPERTIES_FROM_STRING = Type.getMethodDescriptor((Type)PROPERTIES_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_VOID_FROM_PROPERTIES = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{PROPERTIES_TYPE});
    private static final String RETURN_VOID_FROM_PROPERTIES_STRING = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{PROPERTIES_TYPE, STRING_TYPE});
    private static final String RETURN_CALL_SITE_ARRAY = Type.getMethodDescriptor((Type)Type.getType(CallSiteArray.class), (Type[])new Type[0]);
    private static final String RETURN_VOID_FROM_CALL_SITE_ARRAY = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(CallSiteArray.class)});
    private static final String RETURN_OBJECT_FROM_SERIALIZED_LAMBDA = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{SERIALIZED_LAMBDA_TYPE});
    private static final String RETURN_MAP = Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]);
    private static final String RETURN_MAP_FROM_STRING = Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[]{STRING_TYPE});
    private static final Type PROCESS_TYPE = Type.getType(Process.class);
    private static final Type PROCESS_BUILDER_TYPE = Type.getType(ProcessBuilder.class);
    private static final Type RUNTIME_TYPE = Type.getType(Runtime.class);
    private static final Type PROCESS_GROOVY_METHODS_TYPE = Type.getType(ProcessGroovyMethods.class);
    private static final Type STRING_ARRAY_TYPE = Type.getType(String[].class);
    private static final Type FILE_TYPE = Type.getType(File.class);
    private static final Type LIST_TYPE = Type.getType(List.class);
    private static final String RETURN_PROCESS = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[0]);
    private static final String RETURN_PROCESS_FROM_PROCESS_BUILDER_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{PROCESS_BUILDER_TYPE, STRING_TYPE});
    private static final String RETURN_LIST_FROM_LIST = Type.getMethodDescriptor((Type)LIST_TYPE, (Type[])new Type[]{LIST_TYPE});
    private static final String RETURN_LIST_FROM_LIST_STRING = Type.getMethodDescriptor((Type)LIST_TYPE, (Type[])new Type[]{LIST_TYPE, STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_RUNTIME_STRING_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{RUNTIME_TYPE, STRING_TYPE, STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_ARRAY = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_ARRAY_TYPE});
    private static final String RETURN_PROCESS_FROM_RUNTIME_STRING_ARRAY_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{RUNTIME_TYPE, STRING_ARRAY_TYPE, STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_ARRAY_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_ARRAY_TYPE, STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_LIST = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{LIST_TYPE});
    private static final String RETURN_PROCESS_FROM_LIST_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{LIST_TYPE, STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_STRING_ARRAY = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_ARRAY_TYPE});
    private static final String RETURN_PROCESS_FROM_RUNTIME_STRING_STRING_ARRAY_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{RUNTIME_TYPE, STRING_TYPE, STRING_ARRAY_TYPE, STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_ARRAY_STRING_ARRAY = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_ARRAY_TYPE, STRING_ARRAY_TYPE});
    private static final String RETURN_PROCESS_FROM_RUNTIME_STRING_ARRAY_STRING_ARRAY_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{RUNTIME_TYPE, STRING_ARRAY_TYPE, STRING_ARRAY_TYPE, STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_STRING_ARRAY_FILE = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_ARRAY_TYPE, FILE_TYPE});
    private static final String RETURN_PROCESS_FROM_RUNTIME_STRING_STRING_ARRAY_FILE_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{RUNTIME_TYPE, STRING_TYPE, STRING_ARRAY_TYPE, FILE_TYPE, STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_STRING_ARRAY_FILE_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_ARRAY_TYPE, FILE_TYPE, STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_ARRAY_STRING_ARRAY_FILE = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_ARRAY_TYPE, STRING_ARRAY_TYPE, FILE_TYPE});
    private static final String RETURN_PROCESS_FROM_RUNTIME_STRING_ARRAY_STRING_ARRAY_FILE_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{RUNTIME_TYPE, STRING_ARRAY_TYPE, STRING_ARRAY_TYPE, FILE_TYPE, STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_ARRAY_STRING_ARRAY_FILE_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_ARRAY_TYPE, STRING_ARRAY_TYPE, FILE_TYPE, STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_LIST_STRING_ARRAY_FILE = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{LIST_TYPE, STRING_ARRAY_TYPE, FILE_TYPE});
    private static final String RETURN_PROCESS_FROM_LIST_STRING_ARRAY_FILE_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{LIST_TYPE, STRING_ARRAY_TYPE, FILE_TYPE, STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_LIST_FILE = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_TYPE, LIST_TYPE, FILE_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_LIST_FILE_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_TYPE, LIST_TYPE, FILE_TYPE, STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_ARRAY_LIST_FILE = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_ARRAY_TYPE, LIST_TYPE, FILE_TYPE});
    private static final String RETURN_PROCESS_FROM_STRING_ARRAY_LIST_FILE_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{STRING_ARRAY_TYPE, LIST_TYPE, FILE_TYPE, STRING_TYPE});
    private static final String RETURN_PROCESS_FROM_LIST_LIST_FILE = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{LIST_TYPE, LIST_TYPE, FILE_TYPE});
    private static final String RETURN_PROCESS_FROM_LIST_LIST_FILE_STRING = Type.getMethodDescriptor((Type)PROCESS_TYPE, (Type[])new Type[]{LIST_TYPE, LIST_TYPE, FILE_TYPE, STRING_TYPE});
    private static final Type FILE_INPUT_STREAM_TYPE = Type.getType(FileInputStream.class);
    private static final String RETURN_VOID_FROM_FILE = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{FILE_TYPE});
    private static final String RETURN_VOID_FROM_FILE_STRING = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{FILE_TYPE, STRING_TYPE});
    private static final String RETURN_VOID_FROM_STRING = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{STRING_TYPE});
    private static final String RETURN_VOID_FROM_STRING_STRING = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{STRING_TYPE, STRING_TYPE});
    private static final String LAMBDA_METAFACTORY_TYPE = Type.getType(LambdaMetafactory.class).getInternalName();
    private static final String LAMBDA_METAFACTORY_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(CallSite.class), (Type[])new Type[]{Type.getType(MethodHandles.Lookup.class), STRING_TYPE, Type.getType(MethodType.class), Type.getType(Object[].class)});
    private static final String GROOVY_INDY_INTERFACE_TYPE = Type.getType(org.codehaus.groovy.vmplugin.v8.IndyInterface.class).getInternalName();
    private static final String GROOVY_INDY_INTERFACE_V7_TYPE = Type.getType(IndyInterface.class).getInternalName();
    private static final String GROOVY_INDY_INTERFACE_BOOTSTRAP_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(CallSite.class), (Type[])new Type[]{Type.getType(MethodHandles.Lookup.class), STRING_TYPE, Type.getType(MethodType.class), STRING_TYPE, Type.INT_TYPE});
    private static final String INSTRUMENTED_CALL_SITE_METHOD = "$instrumentedCallSiteArray";
    private static final String CREATE_CALL_SITE_ARRAY_METHOD = "$createCallSiteArray";
    private static final String DESERIALIZE_LAMBDA = "$deserializeLambda$";
    private static final String RENAMED_DESERIALIZE_LAMBDA = "$renamedDeserializeLambda$";
    private static final String[] NO_EXCEPTIONS = new String[0];

    InstrumentingTransformer() {
    }

    @Override
    public void applyConfigurationTo(Hasher hasher) {
        hasher.putString((CharSequence)InstrumentingTransformer.class.getSimpleName());
        hasher.putInt(20);
    }

    @Override
    public Pair<RelativePath, ClassVisitor> apply(ClasspathEntryVisitor.Entry entry, ClassVisitor visitor) {
        return Pair.of((Object)entry.getPath(), (Object)((Object)new InstrumentingVisitor(new InstrumentingBackwardsCompatibilityVisitor(visitor))));
    }

    private static class LambdaFactoryDetails {
        final String name;
        final String descriptor;
        final Handle bootstrapMethodHandle;
        final List<?> bootstrapMethodArguments;

        public LambdaFactoryDetails(String name, String descriptor, Handle bootstrapMethodHandle, List<?> bootstrapMethodArguments) {
            this.name = name;
            this.descriptor = descriptor;
            this.bootstrapMethodHandle = bootstrapMethodHandle;
            this.bootstrapMethodArguments = bootstrapMethodArguments;
        }
    }

    private static class InstrumentingMethodVisitor
    extends MethodVisitorScope {
        private final InstrumentingVisitor owner;
        private final String className;
        private static final String ACTION_LAMBDA_SUFFIX = ")" + Type.getType(Action.class).getDescriptor();
        private static final String SPEC_LAMBDA_SUFFIX = ")" + Type.getType(Spec.class).getDescriptor();
        private static final String TRANSFORMER_LAMBDA_SUFFIX = ")" + Type.getType(Transformer.class).getDescriptor();
        private static final String COMMAND_LINE_ARGUMENT_PROVIDER_LAMBDA_SUFFIX = ")" + Type.getType(CommandLineArgumentProvider.class).getDescriptor();

        public InstrumentingMethodVisitor(InstrumentingVisitor owner, MethodVisitor methodVisitor) {
            super(methodVisitor);
            this.owner = owner;
            this.className = owner.className;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (opcode == 184 && this.visitINVOKESTATIC(owner, name, descriptor)) {
                return;
            }
            if (opcode == 182 && this.visitINVOKEVIRTUAL(owner, name, descriptor)) {
                return;
            }
            if (opcode == 183 && this.visitINVOKESPECIAL(owner, name, descriptor)) {
                return;
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        private boolean visitINVOKESTATIC(String owner, String name, String descriptor) {
            if (owner.equals(SYSTEM_TYPE.getInternalName())) {
                if (name.equals("getProperty")) {
                    if (descriptor.equals(RETURN_STRING_FROM_STRING)) {
                        this._LDC(this.binaryClassNameOf(this.className));
                        this._INVOKESTATIC(INSTRUMENTED_TYPE, "systemProperty", RETURN_STRING_FROM_STRING_STRING);
                        return true;
                    }
                    if (descriptor.equals(RETURN_STRING_FROM_STRING_STRING)) {
                        this._LDC(this.binaryClassNameOf(this.className));
                        this._INVOKESTATIC(INSTRUMENTED_TYPE, "systemProperty", RETURN_STRING_FROM_STRING_STRING_STRING);
                        return true;
                    }
                } else {
                    if (name.equals("getProperties") && descriptor.equals(RETURN_PROPERTIES)) {
                        this._LDC(this.binaryClassNameOf(this.className));
                        this._INVOKESTATIC(INSTRUMENTED_TYPE, "systemProperties", RETURN_PROPERTIES_FROM_STRING);
                        return true;
                    }
                    if (name.equals("setProperties") && descriptor.equals(RETURN_VOID_FROM_PROPERTIES)) {
                        this._LDC(this.binaryClassNameOf(this.className));
                        this._INVOKESTATIC(INSTRUMENTED_TYPE, "setSystemProperties", RETURN_VOID_FROM_PROPERTIES_STRING);
                        return true;
                    }
                    if (name.equals("setProperty") && descriptor.equals(RETURN_STRING_FROM_STRING_STRING)) {
                        this._LDC(this.binaryClassNameOf(this.className));
                        this._INVOKESTATIC(INSTRUMENTED_TYPE, "setSystemProperty", RETURN_STRING_FROM_STRING_STRING_STRING);
                        return true;
                    }
                    if (name.equals("clearProperty") && descriptor.equals(RETURN_STRING_FROM_STRING)) {
                        this._LDC(this.binaryClassNameOf(this.className));
                        this._INVOKESTATIC(INSTRUMENTED_TYPE, "clearSystemProperty", RETURN_STRING_FROM_STRING_STRING);
                        return true;
                    }
                    if (name.equals("getenv")) {
                        if (descriptor.equals(RETURN_STRING_FROM_STRING)) {
                            this._LDC(this.binaryClassNameOf(this.className));
                            this._INVOKESTATIC(INSTRUMENTED_TYPE, "getenv", RETURN_STRING_FROM_STRING_STRING);
                            return true;
                        }
                        if (descriptor.equals(RETURN_MAP)) {
                            this._LDC(this.binaryClassNameOf(this.className));
                            this._INVOKESTATIC(INSTRUMENTED_TYPE, "getenv", RETURN_MAP_FROM_STRING);
                            return true;
                        }
                    }
                }
            } else if (owner.equals(INTEGER_TYPE.getInternalName()) && name.equals("getInteger")) {
                if (descriptor.equals(RETURN_INTEGER_FROM_STRING)) {
                    this._LDC(this.binaryClassNameOf(this.className));
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "getInteger", RETURN_INTEGER_FROM_STRING_STRING);
                    return true;
                }
                if (descriptor.equals(RETURN_INTEGER_FROM_STRING_INT)) {
                    this._LDC(this.binaryClassNameOf(this.className));
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "getInteger", RETURN_INTEGER_FROM_STRING_INT_STRING);
                    return true;
                }
                if (descriptor.equals(RETURN_INTEGER_FROM_STRING_INTEGER)) {
                    this._LDC(this.binaryClassNameOf(this.className));
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "getInteger", RETURN_INTEGER_FROM_STRING_INTEGER_STRING);
                    return true;
                }
            } else if (owner.equals(LONG_TYPE.getInternalName()) && name.equals("getLong")) {
                if (descriptor.equals(RETURN_LONG_FROM_STRING)) {
                    this._LDC(this.binaryClassNameOf(this.className));
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "getLong", RETURN_LONG_FROM_STRING_STRING);
                    return true;
                }
                if (descriptor.equals(RETURN_LONG_FROM_STRING_PRIMITIVE_LONG)) {
                    this._LDC(this.binaryClassNameOf(this.className));
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "getLong", RETURN_LONG_FROM_STRING_PRIMITIVE_LONG_STRING);
                    return true;
                }
                if (descriptor.equals(RETURN_LONG_FROM_STRING_LONG)) {
                    this._LDC(this.binaryClassNameOf(this.className));
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "getLong", RETURN_LONG_FROM_STRING_LONG_STRING);
                    return true;
                }
            } else {
                if (owner.equals(BOOLEAN_TYPE.getInternalName()) && name.equals("getBoolean") && descriptor.equals(RETURN_PRIMITIVE_BOOLEAN_FROM_STRING)) {
                    this._LDC(this.binaryClassNameOf(this.className));
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "getBoolean", RETURN_PRIMITIVE_BOOLEAN_FROM_STRING_STRING);
                    return true;
                }
                if (owner.equals(PROCESS_GROOVY_METHODS_TYPE.getInternalName()) && name.equals("execute")) {
                    Optional<String> instrumentedDescriptor = this.getInstrumentedDescriptorForProcessGroovyMethodsExecuteDescriptor(descriptor);
                    if (!instrumentedDescriptor.isPresent()) {
                        return false;
                    }
                    this._LDC(this.binaryClassNameOf(this.className));
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "execute", instrumentedDescriptor.get());
                    return true;
                }
            }
            if (owner.equals(PROCESS_BUILDER_TYPE.getInternalName()) && name.equals("startPipeline") && descriptor.equals(RETURN_LIST_FROM_LIST)) {
                this._LDC(this.binaryClassNameOf(this.className));
                this._INVOKESTATIC(INSTRUMENTED_TYPE, "startPipeline", RETURN_LIST_FROM_LIST_STRING);
                return true;
            }
            if (owner.equals(this.className) && name.equals(InstrumentingTransformer.CREATE_CALL_SITE_ARRAY_METHOD) && descriptor.equals(RETURN_CALL_SITE_ARRAY)) {
                this._INVOKESTATIC(this.className, InstrumentingTransformer.INSTRUMENTED_CALL_SITE_METHOD, RETURN_CALL_SITE_ARRAY);
                return true;
            }
            return false;
        }

        private boolean visitINVOKEVIRTUAL(String owner, String name, String descriptor) {
            if (owner.equals(RUNTIME_TYPE.getInternalName()) && name.equals("exec")) {
                Optional<String> instrumentedDescriptor = this.getInstrumentedDescriptorForRuntimeExecDescriptor(descriptor);
                if (!instrumentedDescriptor.isPresent()) {
                    return false;
                }
                this._LDC(this.binaryClassNameOf(this.className));
                this._INVOKESTATIC(INSTRUMENTED_TYPE, "exec", instrumentedDescriptor.get());
                return true;
            }
            if (owner.equals(PROCESS_BUILDER_TYPE.getInternalName()) && name.equals("start") && descriptor.equals(RETURN_PROCESS)) {
                this._LDC(this.binaryClassNameOf(this.className));
                this._INVOKESTATIC(INSTRUMENTED_TYPE, "start", RETURN_PROCESS_FROM_PROCESS_BUILDER_STRING);
                return true;
            }
            return false;
        }

        private Optional<String> getInstrumentedDescriptorForProcessGroovyMethodsExecuteDescriptor(String descriptor) {
            if (descriptor.equals(RETURN_PROCESS_FROM_STRING)) {
                return Optional.of(RETURN_PROCESS_FROM_STRING_STRING);
            }
            if (descriptor.equals(RETURN_PROCESS_FROM_STRING_ARRAY)) {
                return Optional.of(RETURN_PROCESS_FROM_STRING_ARRAY_STRING);
            }
            if (descriptor.equals(RETURN_PROCESS_FROM_LIST)) {
                return Optional.of(RETURN_PROCESS_FROM_LIST_STRING);
            }
            if (descriptor.equals(RETURN_PROCESS_FROM_STRING_STRING_ARRAY_FILE)) {
                return Optional.of(RETURN_PROCESS_FROM_STRING_STRING_ARRAY_FILE_STRING);
            }
            if (descriptor.equals(RETURN_PROCESS_FROM_STRING_ARRAY_STRING_ARRAY_FILE)) {
                return Optional.of(RETURN_PROCESS_FROM_STRING_ARRAY_STRING_ARRAY_FILE_STRING);
            }
            if (descriptor.equals(RETURN_PROCESS_FROM_LIST_STRING_ARRAY_FILE)) {
                return Optional.of(RETURN_PROCESS_FROM_LIST_STRING_ARRAY_FILE_STRING);
            }
            if (descriptor.equals(RETURN_PROCESS_FROM_STRING_LIST_FILE)) {
                return Optional.of(RETURN_PROCESS_FROM_STRING_LIST_FILE_STRING);
            }
            if (descriptor.equals(RETURN_PROCESS_FROM_STRING_ARRAY_LIST_FILE)) {
                return Optional.of(RETURN_PROCESS_FROM_STRING_ARRAY_LIST_FILE_STRING);
            }
            if (descriptor.equals(RETURN_PROCESS_FROM_LIST_LIST_FILE)) {
                return Optional.of(RETURN_PROCESS_FROM_LIST_LIST_FILE_STRING);
            }
            return Optional.empty();
        }

        private Optional<String> getInstrumentedDescriptorForRuntimeExecDescriptor(String descriptor) {
            if (descriptor.equals(RETURN_PROCESS_FROM_STRING)) {
                return Optional.of(RETURN_PROCESS_FROM_RUNTIME_STRING_STRING);
            }
            if (descriptor.equals(RETURN_PROCESS_FROM_STRING_ARRAY)) {
                return Optional.of(RETURN_PROCESS_FROM_RUNTIME_STRING_ARRAY_STRING);
            }
            if (descriptor.equals(RETURN_PROCESS_FROM_STRING_STRING_ARRAY)) {
                return Optional.of(RETURN_PROCESS_FROM_RUNTIME_STRING_STRING_ARRAY_STRING);
            }
            if (descriptor.equals(RETURN_PROCESS_FROM_STRING_ARRAY_STRING_ARRAY)) {
                return Optional.of(RETURN_PROCESS_FROM_RUNTIME_STRING_ARRAY_STRING_ARRAY_STRING);
            }
            if (descriptor.equals(RETURN_PROCESS_FROM_STRING_STRING_ARRAY_FILE)) {
                return Optional.of(RETURN_PROCESS_FROM_RUNTIME_STRING_STRING_ARRAY_FILE_STRING);
            }
            if (descriptor.equals(RETURN_PROCESS_FROM_STRING_ARRAY_STRING_ARRAY_FILE)) {
                return Optional.of(RETURN_PROCESS_FROM_RUNTIME_STRING_ARRAY_STRING_ARRAY_FILE_STRING);
            }
            return Optional.empty();
        }

        private boolean visitINVOKESPECIAL(String owner, String name, String descriptor) {
            Optional<String> instrumentedDescriptor;
            if (owner.equals(FILE_INPUT_STREAM_TYPE.getInternalName()) && name.equals("<init>") && (instrumentedDescriptor = this.getInstrumentedDescriptorForFileInputStreamConstructor(descriptor)).isPresent()) {
                this._DUP();
                this._LDC(this.binaryClassNameOf(this.className));
                this._INVOKESTATIC(INSTRUMENTED_TYPE, "fileOpened", instrumentedDescriptor.get());
                this._INVOKESPECIAL(owner, name, descriptor);
                return true;
            }
            return false;
        }

        private Optional<String> getInstrumentedDescriptorForFileInputStreamConstructor(String descriptor) {
            if (descriptor.equals(RETURN_VOID_FROM_FILE)) {
                return Optional.of(RETURN_VOID_FROM_FILE_STRING);
            }
            if (descriptor.equals(RETURN_VOID_FROM_STRING)) {
                return Optional.of(RETURN_VOID_FROM_STRING_STRING);
            }
            return Optional.empty();
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            if (this.isGradleLambdaDescriptor(descriptor) && bootstrapMethodHandle.getOwner().equals(LAMBDA_METAFACTORY_TYPE) && bootstrapMethodHandle.getName().equals("metafactory")) {
                Handle altMethod = new Handle(6, LAMBDA_METAFACTORY_TYPE, "altMetafactory", LAMBDA_METAFACTORY_METHOD_DESCRIPTOR, false);
                ArrayList<Integer> args = new ArrayList<Integer>(bootstrapMethodArguments.length + 1);
                Collections.addAll(args, bootstrapMethodArguments);
                args.add(1);
                super.visitInvokeDynamicInsn(name, descriptor, altMethod, args.toArray());
                this.owner.addSerializedLambda(new LambdaFactoryDetails(name, descriptor, altMethod, args));
            } else if (this.isGroovyIndyCallsite(descriptor, bootstrapMethodHandle)) {
                Handle interceptor = new Handle(6, INSTRUMENTED_TYPE.getInternalName(), "bootstrap", GROOVY_INDY_INTERFACE_BOOTSTRAP_METHOD_DESCRIPTOR, false);
                super.visitInvokeDynamicInsn(name, descriptor, interceptor, bootstrapMethodArguments);
            } else {
                super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            }
        }

        private boolean isGradleLambdaDescriptor(String descriptor) {
            return descriptor.endsWith(ACTION_LAMBDA_SUFFIX) || descriptor.endsWith(SPEC_LAMBDA_SUFFIX) || descriptor.endsWith(TRANSFORMER_LAMBDA_SUFFIX) || descriptor.endsWith(COMMAND_LINE_ARGUMENT_PROVIDER_LAMBDA_SUFFIX);
        }

        private String binaryClassNameOf(String className) {
            return Type.getObjectType((String)className).getClassName();
        }

        private boolean isGroovyIndyCallsite(String descriptor, Handle bootstrapMethodHandle) {
            return (bootstrapMethodHandle.getOwner().equals(GROOVY_INDY_INTERFACE_TYPE) || bootstrapMethodHandle.getOwner().equals(GROOVY_INDY_INTERFACE_V7_TYPE)) && bootstrapMethodHandle.getName().equals("bootstrap") && bootstrapMethodHandle.getDesc().equals(GROOVY_INDY_INTERFACE_BOOTSTRAP_METHOD_DESCRIPTOR);
        }
    }

    private static class InstrumentingVisitor
    extends ClassVisitor {
        String className;
        private final List<LambdaFactoryDetails> lambdaFactories = new ArrayList<LambdaFactoryDetails>();
        private boolean hasGroovyCallSites;
        private boolean hasDeserializeLambda;
        private boolean isInterface;

        public InstrumentingVisitor(ClassVisitor visitor) {
            super(589824, visitor);
        }

        public void addSerializedLambda(LambdaFactoryDetails lambdaFactoryDetails) {
            this.lambdaFactories.add(lambdaFactoryDetails);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
            this.isInterface = (access & 0x200) != 0;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (name.equals(InstrumentingTransformer.CREATE_CALL_SITE_ARRAY_METHOD) && descriptor.equals(RETURN_CALL_SITE_ARRAY)) {
                this.hasGroovyCallSites = true;
            } else if (name.equals(InstrumentingTransformer.DESERIALIZE_LAMBDA) && descriptor.equals(RETURN_OBJECT_FROM_SERIALIZED_LAMBDA)) {
                this.hasDeserializeLambda = true;
                return super.visitMethod(access, InstrumentingTransformer.RENAMED_DESERIALIZE_LAMBDA, descriptor, signature, exceptions);
            }
            MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
            return new InstrumentingMethodVisitor(this, methodVisitor);
        }

        public void visitEnd() {
            if (this.hasGroovyCallSites) {
                this.generateCallSiteFactoryMethod();
            }
            if (!this.lambdaFactories.isEmpty() || this.hasDeserializeLambda) {
                this.generateLambdaDeserializeMethod();
            }
            super.visitEnd();
        }

        private void generateLambdaDeserializeMethod() {
            new MethodVisitorScope(this.visitStaticPrivateMethod(InstrumentingTransformer.DESERIALIZE_LAMBDA, RETURN_OBJECT_FROM_SERIALIZED_LAMBDA)){
                {
                    super(arg0);
                    Label next = null;
                    for (LambdaFactoryDetails factory : lambdaFactories) {
                        if (next != null) {
                            this.visitLabel(next);
                            this._F_SAME();
                        }
                        next = new Label();
                        this._ALOAD(0);
                        this._INVOKEVIRTUAL(SERIALIZED_LAMBDA_TYPE, "getImplMethodName", RETURN_STRING);
                        this._LDC(((Handle)factory.bootstrapMethodArguments.get(1)).getName());
                        this._INVOKEVIRTUAL(OBJECT_TYPE, "equals", RETURN_BOOLEAN_FROM_OBJECT);
                        this._IFEQ(next);
                        Type[] argumentTypes = Type.getArgumentTypes((String)factory.descriptor);
                        for (int i = 0; i < argumentTypes.length; ++i) {
                            this._ALOAD(0);
                            this._LDC(i);
                            this._INVOKEVIRTUAL(SERIALIZED_LAMBDA_TYPE, "getCapturedArg", RETURN_OBJECT_FROM_INT);
                            this._UNBOX(argumentTypes[i]);
                        }
                        this._INVOKEDYNAMIC(factory.name, factory.descriptor, factory.bootstrapMethodHandle, factory.bootstrapMethodArguments);
                        this._ARETURN();
                    }
                    if (next != null) {
                        this.visitLabel(next);
                        this._F_SAME();
                    }
                    if (hasDeserializeLambda) {
                        this._ALOAD(0);
                        this._INVOKESTATIC(className, InstrumentingTransformer.RENAMED_DESERIALIZE_LAMBDA, RETURN_OBJECT_FROM_SERIALIZED_LAMBDA, isInterface);
                    } else {
                        this._ACONST_NULL();
                    }
                    this._ARETURN();
                    this.visitMaxs(0, 0);
                    this.visitEnd();
                }
            };
        }

        private void generateCallSiteFactoryMethod() {
            new MethodVisitorScope(this.visitStaticPrivateMethod(InstrumentingTransformer.INSTRUMENTED_CALL_SITE_METHOD, RETURN_CALL_SITE_ARRAY)){
                {
                    super(arg0);
                    this._INVOKESTATIC(className, InstrumentingTransformer.CREATE_CALL_SITE_ARRAY_METHOD, RETURN_CALL_SITE_ARRAY);
                    this._DUP();
                    this._INVOKESTATIC(INSTRUMENTED_TYPE, "groovyCallSites", RETURN_VOID_FROM_CALL_SITE_ARRAY);
                    this._ARETURN();
                    this.visitMaxs(2, 0);
                    this.visitEnd();
                }
            };
        }

        private MethodVisitor visitStaticPrivateMethod(String name, String descriptor) {
            return super.visitMethod(4106, name, descriptor, null, NO_EXCEPTIONS);
        }
    }
}

