/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.groovy.scripts.TextResourceScriptSource;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.DependenciesAccessors;
import org.gradle.internal.management.DependencyResolutionManagementInternal;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.TextFileResourceLoader;
import org.gradle.internal.resource.TextResource;
import org.gradle.util.internal.NameValidator;

public class ProjectFactory
implements IProjectFactory {
    private final Instantiator instantiator;
    private final TextFileResourceLoader textFileResourceLoader;

    public ProjectFactory(Instantiator instantiator, TextFileResourceLoader textFileResourceLoader) {
        this.instantiator = instantiator;
        this.textFileResourceLoader = textFileResourceLoader;
    }

    @Override
    public ProjectInternal createProject(GradleInternal gradle, ProjectDescriptor projectDescriptor, ProjectState owner, @Nullable ProjectInternal parent, ClassLoaderScope selfClassLoaderScope, ClassLoaderScope baseClassLoaderScope) {
        File buildFile = projectDescriptor.getBuildFile();
        TextResource resource = this.textFileResourceLoader.loadFile("build file", buildFile);
        TextResourceScriptSource source = new TextResourceScriptSource(resource);
        DefaultProject project = (DefaultProject)this.instantiator.newInstance(DefaultProject.class, new Object[]{projectDescriptor.getName(), parent, projectDescriptor.getProjectDir(), buildFile, source, gradle, owner, gradle.getServiceRegistryFactory(), selfClassLoaderScope, baseClassLoaderScope});
        project.beforeEvaluate((Action<? super Project>)((Action)p -> {
            NameValidator.validate(project.getName(), "project name", DefaultProjectDescriptor.INVALID_NAME_IN_INCLUDE_HINT);
            ((DependenciesAccessors)gradle.getServices().get(DependenciesAccessors.class)).createExtensions(project);
            ((DependencyResolutionManagementInternal)gradle.getServices().get(DependencyResolutionManagementInternal.class)).configureProject(project);
        }));
        gradle.getProjectRegistry().addProject(project);
        return project;
    }
}

