/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.archive.AbstractArchiveFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.ResourceException;
import org.gradle.api.resources.internal.ReadableResourceInternal;
import org.gradle.internal.IoActions;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.util.internal.GFileUtils;
import org.gradle.util.internal.PathTraversalChecker;

public class TarFileTree
extends AbstractArchiveFileTree {
    private final Provider<File> tarFileProvider;
    private final Provider<ReadableResourceInternal> resource;
    private final Chmod chmod;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final File tmpDir;
    private final StreamHasher streamHasher;
    private final FileHasher fileHasher;

    public TarFileTree(Provider<File> tarFileProvider, Provider<ReadableResourceInternal> resource, File tmpDir, Chmod chmod, DirectoryFileTreeFactory directoryFileTreeFactory, StreamHasher streamHasher, FileHasher fileHasher) {
        this.tarFileProvider = tarFileProvider;
        this.resource = resource;
        this.chmod = chmod;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.tmpDir = tmpDir;
        this.streamHasher = streamHasher;
        this.fileHasher = fileHasher;
    }

    public String getDisplayName() {
        return String.format("TAR '%s'", ((ReadableResourceInternal)this.resource.get()).getDisplayName());
    }

    public DirectoryFileTree getMirror() {
        return this.directoryFileTreeFactory.create(this.getExpandedDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(FileVisitor visitor) {
        BufferedInputStream inputStream;
        try {
            inputStream = new BufferedInputStream(((ReadableResourceInternal)this.resource.get()).read());
        }
        catch (ResourceException e) {
            throw this.cannotExpand((Exception)((Object)e));
        }
        try {
            try {
                this.visitImpl(visitor, inputStream);
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
        catch (Exception e) {
            String message = "Unable to expand " + this.getDisplayName() + "\n  The tar might be corrupted or it is compressed in an unexpected way.\n  By default the tar tree tries to guess the compression based on the file extension.\n  If you need to specify the compression explicitly please refer to the DSL reference.";
            throw new GradleException(message, (Throwable)e);
        }
    }

    private void visitImpl(FileVisitor visitor, InputStream inputStream) throws IOException {
        TarEntry entry;
        AtomicBoolean stopFlag = new AtomicBoolean();
        NoCloseTarInputStream tar = new NoCloseTarInputStream(inputStream);
        File expandedDir = this.getExpandedDir();
        ReadableResourceInternal resource = (ReadableResourceInternal)this.resource.get();
        while (!stopFlag.get() && (entry = tar.getNextEntry()) != null) {
            if (entry.isDirectory()) {
                visitor.visitDir((FileVisitDetails)new DetailsImpl(resource, expandedDir, entry, tar, stopFlag, this.chmod));
                continue;
            }
            visitor.visitFile((FileVisitDetails)new DetailsImpl(resource, expandedDir, entry, tar, stopFlag, this.chmod));
        }
    }

    @Override
    public Provider<File> getBackingFileProvider() {
        return this.tarFileProvider.orElse(this.resource.map(ReadableResourceInternal::getBackingFile));
    }

    private File getExpandedDir() {
        File tarFile = (File)this.tarFileProvider.getOrNull();
        ReadableResourceInternal resource = (ReadableResourceInternal)this.resource.getOrNull();
        HashCode fileHash = tarFile != null ? this.hashFile(tarFile) : this.hashResource(resource);
        String expandedDirName = resource.getBaseName() + "_" + fileHash;
        return new File(this.tmpDir, expandedDirName);
    }

    private HashCode hashFile(File tarFile) {
        try {
            return this.fileHasher.hash(tarFile);
        }
        catch (Exception e) {
            throw this.cannotExpand(e);
        }
    }

    private HashCode hashResource(ReadableResourceInternal resource) {
        HashCode hashCode;
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(resource.read());
            hashCode = this.streamHasher.hash((InputStream)inputStream);
        }
        catch (ResourceException e) {
            try {
                throw this.cannotExpand((Exception)((Object)e));
            }
            catch (Throwable throwable) {
                IoActions.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IoActions.closeQuietly((Closeable)inputStream);
        return hashCode;
    }

    private RuntimeException cannotExpand(Exception e) {
        throw new InvalidUserDataException(String.format("Cannot expand %s.", this.getDisplayName()), (Throwable)e);
    }

    private static class NoCloseTarInputStream
    extends TarInputStream {
        public NoCloseTarInputStream(InputStream is) {
            super(is);
        }

        public void close() throws IOException {
        }

        public TarEntry getCurrent() {
            return this.currEntry;
        }
    }

    private static class DetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final TarEntry entry;
        private final NoCloseTarInputStream tar;
        private final AtomicBoolean stopFlag;
        private final ReadableResourceInternal resource;
        private final File expandedDir;
        private File file;
        private boolean read;

        public DetailsImpl(ReadableResourceInternal resource, File expandedDir, TarEntry entry, NoCloseTarInputStream tar, AtomicBoolean stopFlag, Chmod chmod) {
            super(chmod);
            this.resource = resource;
            this.expandedDir = expandedDir;
            this.entry = entry;
            this.tar = tar;
            this.stopFlag = stopFlag;
        }

        public String getDisplayName() {
            return String.format("tar entry %s!%s", this.resource.getDisplayName(), this.entry.getName());
        }

        public void stopVisiting() {
            this.stopFlag.set(true);
        }

        public File getFile() {
            if (this.file == null) {
                this.file = new File(this.expandedDir, this.safeEntryName());
                if (!this.file.exists()) {
                    this.copyTo(this.file);
                }
            }
            return this.file;
        }

        public long getLastModified() {
            return this.entry.getModTime().getTime();
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        public long getSize() {
            return this.entry.getSize();
        }

        public InputStream open() {
            if (this.read && this.file != null) {
                return GFileUtils.openInputStream((File)this.file);
            }
            if (this.read || this.tar.getCurrent() != this.entry) {
                throw new UnsupportedOperationException(String.format("The contents of %s has already been read.", new Object[]{this}));
            }
            this.read = true;
            return this.tar;
        }

        public RelativePath getRelativePath() {
            return new RelativePath(!this.entry.isDirectory(), this.safeEntryName().split("/"));
        }

        public int getMode() {
            return this.entry.getMode() & 0x1FF;
        }

        private String safeEntryName() {
            return PathTraversalChecker.safePathName((String)this.entry.getName());
        }
    }
}

