/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.test.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.properties.InputFilePropertyType;
import org.gradle.api.internal.tasks.properties.OutputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestFrameworkOptions;
import org.gradle.api.tasks.testing.junitplatform.JUnitPlatformOptions;
import org.gradle.internal.enterprise.test.CandidateClassFile;
import org.gradle.internal.enterprise.test.InputFileProperty;
import org.gradle.internal.enterprise.test.OutputFileProperty;
import org.gradle.internal.enterprise.test.TestTaskFilters;
import org.gradle.internal.enterprise.test.TestTaskForkOptions;
import org.gradle.internal.enterprise.test.TestTaskProperties;
import org.gradle.internal.enterprise.test.TestTaskPropertiesService;
import org.gradle.internal.enterprise.test.impl.DefaultCandidateClassFile;
import org.gradle.internal.enterprise.test.impl.DefaultInputFileProperty;
import org.gradle.internal.enterprise.test.impl.DefaultOutputFileProperty;
import org.gradle.internal.enterprise.test.impl.DefaultTestTaskFilters;
import org.gradle.internal.enterprise.test.impl.DefaultTestTaskForkOptions;
import org.gradle.internal.enterprise.test.impl.DefaultTestTaskProperties;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.DefaultProcessForkOptions;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.process.internal.JavaForkOptionsInternal;

public class DefaultTestTaskPropertiesService
implements TestTaskPropertiesService {
    private final PropertyWalker propertyWalker;
    private final FileCollectionFactory fileCollectionFactory;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final JvmVersionDetector jvmVersionDetector;
    private final JavaModuleDetector javaModuleDetector;

    @Inject
    public DefaultTestTaskPropertiesService(PropertyWalker propertyWalker, FileCollectionFactory fileCollectionFactory, JavaForkOptionsFactory forkOptionsFactory, JvmVersionDetector jvmVersionDetector, JavaModuleDetector javaModuleDetector) {
        this.propertyWalker = propertyWalker;
        this.fileCollectionFactory = fileCollectionFactory;
        this.forkOptionsFactory = forkOptionsFactory;
        this.jvmVersionDetector = jvmVersionDetector;
        this.javaModuleDetector = javaModuleDetector;
    }

    @Override
    public TestTaskProperties collectProperties(Test task) {
        final ImmutableList.Builder inputFileProperties = ImmutableList.builder();
        final ImmutableList.Builder outputFileProperties = ImmutableList.builder();
        TaskPropertyUtils.visitProperties((PropertyWalker)this.propertyWalker, (TaskInternal)task, (PropertyVisitor)new PropertyVisitor.Adapter(){

            public void visitInputFileProperty(String propertyName, boolean optional, boolean skipWhenEmpty, DirectorySensitivity directorySensitivity, LineEndingSensitivity lineEndingSensitivity, boolean incremental, @Nullable Class<? extends FileNormalizer> fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
                FileCollection files = DefaultTestTaskPropertiesService.this.resolveLeniently(value);
                inputFileProperties.add((Object)new DefaultInputFileProperty(propertyName, (Iterable<File>)files));
            }

            public void visitOutputFileProperty(String propertyName, boolean optional, PropertyValue value, OutputFilePropertyType filePropertyType) {
                FileCollection files = DefaultTestTaskPropertiesService.this.resolveLeniently(value);
                OutputFileProperty.Type type = filePropertyType.getOutputType() == TreeType.DIRECTORY ? OutputFileProperty.Type.DIRECTORY : OutputFileProperty.Type.FILE;
                outputFileProperties.add((Object)new DefaultOutputFileProperty(propertyName, (Iterable<File>)files, type));
            }
        });
        return new DefaultTestTaskProperties(task.getOptions() instanceof JUnitPlatformOptions, task.getForkEvery(), this.collectFilters(task), this.collectForkOptions(task), this.collectCandidateClassFiles(task), (ImmutableList<InputFileProperty>)inputFileProperties.build(), (ImmutableList<OutputFileProperty>)outputFileProperties.build());
    }

    private ImmutableList<CandidateClassFile> collectCandidateClassFiles(Test task) {
        final ImmutableList.Builder builder = ImmutableList.builder();
        task.getCandidateClassFiles().visit((FileVisitor)new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileDetails) {
                builder.add((Object)new DefaultCandidateClassFile(fileDetails.getFile(), fileDetails.getPath()));
            }
        });
        return builder.build();
    }

    private FileCollection resolveLeniently(PropertyValue value) {
        Object sources = value.call();
        return sources == null ? this.fileCollectionFactory.empty() : this.fileCollectionFactory.resolvingLeniently(sources);
    }

    private TestTaskFilters collectFilters(Test task) {
        DefaultTestFilter filter = (DefaultTestFilter)task.getFilter();
        TestFrameworkOptions options = task.getOptions();
        return new DefaultTestTaskFilters(filter.getIncludePatterns(), filter.getCommandLineIncludePatterns(), filter.getExcludePatterns(), this.getOrEmpty(options, JUnitPlatformOptions::getIncludeTags), this.getOrEmpty(options, JUnitPlatformOptions::getExcludeTags), this.getOrEmpty(options, JUnitPlatformOptions::getIncludeEngines), this.getOrEmpty(options, JUnitPlatformOptions::getExcludeEngines));
    }

    private <T> Set<T> getOrEmpty(TestFrameworkOptions options, Function<JUnitPlatformOptions, Set<T>> extractor) {
        return options instanceof JUnitPlatformOptions ? extractor.apply((JUnitPlatformOptions)options) : ImmutableSet.of();
    }

    private TestTaskForkOptions collectForkOptions(Test task) {
        boolean testIsModule = this.javaModuleDetector.isModule(((Boolean)task.getModularity().getInferModulePath().get()).booleanValue(), task.getTestClassesDirs());
        JavaForkOptionsInternal forkOptions = this.forkOptionsFactory.newJavaForkOptions();
        task.copyTo((JavaForkOptions)forkOptions);
        String executable = forkOptions.getExecutable();
        return new DefaultTestTaskForkOptions(forkOptions.getWorkingDir(), executable, this.detectJavaVersion(executable), (Iterable<File>)this.javaModuleDetector.inferClasspath(testIsModule, task.getClasspath()), (Iterable<File>)this.javaModuleDetector.inferModulePath(testIsModule, task.getClasspath()), forkOptions.getAllJvmArgs(), DefaultProcessForkOptions.getActualEnvironment((ProcessForkOptions)forkOptions));
    }

    private int detectJavaVersion(String executable) {
        return Integer.parseInt(this.jvmVersionDetector.getJavaVersion(executable).getMajorVersion());
    }
}

