/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import java.util.ArrayList;
import java.util.List;
import tim.prune.cmd.Command;
import tim.prune.cmd.RemoveMediaCmd;
import tim.prune.data.AudioClip;
import tim.prune.data.MediaList;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.TrackInfo;

public class AppendMediaCmd
extends Command {
    private final ArrayList<MediaObject> _media = new ArrayList();

    public AppendMediaCmd(List<MediaObject> list) {
        this(null, list);
    }

    AppendMediaCmd(Command command, List<MediaObject> list) {
        super(command);
        this._media.addAll(list);
    }

    @Override
    public int getUpdateFlags() {
        return 16;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        if (this._media.isEmpty()) {
            return false;
        }
        int n = 0;
        MediaList<Photo> mediaList = trackInfo.getPhotoList();
        MediaList<AudioClip> mediaList2 = trackInfo.getAudioList();
        for (MediaObject mediaObject : this._media) {
            MediaObject mediaObject2;
            if (mediaObject instanceof Photo) {
                mediaObject2 = (Photo)mediaObject;
                if (mediaObject2 == null || mediaList.contains((Photo)mediaObject2)) continue;
                mediaList.add((Photo)mediaObject2);
                ++n;
                continue;
            }
            if (!(mediaObject instanceof AudioClip) || (mediaObject2 = (AudioClip)mediaObject) == null || mediaList2.contains((AudioClip)mediaObject2)) continue;
            mediaList2.add((AudioClip)mediaObject2);
            ++n;
        }
        return n > 0;
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        return new RemoveMediaCmd(this, this._media);
    }
}

