/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.cli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class PrintTable {
    private final String[] names;
    private final List<String[]> data;
    private int[] limits;

    public PrintTable(String ... fieldNames) {
        this.names = fieldNames;
        this.data = new ArrayList<String[]>();
    }

    public void setLimits(int ... limits) {
        assert (limits.length == this.names.length);
        this.limits = limits;
    }

    public void addRow(String ... fields) {
        this.data.add(fields);
    }

    public void write(Appendable ps) throws IOException {
        int[] lengths = new int[this.names.length];
        PrintTable.length(this.names, lengths, this.limits);
        for (String[] arr : this.data) {
            PrintTable.length(arr, lengths, this.limits);
        }
        PrintTable.printRow(ps, this.names, lengths, this.limits);
        PrintTable.printSeparator(ps, lengths);
        for (String[] arr : this.data) {
            PrintTable.printRow(ps, arr, lengths, this.limits);
        }
        PrintTable.printSeparator(ps, lengths);
    }

    private static void length(String[] data, int[] lengths, int[] limits) {
        assert (data.length == lengths.length);
        for (int i = 0; i < data.length; ++i) {
            int l = data[i].length();
            if (limits != null && limits[i] >= 0 && l > limits[i]) {
                l = limits[i];
            }
            if (lengths[i] >= l) continue;
            lengths[i] = l;
        }
    }

    private static void printRow(Appendable ps, String[] data, int[] lengths, int[] limits) throws IOException {
        assert (data.length == lengths.length);
        String sep = "";
        for (int i = 0; i < data.length; ++i) {
            ps.append(sep);
            String d = data[i];
            if (limits != null && limits[i] >= 0 && d.length() > limits[i]) {
                d = d.substring(0, limits[i]);
            }
            ps.append(d);
            int missing = lengths[i] - d.length();
            while (missing-- > 0) {
                ps.append(' ');
            }
            sep = " ";
        }
        ps.append('\n');
    }

    private static void printSeparator(Appendable ps, int[] lengths) throws IOException {
        String sep = "";
        for (int i = 0; i < lengths.length; ++i) {
            ps.append(sep);
            for (int j = 0; j < lengths[i]; ++j) {
                ps.append('-');
            }
            sep = " ";
        }
        ps.append('\n');
    }
}

