/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.api;

public final class Range {
    private final Number lowerNumber;
    private final Number upperNumber;
    private Number min;
    private Number max;
    private boolean leftInclusive = true;
    private boolean rightInclusive = true;
    private Number[] values;

    public Range(Number lowerBound, Number upperBound) {
        this.lowerNumber = lowerBound;
        this.upperNumber = upperBound;
        if (!lowerBound.getClass().equals(upperBound.getClass())) {
            throw new IllegalArgumentException("Lower and upper must be the same class");
        }
    }

    public Range(Number lowerBound, Number upperBound, boolean leftInclusive, boolean rightInclusive) {
        this(lowerBound, upperBound);
        this.leftInclusive = leftInclusive;
        this.rightInclusive = rightInclusive;
    }

    public Range(Number lowerBound, Number upperBound, Number min, Number max) {
        this(lowerBound, upperBound);
        if (!min.getClass().equals(lowerBound.getClass()) || !min.getClass().equals(max.getClass())) {
            throw new IllegalArgumentException("Lower and upper must be the same class");
        }
        this.min = min;
        this.max = max;
    }

    public Range(Number lowerBound, Number upperBound, Number min, Number max, Number[] values) {
        this(lowerBound, upperBound, min, max);
        this.values = values;
    }

    public Range(Number lowerBound, Number upperBound, Number min, Number max, boolean leftInclusive, boolean rightInclusive, Number[] values) {
        this(lowerBound, upperBound, min, max, values);
        this.leftInclusive = leftInclusive;
        this.rightInclusive = rightInclusive;
    }

    public static Number trimToBounds(Number min, Number max, Number value) {
        if (min != null && max != null && value != null) {
            if (min.getClass().equals(max.getClass()) && max.getClass().equals(value.getClass())) {
                if (min instanceof Long || min instanceof Integer || min instanceof Short || min instanceof Byte) {
                    if (value.longValue() < min.longValue()) {
                        value = min;
                    } else if (value.longValue() > max.longValue()) {
                        value = max;
                    }
                } else if (min instanceof Float || min instanceof Double) {
                    if (value.doubleValue() < min.doubleValue()) {
                        value = min;
                    } else if (value.doubleValue() > max.doubleValue()) {
                        value = max;
                    }
                }
            } else {
                throw new IllegalArgumentException("min, max and value must be the same class");
            }
        }
        return value;
    }

    public boolean isInRange(Number value) {
        return ((Comparable)((Object)this.lowerNumber)).compareTo(value) <= (this.leftInclusive ? 0 : -1) && ((Comparable)((Object)this.upperNumber)).compareTo(value) >= (this.rightInclusive ? 0 : 1);
    }

    public Double getLowerDouble() {
        return this.lowerNumber.doubleValue();
    }

    public Float getLowerFloat() {
        return Float.valueOf(this.lowerNumber.floatValue());
    }

    public Integer getLowerInteger() {
        return this.lowerNumber.intValue();
    }

    public Long getLowerLong() {
        return this.lowerNumber.longValue();
    }

    public Byte getLowerByte() {
        return this.lowerNumber.byteValue();
    }

    public Short getLowerShort() {
        return this.lowerNumber.shortValue();
    }

    public Double getUpperDouble() {
        return this.upperNumber.doubleValue();
    }

    public Float getUpperFloat() {
        return Float.valueOf(this.upperNumber.floatValue());
    }

    public Integer getUpperInteger() {
        return this.upperNumber.intValue();
    }

    public Long getUpperLong() {
        return this.upperNumber.longValue();
    }

    public Short getUpperShort() {
        return this.upperNumber.shortValue();
    }

    public Byte getUpperByte() {
        return this.upperNumber.byteValue();
    }

    public Number getLowerBound() {
        return this.lowerNumber;
    }

    public Number getUpperBound() {
        return this.upperNumber;
    }

    public Number getMinimum() {
        return this.min;
    }

    public Number getMaximum() {
        return this.max;
    }

    public Class getRangeType() {
        return this.lowerNumber.getClass();
    }

    public Number[] getValues() {
        return this.values;
    }

    public boolean isLeftInclusive() {
        return this.leftInclusive;
    }

    public boolean isRightInclusive() {
        return this.rightInclusive;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (!(this.lowerNumber == other.lowerNumber || this.lowerNumber != null && this.lowerNumber.equals(other.lowerNumber))) {
            return false;
        }
        if (!(this.upperNumber == other.upperNumber || this.upperNumber != null && this.upperNumber.equals(other.upperNumber))) {
            return false;
        }
        if (!(this.min == other.min || this.min != null && this.min.equals(other.min))) {
            return false;
        }
        if (!(this.max == other.max || this.max != null && this.max.equals(other.max))) {
            return false;
        }
        if (this.leftInclusive != other.leftInclusive) {
            return false;
        }
        return this.rightInclusive == other.rightInclusive;
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + (this.lowerNumber != null ? this.lowerNumber.hashCode() : 0);
        hash = 13 * hash + (this.upperNumber != null ? this.upperNumber.hashCode() : 0);
        hash = 13 * hash + (this.min != null ? this.min.hashCode() : 0);
        hash = 13 * hash + (this.max != null ? this.max.hashCode() : 0);
        hash = 13 * hash + (this.leftInclusive ? 1 : 0);
        hash = 13 * hash + (this.rightInclusive ? 1 : 0);
        return hash;
    }

    public String toString() {
        return this.lowerNumber + " - " + this.upperNumber;
    }
}

