/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.filters.library;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.gephi.desktop.filters.library.CategoryNode;
import org.gephi.desktop.filters.library.FilterBuilderNode;
import org.gephi.desktop.filters.library.FiltersExplorer;
import org.gephi.desktop.filters.library.SavedQueryNode;
import org.gephi.filters.api.Query;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.FilterBuilder;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;

public class CategoryChildFactory
extends ChildFactory<Object> {
    private final Category category;
    private final FiltersExplorer.Utils utils;

    public CategoryChildFactory(FiltersExplorer.Utils utils, Category category) {
        this.utils = utils;
        this.category = category;
    }

    protected boolean createKeys(List<Object> toPopulate) {
        Object[] children = this.utils.getChildren(this.category);
        Arrays.sort(children, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == FiltersExplorer.QUERIES || o2 == FiltersExplorer.QUERIES) {
                    return o1 == FiltersExplorer.QUERIES ? 1 : -1;
                }
                if (o1 instanceof Category && o2 instanceof Category) {
                    String s1 = ((Category)o1).getName();
                    String s2 = ((Category)o2).getName();
                    return s1.compareTo(s2);
                }
                if (o1 instanceof FilterBuilder && o2 instanceof FilterBuilder) {
                    String s1 = ((FilterBuilder)o1).getName();
                    String s2 = ((FilterBuilder)o2).getName();
                    return s1.compareTo(s2);
                }
                if (o1 instanceof Query && o2 instanceof Query) {
                    String s1 = ((Query)o1).getName();
                    String s2 = ((Query)o2).getName();
                    return s1.compareTo(s2);
                }
                if (o1 instanceof Category) {
                    return -1;
                }
                return 1;
            }
        });
        toPopulate.addAll(Arrays.asList(children));
        return true;
    }

    protected Node[] createNodesForKey(Object key) {
        if (key instanceof Category) {
            return new Node[]{new CategoryNode(this.utils, (Category)key)};
        }
        if (key instanceof FilterBuilder) {
            return new Node[]{new FilterBuilderNode((FilterBuilder)key)};
        }
        return new Node[]{new SavedQueryNode((Query)key)};
    }
}

