/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.googleearth;

import com.google.earth.kml._2.DocumentType;
import com.google.earth.kml._2.FeatureType;
import com.google.earth.kml._2.FolderType;
import com.google.earth.kml._2.IconStyleIconType;
import com.google.earth.kml._2.IconStyleType;
import com.google.earth.kml._2.KmlType;
import com.google.earth.kml._2.ObjectFactory;
import com.google.earth.kml._2.PlacemarkType;
import com.google.earth.kml._2.PointType;
import com.google.earth.kml._2.StyleSelectorType;
import com.google.earth.kml._2.StyleType;
import com.google.earth.kml._2.TimeStampType;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.fibs.geotag.Settings;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.googleearth.GoogleearthFileFilter;
import org.fibs.geotag.util.OperatingSystem;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class KmlExporter {
    private static final I18n i18n = I18nFactory.getI18n(KmlExporter.class);
    private static final String STYLE = "Photo";
    private static final String KML_FOLDER = i18n.tr("Images");
    private static final String KMZ_IMAGE_FOLDER = "images";
    private List<ImageInfo> imageInfos;

    public KmlExporter(List<ImageInfo> imageInfos) {
        this.imageInfos = imageInfos;
    }

    public void write(OutputStream outputStream, boolean kmz) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)KmlType.class.getPackage().getName());
            ObjectFactory factory = new ObjectFactory();
            KmlType kml = factory.createKmlType();
            DocumentType document = factory.createDocumentType();
            document.setName("Geotag");
            List<JAXBElement<? extends FeatureType>> documentFeatures = document.getFeature();
            StyleType style = factory.createStyleType();
            style.setId(STYLE);
            IconStyleType iconStyle = factory.createIconStyleType();
            IconStyleIconType icon = factory.createIconStyleIconType();
            String iconURL = Settings.get(Settings.SETTING.KML_ICON_URL, "http://maps.google.com/mapfiles/kml/pal4/icon46.png");
            if ("".equals(iconURL)) {
                iconURL = "http://maps.google.com/mapfiles/kml/pal4/icon46.png";
                Settings.put(Settings.SETTING.KML_ICON_URL, iconURL);
                Settings.flush();
            }
            icon.setHref(iconURL);
            iconStyle.setIcon(icon);
            style.setIconStyle(iconStyle);
            List<JAXBElement<? extends StyleSelectorType>> styleSelectors = document.getStyleSelector();
            styleSelectors.add(factory.createStyle(style));
            FolderType folder = factory.createFolderType();
            folder.setName(KML_FOLDER);
            folder.setOpen(false);
            List<JAXBElement<? extends FeatureType>> folderFeatures = folder.getFeature();
            for (ImageInfo imageInfo : this.imageInfos) {
                String footer;
                String locString;
                String imagePath = imageInfo.getPath();
                String imageDirectory = Settings.get(Settings.SETTING.KML_IMAGE_PATH, "");
                if (imageDirectory.length() > 0) {
                    imagePath = String.valueOf(imageDirectory) + (imageDirectory.endsWith(File.separator) ? "" : File.separator) + imageInfo.getName();
                }
                PlacemarkType placemark = factory.createPlacemarkType();
                placemark.setName(imageInfo.getName());
                TimeStampType timeStamp = factory.createTimeStampType();
                Date date = imageInfo.getTimeGMT().getTime();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                timeStamp.setWhen(dateFormat.format(date));
                placemark.setTimePrimitive(factory.createTimeStamp(timeStamp));
                StringBuilder description = new StringBuilder();
                String header = Settings.get(Settings.SETTING.KML_DESCRIPTION_HEADER, "");
                if (header != null && header.length() > 0) {
                    description.append(header);
                }
                description.append("<a href=\"");
                if (OperatingSystem.isWindows()) {
                    description.append("file:///");
                }
                description.append(imagePath);
                description.append("\"><img src=\"");
                if (OperatingSystem.isWindows()) {
                    description.append("file:///");
                }
                if (kmz && Settings.get(Settings.SETTING.KMZ_STORE_THUMBNAILS, false)) {
                    description.append(KMZ_IMAGE_FOLDER);
                    description.append(File.separator);
                    description.append(imageInfo.getName());
                    description.append("\" width=\"" + imageInfo.getThumbnail().getIconWidth() + "\"/>");
                } else {
                    description.append(imagePath);
                    description.append("\" width=\"");
                    description.append(Settings.get(Settings.SETTING.THUMBNAIL_SIZE, 150));
                    description.append("\"/>");
                }
                description.append("</a>");
                String userComment = imageInfo.getUserComment();
                if (userComment != null && !"".equals(userComment)) {
                    description.append("<br>").append(userComment);
                }
                if ((locString = KmlExporter.getLocationString(imageInfo)) != null) {
                    description.append("<br>").append(locString);
                }
                if ((footer = Settings.get(Settings.SETTING.KML_DESCRIPTION_FOOTER, "")) != null && footer.length() > 0) {
                    description.append(footer);
                }
                placemark.setDescription(description.toString());
                PointType point = factory.createPointType();
                double latitude = 51.477222222222224;
                double longitude = 0.0;
                try {
                    latitude = Double.parseDouble(imageInfo.getGpsLatitude());
                    longitude = Double.parseDouble(imageInfo.getGpsLongitude());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                List<String> coordinates = point.getCoordinates();
                coordinates.add(String.valueOf(longitude) + "," + latitude);
                placemark.setGeometry(factory.createPoint(point));
                placemark.setStyleUrl("#Photo");
                folderFeatures.add(factory.createPlacemark(placemark));
            }
            documentFeatures.add(factory.createFolder(folder));
            kml.setFeature(factory.createDocument(document));
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(factory.createKml(kml), outputStream);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    private static String getLocationString(ImageInfo imageInfo) {
        StringBuilder location = new StringBuilder();
        KmlExporter.addLocationItem(location, imageInfo.getLocationName());
        KmlExporter.addLocationItem(location, imageInfo.getCityName());
        KmlExporter.addLocationItem(location, imageInfo.getProvinceName());
        KmlExporter.addLocationItem(location, imageInfo.getCountryName());
        if (location.length() > 0) {
            return location.toString();
        }
        return null;
    }

    private static void addLocationItem(StringBuilder builder, String item) {
        if (item == null) {
            return;
        }
        if (builder.length() > 0) {
            builder.append(", ");
        }
        builder.append(item);
    }

    public void writeKml(File file) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        this.write(outputStream, false);
        outputStream.close();
    }

    public void writeKmz(File file) throws IOException {
        ZipEntry zipEntry = new ZipEntry("Geotag.kml");
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        zipOutputStream.setLevel(9);
        zipOutputStream.putNextEntry(zipEntry);
        this.write(zipOutputStream, true);
        zipOutputStream.closeEntry();
        if (Settings.get(Settings.SETTING.KMZ_STORE_THUMBNAILS, false)) {
            for (ImageInfo imageInfo : this.imageInfos) {
                ImageIcon thumbnail = imageInfo.getThumbnail();
                if (thumbnail == null) continue;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)((Object)thumbnail.getImage()), "jpg", byteArrayOutputStream);
                    zipEntry = new ZipEntry("images/" + imageInfo.getName());
                    zipOutputStream.putNextEntry(zipEntry);
                    zipOutputStream.write(byteArrayOutputStream.toByteArray());
                    zipOutputStream.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        zipOutputStream.close();
    }

    public void write(File file) throws IOException {
        if (GoogleearthFileFilter.isKmlFile(file)) {
            this.writeKml(file);
        } else if (GoogleearthFileFilter.isKmzFile(file)) {
            this.writeKmz(file);
        } else {
            throw new IOException("Neither KML nor KMZ " + file.getPath());
        }
    }
}

