/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode.nodelist;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.ui.components.JComboBoxFactory;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.NodeList;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.TextHolder;

class NodeListWithReplacement
extends NodeList {
    private static final String REMINDER_TEXT_REPLACE = "reminder.Replace";
    private final JComboBox mFilterTextReplaceField;
    private final JCheckBox useRegexInReplace;

    NodeListWithReplacement(String windowTitle, boolean searchInAllMaps, String windowPreferenceStorageProperty) {
        super(windowTitle, searchInAllMaps, windowPreferenceStorageProperty);
        this.mFilterTextSearchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent pEvent) {
                if (pEvent.getKeyCode() == 40) {
                    NodeListWithReplacement.this.mFilterTextReplaceField.requestFocusInWindow();
                }
            }
        });
        this.mFilterTextReplaceField = JComboBoxFactory.create();
        this.mFilterTextReplaceField.setEditable(true);
        this.mFilterTextReplaceField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent pEvent) {
                if (pEvent.getKeyCode() == 40) {
                    NodeListWithReplacement.this.tableView.requestFocusInWindow();
                } else if (pEvent.getKeyCode() == 38) {
                    NodeListWithReplacement.this.mFilterTextSearchField.requestFocusInWindow();
                }
            }
        });
        this.useRegexInReplace = new JCheckBox(TextUtils.getText((String)"regular_expressions"));
    }

    private static String replace(Pattern p, String input, String replacement) {
        String result = HtmlUtils.getReplaceResult((Pattern)p, (String)input, (String)replacement);
        return result;
    }

    private void replace(HolderAccessor holderAccessor, boolean selectedOnly) {
        Pattern p;
        String searchString = (String)this.mFilterTextSearchField.getSelectedItem();
        if (searchString == null) {
            return;
        }
        String replaceString = (String)this.mFilterTextReplaceField.getSelectedItem();
        try {
            p = Pattern.compile(this.useRegexInFind.isSelected() ? searchString : Pattern.quote(searchString), this.matchCase.isSelected() ? 0 : 66);
        }
        catch (PatternSyntaxException e) {
            UITools.errorMessage((Object)TextUtils.format((String)"wrong_regexp", (Object[])new Object[]{searchString, e.getMessage()}));
            return;
        }
        String replacement = replaceString == null ? "" : replaceString;
        int length = holderAccessor.getLength();
        for (int i = 0; i < length; ++i) {
            TextHolder[] textHolders;
            if (selectedOnly && !this.tableView.isRowSelected(i)) continue;
            for (TextHolder textHolder : textHolders = holderAccessor.getNodeHoldersAt(i)) {
                String replaceResult;
                String text = textHolder.getText();
                String literalReplacement = this.useRegexInReplace.isSelected() ? replacement : Matcher.quoteReplacement(replacement);
                try {
                    replaceResult = HtmlUtils.isHtml((String)text) ? NodeListWithReplacement.replace(p, text, literalReplacement) : p.matcher(text).replaceAll(literalReplacement);
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    UITools.errorMessage((Object)TextUtils.format((String)"wrong_regexp", (Object[])new Object[]{replacement, message != null ? message : e.getClass().getSimpleName()}));
                    return;
                }
                if (StringUtils.equals((String)text, (String)replaceResult)) continue;
                holderAccessor.changeString(textHolder, replaceResult);
            }
        }
        this.mFlatNodeTableFilterModel.resetFilter();
        this.mFilterTextSearchField.insertItemAt(this.mFilterTextSearchField.getSelectedItem(), 0);
        this.mFilterTextReplaceField.insertItemAt(this.mFilterTextReplaceField.getSelectedItem(), 0);
        this.mFilterTextSearchField.setSelectedItem("");
    }

    @Override
    protected void createSpecificUI(Container contentPane, GridBagConstraints layoutConstraints) {
        ++layoutConstraints.gridy;
        layoutConstraints.weightx = 0.0;
        layoutConstraints.gridwidth = 1;
        contentPane.add((Component)new JLabel(TextUtils.getText((String)REMINDER_TEXT_REPLACE)), layoutConstraints);
        layoutConstraints.gridx = 4;
        contentPane.add((Component)this.useRegexInReplace, layoutConstraints);
        layoutConstraints.gridx = 0;
        layoutConstraints.weightx = 1.0;
        layoutConstraints.gridwidth = 0;
        ++layoutConstraints.gridy;
        contentPane.add((Component)this.mFilterTextReplaceField, layoutConstraints);
    }

    @Override
    protected void createSpecificButtons(Container container) {
        AbstractAction replaceAllAction = new AbstractAction(TextUtils.getText((String)"reminder.Replace_All")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NodeListWithReplacement.this.replace(new HolderAccessor(), false);
            }
        };
        JButton replaceAllButton = new JButton(replaceAllAction);
        final AbstractAction replaceSelectedAction = new AbstractAction(TextUtils.getText((String)"reminder.Replace_Selected")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NodeListWithReplacement.this.replace(new HolderAccessor(), true);
            }
        };
        JButton replaceSelectedButton = new JButton(replaceSelectedAction);
        replaceSelectedAction.setEnabled(false);
        container.add(replaceAllButton);
        container.add(replaceSelectedButton);
        ListSelectionModel rowSM1 = this.tableView.getSelectionModel();
        rowSM1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                boolean enable = !lsm.isSelectionEmpty();
                replaceSelectedAction.setEnabled(enable);
            }
        });
    }

    private class HolderAccessor {
        HolderAccessor() {
        }

        private void changeString(TextHolder textHolder, String newText) {
            textHolder.setText(newText);
        }

        public int getLength() {
            return NodeListWithReplacement.this.mFlatNodeTableFilterModel.getRowCount();
        }

        private TextHolder[] getNodeHoldersAt(int row) {
            return new TextHolder[]{(TextHolder)NodeListWithReplacement.this.sorter.getValueAt(row, NodeListWithReplacement.this.nodeTextColumn), (TextHolder)NodeListWithReplacement.this.sorter.getValueAt(row, NodeListWithReplacement.this.nodeDetailsColumn), (TextHolder)NodeListWithReplacement.this.sorter.getValueAt(row, NodeListWithReplacement.this.nodeNotesColumn)};
        }
    }
}

