/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.border.MatteBorder;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.view.swing.features.filepreview.BitmapViewerComponent;

public class BitmapImagePreview
extends JComponent
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    protected static final int BORDER_WIDTH = 2;

    public BitmapImagePreview(JFileChooser fc) {
        this();
        fc.addPropertyChangeListener(this);
    }

    public BitmapImagePreview() {
        this.setBorder(new MatteBorder(2, 2, 2, 2, Color.BLACK));
        int previewSize = ResourceController.getResourceController().getIntProperty("image_preview_size", 300);
        this.setPreferredSize(new Dimension(previewSize, previewSize));
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        File file;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            file = null;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            file = (File)e.getNewValue();
        } else {
            return;
        }
        try {
            this.updateView(file);
        }
        catch (MalformedURLException e1) {
            LogUtils.warn(e1);
        }
        catch (IOException e1) {
            LogUtils.warn(e1);
        }
    }

    protected void updateView(File file) throws MalformedURLException, IOException {
        this.removeView();
        this.repaint();
        if (file == null || !file.exists()) {
            return;
        }
        BitmapViewerComponent viewer = new BitmapViewerComponent(file.toURI());
        viewer.setHint(2);
        Dimension size = this.getSize();
        size.width -= 4;
        size.height -= 4;
        viewer.setPreferredSize(size);
        viewer.setSize(size);
        viewer.setLocation(2, 2);
        this.add(viewer);
        viewer.revalidate();
        viewer.repaint();
    }

    protected void removeView() {
        if (this.getComponentCount() == 1) {
            this.remove(0);
            this.repaint();
        }
    }
}

