/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util.signal;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import net.infonode.util.collection.CopyOnWriteArrayList;
import net.infonode.util.collection.EmptyIterator;
import net.infonode.util.signal.SignalHook;
import net.infonode.util.signal.SignalListener;

public class Signal {
    private static ReferenceQueue refQueue = new ReferenceQueue();
    private boolean reverseNotifyOrder;
    private CopyOnWriteArrayList listeners;
    private SignalHookImpl signalHook = new SignalHookImpl();

    static {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        ((WeakListener)refQueue.remove()).remove();
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public Signal() {
        this(true);
    }

    public Signal(boolean reverseNotifyOrder) {
        this.reverseNotifyOrder = reverseNotifyOrder;
    }

    protected void firstListenerAdded() {
    }

    protected void lastListenerRemoved() {
    }

    public synchronized void addListener(SignalListener listener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList(2);
        }
        this.listeners.add(listener);
        if (this.listeners.size() == 1) {
            this.firstListenerAdded();
        }
    }

    public synchronized boolean removeListener(SignalListener listener) {
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.size()) {
                Object o = this.listeners.get(i);
                if (o == listener || o instanceof WeakListener && ((WeakListener)o).get() == listener) {
                    this.removeListener(i);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected synchronized void removeWeakListener(WeakListener listener) {
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.size()) {
                Object o = this.listeners.get(i);
                if (o == listener) {
                    this.removeListener(i);
                    break;
                }
                ++i;
            }
        }
    }

    protected synchronized void removeListener(int index) {
        this.listeners.remove(index);
        if (this.listeners.size() == 0) {
            this.listeners = null;
            this.lastListenerRemoved();
        }
    }

    public synchronized boolean hasListeners() {
        return this.listeners != null && this.listeners.size() > 0;
    }

    public synchronized Iterator iterator() {
        return this.listeners == null ? EmptyIterator.INSTANCE : this.listeners.iterator();
    }

    public SignalHook getHook() {
        return this.signalHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void emit(Object object) {
        int size;
        Object[] e;
        Signal signal = this;
        synchronized (signal) {
            if (this.listeners == null) {
                return;
            }
            e = this.listeners.getElements();
            size = this.listeners.size();
        }
        if (this.reverseNotifyOrder) {
            int i = size - 1;
            while (i >= 0) {
                ((SignalListener)e[i]).signalEmitted(this, object);
                --i;
            }
        } else {
            int i = 0;
            while (i < size) {
                ((SignalListener)e[i]).signalEmitted(this, object);
                ++i;
            }
        }
    }

    public void removeListeners(Collection toRemove) {
        this.listeners.removeAll(toRemove);
    }

    private class SignalHookImpl
    implements SignalHook {
        private SignalHookImpl() {
        }

        @Override
        public void add(SignalListener listener) {
            Signal.this.addListener(listener);
        }

        @Override
        public void addWeak(SignalListener listener) {
            Signal.this.addListener(new WeakListener(listener, refQueue, this));
        }

        @Override
        public boolean remove(SignalListener listener) {
            return Signal.this.removeListener(listener);
        }

        public void removeWeak(WeakListener ref) {
            Signal.this.removeWeakListener(ref);
        }
    }

    private static class WeakListener
    extends WeakReference
    implements SignalListener {
        private SignalHookImpl hook;

        protected WeakListener(SignalListener listener, ReferenceQueue q, SignalHookImpl hook) {
            super(listener, q);
            this.hook = hook;
        }

        public void remove() {
            this.hook.removeWeak(this);
        }

        @Override
        public void signalEmitted(Signal signal, Object object) {
            SignalListener l = (SignalListener)this.get();
            if (l != null) {
                l.signalEmitted(signal, object);
            }
        }
    }
}

