/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.view.swing.map.Drawable;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;

class FoldingCircle
implements Drawable {
    private static final BasicStroke BORDER_STROKE = new BasicStroke(UITools.FONT_SCALE_FACTOR * 1.0f);
    private final boolean folded;

    public FoldingCircle(boolean folded) {
        this.folded = folded;
    }

    @Override
    public void draw(Graphics2D g, NodeView nodeView, Rectangle r) {
        MainView mainView = nodeView.getMainView();
        Color borderColor = mainView.getFoldingMarkBorderColor();
        Color fillColor = this.folded ? borderColor : mainView.getFoldingMarkFillColor();
        int x = r.x;
        int y = r.y;
        int width = r.width;
        int height = r.height;
        float minimumStroke = (float)height / 8.0f;
        BasicStroke stroke = minimumStroke > UITools.FONT_SCALE_FACTOR * 1.0f ? new BasicStroke(minimumStroke) : BORDER_STROKE;
        int strokeLineWidth = (int)Math.ceil(stroke.getLineWidth() / 2.0f);
        x += strokeLineWidth;
        y += strokeLineWidth;
        width -= strokeLineWidth * 2;
        height -= strokeLineWidth * 2;
        if (fillColor.getAlpha() != 255) {
            g.setColor(nodeView.getBackgroundColor());
            g.fillOval(x, y, width, height);
        }
        g.setColor(fillColor);
        g.fillOval(x, y, width, height);
        g.setColor(borderColor);
        g.setStroke(stroke);
        g.drawOval(x, y, width, height);
    }
}

