/**
 * SECTION:persona
 * @short_description: Represents a &quot;shard&quot; of a person from a single source (a single <link linkend="FolksBackend"><type>FolksBackend</type></link>), such as an XMPP contact from Telepathy or a vCard contact from evolution-data-server.
 * 
 * <para>All the personas belonging to one physical person are aggregated to form a single <link linkend="FolksIndividual"><type>FolksIndividual</type></link> representing that person.</para><para>Properties of a persona are provided by implementing &quot;details&quot; interfaces, such as <link linkend="FolksNameDetails"><type>FolksNameDetails</type></link> or <link linkend="FolksEmailDetails"><type>FolksEmailDetails</type></link>. They must be accessed through these interfaces. Different backends&apos; subclasses of <link linkend="FolksPersona"><type>FolksPersona</type></link> may implement different sets of interfaces. The set of interfaces implemented by a given persona is guaranteed not to change over the lifetime of that persona.</para>
 */
/**
 * FOLKS_TYPE_PERSONA:
 * 
 * The type for <link linkend="FolksPersona"><type>FolksPersona</type></link>.
 */
/**
 * folks_persona_linkable_property_to_links:
 * @self: the <link linkend="FolksPersona"><type>FolksPersona</type></link> instance
 * @prop_name: (in): &nbsp;.  <para>the name of the linkable property to use, which must be listed in <link linkend="FolksPersona--linkable-properties"><type>"linkable-properties"</type></link> </para>
 * @callback: (in): &nbsp;.  <para>a callback to execute for each of the mapping strings generated by this property </para>
 * @callback_target: (allow-none) (closure): user data to pass to @callback
 * 
 * Produce one or more mapping strings for the given property&apos;s value.
 * 
 * <para>This is a virtual method, to be overridden by subclasses of <link linkend="FolksPersona"><type>FolksPersona</type></link> who have linkable properties. Each of their linkable properties should be handled by their implementation of this function, examining the current value of the property and calling <code>callback</code> with one or more mapping strings for the property&apos;s value. Each of these mapping strings will be added to the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link>&apos;s link map, related to the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> instance which contains this <link linkend="FolksPersona"><type>FolksPersona</type></link>.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="FolksPersona--linkable-properties"><type>"linkable-properties"</type></link>
 *
 * Since: 0.1.13
 */
/**
 * FolksPersona:iid:
 * 
 * The internal ID used to represent the Persona for linking.
 * 
 * <para>This is opaque, and shouldn&apos;t be parsed or considered meaningful by clients.</para><para>The internal ID should be unique within a backend, but may not be unique across backends, so that links can be made between Personas with similar internal IDs.</para>
 */
/**
 * folks_persona_get_iid:
 * @self: the <link linkend="FolksPersona"><type>FolksPersona</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersona--iid"><type>"iid"</type></link> property.
 * 
 * The internal ID used to represent the Persona for linking.
 * 
 * <para>This is opaque, and shouldn&apos;t be parsed or considered meaningful by clients.</para><para>The internal ID should be unique within a backend, but may not be unique across backends, so that links can be made between Personas with similar internal IDs.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersona--iid"><type>"iid"</type></link> property
 */
/**
 * FolksPersona:uid:
 * 
 * The universal ID used to represent the Persona outside its <link linkend="FolksBackend"><type>FolksBackend</type></link>.
 * 
 * <para>This is opaque, and should only be parsed by clients using <link linkend="folks-persona-split-uid"><function>folks_persona_split_uid()</function></link>.</para><para>This is the canonical way to refer to any Persona. It is guaranteed to be unique within the Persona&apos;s <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.</para><para>A Persona&apos;s UID is immutable over the life of the Persona in the backing store, so a given UID is guaranteed to refer to the same Persona each time libfolks is used, until the Persona is permanently removed from its backing store.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-persona-build-uid"><function>folks_persona_build_uid()</function></link>, <link linkend="folks-persona-split-uid"><function>folks_persona_split_uid()</function></link>
 */
/**
 * folks_persona_get_uid:
 * @self: the <link linkend="FolksPersona"><type>FolksPersona</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersona--uid"><type>"uid"</type></link> property.
 * 
 * The universal ID used to represent the Persona outside its <link linkend="FolksBackend"><type>FolksBackend</type></link>.
 * 
 * <para>This is opaque, and should only be parsed by clients using <link linkend="folks-persona-split-uid"><function>folks_persona_split_uid()</function></link>.</para><para>This is the canonical way to refer to any Persona. It is guaranteed to be unique within the Persona&apos;s <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.</para><para>A Persona&apos;s UID is immutable over the life of the Persona in the backing store, so a given UID is guaranteed to refer to the same Persona each time libfolks is used, until the Persona is permanently removed from its backing store.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersona--uid"><type>"uid"</type></link> property
 */
/**
 * FolksPersona:display-id:
 * 
 * The human-readable, service-specific universal ID used to represent the Persona.
 * 
 * <para>For example: <code>foo@@xmpp.example.org</code>.</para><para>This should be used whenever the user needs to be presented with a familiar, service-specific ID. For instance, in a prompt for the user to select a specific IM contact within an <link linkend="FolksIndividual"><type>FolksIndividual</type></link> to begin a chat with.</para><para>This is not guaranteed to be unique outside of the Persona&apos;s <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>, but is guaranteed to be unique within it. If a suitable human-readable ID isn’t available from the backend, the display ID will be equal to the <link linkend="FolksPersona--iid"><type>"iid"</type></link>.</para>
 *
 * Since: 0.1.13
 */
/**
 * folks_persona_get_display_id:
 * @self: the <link linkend="FolksPersona"><type>FolksPersona</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersona--display-id"><type>"display-id"</type></link> property.
 * 
 * The human-readable, service-specific universal ID used to represent the Persona.
 * 
 * <para>For example: <code>foo@@xmpp.example.org</code>.</para><para>This should be used whenever the user needs to be presented with a familiar, service-specific ID. For instance, in a prompt for the user to select a specific IM contact within an <link linkend="FolksIndividual"><type>FolksIndividual</type></link> to begin a chat with.</para><para>This is not guaranteed to be unique outside of the Persona&apos;s <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>, but is guaranteed to be unique within it. If a suitable human-readable ID isn’t available from the backend, the display ID will be equal to the <link linkend="FolksPersona--iid"><type>"iid"</type></link>.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersona--display-id"><type>"display-id"</type></link> property
 *
 * Since: 0.1.13
 */
/**
 * FolksPersona:is-user:
 * 
 * Whether the Persona is the user.
 * 
 * <para>Iff the Persona represents the user (the person who owns the account in the respective backend) this is <code>true</code>.</para>
 *
 * Since: 0.3.0
 */
/**
 * folks_persona_get_is_user:
 * @self: the <link linkend="FolksPersona"><type>FolksPersona</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersona--is-user"><type>"is-user"</type></link> property.
 * 
 * Whether the Persona is the user.
 * 
 * <para>Iff the Persona represents the user (the person who owns the account in the respective backend) this is <code>true</code>.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersona--is-user"><type>"is-user"</type></link> property
 *
 * Since: 0.3.0
 */
/**
 * FolksPersona:store:
 * 
 * The <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> which contains this Persona.
 */
/**
 * folks_persona_get_store:
 * @self: the <link linkend="FolksPersona"><type>FolksPersona</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersona--store"><type>"store"</type></link> property.
 * 
 * The <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> which contains this Persona.
 * 
 * Returns: the value of the <link linkend="FolksPersona--store"><type>"store"</type></link> property
 */
/**
 * FolksPersona:individual:
 * 
 * The <link linkend="FolksIndividual"><type>FolksIndividual</type></link> which contains this Persona.
 * 
 * <para>This may be <code>null</code>, but should only ever be so when the Persona has just been created, when its <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> is being destroyed, or when it&apos;s moving between <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.</para>
 *
 * Since: 0.6.0
 */
/**
 * folks_persona_get_individual:
 * @self: the <link linkend="FolksPersona"><type>FolksPersona</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersona--individual"><type>"individual"</type></link> property.
 * 
 * The <link linkend="FolksIndividual"><type>FolksIndividual</type></link> which contains this Persona.
 * 
 * <para>This may be <code>null</code>, but should only ever be so when the Persona has just been created, when its <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> is being destroyed, or when it&apos;s moving between <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersona--individual"><type>"individual"</type></link> property
 *
 * Since: 0.6.0
 */
/**
 * folks_persona_set_individual:
 * @self: the <link linkend="FolksPersona"><type>FolksPersona</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPersona--individual"><type>"individual"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPersona--individual"><type>"individual"</type></link> property to @value.
 * 
 * The <link linkend="FolksIndividual"><type>FolksIndividual</type></link> which contains this Persona.
 * 
 * <para>This may be <code>null</code>, but should only ever be so when the Persona has just been created, when its <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> is being destroyed, or when it&apos;s moving between <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksPersona:linkable-properties:
 * @result_length1: return location for the length of the property's value
 * 
 * The names of the properties of this Persona which are linkable.
 * 
 * <para>If a property name is in this list, and the Persona is from a <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> whose trust level is <link linkend="FOLKS-PERSONA-STORE-TRUST-FULL"><type>FOLKS_PERSONA_STORE_TRUST_FULL</type></link>, the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> should be able to reliably use the value of the property from a given Persona instance to link the Persona with other Personas and form <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.</para><para>Note that <link linkend="FolksPersona--uid"><type>"uid"</type></link> is always implicitly a member of this list, and doesn&apos;t need to be added explicitly.</para><para>This list will have no effect if the Persona&apos;s <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> trust level is not <link linkend="FOLKS-PERSONA-STORE-TRUST-FULL"><type>FOLKS_PERSONA_STORE_TRUST_FULL</type></link>.</para><para>This property value is guaranteed to be constant for a given persona, but may vary between personas in the same store.</para>
 *
 * Since: 0.1.13
 */
/**
 * folks_persona_get_linkable_properties:
 * @self: the <link linkend="FolksPersona"><type>FolksPersona</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersona--linkable-properties"><type>"linkable-properties"</type></link> property.
 * 
 * The names of the properties of this Persona which are linkable.
 * 
 * <para>If a property name is in this list, and the Persona is from a <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> whose trust level is <link linkend="FOLKS-PERSONA-STORE-TRUST-FULL"><type>FOLKS_PERSONA_STORE_TRUST_FULL</type></link>, the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> should be able to reliably use the value of the property from a given Persona instance to link the Persona with other Personas and form <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.</para><para>Note that <link linkend="FolksPersona--uid"><type>"uid"</type></link> is always implicitly a member of this list, and doesn&apos;t need to be added explicitly.</para><para>This list will have no effect if the Persona&apos;s <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> trust level is not <link linkend="FOLKS-PERSONA-STORE-TRUST-FULL"><type>FOLKS_PERSONA_STORE_TRUST_FULL</type></link>.</para><para>This property value is guaranteed to be constant for a given persona, but may vary between personas in the same store.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersona--linkable-properties"><type>"linkable-properties"</type></link> property
 *
 * Since: 0.1.13
 */
/**
 * FolksPersona:writeable-properties:
 * @result_length1: return location for the length of the property's value
 * 
 * The names of the properties of this Persona which are writeable.
 * 
 * <para>If a property name is in this list, setting the property should result in the updated value being stored in the backend&apos;s permanent storage (unless it gets rejected due to being invalid, or a different error occurs).</para><para>It&apos;s intended that this property value will be constant for a given Persona subclass, but this isn&apos;t guaranteed; it&apos;s possible that Persona subclasses may vary the value of this property at run time.</para>
 *
 * Since: 0.6.0
 */
/**
 * folks_persona_get_writeable_properties:
 * @self: the <link linkend="FolksPersona"><type>FolksPersona</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersona--writeable-properties"><type>"writeable-properties"</type></link> property.
 * 
 * The names of the properties of this Persona which are writeable.
 * 
 * <para>If a property name is in this list, setting the property should result in the updated value being stored in the backend&apos;s permanent storage (unless it gets rejected due to being invalid, or a different error occurs).</para><para>It&apos;s intended that this property value will be constant for a given Persona subclass, but this isn&apos;t guaranteed; it&apos;s possible that Persona subclasses may vary the value of this property at run time.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersona--writeable-properties"><type>"writeable-properties"</type></link> property
 *
 * Since: 0.6.0
 */
/**
 * FolksPersonaLinkablePropertyCallback:
 * @link: (in): &nbsp;.  <para>the mapping string to be added to the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> </para>
 * @user_data: (closure): data to pass to the delegate function
 * 
 * Callback into the aggregator to manipulate a link mapping.
 * 
 * <para>This is a callback provided by the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> whenever a <link linkend="folks-persona-linkable-property-to-links"><function>folks_persona_linkable_property_to_links()</function></link> method is called, which should be called by the <code>linkable_property_to_links</code> implementation for each linkable-property-to-individual mapping it wants to add or remove in the aggregator.</para>
 *
 * Since: 0.1.13
 */
/**
 * folks_persona_build_uid:
 * @backend_name: (in): &nbsp;.  <para>the <link linkend="FolksBackend--name"><type>"name"</type></link> </para>
 * @persona_store_id: (in): &nbsp;.  <para>the <link linkend="FolksPersonaStore--id"><type>"id"</type></link> </para>
 * @persona_id: (in): &nbsp;.  <para>the Persona identifier (backend-specific) </para>
 * 
 * Build a UID from the given components.
 * 
 * <para>Each component is escaped before the UID is built. All components must be non-empty strings.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-persona-split-uid"><function>folks_persona_split_uid()</function></link>
 * 
 * Returns: <para>a valid UID </para>
 *
 * Since: 0.1.13
 */
/**
 * folks_persona_split_uid:
 * @uid: (in): &nbsp;.  <para>a valid UID </para>
 * @backend_name: (out): &nbsp;.  <para>the <link linkend="FolksBackend--name"><type>"name"</type></link> </para>
 * @persona_store_id: (out): &nbsp;.  <para>the <link linkend="FolksPersonaStore--id"><type>"id"</type></link> </para>
 * @persona_id: (out): &nbsp;.  <para>the Persona identifier (backend-specific) </para>
 * 
 * Split a UID into its component parts.
 * 
 * <para>Each component is unescaped before being returned. The UID <emphasis>must</emphasis> be correctly formed.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-persona-build-uid"><function>folks_persona_build_uid()</function></link>
 *
 * Since: 0.1.13
 */
/**
 * FolksPersona:
 * 
 * Represents a &quot;shard&quot; of a person from a single source (a single <link linkend="FolksBackend"><type>FolksBackend</type></link>), such as an XMPP contact from Telepathy or a vCard contact from evolution-data-server.
 * 
 * <para>All the personas belonging to one physical person are aggregated to form a single <link linkend="FolksIndividual"><type>FolksIndividual</type></link> representing that person.</para><para>Properties of a persona are provided by implementing &quot;details&quot; interfaces, such as <link linkend="FolksNameDetails"><type>FolksNameDetails</type></link> or <link linkend="FolksEmailDetails"><type>FolksEmailDetails</type></link>. They must be accessed through these interfaces. Different backends&apos; subclasses of <link linkend="FolksPersona"><type>FolksPersona</type></link> may implement different sets of interfaces. The set of interfaces implemented by a given persona is guaranteed not to change over the lifetime of that persona.</para>
 */
/**
 * FolksPersonaClass:
 * @linkable_property_to_links: virtual method called by <link linkend="folks-persona-linkable-property-to-links"><function>folks_persona_linkable_property_to_links()</function></link>
 * @get_linkable_properties: getter method for the abstract property <link linkend="FolksPersona--linkable-properties"><type>"linkable-properties"</type></link>
 * @get_writeable_properties: getter method for the abstract property <link linkend="FolksPersona--writeable-properties"><type>"writeable-properties"</type></link>
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-PERSONA:CAPS"><literal>FOLKS_TYPE_PERSONA</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * FolksPropertyError:
 * @FOLKS_PROPERTY_ERROR_NOT_WRITEABLE: Property is not writeable for this particular object.
 * @FOLKS_PROPERTY_ERROR_INVALID_VALUE: Value was invalid for the property.
 * @FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR: Unknown error when setting the property.
 * @FOLKS_PROPERTY_ERROR_UNAVAILABLE: The backing store is offline or otherwise unavailable.<para>This is a temporary error which should be retifiable by going online or ensuring the backing store is logged in.</para>
 * 
 * Errors which can be thrown when asynchronously setting a property of a <link linkend="FolksPersona"><type>FolksPersona</type></link> using a setter method defined on an interface such as <link linkend="FolksAliasDetails"><type>FolksAliasDetails</type></link>.
 *
 * Since: 0.6.2
 */
