"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAllowedOp = exports.getOppositeEdgeOp = exports.getOppositeKind = exports.getGraphKeywordStr = exports.getEdgeStr = exports.createChangeToEdit = void 0;
const vscode_languageserver_types_1 = require("vscode-languageserver-types");
const index_js_1 = require("../../index.js");
function createChangeToEdit(start, end, changeTo) {
    return vscode_languageserver_types_1.TextEdit.replace(vscode_languageserver_types_1.Range.create(start, end), changeTo);
}
exports.createChangeToEdit = createChangeToEdit;
;
function getEdgeStr(op) {
    return op === index_js_1.SyntaxKind.DirectedEdgeOp ? "->" : "--";
}
exports.getEdgeStr = getEdgeStr;
function getGraphKeywordStr(g) {
    return g === index_js_1.SyntaxKind.DigraphKeyword ? "digraph" : "graph";
}
exports.getGraphKeywordStr = getGraphKeywordStr;
function getOppositeKind(g) {
    return g === index_js_1.SyntaxKind.DigraphKeyword ? index_js_1.SyntaxKind.GraphKeyword : index_js_1.SyntaxKind.DigraphKeyword;
}
exports.getOppositeKind = getOppositeKind;
function getOppositeEdgeOp(g) {
    return g === index_js_1.SyntaxKind.DirectedEdgeOp ? index_js_1.SyntaxKind.UndirectedEdgeOp : index_js_1.SyntaxKind.DirectedEdgeOp;
}
exports.getOppositeEdgeOp = getOppositeEdgeOp;
function getAllowedOp(g) {
    return g === index_js_1.SyntaxKind.DigraphKeyword ? index_js_1.SyntaxKind.DirectedEdgeOp : index_js_1.SyntaxKind.UndirectedEdgeOp;
}
exports.getAllowedOp = getAllowedOp;
//# sourceMappingURL=common.js.map