/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.fs;

import com.ceph.fs.CephMount;

class CephNativeLoader {
    private static final CephNativeLoader instance = new CephNativeLoader();
    private static boolean initialized = false;
    private static final String JNI_PATH_ENV_VAR = "CEPH_JNI_PATH";
    private static final String LIBRARY_NAME = "cephfs_jni";
    private static final String LIBRARY_FILE = "libcephfs_jni.so";

    private CephNativeLoader() {
    }

    public static CephNativeLoader getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadLibrary() {
        if (initialized) {
            return;
        }
        boolean bl = false;
        String string = System.getenv(JNI_PATH_ENV_VAR);
        try {
            if (string != null) {
                System.out.println("Loading libcephfs-jni: " + string);
                System.load(string);
                bl = true;
            } else {
                try {
                    System.out.println("Loading libcephfs-jni from default path: " + System.getProperty("java.library.path"));
                    System.loadLibrary(LIBRARY_NAME);
                    bl = true;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    try {
                        string = "/usr/lib64/libcephfs_jni.so";
                        System.out.println("Loading libcephfs-jni: " + string);
                        System.load(string);
                        bl = true;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                        string = "/usr/lib/jni/libcephfs_jni.so";
                        System.out.println("Loading libcephfs-jni: " + string);
                        System.load(string);
                        bl = true;
                    }
                }
            }
            System.out.println("Loading libcephfs-jni: " + (bl ? "Success!" : "Failure!"));
        }
        catch (Throwable throwable) {
            System.out.println("Loading libcephfs-jni: " + (bl ? "Success!" : "Failure!"));
            throw throwable;
        }
        CephMount.native_initialize();
        initialized = true;
    }
}

