#!/usr/bin/env node
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 634:
/***/ ((module) => {

module.exports = require("open");

/***/ }),

/***/ 269:
/***/ ((module) => {

module.exports = require("url");

/***/ }),

/***/ 147:
/***/ ((module) => {

module.exports = JSON.parse('{"name":"@bitwarden/cli","description":"A secure and free password manager for all of your devices.","version":"2024.2.0","keywords":["bitwarden","password","vault","password manager","cli"],"author":"Bitwarden Inc. <hello@bitwarden.com> (https://bitwarden.com)","homepage":"https://bitwarden.com","repository":{"type":"git","url":"https://github.com/bitwarden/clients"},"license":"GPL-3.0-only","scripts":{"clean":"rimraf dist","build":"webpack","build:debug":"npm run build && node --inspect ./build/bw.js","build:watch":"webpack --watch","build:prod":"cross-env NODE_ENV=production webpack","build:prod:watch":"cross-env NODE_ENV=production webpack --watch","package":"npm run package:win && npm run package:mac && npm run package:lin","package:win":"pkg . --targets win-x64 --output ./dist/windows/bw.exe","package:mac":"pkg . --targets macos-x64 --output ./dist/macos/bw","package:lin":"pkg . --targets linux-x64 --output ./dist/linux/bw","debug":"node --inspect ./build/bw.js","dist":"npm run build:prod && npm run clean && npm run package","dist:win":"npm run build:prod && npm run clean && npm run package:win","dist:mac":"npm run build:prod && npm run clean && npm run package:mac","dist:lin":"npm run build:prod && npm run clean && npm run package:lin","publish:npm":"npm run build:prod && npm publish --access public","test":"jest","test:watch":"jest --watch","test:watch:all":"jest --watchAll"},"bin":{"bw":"build/bw.js"},"pkg":{"assets":["./build/**/*","../../node_modules/argon2/**/*"]},"dependencies":{"@koa/multer":"3.0.2","@koa/router":"12.0.1","argon2":"0.31.0","big-integer":"1.6.51","browser-hrtime":"1.1.8","chalk":"4.1.2","commander":"7.2.0","form-data":"4.0.0","https-proxy-agent":"7.0.2","inquirer":"8.2.6","jsdom":"23.0.1","jszip":"3.10.1","koa":"2.15.0","koa-bodyparser":"4.4.1","koa-json":"2.0.2","lowdb":"1.0.0","lunr":"2.3.9","multer":"1.4.5-lts.1","node-fetch":"2.6.12","node-forge":"1.3.1","open":"8.4.2","papaparse":"5.4.1","proper-lockfile":"4.1.2","rxjs":"7.8.1","tldts":"6.1.2","zxcvbn":"4.4.2"}}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {

// UNUSED EXPORTS: Main

;// CONCATENATED MODULE: external "fs"
const external_fs_namespaceObject = require("fs");
;// CONCATENATED MODULE: external "path"
const external_path_namespaceObject = require("path");
;// CONCATENATED MODULE: external "commander"
const external_commander_namespaceObject = require("commander");
;// CONCATENATED MODULE: external "jsdom"
const external_jsdom_namespaceObject = require("jsdom");
;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/encryption-type.enum.ts
var EncryptionType;
(function (EncryptionType) {
    EncryptionType[EncryptionType["AesCbc256_B64"] = 0] = "AesCbc256_B64";
    EncryptionType[EncryptionType["AesCbc128_HmacSha256_B64"] = 1] = "AesCbc128_HmacSha256_B64";
    EncryptionType[EncryptionType["AesCbc256_HmacSha256_B64"] = 2] = "AesCbc256_HmacSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha256_B64"] = 3] = "Rsa2048_OaepSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha1_B64"] = 4] = "Rsa2048_OaepSha1_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha256_HmacSha256_B64"] = 5] = "Rsa2048_OaepSha256_HmacSha256_B64";
    EncryptionType[EncryptionType["Rsa2048_OaepSha1_HmacSha256_B64"] = 6] = "Rsa2048_OaepSha1_HmacSha256_B64";
})(EncryptionType || (EncryptionType = {}));
/** The expected number of parts to a serialized EncString of the given encryption type.
 * For example, an EncString of type AesCbc256_B64 will have 2 parts, and an EncString of type
 * AesCbc128_HmacSha256_B64 will have 3 parts.
 *
 * Example of annotated serialized EncStrings:
 * 0.iv|data
 * 1.iv|data|mac
 * 2.iv|data|mac
 * 3.data
 * 4.data
 *
 * @see EncString
 * @see EncryptionType
 * @see EncString.parseEncryptedString
 */
const EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE = {
    [EncryptionType.AesCbc256_B64]: 2,
    [EncryptionType.AesCbc128_HmacSha256_B64]: 3,
    [EncryptionType.AesCbc256_HmacSha256_B64]: 3,
    [EncryptionType.Rsa2048_OaepSha256_B64]: 1,
    [EncryptionType.Rsa2048_OaepSha1_B64]: 1,
    [EncryptionType.Rsa2048_OaepSha256_HmacSha256_B64]: 2,
    [EncryptionType.Rsa2048_OaepSha1_HmacSha256_B64]: 2,
};

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/file-upload-type.enum.ts
var FileUploadType;
(function (FileUploadType) {
    FileUploadType[FileUploadType["Direct"] = 0] = "Direct";
    FileUploadType[FileUploadType["Azure"] = 1] = "Azure";
})(FileUploadType || (FileUploadType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/hash-purpose.enum.ts
var HashPurpose;
(function (HashPurpose) {
    HashPurpose[HashPurpose["ServerAuthorization"] = 1] = "ServerAuthorization";
    HashPurpose[HashPurpose["LocalAuthorization"] = 2] = "LocalAuthorization";
})(HashPurpose || (HashPurpose = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/html-storage-location.enum.ts
var HtmlStorageLocation;
(function (HtmlStorageLocation) {
    HtmlStorageLocation["Local"] = "local";
    HtmlStorageLocation["Memory"] = "memory";
    HtmlStorageLocation["Session"] = "session";
})(HtmlStorageLocation || (HtmlStorageLocation = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/kdf-config.ts
class KdfConfig {
    constructor(iterations, memory, parallelism) {
        this.iterations = iterations;
        this.memory = memory;
        this.parallelism = parallelism;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/misc/range-with-default.ts
/**
 * A range with a default value.
 *
 * Enforces constraints to ensure min > default > max.
 */
class RangeWithDefault {
    constructor(min, max, defaultValue) {
        this.min = min;
        this.max = max;
        this.defaultValue = defaultValue;
        if (min > max) {
            throw new Error(`${min} is greater than ${max}.`);
        }
        if (this.inRange(defaultValue) === false) {
            throw new Error("Default value is not in range.");
        }
    }
    inRange(value) {
        return value >= this.min && value <= this.max;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/kdf-type.enum.ts


var KdfType;
(function (KdfType) {
    KdfType[KdfType["PBKDF2_SHA256"] = 0] = "PBKDF2_SHA256";
    KdfType[KdfType["Argon2id"] = 1] = "Argon2id";
})(KdfType || (KdfType = {}));
const ARGON2_MEMORY = new RangeWithDefault(16, 1024, 64);
const ARGON2_PARALLELISM = new RangeWithDefault(1, 16, 4);
const ARGON2_ITERATIONS = new RangeWithDefault(2, 10, 3);
const DEFAULT_KDF_TYPE = KdfType.PBKDF2_SHA256;
const PBKDF2_ITERATIONS = new RangeWithDefault(600000, 2000000, 600000);
const DEFAULT_KDF_CONFIG = new KdfConfig(PBKDF2_ITERATIONS.defaultValue);

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/key-suffix-options.enum.ts
var KeySuffixOptions;
(function (KeySuffixOptions) {
    KeySuffixOptions["Auto"] = "auto";
    KeySuffixOptions["Biometric"] = "biometric";
    KeySuffixOptions["Pin"] = "pin";
})(KeySuffixOptions || (KeySuffixOptions = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/log-level-type.enum.ts
var LogLevelType;
(function (LogLevelType) {
    LogLevelType[LogLevelType["Debug"] = 0] = "Debug";
    LogLevelType[LogLevelType["Info"] = 1] = "Info";
    LogLevelType[LogLevelType["Warning"] = 2] = "Warning";
    LogLevelType[LogLevelType["Error"] = 3] = "Error";
})(LogLevelType || (LogLevelType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/storage-location.enum.ts
var StorageLocation;
(function (StorageLocation) {
    StorageLocation["Both"] = "both";
    StorageLocation["Disk"] = "disk";
    StorageLocation["Memory"] = "memory";
})(StorageLocation || (StorageLocation = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/theme-type.enum.ts
var ThemeType;
(function (ThemeType) {
    ThemeType["System"] = "system";
    ThemeType["Light"] = "light";
    ThemeType["Dark"] = "dark";
    ThemeType["Nord"] = "nord";
    ThemeType["SolarizedDark"] = "solarizedDark";
})(ThemeType || (ThemeType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/platform/enums/index.ts










;// CONCATENATED MODULE: external "rxjs"
const external_rxjs_namespaceObject = require("rxjs");
;// CONCATENATED MODULE: external "tldts"
const external_tldts_namespaceObject = require("tldts");
;// CONCATENATED MODULE: ../../libs/common/src/platform/misc/utils.ts
/* eslint-disable no-useless-escape */



const nodeURL = typeof window === "undefined" ? __webpack_require__(269) : null;
class utils_Utils {
    static init() {
        if (utils_Utils.inited) {
            return;
        }
        utils_Utils.inited = true;
        utils_Utils.isNode =
            typeof process !== "undefined" &&
                process.release != null &&
                process.release.name === "node";
        utils_Utils.isBrowser = typeof window !== "undefined";
        utils_Utils.isMobileBrowser = utils_Utils.isBrowser && this.isMobile(window);
        utils_Utils.isAppleMobileBrowser = utils_Utils.isBrowser && this.isAppleMobile(window);
        if (utils_Utils.isNode) {
            utils_Utils.global = global;
        }
        else if (utils_Utils.isBrowser) {
            utils_Utils.global = window;
        }
        else {
            // If it's not browser or node then it must be a service worker
            utils_Utils.global = self;
        }
    }
    static fromB64ToArray(str) {
        if (str == null) {
            return null;
        }
        if (utils_Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "base64"));
        }
        else {
            const binaryString = utils_Utils.global.atob(str);
            const bytes = new Uint8Array(binaryString.length);
            for (let i = 0; i < binaryString.length; i++) {
                bytes[i] = binaryString.charCodeAt(i);
            }
            return bytes;
        }
    }
    static fromUrlB64ToArray(str) {
        return utils_Utils.fromB64ToArray(utils_Utils.fromUrlB64ToB64(str));
    }
    static fromHexToArray(str) {
        if (utils_Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "hex"));
        }
        else {
            const bytes = new Uint8Array(str.length / 2);
            for (let i = 0; i < str.length; i += 2) {
                bytes[i / 2] = parseInt(str.substr(i, 2), 16);
            }
            return bytes;
        }
    }
    static fromUtf8ToArray(str) {
        if (utils_Utils.isNode) {
            return new Uint8Array(Buffer.from(str, "utf8"));
        }
        else {
            const strUtf8 = unescape(encodeURIComponent(str));
            const arr = new Uint8Array(strUtf8.length);
            for (let i = 0; i < strUtf8.length; i++) {
                arr[i] = strUtf8.charCodeAt(i);
            }
            return arr;
        }
    }
    static fromByteStringToArray(str) {
        if (str == null) {
            return null;
        }
        const arr = new Uint8Array(str.length);
        for (let i = 0; i < str.length; i++) {
            arr[i] = str.charCodeAt(i);
        }
        return arr;
    }
    static fromBufferToB64(buffer) {
        if (buffer == null) {
            return null;
        }
        if (utils_Utils.isNode) {
            return Buffer.from(buffer).toString("base64");
        }
        else {
            let binary = "";
            const bytes = new Uint8Array(buffer);
            for (let i = 0; i < bytes.byteLength; i++) {
                binary += String.fromCharCode(bytes[i]);
            }
            return utils_Utils.global.btoa(binary);
        }
    }
    static fromBufferToUrlB64(buffer) {
        return utils_Utils.fromB64toUrlB64(utils_Utils.fromBufferToB64(buffer));
    }
    static fromB64toUrlB64(b64Str) {
        return b64Str.replace(/\+/g, "-").replace(/\//g, "_").replace(/=/g, "");
    }
    static fromBufferToUtf8(buffer) {
        if (utils_Utils.isNode) {
            return Buffer.from(buffer).toString("utf8");
        }
        else {
            const bytes = new Uint8Array(buffer);
            const encodedString = String.fromCharCode.apply(null, bytes);
            return decodeURIComponent(escape(encodedString));
        }
    }
    static fromBufferToByteString(buffer) {
        return String.fromCharCode.apply(null, new Uint8Array(buffer));
    }
    // ref: https://stackoverflow.com/a/40031979/1090359
    static fromBufferToHex(buffer) {
        if (utils_Utils.isNode) {
            return Buffer.from(buffer).toString("hex");
        }
        else {
            const bytes = new Uint8Array(buffer);
            return Array.prototype.map
                .call(bytes, (x) => ("00" + x.toString(16)).slice(-2))
                .join("");
        }
    }
    /**
     * Converts a hex string to an ArrayBuffer.
     * Note: this doesn't need any Node specific code as parseInt() / ArrayBuffer / Uint8Array
     * work the same in Node and the browser.
     * @param {string} hexString - A string of hexadecimal characters.
     * @returns {ArrayBuffer} The ArrayBuffer representation of the hex string.
     */
    static hexStringToArrayBuffer(hexString) {
        // Check if the hexString has an even length, as each hex digit represents half a byte (4 bits),
        // and it takes two hex digits to represent a full byte (8 bits).
        if (hexString.length % 2 !== 0) {
            throw "HexString has to be an even length";
        }
        // Create an ArrayBuffer with a length that is half the length of the hex string,
        // because each pair of hex digits will become a single byte.
        const arrayBuffer = new ArrayBuffer(hexString.length / 2);
        // Create a Uint8Array view on top of the ArrayBuffer (each position represents a byte)
        // as ArrayBuffers cannot be edited directly.
        const uint8Array = new Uint8Array(arrayBuffer);
        // Loop through the bytes
        for (let i = 0; i < uint8Array.length; i++) {
            // Extract two hex characters (1 byte)
            const hexByte = hexString.substr(i * 2, 2);
            // Convert hexByte into a decimal value from base 16. (ex: ff --> 255)
            const byteValue = parseInt(hexByte, 16);
            // Place the byte value into the uint8Array
            uint8Array[i] = byteValue;
        }
        return arrayBuffer;
    }
    static fromUrlB64ToB64(urlB64Str) {
        let output = urlB64Str.replace(/-/g, "+").replace(/_/g, "/");
        switch (output.length % 4) {
            case 0:
                break;
            case 2:
                output += "==";
                break;
            case 3:
                output += "=";
                break;
            default:
                throw new Error("Illegal base64url string!");
        }
        return output;
    }
    static fromUrlB64ToUtf8(urlB64Str) {
        return utils_Utils.fromB64ToUtf8(utils_Utils.fromUrlB64ToB64(urlB64Str));
    }
    static fromUtf8ToB64(utfStr) {
        if (utils_Utils.isNode) {
            return Buffer.from(utfStr, "utf8").toString("base64");
        }
        else {
            return decodeURIComponent(escape(utils_Utils.global.btoa(utfStr)));
        }
    }
    static fromUtf8ToUrlB64(utfStr) {
        return utils_Utils.fromBufferToUrlB64(utils_Utils.fromUtf8ToArray(utfStr));
    }
    static fromB64ToUtf8(b64Str) {
        if (utils_Utils.isNode) {
            return Buffer.from(b64Str, "base64").toString("utf8");
        }
        else {
            return decodeURIComponent(escape(utils_Utils.global.atob(b64Str)));
        }
    }
    // ref: http://stackoverflow.com/a/2117523/1090359
    static newGuid() {
        return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (c) => {
            const r = (Math.random() * 16) | 0;
            const v = c === "x" ? r : (r & 0x3) | 0x8;
            return v.toString(16);
        });
    }
    static isGuid(id) {
        return RegExp(/^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/, "i").test(id);
    }
    static getHostname(uriString) {
        if (utils_Utils.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        if (uriString.startsWith("data:")) {
            return null;
        }
        if (uriString.startsWith("about:")) {
            return null;
        }
        if (uriString.startsWith("file:")) {
            return null;
        }
        // Does uriString contain invalid characters
        // TODO Needs to possibly be extended, although '!' is a reserved character
        if (uriString.indexOf("!") > 0) {
            return null;
        }
        try {
            const hostname = (0,external_tldts_namespaceObject.getHostname)(uriString, { validHosts: this.validHosts });
            if (hostname != null) {
                return hostname;
            }
        }
        catch (_a) {
            return null;
        }
        return null;
    }
    static getHost(uriString) {
        const url = utils_Utils.getUrl(uriString);
        try {
            return url != null && url.host !== "" ? url.host : null;
        }
        catch (_a) {
            return null;
        }
    }
    static getDomain(uriString) {
        if (utils_Utils.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        if (uriString.startsWith("data:")) {
            return null;
        }
        if (uriString.startsWith("about:")) {
            return null;
        }
        try {
            const parseResult = (0,external_tldts_namespaceObject.parse)(uriString, {
                validHosts: this.validHosts,
                allowPrivateDomains: true,
            });
            if (parseResult != null && parseResult.hostname != null) {
                if (parseResult.hostname === "localhost" || parseResult.isIp) {
                    return parseResult.hostname;
                }
                if (parseResult.domain != null) {
                    return parseResult.domain;
                }
                return null;
            }
        }
        catch (_a) {
            return null;
        }
        return null;
    }
    static getQueryParams(uriString) {
        const url = utils_Utils.getUrl(uriString);
        if (url == null || url.search == null || url.search === "") {
            return null;
        }
        const map = new Map();
        const pairs = (url.search[0] === "?" ? url.search.substr(1) : url.search).split("&");
        pairs.forEach((pair) => {
            const parts = pair.split("=");
            if (parts.length < 1) {
                return;
            }
            map.set(decodeURIComponent(parts[0]).toLowerCase(), parts[1] == null ? "" : decodeURIComponent(parts[1]));
        });
        return map;
    }
    static getSortFunction(i18nService, prop) {
        return (a, b) => {
            if (a[prop] == null && b[prop] != null) {
                return -1;
            }
            if (a[prop] != null && b[prop] == null) {
                return 1;
            }
            if (a[prop] == null && b[prop] == null) {
                return 0;
            }
            // The `as unknown as string` here is unfortunate because typescript doesn't property understand that the return of T[prop] will be a string
            return i18nService.collator
                ? i18nService.collator.compare(a[prop], b[prop])
                : a[prop].localeCompare(b[prop]);
        };
    }
    static isNullOrWhitespace(str) {
        return str == null || typeof str !== "string" || str.trim() === "";
    }
    static isNullOrEmpty(str) {
        return str == null || typeof str !== "string" || str == "";
    }
    static isPromise(obj) {
        return (obj != undefined && typeof obj["then"] === "function" && typeof obj["catch"] === "function");
    }
    static nameOf(name) {
        return name;
    }
    static assign(target, source) {
        return Object.assign(target, source);
    }
    static iterateEnum(obj) {
        return Object.keys(obj).filter((k) => Number.isNaN(+k)).map((k) => obj[k]);
    }
    static getUrl(uriString) {
        if (this.isNullOrWhitespace(uriString)) {
            return null;
        }
        uriString = uriString.trim();
        return utils_Utils.getUrlObject(uriString);
    }
    static camelToPascalCase(s) {
        return s.charAt(0).toUpperCase() + s.slice(1);
    }
    /**
     * There are a few ways to calculate text color for contrast, this one seems to fit accessibility guidelines best.
     * https://stackoverflow.com/a/3943023/6869691
     *
     * @param {string} bgColor
     * @param {number} [threshold] see stackoverflow link above
     * @param {boolean} [svgTextFill]
     * Indicates if this method is performed on an SVG <text> 'fill' attribute (e.g. <text fill="black"></text>).
     * This check is necessary because the '!important' tag cannot be used in a 'fill' attribute.
     */
    static pickTextColorBasedOnBgColor(bgColor, threshold = 186, svgTextFill = false) {
        const bgColorHexNums = bgColor.charAt(0) === "#" ? bgColor.substring(1, 7) : bgColor;
        const r = parseInt(bgColorHexNums.substring(0, 2), 16); // hexToR
        const g = parseInt(bgColorHexNums.substring(2, 4), 16); // hexToG
        const b = parseInt(bgColorHexNums.substring(4, 6), 16); // hexToB
        const blackColor = svgTextFill ? "black" : "black !important";
        const whiteColor = svgTextFill ? "white" : "white !important";
        return r * 0.299 + g * 0.587 + b * 0.114 > threshold ? blackColor : whiteColor;
    }
    static stringToColor(str) {
        let hash = 0;
        for (let i = 0; i < str.length; i++) {
            hash = str.charCodeAt(i) + ((hash << 5) - hash);
        }
        let color = "#";
        for (let i = 0; i < 3; i++) {
            const value = (hash >> (i * 8)) & 0xff;
            color += ("00" + value.toString(16)).substr(-2);
        }
        return color;
    }
    /**
     * @throws Will throw an error if the ContainerService has not been attached to the window object
     */
    static getContainerService() {
        if (this.global.bitwardenContainerService == null) {
            throw new Error("global bitwardenContainerService not initialized.");
        }
        return this.global.bitwardenContainerService;
    }
    static validateHexColor(color) {
        return /^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/.test(color);
    }
    /**
     * Converts map to a Record<string, V> with the same data. Inverse of recordToMap
     * Useful in toJSON methods, since Maps are not serializable
     * @param map
     * @returns
     */
    static mapToRecord(map) {
        if (map == null) {
            return null;
        }
        if (!(map instanceof Map)) {
            return map;
        }
        return Object.fromEntries(map);
    }
    /**
     * Converts record to a Map<string, V> with the same data. Inverse of mapToRecord
     * Useful in fromJSON methods, since Maps are not serializable
     *
     * Warning: If the record has string keys that are numbers, they will be converted to numbers in the map
     * @param record
     * @returns
     */
    static recordToMap(record) {
        if (record == null) {
            return null;
        }
        else if (record instanceof Map) {
            return record;
        }
        const entries = Object.entries(record);
        if (entries.length === 0) {
            return new Map();
        }
        if (isNaN(Number(entries[0][0]))) {
            return new Map(entries);
        }
        else {
            return new Map(entries.map((e) => [Number(e[0]), e[1]]));
        }
    }
    /** Applies Object.assign, but converts the type nicely using Type-Fest Merge<Destination, Source> */
    static merge(destination, source) {
        return Object.assign(destination, source);
    }
    /**
     * encodeURIComponent escapes all characters except the following:
     * alphabetic, decimal digits, - _ . ! ~ * ' ( )
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURIComponent#encoding_for_rfc3986
     */
    static encodeRFC3986URIComponent(str) {
        return encodeURIComponent(str).replace(/[!'()*]/g, (c) => `%${c.charCodeAt(0).toString(16).toUpperCase()}`);
    }
    /**
     * Normalizes a path for defense against attacks like traversals
     * @param denormalizedPath
     * @returns
     */
    static normalizePath(denormalizedPath) {
        return external_path_namespaceObject.normalize(decodeURIComponent(denormalizedPath)).replace(/^(\.\.(\/|\\|$))+/, "");
    }
    static isMobile(win) {
        let mobile = false;
        ((a) => {
            if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a) ||
                /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))) {
                mobile = true;
            }
        })(win.navigator.userAgent || win.navigator.vendor || win.opera);
        return mobile || win.navigator.userAgent.match(/iPad/i) != null;
    }
    static delay(ms) {
        return new Promise((resolve) => setTimeout(resolve, ms));
    }
    /**
     * Generate an observable from a function that returns a promise.
     * Similar to the rxjs function {@link from} with one big exception:
     * {@link from} will not re-execute the function when observers resubscribe.
     * {@link Util.asyncToObservable} will execute `generator` for every
     * subscribe, making it ideal if the value ever needs to be refreshed.
     * */
    static asyncToObservable(generator) {
        return (0,external_rxjs_namespaceObject.of)(undefined).pipe((0,external_rxjs_namespaceObject.switchMap)(() => generator()));
    }
    /**
     * Return the number of days remaining before a target date arrives.
     * Returns 0 if the day has already passed.
     */
    static daysRemaining(targetDate) {
        const diffTime = targetDate.getTime() - Date.now();
        const msPerDay = 86400000;
        return Math.max(0, Math.floor(diffTime / msPerDay));
    }
    static isAppleMobile(win) {
        return (win.navigator.userAgent.match(/iPhone/i) != null ||
            win.navigator.userAgent.match(/iPad/i) != null);
    }
    static getUrlObject(uriString) {
        // All the methods below require a protocol to properly parse a URL string
        // Assume http if no other protocol is present
        const hasProtocol = uriString.indexOf("://") > -1;
        if (!hasProtocol && uriString.indexOf(".") > -1) {
            uriString = "http://" + uriString;
        }
        else if (!hasProtocol) {
            return null;
        }
        try {
            if (nodeURL != null) {
                return new nodeURL.URL(uriString);
            }
            return new URL(uriString);
        }
        catch (e) {
            // Ignore error
        }
        return null;
    }
}
utils_Utils.inited = false;
utils_Utils.isNode = false;
utils_Utils.isBrowser = true;
utils_Utils.isMobileBrowser = false;
utils_Utils.isAppleMobileBrowser = false;
utils_Utils.global = null;
// Transpiled version of /\p{Emoji_Presentation}/gu using https://mothereff.in/regexpu. Used for compatability in older browsers.
utils_Utils.regexpEmojiPresentation = /(?:[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u270A\u270B\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF93\uDFA0-\uDFCA\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF4\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC3E\uDC40\uDC42-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDD7A\uDD95\uDD96\uDDA4\uDDFB-\uDE4F\uDE80-\uDEC5\uDECC\uDED0-\uDED2\uDED5-\uDED7\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0C-\uDD3A\uDD3C-\uDD45\uDD47-\uDD78\uDD7A-\uDDCB\uDDCD-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6])/g;
utils_Utils.validHosts = ["localhost"];
utils_Utils.originalMinimumPasswordLength = 8;
utils_Utils.minimumPasswordLength = 12;
utils_Utils.DomainMatchBlacklist = new Map([
    ["google.com", new Set(["script.google.com"])],
]);
utils_Utils.init();

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/enc-string.ts
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class EncString {
    constructor(encryptedStringOrType, data, iv, mac) {
        if (data != null) {
            this.initFromData(encryptedStringOrType, data, iv, mac);
        }
        else {
            this.initFromEncryptedString(encryptedStringOrType);
        }
    }
    get ivBytes() {
        return this.iv == null ? null : utils_Utils.fromB64ToArray(this.iv);
    }
    get macBytes() {
        return this.mac == null ? null : utils_Utils.fromB64ToArray(this.mac);
    }
    get dataBytes() {
        return this.data == null ? null : utils_Utils.fromB64ToArray(this.data);
    }
    toJSON() {
        return this.encryptedString;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return new EncString(obj);
    }
    initFromData(encType, data, iv, mac) {
        if (iv != null) {
            this.encryptedString = (encType + "." + iv + "|" + data);
        }
        else {
            this.encryptedString = (encType + "." + data);
        }
        // mac
        if (mac != null) {
            this.encryptedString = (this.encryptedString + "|" + mac);
        }
        this.encryptionType = encType;
        this.data = data;
        this.iv = iv;
        this.mac = mac;
    }
    initFromEncryptedString(encryptedString) {
        this.encryptedString = encryptedString;
        if (!this.encryptedString) {
            return;
        }
        const { encType, encPieces } = EncString.parseEncryptedString(this.encryptedString);
        this.encryptionType = encType;
        if (encPieces.length !== EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE[encType]) {
            return;
        }
        switch (encType) {
            case EncryptionType.AesCbc128_HmacSha256_B64:
            case EncryptionType.AesCbc256_HmacSha256_B64:
                this.iv = encPieces[0];
                this.data = encPieces[1];
                this.mac = encPieces[2];
                break;
            case EncryptionType.AesCbc256_B64:
                this.iv = encPieces[0];
                this.data = encPieces[1];
                break;
            case EncryptionType.Rsa2048_OaepSha256_B64:
            case EncryptionType.Rsa2048_OaepSha1_B64:
                this.data = encPieces[0];
                break;
            default:
                return;
        }
    }
    static parseEncryptedString(encryptedString) {
        const headerPieces = encryptedString.split(".");
        let encType;
        let encPieces = null;
        if (headerPieces.length === 2) {
            try {
                encType = parseInt(headerPieces[0], null);
                encPieces = headerPieces[1].split("|");
            }
            catch (e) {
                return;
            }
        }
        else {
            encPieces = encryptedString.split("|");
            encType =
                encPieces.length === 3
                    ? EncryptionType.AesCbc128_HmacSha256_B64
                    : EncryptionType.AesCbc256_B64;
        }
        return {
            encType,
            encPieces,
        };
    }
    static isSerializedEncString(s) {
        const { encType, encPieces } = this.parseEncryptedString(s);
        return EXPECTED_NUM_PARTS_BY_ENCRYPTION_TYPE[encType] === encPieces.length;
    }
    decrypt(orgId, key = null) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.decryptedValue != null) {
                return this.decryptedValue;
            }
            try {
                if (key == null) {
                    key = yield this.getKeyForDecryption(orgId);
                }
                if (key == null) {
                    throw new Error("No key to decrypt EncString with orgId " + orgId);
                }
                const encryptService = utils_Utils.getContainerService().getEncryptService();
                this.decryptedValue = yield encryptService.decryptToUtf8(this, key);
            }
            catch (e) {
                this.decryptedValue = "[error: cannot decrypt]";
            }
            return this.decryptedValue;
        });
    }
    getKeyForDecryption(orgId) {
        return __awaiter(this, void 0, void 0, function* () {
            const cryptoService = utils_Utils.getContainerService().getCryptoService();
            return orgId != null
                ? yield cryptoService.getOrgKey(orgId)
                : yield cryptoService.getUserKeyWithLegacySupport();
        });
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/services/pin-crypto/pin-crypto.service.implementation.ts
var pin_crypto_service_implementation_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class PinCryptoService {
    constructor(stateService, cryptoService, vaultTimeoutSettingsService, logService) {
        this.stateService = stateService;
        this.cryptoService = cryptoService;
        this.vaultTimeoutSettingsService = vaultTimeoutSettingsService;
        this.logService = logService;
    }
    decryptUserKeyWithPin(pin) {
        return pin_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            try {
                const pinLockType = yield this.vaultTimeoutSettingsService.isPinLockSet();
                const { pinKeyEncryptedUserKey, oldPinKeyEncryptedMasterKey } = yield this.getPinKeyEncryptedKeys(pinLockType);
                const kdf = yield this.stateService.getKdfType();
                const kdfConfig = yield this.stateService.getKdfConfig();
                let userKey;
                const email = yield this.stateService.getEmail();
                if (oldPinKeyEncryptedMasterKey) {
                    userKey = yield this.cryptoService.decryptAndMigrateOldPinKey(pinLockType === "TRANSIENT", pin, email, kdf, kdfConfig, oldPinKeyEncryptedMasterKey);
                }
                else {
                    userKey = yield this.cryptoService.decryptUserKeyWithPin(pin, email, kdf, kdfConfig, pinKeyEncryptedUserKey);
                }
                if (!userKey) {
                    this.logService.warning(`User key null after pin key decryption.`);
                    return null;
                }
                if (!(yield this.validatePin(userKey, pin))) {
                    this.logService.warning(`Pin key decryption successful but pin validation failed.`);
                    return null;
                }
                return userKey;
            }
            catch (error) {
                this.logService.error(`Error decrypting user key with pin: ${error}`);
                return null;
            }
        });
    }
    // Note: oldPinKeyEncryptedMasterKey is only used for migrating old pin keys
    // and will be null for all migrated accounts
    getPinKeyEncryptedKeys(pinLockType) {
        return pin_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            switch (pinLockType) {
                case "PERSISTANT": {
                    const pinKeyEncryptedUserKey = yield this.stateService.getPinKeyEncryptedUserKey();
                    const oldPinKeyEncryptedMasterKey = yield this.stateService.getEncryptedPinProtected();
                    return {
                        pinKeyEncryptedUserKey,
                        oldPinKeyEncryptedMasterKey: oldPinKeyEncryptedMasterKey
                            ? new EncString(oldPinKeyEncryptedMasterKey)
                            : undefined,
                    };
                }
                case "TRANSIENT": {
                    const pinKeyEncryptedUserKey = yield this.stateService.getPinKeyEncryptedUserKeyEphemeral();
                    const oldPinKeyEncryptedMasterKey = yield this.stateService.getDecryptedPinProtected();
                    return { pinKeyEncryptedUserKey, oldPinKeyEncryptedMasterKey };
                }
                case "DISABLED":
                    throw new Error("Pin is disabled");
                default: {
                    // Compile-time check for exhaustive switch
                    const _exhaustiveCheck = pinLockType;
                    return _exhaustiveCheck;
                }
            }
        });
    }
    validatePin(userKey, pin) {
        return pin_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            const protectedPin = yield this.stateService.getProtectedPin();
            const decryptedPin = yield this.cryptoService.decryptToUtf8(new EncString(protectedPin), userKey);
            return decryptedPin === pin;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/auth/src/common/services/index.ts


;// CONCATENATED MODULE: ../../libs/auth/src/common/index.ts
/**
 * This barrel file should only contain non-Angular exports
 */




;// CONCATENATED MODULE: ../../libs/common/src/models/response/base.response.ts
class BaseResponse {
    constructor(response) {
        this.response = response;
    }
    getResponseProperty(propertyName, response = null, exactName = false) {
        if (propertyName == null || propertyName === "") {
            throw new Error("propertyName must not be null/empty.");
        }
        if (response == null && this.response != null) {
            response = this.response;
        }
        if (response == null) {
            return null;
        }
        if (!exactName && response[propertyName] === undefined) {
            let otherCasePropertyName = null;
            if (propertyName.charAt(0) === propertyName.charAt(0).toUpperCase()) {
                otherCasePropertyName = propertyName.charAt(0).toLowerCase();
            }
            else {
                otherCasePropertyName = propertyName.charAt(0).toUpperCase();
            }
            if (propertyName.length > 1) {
                otherCasePropertyName += propertyName.slice(1);
            }
            propertyName = otherCasePropertyName;
            if (response[propertyName] === undefined) {
                propertyName = propertyName.toLowerCase();
            }
            if (response[propertyName] === undefined) {
                propertyName = propertyName.toUpperCase();
            }
        }
        return response[propertyName];
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/api-key.response.ts

class ApiKeyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.apiKey = this.getResponseProperty("ApiKey");
        this.revisionDate = new Date(this.getResponseProperty("RevisionDate"));
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/sso.ts
var SsoType;
(function (SsoType) {
    SsoType[SsoType["None"] = 0] = "None";
    SsoType[SsoType["OpenIdConnect"] = 1] = "OpenIdConnect";
    SsoType[SsoType["Saml2"] = 2] = "Saml2";
})(SsoType || (SsoType = {}));
var MemberDecryptionType;
(function (MemberDecryptionType) {
    MemberDecryptionType[MemberDecryptionType["MasterPassword"] = 0] = "MasterPassword";
    MemberDecryptionType[MemberDecryptionType["KeyConnector"] = 1] = "KeyConnector";
    MemberDecryptionType[MemberDecryptionType["TrustedDeviceEncryption"] = 2] = "TrustedDeviceEncryption";
})(MemberDecryptionType || (MemberDecryptionType = {}));
var OpenIdConnectRedirectBehavior;
(function (OpenIdConnectRedirectBehavior) {
    OpenIdConnectRedirectBehavior[OpenIdConnectRedirectBehavior["RedirectGet"] = 0] = "RedirectGet";
    OpenIdConnectRedirectBehavior[OpenIdConnectRedirectBehavior["FormPost"] = 1] = "FormPost";
})(OpenIdConnectRedirectBehavior || (OpenIdConnectRedirectBehavior = {}));
var Saml2BindingType;
(function (Saml2BindingType) {
    Saml2BindingType[Saml2BindingType["HttpRedirect"] = 1] = "HttpRedirect";
    Saml2BindingType[Saml2BindingType["HttpPost"] = 2] = "HttpPost";
})(Saml2BindingType || (Saml2BindingType = {}));
var Saml2NameIdFormat;
(function (Saml2NameIdFormat) {
    Saml2NameIdFormat[Saml2NameIdFormat["NotConfigured"] = 0] = "NotConfigured";
    Saml2NameIdFormat[Saml2NameIdFormat["Unspecified"] = 1] = "Unspecified";
    Saml2NameIdFormat[Saml2NameIdFormat["EmailAddress"] = 2] = "EmailAddress";
    Saml2NameIdFormat[Saml2NameIdFormat["X509SubjectName"] = 3] = "X509SubjectName";
    Saml2NameIdFormat[Saml2NameIdFormat["WindowsDomainQualifiedName"] = 4] = "WindowsDomainQualifiedName";
    Saml2NameIdFormat[Saml2NameIdFormat["KerberosPrincipalName"] = 5] = "KerberosPrincipalName";
    Saml2NameIdFormat[Saml2NameIdFormat["EntityIdentifier"] = 6] = "EntityIdentifier";
    Saml2NameIdFormat[Saml2NameIdFormat["Persistent"] = 7] = "Persistent";
    Saml2NameIdFormat[Saml2NameIdFormat["Transient"] = 8] = "Transient";
})(Saml2NameIdFormat || (Saml2NameIdFormat = {}));
var Saml2SigningBehavior;
(function (Saml2SigningBehavior) {
    Saml2SigningBehavior[Saml2SigningBehavior["IfIdpWantAuthnRequestsSigned"] = 0] = "IfIdpWantAuthnRequestsSigned";
    Saml2SigningBehavior[Saml2SigningBehavior["Always"] = 1] = "Always";
    Saml2SigningBehavior[Saml2SigningBehavior["Never"] = 3] = "Never";
})(Saml2SigningBehavior || (Saml2SigningBehavior = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/api/sso-config.api.ts


class SsoConfigApi extends BaseResponse {
    static fromView(view, api = new SsoConfigApi()) {
        api.configType = view.configType;
        api.memberDecryptionType = view.memberDecryptionType;
        api.keyConnectorUrl = view.keyConnectorUrl;
        if (api.configType === SsoType.OpenIdConnect) {
            api.authority = view.openId.authority;
            api.clientId = view.openId.clientId;
            api.clientSecret = view.openId.clientSecret;
            api.metadataAddress = view.openId.metadataAddress;
            api.redirectBehavior = view.openId.redirectBehavior;
            api.getClaimsFromUserInfoEndpoint = view.openId.getClaimsFromUserInfoEndpoint;
            api.additionalScopes = view.openId.additionalScopes;
            api.additionalUserIdClaimTypes = view.openId.additionalUserIdClaimTypes;
            api.additionalEmailClaimTypes = view.openId.additionalEmailClaimTypes;
            api.additionalNameClaimTypes = view.openId.additionalNameClaimTypes;
            api.acrValues = view.openId.acrValues;
            api.expectedReturnAcrValue = view.openId.expectedReturnAcrValue;
        }
        else if (api.configType === SsoType.Saml2) {
            api.spUniqueEntityId = view.saml.spUniqueEntityId;
            api.spNameIdFormat = view.saml.spNameIdFormat;
            api.spOutboundSigningAlgorithm = view.saml.spOutboundSigningAlgorithm;
            api.spSigningBehavior = view.saml.spSigningBehavior;
            api.spMinIncomingSigningAlgorithm = view.saml.spMinIncomingSigningAlgorithm;
            api.spWantAssertionsSigned = view.saml.spWantAssertionsSigned;
            api.spValidateCertificates = view.saml.spValidateCertificates;
            api.idpEntityId = view.saml.idpEntityId;
            api.idpBindingType = view.saml.idpBindingType;
            api.idpSingleSignOnServiceUrl = view.saml.idpSingleSignOnServiceUrl;
            api.idpSingleLogoutServiceUrl = view.saml.idpSingleLogoutServiceUrl;
            api.idpX509PublicCert = view.saml.idpX509PublicCert;
            api.idpOutboundSigningAlgorithm = view.saml.idpOutboundSigningAlgorithm;
            api.idpAllowUnsolicitedAuthnResponse = view.saml.idpAllowUnsolicitedAuthnResponse;
            api.idpWantAuthnRequestsSigned = view.saml.idpWantAuthnRequestsSigned;
            // Value is inverted in the api model (disable instead of allow)
            api.idpDisableOutboundLogoutRequests = !view.saml.idpAllowOutboundLogoutRequests;
        }
        return api;
    }
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.configType = this.getResponseProperty("ConfigType");
        this.memberDecryptionType = this.getResponseProperty("MemberDecryptionType");
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
        this.authority = this.getResponseProperty("Authority");
        this.clientId = this.getResponseProperty("ClientId");
        this.clientSecret = this.getResponseProperty("ClientSecret");
        this.metadataAddress = this.getResponseProperty("MetadataAddress");
        this.redirectBehavior = this.getResponseProperty("RedirectBehavior");
        this.getClaimsFromUserInfoEndpoint = this.getResponseProperty("GetClaimsFromUserInfoEndpoint");
        this.additionalScopes = this.getResponseProperty("AdditionalScopes");
        this.additionalUserIdClaimTypes = this.getResponseProperty("AdditionalUserIdClaimTypes");
        this.additionalEmailClaimTypes = this.getResponseProperty("AdditionalEmailClaimTypes");
        this.additionalNameClaimTypes = this.getResponseProperty("AdditionalNameClaimTypes");
        this.acrValues = this.getResponseProperty("AcrValues");
        this.expectedReturnAcrValue = this.getResponseProperty("ExpectedReturnAcrValue");
        this.spUniqueEntityId = this.getResponseProperty("SpUniqueEntityId");
        this.spNameIdFormat = this.getResponseProperty("SpNameIdFormat");
        this.spOutboundSigningAlgorithm = this.getResponseProperty("SpOutboundSigningAlgorithm");
        this.spSigningBehavior = this.getResponseProperty("SpSigningBehavior");
        this.spMinIncomingSigningAlgorithm = this.getResponseProperty("SpMinIncomingSigningAlgorithm");
        this.spWantAssertionsSigned = this.getResponseProperty("SpWantAssertionsSigned");
        this.spValidateCertificates = this.getResponseProperty("SpValidateCertificates");
        this.idpEntityId = this.getResponseProperty("IdpEntityId");
        this.idpBindingType = this.getResponseProperty("IdpBindingType");
        this.idpSingleSignOnServiceUrl = this.getResponseProperty("IdpSingleSignOnServiceUrl");
        this.idpSingleLogoutServiceUrl = this.getResponseProperty("IdpSingleLogoutServiceUrl");
        this.idpX509PublicCert = this.getResponseProperty("IdpX509PublicCert");
        this.idpOutboundSigningAlgorithm = this.getResponseProperty("IdpOutboundSigningAlgorithm");
        this.idpAllowUnsolicitedAuthnResponse = this.getResponseProperty("IdpAllowUnsolicitedAuthnResponse");
        this.idpDisableOutboundLogoutRequests = this.getResponseProperty("IdpDisableOutboundLogoutRequests");
        this.idpWantAuthnRequestsSigned = this.getResponseProperty("IdpWantAuthnRequestsSigned");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/organization-sso.response.ts


class OrganizationSsoResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.enabled = this.getResponseProperty("Enabled");
        this.identifier = this.getResponseProperty("Identifier");
        this.data =
            this.getResponseProperty("Data") != null
                ? new SsoConfigApi(this.getResponseProperty("Data"))
                : null;
        this.urls = new SsoUrls(this.getResponseProperty("Urls"));
    }
}
class SsoUrls extends BaseResponse {
    constructor(response) {
        super(response);
        this.callbackPath = this.getResponseProperty("CallbackPath");
        this.signedOutCallbackPath = this.getResponseProperty("SignedOutCallbackPath");
        this.spEntityId = this.getResponseProperty("SpEntityId");
        this.spEntityIdStatic = this.getResponseProperty("SpEntityIdStatic");
        this.spMetadataUrl = this.getResponseProperty("SpMetadataUrl");
        this.spAcsUrl = this.getResponseProperty("SpAcsUrl");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/billing.response.ts

class BillingResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.invoices = [];
        this.transactions = [];
        this.balance = this.getResponseProperty("Balance");
        const paymentSource = this.getResponseProperty("PaymentSource");
        const transactions = this.getResponseProperty("Transactions");
        const invoices = this.getResponseProperty("Invoices");
        this.paymentSource = paymentSource == null ? null : new BillingSourceResponse(paymentSource);
        if (transactions != null) {
            this.transactions = transactions.map((t) => new BillingTransactionResponse(t));
        }
        if (invoices != null) {
            this.invoices = invoices.map((i) => new BillingInvoiceResponse(i));
        }
    }
    get hasNoHistory() {
        return this.invoices.length == 0 && this.transactions.length == 0;
    }
}
class BillingSourceResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.type = this.getResponseProperty("Type");
        this.cardBrand = this.getResponseProperty("CardBrand");
        this.description = this.getResponseProperty("Description");
        this.needsVerification = this.getResponseProperty("NeedsVerification");
    }
}
class BillingInvoiceResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.url = this.getResponseProperty("Url");
        this.pdfUrl = this.getResponseProperty("PdfUrl");
        this.number = this.getResponseProperty("Number");
        this.paid = this.getResponseProperty("Paid");
        this.date = this.getResponseProperty("Date");
        this.amount = this.getResponseProperty("Amount");
    }
}
class BillingTransactionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.createdDate = this.getResponseProperty("CreatedDate");
        this.amount = this.getResponseProperty("Amount");
        this.refunded = this.getResponseProperty("Refunded");
        this.partiallyRefunded = this.getResponseProperty("PartiallyRefunded");
        this.refundedAmount = this.getResponseProperty("RefundedAmount");
        this.type = this.getResponseProperty("Type");
        this.paymentMethodType = this.getResponseProperty("PaymentMethodType");
        this.details = this.getResponseProperty("Details");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/organization-risks-subscription-failure.response.ts

class OrganizationRisksSubscriptionFailureResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.organizationId = this.getResponseProperty("OrganizationId");
        this.risksSubscriptionFailure = this.getResponseProperty("RisksSubscriptionFailure");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/plan.response.ts

class PlanResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.type = this.getResponseProperty("Type");
        this.product = this.getResponseProperty("Product");
        this.name = this.getResponseProperty("Name");
        this.isAnnual = this.getResponseProperty("IsAnnual");
        this.nameLocalizationKey = this.getResponseProperty("NameLocalizationKey");
        this.descriptionLocalizationKey = this.getResponseProperty("DescriptionLocalizationKey");
        this.canBeUsedByBusiness = this.getResponseProperty("CanBeUsedByBusiness");
        this.trialPeriodDays = this.getResponseProperty("TrialPeriodDays");
        this.hasSelfHost = this.getResponseProperty("HasSelfHost");
        this.hasPolicies = this.getResponseProperty("HasPolicies");
        this.hasGroups = this.getResponseProperty("HasGroups");
        this.hasDirectory = this.getResponseProperty("HasDirectory");
        this.hasEvents = this.getResponseProperty("HasEvents");
        this.hasTotp = this.getResponseProperty("HasTotp");
        this.has2fa = this.getResponseProperty("Has2fa");
        this.hasApi = this.getResponseProperty("HasApi");
        this.hasSso = this.getResponseProperty("HasSso");
        this.hasResetPassword = this.getResponseProperty("HasResetPassword");
        this.usersGetPremium = this.getResponseProperty("UsersGetPremium");
        this.upgradeSortOrder = this.getResponseProperty("UpgradeSortOrder");
        this.displaySortOrder = this.getResponseProperty("DisplaySortOrder");
        this.legacyYear = this.getResponseProperty("LegacyYear");
        this.disabled = this.getResponseProperty("Disabled");
        const passwordManager = this.getResponseProperty("PasswordManager");
        const secretsManager = this.getResponseProperty("SecretsManager");
        this.PasswordManager =
            passwordManager == null ? null : new PasswordManagerPlanFeaturesResponse(passwordManager);
        this.SecretsManager =
            secretsManager == null ? null : new SecretsManagerPlanFeaturesResponse(secretsManager);
    }
}
class SecretsManagerPlanFeaturesResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.stripeSeatPlanId = this.getResponseProperty("StripeSeatPlanId");
        this.baseSeats = this.getResponseProperty("BaseSeats");
        this.basePrice = this.getResponseProperty("BasePrice");
        this.seatPrice = this.getResponseProperty("SeatPrice");
        this.hasAdditionalSeatsOption = this.getResponseProperty("HasAdditionalSeatsOption");
        this.maxAdditionalSeats = this.getResponseProperty("MaxAdditionalSeats");
        this.maxSeats = this.getResponseProperty("MaxSeats");
        this.stripeServiceAccountPlanId = this.getResponseProperty("StripeServiceAccountPlanId");
        this.additionalPricePerServiceAccount = this.getResponseProperty("AdditionalPricePerServiceAccount");
        this.baseServiceAccount = this.getResponseProperty("BaseServiceAccount");
        this.maxServiceAccount = this.getResponseProperty("MaxServiceAccount");
        this.hasAdditionalServiceAccountOption = this.getResponseProperty("HasAdditionalServiceAccountOption");
        this.maxAdditionalServiceAccounts = this.getResponseProperty("MaxAdditionalServiceAccounts");
        this.maxProjects = this.getResponseProperty("MaxProjects");
    }
}
class PasswordManagerPlanFeaturesResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.stripePlanId = this.getResponseProperty("StripePlanId");
        this.stripeSeatPlanId = this.getResponseProperty("StripeSeatPlanId");
        this.stripeStoragePlanId = this.getResponseProperty("StripeStoragePlanId");
        this.stripePremiumAccessPlanId = this.getResponseProperty("StripePremiumAccessPlanId");
        this.basePrice = this.getResponseProperty("BasePrice");
        this.seatPrice = this.getResponseProperty("SeatPrice");
        this.baseSeats = this.getResponseProperty("BaseSeats");
        this.maxAdditionalSeats = this.getResponseProperty("MaxAdditionalSeats");
        this.premiumAccessOptionPrice = this.getResponseProperty("PremiumAccessOptionPrice");
        this.maxSeats = this.getResponseProperty("MaxSeats");
        this.additionalStoragePricePerGb = this.getResponseProperty("AdditionalStoragePricePerGb");
        this.hasAdditionalSeatsOption = this.getResponseProperty("HasAdditionalSeatsOption");
        this.baseStorageGb = this.getResponseProperty("BaseStorageGb");
        this.maxCollections = this.getResponseProperty("MaxCollections");
        this.hasAdditionalStorageOption = this.getResponseProperty("HasAdditionalStorageOption");
        this.maxAdditionalStorage = this.getResponseProperty("MaxAdditionalStorage");
        this.hasPremiumAccessOption = this.getResponseProperty("HasPremiumAccessOption");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/organization.response.ts


class OrganizationResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.businessName = this.getResponseProperty("BusinessName");
        this.businessAddress1 = this.getResponseProperty("BusinessAddress1");
        this.businessAddress2 = this.getResponseProperty("BusinessAddress2");
        this.businessAddress3 = this.getResponseProperty("BusinessAddress3");
        this.businessCountry = this.getResponseProperty("BusinessCountry");
        this.businessTaxNumber = this.getResponseProperty("BusinessTaxNumber");
        this.billingEmail = this.getResponseProperty("BillingEmail");
        const plan = this.getResponseProperty("Plan");
        this.plan = plan == null ? null : new PlanResponse(plan);
        this.planType = this.getResponseProperty("PlanType");
        this.seats = this.getResponseProperty("Seats");
        this.maxAutoscaleSeats = this.getResponseProperty("MaxAutoscaleSeats");
        this.maxCollections = this.getResponseProperty("MaxCollections");
        this.maxStorageGb = this.getResponseProperty("MaxStorageGb");
        this.useGroups = this.getResponseProperty("UseGroups");
        this.useDirectory = this.getResponseProperty("UseDirectory");
        this.useEvents = this.getResponseProperty("UseEvents");
        this.useTotp = this.getResponseProperty("UseTotp");
        this.use2fa = this.getResponseProperty("Use2fa");
        this.useApi = this.getResponseProperty("UseApi");
        this.useResetPassword = this.getResponseProperty("UseResetPassword");
        this.useSecretsManager = this.getResponseProperty("UseSecretsManager");
        this.hasPublicAndPrivateKeys = this.getResponseProperty("HasPublicAndPrivateKeys");
        this.usePasswordManager = this.getResponseProperty("UsePasswordManager");
        this.smSeats = this.getResponseProperty("SmSeats");
        this.smServiceAccounts = this.getResponseProperty("SmServiceAccounts");
        this.maxAutoscaleSmSeats = this.getResponseProperty("MaxAutoscaleSmSeats");
        this.maxAutoscaleSmServiceAccounts = this.getResponseProperty("MaxAutoscaleSmServiceAccounts");
        this.limitCollectionCreationDeletion = this.getResponseProperty("LimitCollectionCreationDeletion");
        this.allowAdminAccessToAllCollectionItems = this.getResponseProperty("AllowAdminAccessToAllCollectionItems");
        this.flexibleCollections = this.getResponseProperty("FlexibleCollections");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/subscription.response.ts

class SubscriptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.storageName = this.getResponseProperty("StorageName");
        this.storageGb = this.getResponseProperty("StorageGb");
        this.maxStorageGb = this.getResponseProperty("MaxStorageGb");
        this.license = this.getResponseProperty("License");
        this.expiration = this.getResponseProperty("Expiration");
        const subscription = this.getResponseProperty("Subscription");
        const upcomingInvoice = this.getResponseProperty("UpcomingInvoice");
        this.subscription = subscription == null ? null : new BillingSubscriptionResponse(subscription);
        this.upcomingInvoice =
            upcomingInvoice == null
                ? null
                : new BillingSubscriptionUpcomingInvoiceResponse(upcomingInvoice);
    }
}
class BillingSubscriptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.items = [];
        this.trialStartDate = this.getResponseProperty("TrialStartDate");
        this.trialEndDate = this.getResponseProperty("TrialEndDate");
        this.periodStartDate = this.getResponseProperty("PeriodStartDate");
        this.periodEndDate = this.getResponseProperty("PeriodEndDate");
        this.cancelledDate = this.getResponseProperty("CancelledDate");
        this.cancelAtEndDate = this.getResponseProperty("CancelAtEndDate");
        this.status = this.getResponseProperty("Status");
        this.cancelled = this.getResponseProperty("Cancelled");
        const items = this.getResponseProperty("Items");
        if (items != null) {
            this.items = items.map((i) => new BillingSubscriptionItemResponse(i));
        }
    }
}
class BillingSubscriptionItemResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.productId = this.getResponseProperty("ProductId");
        this.name = this.getResponseProperty("Name");
        this.amount = this.getResponseProperty("Amount");
        this.quantity = this.getResponseProperty("Quantity");
        this.interval = this.getResponseProperty("Interval");
        this.sponsoredSubscriptionItem = this.getResponseProperty("SponsoredSubscriptionItem");
        this.addonSubscriptionItem = this.getResponseProperty("AddonSubscriptionItem");
    }
}
class BillingSubscriptionUpcomingInvoiceResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.date = this.getResponseProperty("Date");
        this.amount = this.getResponseProperty("Amount");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/organization-subscription.response.ts



class OrganizationSubscriptionResponse extends OrganizationResponse {
    constructor(response) {
        super(response);
        this.storageName = this.getResponseProperty("StorageName");
        this.storageGb = this.getResponseProperty("StorageGb");
        const subscription = this.getResponseProperty("Subscription");
        this.subscription = subscription == null ? null : new BillingSubscriptionResponse(subscription);
        const upcomingInvoice = this.getResponseProperty("UpcomingInvoice");
        this.upcomingInvoice =
            upcomingInvoice == null
                ? null
                : new BillingSubscriptionUpcomingInvoiceResponse(upcomingInvoice);
        const customerDiscount = this.getResponseProperty("CustomerDiscount");
        this.customerDiscount =
            customerDiscount == null ? null : new BillingCustomerDiscount(customerDiscount);
        this.expiration = this.getResponseProperty("Expiration");
        this.expirationWithoutGracePeriod = this.getResponseProperty("ExpirationWithoutGracePeriod");
        this.secretsManagerBeta = this.getResponseProperty("SecretsManagerBeta");
    }
}
class BillingCustomerDiscount extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.active = this.getResponseProperty("Active");
        this.percentOff = this.getResponseProperty("PercentOff");
        this.appliesTo = this.getResponseProperty("AppliesTo");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/api/permissions.api.ts

class PermissionsApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return this;
        }
        this.accessEventLogs = this.getResponseProperty("AccessEventLogs");
        this.accessImportExport = this.getResponseProperty("AccessImportExport");
        this.accessReports = this.getResponseProperty("AccessReports");
        this.createNewCollections = this.getResponseProperty("CreateNewCollections");
        this.editAnyCollection = this.getResponseProperty("EditAnyCollection");
        this.deleteAnyCollection = this.getResponseProperty("DeleteAnyCollection");
        this.editAssignedCollections = this.getResponseProperty("EditAssignedCollections");
        this.deleteAssignedCollections = this.getResponseProperty("DeleteAssignedCollections");
        this.manageCiphers = this.getResponseProperty("ManageCiphers");
        this.manageGroups = this.getResponseProperty("ManageGroups");
        this.manageSso = this.getResponseProperty("ManageSso");
        this.managePolicies = this.getResponseProperty("ManagePolicies");
        this.manageUsers = this.getResponseProperty("ManageUsers");
        this.manageResetPassword = this.getResponseProperty("ManageResetPassword");
        this.manageScim = this.getResponseProperty("ManageScim");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/profile-organization.response.ts


class ProfileOrganizationResponse extends BaseResponse {
    constructor(response) {
        var _a, _b, _c, _d;
        super(response);
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.usePolicies = this.getResponseProperty("UsePolicies");
        this.useGroups = this.getResponseProperty("UseGroups");
        this.useDirectory = this.getResponseProperty("UseDirectory");
        this.useEvents = this.getResponseProperty("UseEvents");
        this.useTotp = this.getResponseProperty("UseTotp");
        this.use2fa = this.getResponseProperty("Use2fa");
        this.useApi = this.getResponseProperty("UseApi");
        this.useSso = this.getResponseProperty("UseSso");
        this.useKeyConnector = (_a = this.getResponseProperty("UseKeyConnector")) !== null && _a !== void 0 ? _a : false;
        this.useScim = (_b = this.getResponseProperty("UseScim")) !== null && _b !== void 0 ? _b : false;
        this.useCustomPermissions = (_c = this.getResponseProperty("UseCustomPermissions")) !== null && _c !== void 0 ? _c : false;
        this.useResetPassword = this.getResponseProperty("UseResetPassword");
        this.useSecretsManager = this.getResponseProperty("UseSecretsManager");
        this.usePasswordManager = this.getResponseProperty("UsePasswordManager");
        this.useActivateAutofillPolicy = this.getResponseProperty("UseActivateAutofillPolicy");
        this.selfHost = this.getResponseProperty("SelfHost");
        this.usersGetPremium = this.getResponseProperty("UsersGetPremium");
        this.seats = this.getResponseProperty("Seats");
        this.maxCollections = this.getResponseProperty("MaxCollections");
        this.maxStorageGb = this.getResponseProperty("MaxStorageGb");
        this.key = this.getResponseProperty("Key");
        this.hasPublicAndPrivateKeys = this.getResponseProperty("HasPublicAndPrivateKeys");
        this.status = this.getResponseProperty("Status");
        this.type = this.getResponseProperty("Type");
        this.enabled = this.getResponseProperty("Enabled");
        this.ssoBound = this.getResponseProperty("SsoBound");
        this.identifier = this.getResponseProperty("Identifier");
        this.permissions = new PermissionsApi(this.getResponseProperty("permissions"));
        this.resetPasswordEnrolled = this.getResponseProperty("ResetPasswordEnrolled");
        this.userId = this.getResponseProperty("UserId");
        this.providerId = this.getResponseProperty("ProviderId");
        this.providerName = this.getResponseProperty("ProviderName");
        this.providerType = this.getResponseProperty("ProviderType");
        this.familySponsorshipFriendlyName = this.getResponseProperty("FamilySponsorshipFriendlyName");
        this.familySponsorshipAvailable = this.getResponseProperty("FamilySponsorshipAvailable");
        this.planProductType = this.getResponseProperty("PlanProductType");
        this.keyConnectorEnabled = (_d = this.getResponseProperty("KeyConnectorEnabled")) !== null && _d !== void 0 ? _d : false;
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
        const familySponsorshipLastSyncDateString = this.getResponseProperty("FamilySponsorshipLastSyncDate");
        if (familySponsorshipLastSyncDateString) {
            this.familySponsorshipLastSyncDate = new Date(familySponsorshipLastSyncDateString);
        }
        const familySponsorshipValidUntilString = this.getResponseProperty("FamilySponsorshipValidUntil");
        if (familySponsorshipValidUntilString) {
            this.familySponsorshipValidUntil = new Date(familySponsorshipValidUntilString);
        }
        this.familySponsorshipToDelete = this.getResponseProperty("FamilySponsorshipToDelete");
        this.accessSecretsManager = this.getResponseProperty("AccessSecretsManager");
        this.limitCollectionCreationDeletion = this.getResponseProperty("LimitCollectionCreationDeletion");
        this.allowAdminAccessToAllCollectionItems = this.getResponseProperty("AllowAdminAccessToAllCollectionItems");
        this.flexibleCollections = this.getResponseProperty("FlexibleCollections");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/profile-provider-organization.response.ts

class ProfileProviderOrganizationResponse extends ProfileOrganizationResponse {
    constructor(response) {
        super(response);
        this.keyConnectorEnabled = false;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/profile-provider.response.ts


class ProfileProviderResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.key = this.getResponseProperty("Key");
        this.status = this.getResponseProperty("Status");
        this.type = this.getResponseProperty("Type");
        this.enabled = this.getResponseProperty("Enabled");
        this.permissions = new PermissionsApi(this.getResponseProperty("permissions"));
        this.userId = this.getResponseProperty("UserId");
        this.useEvents = this.getResponseProperty("UseEvents");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/profile.response.ts




class ProfileResponse extends BaseResponse {
    constructor(response) {
        var _a, _b;
        super(response);
        this.organizations = [];
        this.providers = [];
        this.providerOrganizations = [];
        this.id = this.getResponseProperty("Id");
        this.name = this.getResponseProperty("Name");
        this.email = this.getResponseProperty("Email");
        this.emailVerified = this.getResponseProperty("EmailVerified");
        this.masterPasswordHint = this.getResponseProperty("MasterPasswordHint");
        this.premiumPersonally = this.getResponseProperty("Premium");
        this.premiumFromOrganization = this.getResponseProperty("PremiumFromOrganization");
        this.culture = this.getResponseProperty("Culture");
        this.twoFactorEnabled = this.getResponseProperty("TwoFactorEnabled");
        this.key = this.getResponseProperty("Key");
        this.avatarColor = this.getResponseProperty("AvatarColor");
        this.privateKey = this.getResponseProperty("PrivateKey");
        this.securityStamp = this.getResponseProperty("SecurityStamp");
        this.forcePasswordReset = (_a = this.getResponseProperty("ForcePasswordReset")) !== null && _a !== void 0 ? _a : false;
        this.usesKeyConnector = (_b = this.getResponseProperty("UsesKeyConnector")) !== null && _b !== void 0 ? _b : false;
        const organizations = this.getResponseProperty("Organizations");
        if (organizations != null) {
            this.organizations = organizations.map((o) => new ProfileOrganizationResponse(o));
        }
        const providers = this.getResponseProperty("Providers");
        if (providers != null) {
            this.providers = providers.map((o) => new ProfileProviderResponse(o));
        }
        const providerOrganizations = this.getResponseProperty("ProviderOrganizations");
        if (providerOrganizations != null) {
            this.providerOrganizations = providerOrganizations.map((o) => new ProfileProviderOrganizationResponse(o));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/payment.response.ts


class PaymentResponse extends BaseResponse {
    constructor(response) {
        super(response);
        const userProfile = this.getResponseProperty("UserProfile");
        if (userProfile != null) {
            this.userProfile = new ProfileResponse(userProfile);
        }
        this.paymentIntentClientSecret = this.getResponseProperty("PaymentIntentClientSecret");
        this.success = this.getResponseProperty("Success");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/billing/models/response/tax-info.response.ts

class TaxInfoResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.taxId = this.getResponseProperty("TaxIdNumber");
        this.taxIdType = this.getResponseProperty("TaxIdType");
        this.line1 = this.getResponseProperty("Line1");
        this.line2 = this.getResponseProperty("Line2");
        this.city = this.getResponseProperty("City");
        this.state = this.getResponseProperty("State");
        this.postalCode = this.getResponseProperty("PostalCode");
        this.country = this.getResponseProperty("Country");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/list.response.ts

class ListResponse extends BaseResponse {
    constructor(response, t) {
        super(response);
        const data = this.getResponseProperty("Data");
        this.data = data == null ? [] : data.map((dr) => new t(dr));
        this.continuationToken = this.getResponseProperty("ContinuationToken");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/organization-api-key-information.response.ts

class OrganizationApiKeyInformationResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.keyType = this.getResponseProperty("KeyType");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/organization-auto-enroll-status.response.ts

class OrganizationAutoEnrollStatusResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.resetPasswordEnabled = this.getResponseProperty("ResetPasswordEnabled");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/response/keys.response.ts

class KeysResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.privateKey = this.getResponseProperty("PrivateKey");
        this.publicKey = this.getResponseProperty("PublicKey");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/organization-keys.response.ts

class OrganizationKeysResponse extends KeysResponse {
    constructor(response) {
        super(response);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/organization/organization-api.service.ts
var organization_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













class OrganizationApiService {
    constructor(apiService, syncService) {
        this.apiService = apiService;
        this.syncService = syncService;
    }
    get(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id, null, true, true);
            return new OrganizationResponse(r);
        });
    }
    getBilling(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/billing", null, true, true);
            return new BillingResponse(r);
        });
    }
    getSubscription(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/subscription", null, true, true);
            return new OrganizationSubscriptionResponse(r);
        });
    }
    getLicense(id, installationId) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("GET", "/organizations/" + id + "/license?installationId=" + installationId, null, true, true);
        });
    }
    getAutoEnrollStatus(identifier) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + identifier + "/auto-enroll-status", null, true, true);
            return new OrganizationAutoEnrollStatusResponse(r);
        });
    }
    create(request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations", request, true, true);
            // Forcing a sync will notify organization service that they need to repull
            yield this.syncService.fullSync(true);
            return new OrganizationResponse(r);
        });
    }
    createLicense(data) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/licenses/self-hosted", data, true, true);
            return new OrganizationResponse(r);
        });
    }
    save(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + id, request, true, true);
            const data = new OrganizationResponse(r);
            yield this.syncService.fullSync(true);
            return data;
        });
    }
    updatePayment(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/payment", request, true, false);
        });
    }
    upgrade(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/upgrade", request, true, true);
            return new PaymentResponse(r);
        });
    }
    updatePasswordManagerSeats(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/subscription", request, true, false);
        });
    }
    updateSecretsManagerSubscription(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/sm-subscription", request, true, false);
        });
    }
    updateSeats(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/seat", request, true, true);
            return new PaymentResponse(r);
        });
    }
    updateStorage(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/storage", request, true, true);
            return new PaymentResponse(r);
        });
    }
    verifyBank(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/" + id + "/verify-bank", request, true, false);
        });
    }
    cancel(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/cancel", null, true, false);
        });
    }
    reinstate(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + id + "/reinstate", null, true, false);
        });
    }
    leave(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/" + id + "/leave", null, true, false);
            yield this.syncService.fullSync(true);
        });
    }
    delete(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("DELETE", "/organizations/" + id, request, true, false);
            yield this.syncService.fullSync(true);
        });
    }
    updateLicense(id, data) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/licenses/self-hosted/" + id, data, true, false);
        });
    }
    importDirectory(organizationId, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/organizations/" + organizationId + "/import", request, true, false);
        });
    }
    getOrCreateApiKey(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/api-key", request, true, true);
            return new ApiKeyResponse(r);
        });
    }
    getApiKeyInformation(id, organizationApiKeyType = null) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const uri = organizationApiKeyType === null
                ? "/organizations/" + id + "/api-key-information"
                : "/organizations/" + id + "/api-key-information/" + organizationApiKeyType;
            const r = yield this.apiService.send("GET", uri, null, true, true);
            return new ListResponse(r, OrganizationApiKeyInformationResponse);
        });
    }
    rotateApiKey(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/rotate-api-key", request, true, true);
            return new ApiKeyResponse(r);
        });
    }
    getTaxInfo(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/tax", null, true, true);
            return new TaxInfoResponse(r);
        });
    }
    updateTaxInfo(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            // Can't broadcast anything because the response doesn't have content
            return this.apiService.send("PUT", "/organizations/" + id + "/tax", request, true, false);
        });
    }
    getKeys(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/keys", null, true, true);
            return new OrganizationKeysResponse(r);
        });
    }
    updateKeys(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/keys", request, true, true);
            // Not broadcasting anything because data on this response doesn't correspond to `Organization`
            return new OrganizationKeysResponse(r);
        });
    }
    getSso(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/sso", null, true, true);
            return new OrganizationSsoResponse(r);
        });
    }
    updateSso(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/sso", request, true, true);
            // Not broadcasting anything because data on this response doesn't correspond to `Organization`
            return new OrganizationSsoResponse(r);
        });
    }
    selfHostedSyncLicense(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/licenses/self-hosted/" + id + "/sync/", null, true, false);
        });
    }
    subscribeToSecretsManager(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + id + "/subscribe-secrets-manager", request, true, true);
            return new ProfileOrganizationResponse(r);
        });
    }
    updateCollectionManagement(id, request) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + id + "/collection-management", request, true, true);
            const data = new OrganizationResponse(r);
            yield this.syncService.fullSync(true);
            return data;
        });
    }
    risksSubscriptionFailure(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + id + "/risks-subscription-failure", null, true, true);
            return new OrganizationRisksSubscriptionFailureResponse(r);
        });
    }
    enableCollectionEnhancements(id) {
        return organization_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/organizations/" + id + "/enable-collection-enhancements", null, true, false);
            yield this.syncService.fullSync(true);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/abstractions/organization/organization.service.abstraction.ts


function canAccessVaultTab(org) {
    return org.canViewAssignedCollections || org.canViewAllCollections;
}
function canAccessSettingsTab(org) {
    return (org.isOwner ||
        org.canManagePolicies ||
        org.canManageSso ||
        org.canManageScim ||
        org.canAccessImportExport ||
        org.canManageDeviceApprovals);
}
function canAccessMembersTab(org) {
    return org.canManageUsers || org.canManageUsersPassword;
}
function canAccessGroupsTab(org) {
    return org.canManageGroups;
}
function canAccessReportingTab(org) {
    return org.canAccessReports || org.canAccessEventLogs;
}
function canAccessBillingTab(org) {
    return org.isOwner;
}
function canAccessOrgAdmin(org) {
    return (canAccessMembersTab(org) ||
        canAccessGroupsTab(org) ||
        canAccessReportingTab(org) ||
        canAccessBillingTab(org) ||
        canAccessSettingsTab(org) ||
        canAccessVaultTab(org));
}
function getOrganizationById(id) {
    return map((orgs) => orgs.find((o) => o.id === id));
}
function canAccessAdmin(i18nService) {
    return map((orgs) => orgs.filter(canAccessOrgAdmin).sort(Utils.getSortFunction(i18nService, "name")));
}
/**
 * @deprecated
 * To be removed after Flexible Collections.
 **/
function canAccessImportExport(i18nService) {
    return map((orgs) => orgs
        .filter((org) => org.canAccessImportExport)
        .sort(Utils.getSortFunction(i18nService, "name")));
}
function canAccessImport(i18nService) {
    return map((orgs) => orgs
        .filter((org) => org.canAccessImportExport || (org.canCreateNewCollections && org.flexibleCollections))
        .sort(Utils.getSortFunction(i18nService, "name")));
}
/**
 * Returns `true` if a user is a member of an organization (rather than only being a ProviderUser)
 * @deprecated Use organizationService.memberOrganizations$ instead
 */
function isMember(org) {
    return org.isMember;
}
class OrganizationService {
}
class InternalOrganizationServiceAbstraction extends (/* unused pure expression or super */ null && (OrganizationService)) {
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/organization-api-key-type.enum.ts
var OrganizationApiKeyType;
(function (OrganizationApiKeyType) {
    OrganizationApiKeyType[OrganizationApiKeyType["Default"] = 0] = "Default";
    OrganizationApiKeyType[OrganizationApiKeyType["BillingSync"] = 1] = "BillingSync";
    OrganizationApiKeyType[OrganizationApiKeyType["Scim"] = 2] = "Scim";
})(OrganizationApiKeyType || (OrganizationApiKeyType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/organization-connection-type.enum.ts
var OrganizationConnectionType;
(function (OrganizationConnectionType) {
    OrganizationConnectionType[OrganizationConnectionType["CloudBillingSync"] = 1] = "CloudBillingSync";
    OrganizationConnectionType[OrganizationConnectionType["Scim"] = 2] = "Scim";
})(OrganizationConnectionType || (OrganizationConnectionType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/organization-user-status-type.enum.ts
var OrganizationUserStatusType;
(function (OrganizationUserStatusType) {
    OrganizationUserStatusType[OrganizationUserStatusType["Invited"] = 0] = "Invited";
    OrganizationUserStatusType[OrganizationUserStatusType["Accepted"] = 1] = "Accepted";
    OrganizationUserStatusType[OrganizationUserStatusType["Confirmed"] = 2] = "Confirmed";
    OrganizationUserStatusType[OrganizationUserStatusType["Revoked"] = -1] = "Revoked";
})(OrganizationUserStatusType || (OrganizationUserStatusType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/organization-user-type.enum.ts
var OrganizationUserType;
(function (OrganizationUserType) {
    OrganizationUserType[OrganizationUserType["Owner"] = 0] = "Owner";
    OrganizationUserType[OrganizationUserType["Admin"] = 1] = "Admin";
    OrganizationUserType[OrganizationUserType["User"] = 2] = "User";
    /**
     * @deprecated
     * This is deprecated with the introduction of Flexible Collections.
     */
    OrganizationUserType[OrganizationUserType["Manager"] = 3] = "Manager";
    OrganizationUserType[OrganizationUserType["Custom"] = 4] = "Custom";
})(OrganizationUserType || (OrganizationUserType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/policy-type.enum.ts
var policy_type_enum_PolicyType;
(function (PolicyType) {
    PolicyType[PolicyType["TwoFactorAuthentication"] = 0] = "TwoFactorAuthentication";
    PolicyType[PolicyType["MasterPassword"] = 1] = "MasterPassword";
    PolicyType[PolicyType["PasswordGenerator"] = 2] = "PasswordGenerator";
    PolicyType[PolicyType["SingleOrg"] = 3] = "SingleOrg";
    PolicyType[PolicyType["RequireSso"] = 4] = "RequireSso";
    PolicyType[PolicyType["PersonalOwnership"] = 5] = "PersonalOwnership";
    PolicyType[PolicyType["DisableSend"] = 6] = "DisableSend";
    PolicyType[PolicyType["SendOptions"] = 7] = "SendOptions";
    PolicyType[PolicyType["ResetPassword"] = 8] = "ResetPassword";
    PolicyType[PolicyType["MaximumVaultTimeout"] = 9] = "MaximumVaultTimeout";
    PolicyType[PolicyType["DisablePersonalVaultExport"] = 10] = "DisablePersonalVaultExport";
    PolicyType[PolicyType["ActivateAutofill"] = 11] = "ActivateAutofill";
})(policy_type_enum_PolicyType || (policy_type_enum_PolicyType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/provider-type.enum.ts
var ProviderType;
(function (ProviderType) {
    ProviderType[ProviderType["Msp"] = 0] = "Msp";
    ProviderType[ProviderType["Reseller"] = 1] = "Reseller";
})(ProviderType || (ProviderType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/provider-user-status-type.enum.ts
var ProviderUserStatusType;
(function (ProviderUserStatusType) {
    ProviderUserStatusType[ProviderUserStatusType["Invited"] = 0] = "Invited";
    ProviderUserStatusType[ProviderUserStatusType["Accepted"] = 1] = "Accepted";
    ProviderUserStatusType[ProviderUserStatusType["Confirmed"] = 2] = "Confirmed";
    ProviderUserStatusType[ProviderUserStatusType["Revoked"] = -1] = "Revoked";
})(ProviderUserStatusType || (ProviderUserStatusType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/provider-user-type.enum.ts
var ProviderUserType;
(function (ProviderUserType) {
    ProviderUserType[ProviderUserType["ProviderAdmin"] = 0] = "ProviderAdmin";
    ProviderUserType[ProviderUserType["ServiceUser"] = 1] = "ServiceUser";
})(ProviderUserType || (ProviderUserType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/scim-provider-type.enum.ts
var ScimProviderType;
(function (ScimProviderType) {
    ScimProviderType[ScimProviderType["Default"] = 0] = "Default";
    ScimProviderType[ScimProviderType["AzureAd"] = 1] = "AzureAd";
    ScimProviderType[ScimProviderType["Okta"] = 2] = "Okta";
    ScimProviderType[ScimProviderType["OneLogin"] = 3] = "OneLogin";
    ScimProviderType[ScimProviderType["JumpCloud"] = 4] = "JumpCloud";
    ScimProviderType[ScimProviderType["GoogleWorkspace"] = 5] = "GoogleWorkspace";
    ScimProviderType[ScimProviderType["Rippling"] = 6] = "Rippling";
})(ScimProviderType || (ScimProviderType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/enums/index.ts










;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/organization.ts

class Organization {
    constructor(obj) {
        if (obj == null) {
            return;
        }
        this.id = obj.id;
        this.name = obj.name;
        this.status = obj.status;
        this.type = obj.type;
        this.enabled = obj.enabled;
        this.usePolicies = obj.usePolicies;
        this.useGroups = obj.useGroups;
        this.useDirectory = obj.useDirectory;
        this.useEvents = obj.useEvents;
        this.useTotp = obj.useTotp;
        this.use2fa = obj.use2fa;
        this.useApi = obj.useApi;
        this.useSso = obj.useSso;
        this.useKeyConnector = obj.useKeyConnector;
        this.useScim = obj.useScim;
        this.useCustomPermissions = obj.useCustomPermissions;
        this.useResetPassword = obj.useResetPassword;
        this.useSecretsManager = obj.useSecretsManager;
        this.usePasswordManager = obj.usePasswordManager;
        this.useActivateAutofillPolicy = obj.useActivateAutofillPolicy;
        this.selfHost = obj.selfHost;
        this.usersGetPremium = obj.usersGetPremium;
        this.seats = obj.seats;
        this.maxCollections = obj.maxCollections;
        this.maxStorageGb = obj.maxStorageGb;
        this.ssoBound = obj.ssoBound;
        this.identifier = obj.identifier;
        this.permissions = obj.permissions;
        this.resetPasswordEnrolled = obj.resetPasswordEnrolled;
        this.userId = obj.userId;
        this.hasPublicAndPrivateKeys = obj.hasPublicAndPrivateKeys;
        this.providerId = obj.providerId;
        this.providerName = obj.providerName;
        this.providerType = obj.providerType;
        this.isProviderUser = obj.isProviderUser;
        this.isMember = obj.isMember;
        this.familySponsorshipFriendlyName = obj.familySponsorshipFriendlyName;
        this.familySponsorshipAvailable = obj.familySponsorshipAvailable;
        this.planProductType = obj.planProductType;
        this.keyConnectorEnabled = obj.keyConnectorEnabled;
        this.keyConnectorUrl = obj.keyConnectorUrl;
        this.familySponsorshipLastSyncDate = obj.familySponsorshipLastSyncDate;
        this.familySponsorshipValidUntil = obj.familySponsorshipValidUntil;
        this.familySponsorshipToDelete = obj.familySponsorshipToDelete;
        this.accessSecretsManager = obj.accessSecretsManager;
        this.limitCollectionCreationDeletion = obj.limitCollectionCreationDeletion;
        this.allowAdminAccessToAllCollectionItems = obj.allowAdminAccessToAllCollectionItems;
        this.flexibleCollections = obj.flexibleCollections;
    }
    get canAccess() {
        if (this.isOwner) {
            return true;
        }
        return this.enabled && this.status === OrganizationUserStatusType.Confirmed;
    }
    /**
     * Whether a user has Manager permissions or greater
     *
     * @deprecated
     * This is deprecated with the introduction of Flexible Collections.
     */
    get isManager() {
        return this.type === OrganizationUserType.Manager || this.isAdmin;
    }
    /**
     * Whether a user has Admin permissions or greater
     */
    get isAdmin() {
        return this.type === OrganizationUserType.Admin || this.isOwner;
    }
    /**
     * Whether a user has Owner permissions (including ProviderUsers)
     */
    get isOwner() {
        return this.type === OrganizationUserType.Owner || this.isProviderUser;
    }
    get canAccessEventLogs() {
        return (this.isAdmin || this.permissions.accessEventLogs) && this.useEvents;
    }
    get canAccessImportExport() {
        return this.isAdmin || this.permissions.accessImportExport;
    }
    get canAccessReports() {
        return this.isAdmin || this.permissions.accessReports;
    }
    get canCreateNewCollections() {
        if (this.flexibleCollections) {
            return (!this.limitCollectionCreationDeletion ||
                this.isAdmin ||
                this.permissions.createNewCollections);
        }
        return this.isManager || this.permissions.createNewCollections;
    }
    get canEditAnyCollection() {
        return this.isAdmin || this.permissions.editAnyCollection;
    }
    get canUseAdminCollections() {
        return this.canEditAnyCollection;
    }
    get canDeleteAnyCollection() {
        return this.isAdmin || this.permissions.deleteAnyCollection;
    }
    get canViewAllCollections() {
        return this.canEditAnyCollection || this.canDeleteAnyCollection;
    }
    /**
     * @deprecated
     * This is deprecated with the introduction of Flexible Collections.
     * This will always return false if FlexibleCollections flag is on.
     */
    get canEditAssignedCollections() {
        return this.isManager || this.permissions.editAssignedCollections;
    }
    /**
     * @deprecated
     * This is deprecated with the introduction of Flexible Collections.
     * This will always return false if FlexibleCollections flag is on.
     */
    get canDeleteAssignedCollections() {
        return this.isManager || this.permissions.deleteAssignedCollections;
    }
    /**
     * @deprecated
     * This is deprecated with the introduction of Flexible Collections.
     * This will always return false if FlexibleCollections flag is on.
     */
    get canViewAssignedCollections() {
        return this.canDeleteAssignedCollections || this.canEditAssignedCollections;
    }
    get canManageGroups() {
        return (this.isAdmin || this.permissions.manageGroups) && this.useGroups;
    }
    get canManageSso() {
        return (this.isAdmin || this.permissions.manageSso) && this.useSso;
    }
    get canManageDomainVerification() {
        return (this.isAdmin || this.permissions.manageSso) && this.useSso;
    }
    get canManageScim() {
        return (this.isAdmin || this.permissions.manageScim) && this.useScim;
    }
    get canManagePolicies() {
        return (this.isAdmin || this.permissions.managePolicies) && this.usePolicies;
    }
    get canManageUsers() {
        return this.isAdmin || this.permissions.manageUsers;
    }
    get canManageUsersPassword() {
        return this.isAdmin || this.permissions.manageResetPassword;
    }
    get canManageDeviceApprovals() {
        return (this.isAdmin || this.permissions.manageResetPassword) && this.useSso;
    }
    get isExemptFromPolicies() {
        return this.canManagePolicies;
    }
    get canViewSubscription() {
        if (this.canEditSubscription) {
            return true;
        }
        return this.hasProvider && this.providerType === ProviderType.Msp
            ? this.isProviderUser
            : this.isOwner;
    }
    get canEditSubscription() {
        return this.hasProvider ? this.isProviderUser : this.isOwner;
    }
    get canEditPaymentMethods() {
        return this.canEditSubscription;
    }
    get canViewBillingHistory() {
        return this.canEditSubscription;
    }
    get hasProvider() {
        return this.providerId != null || this.providerName != null;
    }
    get hasReseller() {
        return this.hasProvider && this.providerType === ProviderType.Reseller;
    }
    get canAccessSecretsManager() {
        return this.useSecretsManager && this.accessSecretsManager;
    }
    get isFreeOrg() {
        // return true if organization needs to be upgraded from a free org
        return !this.useTotp;
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new Organization(), json, {
            familySponsorshipLastSyncDate: new Date(json.familySponsorshipLastSyncDate),
            familySponsorshipValidUntil: new Date(json.familySponsorshipValidUntil),
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/organization/organization.service.ts
var organization_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class organization_service_OrganizationService {
    constructor(stateService) {
        this.stateService = stateService;
        this._organizations = new external_rxjs_namespaceObject.BehaviorSubject([]);
        this.organizations$ = this._organizations.asObservable();
        this.memberOrganizations$ = this.organizations$.pipe((0,external_rxjs_namespaceObject.map)((orgs) => orgs.filter(isMember)));
        this.stateService.activeAccountUnlocked$
            .pipe((0,external_rxjs_namespaceObject.concatMap)((unlocked) => organization_service_awaiter(this, void 0, void 0, function* () {
            if (!unlocked) {
                this._organizations.next([]);
                return;
            }
            const data = yield this.stateService.getOrganizations();
            this.updateObservables(data);
        })))
            .subscribe();
    }
    get$(id) {
        return this.organizations$.pipe((0,external_rxjs_namespaceObject.map)((orgs) => orgs.find((o) => o.id === id)));
    }
    getAll(userId) {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            const organizationsMap = yield this.stateService.getOrganizations({ userId: userId });
            return Object.values(organizationsMap || {}).map((o) => new Organization(o));
        });
    }
    canManageSponsorships() {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            const organizations = this._organizations.getValue();
            return organizations.some((o) => o.familySponsorshipAvailable || o.familySponsorshipFriendlyName !== null);
        });
    }
    hasOrganizations() {
        const organizations = this._organizations.getValue();
        return organizations.length > 0;
    }
    upsert(organization) {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            let organizations = yield this.stateService.getOrganizations();
            if (organizations == null) {
                organizations = {};
            }
            organizations[organization.id] = organization;
            yield this.replace(organizations);
        });
    }
    delete(id) {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            const organizations = yield this.stateService.getOrganizations();
            if (organizations == null) {
                return;
            }
            if (organizations[id] == null) {
                return;
            }
            delete organizations[id];
            yield this.replace(organizations);
        });
    }
    get(id) {
        const organizations = this._organizations.getValue();
        return organizations.find((organization) => organization.id === id);
    }
    /**
     * @deprecated For the CLI only
     * @param id id of the organization
     */
    getFromState(id) {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            const organizationsMap = yield this.stateService.getOrganizations();
            const organization = organizationsMap[id];
            if (organization == null) {
                return null;
            }
            return new Organization(organization);
        });
    }
    getByIdentifier(identifier) {
        const organizations = this._organizations.getValue();
        return organizations.find((organization) => organization.identifier === identifier);
    }
    replace(organizations) {
        return organization_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setOrganizations(organizations);
            this.updateObservables(organizations);
        });
    }
    updateObservables(organizationsMap) {
        const organizations = Object.values(organizationsMap || {}).map((o) => new Organization(o));
        this._organizations.next(organizations);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/selection-read-only.response.ts

class SelectionReadOnlyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.readOnly = this.getResponseProperty("ReadOnly");
        this.hidePasswords = this.getResponseProperty("HidePasswords");
        this.manage = this.getResponseProperty("Manage");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/abstractions/organization-user/responses/organization-user.response.ts



class OrganizationUserResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.collections = [];
        this.groups = [];
        this.id = this.getResponseProperty("Id");
        this.userId = this.getResponseProperty("UserId");
        this.type = this.getResponseProperty("Type");
        this.status = this.getResponseProperty("Status");
        this.permissions = new PermissionsApi(this.getResponseProperty("Permissions"));
        this.externalId = this.getResponseProperty("ExternalId");
        this.accessAll = this.getResponseProperty("AccessAll");
        this.accessSecretsManager = this.getResponseProperty("AccessSecretsManager");
        this.resetPasswordEnrolled = this.getResponseProperty("ResetPasswordEnrolled");
        this.hasMasterPassword = this.getResponseProperty("HasMasterPassword");
        const collections = this.getResponseProperty("Collections");
        if (collections != null) {
            this.collections = collections.map((c) => new SelectionReadOnlyResponse(c));
        }
        const groups = this.getResponseProperty("Groups");
        if (groups != null) {
            this.groups = groups;
        }
    }
}
class OrganizationUserUserDetailsResponse extends OrganizationUserResponse {
    constructor(response) {
        var _a;
        super(response);
        this.name = this.getResponseProperty("Name");
        this.email = this.getResponseProperty("Email");
        this.avatarColor = this.getResponseProperty("AvatarColor");
        this.twoFactorEnabled = this.getResponseProperty("TwoFactorEnabled");
        this.usesKeyConnector = (_a = this.getResponseProperty("UsesKeyConnector")) !== null && _a !== void 0 ? _a : false;
    }
}
class OrganizationUserDetailsResponse extends OrganizationUserResponse {
    constructor(response) {
        super(response);
    }
}
class OrganizationUserResetPasswordDetailsResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.kdf = this.getResponseProperty("Kdf");
        this.kdfIterations = this.getResponseProperty("KdfIterations");
        this.kdfMemory = this.getResponseProperty("KdfMemory");
        this.kdfParallelism = this.getResponseProperty("KdfParallelism");
        this.resetPasswordKey = this.getResponseProperty("ResetPasswordKey");
        this.encryptedPrivateKey = this.getResponseProperty("EncryptedPrivateKey");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/abstractions/organization-user/responses/organization-user-bulk.response.ts

class OrganizationUserBulkResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.error = this.getResponseProperty("Error");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/abstractions/organization-user/responses/organization-user-bulk-public-key.response.ts

class OrganizationUserBulkPublicKeyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.userId = this.getResponseProperty("UserId");
        this.key = this.getResponseProperty("Key");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/organization-user/requests/organization-user-bulk.request.ts
class OrganizationUserBulkRequest {
    constructor(ids) {
        this.ids = ids == null ? [] : ids;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/organization-user/organization-user.service.implementation.ts
var organization_user_service_implementation_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class OrganizationUserServiceImplementation {
    constructor(apiService) {
        this.apiService = apiService;
    }
    getOrganizationUser(organizationId, id, options) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const params = new URLSearchParams();
            if (options === null || options === void 0 ? void 0 : options.includeGroups) {
                params.set("includeGroups", "true");
            }
            const r = yield this.apiService.send("GET", `/organizations/${organizationId}/users/${id}?${params.toString()}`, null, true, true);
            return new OrganizationUserDetailsResponse(r);
        });
    }
    getOrganizationUserGroups(organizationId, id) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + organizationId + "/users/" + id + "/groups", null, true, true);
            return r;
        });
    }
    getAllUsers(organizationId, options) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const params = new URLSearchParams();
            if (options === null || options === void 0 ? void 0 : options.includeCollections) {
                params.set("includeCollections", "true");
            }
            if (options === null || options === void 0 ? void 0 : options.includeGroups) {
                params.set("includeGroups", "true");
            }
            const r = yield this.apiService.send("GET", `/organizations/${organizationId}/users?${params.toString()}`, null, true, true);
            return new ListResponse(r, OrganizationUserUserDetailsResponse);
        });
    }
    getOrganizationUserResetPasswordDetails(organizationId, id) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + organizationId + "/users/" + id + "/reset-password-details", null, true, true);
            return new OrganizationUserResetPasswordDetailsResponse(r);
        });
    }
    postOrganizationUserInvite(organizationId, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/invite", request, true, false);
    }
    postOrganizationUserReinvite(organizationId, id) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/reinvite", null, true, false);
    }
    postManyOrganizationUserReinvite(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/reinvite", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    postOrganizationUserAcceptInit(organizationId, id, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/accept-init", request, true, false);
    }
    postOrganizationUserAccept(organizationId, id, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/accept", request, true, false);
    }
    postOrganizationUserConfirm(organizationId, id, request) {
        return this.apiService.send("POST", "/organizations/" + organizationId + "/users/" + id + "/confirm", request, true, false);
    }
    postOrganizationUsersPublicKey(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/public-keys", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkPublicKeyResponse);
        });
    }
    postOrganizationUserBulkConfirm(organizationId, request) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/organizations/" + organizationId + "/users/confirm", request, true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    putOrganizationUserBulkEnableSecretsManager(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("PUT", "/organizations/" + organizationId + "/users/enable-secrets-manager", new OrganizationUserBulkRequest(ids), true, false);
        });
    }
    putOrganizationUser(organizationId, id, request) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id, request, true, false);
    }
    putOrganizationUserGroups(organizationId, id, request) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id + "/groups", request, true, false);
    }
    putOrganizationUserResetPasswordEnrollment(organizationId, userId, request) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + userId + "/reset-password-enrollment", request, true, false);
    }
    putOrganizationUserResetPassword(organizationId, id, request) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id + "/reset-password", request, true, false);
    }
    deleteOrganizationUser(organizationId, id) {
        return this.apiService.send("DELETE", "/organizations/" + organizationId + "/users/" + id, null, true, false);
    }
    deleteManyOrganizationUsers(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("DELETE", "/organizations/" + organizationId + "/users", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    revokeOrganizationUser(organizationId, id) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id + "/revoke", null, true, false);
    }
    revokeManyOrganizationUsers(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + organizationId + "/users/revoke", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
    restoreOrganizationUser(organizationId, id) {
        return this.apiService.send("PUT", "/organizations/" + organizationId + "/users/" + id + "/restore", null, true, false);
    }
    restoreManyOrganizationUsers(organizationId, ids) {
        return organization_user_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + organizationId + "/users/restore", new OrganizationUserBulkRequest(ids), true, true);
            return new ListResponse(r, OrganizationUserBulkResponse);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/enums/client-type.enum.ts
var ClientType;
(function (ClientType) {
    ClientType["Web"] = "web";
    ClientType["Browser"] = "browser";
    ClientType["Desktop"] = "desktop";
    // Mobile = "mobile",
    ClientType["Cli"] = "cli";
    // DirectoryConnector = "connector",
})(ClientType || (ClientType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/device-type.enum.ts
var DeviceType;
(function (DeviceType) {
    DeviceType[DeviceType["Android"] = 0] = "Android";
    DeviceType[DeviceType["iOS"] = 1] = "iOS";
    DeviceType[DeviceType["ChromeExtension"] = 2] = "ChromeExtension";
    DeviceType[DeviceType["FirefoxExtension"] = 3] = "FirefoxExtension";
    DeviceType[DeviceType["OperaExtension"] = 4] = "OperaExtension";
    DeviceType[DeviceType["EdgeExtension"] = 5] = "EdgeExtension";
    DeviceType[DeviceType["WindowsDesktop"] = 6] = "WindowsDesktop";
    DeviceType[DeviceType["MacOsDesktop"] = 7] = "MacOsDesktop";
    DeviceType[DeviceType["LinuxDesktop"] = 8] = "LinuxDesktop";
    DeviceType[DeviceType["ChromeBrowser"] = 9] = "ChromeBrowser";
    DeviceType[DeviceType["FirefoxBrowser"] = 10] = "FirefoxBrowser";
    DeviceType[DeviceType["OperaBrowser"] = 11] = "OperaBrowser";
    DeviceType[DeviceType["EdgeBrowser"] = 12] = "EdgeBrowser";
    DeviceType[DeviceType["IEBrowser"] = 13] = "IEBrowser";
    DeviceType[DeviceType["UnknownBrowser"] = 14] = "UnknownBrowser";
    DeviceType[DeviceType["AndroidAmazon"] = 15] = "AndroidAmazon";
    DeviceType[DeviceType["UWP"] = 16] = "UWP";
    DeviceType[DeviceType["SafariBrowser"] = 17] = "SafariBrowser";
    DeviceType[DeviceType["VivaldiBrowser"] = 18] = "VivaldiBrowser";
    DeviceType[DeviceType["VivaldiExtension"] = 19] = "VivaldiExtension";
    DeviceType[DeviceType["SafariExtension"] = 20] = "SafariExtension";
    DeviceType[DeviceType["SDK"] = 21] = "SDK";
    DeviceType[DeviceType["Server"] = 22] = "Server";
    DeviceType[DeviceType["WindowsCLI"] = 23] = "WindowsCLI";
    DeviceType[DeviceType["MacOsCLI"] = 24] = "MacOsCLI";
    DeviceType[DeviceType["LinuxCLI"] = 25] = "LinuxCLI";
})(DeviceType || (DeviceType = {}));
const MobileDeviceTypes = new Set([
    DeviceType.Android,
    DeviceType.iOS,
    DeviceType.AndroidAmazon,
]);
const DesktopDeviceTypes = new Set([
    DeviceType.WindowsDesktop,
    DeviceType.MacOsDesktop,
    DeviceType.LinuxDesktop,
    DeviceType.UWP,
    DeviceType.WindowsCLI,
    DeviceType.MacOsCLI,
    DeviceType.LinuxCLI,
]);

;// CONCATENATED MODULE: ../../libs/common/src/enums/event-system-user.enum.ts
// Note: the enum key is used to describe the EventSystemUser in the UI. Be careful about changing it.
var EventSystemUser;
(function (EventSystemUser) {
    EventSystemUser[EventSystemUser["SCIM"] = 1] = "SCIM";
    EventSystemUser[EventSystemUser["DomainVerification"] = 2] = "DomainVerification";
})(EventSystemUser || (EventSystemUser = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/event-type.enum.ts
// Increment by 100 for each new set of events
var EventType;
(function (EventType) {
    EventType[EventType["User_LoggedIn"] = 1000] = "User_LoggedIn";
    EventType[EventType["User_ChangedPassword"] = 1001] = "User_ChangedPassword";
    EventType[EventType["User_Updated2fa"] = 1002] = "User_Updated2fa";
    EventType[EventType["User_Disabled2fa"] = 1003] = "User_Disabled2fa";
    EventType[EventType["User_Recovered2fa"] = 1004] = "User_Recovered2fa";
    EventType[EventType["User_FailedLogIn"] = 1005] = "User_FailedLogIn";
    EventType[EventType["User_FailedLogIn2fa"] = 1006] = "User_FailedLogIn2fa";
    EventType[EventType["User_ClientExportedVault"] = 1007] = "User_ClientExportedVault";
    EventType[EventType["User_UpdatedTempPassword"] = 1008] = "User_UpdatedTempPassword";
    EventType[EventType["User_MigratedKeyToKeyConnector"] = 1009] = "User_MigratedKeyToKeyConnector";
    EventType[EventType["User_RequestedDeviceApproval"] = 1010] = "User_RequestedDeviceApproval";
    EventType[EventType["Cipher_Created"] = 1100] = "Cipher_Created";
    EventType[EventType["Cipher_Updated"] = 1101] = "Cipher_Updated";
    EventType[EventType["Cipher_Deleted"] = 1102] = "Cipher_Deleted";
    EventType[EventType["Cipher_AttachmentCreated"] = 1103] = "Cipher_AttachmentCreated";
    EventType[EventType["Cipher_AttachmentDeleted"] = 1104] = "Cipher_AttachmentDeleted";
    EventType[EventType["Cipher_Shared"] = 1105] = "Cipher_Shared";
    EventType[EventType["Cipher_UpdatedCollections"] = 1106] = "Cipher_UpdatedCollections";
    EventType[EventType["Cipher_ClientViewed"] = 1107] = "Cipher_ClientViewed";
    EventType[EventType["Cipher_ClientToggledPasswordVisible"] = 1108] = "Cipher_ClientToggledPasswordVisible";
    EventType[EventType["Cipher_ClientToggledHiddenFieldVisible"] = 1109] = "Cipher_ClientToggledHiddenFieldVisible";
    EventType[EventType["Cipher_ClientToggledCardCodeVisible"] = 1110] = "Cipher_ClientToggledCardCodeVisible";
    EventType[EventType["Cipher_ClientCopiedPassword"] = 1111] = "Cipher_ClientCopiedPassword";
    EventType[EventType["Cipher_ClientCopiedHiddenField"] = 1112] = "Cipher_ClientCopiedHiddenField";
    EventType[EventType["Cipher_ClientCopiedCardCode"] = 1113] = "Cipher_ClientCopiedCardCode";
    EventType[EventType["Cipher_ClientAutofilled"] = 1114] = "Cipher_ClientAutofilled";
    EventType[EventType["Cipher_SoftDeleted"] = 1115] = "Cipher_SoftDeleted";
    EventType[EventType["Cipher_Restored"] = 1116] = "Cipher_Restored";
    EventType[EventType["Cipher_ClientToggledCardNumberVisible"] = 1117] = "Cipher_ClientToggledCardNumberVisible";
    EventType[EventType["Cipher_ClientToggledTOTPSeedVisible"] = 1118] = "Cipher_ClientToggledTOTPSeedVisible";
    EventType[EventType["Collection_Created"] = 1300] = "Collection_Created";
    EventType[EventType["Collection_Updated"] = 1301] = "Collection_Updated";
    EventType[EventType["Collection_Deleted"] = 1302] = "Collection_Deleted";
    EventType[EventType["Group_Created"] = 1400] = "Group_Created";
    EventType[EventType["Group_Updated"] = 1401] = "Group_Updated";
    EventType[EventType["Group_Deleted"] = 1402] = "Group_Deleted";
    EventType[EventType["OrganizationUser_Invited"] = 1500] = "OrganizationUser_Invited";
    EventType[EventType["OrganizationUser_Confirmed"] = 1501] = "OrganizationUser_Confirmed";
    EventType[EventType["OrganizationUser_Updated"] = 1502] = "OrganizationUser_Updated";
    EventType[EventType["OrganizationUser_Removed"] = 1503] = "OrganizationUser_Removed";
    EventType[EventType["OrganizationUser_UpdatedGroups"] = 1504] = "OrganizationUser_UpdatedGroups";
    EventType[EventType["OrganizationUser_UnlinkedSso"] = 1505] = "OrganizationUser_UnlinkedSso";
    EventType[EventType["OrganizationUser_ResetPassword_Enroll"] = 1506] = "OrganizationUser_ResetPassword_Enroll";
    EventType[EventType["OrganizationUser_ResetPassword_Withdraw"] = 1507] = "OrganizationUser_ResetPassword_Withdraw";
    EventType[EventType["OrganizationUser_AdminResetPassword"] = 1508] = "OrganizationUser_AdminResetPassword";
    EventType[EventType["OrganizationUser_ResetSsoLink"] = 1509] = "OrganizationUser_ResetSsoLink";
    EventType[EventType["OrganizationUser_FirstSsoLogin"] = 1510] = "OrganizationUser_FirstSsoLogin";
    EventType[EventType["OrganizationUser_Revoked"] = 1511] = "OrganizationUser_Revoked";
    EventType[EventType["OrganizationUser_Restored"] = 1512] = "OrganizationUser_Restored";
    EventType[EventType["OrganizationUser_ApprovedAuthRequest"] = 1513] = "OrganizationUser_ApprovedAuthRequest";
    EventType[EventType["OrganizationUser_RejectedAuthRequest"] = 1514] = "OrganizationUser_RejectedAuthRequest";
    EventType[EventType["Organization_Updated"] = 1600] = "Organization_Updated";
    EventType[EventType["Organization_PurgedVault"] = 1601] = "Organization_PurgedVault";
    EventType[EventType["Organization_ClientExportedVault"] = 1602] = "Organization_ClientExportedVault";
    EventType[EventType["Organization_VaultAccessed"] = 1603] = "Organization_VaultAccessed";
    EventType[EventType["Organization_EnabledSso"] = 1604] = "Organization_EnabledSso";
    EventType[EventType["Organization_DisabledSso"] = 1605] = "Organization_DisabledSso";
    EventType[EventType["Organization_EnabledKeyConnector"] = 1606] = "Organization_EnabledKeyConnector";
    EventType[EventType["Organization_DisabledKeyConnector"] = 1607] = "Organization_DisabledKeyConnector";
    EventType[EventType["Organization_SponsorshipsSynced"] = 1608] = "Organization_SponsorshipsSynced";
    EventType[EventType["Organization_CollectionManagementUpdated"] = 1609] = "Organization_CollectionManagementUpdated";
    EventType[EventType["Policy_Updated"] = 1700] = "Policy_Updated";
    EventType[EventType["ProviderUser_Invited"] = 1800] = "ProviderUser_Invited";
    EventType[EventType["ProviderUser_Confirmed"] = 1801] = "ProviderUser_Confirmed";
    EventType[EventType["ProviderUser_Updated"] = 1802] = "ProviderUser_Updated";
    EventType[EventType["ProviderUser_Removed"] = 1803] = "ProviderUser_Removed";
    EventType[EventType["ProviderOrganization_Created"] = 1900] = "ProviderOrganization_Created";
    EventType[EventType["ProviderOrganization_Added"] = 1901] = "ProviderOrganization_Added";
    EventType[EventType["ProviderOrganization_Removed"] = 1902] = "ProviderOrganization_Removed";
    EventType[EventType["ProviderOrganization_VaultAccessed"] = 1903] = "ProviderOrganization_VaultAccessed";
    EventType[EventType["OrganizationDomain_Added"] = 2000] = "OrganizationDomain_Added";
    EventType[EventType["OrganizationDomain_Removed"] = 2001] = "OrganizationDomain_Removed";
    EventType[EventType["OrganizationDomain_Verified"] = 2002] = "OrganizationDomain_Verified";
    EventType[EventType["OrganizationDomain_NotVerified"] = 2003] = "OrganizationDomain_NotVerified";
    EventType[EventType["Secret_Retrieved"] = 2100] = "Secret_Retrieved";
})(EventType || (EventType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/http-status-code.enum.ts
/**
 * Hypertext Transfer Protocol (HTTP) response status codes.
 *
 * @see {@link https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}
 * src: https://gist.github.com/RWOverdijk/6cef816cfdf5722228e01cc05fd4b094
 */
var HttpStatusCode;
(function (HttpStatusCode) {
    /**
     * The server has received the request headers and the client should proceed to send the request body
     * (in the case of a request for which a body needs to be sent; for example, a POST request).
     * Sending a large request body to a server after a request has been rejected for inappropriate headers would be inefficient.
     * To have a server check the request's headers, a client must send Expect: 100-continue as a header in its initial request
     * and receive a 100 Continue status code in response before sending the body. The response 417 Expectation Failed indicates the request should not be continued.
     */
    HttpStatusCode[HttpStatusCode["Continue"] = 100] = "Continue";
    /**
     * The requester has asked the server to switch protocols and the server has agreed to do so.
     */
    HttpStatusCode[HttpStatusCode["SwitchingProtocols"] = 101] = "SwitchingProtocols";
    /**
     * A WebDAV request may contain many sub-requests involving file operations, requiring a long time to complete the request.
     * This code indicates that the server has received and is processing the request, but no response is available yet.
     * This prevents the client from timing out and assuming the request was lost.
     */
    HttpStatusCode[HttpStatusCode["Processing"] = 102] = "Processing";
    // **********************************************************************************************************
    // 200s - SUCCESS
    // **********************************************************************************************************
    /**
     * Standard response for successful HTTP requests.
     * The actual response will depend on the request method used.
     * In a GET request, the response will contain an entity corresponding to the requested resource.
     * In a POST request, the response will contain an entity describing or containing the result of the action.
     */
    HttpStatusCode[HttpStatusCode["Ok"] = 200] = "Ok";
    /**
     * The request has been fulfilled, resulting in the creation of a new resource.
     */
    HttpStatusCode[HttpStatusCode["Created"] = 201] = "Created";
    /**
     * The request has been accepted for processing, but the processing has not been completed.
     * The request might or might not be eventually acted upon, and may be disallowed when processing occurs.
     */
    HttpStatusCode[HttpStatusCode["Accepted"] = 202] = "Accepted";
    /**
     * SINCE HTTP/1.1
     * The server is a transforming proxy that received a 200 OK from its origin,
     * but is returning a modified version of the origin's response.
     */
    HttpStatusCode[HttpStatusCode["NonAuthoritativeInformation"] = 203] = "NonAuthoritativeInformation";
    /**
     * The server successfully processed the request and is not returning any content.
     */
    HttpStatusCode[HttpStatusCode["NoContent"] = 204] = "NoContent";
    /**
     * The server successfully processed the request, but is not returning any content.
     * Unlike a 204 response, this response requires that the requester reset the document view.
     */
    HttpStatusCode[HttpStatusCode["ResetContent"] = 205] = "ResetContent";
    /**
     * The server is delivering only part of the resource (byte serving) due to a range header sent by the client.
     * The range header is used by HTTP clients to enable resuming of interrupted downloads,
     * or split a download into multiple simultaneous streams.
     */
    HttpStatusCode[HttpStatusCode["PartialContent"] = 206] = "PartialContent";
    /**
     * The message body that follows is an XML message and can contain a number of separate response codes,
     * depending on how many sub-requests were made.
     */
    HttpStatusCode[HttpStatusCode["MultiStatus"] = 207] = "MultiStatus";
    /**
     * The members of a DAV binding have already been enumerated in a preceding part of the (multistatus) response,
     * and are not being included again.
     */
    HttpStatusCode[HttpStatusCode["AlreadyReported"] = 208] = "AlreadyReported";
    /**
     * The server has fulfilled a request for the resource,
     * and the response is a representation of the result of one or more instance-manipulations applied to the current instance.
     */
    HttpStatusCode[HttpStatusCode["ImUsed"] = 226] = "ImUsed";
    // **********************************************************************************************************
    // 300s - Redirections
    // **********************************************************************************************************
    /**
     * Indicates multiple options for the resource from which the client may choose (via agent-driven content negotiation).
     * For example, this code could be used to present multiple video format options,
     * to list files with different filename extensions, or to suggest word-sense disambiguation.
     */
    HttpStatusCode[HttpStatusCode["MultipleChoices"] = 300] = "MultipleChoices";
    /**
     * This and all future requests should be directed to the given URI.
     */
    HttpStatusCode[HttpStatusCode["MovedPermanently"] = 301] = "MovedPermanently";
    /**
     * This is an example of industry practice contradicting the standard.
     * The HTTP/1.0 specification (RFC 1945) required the client to perform a temporary redirect
     * (the original describing phrase was "Moved Temporarily"), but popular browsers implemented 302
     * with the functionality of a 303 See Other. Therefore, HTTP/1.1 added status codes 303 and 307
     * to distinguish between the two behaviours. However, some Web applications and frameworks
     * use the 302 status code as if it were the 303.
     */
    HttpStatusCode[HttpStatusCode["Found"] = 302] = "Found";
    /**
     * SINCE HTTP/1.1
     * The response to the request can be found under another URI using a GET method.
     * When received in response to a POST (or PUT/DELETE), the client should presume that
     * the server has received the data and should issue a redirect with a separate GET message.
     */
    HttpStatusCode[HttpStatusCode["SeeOther"] = 303] = "SeeOther";
    /**
     * Indicates that the resource has not been modified since the version specified by the request headers If-Modified-Since or If-None-Match.
     * In such case, there is no need to retransmit the resource since the client still has a previously-downloaded copy.
     */
    HttpStatusCode[HttpStatusCode["NotModified"] = 304] = "NotModified";
    /**
     * SINCE HTTP/1.1
     * The requested resource is available only through a proxy, the address for which is provided in the response.
     * Many HTTP clients (such as Mozilla and Internet Explorer) do not correctly handle responses with this status code, primarily for security reasons.
     */
    HttpStatusCode[HttpStatusCode["UseProxy"] = 305] = "UseProxy";
    /**
     * No longer used. Originally meant "Subsequent requests should use the specified proxy."
     */
    HttpStatusCode[HttpStatusCode["SwitchProxy"] = 306] = "SwitchProxy";
    /**
     * SINCE HTTP/1.1
     * In this case, the request should be repeated with another URI; however, future requests should still use the original URI.
     * In contrast to how 302 was historically implemented, the request method is not allowed to be changed when reissuing the original request.
     * For example, a POST request should be repeated using another POST request.
     */
    HttpStatusCode[HttpStatusCode["TemporaryRedirect"] = 307] = "TemporaryRedirect";
    /**
     * The request and all future requests should be repeated using another URI.
     * 307 and 308 parallel the behaviors of 302 and 301, but do not allow the HTTP method to change.
     * So, for example, submitting a form to a permanently redirected resource may continue smoothly.
     */
    HttpStatusCode[HttpStatusCode["PermanentRedirect"] = 308] = "PermanentRedirect";
    // **********************************************************************************************************
    // 400s - Client / User messed up
    // **********************************************************************************************************
    /**
     * The server cannot or will not process the request due to an apparent client error
     * (e.g., malformed request syntax, too large size, invalid request message framing, or deceptive request routing).
     */
    HttpStatusCode[HttpStatusCode["BadRequest"] = 400] = "BadRequest";
    /**
     * Similar to 403 Forbidden, but specifically for use when authentication is required and has failed or has not yet
     * been provided. The response must include a WWW-Authenticate header field containing a challenge applicable to the
     * requested resource. See Basic access authentication and Digest access authentication. 401 semantically means
     * "unauthenticated",i.e. the user does not have the necessary credentials.
     */
    HttpStatusCode[HttpStatusCode["Unauthorized"] = 401] = "Unauthorized";
    /**
     * Reserved for future use. The original intention was that this code might be used as part of some form of digital
     * cash or micro payment scheme, but that has not happened, and this code is not usually used.
     * Google Developers API uses this status if a particular developer has exceeded the daily limit on requests.
     */
    HttpStatusCode[HttpStatusCode["PaymentRequired"] = 402] = "PaymentRequired";
    /**
     * The request was valid, but the server is refusing action.
     * The user might not have the necessary permissions for a resource.
     */
    HttpStatusCode[HttpStatusCode["Forbidden"] = 403] = "Forbidden";
    /**
     * The requested resource could not be found but may be available in the future.
     * Subsequent requests by the client are permissible.
     */
    HttpStatusCode[HttpStatusCode["NotFound"] = 404] = "NotFound";
    /**
     * A request method is not supported for the requested resource;
     * for example, a GET request on a form that requires data to be presented via POST, or a PUT request on a read-only resource.
     */
    HttpStatusCode[HttpStatusCode["MethodNotAllowed"] = 405] = "MethodNotAllowed";
    /**
     * The requested resource is capable of generating only content not acceptable according to the Accept headers sent in the request.
     */
    HttpStatusCode[HttpStatusCode["NotAcceptable"] = 406] = "NotAcceptable";
    /**
     * The client must first authenticate itself with the proxy.
     */
    HttpStatusCode[HttpStatusCode["ProxyAuthenticationRequired"] = 407] = "ProxyAuthenticationRequired";
    /**
     * The server timed out waiting for the request.
     * According to HTTP specifications:
     * "The client did not produce a request within the time that the server was prepared to wait. The client MAY repeat the request without modifications at any later time."
     */
    HttpStatusCode[HttpStatusCode["RequestTimeout"] = 408] = "RequestTimeout";
    /**
     * Indicates that the request could not be processed because of conflict in the request,
     * such as an edit conflict between multiple simultaneous updates.
     */
    HttpStatusCode[HttpStatusCode["Conflict"] = 409] = "Conflict";
    /**
     * Indicates that the resource requested is no longer available and will not be available again.
     * This should be used when a resource has been intentionally removed and the resource should be purged.
     * Upon receiving a 410 status code, the client should not request the resource in the future.
     * Clients such as search engines should remove the resource from their indices.
     * Most use cases do not require clients and search engines to purge the resource, and a "404 Not Found" may be used instead.
     */
    HttpStatusCode[HttpStatusCode["Gone"] = 410] = "Gone";
    /**
     * The request did not specify the length of its content, which is required by the requested resource.
     */
    HttpStatusCode[HttpStatusCode["LengthRequired"] = 411] = "LengthRequired";
    /**
     * The server does not meet one of the preconditions that the requester put on the request.
     */
    HttpStatusCode[HttpStatusCode["PreconditionFailed"] = 412] = "PreconditionFailed";
    /**
     * The request is larger than the server is willing or able to process. Previously called "Request Entity Too Large".
     */
    HttpStatusCode[HttpStatusCode["PayloadTooLarge"] = 413] = "PayloadTooLarge";
    /**
     * The URI provided was too long for the server to process. Often the result of too much data being encoded as a query-string of a GET request,
     * in which case it should be converted to a POST request.
     * Called "Request-URI Too Long" previously.
     */
    HttpStatusCode[HttpStatusCode["UriTooLong"] = 414] = "UriTooLong";
    /**
     * The request entity has a media type which the server or resource does not support.
     * For example, the client uploads an image as image/svg+xml, but the server requires that images use a different format.
     */
    HttpStatusCode[HttpStatusCode["UnsupportedMediaType"] = 415] = "UnsupportedMediaType";
    /**
     * The client has asked for a portion of the file (byte serving), but the server cannot supply that portion.
     * For example, if the client asked for a part of the file that lies beyond the end of the file.
     * Called "Requested Range Not Satisfiable" previously.
     */
    HttpStatusCode[HttpStatusCode["RangeNotSatisfiable"] = 416] = "RangeNotSatisfiable";
    /**
     * The server cannot meet the requirements of the Expect request-header field.
     */
    HttpStatusCode[HttpStatusCode["ExpectationFailed"] = 417] = "ExpectationFailed";
    /**
     * This code was defined in 1998 as one of the traditional IETF April Fools' jokes, in RFC 2324, Hyper Text Coffee Pot Control Protocol,
     * and is not expected to be implemented by actual HTTP servers. The RFC specifies this code should be returned by
     * teapots requested to brew coffee. This HTTP status is used as an Easter egg in some websites, including Google.com.
     */
    HttpStatusCode[HttpStatusCode["IAmATeapot"] = 418] = "IAmATeapot";
    /**
     * The request was directed at a server that is not able to produce a response (for example because a connection reuse).
     */
    HttpStatusCode[HttpStatusCode["MisdirectedRequest"] = 421] = "MisdirectedRequest";
    /**
     * The request was well-formed but was unable to be followed due to semantic errors.
     */
    HttpStatusCode[HttpStatusCode["UnprocessableEntity"] = 422] = "UnprocessableEntity";
    /**
     * The resource that is being accessed is locked.
     */
    HttpStatusCode[HttpStatusCode["Locked"] = 423] = "Locked";
    /**
     * The request failed due to failure of a previous request (e.g., a PROPPATCH).
     */
    HttpStatusCode[HttpStatusCode["FailedDependency"] = 424] = "FailedDependency";
    /**
     * The client should switch to a different protocol such as TLS/1.0, given in the Upgrade header field.
     */
    HttpStatusCode[HttpStatusCode["UpgradeRequired"] = 426] = "UpgradeRequired";
    /**
     * The origin server requires the request to be conditional.
     * Intended to prevent "the 'lost update' problem, where a client
     * GETs a resource's state, modifies it, and PUTs it back to the server,
     * when meanwhile a third party has modified the state on the server, leading to a conflict."
     */
    HttpStatusCode[HttpStatusCode["PreconditionRequired"] = 428] = "PreconditionRequired";
    /**
     * The user has sent too many requests in a given amount of time. Intended for use with rate-limiting schemes.
     */
    HttpStatusCode[HttpStatusCode["TooManyRequests"] = 429] = "TooManyRequests";
    /**
     * The server is unwilling to process the request because either an individual header field,
     * or all the header fields collectively, are too large.
     */
    HttpStatusCode[HttpStatusCode["RequestHeaderFieldsTooLarge"] = 431] = "RequestHeaderFieldsTooLarge";
    /**
     * A server operator has received a legal demand to deny access to a resource or to a set of resources
     * that includes the requested resource. The code 451 was chosen as a reference to the novel Fahrenheit 451.
     */
    HttpStatusCode[HttpStatusCode["UnavailableForLegalReasons"] = 451] = "UnavailableForLegalReasons";
    // **********************************************************************************************************
    // 500s - Server messed up
    // **********************************************************************************************************
    /**
     * A generic error message, given when an unexpected condition was encountered and no more specific message is suitable.
     */
    HttpStatusCode[HttpStatusCode["InternalServerError"] = 500] = "InternalServerError";
    /**
     * The server either does not recognize the request method, or it lacks the ability to fulfill the request.
     * Usually this implies future availability (e.g., a new feature of a web-service API).
     */
    HttpStatusCode[HttpStatusCode["NotImplemented"] = 501] = "NotImplemented";
    /**
     * The server was acting as a gateway or proxy and received an invalid response from the upstream server.
     */
    HttpStatusCode[HttpStatusCode["BadGateway"] = 502] = "BadGateway";
    /**
     * The server is currently unavailable (because it is overloaded or down for maintenance).
     * Generally, this is a temporary state.
     */
    HttpStatusCode[HttpStatusCode["ServiceUnavailable"] = 503] = "ServiceUnavailable";
    /**
     * The server was acting as a gateway or proxy and did not receive a timely response from the upstream server.
     */
    HttpStatusCode[HttpStatusCode["GatewayTimeout"] = 504] = "GatewayTimeout";
    /**
     * The server does not support the HTTP protocol version used in the request
     */
    HttpStatusCode[HttpStatusCode["HttpVersionNotSupported"] = 505] = "HttpVersionNotSupported";
    /**
     * Transparent content negotiation for the request results in a circular reference.
     */
    HttpStatusCode[HttpStatusCode["VariantAlsoNegotiates"] = 506] = "VariantAlsoNegotiates";
    /**
     * The server is unable to store the representation needed to complete the request.
     */
    HttpStatusCode[HttpStatusCode["InsufficientStorage"] = 507] = "InsufficientStorage";
    /**
     * The server detected an infinite loop while processing the request.
     */
    HttpStatusCode[HttpStatusCode["LoopDetected"] = 508] = "LoopDetected";
    /**
     * Further extensions to the request are required for the server to fulfill it.
     */
    HttpStatusCode[HttpStatusCode["NotExtended"] = 510] = "NotExtended";
    /**
     * The client needs to authenticate to gain network access.
     * Intended for use by intercepting proxies used to control access to the network (e.g., "captive portals" used
     * to require agreement to Terms of Service before granting full Internet access via a Wi-Fi hotspot).
     */
    HttpStatusCode[HttpStatusCode["NetworkAuthenticationRequired"] = 511] = "NetworkAuthenticationRequired";
})(HttpStatusCode || (HttpStatusCode = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/native-messaging-version.enum.ts
var NativeMessagingVersion;
(function (NativeMessagingVersion) {
    NativeMessagingVersion[NativeMessagingVersion["One"] = 1] = "One";
    NativeMessagingVersion[NativeMessagingVersion["Latest"] = 1] = "Latest";
})(NativeMessagingVersion || (NativeMessagingVersion = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/notification-type.enum.ts
var NotificationType;
(function (NotificationType) {
    NotificationType[NotificationType["SyncCipherUpdate"] = 0] = "SyncCipherUpdate";
    NotificationType[NotificationType["SyncCipherCreate"] = 1] = "SyncCipherCreate";
    NotificationType[NotificationType["SyncLoginDelete"] = 2] = "SyncLoginDelete";
    NotificationType[NotificationType["SyncFolderDelete"] = 3] = "SyncFolderDelete";
    NotificationType[NotificationType["SyncCiphers"] = 4] = "SyncCiphers";
    NotificationType[NotificationType["SyncVault"] = 5] = "SyncVault";
    NotificationType[NotificationType["SyncOrgKeys"] = 6] = "SyncOrgKeys";
    NotificationType[NotificationType["SyncFolderCreate"] = 7] = "SyncFolderCreate";
    NotificationType[NotificationType["SyncFolderUpdate"] = 8] = "SyncFolderUpdate";
    NotificationType[NotificationType["SyncCipherDelete"] = 9] = "SyncCipherDelete";
    NotificationType[NotificationType["SyncSettings"] = 10] = "SyncSettings";
    NotificationType[NotificationType["LogOut"] = 11] = "LogOut";
    NotificationType[NotificationType["SyncSendCreate"] = 12] = "SyncSendCreate";
    NotificationType[NotificationType["SyncSendUpdate"] = 13] = "SyncSendUpdate";
    NotificationType[NotificationType["SyncSendDelete"] = 14] = "SyncSendDelete";
    NotificationType[NotificationType["AuthRequest"] = 15] = "AuthRequest";
    NotificationType[NotificationType["AuthRequestResponse"] = 16] = "AuthRequestResponse";
})(NotificationType || (NotificationType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/product-type.enum.ts
var ProductType;
(function (ProductType) {
    ProductType[ProductType["Free"] = 0] = "Free";
    ProductType[ProductType["Families"] = 1] = "Families";
    ProductType[ProductType["Teams"] = 2] = "Teams";
    ProductType[ProductType["Enterprise"] = 3] = "Enterprise";
    ProductType[ProductType["TeamsStarter"] = 4] = "TeamsStarter";
})(ProductType || (ProductType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/enums/index.ts









;// CONCATENATED MODULE: ../../libs/common/src/models/response/error.response.ts


class ErrorResponse extends BaseResponse {
    constructor(response, status, identityResponse) {
        var _a, _b;
        super(response);
        let errorModel = null;
        if (response != null) {
            const responseErrorModel = this.getResponseProperty("ErrorModel");
            if (responseErrorModel && identityResponse) {
                errorModel = responseErrorModel;
            }
            else {
                errorModel = response;
            }
        }
        if (status === 429) {
            this.message = "Rate limit exceeded. Try again later.";
        }
        else if (errorModel) {
            this.message = this.getResponseProperty("Message", errorModel);
            this.validationErrors = this.getResponseProperty("ValidationErrors", errorModel);
            this.captchaSiteKey = (_b = (_a = this.validationErrors) === null || _a === void 0 ? void 0 : _a.HCaptcha_SiteKey) === null || _b === void 0 ? void 0 : _b[0];
            this.captchaRequired = !utils_Utils.isNullOrWhitespace(this.captchaSiteKey);
        }
        this.statusCode = status;
    }
    getSingleMessage() {
        if (this.validationErrors == null) {
            return this.message;
        }
        for (const key in this.validationErrors) {
            // eslint-disable-next-line
            if (!this.validationErrors.hasOwnProperty(key)) {
                continue;
            }
            if (this.validationErrors[key].length) {
                return this.validationErrors[key][0];
            }
        }
        return this.message;
    }
    getAllMessages() {
        const messages = [];
        if (this.validationErrors == null) {
            return messages;
        }
        for (const key in this.validationErrors) {
            // eslint-disable-next-line
            if (!this.validationErrors.hasOwnProperty(key)) {
                continue;
            }
            this.validationErrors[key].forEach((item) => {
                let prefix = "";
                if (key.indexOf("[") > -1 && key.indexOf("]") > -1) {
                    const lastSep = key.lastIndexOf(".");
                    prefix = key.substr(0, lastSep > -1 ? lastSep : key.length) + ": ";
                }
                messages.push(prefix + item);
            });
        }
        return messages;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/data/policy.data.ts
class PolicyData {
    constructor(response) {
        this.id = response.id;
        this.organizationId = response.organizationId;
        this.type = response.type;
        this.data = response.data;
        this.enabled = response.enabled;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/response/policy.response.ts

class PolicyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.organizationId = this.getResponseProperty("OrganizationId");
        this.type = this.getResponseProperty("Type");
        this.data = this.getResponseProperty("Data");
        this.enabled = this.getResponseProperty("Enabled");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/policy/policy-api.service.ts
var policy_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







class PolicyApiService {
    constructor(policyService, apiService, stateService) {
        this.policyService = policyService;
        this.apiService = apiService;
        this.stateService = stateService;
    }
    getPolicy(organizationId, type) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + organizationId + "/policies/" + type, null, true, true);
            return new PolicyResponse(r);
        });
    }
    getPolicies(organizationId) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" + organizationId + "/policies", null, true, true);
            return new ListResponse(r, PolicyResponse);
        });
    }
    getPoliciesByToken(organizationId, token, email, organizationUserId) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/organizations/" +
                organizationId +
                "/policies/token?" +
                "token=" +
                encodeURIComponent(token) +
                "&email=" +
                utils_Utils.encodeRFC3986URIComponent(email) +
                "&organizationUserId=" +
                organizationUserId, null, false, true);
            return new ListResponse(r, PolicyResponse);
        });
    }
    getMasterPasswordPolicyResponseForOrgUser(organizationId) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            const response = yield this.apiService.send("GET", "/organizations/" + organizationId + "/policies/master-password", null, true, true);
            return new PolicyResponse(response);
        });
    }
    getMasterPasswordPolicyOptsForOrgUser(orgId) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            try {
                const masterPasswordPolicyResponse = yield this.getMasterPasswordPolicyResponseForOrgUser(orgId);
                const masterPasswordPolicy = this.policyService.mapPolicyFromResponse(masterPasswordPolicyResponse);
                if (!masterPasswordPolicy) {
                    return null;
                }
                return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.policyService.masterPasswordPolicyOptions$([masterPasswordPolicy]));
            }
            catch (error) {
                // If policy not found, return null
                if (error instanceof ErrorResponse && error.statusCode === HttpStatusCode.NotFound) {
                    return null;
                }
                // otherwise rethrow error
                throw error;
            }
        });
    }
    putPolicy(organizationId, type, request) {
        return policy_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/organizations/" + organizationId + "/policies/" + type, request, true, true);
            const response = new PolicyResponse(r);
            const data = new PolicyData(response);
            yield this.policyService.upsert(data);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/domain-base.ts
var domain_base_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

// https://contributing.bitwarden.com/architecture/clients/data-model#domain
class Domain {
    buildDomainModel(domain, dataObj, map, notEncList = []) {
        for (const prop in map) {
            // eslint-disable-next-line
            if (!map.hasOwnProperty(prop)) {
                continue;
            }
            const objProp = dataObj[map[prop] || prop];
            if (notEncList.indexOf(prop) > -1) {
                domain[prop] = objProp ? objProp : null;
            }
            else {
                domain[prop] = objProp ? new EncString(objProp) : null;
            }
        }
    }
    buildDataModel(domain, dataObj, map, notEncStringList = []) {
        for (const prop in map) {
            // eslint-disable-next-line
            if (!map.hasOwnProperty(prop)) {
                continue;
            }
            const objProp = domain[map[prop] || prop];
            if (notEncStringList.indexOf(prop) > -1) {
                dataObj[prop] = objProp != null ? objProp : null;
            }
            else {
                dataObj[prop] = objProp != null ? objProp.encryptedString : null;
            }
        }
    }
    decryptObj(viewModel, map, orgId, key = null) {
        return domain_base_awaiter(this, void 0, void 0, function* () {
            const promises = [];
            const self = this;
            for (const prop in map) {
                // eslint-disable-next-line
                if (!map.hasOwnProperty(prop)) {
                    continue;
                }
                (function (theProp) {
                    const p = Promise.resolve()
                        .then(() => {
                        const mapProp = map[theProp] || theProp;
                        if (self[mapProp]) {
                            return self[mapProp].decrypt(orgId, key);
                        }
                        return null;
                    })
                        .then((val) => {
                        viewModel[theProp] = val;
                    });
                    promises.push(p);
                })(prop);
            }
            yield Promise.all(promises);
            return viewModel;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/master-password-policy-options.ts

class MasterPasswordPolicyOptions extends Domain {
    constructor() {
        super(...arguments);
        this.minComplexity = 0;
        this.minLength = 0;
        this.requireUpper = false;
        this.requireLower = false;
        this.requireNumbers = false;
        this.requireSpecial = false;
        /**
         * Flag to indicate if the policy should be enforced on login.
         * If true, and the user's password does not meet the policy requirements,
         * the user will be forced to update their password.
         */
        this.enforceOnLogin = false;
    }
    static fromResponse(policy) {
        if (policy == null) {
            return null;
        }
        const options = new MasterPasswordPolicyOptions();
        options.minComplexity = policy.minComplexity;
        options.minLength = policy.minLength;
        options.requireUpper = policy.requireUpper;
        options.requireLower = policy.requireLower;
        options.requireNumbers = policy.requireNumbers;
        options.requireSpecial = policy.requireSpecial;
        options.enforceOnLogin = policy.enforceOnLogin;
        return options;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/policy.ts

class Policy extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.id = obj.id;
        this.organizationId = obj.organizationId;
        this.type = obj.type;
        this.data = obj.data;
        this.enabled = obj.enabled;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/reset-password-policy-options.ts

class ResetPasswordPolicyOptions extends Domain {
    constructor() {
        super(...arguments);
        this.autoEnrollEnabled = false;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/policy/policy.service.ts
var policy_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







class PolicyService {
    constructor(stateService, organizationService) {
        this.stateService = stateService;
        this.organizationService = organizationService;
        this._policies = new external_rxjs_namespaceObject.BehaviorSubject([]);
        this.policies$ = this._policies.asObservable();
        this.stateService.activeAccountUnlocked$
            .pipe((0,external_rxjs_namespaceObject.concatMap)((unlocked) => policy_service_awaiter(this, void 0, void 0, function* () {
            if (utils_Utils.global.bitwardenContainerService == null) {
                return;
            }
            if (!unlocked) {
                this._policies.next([]);
                return;
            }
            const data = yield this.stateService.getEncryptedPolicies();
            yield this.updateObservables(data);
        })))
            .subscribe();
    }
    get$(policyType, policyFilter) {
        return this.policies$.pipe((0,external_rxjs_namespaceObject.concatMap)((policies) => policy_service_awaiter(this, void 0, void 0, function* () {
            const userId = yield this.stateService.getUserId();
            const appliesToCurrentUser = yield this.checkPoliciesThatApplyToUser(policies, policyType, policyFilter, userId);
            if (appliesToCurrentUser) {
                return policies.find((policy) => policy.type === policyType && policy.enabled);
            }
        })));
    }
    getAll(type, userId) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            let response = [];
            const decryptedPolicies = yield this.stateService.getDecryptedPolicies({ userId: userId });
            if (decryptedPolicies != null) {
                response = decryptedPolicies;
            }
            else {
                const diskPolicies = yield this.stateService.getEncryptedPolicies({ userId: userId });
                for (const id in diskPolicies) {
                    if (Object.prototype.hasOwnProperty.call(diskPolicies, id)) {
                        response.push(new Policy(diskPolicies[id]));
                    }
                }
                yield this.stateService.setDecryptedPolicies(response, { userId: userId });
            }
            if (type != null) {
                return response.filter((policy) => policy.type === type);
            }
            else {
                return response;
            }
        });
    }
    masterPasswordPolicyOptions$(policies) {
        const observable = policies ? (0,external_rxjs_namespaceObject.of)(policies) : this.policies$;
        return observable.pipe((0,external_rxjs_namespaceObject.map)((obsPolicies) => {
            let enforcedOptions = null;
            const filteredPolicies = obsPolicies.filter((p) => p.type === policy_type_enum_PolicyType.MasterPassword);
            if (filteredPolicies == null || filteredPolicies.length === 0) {
                return enforcedOptions;
            }
            filteredPolicies.forEach((currentPolicy) => {
                if (!currentPolicy.enabled || currentPolicy.data == null) {
                    return;
                }
                if (enforcedOptions == null) {
                    enforcedOptions = new MasterPasswordPolicyOptions();
                }
                if (currentPolicy.data.minComplexity != null &&
                    currentPolicy.data.minComplexity > enforcedOptions.minComplexity) {
                    enforcedOptions.minComplexity = currentPolicy.data.minComplexity;
                }
                if (currentPolicy.data.minLength != null &&
                    currentPolicy.data.minLength > enforcedOptions.minLength) {
                    enforcedOptions.minLength = currentPolicy.data.minLength;
                }
                if (currentPolicy.data.requireUpper) {
                    enforcedOptions.requireUpper = true;
                }
                if (currentPolicy.data.requireLower) {
                    enforcedOptions.requireLower = true;
                }
                if (currentPolicy.data.requireNumbers) {
                    enforcedOptions.requireNumbers = true;
                }
                if (currentPolicy.data.requireSpecial) {
                    enforcedOptions.requireSpecial = true;
                }
                if (currentPolicy.data.enforceOnLogin) {
                    enforcedOptions.enforceOnLogin = true;
                }
            });
            return enforcedOptions;
        }));
    }
    policyAppliesToActiveUser$(policyType, policyFilter) {
        return this.policies$.pipe((0,external_rxjs_namespaceObject.concatMap)((policies) => policy_service_awaiter(this, void 0, void 0, function* () {
            const userId = yield this.stateService.getUserId();
            return yield this.checkPoliciesThatApplyToUser(policies, policyType, policyFilter, userId);
        })));
    }
    evaluateMasterPassword(passwordStrength, newPassword, enforcedPolicyOptions) {
        if (enforcedPolicyOptions == null) {
            return true;
        }
        if (enforcedPolicyOptions.minComplexity > 0 &&
            enforcedPolicyOptions.minComplexity > passwordStrength) {
            return false;
        }
        if (enforcedPolicyOptions.minLength > 0 &&
            enforcedPolicyOptions.minLength > newPassword.length) {
            return false;
        }
        if (enforcedPolicyOptions.requireUpper && newPassword.toLocaleLowerCase() === newPassword) {
            return false;
        }
        if (enforcedPolicyOptions.requireLower && newPassword.toLocaleUpperCase() === newPassword) {
            return false;
        }
        if (enforcedPolicyOptions.requireNumbers && !/[0-9]/.test(newPassword)) {
            return false;
        }
        // eslint-disable-next-line
        if (enforcedPolicyOptions.requireSpecial && !/[!@#$%\^&*]/g.test(newPassword)) {
            return false;
        }
        return true;
    }
    getResetPasswordPolicyOptions(policies, orgId) {
        var _a, _b, _c;
        const resetPasswordPolicyOptions = new ResetPasswordPolicyOptions();
        if (policies == null || orgId == null) {
            return [resetPasswordPolicyOptions, false];
        }
        const policy = policies.find((p) => p.organizationId === orgId && p.type === policy_type_enum_PolicyType.ResetPassword && p.enabled);
        resetPasswordPolicyOptions.autoEnrollEnabled = (_b = (_a = policy === null || policy === void 0 ? void 0 : policy.data) === null || _a === void 0 ? void 0 : _a.autoEnrollEnabled) !== null && _b !== void 0 ? _b : false;
        return [resetPasswordPolicyOptions, (_c = policy === null || policy === void 0 ? void 0 : policy.enabled) !== null && _c !== void 0 ? _c : false];
    }
    mapPolicyFromResponse(policyResponse) {
        const policyData = new PolicyData(policyResponse);
        return new Policy(policyData);
    }
    mapPoliciesFromToken(policiesResponse) {
        if ((policiesResponse === null || policiesResponse === void 0 ? void 0 : policiesResponse.data) == null) {
            return null;
        }
        return policiesResponse.data.map((response) => this.mapPolicyFromResponse(response));
    }
    policyAppliesToUser(policyType, policyFilter, userId) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            const policies = yield this.getAll(policyType, userId);
            return this.checkPoliciesThatApplyToUser(policies, policyType, policyFilter, userId);
        });
    }
    upsert(policy) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            let policies = yield this.stateService.getEncryptedPolicies();
            if (policies == null) {
                policies = {};
            }
            policies[policy.id] = policy;
            yield this.updateObservables(policies);
            yield this.stateService.setDecryptedPolicies(null);
            yield this.stateService.setEncryptedPolicies(policies);
        });
    }
    replace(policies) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            yield this.updateObservables(policies);
            yield this.stateService.setDecryptedPolicies(null);
            yield this.stateService.setEncryptedPolicies(policies);
        });
    }
    clear(userId) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null || userId == (yield this.stateService.getUserId())) {
                this._policies.next([]);
            }
            yield this.stateService.setDecryptedPolicies(null, { userId: userId });
            yield this.stateService.setEncryptedPolicies(null, { userId: userId });
        });
    }
    isExemptFromPolicies(organization, policyType) {
        if (policyType === policy_type_enum_PolicyType.MaximumVaultTimeout) {
            return organization.type === OrganizationUserType.Owner;
        }
        return organization.isExemptFromPolicies;
    }
    updateObservables(policiesMap) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            const policies = Object.values(policiesMap || {}).map((f) => new Policy(f));
            this._policies.next(policies);
        });
    }
    checkPoliciesThatApplyToUser(policies, policyType, policyFilter, userId) {
        return policy_service_awaiter(this, void 0, void 0, function* () {
            const organizations = yield this.organizationService.getAll(userId);
            const filteredPolicies = policies.filter((p) => p.type === policyType && p.enabled && (policyFilter == null || policyFilter(p)));
            const policySet = new Set(filteredPolicies.map((p) => p.organizationId));
            return organizations.some((o) => o.status >= OrganizationUserStatusType.Accepted &&
                o.usePolicies &&
                policySet.has(o.id) &&
                !this.isExemptFromPolicies(o, policyType));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/provider.ts

class Provider {
    constructor(obj) {
        if (obj == null) {
            return;
        }
        this.id = obj.id;
        this.name = obj.name;
        this.status = obj.status;
        this.type = obj.type;
        this.enabled = obj.enabled;
        this.userId = obj.userId;
        this.useEvents = obj.useEvents;
    }
    get canAccess() {
        if (this.isProviderAdmin) {
            return true;
        }
        return this.enabled && this.status === ProviderUserStatusType.Confirmed;
    }
    get canCreateOrganizations() {
        return this.enabled && this.isProviderAdmin;
    }
    get canManageUsers() {
        return this.isProviderAdmin;
    }
    get canAccessEventLogs() {
        return this.isProviderAdmin;
    }
    get isProviderAdmin() {
        return this.type === ProviderUserType.ProviderAdmin;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/services/provider.service.ts
var provider_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class ProviderService {
    constructor(stateService) {
        this.stateService = stateService;
    }
    get(id) {
        return provider_service_awaiter(this, void 0, void 0, function* () {
            const providers = yield this.stateService.getProviders();
            // eslint-disable-next-line
            if (providers == null || !providers.hasOwnProperty(id)) {
                return null;
            }
            return new Provider(providers[id]);
        });
    }
    getAll() {
        return provider_service_awaiter(this, void 0, void 0, function* () {
            const providers = yield this.stateService.getProviders();
            const response = [];
            for (const id in providers) {
                // eslint-disable-next-line
                if (providers.hasOwnProperty(id)) {
                    response.push(new Provider(providers[id]));
                }
            }
            return response;
        });
    }
    save(providers) {
        return provider_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setProviders(providers);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/abstractions/account.service.ts
function accountInfoEqual(a, b) {
    return (a === null || a === void 0 ? void 0 : a.status) === (b === null || b === void 0 ? void 0 : b.status) && (a === null || a === void 0 ? void 0 : a.email) === (b === null || b === void 0 ? void 0 : b.email) && (a === null || a === void 0 ? void 0 : a.name) === (b === null || b === void 0 ? void 0 : b.name);
}
class AccountService {
}
class InternalAccountService extends (/* unused pure expression or super */ null && (AccountService)) {
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/derive-definition.ts
/**
 * DeriveDefinitions describe state derived from another observable, the value type of which is given by `TFrom`.
 *
 * The StateDefinition is used to describe the domain of the state, and the DeriveDefinition
 * sub-divides that domain into specific keys. These keys are used to cache data in memory and enables derived state to
 * be calculated once regardless of multiple execution contexts.
 */
class DeriveDefinition {
    /**
     * Creates a new instance of a DeriveDefinition. Derived state is always stored in memory, so the storage location
     * defined in @link{StateDefinition} is ignored.
     *
     * @param stateDefinition The state definition for which this key belongs to.
     * @param uniqueDerivationName The name of the key, this should be unique per domain.
     * @param options A set of options to customize the behavior of {@link DeriveDefinition}.
     * @param options.derive A function to use to convert values from TFrom to TTo. This is called on each emit of the parent state observable
     * and the resulting value will be emitted from the derived state observable.
     * @param options.cleanupDelayMs The number of milliseconds to wait before cleaning up the state after the last subscriber has unsubscribed.
     * Defaults to 1000ms.
     * @param options.dependencyShape An object defining the dependencies of the derive function. The keys of the object are the names of the dependencies
     * and the values are the types of the dependencies.
     * for example:
     * ```
     * {
     *   myService: MyService,
     *   myOtherService: MyOtherService,
     * }
     * ```
     *
     * @param options.deserializer A function to use to safely convert your type from json to your expected type.
     *   Your data may be serialized/deserialized at any time and this needs callback needs to be able to faithfully re-initialize
     *   from the JSON object representation of your type.
     */
    constructor(stateDefinition, uniqueDerivationName, options) {
        this.stateDefinition = stateDefinition;
        this.uniqueDerivationName = uniqueDerivationName;
        this.options = options;
    }
    /**
     * Factory that produces a {@link DeriveDefinition} from a {@link KeyDefinition} and a set of options. The returned
     * definition will have the same key as the given key definition, but will not collide with it in storage, even if
     * they both reside in memory.
     * @param keyDefinition
     * @param options
     * @returns
     */
    static from(keyDefinition, options) {
        return new DeriveDefinition(keyDefinition.stateDefinition, keyDefinition.key, options);
    }
    get derive() {
        return this.options.derive;
    }
    deserialize(serialized) {
        return this.options.deserializer(serialized);
    }
    get cleanupDelayMs() {
        var _a;
        return this.options.cleanupDelayMs < 0 ? 0 : (_a = this.options.cleanupDelayMs) !== null && _a !== void 0 ? _a : 1000;
    }
    buildCacheKey() {
        return `derived_${this.stateDefinition.name}_${this.uniqueDerivationName}`;
    }
    /**
     * Creates a {@link StorageKey} that points to the data for the given derived definition.
     * @returns A key that is ready to be used in a storage service to get data.
     */
    get storageKey() {
        return `derived_${this.stateDefinition.name}_${this.uniqueDerivationName}`;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/key-definition.ts

/**
 * KeyDefinitions describe the precise location to store data for a given piece of state.
 * The StateDefinition is used to describe the domain of the state, and the KeyDefinition
 * sub-divides that domain into specific keys.
 */
class KeyDefinition {
    /**
     * Creates a new instance of a KeyDefinition
     * @param stateDefinition The state definition for which this key belongs to.
     * @param key The name of the key, this should be unique per domain.
     * @param options A set of options to customize the behavior of {@link KeyDefinition}. All options are required.
     * @param options.deserializer A function to use to safely convert your type from json to your expected type.
     *   Your data may be serialized/deserialized at any time and this needs callback needs to be able to faithfully re-initialize
     *   from the JSON object representation of your type.
     */
    constructor(stateDefinition, key, options) {
        this.stateDefinition = stateDefinition;
        this.key = key;
        this.options = options;
        if (options.deserializer == null) {
            throw new Error(`'deserializer' is a required property on key ${this.errorKeyName}`);
        }
        if (options.cleanupDelayMs <= 0) {
            throw new Error(`'cleanupDelayMs' must be greater than 0. Value of ${options.cleanupDelayMs} passed to key ${this.errorKeyName} `);
        }
    }
    /**
     * Gets the deserializer configured for this {@link KeyDefinition}
     */
    get deserializer() {
        return this.options.deserializer;
    }
    /**
     * Gets the number of milliseconds to wait before cleaning up the state after the last subscriber has unsubscribed.
     */
    get cleanupDelayMs() {
        var _a;
        return this.options.cleanupDelayMs < 0 ? 0 : (_a = this.options.cleanupDelayMs) !== null && _a !== void 0 ? _a : 1000;
    }
    /**
     * Creates a {@link KeyDefinition} for state that is an array.
     * @param stateDefinition The state definition to be added to the KeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link KeyDefinition}.
     * @returns A {@link KeyDefinition} initialized for arrays, the options run
     * the deserializer on the provided options for each element of an array
     * **unless that array is null, in which case it will return an empty list.**
     *
     * @example
     * ```typescript
     * const MY_KEY = KeyDefinition.array<MyArrayElement>(MY_STATE, "key", {
     *   deserializer: (myJsonElement) => convertToElement(myJsonElement),
     * });
     * ```
     */
    static array(stateDefinition, key, 
    // We have them provide options for the element of the array, depending on future options we add, this could get a little weird.
    options) {
        return new KeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: (jsonValue) => {
                if (jsonValue == null) {
                    return null;
                }
                return jsonValue.map((v) => options.deserializer(v));
            } }));
    }
    /**
     * Creates a {@link KeyDefinition} for state that is a record.
     * @param stateDefinition The state definition to be added to the KeyDefinition
     * @param key The key to be added to the KeyDefinition
     * @param options The options to customize the final {@link KeyDefinition}.
     * @returns A {@link KeyDefinition} that contains a serializer that will run the provided deserializer for each
     * value in a record and returns every key as a string **unless that record is null, in which case it will return an record.**
     *
     * @example
     * ```typescript
     * const MY_KEY = KeyDefinition.record<MyRecordValue>(MY_STATE, "key", {
     *   deserializer: (myJsonValue) => convertToValue(myJsonValue),
     * });
     * ```
     */
    static record(stateDefinition, key, 
    // We have them provide options for the value of the record, depending on future options we add, this could get a little weird.
    options) {
        return new KeyDefinition(stateDefinition, key, Object.assign(Object.assign({}, options), { deserializer: (jsonValue) => {
                if (jsonValue == null) {
                    return null;
                }
                const output = {};
                for (const key in jsonValue) {
                    output[key] = options.deserializer(jsonValue[key]);
                }
                return output;
            } }));
    }
    get fullName() {
        return `${this.stateDefinition.name}_${this.key}`;
    }
    get errorKeyName() {
        return `${this.stateDefinition.name} > ${this.key}`;
    }
}
/**
 * Creates a {@link StorageKey} that points to the data at the given key definition for the specified user.
 * @param userId The userId of the user you want the key to be for.
 * @param keyDefinition The key definition of which data the key should point to.
 * @returns A key that is ready to be used in a storage service to get data.
 */
function userKeyBuilder(userId, keyDefinition) {
    if (!utils_Utils.isGuid(userId)) {
        throw new Error("You cannot build a user key without a valid UserId");
    }
    return `user_${userId}_${keyDefinition.stateDefinition.name}_${keyDefinition.key}`;
}
/**
 * Creates a {@link StorageKey}
 * @param keyDefinition The key definition of which data the key should point to.
 * @returns A key that is ready to be used in a storage service to get data.
 */
function globalKeyBuilder(keyDefinition) {
    return `global_${keyDefinition.stateDefinition.name}_${keyDefinition.key}`;
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/state-definition.ts
/**
 * Defines the base location and instruction of where this state is expected to be located.
 */
class StateDefinition {
    /**
     * Creates a new instance of {@link StateDefinition}, the creation of which is owned by the platform team.
     * @param name The name of the state, this needs to be unique from all other {@link StateDefinition}'s.
     * @param defaultStorageLocation The location of where this state should be stored.
     */
    constructor(name, defaultStorageLocation, storageLocationOverrides) {
        this.name = name;
        this.defaultStorageLocation = defaultStorageLocation;
        this.storageLocationOverrides = storageLocationOverrides !== null && storageLocationOverrides !== void 0 ? storageLocationOverrides : {};
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/state-definitions.ts

/**
 * `StateDefinition`s comes with some rules, to facilitate a quick review from
 * platform of this file, ensure you follow these rules, the ones marked with (tested)
 * have unit tests that you can run locally.
 *
 * 1. (tested) Names should not be null or undefined
 * 2. (tested) Name and storage location should be unique
 * 3. (tested) Name and storage location can't differ from another export by only casing
 * 4. (tested) Name should be longer than 3 characters. It should be descriptive, but brief.
 * 5. (tested) Name should not contain spaces or underscores
 * 6. Name should be human readable
 * 7. Name should be in camelCase format (unit tests ensure the first character is lowercase)
 * 8. Teams should only use state definitions they have created
 * 9. StateDefinitions should only be used for keys relating to the state name they chose
 *
 */
const ACCOUNT_MEMORY = new StateDefinition("account", "memory");
const BILLING_BANNERS_DISK = new StateDefinition("billingBanners", "disk");
const CRYPTO_DISK = new StateDefinition("crypto", "disk");
const ENVIRONMENT_DISK = new StateDefinition("environment", "disk");
const GENERATOR_DISK = new StateDefinition("generator", "disk");
const GENERATOR_MEMORY = new StateDefinition("generator", "memory");

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/index.ts








;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/authentication-status.ts
var AuthenticationStatus;
(function (AuthenticationStatus) {
    AuthenticationStatus[AuthenticationStatus["LoggedOut"] = 0] = "LoggedOut";
    AuthenticationStatus[AuthenticationStatus["Locked"] = 1] = "Locked";
    AuthenticationStatus[AuthenticationStatus["Unlocked"] = 2] = "Unlocked";
})(AuthenticationStatus || (AuthenticationStatus = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/account.service.ts
var account_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




const ACCOUNT_ACCOUNTS = KeyDefinition.record(ACCOUNT_MEMORY, "accounts", {
    deserializer: (accountInfo) => accountInfo,
});
const ACCOUNT_ACTIVE_ACCOUNT_ID = new KeyDefinition(ACCOUNT_MEMORY, "activeAccountId", {
    deserializer: (id) => id,
});
class AccountServiceImplementation {
    constructor(messagingService, logService, globalStateProvider) {
        this.messagingService = messagingService;
        this.logService = logService;
        this.globalStateProvider = globalStateProvider;
        this.lock = new external_rxjs_namespaceObject.Subject();
        this.logout = new external_rxjs_namespaceObject.Subject();
        this.accountLock$ = this.lock.asObservable();
        this.accountLogout$ = this.logout.asObservable();
        this.accountsState = this.globalStateProvider.get(ACCOUNT_ACCOUNTS);
        this.activeAccountIdState = this.globalStateProvider.get(ACCOUNT_ACTIVE_ACCOUNT_ID);
        this.accounts$ = this.accountsState.state$.pipe((0,external_rxjs_namespaceObject.map)((accounts) => (accounts == null ? {} : accounts)));
        this.activeAccount$ = this.activeAccountIdState.state$.pipe((0,external_rxjs_namespaceObject.combineLatestWith)(this.accounts$), (0,external_rxjs_namespaceObject.map)(([id, accounts]) => (id ? Object.assign({ id }, accounts[id]) : undefined)), (0,external_rxjs_namespaceObject.distinctUntilChanged)((a, b) => (a === null || a === void 0 ? void 0 : a.id) === (b === null || b === void 0 ? void 0 : b.id) && accountInfoEqual(a, b)), (0,external_rxjs_namespaceObject.shareReplay)({ bufferSize: 1, refCount: false }));
    }
    addAccount(userId, accountData) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            yield this.accountsState.update((accounts) => {
                accounts || (accounts = {});
                accounts[userId] = accountData;
                return accounts;
            });
        });
    }
    setAccountName(userId, name) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            yield this.setAccountInfo(userId, { name });
        });
    }
    setAccountEmail(userId, email) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            yield this.setAccountInfo(userId, { email });
        });
    }
    setAccountStatus(userId, status) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            yield this.setAccountInfo(userId, { status });
            if (status === AuthenticationStatus.LoggedOut) {
                this.logout.next(userId);
            }
            else if (status === AuthenticationStatus.Locked) {
                this.lock.next(userId);
            }
        });
    }
    switchAccount(userId) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            yield this.activeAccountIdState.update((_, accounts) => {
                if (userId == null) {
                    // indicates no account is active
                    return null;
                }
                if ((accounts === null || accounts === void 0 ? void 0 : accounts[userId]) == null) {
                    throw new Error("Account does not exist");
                }
                return userId;
            }, {
                combineLatestWith: this.accounts$,
                shouldUpdate: (id) => {
                    // update only if userId changes
                    return id !== userId;
                },
            });
        });
    }
    // TODO: update to use our own account status settings. Requires inverting direction of state service accounts flow
    delete() {
        var _a;
        return account_service_awaiter(this, void 0, void 0, function* () {
            try {
                (_a = this.messagingService) === null || _a === void 0 ? void 0 : _a.send("logout");
            }
            catch (e) {
                this.logService.error(e);
                throw e;
            }
        });
    }
    setAccountInfo(userId, update) {
        return account_service_awaiter(this, void 0, void 0, function* () {
            function newAccountInfo(oldAccountInfo) {
                return Object.assign(Object.assign({}, oldAccountInfo), update);
            }
            yield this.accountsState.update((accounts) => {
                accounts[userId] = newAccountInfo(accounts[userId]);
                return accounts;
            }, {
                // Avoid unnecessary updates
                // TODO: Faster comparison, maybe include a hash on the objects?
                shouldUpdate: (accounts) => {
                    if ((accounts === null || accounts === void 0 ? void 0 : accounts[userId]) == null) {
                        throw new Error("Account does not exist");
                    }
                    return !accountInfoEqual(accounts[userId], newAccountInfo(accounts[userId]));
                },
            });
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/symmetric-crypto-key.ts


class SymmetricCryptoKey {
    constructor(key, encType) {
        if (key == null) {
            throw new Error("Must provide key");
        }
        if (encType == null) {
            if (key.byteLength === 32) {
                encType = EncryptionType.AesCbc256_B64;
            }
            else if (key.byteLength === 64) {
                encType = EncryptionType.AesCbc256_HmacSha256_B64;
            }
            else {
                throw new Error("Unable to determine encType.");
            }
        }
        this.key = key;
        this.encType = encType;
        if (encType === EncryptionType.AesCbc256_B64 && key.byteLength === 32) {
            this.encKey = key;
            this.macKey = null;
        }
        else if (encType === EncryptionType.AesCbc128_HmacSha256_B64 && key.byteLength === 32) {
            this.encKey = key.slice(0, 16);
            this.macKey = key.slice(16, 32);
        }
        else if (encType === EncryptionType.AesCbc256_HmacSha256_B64 && key.byteLength === 64) {
            this.encKey = key.slice(0, 32);
            this.macKey = key.slice(32, 64);
        }
        else {
            throw new Error("Unsupported encType/key length.");
        }
        if (this.key != null) {
            this.keyB64 = utils_Utils.fromBufferToB64(this.key);
        }
        if (this.encKey != null) {
            this.encKeyB64 = utils_Utils.fromBufferToB64(this.encKey);
        }
        if (this.macKey != null) {
            this.macKeyB64 = utils_Utils.fromBufferToB64(this.macKey);
        }
    }
    toJSON() {
        // The whole object is constructed from the initial key, so just store the B64 key
        return { keyB64: this.keyB64 };
    }
    static fromString(s) {
        if (s == null) {
            return null;
        }
        const arrayBuffer = utils_Utils.fromB64ToArray(s);
        return new SymmetricCryptoKey(arrayBuffer);
    }
    static fromJSON(obj) {
        return SymmetricCryptoKey.fromString(obj === null || obj === void 0 ? void 0 : obj.keyB64);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/auth-request-crypto.service.implementation.ts
var auth_request_crypto_service_implementation_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class AuthRequestCryptoServiceImplementation {
    constructor(cryptoService) {
        this.cryptoService = cryptoService;
    }
    setUserKeyAfterDecryptingSharedUserKey(authReqResponse, authReqPrivateKey) {
        return auth_request_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            const userKey = yield this.decryptPubKeyEncryptedUserKey(authReqResponse.key, authReqPrivateKey);
            yield this.cryptoService.setUserKey(userKey);
        });
    }
    setKeysAfterDecryptingSharedMasterKeyAndHash(authReqResponse, authReqPrivateKey) {
        return auth_request_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            const { masterKey, masterKeyHash } = yield this.decryptPubKeyEncryptedMasterKeyAndHash(authReqResponse.key, authReqResponse.masterPasswordHash, authReqPrivateKey);
            // Decrypt and set user key in state
            const userKey = yield this.cryptoService.decryptUserKeyWithMasterKey(masterKey);
            // Set masterKey + masterKeyHash in state after decryption (in case decryption fails)
            yield this.cryptoService.setMasterKey(masterKey);
            yield this.cryptoService.setMasterKeyHash(masterKeyHash);
            yield this.cryptoService.setUserKey(userKey);
        });
    }
    // Decryption helpers
    decryptPubKeyEncryptedUserKey(pubKeyEncryptedUserKey, privateKey) {
        return auth_request_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            const decryptedUserKeyBytes = yield this.cryptoService.rsaDecrypt(pubKeyEncryptedUserKey, privateKey);
            return new SymmetricCryptoKey(decryptedUserKeyBytes);
        });
    }
    decryptPubKeyEncryptedMasterKeyAndHash(pubKeyEncryptedMasterKey, pubKeyEncryptedMasterKeyHash, privateKey) {
        return auth_request_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            const decryptedMasterKeyArrayBuffer = yield this.cryptoService.rsaDecrypt(pubKeyEncryptedMasterKey, privateKey);
            const decryptedMasterKeyHashArrayBuffer = yield this.cryptoService.rsaDecrypt(pubKeyEncryptedMasterKeyHash, privateKey);
            const masterKey = new SymmetricCryptoKey(decryptedMasterKeyArrayBuffer);
            const masterKeyHash = utils_Utils.fromBufferToUtf8(decryptedMasterKeyHashArrayBuffer);
            return {
                masterKey,
                masterKeyHash,
            };
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/request/prelogin.request.ts
class PreloginRequest {
    constructor(email) {
        this.email = email;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/authentication-type.ts
var authentication_type_AuthenticationType;
(function (AuthenticationType) {
    AuthenticationType[AuthenticationType["Password"] = 0] = "Password";
    AuthenticationType[AuthenticationType["Sso"] = 1] = "Sso";
    AuthenticationType[AuthenticationType["UserApi"] = 2] = "UserApi";
    AuthenticationType[AuthenticationType["AuthRequest"] = 3] = "AuthRequest";
    AuthenticationType[AuthenticationType["WebAuthn"] = 4] = "WebAuthn";
})(authentication_type_AuthenticationType || (authentication_type_AuthenticationType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/token.request.ts
class TokenRequest {
    constructor(twoFactor, device) {
        this.twoFactor = twoFactor;
        this.device = device != null ? device : null;
    }
    // eslint-disable-next-line
    alterIdentityTokenHeaders(headers) {
        // Implemented in subclass if required
    }
    setTwoFactor(twoFactor) {
        this.twoFactor = twoFactor;
    }
    setAuthRequestAccessCode(accessCode) {
        this.authRequest = accessCode;
    }
    toIdentityToken(clientId) {
        const obj = {
            scope: "api offline_access",
            client_id: clientId,
        };
        if (this.device) {
            obj.deviceType = this.device.type;
            obj.deviceIdentifier = this.device.identifier;
            obj.deviceName = this.device.name;
            // no push tokens for browser apps yet
            // obj.devicePushToken = this.device.pushToken;
        }
        //passswordless login
        if (this.authRequest) {
            obj.authRequest = this.authRequest;
        }
        if (this.twoFactor) {
            if (this.twoFactor.token && this.twoFactor.provider != null) {
                obj.twoFactorToken = this.twoFactor.token;
                obj.twoFactorProvider = this.twoFactor.provider;
                obj.twoFactorRemember = this.twoFactor.remember ? "1" : "0";
            }
        }
        return obj;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/password-token.request.ts


class PasswordTokenRequest extends TokenRequest {
    constructor(email, masterPasswordHash, captchaResponse, twoFactor, device) {
        super(twoFactor, device);
        this.email = email;
        this.masterPasswordHash = masterPasswordHash;
        this.captchaResponse = captchaResponse;
        this.twoFactor = twoFactor;
    }
    toIdentityToken(clientId) {
        const obj = super.toIdentityToken(clientId);
        obj.grant_type = "password";
        obj.username = this.email;
        obj.password = this.masterPasswordHash;
        if (this.captchaResponse != null) {
            obj.captchaResponse = this.captchaResponse;
        }
        return obj;
    }
    alterIdentityTokenHeaders(headers) {
        headers.set("Auth-Email", utils_Utils.fromUtf8ToUrlB64(this.email));
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/request/keys.request.ts
class KeysRequest {
    constructor(publicKey, encryptedPrivateKey) {
        this.publicKey = publicKey;
        this.encryptedPrivateKey = encryptedPrivateKey;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/admin-auth-req-storable.ts

// TODO: Tech Debt: potentially create a type Storage shape vs using a class here in the future
// type StorageShape {
//   id: string;
//   privateKey: string;
// }
// so we can get rid of the any type passed into fromJSON and coming out of ToJSON
class AdminAuthRequestStorable {
    constructor(init) {
        if (init) {
            Object.assign(this, init);
        }
    }
    toJSON() {
        return {
            id: this.id,
            privateKey: utils_Utils.fromBufferToByteString(this.privateKey),
        };
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        let privateKeyBuffer = null;
        if (obj.privateKey) {
            privateKeyBuffer = utils_Utils.fromByteStringToArray(obj.privateKey);
        }
        return new AdminAuthRequestStorable({
            id: obj.id,
            privateKey: privateKeyBuffer,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/user-decryption-options/key-connector-user-decryption-option.ts
class KeyConnectorUserDecryptionOption {
    constructor(keyConnectorUrl) {
        this.keyConnectorUrl = keyConnectorUrl;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/user-decryption-options/trusted-device-user-decryption-option.ts
class TrustedDeviceUserDecryptionOption {
    constructor(hasAdminApproval, hasLoginApprovingDevice, hasManageResetPasswordPermission) {
        this.hasAdminApproval = hasAdminApproval;
        this.hasLoginApprovingDevice = hasLoginApprovingDevice;
        this.hasManageResetPasswordPermission = hasManageResetPasswordPermission;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/cryptography/initializer-key.ts
var InitializerKey;
(function (InitializerKey) {
    InitializerKey[InitializerKey["Cipher"] = 0] = "Cipher";
    InitializerKey[InitializerKey["CipherView"] = 1] = "CipherView";
})(InitializerKey || (InitializerKey = {}));

;// CONCATENATED MODULE: ../../libs/common/src/vault/enums/cipher-reprompt-type.ts
var CipherRepromptType;
(function (CipherRepromptType) {
    CipherRepromptType[CipherRepromptType["None"] = 0] = "None";
    CipherRepromptType[CipherRepromptType["Password"] = 1] = "Password";
})(CipherRepromptType || (CipherRepromptType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/vault/enums/cipher-type.ts
var CipherType;
(function (CipherType) {
    CipherType[CipherType["Login"] = 1] = "Login";
    CipherType[CipherType["SecureNote"] = 2] = "SecureNote";
    CipherType[CipherType["Card"] = 3] = "Card";
    CipherType[CipherType["Identity"] = 4] = "Identity";
})(CipherType || (CipherType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/attachment.view.ts

class AttachmentView {
    constructor(a) {
        this.id = null;
        this.url = null;
        this.size = null;
        this.sizeName = null;
        this.fileName = null;
        this.key = null;
        if (!a) {
            return;
        }
        this.id = a.id;
        this.url = a.url;
        this.size = a.size;
        this.sizeName = a.sizeName;
    }
    get fileSize() {
        try {
            if (this.size != null) {
                return parseInt(this.size, null);
            }
        }
        catch (_a) {
            // Invalid file size.
        }
        return 0;
    }
    static fromJSON(obj) {
        const key = obj.key == null ? null : SymmetricCryptoKey.fromJSON(obj.key);
        return Object.assign(new AttachmentView(), obj, { key: key });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/enums/field-type.enum.ts
var FieldType;
(function (FieldType) {
    FieldType[FieldType["Text"] = 0] = "Text";
    FieldType[FieldType["Hidden"] = 1] = "Hidden";
    FieldType[FieldType["Boolean"] = 2] = "Boolean";
    FieldType[FieldType["Linked"] = 3] = "Linked";
})(FieldType || (FieldType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/vault/enums/linked-id-type.enum.ts
// LoginView
var LoginLinkedId;
(function (LoginLinkedId) {
    LoginLinkedId[LoginLinkedId["Username"] = 100] = "Username";
    LoginLinkedId[LoginLinkedId["Password"] = 101] = "Password";
})(LoginLinkedId || (LoginLinkedId = {}));
// CardView
var CardLinkedId;
(function (CardLinkedId) {
    CardLinkedId[CardLinkedId["CardholderName"] = 300] = "CardholderName";
    CardLinkedId[CardLinkedId["ExpMonth"] = 301] = "ExpMonth";
    CardLinkedId[CardLinkedId["ExpYear"] = 302] = "ExpYear";
    CardLinkedId[CardLinkedId["Code"] = 303] = "Code";
    CardLinkedId[CardLinkedId["Brand"] = 304] = "Brand";
    CardLinkedId[CardLinkedId["Number"] = 305] = "Number";
})(CardLinkedId || (CardLinkedId = {}));
// IdentityView
var IdentityLinkedId;
(function (IdentityLinkedId) {
    IdentityLinkedId[IdentityLinkedId["Title"] = 400] = "Title";
    IdentityLinkedId[IdentityLinkedId["MiddleName"] = 401] = "MiddleName";
    IdentityLinkedId[IdentityLinkedId["Address1"] = 402] = "Address1";
    IdentityLinkedId[IdentityLinkedId["Address2"] = 403] = "Address2";
    IdentityLinkedId[IdentityLinkedId["Address3"] = 404] = "Address3";
    IdentityLinkedId[IdentityLinkedId["City"] = 405] = "City";
    IdentityLinkedId[IdentityLinkedId["State"] = 406] = "State";
    IdentityLinkedId[IdentityLinkedId["PostalCode"] = 407] = "PostalCode";
    IdentityLinkedId[IdentityLinkedId["Country"] = 408] = "Country";
    IdentityLinkedId[IdentityLinkedId["Company"] = 409] = "Company";
    IdentityLinkedId[IdentityLinkedId["Email"] = 410] = "Email";
    IdentityLinkedId[IdentityLinkedId["Phone"] = 411] = "Phone";
    IdentityLinkedId[IdentityLinkedId["Ssn"] = 412] = "Ssn";
    IdentityLinkedId[IdentityLinkedId["Username"] = 413] = "Username";
    IdentityLinkedId[IdentityLinkedId["PassportNumber"] = 414] = "PassportNumber";
    IdentityLinkedId[IdentityLinkedId["LicenseNumber"] = 415] = "LicenseNumber";
    IdentityLinkedId[IdentityLinkedId["FirstName"] = 416] = "FirstName";
    IdentityLinkedId[IdentityLinkedId["LastName"] = 417] = "LastName";
    IdentityLinkedId[IdentityLinkedId["FullName"] = 418] = "FullName";
})(IdentityLinkedId || (IdentityLinkedId = {}));

;// CONCATENATED MODULE: ../../libs/common/src/vault/enums/secure-note-type.enum.ts
var SecureNoteType;
(function (SecureNoteType) {
    SecureNoteType[SecureNoteType["Generic"] = 0] = "Generic";
})(SecureNoteType || (SecureNoteType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/vault/enums/uri-match-type.enum.ts
var UriMatchType;
(function (UriMatchType) {
    UriMatchType[UriMatchType["Domain"] = 0] = "Domain";
    UriMatchType[UriMatchType["Host"] = 1] = "Host";
    UriMatchType[UriMatchType["StartsWith"] = 2] = "StartsWith";
    UriMatchType[UriMatchType["Exact"] = 3] = "Exact";
    UriMatchType[UriMatchType["RegularExpression"] = 4] = "RegularExpression";
    UriMatchType[UriMatchType["Never"] = 5] = "Never";
})(UriMatchType || (UriMatchType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/vault/enums/index.ts







;// CONCATENATED MODULE: ../../libs/common/src/vault/linked-field-option.decorator.ts
class LinkedMetadata {
    constructor(propertyKey, _i18nKey) {
        this.propertyKey = propertyKey;
        this._i18nKey = _i18nKey;
    }
    get i18nKey() {
        var _a;
        return (_a = this._i18nKey) !== null && _a !== void 0 ? _a : this.propertyKey;
    }
}
/**
 * A decorator used to set metadata used by Linked custom fields. Apply it to a class property or getter to make it
 *    available as a Linked custom field option.
 * @param id - A unique value that is saved in the Field model. It is used to look up the decorated class property.
 * @param i18nKey - The i18n key used to describe the decorated class property in the UI. If it is null, then the name
 *    of the class property will be used as the i18n key.
 */
function linkedFieldOption(id, i18nKey) {
    return (prototype, propertyKey) => {
        if (prototype.linkedFieldOptions == null) {
            prototype.linkedFieldOptions = new Map();
        }
        prototype.linkedFieldOptions.set(id, new LinkedMetadata(propertyKey, i18nKey));
    };
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/item.view.ts
class ItemView {
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/card.view.ts
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



class CardView extends ItemView {
    constructor() {
        super(...arguments);
        this.cardholderName = null;
        this.expMonth = null;
        this.expYear = null;
        this.code = null;
        this._brand = null;
        this._number = null;
        this._subTitle = null;
    }
    get maskedCode() {
        return this.code != null ? "•".repeat(this.code.length) : null;
    }
    get maskedNumber() {
        return this.number != null ? "•".repeat(this.number.length) : null;
    }
    get brand() {
        return this._brand;
    }
    set brand(value) {
        this._brand = value;
        this._subTitle = null;
    }
    get number() {
        return this._number;
    }
    set number(value) {
        this._number = value;
        this._subTitle = null;
    }
    get subTitle() {
        if (this._subTitle == null) {
            this._subTitle = this.brand;
            if (this.number != null && this.number.length >= 4) {
                if (this._subTitle != null && this._subTitle !== "") {
                    this._subTitle += ", ";
                }
                else {
                    this._subTitle = "";
                }
                // Show last 5 on amex, last 4 for all others
                const count = this.number.length >= 5 && this.number.match(new RegExp("^3[47]")) != null ? 5 : 4;
                this._subTitle += "*" + this.number.substr(this.number.length - count);
            }
        }
        return this._subTitle;
    }
    get expiration() {
        if (!this.expMonth && !this.expYear) {
            return null;
        }
        let exp = this.expMonth != null ? ("0" + this.expMonth).slice(-2) : "__";
        exp += " / " + (this.expYear != null ? this.formatYear(this.expYear) : "____");
        return exp;
    }
    formatYear(year) {
        return year.length === 2 ? "20" + year : year;
    }
    static fromJSON(obj) {
        return Object.assign(new CardView(), obj);
    }
    // ref https://stackoverflow.com/a/5911300
    static getCardBrandByPatterns(cardNum) {
        if (cardNum == null || typeof cardNum !== "string" || cardNum.trim() === "") {
            return null;
        }
        // Visa
        let re = new RegExp("^4");
        if (cardNum.match(re) != null) {
            return "Visa";
        }
        // Mastercard
        // Updated for Mastercard 2017 BINs expansion
        if (/^(5[1-5][0-9]{14}|2(22[1-9][0-9]{12}|2[3-9][0-9]{13}|[3-6][0-9]{14}|7[0-1][0-9]{13}|720[0-9]{12}))$/.test(cardNum)) {
            return "Mastercard";
        }
        // AMEX
        re = new RegExp("^3[47]");
        if (cardNum.match(re) != null) {
            return "Amex";
        }
        // Discover
        re = new RegExp("^(6011|622(12[6-9]|1[3-9][0-9]|[2-8][0-9]{2}|9[0-1][0-9]|92[0-5]|64[4-9])|65)");
        if (cardNum.match(re) != null) {
            return "Discover";
        }
        // Diners
        re = new RegExp("^36");
        if (cardNum.match(re) != null) {
            return "Diners Club";
        }
        // Diners - Carte Blanche
        re = new RegExp("^30[0-5]");
        if (cardNum.match(re) != null) {
            return "Diners Club";
        }
        // JCB
        re = new RegExp("^35(2[89]|[3-8][0-9])");
        if (cardNum.match(re) != null) {
            return "JCB";
        }
        // Visa Electron
        re = new RegExp("^(4026|417500|4508|4844|491(3|7))");
        if (cardNum.match(re) != null) {
            return "Visa";
        }
        return null;
    }
}
__decorate([
    linkedFieldOption(CardLinkedId.CardholderName),
    __metadata("design:type", String)
], CardView.prototype, "cardholderName", void 0);
__decorate([
    linkedFieldOption(CardLinkedId.ExpMonth, "expirationMonth"),
    __metadata("design:type", String)
], CardView.prototype, "expMonth", void 0);
__decorate([
    linkedFieldOption(CardLinkedId.ExpYear, "expirationYear"),
    __metadata("design:type", String)
], CardView.prototype, "expYear", void 0);
__decorate([
    linkedFieldOption(CardLinkedId.Code, "securityCode"),
    __metadata("design:type", String)
], CardView.prototype, "code", void 0);
__decorate([
    linkedFieldOption(CardLinkedId.Brand),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], CardView.prototype, "brand", null);
__decorate([
    linkedFieldOption(CardLinkedId.Number),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], CardView.prototype, "number", null);

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/field.view.ts
class FieldView {
    constructor(f) {
        this.name = null;
        this.value = null;
        this.type = null;
        this.newField = false; // Marks if the field is new and hasn't been saved
        this.showValue = false;
        this.showCount = false;
        this.linkedId = null;
        if (!f) {
            return;
        }
        this.type = f.type;
        this.linkedId = f.linkedId;
    }
    get maskedValue() {
        return this.value != null ? "••••••••" : null;
    }
    static fromJSON(obj) {
        return Object.assign(new FieldView(), obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/identity.view.ts
var identity_view_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var identity_view_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




class IdentityView extends ItemView {
    constructor() {
        super();
        this.title = null;
        this.middleName = null;
        this.address1 = null;
        this.address2 = null;
        this.address3 = null;
        this.city = null;
        this.state = null;
        this.postalCode = null;
        this.country = null;
        this.company = null;
        this.email = null;
        this.phone = null;
        this.ssn = null;
        this.username = null;
        this.passportNumber = null;
        this.licenseNumber = null;
        this._firstName = null;
        this._lastName = null;
        this._subTitle = null;
    }
    get firstName() {
        return this._firstName;
    }
    set firstName(value) {
        this._firstName = value;
        this._subTitle = null;
    }
    get lastName() {
        return this._lastName;
    }
    set lastName(value) {
        this._lastName = value;
        this._subTitle = null;
    }
    get subTitle() {
        if (this._subTitle == null && (this.firstName != null || this.lastName != null)) {
            this._subTitle = "";
            if (this.firstName != null) {
                this._subTitle = this.firstName;
            }
            if (this.lastName != null) {
                if (this._subTitle !== "") {
                    this._subTitle += " ";
                }
                this._subTitle += this.lastName;
            }
        }
        return this._subTitle;
    }
    get fullName() {
        if (this.title != null ||
            this.firstName != null ||
            this.middleName != null ||
            this.lastName != null) {
            let name = "";
            if (this.title != null) {
                name += this.title + " ";
            }
            if (this.firstName != null) {
                name += this.firstName + " ";
            }
            if (this.middleName != null) {
                name += this.middleName + " ";
            }
            if (this.lastName != null) {
                name += this.lastName;
            }
            return name.trim();
        }
        return null;
    }
    get fullAddress() {
        let address = this.address1;
        if (!utils_Utils.isNullOrWhitespace(this.address2)) {
            if (!utils_Utils.isNullOrWhitespace(address)) {
                address += ", ";
            }
            address += this.address2;
        }
        if (!utils_Utils.isNullOrWhitespace(this.address3)) {
            if (!utils_Utils.isNullOrWhitespace(address)) {
                address += ", ";
            }
            address += this.address3;
        }
        return address;
    }
    get fullAddressPart2() {
        if (this.city == null && this.state == null && this.postalCode == null) {
            return null;
        }
        const city = this.city || "-";
        const state = this.state;
        const postalCode = this.postalCode || "-";
        let addressPart2 = city;
        if (!utils_Utils.isNullOrWhitespace(state)) {
            addressPart2 += ", " + state;
        }
        addressPart2 += ", " + postalCode;
        return addressPart2;
    }
    static fromJSON(obj) {
        return Object.assign(new IdentityView(), obj);
    }
}
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Title),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "title", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.MiddleName),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "middleName", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Address1),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "address1", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Address2),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "address2", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Address3),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "address3", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.City, "cityTown"),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "city", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.State, "stateProvince"),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "state", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.PostalCode, "zipPostalCode"),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "postalCode", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Country),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "country", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Company),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "company", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Email),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "email", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Phone),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "phone", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Ssn),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "ssn", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.Username),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "username", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.PassportNumber),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "passportNumber", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.LicenseNumber),
    identity_view_metadata("design:type", String)
], IdentityView.prototype, "licenseNumber", void 0);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.FirstName),
    identity_view_metadata("design:type", String),
    identity_view_metadata("design:paramtypes", [String])
], IdentityView.prototype, "firstName", null);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.LastName),
    identity_view_metadata("design:type", String),
    identity_view_metadata("design:paramtypes", [String])
], IdentityView.prototype, "lastName", null);
identity_view_decorate([
    linkedFieldOption(IdentityLinkedId.FullName),
    identity_view_metadata("design:type", String),
    identity_view_metadata("design:paramtypes", [])
], IdentityView.prototype, "fullName", null);

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/fido2-credential.view.ts

class Fido2CredentialView extends ItemView {
    constructor() {
        super(...arguments);
        this.creationDate = null;
    }
    get subTitle() {
        return this.userDisplayName;
    }
    static fromJSON(obj) {
        const creationDate = obj.creationDate != null ? new Date(obj.creationDate) : null;
        return Object.assign(new Fido2CredentialView(), obj, {
            creationDate,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/misc/safe-urls.ts

const CanLaunchWhitelist = [
    "https://",
    "http://",
    "ssh://",
    "ftp://",
    "sftp://",
    "irc://",
    "vnc://",
    // https://docs.microsoft.com/en-us/windows-server/remote/remote-desktop-services/clients/remote-desktop-uri
    "rdp://",
    "ms-rd:",
    "chrome://",
    "iosapp://",
    "androidapp://",
];
class SafeUrls {
    static canLaunch(uri) {
        if (utils_Utils.isNullOrWhitespace(uri)) {
            return false;
        }
        for (let i = 0; i < CanLaunchWhitelist.length; i++) {
            if (uri.indexOf(CanLaunchWhitelist[i]) === 0) {
                return true;
            }
        }
        return false;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/login-uri.view.ts



class LoginUriView {
    constructor(u) {
        this.match = null;
        this._uri = null;
        this._domain = null;
        this._hostname = null;
        this._host = null;
        this._canLaunch = null;
        if (!u) {
            return;
        }
        this.match = u.match;
    }
    get uri() {
        return this._uri;
    }
    set uri(value) {
        this._uri = value;
        this._domain = null;
        this._canLaunch = null;
    }
    get domain() {
        if (this._domain == null && this.uri != null) {
            this._domain = utils_Utils.getDomain(this.uri);
            if (this._domain === "") {
                this._domain = null;
            }
        }
        return this._domain;
    }
    get hostname() {
        if (this.match === UriMatchType.RegularExpression) {
            return null;
        }
        if (this._hostname == null && this.uri != null) {
            this._hostname = utils_Utils.getHostname(this.uri);
            if (this._hostname === "") {
                this._hostname = null;
            }
        }
        return this._hostname;
    }
    get host() {
        if (this.match === UriMatchType.RegularExpression) {
            return null;
        }
        if (this._host == null && this.uri != null) {
            this._host = utils_Utils.getHost(this.uri);
            if (this._host === "") {
                this._host = null;
            }
        }
        return this._host;
    }
    get hostnameOrUri() {
        return this.hostname != null ? this.hostname : this.uri;
    }
    get hostOrUri() {
        return this.host != null ? this.host : this.uri;
    }
    get isWebsite() {
        return (this.uri != null &&
            (this.uri.indexOf("http://") === 0 ||
                this.uri.indexOf("https://") === 0 ||
                (this.uri.indexOf("://") < 0 && !utils_Utils.isNullOrWhitespace(utils_Utils.getDomain(this.uri)))));
    }
    get canLaunch() {
        if (this._canLaunch != null) {
            return this._canLaunch;
        }
        if (this.uri != null && this.match !== UriMatchType.RegularExpression) {
            this._canLaunch = SafeUrls.canLaunch(this.launchUri);
        }
        else {
            this._canLaunch = false;
        }
        return this._canLaunch;
    }
    get launchUri() {
        return this.uri.indexOf("://") < 0 && !utils_Utils.isNullOrWhitespace(utils_Utils.getDomain(this.uri))
            ? "http://" + this.uri
            : this.uri;
    }
    static fromJSON(obj) {
        return Object.assign(new LoginUriView(), obj);
    }
    matchesUri(targetUri, equivalentDomains, defaultUriMatch = null) {
        var _a;
        if (!this.uri || !targetUri) {
            return false;
        }
        let matchType = (_a = this.match) !== null && _a !== void 0 ? _a : defaultUriMatch;
        matchType !== null && matchType !== void 0 ? matchType : (matchType = UriMatchType.Domain);
        const targetDomain = utils_Utils.getDomain(targetUri);
        const matchDomains = equivalentDomains.add(targetDomain);
        switch (matchType) {
            case UriMatchType.Domain:
                return this.matchesDomain(targetUri, matchDomains);
            case UriMatchType.Host: {
                const urlHost = utils_Utils.getHost(targetUri);
                return urlHost != null && urlHost === utils_Utils.getHost(this.uri);
            }
            case UriMatchType.Exact:
                return targetUri === this.uri;
            case UriMatchType.StartsWith:
                return targetUri.startsWith(this.uri);
            case UriMatchType.RegularExpression:
                try {
                    const regex = new RegExp(this.uri, "i");
                    return regex.test(targetUri);
                }
                catch (e) {
                    // Invalid regex
                    return false;
                }
            case UriMatchType.Never:
                return false;
            default:
                break;
        }
        return false;
    }
    matchesDomain(targetUri, matchDomains) {
        if (targetUri == null || this.domain == null || !matchDomains.has(this.domain)) {
            return false;
        }
        if (utils_Utils.DomainMatchBlacklist.has(this.domain)) {
            const domainUrlHost = utils_Utils.getHost(targetUri);
            return !utils_Utils.DomainMatchBlacklist.get(this.domain).has(domainUrlHost);
        }
        return true;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/login.view.ts
var login_view_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var login_view_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};






class LoginView extends ItemView {
    constructor(l) {
        super();
        this.username = null;
        this.password = null;
        this.passwordRevisionDate = null;
        this.totp = null;
        this.uris = [];
        this.autofillOnPageLoad = null;
        this.fido2Credentials = null;
        if (!l) {
            return;
        }
        this.passwordRevisionDate = l.passwordRevisionDate;
        this.autofillOnPageLoad = l.autofillOnPageLoad;
    }
    get uri() {
        return this.hasUris ? this.uris[0].uri : null;
    }
    get maskedPassword() {
        return this.password != null ? "••••••••" : null;
    }
    get subTitle() {
        return this.username;
    }
    get canLaunch() {
        return this.hasUris && this.uris.some((u) => u.canLaunch);
    }
    get hasTotp() {
        return !utils_Utils.isNullOrWhitespace(this.totp);
    }
    get launchUri() {
        if (this.hasUris) {
            const uri = this.uris.find((u) => u.canLaunch);
            if (uri != null) {
                return uri.launchUri;
            }
        }
        return null;
    }
    get hasUris() {
        return this.uris != null && this.uris.length > 0;
    }
    get hasFido2Credentials() {
        return this.fido2Credentials != null && this.fido2Credentials.length > 0;
    }
    matchesUri(targetUri, equivalentDomains, defaultUriMatch = null) {
        if (this.uris == null) {
            return false;
        }
        return this.uris.some((uri) => uri.matchesUri(targetUri, equivalentDomains, defaultUriMatch));
    }
    static fromJSON(obj) {
        var _a;
        const passwordRevisionDate = obj.passwordRevisionDate == null ? null : new Date(obj.passwordRevisionDate);
        const uris = obj.uris.map((uri) => LoginUriView.fromJSON(uri));
        const fido2Credentials = (_a = obj.fido2Credentials) === null || _a === void 0 ? void 0 : _a.map((key) => Fido2CredentialView.fromJSON(key));
        return Object.assign(new LoginView(), obj, {
            passwordRevisionDate,
            uris,
            fido2Credentials,
        });
    }
}
login_view_decorate([
    linkedFieldOption(LoginLinkedId.Username),
    login_view_metadata("design:type", String)
], LoginView.prototype, "username", void 0);
login_view_decorate([
    linkedFieldOption(LoginLinkedId.Password),
    login_view_metadata("design:type", String)
], LoginView.prototype, "password", void 0);

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/password-history.view.ts
class PasswordHistoryView {
    constructor(ph) {
        this.password = null;
        this.lastUsedDate = null;
        if (!ph) {
            return;
        }
        this.lastUsedDate = ph.lastUsedDate;
    }
    static fromJSON(obj) {
        const lastUsedDate = obj.lastUsedDate == null ? null : new Date(obj.lastUsedDate);
        return Object.assign(new PasswordHistoryView(), obj, {
            lastUsedDate: lastUsedDate,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/secure-note.view.ts

class SecureNoteView extends ItemView {
    constructor(n) {
        super();
        this.type = null;
        if (!n) {
            return;
        }
        this.type = n.type;
    }
    get subTitle() {
        return null;
    }
    static fromJSON(obj) {
        return Object.assign(new SecureNoteView(), obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/cipher.view.ts










class CipherView {
    constructor(c) {
        var _a;
        this.initializerKey = InitializerKey.CipherView;
        this.id = null;
        this.organizationId = null;
        this.folderId = null;
        this.name = null;
        this.notes = null;
        this.type = null;
        this.favorite = false;
        this.organizationUseTotp = false;
        this.edit = false;
        this.viewPassword = true;
        this.login = new LoginView();
        this.identity = new IdentityView();
        this.card = new CardView();
        this.secureNote = new SecureNoteView();
        this.attachments = null;
        this.fields = null;
        this.passwordHistory = null;
        this.collectionIds = null;
        this.revisionDate = null;
        this.creationDate = null;
        this.deletedDate = null;
        this.reprompt = CipherRepromptType.None;
        if (!c) {
            return;
        }
        this.id = c.id;
        this.organizationId = c.organizationId;
        this.folderId = c.folderId;
        this.favorite = c.favorite;
        this.organizationUseTotp = c.organizationUseTotp;
        this.edit = c.edit;
        this.viewPassword = c.viewPassword;
        this.type = c.type;
        this.localData = c.localData;
        this.collectionIds = c.collectionIds;
        this.revisionDate = c.revisionDate;
        this.creationDate = c.creationDate;
        this.deletedDate = c.deletedDate;
        // Old locally stored ciphers might have reprompt == null. If so set it to None.
        this.reprompt = (_a = c.reprompt) !== null && _a !== void 0 ? _a : CipherRepromptType.None;
    }
    get item() {
        switch (this.type) {
            case CipherType.Login:
                return this.login;
            case CipherType.SecureNote:
                return this.secureNote;
            case CipherType.Card:
                return this.card;
            case CipherType.Identity:
                return this.identity;
            default:
                break;
        }
        return null;
    }
    get subTitle() {
        var _a;
        return (_a = this.item) === null || _a === void 0 ? void 0 : _a.subTitle;
    }
    get hasPasswordHistory() {
        return this.passwordHistory && this.passwordHistory.length > 0;
    }
    get hasAttachments() {
        return this.attachments && this.attachments.length > 0;
    }
    get hasOldAttachments() {
        if (this.hasAttachments) {
            for (let i = 0; i < this.attachments.length; i++) {
                if (this.attachments[i].key == null) {
                    return true;
                }
            }
        }
        return false;
    }
    get hasFields() {
        return this.fields && this.fields.length > 0;
    }
    get passwordRevisionDisplayDate() {
        if (this.type !== CipherType.Login || this.login == null) {
            return null;
        }
        else if (this.login.password == null || this.login.password === "") {
            return null;
        }
        return this.login.passwordRevisionDate;
    }
    get isDeleted() {
        return this.deletedDate != null;
    }
    get linkedFieldOptions() {
        var _a;
        return (_a = this.item) === null || _a === void 0 ? void 0 : _a.linkedFieldOptions;
    }
    linkedFieldValue(id) {
        var _a;
        const linkedFieldOption = (_a = this.linkedFieldOptions) === null || _a === void 0 ? void 0 : _a.get(id);
        if (linkedFieldOption == null) {
            return null;
        }
        const item = this.item;
        return this.item[linkedFieldOption.propertyKey];
    }
    linkedFieldI18nKey(id) {
        var _a;
        return (_a = this.linkedFieldOptions.get(id)) === null || _a === void 0 ? void 0 : _a.i18nKey;
    }
    // This is used as a marker to indicate that the cipher view object still has its prototype
    toJSON() {
        return this;
    }
    static fromJSON(obj) {
        var _a, _b, _c;
        if (obj == null) {
            return null;
        }
        const view = new CipherView();
        const revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        const deletedDate = obj.deletedDate == null ? null : new Date(obj.deletedDate);
        const attachments = (_a = obj.attachments) === null || _a === void 0 ? void 0 : _a.map((a) => AttachmentView.fromJSON(a));
        const fields = (_b = obj.fields) === null || _b === void 0 ? void 0 : _b.map((f) => FieldView.fromJSON(f));
        const passwordHistory = (_c = obj.passwordHistory) === null || _c === void 0 ? void 0 : _c.map((ph) => PasswordHistoryView.fromJSON(ph));
        Object.assign(view, obj, {
            revisionDate: revisionDate,
            deletedDate: deletedDate,
            attachments: attachments,
            fields: fields,
            passwordHistory: passwordHistory,
        });
        switch (obj.type) {
            case CipherType.Card:
                view.card = CardView.fromJSON(obj.card);
                break;
            case CipherType.Identity:
                view.identity = IdentityView.fromJSON(obj.identity);
                break;
            case CipherType.Login:
                view.login = LoginView.fromJSON(obj.login);
                break;
            case CipherType.SecureNote:
                view.secureNote = SecureNoteView.fromJSON(obj.secureNote);
                break;
            default:
                break;
        }
        return view;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/data/server-config.data.ts
class ServerConfigData {
    constructor(serverConfigResponse) {
        this.featureStates = {};
        this.version = serverConfigResponse === null || serverConfigResponse === void 0 ? void 0 : serverConfigResponse.version;
        this.gitHash = serverConfigResponse === null || serverConfigResponse === void 0 ? void 0 : serverConfigResponse.gitHash;
        this.server = (serverConfigResponse === null || serverConfigResponse === void 0 ? void 0 : serverConfigResponse.server)
            ? new ThirdPartyServerConfigData(serverConfigResponse.server)
            : null;
        this.utcDate = new Date().toISOString();
        this.environment = (serverConfigResponse === null || serverConfigResponse === void 0 ? void 0 : serverConfigResponse.environment)
            ? new EnvironmentServerConfigData(serverConfigResponse.environment)
            : null;
        this.featureStates = serverConfigResponse === null || serverConfigResponse === void 0 ? void 0 : serverConfigResponse.featureStates;
    }
    static fromJSON(obj) {
        return Object.assign(new ServerConfigData({}), obj, {
            server: (obj === null || obj === void 0 ? void 0 : obj.server) ? ThirdPartyServerConfigData.fromJSON(obj.server) : null,
            environment: (obj === null || obj === void 0 ? void 0 : obj.environment) ? EnvironmentServerConfigData.fromJSON(obj.environment) : null,
        });
    }
}
class ThirdPartyServerConfigData {
    constructor(response) {
        this.name = response.name;
        this.url = response.url;
    }
    static fromJSON(obj) {
        return Object.assign(new ThirdPartyServerConfigData({}), obj);
    }
}
class EnvironmentServerConfigData {
    constructor(response) {
        this.cloudRegion = response.cloudRegion;
        this.vault = response.vault;
        this.api = response.api;
        this.identity = response.identity;
        this.notifications = response.notifications;
        this.sso = response.sso;
    }
    static fromJSON(obj) {
        return Object.assign(new EnvironmentServerConfigData({}), obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/account.ts








class EncryptionPair {
    toJSON() {
        return {
            encrypted: this.encrypted,
            decrypted: this.decrypted instanceof ArrayBuffer
                ? utils_Utils.fromBufferToByteString(this.decrypted)
                : this.decrypted,
        };
    }
    static fromJSON(obj, decryptedFromJson, encryptedFromJson) {
        if (obj == null) {
            return null;
        }
        const pair = new EncryptionPair();
        if ((obj === null || obj === void 0 ? void 0 : obj.encrypted) != null) {
            pair.encrypted = encryptedFromJson
                ? encryptedFromJson(obj.encrypted)
                : obj.encrypted;
        }
        if ((obj === null || obj === void 0 ? void 0 : obj.decrypted) != null) {
            pair.decrypted = decryptedFromJson
                ? decryptedFromJson(obj.decrypted)
                : obj.decrypted;
        }
        return pair;
    }
}
class DataEncryptionPair {
}
// This is a temporary structure to handle migrated `DataEncryptionPair` to
//  avoid needing a data migration at this stage. It should be replaced with
//  proper data migrations when `DataEncryptionPair` is deprecated.
class TemporaryDataEncryption {
}
class AccountData {
    constructor() {
        this.ciphers = new DataEncryptionPair();
        this.folders = new TemporaryDataEncryption();
        this.sends = new DataEncryptionPair();
        this.collections = new DataEncryptionPair();
        this.policies = new DataEncryptionPair();
        this.passwordGenerationHistory = new EncryptionPair();
    }
    static fromJSON(obj) {
        var _a, _b;
        if (obj == null) {
            return null;
        }
        return Object.assign(new AccountData(), obj, {
            addEditCipherInfo: {
                cipher: CipherView.fromJSON((_a = obj === null || obj === void 0 ? void 0 : obj.addEditCipherInfo) === null || _a === void 0 ? void 0 : _a.cipher),
                collectionIds: (_b = obj === null || obj === void 0 ? void 0 : obj.addEditCipherInfo) === null || _b === void 0 ? void 0 : _b.collectionIds,
            },
        });
    }
}
class AccountKeys {
    constructor() {
        this.providerKeys = new EncryptionPair();
        this.privateKey = new EncryptionPair();
        /** @deprecated July 2023, left for migration purposes*/
        this.cryptoSymmetricKey = new EncryptionPair();
    }
    toJSON() {
        // If you pass undefined into fromBufferToByteString, you will get an empty string back
        // which will cause all sorts of headaches down the line when you try to getPublicKey
        // and expect a Uint8Array and get an empty string instead.
        return utils_Utils.merge(this, {
            publicKey: this.publicKey ? utils_Utils.fromBufferToByteString(this.publicKey) : undefined,
        });
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new AccountKeys(), obj, {
            userKey: SymmetricCryptoKey.fromJSON(obj === null || obj === void 0 ? void 0 : obj.userKey),
            masterKey: SymmetricCryptoKey.fromJSON(obj === null || obj === void 0 ? void 0 : obj.masterKey),
            deviceKey: obj === null || obj === void 0 ? void 0 : obj.deviceKey,
            cryptoMasterKey: SymmetricCryptoKey.fromJSON(obj === null || obj === void 0 ? void 0 : obj.cryptoMasterKey),
            cryptoSymmetricKey: EncryptionPair.fromJSON(obj === null || obj === void 0 ? void 0 : obj.cryptoSymmetricKey, SymmetricCryptoKey.fromJSON),
            providerKeys: AccountKeys.initRecordEncryptionPairsFromJSON(obj === null || obj === void 0 ? void 0 : obj.providerKeys),
            privateKey: EncryptionPair.fromJSON(obj === null || obj === void 0 ? void 0 : obj.privateKey, (decObj) => utils_Utils.fromByteStringToArray(decObj)),
            publicKey: utils_Utils.fromByteStringToArray(obj === null || obj === void 0 ? void 0 : obj.publicKey),
        });
    }
    static initRecordEncryptionPairsFromJSON(obj) {
        return EncryptionPair.fromJSON(obj, (decObj) => {
            if (obj == null) {
                return null;
            }
            const record = {};
            for (const id in decObj) {
                record[id] = SymmetricCryptoKey.fromJSON(decObj[id]);
            }
            return record;
        });
    }
}
class AccountProfile {
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new AccountProfile(), obj);
    }
}
class AccountSettings {
    constructor() {
        this.vaultTimeoutAction = "lock";
        /** @deprecated July 2023, left for migration purposes*/
        this.pinProtected = new EncryptionPair();
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new AccountSettings(), obj, {
            pinProtected: EncryptionPair.fromJSON(obj === null || obj === void 0 ? void 0 : obj.pinProtected, EncString.fromJSON),
            serverConfig: ServerConfigData.fromJSON(obj === null || obj === void 0 ? void 0 : obj.serverConfig),
        });
    }
}
class AccountTokens {
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new AccountTokens(), obj);
    }
}
class AccountDecryptionOptions {
    constructor(init) {
        if (init) {
            Object.assign(this, init);
        }
    }
    // TODO: these nice getters don't work because the Account object is not properly being deserialized out of
    // JSON (the Account static fromJSON method is not running) so these getters don't exist on the
    // account decryptions options object when pulled out of state.  This is a bug that needs to be fixed later on
    // get hasTrustedDeviceOption(): boolean {
    //   return this.trustedDeviceOption !== null && this.trustedDeviceOption !== undefined;
    // }
    // get hasKeyConnectorOption(): boolean {
    //   return this.keyConnectorOption !== null && this.keyConnectorOption !== undefined;
    // }
    static fromResponse(response) {
        if (response == null) {
            return null;
        }
        const accountDecryptionOptions = new AccountDecryptionOptions();
        if (response.userDecryptionOptions) {
            // If the response has userDecryptionOptions, this means it's on a post-TDE server version and can interrogate
            // the new decryption options.
            const responseOptions = response.userDecryptionOptions;
            accountDecryptionOptions.hasMasterPassword = responseOptions.hasMasterPassword;
            if (responseOptions.trustedDeviceOption) {
                accountDecryptionOptions.trustedDeviceOption = new TrustedDeviceUserDecryptionOption(responseOptions.trustedDeviceOption.hasAdminApproval, responseOptions.trustedDeviceOption.hasLoginApprovingDevice, responseOptions.trustedDeviceOption.hasManageResetPasswordPermission);
            }
            if (responseOptions.keyConnectorOption) {
                accountDecryptionOptions.keyConnectorOption = new KeyConnectorUserDecryptionOption(responseOptions.keyConnectorOption.keyConnectorUrl);
            }
        }
        else {
            // If the response does not have userDecryptionOptions, this means it's on a pre-TDE server version and so
            // we must base our decryption options on the presence of the keyConnectorUrl.
            // Note that the presence of keyConnectorUrl implies that the user does not have a master password, as in pre-TDE
            // server versions, a master password short-circuited the addition of the keyConnectorUrl to the response.
            // TODO: remove this check after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
            const usingKeyConnector = response.keyConnectorUrl != null;
            accountDecryptionOptions.hasMasterPassword = !usingKeyConnector;
            if (usingKeyConnector) {
                accountDecryptionOptions.keyConnectorOption = new KeyConnectorUserDecryptionOption(response.keyConnectorUrl);
            }
        }
        return accountDecryptionOptions;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const accountDecryptionOptions = Object.assign(new AccountDecryptionOptions(), obj);
        if (obj.trustedDeviceOption) {
            accountDecryptionOptions.trustedDeviceOption = new TrustedDeviceUserDecryptionOption(obj.trustedDeviceOption.hasAdminApproval, obj.trustedDeviceOption.hasLoginApprovingDevice, obj.trustedDeviceOption.hasManageResetPasswordPermission);
        }
        if (obj.keyConnectorOption) {
            accountDecryptionOptions.keyConnectorOption = new KeyConnectorUserDecryptionOption(obj.keyConnectorOption.keyConnectorUrl);
        }
        return accountDecryptionOptions;
    }
}
class LoginState {
    constructor(init) {
        if (init) {
            Object.assign(this, init);
        }
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const loginState = Object.assign(new LoginState(), obj);
        return loginState;
    }
}
class Account {
    constructor(init) {
        this.data = new AccountData();
        this.keys = new AccountKeys();
        this.profile = new AccountProfile();
        this.settings = new AccountSettings();
        this.tokens = new AccountTokens();
        this.decryptionOptions = new AccountDecryptionOptions();
        this.loginState = new LoginState();
        this.adminAuthRequest = null;
        Object.assign(this, {
            data: Object.assign(Object.assign({}, new AccountData()), init === null || init === void 0 ? void 0 : init.data),
            keys: Object.assign(Object.assign({}, new AccountKeys()), init === null || init === void 0 ? void 0 : init.keys),
            profile: Object.assign(Object.assign({}, new AccountProfile()), init === null || init === void 0 ? void 0 : init.profile),
            settings: Object.assign(Object.assign({}, new AccountSettings()), init === null || init === void 0 ? void 0 : init.settings),
            tokens: Object.assign(Object.assign({}, new AccountTokens()), init === null || init === void 0 ? void 0 : init.tokens),
            decryptionOptions: Object.assign(Object.assign({}, new AccountDecryptionOptions()), init === null || init === void 0 ? void 0 : init.decryptionOptions),
            loginState: Object.assign(Object.assign({}, new LoginState()), init === null || init === void 0 ? void 0 : init.loginState),
            adminAuthRequest: init === null || init === void 0 ? void 0 : init.adminAuthRequest,
        });
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new Account({}), json, {
            keys: AccountKeys.fromJSON(json === null || json === void 0 ? void 0 : json.keys),
            data: AccountData.fromJSON(json === null || json === void 0 ? void 0 : json.data),
            profile: AccountProfile.fromJSON(json === null || json === void 0 ? void 0 : json.profile),
            settings: AccountSettings.fromJSON(json === null || json === void 0 ? void 0 : json.settings),
            tokens: AccountTokens.fromJSON(json === null || json === void 0 ? void 0 : json.tokens),
            decryptionOptions: AccountDecryptionOptions.fromJSON(json === null || json === void 0 ? void 0 : json.decryptionOptions),
            loginState: LoginState.fromJSON(json === null || json === void 0 ? void 0 : json.loginState),
            adminAuthRequest: AdminAuthRequestStorable.fromJSON(json === null || json === void 0 ? void 0 : json.adminAuthRequest),
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/two-factor-provider-type.ts
var TwoFactorProviderType;
(function (TwoFactorProviderType) {
    TwoFactorProviderType[TwoFactorProviderType["Authenticator"] = 0] = "Authenticator";
    TwoFactorProviderType[TwoFactorProviderType["Email"] = 1] = "Email";
    TwoFactorProviderType[TwoFactorProviderType["Duo"] = 2] = "Duo";
    TwoFactorProviderType[TwoFactorProviderType["Yubikey"] = 3] = "Yubikey";
    TwoFactorProviderType[TwoFactorProviderType["U2f"] = 4] = "U2f";
    TwoFactorProviderType[TwoFactorProviderType["Remember"] = 5] = "Remember";
    TwoFactorProviderType[TwoFactorProviderType["OrganizationDuo"] = 6] = "OrganizationDuo";
    TwoFactorProviderType[TwoFactorProviderType["WebAuthn"] = 7] = "WebAuthn";
})(TwoFactorProviderType || (TwoFactorProviderType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/force-set-password-reason.ts
/*
 * This enum is used to determine if a user should be forced to initially set or reset their password
 * on login (server flag) or unlock via MP (client evaluation).
 */
var ForceSetPasswordReason;
(function (ForceSetPasswordReason) {
    /**
     * A password reset should not be forced.
     */
    ForceSetPasswordReason[ForceSetPasswordReason["None"] = 0] = "None";
    /**
     * Occurs when an organization admin forces a user to reset their password.
     * Communicated via server flag.
     */
    ForceSetPasswordReason[ForceSetPasswordReason["AdminForcePasswordReset"] = 1] = "AdminForcePasswordReset";
    /**
     * Occurs when a user logs in / unlocks their vault with a master password that does not meet an organization's
     * master password policy that is enforced on login/unlock.
     * Only set client side b/c server can't evaluate MP.
     */
    ForceSetPasswordReason[ForceSetPasswordReason["WeakMasterPassword"] = 2] = "WeakMasterPassword";
    /**
     * Occurs when a TDE user without a password obtains the password reset permission.
     * Set post login & decryption client side and by server in sync (to catch logged in users).
     */
    ForceSetPasswordReason[ForceSetPasswordReason["TdeUserWithoutPasswordHasPasswordResetPermission"] = 3] = "TdeUserWithoutPasswordHasPasswordResetPermission";
})(ForceSetPasswordReason || (ForceSetPasswordReason = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/auth-result.ts


class AuthResult {
    constructor() {
        this.captchaSiteKey = "";
        // TODO: PM-3287 - Remove this after 3 releases of backwards compatibility. - Target release 2023.12 for removal
        /**
         * @deprecated
         * Replace with using AccountDecryptionOptions to determine if the user does
         * not have a master password and is not using Key Connector.
         * */
        this.resetMasterPassword = false;
        this.forcePasswordReset = ForceSetPasswordReason.None;
        this.twoFactorProviders = null;
    }
    get requiresCaptcha() {
        return !utils_Utils.isNullOrWhitespace(this.captchaSiteKey);
    }
    get requiresTwoFactor() {
        return this.twoFactorProviders != null;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/device.request.ts
class DeviceRequest {
    constructor(appId, platformUtilsService) {
        this.type = platformUtilsService.getDevice();
        this.name = platformUtilsService.getDeviceString();
        this.identifier = appId;
        this.pushToken = null;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/token-two-factor.request.ts
class TokenTwoFactorRequest {
    constructor(provider = null, token = null, remember = false) {
        this.provider = provider;
        this.token = token;
        this.remember = remember;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/identity-captcha.response.ts

class IdentityCaptchaResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.siteKey = this.getResponseProperty("HCaptcha_SiteKey");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/master-password-policy.response.ts

class MasterPasswordPolicyResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.minComplexity = this.getResponseProperty("MinComplexity");
        this.minLength = this.getResponseProperty("MinLength");
        this.requireUpper = this.getResponseProperty("RequireUpper");
        this.requireLower = this.getResponseProperty("RequireLower");
        this.requireNumbers = this.getResponseProperty("RequireNumbers");
        this.requireSpecial = this.getResponseProperty("RequireSpecial");
        this.enforceOnLogin = this.getResponseProperty("EnforceOnLogin");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/user-decryption-options/key-connector-user-decryption-option.response.ts

class KeyConnectorUserDecryptionOptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/user-decryption-options/trusted-device-user-decryption-option.response.ts


class TrustedDeviceUserDecryptionOptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.hasAdminApproval = this.getResponseProperty("HasAdminApproval");
        this.hasLoginApprovingDevice = this.getResponseProperty("HasLoginApprovingDevice");
        this.hasManageResetPasswordPermission = this.getResponseProperty("HasManageResetPasswordPermission");
        if (response.EncryptedPrivateKey) {
            this.encryptedPrivateKey = new EncString(this.getResponseProperty("EncryptedPrivateKey"));
        }
        if (response.EncryptedUserKey) {
            this.encryptedUserKey = new EncString(this.getResponseProperty("EncryptedUserKey"));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/user-decryption-options/webauthn-prf-decryption-option.response.ts


class WebAuthnPrfDecryptionOptionResponse extends BaseResponse {
    constructor(response) {
        super(response);
        if (response.EncryptedPrivateKey) {
            this.encryptedPrivateKey = new EncString(this.getResponseProperty("EncryptedPrivateKey"));
        }
        if (response.EncryptedUserKey) {
            this.encryptedUserKey = new EncString(this.getResponseProperty("EncryptedUserKey"));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/user-decryption-options/user-decryption-options.response.ts




class UserDecryptionOptionsResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.hasMasterPassword = this.getResponseProperty("HasMasterPassword");
        if (response.TrustedDeviceOption) {
            this.trustedDeviceOption = new TrustedDeviceUserDecryptionOptionResponse(this.getResponseProperty("TrustedDeviceOption"));
        }
        if (response.KeyConnectorOption) {
            this.keyConnectorOption = new KeyConnectorUserDecryptionOptionResponse(this.getResponseProperty("KeyConnectorOption"));
        }
        if (response.WebAuthnPrfOption) {
            this.webAuthnPrfOption = new WebAuthnPrfDecryptionOptionResponse(this.getResponseProperty("WebAuthnPrfOption"));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/identity-token.response.ts



class IdentityTokenResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.accessToken = response.access_token;
        this.expiresIn = response.expires_in;
        this.refreshToken = response.refresh_token;
        this.tokenType = response.token_type;
        this.resetMasterPassword = this.getResponseProperty("ResetMasterPassword");
        this.privateKey = this.getResponseProperty("PrivateKey");
        this.key = this.getResponseProperty("Key");
        this.twoFactorToken = this.getResponseProperty("TwoFactorToken");
        this.kdf = this.getResponseProperty("Kdf");
        this.kdfIterations = this.getResponseProperty("KdfIterations");
        this.kdfMemory = this.getResponseProperty("KdfMemory");
        this.kdfParallelism = this.getResponseProperty("KdfParallelism");
        this.forcePasswordReset = this.getResponseProperty("ForcePasswordReset");
        this.apiUseKeyConnector = this.getResponseProperty("ApiUseKeyConnector");
        this.keyConnectorUrl = this.getResponseProperty("KeyConnectorUrl");
        this.masterPasswordPolicy = new MasterPasswordPolicyResponse(this.getResponseProperty("MasterPasswordPolicy"));
        if (response.UserDecryptionOptions) {
            this.userDecryptionOptions = new UserDecryptionOptionsResponse(this.getResponseProperty("UserDecryptionOptions"));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/identity-two-factor.response.ts


class IdentityTwoFactorResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.twoFactorProviders2 = new Map();
        this.captchaToken = this.getResponseProperty("CaptchaBypassToken");
        this.twoFactorProviders = this.getResponseProperty("TwoFactorProviders");
        const twoFactorProviders2 = this.getResponseProperty("TwoFactorProviders2");
        if (twoFactorProviders2 != null) {
            for (const prop in twoFactorProviders2) {
                // eslint-disable-next-line
                if (twoFactorProviders2.hasOwnProperty(prop)) {
                    this.twoFactorProviders2.set(parseInt(prop, null), twoFactorProviders2[prop]);
                }
            }
        }
        this.masterPasswordPolicy = new MasterPasswordPolicyResponse(this.getResponseProperty("MasterPasswordPolicy"));
        this.ssoEmail2faSessionToken = this.getResponseProperty("SsoEmail2faSessionToken");
        this.email = this.getResponseProperty("Email");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/login-strategies/login.strategy.ts
var login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};











class LoginStrategy {
    constructor(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService) {
        this.cryptoService = cryptoService;
        this.apiService = apiService;
        this.tokenService = tokenService;
        this.appIdService = appIdService;
        this.platformUtilsService = platformUtilsService;
        this.messagingService = messagingService;
        this.logService = logService;
        this.stateService = stateService;
        this.twoFactorService = twoFactorService;
        this.captchaBypassToken = null;
    }
    logInTwoFactor(twoFactor, captchaResponse = null) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            this.tokenRequest.setTwoFactor(twoFactor);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    startLogIn() {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            this.twoFactorService.clearSelectedProvider();
            const response = yield this.apiService.postIdentityToken(this.tokenRequest);
            if (response instanceof IdentityTwoFactorResponse) {
                return [yield this.processTwoFactorResponse(response), response];
            }
            else if (response instanceof IdentityCaptchaResponse) {
                return [yield this.processCaptchaResponse(response), response];
            }
            else if (response instanceof IdentityTokenResponse) {
                return [yield this.processTokenResponse(response), response];
            }
            throw new Error("Invalid response object.");
        });
    }
    buildDeviceRequest() {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const appId = yield this.appIdService.getAppId();
            return new DeviceRequest(appId, this.platformUtilsService);
        });
    }
    buildTwoFactor(userProvidedTwoFactor) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            if (userProvidedTwoFactor != null) {
                return userProvidedTwoFactor;
            }
            const storedTwoFactorToken = yield this.tokenService.getTwoFactorToken();
            if (storedTwoFactorToken != null) {
                return new TokenTwoFactorRequest(TwoFactorProviderType.Remember, storedTwoFactorToken, false);
            }
            return new TokenTwoFactorRequest();
        });
    }
    saveAccountInformation(tokenResponse) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const accountInformation = yield this.tokenService.decodeToken(tokenResponse.accessToken);
            // Must persist existing device key if it exists for trusted device decryption to work
            // However, we must provide a user id so that the device key can be retrieved
            // as the state service won't have an active account at this point in time
            // even though the data exists in local storage.
            const userId = accountInformation.sub;
            const deviceKey = yield this.stateService.getDeviceKey({ userId });
            const accountKeys = new AccountKeys();
            if (deviceKey) {
                accountKeys.deviceKey = deviceKey;
            }
            // If you don't persist existing admin auth requests on login, they will get deleted.
            const adminAuthRequest = yield this.stateService.getAdminAuthRequest({ userId });
            yield this.stateService.addAccount(new Account({
                profile: Object.assign(Object.assign({}, new AccountProfile()), {
                    userId,
                    name: accountInformation.name,
                    email: accountInformation.email,
                    hasPremiumPersonally: accountInformation.premium,
                    kdfIterations: tokenResponse.kdfIterations,
                    kdfMemory: tokenResponse.kdfMemory,
                    kdfParallelism: tokenResponse.kdfParallelism,
                    kdfType: tokenResponse.kdf,
                }),
                tokens: Object.assign(Object.assign({}, new AccountTokens()), {
                    accessToken: tokenResponse.accessToken,
                    refreshToken: tokenResponse.refreshToken,
                }),
                keys: accountKeys,
                decryptionOptions: AccountDecryptionOptions.fromResponse(tokenResponse),
                adminAuthRequest: adminAuthRequest === null || adminAuthRequest === void 0 ? void 0 : adminAuthRequest.toJSON(),
            }));
        });
    }
    processTokenResponse(response) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const result = new AuthResult();
            // Old encryption keys must be migrated, but is currently only available on web.
            // Other clients shouldn't continue the login process.
            if (this.encryptionKeyMigrationRequired(response)) {
                result.requiresEncryptionKeyMigration = true;
                if (this.platformUtilsService.getClientType() !== ClientType.Web) {
                    return result;
                }
            }
            result.resetMasterPassword = response.resetMasterPassword;
            // Convert boolean to enum
            if (response.forcePasswordReset) {
                result.forcePasswordReset = ForceSetPasswordReason.AdminForcePasswordReset;
            }
            // Must come before setting keys, user key needs email to update additional keys
            yield this.saveAccountInformation(response);
            if (response.twoFactorToken != null) {
                yield this.tokenService.setTwoFactorToken(response);
            }
            yield this.setMasterKey(response);
            yield this.setUserKey(response);
            yield this.setPrivateKey(response);
            this.messagingService.send("loggedIn");
            return result;
        });
    }
    // Old accounts used master key for encryption. We are forcing migrations but only need to
    // check on password logins
    encryptionKeyMigrationRequired(response) {
        return false;
    }
    createKeyPairForOldAccount() {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            try {
                const [publicKey, privateKey] = yield this.cryptoService.makeKeyPair();
                yield this.apiService.postAccountKeys(new KeysRequest(publicKey, privateKey.encryptedString));
                return privateKey.encryptedString;
            }
            catch (e) {
                this.logService.error(e);
            }
        });
    }
    processTwoFactorResponse(response) {
        var _a;
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const result = new AuthResult();
            result.twoFactorProviders = response.twoFactorProviders2;
            this.twoFactorService.setProviders(response);
            this.captchaBypassToken = (_a = response.captchaToken) !== null && _a !== void 0 ? _a : null;
            result.ssoEmail2FaSessionToken = response.ssoEmail2faSessionToken;
            result.email = response.email;
            return result;
        });
    }
    processCaptchaResponse(response) {
        return login_strategy_awaiter(this, void 0, void 0, function* () {
            const result = new AuthResult();
            result.captchaSiteKey = response.siteKey;
            return result;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/login-strategies/auth-request-login.strategy.ts
var auth_request_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class AuthRequestLoginStrategy extends LoginStrategy {
    get email() {
        return this.tokenRequest.email;
    }
    get accessCode() {
        return this.authRequestCredentials.accessCode;
    }
    get authRequestId() {
        return this.authRequestCredentials.authRequestId;
    }
    constructor(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, deviceTrustCryptoService) {
        super(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService);
        this.deviceTrustCryptoService = deviceTrustCryptoService;
    }
    logIn(credentials) {
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            // NOTE: To avoid DeadObject references on Firefox, do not set the credentials object directly
            // Use deep copy in future if objects are added that were created in popup
            this.authRequestCredentials = Object.assign({}, credentials);
            this.tokenRequest = new PasswordTokenRequest(credentials.email, credentials.accessCode, null, yield this.buildTwoFactor(credentials.twoFactor), yield this.buildDeviceRequest());
            this.tokenRequest.setAuthRequestAccessCode(credentials.authRequestId);
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    logInTwoFactor(twoFactor, captchaResponse) {
        const _super = Object.create(null, {
            logInTwoFactor: { get: () => super.logInTwoFactor }
        });
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            this.tokenRequest.captchaResponse = captchaResponse !== null && captchaResponse !== void 0 ? captchaResponse : this.captchaBypassToken;
            return _super.logInTwoFactor.call(this, twoFactor);
        });
    }
    setMasterKey(response) {
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            if (this.authRequestCredentials.decryptedMasterKey &&
                this.authRequestCredentials.decryptedMasterKeyHash) {
                yield this.cryptoService.setMasterKey(this.authRequestCredentials.decryptedMasterKey);
                yield this.cryptoService.setMasterKeyHash(this.authRequestCredentials.decryptedMasterKeyHash);
            }
        });
    }
    setUserKey(response) {
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            // User now may or may not have a master password
            // but set the master key encrypted user key if it exists regardless
            yield this.cryptoService.setMasterKeyEncryptedUserKey(response.key);
            if (this.authRequestCredentials.decryptedUserKey) {
                yield this.cryptoService.setUserKey(this.authRequestCredentials.decryptedUserKey);
            }
            else {
                yield this.trySetUserKeyWithMasterKey();
                // Establish trust if required after setting user key
                yield this.deviceTrustCryptoService.trustDeviceIfRequired();
            }
        });
    }
    trySetUserKeyWithMasterKey() {
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            const masterKey = yield this.cryptoService.getMasterKey();
            if (masterKey) {
                const userKey = yield this.cryptoService.decryptUserKeyWithMasterKey(masterKey);
                yield this.cryptoService.setUserKey(userKey);
            }
        });
    }
    setPrivateKey(response) {
        var _a;
        return auth_request_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount()));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/login-strategies/password-login.strategy.ts
var password_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






class PasswordLoginStrategy extends LoginStrategy {
    get email() {
        return this.tokenRequest.email;
    }
    get masterPasswordHash() {
        return this.tokenRequest.masterPasswordHash;
    }
    constructor(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, passwordStrengthService, policyService, authService) {
        super(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService);
        this.stateService = stateService;
        this.passwordStrengthService = passwordStrengthService;
        this.policyService = policyService;
        this.authService = authService;
        /**
         * Options to track if the user needs to update their password due to a password that does not meet an organization's
         * master password policy.
         */
        this.forcePasswordResetReason = ForceSetPasswordReason.None;
    }
    logInTwoFactor(twoFactor, captchaResponse) {
        const _super = Object.create(null, {
            logInTwoFactor: { get: () => super.logInTwoFactor }
        });
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            this.tokenRequest.captchaResponse = captchaResponse !== null && captchaResponse !== void 0 ? captchaResponse : this.captchaBypassToken;
            const result = yield _super.logInTwoFactor.call(this, twoFactor);
            // 2FA was successful, save the force update password options with the state service if defined
            if (!result.requiresTwoFactor &&
                !result.requiresCaptcha &&
                this.forcePasswordResetReason != ForceSetPasswordReason.None) {
                yield this.stateService.setForceSetPasswordReason(this.forcePasswordResetReason);
                result.forcePasswordReset = this.forcePasswordResetReason;
            }
            return result;
        });
    }
    logIn(credentials) {
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            const { email, masterPassword, captchaToken, twoFactor } = credentials;
            this.masterKey = yield this.authService.makePreloginKey(masterPassword, email);
            // Hash the password early (before authentication) so we don't persist it in memory in plaintext
            this.localMasterKeyHash = yield this.cryptoService.hashMasterKey(masterPassword, this.masterKey, HashPurpose.LocalAuthorization);
            const masterKeyHash = yield this.cryptoService.hashMasterKey(masterPassword, this.masterKey);
            this.tokenRequest = new PasswordTokenRequest(email, masterKeyHash, captchaToken, yield this.buildTwoFactor(twoFactor), yield this.buildDeviceRequest());
            const [authResult, identityResponse] = yield this.startLogIn();
            const masterPasswordPolicyOptions = this.getMasterPasswordPolicyOptionsFromResponse(identityResponse);
            // The identity result can contain master password policies for the user's organizations
            if (masterPasswordPolicyOptions === null || masterPasswordPolicyOptions === void 0 ? void 0 : masterPasswordPolicyOptions.enforceOnLogin) {
                // If there is a policy active, evaluate the supplied password before its no longer in memory
                const meetsRequirements = this.evaluateMasterPassword(credentials, masterPasswordPolicyOptions);
                if (!meetsRequirements) {
                    if (authResult.requiresCaptcha || authResult.requiresTwoFactor) {
                        // Save the flag to this strategy for later use as the master password is about to pass out of scope
                        this.forcePasswordResetReason = ForceSetPasswordReason.WeakMasterPassword;
                    }
                    else {
                        // Authentication was successful, save the force update password options with the state service
                        yield this.stateService.setForceSetPasswordReason(ForceSetPasswordReason.WeakMasterPassword);
                        authResult.forcePasswordReset = ForceSetPasswordReason.WeakMasterPassword;
                    }
                }
            }
            return authResult;
        });
    }
    setMasterKey(response) {
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setMasterKey(this.masterKey);
            yield this.cryptoService.setMasterKeyHash(this.localMasterKeyHash);
        });
    }
    setUserKey(response) {
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            // If migration is required, we won't have a user key to set yet.
            if (this.encryptionKeyMigrationRequired(response)) {
                return;
            }
            yield this.cryptoService.setMasterKeyEncryptedUserKey(response.key);
            const masterKey = yield this.cryptoService.getMasterKey();
            if (masterKey) {
                const userKey = yield this.cryptoService.decryptUserKeyWithMasterKey(masterKey);
                yield this.cryptoService.setUserKey(userKey);
            }
        });
    }
    setPrivateKey(response) {
        var _a;
        return password_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount()));
        });
    }
    encryptionKeyMigrationRequired(response) {
        return !response.key;
    }
    getMasterPasswordPolicyOptionsFromResponse(response) {
        if (response == null || response instanceof IdentityCaptchaResponse) {
            return null;
        }
        return MasterPasswordPolicyOptions.fromResponse(response.masterPasswordPolicy);
    }
    evaluateMasterPassword({ masterPassword, email }, options) {
        var _a;
        const passwordStrength = (_a = this.passwordStrengthService.getPasswordStrength(masterPassword, email)) === null || _a === void 0 ? void 0 : _a.score;
        return this.policyService.evaluateMasterPassword(passwordStrength, masterPassword, options);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/sso-token.request.ts

class SsoTokenRequest extends TokenRequest {
    constructor(code, codeVerifier, redirectUri, twoFactor, device) {
        super(twoFactor, device);
        this.code = code;
        this.codeVerifier = codeVerifier;
        this.redirectUri = redirectUri;
        this.twoFactor = twoFactor;
    }
    toIdentityToken(clientId) {
        const obj = super.toIdentityToken(clientId);
        obj.grant_type = "authorization_code";
        obj.code = this.code;
        obj.code_verifier = this.codeVerifier;
        obj.redirect_uri = this.redirectUri;
        return obj;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/login-strategies/sso-login.strategy.ts
var sso_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class SsoLoginStrategy extends LoginStrategy {
    constructor(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, keyConnectorService, deviceTrustCryptoService, authReqCryptoService, i18nService) {
        super(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService);
        this.keyConnectorService = keyConnectorService;
        this.deviceTrustCryptoService = deviceTrustCryptoService;
        this.authReqCryptoService = authReqCryptoService;
        this.i18nService = i18nService;
    }
    logIn(credentials) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            this.orgId = credentials.orgId;
            this.tokenRequest = new SsoTokenRequest(credentials.code, credentials.codeVerifier, credentials.redirectUrl, yield this.buildTwoFactor(credentials.twoFactor), yield this.buildDeviceRequest());
            const [ssoAuthResult] = yield this.startLogIn();
            this.email = ssoAuthResult.email;
            this.ssoEmail2FaSessionToken = ssoAuthResult.ssoEmail2FaSessionToken;
            // Auth guard currently handles redirects for this.
            if (ssoAuthResult.forcePasswordReset == ForceSetPasswordReason.AdminForcePasswordReset) {
                yield this.stateService.setForceSetPasswordReason(ssoAuthResult.forcePasswordReset);
            }
            return ssoAuthResult;
        });
    }
    setMasterKey(tokenResponse) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            // The only way we can be setting a master key at this point is if we are using Key Connector.
            // First, check to make sure that we should do so based on the token response.
            if (this.shouldSetMasterKeyFromKeyConnector(tokenResponse)) {
                // If we're here, we know that the user should use Key Connector (they have a KeyConnectorUrl) and does not have a master password.
                // We can now check the key on the token response to see whether they are a brand new user or an existing user.
                // The presence of a masterKeyEncryptedUserKey indicates that the user has already been provisioned in Key Connector.
                const newSsoUser = tokenResponse.key == null;
                if (newSsoUser) {
                    yield this.keyConnectorService.convertNewSsoUserToKeyConnector(tokenResponse, this.orgId);
                }
                else {
                    const keyConnectorUrl = this.getKeyConnectorUrl(tokenResponse);
                    yield this.keyConnectorService.setMasterKeyFromUrl(keyConnectorUrl);
                }
            }
        });
    }
    /**
     * Determines if it is possible set the `masterKey` from Key Connector.
     * @param tokenResponse
     * @returns `true` if the master key can be set from Key Connector, `false` otherwise
     */
    shouldSetMasterKeyFromKeyConnector(tokenResponse) {
        var _a;
        const userDecryptionOptions = tokenResponse === null || tokenResponse === void 0 ? void 0 : tokenResponse.userDecryptionOptions;
        if (userDecryptionOptions != null) {
            const userHasMasterPassword = userDecryptionOptions.hasMasterPassword;
            const userHasKeyConnectorUrl = ((_a = userDecryptionOptions.keyConnectorOption) === null || _a === void 0 ? void 0 : _a.keyConnectorUrl) != null;
            // In order for us to set the master key from Key Connector, we need to have a Key Connector URL
            // and the user must not have a master password.
            return userHasKeyConnectorUrl && !userHasMasterPassword;
        }
        else {
            // In pre-TDE versions of the server, the userDecryptionOptions will not be present.
            // In this case, we can determine if the user has a master password and has a Key Connector URL by
            // just checking the keyConnectorUrl property. This is because the server short-circuits on the response
            // and will not pass back the URL in the response if the user has a master password.
            // TODO: remove compatibility check after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
            return tokenResponse.keyConnectorUrl != null;
        }
    }
    getKeyConnectorUrl(tokenResponse) {
        var _a, _b;
        // TODO: remove tokenResponse.keyConnectorUrl reference after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
        const userDecryptionOptions = tokenResponse === null || tokenResponse === void 0 ? void 0 : tokenResponse.userDecryptionOptions;
        return ((_a = tokenResponse.keyConnectorUrl) !== null && _a !== void 0 ? _a : (_b = userDecryptionOptions === null || userDecryptionOptions === void 0 ? void 0 : userDecryptionOptions.keyConnectorOption) === null || _b === void 0 ? void 0 : _b.keyConnectorUrl);
    }
    // TODO: future passkey login strategy will need to support setting user key (decrypting via TDE or admin approval request)
    // so might be worth moving this logic to a common place (base login strategy or a separate service?)
    setUserKey(tokenResponse) {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const masterKeyEncryptedUserKey = tokenResponse.key;
            // Note: masterKeyEncryptedUserKey is undefined for SSO JIT provisioned users
            // on account creation and subsequent logins (confirmed or unconfirmed)
            // but that is fine for TDE so we cannot return if it is undefined
            if (masterKeyEncryptedUserKey) {
                // set the master key encrypted user key if it exists
                yield this.cryptoService.setMasterKeyEncryptedUserKey(masterKeyEncryptedUserKey);
            }
            const userDecryptionOptions = tokenResponse === null || tokenResponse === void 0 ? void 0 : tokenResponse.userDecryptionOptions;
            // Note: TDE and key connector are mutually exclusive
            if (userDecryptionOptions === null || userDecryptionOptions === void 0 ? void 0 : userDecryptionOptions.trustedDeviceOption) {
                yield this.trySetUserKeyWithApprovedAdminRequestIfExists();
                const hasUserKey = yield this.cryptoService.hasUserKey();
                // Only try to set user key with device key if admin approval request was not successful
                if (!hasUserKey) {
                    yield this.trySetUserKeyWithDeviceKey(tokenResponse);
                }
            }
            else if (masterKeyEncryptedUserKey != null &&
                this.getKeyConnectorUrl(tokenResponse) != null) {
                // Key connector enabled for user
                yield this.trySetUserKeyWithMasterKey();
            }
            // Note: In the traditional SSO flow with MP without key connector, the lock component
            // is responsible for deriving master key from MP entry and then decrypting the user key
        });
    }
    trySetUserKeyWithApprovedAdminRequestIfExists() {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            // At this point a user could have an admin auth request that has been approved
            const adminAuthReqStorable = yield this.stateService.getAdminAuthRequest();
            if (!adminAuthReqStorable) {
                return;
            }
            // Call server to see if admin auth request has been approved
            let adminAuthReqResponse;
            try {
                adminAuthReqResponse = yield this.apiService.getAuthRequest(adminAuthReqStorable.id);
            }
            catch (error) {
                if (error instanceof ErrorResponse && error.statusCode === HttpStatusCode.NotFound) {
                    // if we get a 404, it means the auth request has been deleted so clear it from storage
                    yield this.stateService.setAdminAuthRequest(null);
                }
                // Always return on an error here as we don't want to block the user from logging in
                return;
            }
            if (adminAuthReqResponse === null || adminAuthReqResponse === void 0 ? void 0 : adminAuthReqResponse.requestApproved) {
                // if masterPasswordHash has a value, we will always receive authReqResponse.key
                // as authRequestPublicKey(masterKey) + authRequestPublicKey(masterPasswordHash)
                if (adminAuthReqResponse.masterPasswordHash) {
                    yield this.authReqCryptoService.setKeysAfterDecryptingSharedMasterKeyAndHash(adminAuthReqResponse, adminAuthReqStorable.privateKey);
                }
                else {
                    // if masterPasswordHash is null, we will always receive authReqResponse.key
                    // as authRequestPublicKey(userKey)
                    yield this.authReqCryptoService.setUserKeyAfterDecryptingSharedUserKey(adminAuthReqResponse, adminAuthReqStorable.privateKey);
                }
                if (yield this.cryptoService.hasUserKey()) {
                    // Now that we have a decrypted user key in memory, we can check if we
                    // need to establish trust on the current device
                    yield this.deviceTrustCryptoService.trustDeviceIfRequired();
                    // if we successfully decrypted the user key, we can delete the admin auth request out of state
                    // TODO: eventually we post and clean up DB as well once consumed on client
                    yield this.stateService.setAdminAuthRequest(null);
                    this.platformUtilsService.showToast("success", null, this.i18nService.t("loginApproved"));
                }
            }
        });
    }
    trySetUserKeyWithDeviceKey(tokenResponse) {
        var _a;
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const trustedDeviceOption = (_a = tokenResponse.userDecryptionOptions) === null || _a === void 0 ? void 0 : _a.trustedDeviceOption;
            const deviceKey = yield this.deviceTrustCryptoService.getDeviceKey();
            const encDevicePrivateKey = trustedDeviceOption === null || trustedDeviceOption === void 0 ? void 0 : trustedDeviceOption.encryptedPrivateKey;
            const encUserKey = trustedDeviceOption === null || trustedDeviceOption === void 0 ? void 0 : trustedDeviceOption.encryptedUserKey;
            if (!deviceKey || !encDevicePrivateKey || !encUserKey) {
                return;
            }
            const userKey = yield this.deviceTrustCryptoService.decryptUserKeyWithDeviceKey(encDevicePrivateKey, encUserKey, deviceKey);
            if (userKey) {
                yield this.cryptoService.setUserKey(userKey);
            }
        });
    }
    trySetUserKeyWithMasterKey() {
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const masterKey = yield this.cryptoService.getMasterKey();
            // There is a scenario in which the master key is not set here. That will occur if the user
            // has a master password and is using Key Connector. In that case, we cannot set the master key
            // because the user hasn't entered their master password yet.
            // Instead, we'll return here and let the migration to Key Connector handle setting the master key.
            if (!masterKey) {
                return;
            }
            const userKey = yield this.cryptoService.decryptUserKeyWithMasterKey(masterKey);
            yield this.cryptoService.setUserKey(userKey);
        });
    }
    setPrivateKey(tokenResponse) {
        var _a;
        return sso_login_strategy_awaiter(this, void 0, void 0, function* () {
            const newSsoUser = tokenResponse.key == null;
            if (!newSsoUser) {
                yield this.cryptoService.setPrivateKey((_a = tokenResponse.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount()));
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/user-api-token.request.ts

class UserApiTokenRequest extends TokenRequest {
    constructor(clientId, clientSecret, twoFactor, device) {
        super(twoFactor, device);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.twoFactor = twoFactor;
    }
    toIdentityToken() {
        const obj = super.toIdentityToken(this.clientId);
        obj.scope = this.clientId.startsWith("organization") ? "api.organization" : "api";
        obj.grant_type = "client_credentials";
        obj.client_secret = this.clientSecret;
        return obj;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/login-strategies/user-api-login.strategy.ts
var user_api_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class UserApiLoginStrategy extends LoginStrategy {
    constructor(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService, environmentService, keyConnectorService) {
        super(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, stateService, twoFactorService);
        this.environmentService = environmentService;
        this.keyConnectorService = keyConnectorService;
    }
    logIn(credentials) {
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            this.tokenRequest = new UserApiTokenRequest(credentials.clientId, credentials.clientSecret, yield this.buildTwoFactor(), yield this.buildDeviceRequest());
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
    setMasterKey(response) {
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            if (response.apiUseKeyConnector) {
                const keyConnectorUrl = this.environmentService.getKeyConnectorUrl();
                yield this.keyConnectorService.setMasterKeyFromUrl(keyConnectorUrl);
            }
        });
    }
    setUserKey(response) {
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setMasterKeyEncryptedUserKey(response.key);
            if (response.apiUseKeyConnector) {
                const masterKey = yield this.cryptoService.getMasterKey();
                if (masterKey) {
                    const userKey = yield this.cryptoService.decryptUserKeyWithMasterKey(masterKey);
                    yield this.cryptoService.setUserKey(userKey);
                }
            }
        });
    }
    setPrivateKey(response) {
        var _a;
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount()));
        });
    }
    saveAccountInformation(tokenResponse) {
        const _super = Object.create(null, {
            saveAccountInformation: { get: () => super.saveAccountInformation }
        });
        return user_api_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield _super.saveAccountInformation.call(this, tokenResponse);
            yield this.stateService.setApiKeyClientId(this.tokenRequest.clientId);
            yield this.stateService.setApiKeyClientSecret(this.tokenRequest.clientSecret);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/identity-token/webauthn-login-token.request.ts

class WebAuthnLoginTokenRequest extends TokenRequest {
    constructor(token, deviceResponse, device) {
        super(undefined, device);
        this.token = token;
        this.deviceResponse = deviceResponse;
    }
    toIdentityToken(clientId) {
        const obj = super.toIdentityToken(clientId);
        obj.grant_type = "webauthn";
        obj.token = this.token;
        // must be a string b/c sending as form encoded data
        obj.deviceResponse = JSON.stringify(this.deviceResponse);
        return obj;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/login-strategies/webauthn-login.strategy.ts
var webauthn_login_strategy_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class WebAuthnLoginStrategy extends LoginStrategy {
    setMasterKey() {
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            return Promise.resolve();
        });
    }
    setUserKey(idTokenResponse) {
        var _a;
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            const masterKeyEncryptedUserKey = idTokenResponse.key;
            if (masterKeyEncryptedUserKey) {
                // set the master key encrypted user key if it exists
                yield this.cryptoService.setMasterKeyEncryptedUserKey(masterKeyEncryptedUserKey);
            }
            const userDecryptionOptions = idTokenResponse === null || idTokenResponse === void 0 ? void 0 : idTokenResponse.userDecryptionOptions;
            if (userDecryptionOptions === null || userDecryptionOptions === void 0 ? void 0 : userDecryptionOptions.webAuthnPrfOption) {
                const webAuthnPrfOption = (_a = idTokenResponse.userDecryptionOptions) === null || _a === void 0 ? void 0 : _a.webAuthnPrfOption;
                // confirm we still have the prf key
                if (!this.credentials.prfKey) {
                    return;
                }
                // decrypt prf encrypted private key
                const privateKey = yield this.cryptoService.decryptToBytes(webAuthnPrfOption.encryptedPrivateKey, this.credentials.prfKey);
                // decrypt user key with private key
                const userKey = yield this.cryptoService.rsaDecrypt(webAuthnPrfOption.encryptedUserKey.encryptedString, privateKey);
                if (userKey) {
                    yield this.cryptoService.setUserKey(new SymmetricCryptoKey(userKey));
                }
            }
        });
    }
    setPrivateKey(response) {
        var _a;
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            yield this.cryptoService.setPrivateKey((_a = response.privateKey) !== null && _a !== void 0 ? _a : (yield this.createKeyPairForOldAccount()));
        });
    }
    logInTwoFactor() {
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            throw new Error("2FA not supported yet for WebAuthn Login.");
        });
    }
    logIn(credentials) {
        return webauthn_login_strategy_awaiter(this, void 0, void 0, function* () {
            // NOTE: To avoid DeadObject references on Firefox, do not set the credentials object directly
            // Use deep copy in future if objects are added that were created in popup
            this.credentials = Object.assign({}, credentials);
            this.tokenRequest = new WebAuthnLoginTokenRequest(credentials.token, credentials.deviceResponse, yield this.buildDeviceRequest());
            const [authResult] = yield this.startLogIn();
            return authResult;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/passwordless-auth.request.ts
class PasswordlessAuthRequest {
    constructor(key, masterPasswordHash, deviceIdentifier, requestApproved) {
        this.key = key;
        this.masterPasswordHash = masterPasswordHash;
        this.deviceIdentifier = deviceIdentifier;
        this.requestApproved = requestApproved;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/auth.service.ts
var auth_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};














const sessionTimeoutLength = 2 * 60 * 1000; // 2 minutes
class AuthService {
    get email() {
        if (this.logInStrategy instanceof PasswordLoginStrategy ||
            this.logInStrategy instanceof AuthRequestLoginStrategy ||
            this.logInStrategy instanceof SsoLoginStrategy) {
            return this.logInStrategy.email;
        }
        return null;
    }
    get masterPasswordHash() {
        return this.logInStrategy instanceof PasswordLoginStrategy
            ? this.logInStrategy.masterPasswordHash
            : null;
    }
    get accessCode() {
        return this.logInStrategy instanceof AuthRequestLoginStrategy
            ? this.logInStrategy.accessCode
            : null;
    }
    get authRequestId() {
        return this.logInStrategy instanceof AuthRequestLoginStrategy
            ? this.logInStrategy.authRequestId
            : null;
    }
    get ssoEmail2FaSessionToken() {
        return this.logInStrategy instanceof SsoLoginStrategy
            ? this.logInStrategy.ssoEmail2FaSessionToken
            : null;
    }
    constructor(cryptoService, apiService, tokenService, appIdService, platformUtilsService, messagingService, logService, keyConnectorService, environmentService, stateService, twoFactorService, i18nService, encryptService, passwordStrengthService, policyService, deviceTrustCryptoService, authReqCryptoService) {
        this.cryptoService = cryptoService;
        this.apiService = apiService;
        this.tokenService = tokenService;
        this.appIdService = appIdService;
        this.platformUtilsService = platformUtilsService;
        this.messagingService = messagingService;
        this.logService = logService;
        this.keyConnectorService = keyConnectorService;
        this.environmentService = environmentService;
        this.stateService = stateService;
        this.twoFactorService = twoFactorService;
        this.i18nService = i18nService;
        this.encryptService = encryptService;
        this.passwordStrengthService = passwordStrengthService;
        this.policyService = policyService;
        this.deviceTrustCryptoService = deviceTrustCryptoService;
        this.authReqCryptoService = authReqCryptoService;
        this.pushNotificationSubject = new external_rxjs_namespaceObject.Subject();
    }
    logIn(credentials) {
        return auth_service_awaiter(this, void 0, void 0, function* () {
            this.clearState();
            let strategy;
            switch (credentials.type) {
                case authentication_type_AuthenticationType.Password:
                    strategy = new PasswordLoginStrategy(this.cryptoService, this.apiService, this.tokenService, this.appIdService, this.platformUtilsService, this.messagingService, this.logService, this.stateService, this.twoFactorService, this.passwordStrengthService, this.policyService, this);
                    break;
                case authentication_type_AuthenticationType.Sso:
                    strategy = new SsoLoginStrategy(this.cryptoService, this.apiService, this.tokenService, this.appIdService, this.platformUtilsService, this.messagingService, this.logService, this.stateService, this.twoFactorService, this.keyConnectorService, this.deviceTrustCryptoService, this.authReqCryptoService, this.i18nService);
                    break;
                case authentication_type_AuthenticationType.UserApi:
                    strategy = new UserApiLoginStrategy(this.cryptoService, this.apiService, this.tokenService, this.appIdService, this.platformUtilsService, this.messagingService, this.logService, this.stateService, this.twoFactorService, this.environmentService, this.keyConnectorService);
                    break;
                case authentication_type_AuthenticationType.AuthRequest:
                    strategy = new AuthRequestLoginStrategy(this.cryptoService, this.apiService, this.tokenService, this.appIdService, this.platformUtilsService, this.messagingService, this.logService, this.stateService, this.twoFactorService, this.deviceTrustCryptoService);
                    break;
                case authentication_type_AuthenticationType.WebAuthn:
                    strategy = new WebAuthnLoginStrategy(this.cryptoService, this.apiService, this.tokenService, this.appIdService, this.platformUtilsService, this.messagingService, this.logService, this.stateService, this.twoFactorService);
                    break;
            }
            // Note: Do not set the credentials object directly on the strategy. They are
            // created in the popup and can cause DeadObject references on Firefox.
            const result = yield strategy.logIn(credentials);
            if (result === null || result === void 0 ? void 0 : result.requiresTwoFactor) {
                this.saveState(strategy);
            }
            return result;
        });
    }
    logInTwoFactor(twoFactor, captchaResponse) {
        return auth_service_awaiter(this, void 0, void 0, function* () {
            if (this.logInStrategy == null) {
                throw new Error(this.i18nService.t("sessionTimeout"));
            }
            try {
                const result = yield this.logInStrategy.logInTwoFactor(twoFactor, captchaResponse);
                // Only clear state if 2FA token has been accepted, otherwise we need to be able to try again
                if (!result.requiresTwoFactor && !result.requiresCaptcha) {
                    this.clearState();
                }
                return result;
            }
            catch (e) {
                // API exceptions are okay, but if there are any unhandled client-side errors then clear state to be safe
                if (!(e instanceof ErrorResponse)) {
                    this.clearState();
                }
                throw e;
            }
        });
    }
    logOut(callback) {
        callback();
        this.messagingService.send("loggedOut");
    }
    authingWithUserApiKey() {
        return this.logInStrategy instanceof UserApiLoginStrategy;
    }
    authingWithSso() {
        return this.logInStrategy instanceof SsoLoginStrategy;
    }
    authingWithPassword() {
        return this.logInStrategy instanceof PasswordLoginStrategy;
    }
    authingWithPasswordless() {
        return this.logInStrategy instanceof AuthRequestLoginStrategy;
    }
    getAuthStatus(userId) {
        return auth_service_awaiter(this, void 0, void 0, function* () {
            // If we don't have an access token or userId, we're logged out
            const isAuthenticated = yield this.stateService.getIsAuthenticated({ userId: userId });
            if (!isAuthenticated) {
                return AuthenticationStatus.LoggedOut;
            }
            // If we don't have a user key in memory, we're locked
            if (!(yield this.cryptoService.hasUserKeyInMemory(userId))) {
                // Check if the user has vault timeout set to never and verify that
                // they've never unlocked their vault
                const neverLock = (yield this.cryptoService.hasUserKeyStored(KeySuffixOptions.Auto, userId)) &&
                    !(yield this.stateService.getEverBeenUnlocked({ userId: userId }));
                if (neverLock) {
                    // Attempt to get the key from storage and set it in memory
                    const userKey = yield this.cryptoService.getUserKeyFromStorage(KeySuffixOptions.Auto, userId);
                    yield this.cryptoService.setUserKey(userKey, userId);
                }
            }
            // We do another check here in case setting the auto key failed
            const hasKeyInMemory = yield this.cryptoService.hasUserKeyInMemory(userId);
            if (!hasKeyInMemory) {
                return AuthenticationStatus.Locked;
            }
            return AuthenticationStatus.Unlocked;
        });
    }
    makePreloginKey(masterPassword, email) {
        return auth_service_awaiter(this, void 0, void 0, function* () {
            email = email.trim().toLowerCase();
            let kdf = null;
            let kdfConfig = null;
            try {
                const preloginResponse = yield this.apiService.postPrelogin(new PreloginRequest(email));
                if (preloginResponse != null) {
                    kdf = preloginResponse.kdf;
                    kdfConfig = new KdfConfig(preloginResponse.kdfIterations, preloginResponse.kdfMemory, preloginResponse.kdfParallelism);
                }
            }
            catch (e) {
                if (e == null || e.statusCode !== 404) {
                    throw e;
                }
            }
            return yield this.cryptoService.makeMasterKey(masterPassword, email, kdf, kdfConfig);
        });
    }
    authResponsePushNotification(notification) {
        return auth_service_awaiter(this, void 0, void 0, function* () {
            this.pushNotificationSubject.next(notification.id);
        });
    }
    getPushNotificationObs$() {
        return this.pushNotificationSubject.asObservable();
    }
    passwordlessLogin(id, key, requestApproved) {
        return auth_service_awaiter(this, void 0, void 0, function* () {
            const pubKey = utils_Utils.fromB64ToArray(key);
            const masterKey = yield this.cryptoService.getMasterKey();
            let keyToEncrypt;
            let encryptedMasterKeyHash = null;
            if (masterKey) {
                keyToEncrypt = masterKey.encKey;
                // Only encrypt the master password hash if masterKey exists as
                // we won't have a masterKeyHash without a masterKey
                const masterKeyHash = yield this.stateService.getKeyHash();
                if (masterKeyHash != null) {
                    encryptedMasterKeyHash = yield this.cryptoService.rsaEncrypt(utils_Utils.fromUtf8ToArray(masterKeyHash), pubKey);
                }
            }
            else {
                const userKey = yield this.cryptoService.getUserKey();
                keyToEncrypt = userKey.key;
            }
            const encryptedKey = yield this.cryptoService.rsaEncrypt(keyToEncrypt, pubKey);
            const request = new PasswordlessAuthRequest(encryptedKey.encryptedString, encryptedMasterKeyHash === null || encryptedMasterKeyHash === void 0 ? void 0 : encryptedMasterKeyHash.encryptedString, yield this.appIdService.getAppId(), requestApproved);
            return yield this.apiService.putAuthRequest(id, request);
        });
    }
    saveState(strategy) {
        this.logInStrategy = strategy;
        this.startSessionTimeout();
    }
    clearState() {
        this.logInStrategy = null;
        this.clearSessionTimeout();
    }
    startSessionTimeout() {
        this.clearSessionTimeout();
        this.sessionTimeout = setTimeout(() => this.clearState(), sessionTimeoutLength);
    }
    clearSessionTimeout() {
        if (this.sessionTimeout != null) {
            clearTimeout(this.sessionTimeout);
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/secret-verification.request.ts
class SecretVerificationRequest {
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/update-devices-trust.request.ts

class UpdateDevicesTrustRequest extends SecretVerificationRequest {
}
class DeviceKeysUpdateRequest {
}
class OtherDeviceKeysUpdateRequest extends (/* unused pure expression or super */ null && (DeviceKeysUpdateRequest)) {
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/device-trust-crypto.service.implementation.ts
var device_trust_crypto_service_implementation_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class DeviceTrustCryptoService {
    constructor(cryptoFunctionService, cryptoService, encryptService, stateService, appIdService, devicesApiService, i18nService, platformUtilsService) {
        this.cryptoFunctionService = cryptoFunctionService;
        this.cryptoService = cryptoService;
        this.encryptService = encryptService;
        this.stateService = stateService;
        this.appIdService = appIdService;
        this.devicesApiService = devicesApiService;
        this.i18nService = i18nService;
        this.platformUtilsService = platformUtilsService;
    }
    /**
     * @description Retrieves the users choice to trust the device which can only happen after decryption
     * Note: this value should only be used once and then reset
     */
    getShouldTrustDevice() {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getShouldTrustDevice();
        });
    }
    setShouldTrustDevice(value) {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setShouldTrustDevice(value);
        });
    }
    trustDeviceIfRequired() {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            const shouldTrustDevice = yield this.getShouldTrustDevice();
            if (shouldTrustDevice) {
                yield this.trustDevice();
                // reset the trust choice
                yield this.setShouldTrustDevice(false);
            }
        });
    }
    trustDevice() {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            // Attempt to get user key
            const userKey = yield this.cryptoService.getUserKey();
            // If user key is not found, throw error
            if (!userKey) {
                throw new Error("User symmetric key not found");
            }
            // Generate deviceKey
            const deviceKey = yield this.makeDeviceKey();
            // Generate asymmetric RSA key pair: devicePrivateKey, devicePublicKey
            const [devicePublicKey, devicePrivateKey] = yield this.cryptoFunctionService.rsaGenerateKeyPair(2048);
            const [devicePublicKeyEncryptedUserKey, userKeyEncryptedDevicePublicKey, deviceKeyEncryptedDevicePrivateKey,] = yield Promise.all([
                // Encrypt user key with the DevicePublicKey
                this.cryptoService.rsaEncrypt(userKey.key, devicePublicKey),
                // Encrypt devicePublicKey with user key
                this.encryptService.encrypt(devicePublicKey, userKey),
                // Encrypt devicePrivateKey with deviceKey
                this.encryptService.encrypt(devicePrivateKey, deviceKey),
            ]);
            // Send encrypted keys to server
            const deviceIdentifier = yield this.appIdService.getAppId();
            const deviceResponse = yield this.devicesApiService.updateTrustedDeviceKeys(deviceIdentifier, devicePublicKeyEncryptedUserKey.encryptedString, userKeyEncryptedDevicePublicKey.encryptedString, deviceKeyEncryptedDevicePrivateKey.encryptedString);
            // store device key in local/secure storage if enc keys posted to server successfully
            yield this.setDeviceKey(deviceKey);
            this.platformUtilsService.showToast("success", null, this.i18nService.t("deviceTrusted"));
            return deviceResponse;
        });
    }
    rotateDevicesTrust(newUserKey, masterPasswordHash) {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            const currentDeviceKey = yield this.getDeviceKey();
            if (currentDeviceKey == null) {
                // If the current device doesn't have a device key available to it, then we can't
                // rotate any trust at all, so early return.
                return;
            }
            // At this point of rotating their keys, they should still have their old user key in state
            const oldUserKey = yield this.stateService.getUserKey();
            const deviceIdentifier = yield this.appIdService.getAppId();
            const secretVerificationRequest = new SecretVerificationRequest();
            secretVerificationRequest.masterPasswordHash = masterPasswordHash;
            // Get the keys that are used in rotating a devices keys from the server
            const currentDeviceKeys = yield this.devicesApiService.getDeviceKeys(deviceIdentifier, secretVerificationRequest);
            // Decrypt the existing device public key with the old user key
            const decryptedDevicePublicKey = yield this.encryptService.decryptToBytes(currentDeviceKeys.encryptedPublicKey, oldUserKey);
            // Encrypt the brand new user key with the now-decrypted public key for the device
            const encryptedNewUserKey = yield this.cryptoService.rsaEncrypt(newUserKey.key, decryptedDevicePublicKey);
            // Re-encrypt the device public key with the new user key
            const encryptedDevicePublicKey = yield this.encryptService.encrypt(decryptedDevicePublicKey, newUserKey);
            const currentDeviceUpdateRequest = new DeviceKeysUpdateRequest();
            currentDeviceUpdateRequest.encryptedUserKey = encryptedNewUserKey.encryptedString;
            currentDeviceUpdateRequest.encryptedPublicKey = encryptedDevicePublicKey.encryptedString;
            // TODO: For device management, allow this method to take an array of device ids that can be looped over and individually rotated
            // then it can be added to trustRequest.otherDevices.
            const trustRequest = new UpdateDevicesTrustRequest();
            trustRequest.masterPasswordHash = masterPasswordHash;
            trustRequest.currentDevice = currentDeviceUpdateRequest;
            trustRequest.otherDevices = [];
            yield this.devicesApiService.updateTrust(trustRequest, deviceIdentifier);
        });
    }
    getDeviceKey() {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getDeviceKey();
        });
    }
    setDeviceKey(deviceKey) {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setDeviceKey(deviceKey);
        });
    }
    makeDeviceKey() {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            // Create 512-bit device key
            const randomBytes = yield this.cryptoFunctionService.aesGenerateKey(512);
            const deviceKey = new SymmetricCryptoKey(randomBytes);
            return deviceKey;
        });
    }
    decryptUserKeyWithDeviceKey(encryptedDevicePrivateKey, encryptedUserKey, deviceKey) {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            // If device key provided use it, otherwise try to retrieve from storage
            deviceKey || (deviceKey = yield this.getDeviceKey());
            if (!deviceKey) {
                // User doesn't have a device key anymore so device is untrusted
                return null;
            }
            try {
                // attempt to decrypt encryptedDevicePrivateKey with device key
                const devicePrivateKey = yield this.encryptService.decryptToBytes(encryptedDevicePrivateKey, deviceKey);
                // Attempt to decrypt encryptedUserDataKey with devicePrivateKey
                const userKey = yield this.cryptoService.rsaDecrypt(encryptedUserKey.encryptedString, devicePrivateKey);
                return new SymmetricCryptoKey(userKey);
            }
            catch (e) {
                // If either decryption effort fails, we want to remove the device key
                yield this.setDeviceKey(null);
                return null;
            }
        });
    }
    supportsDeviceTrust() {
        return device_trust_crypto_service_implementation_awaiter(this, void 0, void 0, function* () {
            const decryptionOptions = yield this.stateService.getAccountDecryptionOptions();
            return (decryptionOptions === null || decryptionOptions === void 0 ? void 0 : decryptionOptions.trustedDeviceOption) != null;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/abstractions/devices/responses/device.response.ts

class DeviceResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.userId = this.getResponseProperty("UserId");
        this.name = this.getResponseProperty("Name");
        this.identifier = this.getResponseProperty("Identifier");
        this.type = this.getResponseProperty("Type");
        this.creationDate = this.getResponseProperty("CreationDate");
        this.revisionDate = this.getResponseProperty("RevisionDate");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/response/protected-device.response.ts


class ProtectedDeviceResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("id");
        this.name = this.getResponseProperty("name");
        this.identifier = this.getResponseProperty("identifier");
        this.type = this.getResponseProperty("type");
        this.creationDate = new Date(this.getResponseProperty("creationDate"));
        if (response.encryptedUserKey) {
            this.encryptedUserKey = new EncString(this.getResponseProperty("encryptedUserKey"));
        }
        if (response.encryptedPublicKey) {
            this.encryptedPublicKey = new EncString(this.getResponseProperty("encryptedPublicKey"));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/devices/requests/trusted-device-keys.request.ts
class TrustedDeviceKeysRequest {
    constructor(encryptedUserKey, encryptedPublicKey, encryptedPrivateKey) {
        this.encryptedUserKey = encryptedUserKey;
        this.encryptedPublicKey = encryptedPublicKey;
        this.encryptedPrivateKey = encryptedPrivateKey;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/devices-api.service.implementation.ts
var devices_api_service_implementation_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class DevicesApiServiceImplementation {
    constructor(apiService) {
        this.apiService = apiService;
    }
    getKnownDevice(email, deviceIdentifier) {
        return devices_api_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/devices/knowndevice", null, false, true, null, (headers) => {
                headers.set("X-Device-Identifier", deviceIdentifier);
                headers.set("X-Request-Email", utils_Utils.fromUtf8ToUrlB64(email));
            });
            return r;
        });
    }
    /**
     * Get device by identifier
     * @param deviceIdentifier - client generated id (not device id in DB)
     */
    getDeviceByIdentifier(deviceIdentifier) {
        return devices_api_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", `/devices/identifier/${deviceIdentifier}`, null, true, true);
            return new DeviceResponse(r);
        });
    }
    getDevices() {
        return devices_api_service_implementation_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/devices", null, true, true, null);
            return new ListResponse(r, DeviceResponse);
        });
    }
    updateTrustedDeviceKeys(deviceIdentifier, devicePublicKeyEncryptedUserKey, userKeyEncryptedDevicePublicKey, deviceKeyEncryptedDevicePrivateKey) {
        return devices_api_service_implementation_awaiter(this, void 0, void 0, function* () {
            const request = new TrustedDeviceKeysRequest(devicePublicKeyEncryptedUserKey, userKeyEncryptedDevicePublicKey, deviceKeyEncryptedDevicePrivateKey);
            const result = yield this.apiService.send("PUT", `/devices/${deviceIdentifier}/keys`, request, true, true);
            return new DeviceResponse(result);
        });
    }
    updateTrust(updateDevicesTrustRequestModel, deviceIdentifier) {
        return devices_api_service_implementation_awaiter(this, void 0, void 0, function* () {
            yield this.apiService.send("POST", "/devices/update-trust", updateDevicesTrustRequestModel, true, false, null, (headers) => {
                headers.set("Device-Identifier", deviceIdentifier);
            });
        });
    }
    getDeviceKeys(deviceIdentifier, secretVerificationRequest) {
        return devices_api_service_implementation_awaiter(this, void 0, void 0, function* () {
            const result = yield this.apiService.send("POST", `/devices/${deviceIdentifier}/retrieve-keys`, secretVerificationRequest, true, true);
            return new ProtectedDeviceResponse(result);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/key-connector-user-key.request.ts
class KeyConnectorUserKeyRequest {
    constructor(key) {
        this.key = key;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/set-key-connector-key.request.ts
class SetKeyConnectorKeyRequest {
    constructor(key, kdf, kdfConfig, orgIdentifier, keys) {
        this.key = key;
        this.kdf = kdf;
        this.kdfIterations = kdfConfig.iterations;
        this.kdfMemory = kdfConfig.memory;
        this.kdfParallelism = kdfConfig.parallelism;
        this.orgIdentifier = orgIdentifier;
        this.keys = keys;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/key-connector.service.ts
var key_connector_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







class KeyConnectorService {
    constructor(stateService, cryptoService, apiService, tokenService, logService, organizationService, cryptoFunctionService, logoutCallback) {
        this.stateService = stateService;
        this.cryptoService = cryptoService;
        this.apiService = apiService;
        this.tokenService = tokenService;
        this.logService = logService;
        this.organizationService = organizationService;
        this.cryptoFunctionService = cryptoFunctionService;
        this.logoutCallback = logoutCallback;
    }
    setUsesKeyConnector(usesKeyConnector) {
        return this.stateService.setUsesKeyConnector(usesKeyConnector);
    }
    getUsesKeyConnector() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getUsesKeyConnector();
        });
    }
    userNeedsMigration() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            const loggedInUsingSso = yield this.tokenService.getIsExternal();
            const requiredByOrganization = (yield this.getManagingOrganization()) != null;
            const userIsNotUsingKeyConnector = !(yield this.getUsesKeyConnector());
            return loggedInUsingSso && requiredByOrganization && userIsNotUsingKeyConnector;
        });
    }
    migrateUser() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            const organization = yield this.getManagingOrganization();
            const masterKey = yield this.cryptoService.getMasterKey();
            const keyConnectorRequest = new KeyConnectorUserKeyRequest(masterKey.encKeyB64);
            try {
                yield this.apiService.postUserKeyToKeyConnector(organization.keyConnectorUrl, keyConnectorRequest);
            }
            catch (e) {
                this.handleKeyConnectorError(e);
            }
            yield this.apiService.postConvertToKeyConnector();
        });
    }
    // TODO: UserKey should be renamed to MasterKey and typed accordingly
    setMasterKeyFromUrl(url) {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            try {
                const masterKeyResponse = yield this.apiService.getMasterKeyFromKeyConnector(url);
                const keyArr = utils_Utils.fromB64ToArray(masterKeyResponse.key);
                const masterKey = new SymmetricCryptoKey(keyArr);
                yield this.cryptoService.setMasterKey(masterKey);
            }
            catch (e) {
                this.handleKeyConnectorError(e);
            }
        });
    }
    getManagingOrganization() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            const orgs = yield this.organizationService.getAll();
            return orgs.find((o) => o.keyConnectorEnabled &&
                o.type !== OrganizationUserType.Admin &&
                o.type !== OrganizationUserType.Owner &&
                !o.isProviderUser);
        });
    }
    convertNewSsoUserToKeyConnector(tokenResponse, orgId) {
        var _a;
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            // TODO: Remove after tokenResponse.keyConnectorUrl is deprecated in 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3537)
            const { kdf, kdfIterations, kdfMemory, kdfParallelism, keyConnectorUrl: legacyKeyConnectorUrl, userDecryptionOptions, } = tokenResponse;
            const password = yield this.cryptoFunctionService.aesGenerateKey(512);
            const kdfConfig = new KdfConfig(kdfIterations, kdfMemory, kdfParallelism);
            const masterKey = yield this.cryptoService.makeMasterKey(utils_Utils.fromBufferToB64(password), yield this.tokenService.getEmail(), kdf, kdfConfig);
            const keyConnectorRequest = new KeyConnectorUserKeyRequest(masterKey.encKeyB64);
            yield this.cryptoService.setMasterKey(masterKey);
            const userKey = yield this.cryptoService.makeUserKey(masterKey);
            yield this.cryptoService.setUserKey(userKey[0]);
            yield this.cryptoService.setMasterKeyEncryptedUserKey(userKey[1].encryptedString);
            const [pubKey, privKey] = yield this.cryptoService.makeKeyPair();
            try {
                const keyConnectorUrl = legacyKeyConnectorUrl !== null && legacyKeyConnectorUrl !== void 0 ? legacyKeyConnectorUrl : (_a = userDecryptionOptions === null || userDecryptionOptions === void 0 ? void 0 : userDecryptionOptions.keyConnectorOption) === null || _a === void 0 ? void 0 : _a.keyConnectorUrl;
                yield this.apiService.postUserKeyToKeyConnector(keyConnectorUrl, keyConnectorRequest);
            }
            catch (e) {
                this.handleKeyConnectorError(e);
            }
            const keys = new KeysRequest(pubKey, privKey.encryptedString);
            const setPasswordRequest = new SetKeyConnectorKeyRequest(userKey[1].encryptedString, kdf, kdfConfig, orgId, keys);
            yield this.apiService.postSetKeyConnectorKey(setPasswordRequest);
        });
    }
    setConvertAccountRequired(status) {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setConvertAccountToKeyConnector(status);
        });
    }
    getConvertAccountRequired() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getConvertAccountToKeyConnector();
        });
    }
    removeConvertAccountRequired() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setConvertAccountToKeyConnector(null);
        });
    }
    clear() {
        return key_connector_service_awaiter(this, void 0, void 0, function* () {
            yield this.removeConvertAccountRequired();
        });
    }
    handleKeyConnectorError(e) {
        this.logService.error(e);
        if (this.logoutCallback != null) {
            this.logoutCallback(false);
        }
        throw new Error("Key Connector error");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/token.service.ts
var token_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class TokenService {
    static decodeToken(token) {
        if (token == null) {
            throw new Error("Token not provided.");
        }
        const parts = token.split(".");
        if (parts.length !== 3) {
            throw new Error("JWT must have 3 parts");
        }
        const decoded = utils_Utils.fromUrlB64ToUtf8(parts[1]);
        if (decoded == null) {
            throw new Error("Cannot decode the token");
        }
        const decodedToken = JSON.parse(decoded);
        return decodedToken;
    }
    constructor(stateService) {
        this.stateService = stateService;
    }
    setTokens(accessToken, refreshToken, clientIdClientSecret) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            yield this.setToken(accessToken);
            yield this.setRefreshToken(refreshToken);
            if (clientIdClientSecret != null) {
                yield this.setClientId(clientIdClientSecret[0]);
                yield this.setClientSecret(clientIdClientSecret[1]);
            }
        });
    }
    setClientId(clientId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.setApiKeyClientId(clientId);
        });
    }
    getClientId() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getApiKeyClientId();
        });
    }
    setClientSecret(clientSecret) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.setApiKeyClientSecret(clientSecret);
        });
    }
    getClientSecret() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getApiKeyClientSecret();
        });
    }
    setToken(token) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setAccessToken(token);
        });
    }
    getToken() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getAccessToken();
        });
    }
    setRefreshToken(refreshToken) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.setRefreshToken(refreshToken);
        });
    }
    getRefreshToken() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getRefreshToken();
        });
    }
    setTwoFactorToken(tokenResponse) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.setTwoFactorToken(tokenResponse.twoFactorToken);
        });
    }
    getTwoFactorToken() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getTwoFactorToken();
        });
    }
    clearTwoFactorToken() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.setTwoFactorToken(null);
        });
    }
    clearToken(userId) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setAccessToken(null, { userId: userId });
            yield this.stateService.setRefreshToken(null, { userId: userId });
            yield this.stateService.setApiKeyClientId(null, { userId: userId });
            yield this.stateService.setApiKeyClientSecret(null, { userId: userId });
        });
    }
    // jwthelper methods
    // ref https://github.com/auth0/angular-jwt/blob/master/src/angularJwt/services/jwt.js
    decodeToken(token) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            token = token !== null && token !== void 0 ? token : (yield this.stateService.getAccessToken());
            if (token == null) {
                throw new Error("Token not found.");
            }
            return TokenService.decodeToken(token);
        });
    }
    getTokenExpirationDate() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const decoded = yield this.decodeToken();
            if (typeof decoded.exp === "undefined") {
                return null;
            }
            const d = new Date(0); // The 0 here is the key, which sets the date to the epoch
            d.setUTCSeconds(decoded.exp);
            return d;
        });
    }
    tokenSecondsRemaining(offsetSeconds = 0) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const d = yield this.getTokenExpirationDate();
            if (d == null) {
                return 0;
            }
            const msRemaining = d.valueOf() - (new Date().valueOf() + offsetSeconds * 1000);
            return Math.round(msRemaining / 1000);
        });
    }
    tokenNeedsRefresh(minutes = 5) {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const sRemaining = yield this.tokenSecondsRemaining();
            return sRemaining < 60 * minutes;
        });
    }
    getUserId() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const decoded = yield this.decodeToken();
            if (typeof decoded.sub === "undefined") {
                throw new Error("No user id found");
            }
            return decoded.sub;
        });
    }
    getEmail() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const decoded = yield this.decodeToken();
            if (typeof decoded.email === "undefined") {
                throw new Error("No email found");
            }
            return decoded.email;
        });
    }
    getEmailVerified() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const decoded = yield this.decodeToken();
            if (typeof decoded.email_verified === "undefined") {
                throw new Error("No email verification found");
            }
            return decoded.email_verified;
        });
    }
    getName() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const decoded = yield this.decodeToken();
            if (typeof decoded.name === "undefined") {
                return null;
            }
            return decoded.name;
        });
    }
    getIssuer() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const decoded = yield this.decodeToken();
            if (typeof decoded.iss === "undefined") {
                throw new Error("No issuer found");
            }
            return decoded.iss;
        });
    }
    getIsExternal() {
        return token_service_awaiter(this, void 0, void 0, function* () {
            const decoded = yield this.decodeToken();
            return Array.isArray(decoded.amr) && decoded.amr.includes("external");
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/two-factor.service.ts

const TwoFactorProviders = {
    [TwoFactorProviderType.Authenticator]: {
        type: TwoFactorProviderType.Authenticator,
        name: null,
        description: null,
        priority: 1,
        sort: 1,
        premium: false,
    },
    [TwoFactorProviderType.Yubikey]: {
        type: TwoFactorProviderType.Yubikey,
        name: null,
        description: null,
        priority: 3,
        sort: 2,
        premium: true,
    },
    [TwoFactorProviderType.Duo]: {
        type: TwoFactorProviderType.Duo,
        name: "Duo",
        description: null,
        priority: 2,
        sort: 3,
        premium: true,
    },
    [TwoFactorProviderType.OrganizationDuo]: {
        type: TwoFactorProviderType.OrganizationDuo,
        name: "Duo (Organization)",
        description: null,
        priority: 10,
        sort: 4,
        premium: false,
    },
    [TwoFactorProviderType.Email]: {
        type: TwoFactorProviderType.Email,
        name: null,
        description: null,
        priority: 0,
        sort: 6,
        premium: false,
    },
    [TwoFactorProviderType.WebAuthn]: {
        type: TwoFactorProviderType.WebAuthn,
        name: null,
        description: null,
        priority: 4,
        sort: 5,
        premium: false,
    },
};
class TwoFactorService {
    constructor(i18nService, platformUtilsService) {
        this.i18nService = i18nService;
        this.platformUtilsService = platformUtilsService;
        this.selectedTwoFactorProviderType = null;
    }
    init() {
        TwoFactorProviders[TwoFactorProviderType.Email].name = this.i18nService.t("emailTitle");
        TwoFactorProviders[TwoFactorProviderType.Email].description = this.i18nService.t("emailDesc");
        TwoFactorProviders[TwoFactorProviderType.Authenticator].name =
            this.i18nService.t("authenticatorAppTitle");
        TwoFactorProviders[TwoFactorProviderType.Authenticator].description =
            this.i18nService.t("authenticatorAppDesc");
        TwoFactorProviders[TwoFactorProviderType.Duo].description = this.i18nService.t("duoDesc");
        TwoFactorProviders[TwoFactorProviderType.OrganizationDuo].name =
            "Duo (" + this.i18nService.t("organization") + ")";
        TwoFactorProviders[TwoFactorProviderType.OrganizationDuo].description =
            this.i18nService.t("duoOrganizationDesc");
        TwoFactorProviders[TwoFactorProviderType.WebAuthn].name = this.i18nService.t("webAuthnTitle");
        TwoFactorProviders[TwoFactorProviderType.WebAuthn].description =
            this.i18nService.t("webAuthnDesc");
        TwoFactorProviders[TwoFactorProviderType.Yubikey].name = this.i18nService.t("yubiKeyTitle");
        TwoFactorProviders[TwoFactorProviderType.Yubikey].description =
            this.i18nService.t("yubiKeyDesc");
    }
    getSupportedProviders(win) {
        const providers = [];
        if (this.twoFactorProvidersData == null) {
            return providers;
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.OrganizationDuo) &&
            this.platformUtilsService.supportsDuo()) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.OrganizationDuo]);
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.Authenticator)) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.Authenticator]);
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.Yubikey)) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.Yubikey]);
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.Duo) &&
            this.platformUtilsService.supportsDuo()) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.Duo]);
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.WebAuthn) &&
            this.platformUtilsService.supportsWebAuthn(win)) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.WebAuthn]);
        }
        if (this.twoFactorProvidersData.has(TwoFactorProviderType.Email)) {
            providers.push(TwoFactorProviders[TwoFactorProviderType.Email]);
        }
        return providers;
    }
    getDefaultProvider(webAuthnSupported) {
        if (this.twoFactorProvidersData == null) {
            return null;
        }
        if (this.selectedTwoFactorProviderType != null &&
            this.twoFactorProvidersData.has(this.selectedTwoFactorProviderType)) {
            return this.selectedTwoFactorProviderType;
        }
        let providerType = null;
        let providerPriority = -1;
        this.twoFactorProvidersData.forEach((_value, type) => {
            const provider = TwoFactorProviders[type];
            if (provider != null && provider.priority > providerPriority) {
                if (type === TwoFactorProviderType.WebAuthn && !webAuthnSupported) {
                    return;
                }
                providerType = type;
                providerPriority = provider.priority;
            }
        });
        return providerType;
    }
    setSelectedProvider(type) {
        this.selectedTwoFactorProviderType = type;
    }
    clearSelectedProvider() {
        this.selectedTwoFactorProviderType = null;
    }
    setProviders(response) {
        this.twoFactorProvidersData = response.twoFactorProviders2;
    }
    clearProviders() {
        this.twoFactorProvidersData = null;
    }
    getProviders() {
        return this.twoFactorProvidersData;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/user-verification/user-verification-api.service.ts
var user_verification_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class UserVerificationApiService {
    constructor(apiService) {
        this.apiService = apiService;
    }
    postAccountVerifyOTP(request) {
        return this.apiService.send("POST", "/accounts/verify-otp", request, true, false);
    }
    postAccountRequestOTP() {
        return user_verification_api_service_awaiter(this, void 0, void 0, function* () {
            return this.apiService.send("POST", "/accounts/request-otp", null, true, false);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/enums/verification-type.ts
var VerificationType;
(function (VerificationType) {
    VerificationType[VerificationType["MasterPassword"] = 0] = "MasterPassword";
    VerificationType[VerificationType["OTP"] = 1] = "OTP";
    VerificationType[VerificationType["PIN"] = 2] = "PIN";
    VerificationType[VerificationType["Biometrics"] = 3] = "Biometrics";
})(VerificationType || (VerificationType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/request/verify-otp.request.ts
class VerifyOTPRequest {
    constructor(OTP) {
        this.OTP = OTP;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/types/verification.ts
function verificationHasSecret(verification) {
    return "secret" in verification;
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/services/user-verification/user-verification.service.ts
var user_verification_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





/**
 * Used for general-purpose user verification throughout the app.
 * Use it to verify the input collected by UserVerificationComponent.
 */
class UserVerificationService {
    constructor(stateService, cryptoService, i18nService, userVerificationApiService, pinCryptoService, logService, vaultTimeoutSettingsService, platformUtilsService) {
        this.stateService = stateService;
        this.cryptoService = cryptoService;
        this.i18nService = i18nService;
        this.userVerificationApiService = userVerificationApiService;
        this.pinCryptoService = pinCryptoService;
        this.logService = logService;
        this.vaultTimeoutSettingsService = vaultTimeoutSettingsService;
        this.platformUtilsService = platformUtilsService;
    }
    getAvailableVerificationOptions(verificationType) {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            if (verificationType === "client") {
                const [userHasMasterPassword, pinLockType, biometricsLockSet, biometricsUserKeyStored] = yield Promise.all([
                    this.hasMasterPasswordAndMasterKeyHash(),
                    this.vaultTimeoutSettingsService.isPinLockSet(),
                    this.vaultTimeoutSettingsService.isBiometricLockSet(),
                    this.cryptoService.hasUserKeyStored(KeySuffixOptions.Biometric),
                ]);
                // note: we do not need to check this.platformUtilsService.supportsBiometric() because
                // we can just use the logic below which works for both desktop & the browser extension.
                return {
                    client: {
                        masterPassword: userHasMasterPassword,
                        pin: pinLockType !== "DISABLED",
                        biometrics: biometricsLockSet &&
                            (biometricsUserKeyStored || !this.platformUtilsService.supportsSecureStorage()),
                    },
                    server: {
                        masterPassword: false,
                        otp: false,
                    },
                };
            }
            else {
                // server
                // Don't check if have MP hash locally, because we are going to send the secret to the server to be verified.
                const userHasMasterPassword = yield this.hasMasterPassword();
                return {
                    client: {
                        masterPassword: false,
                        pin: false,
                        biometrics: false,
                    },
                    server: { masterPassword: userHasMasterPassword, otp: !userHasMasterPassword },
                };
            }
        });
    }
    /**
     * Create a new request model to be used for server-side verification
     * @param verification User-supplied verification data (Master Password or OTP)
     * @param requestClass The request model to create
     * @param alreadyHashed Whether the master password is already hashed
     */
    buildRequest(verification, requestClass, alreadyHashed) {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            this.validateSecretInput(verification);
            const request = requestClass != null ? new requestClass() : new SecretVerificationRequest();
            if (verification.type === VerificationType.OTP) {
                request.otp = verification.secret;
            }
            else {
                let masterKey = yield this.cryptoService.getMasterKey();
                if (!masterKey && !alreadyHashed) {
                    masterKey = yield this.cryptoService.makeMasterKey(verification.secret, yield this.stateService.getEmail(), yield this.stateService.getKdfType(), yield this.stateService.getKdfConfig());
                }
                request.masterPasswordHash = alreadyHashed
                    ? verification.secret
                    : yield this.cryptoService.hashMasterKey(verification.secret, masterKey);
            }
            return request;
        });
    }
    /**
     * Used to verify Master Password, PIN, or biometrics client-side, or send the OTP to the server for verification (with no other data)
     * Generally used for client-side verification only.
     * @param verification User-supplied verification data (OTP, MP, PIN, or biometrics)
     */
    verifyUser(verification) {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            if (verificationHasSecret(verification)) {
                this.validateSecretInput(verification);
            }
            switch (verification.type) {
                case VerificationType.OTP:
                    return this.verifyUserByOTP(verification);
                case VerificationType.MasterPassword:
                    return this.verifyUserByMasterPassword(verification);
                case VerificationType.PIN:
                    return this.verifyUserByPIN(verification);
                    break;
                case VerificationType.Biometrics:
                    return this.verifyUserByBiometrics();
                default: {
                    // Compile-time check for exhaustive switch
                    const _exhaustiveCheck = verification;
                    return _exhaustiveCheck;
                }
            }
        });
    }
    verifyUserByOTP(verification) {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            const request = new VerifyOTPRequest(verification.secret);
            try {
                yield this.userVerificationApiService.postAccountVerifyOTP(request);
            }
            catch (e) {
                throw new Error(this.i18nService.t("invalidVerificationCode"));
            }
            return true;
        });
    }
    verifyUserByMasterPassword(verification) {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            let masterKey = yield this.cryptoService.getMasterKey();
            if (!masterKey) {
                masterKey = yield this.cryptoService.makeMasterKey(verification.secret, yield this.stateService.getEmail(), yield this.stateService.getKdfType(), yield this.stateService.getKdfConfig());
            }
            const passwordValid = yield this.cryptoService.compareAndUpdateKeyHash(verification.secret, masterKey);
            if (!passwordValid) {
                throw new Error(this.i18nService.t("invalidMasterPassword"));
            }
            // TODO: we should re-evaluate later on if user verification should have the side effect of modifying state. Probably not.
            yield this.cryptoService.setMasterKey(masterKey);
            return true;
        });
    }
    verifyUserByPIN(verification) {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            const userKey = yield this.pinCryptoService.decryptUserKeyWithPin(verification.secret);
            return userKey != null;
        });
    }
    verifyUserByBiometrics() {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            let userKey;
            // Biometrics crashes and doesn't return a value if the user cancels the prompt
            try {
                userKey = yield this.cryptoService.getUserKeyFromStorage(KeySuffixOptions.Biometric);
            }
            catch (e) {
                this.logService.error(`Biometrics User Verification failed: ${e.message}`);
                // So, any failures should be treated as a failed verification
                return false;
            }
            return userKey != null;
        });
    }
    requestOTP() {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            yield this.userVerificationApiService.postAccountRequestOTP();
        });
    }
    /**
     * Check if user has master password or can only use passwordless technologies to log in
     * Note: This only checks the server, not the local state
     * @param userId The user id to check. If not provided, the current user is used
     * @returns True if the user has a master password
     */
    hasMasterPassword(userId) {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            const decryptionOptions = yield this.stateService.getAccountDecryptionOptions({ userId });
            if ((decryptionOptions === null || decryptionOptions === void 0 ? void 0 : decryptionOptions.hasMasterPassword) != undefined) {
                return decryptionOptions.hasMasterPassword;
            }
            // TODO: PM-3518 - Left for backwards compatibility, remove after 2023.12.0
            return !(yield this.stateService.getUsesKeyConnector({ userId }));
        });
    }
    hasMasterPasswordAndMasterKeyHash(userId) {
        return user_verification_service_awaiter(this, void 0, void 0, function* () {
            return ((yield this.hasMasterPassword(userId)) &&
                (yield this.cryptoService.getMasterKeyHash()) != null);
        });
    }
    validateSecretInput(verification) {
        if ((verification === null || verification === void 0 ? void 0 : verification.secret) == null || verification.secret === "") {
            switch (verification.type) {
                case VerificationType.OTP:
                    throw new Error(this.i18nService.t("verificationCodeRequired"));
                case VerificationType.MasterPassword:
                    throw new Error(this.i18nService.t("masterPasswordRequired"));
                case VerificationType.PIN:
                    throw new Error(this.i18nService.t("pinRequired"));
            }
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/factories/account-factory.ts
class AccountFactory {
    constructor(accountConstructor) {
        this.accountConstructor = accountConstructor;
    }
    create(args) {
        return new this.accountConstructor(args);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/factories/global-state-factory.ts
class GlobalStateFactory {
    constructor(globalStateConstructor) {
        this.globalStateConstructor = globalStateConstructor;
    }
    create(args) {
        return new this.globalStateConstructor(args);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/factories/state-factory.ts


class StateFactory {
    constructor(globalStateConstructor, accountConstructor) {
        this.globalStateFactory = new GlobalStateFactory(globalStateConstructor);
        this.accountFactory = new AccountFactory(accountConstructor);
    }
    createGlobal(args) {
        return this.globalStateFactory.create(args);
    }
    createAccount(args) {
        return this.accountFactory.create(args);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/domain/window-state.ts
class WindowState {
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/global-state.ts


class GlobalState {
    constructor() {
        this.theme = ThemeType.System;
        this.window = new WindowState();
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/app-id.service.ts
var app_id_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class AppIdService {
    constructor(storageService) {
        this.storageService = storageService;
    }
    getAppId() {
        return this.makeAndGetAppId("appId");
    }
    getAnonymousAppId() {
        return this.makeAndGetAppId("anonymousAppId");
    }
    makeAndGetAppId(key) {
        return app_id_service_awaiter(this, void 0, void 0, function* () {
            const existingId = yield this.storageService.get(key, {
                htmlStorageLocation: HtmlStorageLocation.Local,
            });
            if (existingId != null) {
                return existingId;
            }
            const guid = utils_Utils.newGuid();
            yield this.storageService.save(key, guid, {
                htmlStorageLocation: HtmlStorageLocation.Local,
            });
            return guid;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/broadcaster.service.ts
class BroadcasterService {
    constructor() {
        this.subscribers = new Map();
    }
    send(message, id) {
        if (id != null) {
            if (this.subscribers.has(id)) {
                this.subscribers.get(id)(message);
            }
            return;
        }
        this.subscribers.forEach((value) => {
            value(message);
        });
    }
    subscribe(id, messageCallback) {
        this.subscribers.set(id, messageCallback);
    }
    unsubscribe(id) {
        if (this.subscribers.has(id)) {
            this.subscribers.delete(id);
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/response/server-config.response.ts

class ServerConfigResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.featureStates = {};
        if (response == null) {
            return;
        }
        this.version = this.getResponseProperty("Version");
        this.gitHash = this.getResponseProperty("GitHash");
        this.server = new ThirdPartyServerConfigResponse(this.getResponseProperty("Server"));
        this.environment = new EnvironmentServerConfigResponse(this.getResponseProperty("Environment"));
        this.featureStates = this.getResponseProperty("FeatureStates");
    }
}
class EnvironmentServerConfigResponse extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.cloudRegion = this.getResponseProperty("CloudRegion");
        this.vault = this.getResponseProperty("Vault");
        this.api = this.getResponseProperty("Api");
        this.identity = this.getResponseProperty("Identity");
        this.notifications = this.getResponseProperty("Notifications");
        this.sso = this.getResponseProperty("Sso");
    }
}
class ThirdPartyServerConfigResponse extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.name = this.getResponseProperty("Name");
        this.url = this.getResponseProperty("Url");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/config/config-api.service.ts
var config_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class ConfigApiService {
    constructor(apiService, authService) {
        this.apiService = apiService;
        this.authService = authService;
    }
    get() {
        return config_api_service_awaiter(this, void 0, void 0, function* () {
            const authed = (yield this.authService.getAuthStatus()) !== AuthenticationStatus.LoggedOut;
            const r = yield this.apiService.send("GET", "/config", null, authed, true);
            return new ServerConfigResponse(r);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/container.service.ts
class ContainerService {
    constructor(cryptoService, encryptService) {
        this.cryptoService = cryptoService;
        this.encryptService = encryptService;
    }
    attachToGlobal(global) {
        if (!global.bitwardenContainerService) {
            global.bitwardenContainerService = this;
        }
    }
    /**
     * @throws Will throw if CryptoService was not instantiated and provided to the ContainerService constructor
     */
    getCryptoService() {
        if (this.cryptoService == null) {
            throw new Error("ContainerService.cryptoService not initialized.");
        }
        return this.cryptoService;
    }
    /**
     * @throws Will throw if EncryptService was not instantiated and provided to the ContainerService constructor
     */
    getEncryptService() {
        if (this.encryptService == null) {
            throw new Error("ContainerService.encryptService not initialized.");
        }
        return this.encryptService;
    }
}

;// CONCATENATED MODULE: external "big-integer"
const external_big_integer_namespaceObject = require("big-integer");
;// CONCATENATED MODULE: ../../libs/common/src/platform/misc/sequentialize.ts
/**
 * Use as a Decorator on async functions, it will prevent multiple 'active' calls as the same time
 *
 * If a promise was returned from a previous call to this function, that hasn't yet resolved it will
 * be returned, instead of calling the original function again
 *
 * Results are not cached, once the promise has returned, the next call will result in a fresh call
 *
 * Read more at https://github.com/bitwarden/jslib/pull/7
 */
function sequentialize(cacheKey) {
    return (target, propertyKey, descriptor) => {
        const originalMethod = descriptor.value;
        const caches = new Map();
        const getCache = (obj) => {
            let cache = caches.get(obj);
            if (cache != null) {
                return cache;
            }
            cache = new Map();
            caches.set(obj, cache);
            return cache;
        };
        return {
            value: function (...args) {
                const cache = getCache(this);
                const argsCacheKey = cacheKey(args);
                let response = cache.get(argsCacheKey);
                if (response != null) {
                    return response;
                }
                const onFinally = () => {
                    cache.delete(argsCacheKey);
                    if (cache.size === 0) {
                        caches.delete(this);
                    }
                };
                response = originalMethod
                    .apply(this, args)
                    .then((val) => {
                    onFinally();
                    return val;
                })
                    .catch((err) => {
                    onFinally();
                    throw err;
                });
                cache.set(argsCacheKey, response);
                return response;
            },
        };
    };
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/misc/wordlist.ts
// EFF's Long Wordlist from https://www.eff.org/dice
const EFFLongWordList = [
    "abacus",
    "abdomen",
    "abdominal",
    "abide",
    "abiding",
    "ability",
    "ablaze",
    "able",
    "abnormal",
    "abrasion",
    "abrasive",
    "abreast",
    "abridge",
    "abroad",
    "abruptly",
    "absence",
    "absentee",
    "absently",
    "absinthe",
    "absolute",
    "absolve",
    "abstain",
    "abstract",
    "absurd",
    "accent",
    "acclaim",
    "acclimate",
    "accompany",
    "account",
    "accuracy",
    "accurate",
    "accustom",
    "acetone",
    "achiness",
    "aching",
    "acid",
    "acorn",
    "acquaint",
    "acquire",
    "acre",
    "acrobat",
    "acronym",
    "acting",
    "action",
    "activate",
    "activator",
    "active",
    "activism",
    "activist",
    "activity",
    "actress",
    "acts",
    "acutely",
    "acuteness",
    "aeration",
    "aerobics",
    "aerosol",
    "aerospace",
    "afar",
    "affair",
    "affected",
    "affecting",
    "affection",
    "affidavit",
    "affiliate",
    "affirm",
    "affix",
    "afflicted",
    "affluent",
    "afford",
    "affront",
    "aflame",
    "afloat",
    "aflutter",
    "afoot",
    "afraid",
    "afterglow",
    "afterlife",
    "aftermath",
    "aftermost",
    "afternoon",
    "aged",
    "ageless",
    "agency",
    "agenda",
    "agent",
    "aggregate",
    "aghast",
    "agile",
    "agility",
    "aging",
    "agnostic",
    "agonize",
    "agonizing",
    "agony",
    "agreeable",
    "agreeably",
    "agreed",
    "agreeing",
    "agreement",
    "aground",
    "ahead",
    "ahoy",
    "aide",
    "aids",
    "aim",
    "ajar",
    "alabaster",
    "alarm",
    "albatross",
    "album",
    "alfalfa",
    "algebra",
    "algorithm",
    "alias",
    "alibi",
    "alienable",
    "alienate",
    "aliens",
    "alike",
    "alive",
    "alkaline",
    "alkalize",
    "almanac",
    "almighty",
    "almost",
    "aloe",
    "aloft",
    "aloha",
    "alone",
    "alongside",
    "aloof",
    "alphabet",
    "alright",
    "although",
    "altitude",
    "alto",
    "aluminum",
    "alumni",
    "always",
    "amaretto",
    "amaze",
    "amazingly",
    "amber",
    "ambiance",
    "ambiguity",
    "ambiguous",
    "ambition",
    "ambitious",
    "ambulance",
    "ambush",
    "amendable",
    "amendment",
    "amends",
    "amenity",
    "amiable",
    "amicably",
    "amid",
    "amigo",
    "amino",
    "amiss",
    "ammonia",
    "ammonium",
    "amnesty",
    "amniotic",
    "among",
    "amount",
    "amperage",
    "ample",
    "amplifier",
    "amplify",
    "amply",
    "amuck",
    "amulet",
    "amusable",
    "amused",
    "amusement",
    "amuser",
    "amusing",
    "anaconda",
    "anaerobic",
    "anagram",
    "anatomist",
    "anatomy",
    "anchor",
    "anchovy",
    "ancient",
    "android",
    "anemia",
    "anemic",
    "aneurism",
    "anew",
    "angelfish",
    "angelic",
    "anger",
    "angled",
    "angler",
    "angles",
    "angling",
    "angrily",
    "angriness",
    "anguished",
    "angular",
    "animal",
    "animate",
    "animating",
    "animation",
    "animator",
    "anime",
    "animosity",
    "ankle",
    "annex",
    "annotate",
    "announcer",
    "annoying",
    "annually",
    "annuity",
    "anointer",
    "another",
    "answering",
    "antacid",
    "antarctic",
    "anteater",
    "antelope",
    "antennae",
    "anthem",
    "anthill",
    "anthology",
    "antibody",
    "antics",
    "antidote",
    "antihero",
    "antiquely",
    "antiques",
    "antiquity",
    "antirust",
    "antitoxic",
    "antitrust",
    "antiviral",
    "antivirus",
    "antler",
    "antonym",
    "antsy",
    "anvil",
    "anybody",
    "anyhow",
    "anymore",
    "anyone",
    "anyplace",
    "anything",
    "anytime",
    "anyway",
    "anywhere",
    "aorta",
    "apache",
    "apostle",
    "appealing",
    "appear",
    "appease",
    "appeasing",
    "appendage",
    "appendix",
    "appetite",
    "appetizer",
    "applaud",
    "applause",
    "apple",
    "appliance",
    "applicant",
    "applied",
    "apply",
    "appointee",
    "appraisal",
    "appraiser",
    "apprehend",
    "approach",
    "approval",
    "approve",
    "apricot",
    "april",
    "apron",
    "aptitude",
    "aptly",
    "aqua",
    "aqueduct",
    "arbitrary",
    "arbitrate",
    "ardently",
    "area",
    "arena",
    "arguable",
    "arguably",
    "argue",
    "arise",
    "armadillo",
    "armband",
    "armchair",
    "armed",
    "armful",
    "armhole",
    "arming",
    "armless",
    "armoire",
    "armored",
    "armory",
    "armrest",
    "army",
    "aroma",
    "arose",
    "around",
    "arousal",
    "arrange",
    "array",
    "arrest",
    "arrival",
    "arrive",
    "arrogance",
    "arrogant",
    "arson",
    "art",
    "ascend",
    "ascension",
    "ascent",
    "ascertain",
    "ashamed",
    "ashen",
    "ashes",
    "ashy",
    "aside",
    "askew",
    "asleep",
    "asparagus",
    "aspect",
    "aspirate",
    "aspire",
    "aspirin",
    "astonish",
    "astound",
    "astride",
    "astrology",
    "astronaut",
    "astronomy",
    "astute",
    "atlantic",
    "atlas",
    "atom",
    "atonable",
    "atop",
    "atrium",
    "atrocious",
    "atrophy",
    "attach",
    "attain",
    "attempt",
    "attendant",
    "attendee",
    "attention",
    "attentive",
    "attest",
    "attic",
    "attire",
    "attitude",
    "attractor",
    "attribute",
    "atypical",
    "auction",
    "audacious",
    "audacity",
    "audible",
    "audibly",
    "audience",
    "audio",
    "audition",
    "augmented",
    "august",
    "authentic",
    "author",
    "autism",
    "autistic",
    "autograph",
    "automaker",
    "automated",
    "automatic",
    "autopilot",
    "available",
    "avalanche",
    "avatar",
    "avenge",
    "avenging",
    "avenue",
    "average",
    "aversion",
    "avert",
    "aviation",
    "aviator",
    "avid",
    "avoid",
    "await",
    "awaken",
    "award",
    "aware",
    "awhile",
    "awkward",
    "awning",
    "awoke",
    "awry",
    "axis",
    "babble",
    "babbling",
    "babied",
    "baboon",
    "backache",
    "backboard",
    "backboned",
    "backdrop",
    "backed",
    "backer",
    "backfield",
    "backfire",
    "backhand",
    "backing",
    "backlands",
    "backlash",
    "backless",
    "backlight",
    "backlit",
    "backlog",
    "backpack",
    "backpedal",
    "backrest",
    "backroom",
    "backshift",
    "backside",
    "backslid",
    "backspace",
    "backspin",
    "backstab",
    "backstage",
    "backtalk",
    "backtrack",
    "backup",
    "backward",
    "backwash",
    "backwater",
    "backyard",
    "bacon",
    "bacteria",
    "bacterium",
    "badass",
    "badge",
    "badland",
    "badly",
    "badness",
    "baffle",
    "baffling",
    "bagel",
    "bagful",
    "baggage",
    "bagged",
    "baggie",
    "bagginess",
    "bagging",
    "baggy",
    "bagpipe",
    "baguette",
    "baked",
    "bakery",
    "bakeshop",
    "baking",
    "balance",
    "balancing",
    "balcony",
    "balmy",
    "balsamic",
    "bamboo",
    "banana",
    "banish",
    "banister",
    "banjo",
    "bankable",
    "bankbook",
    "banked",
    "banker",
    "banking",
    "banknote",
    "bankroll",
    "banner",
    "bannister",
    "banshee",
    "banter",
    "barbecue",
    "barbed",
    "barbell",
    "barber",
    "barcode",
    "barge",
    "bargraph",
    "barista",
    "baritone",
    "barley",
    "barmaid",
    "barman",
    "barn",
    "barometer",
    "barrack",
    "barracuda",
    "barrel",
    "barrette",
    "barricade",
    "barrier",
    "barstool",
    "bartender",
    "barterer",
    "bash",
    "basically",
    "basics",
    "basil",
    "basin",
    "basis",
    "basket",
    "batboy",
    "batch",
    "bath",
    "baton",
    "bats",
    "battalion",
    "battered",
    "battering",
    "battery",
    "batting",
    "battle",
    "bauble",
    "bazooka",
    "blabber",
    "bladder",
    "blade",
    "blah",
    "blame",
    "blaming",
    "blanching",
    "blandness",
    "blank",
    "blaspheme",
    "blasphemy",
    "blast",
    "blatancy",
    "blatantly",
    "blazer",
    "blazing",
    "bleach",
    "bleak",
    "bleep",
    "blemish",
    "blend",
    "bless",
    "blighted",
    "blimp",
    "bling",
    "blinked",
    "blinker",
    "blinking",
    "blinks",
    "blip",
    "blissful",
    "blitz",
    "blizzard",
    "bloated",
    "bloating",
    "blob",
    "blog",
    "bloomers",
    "blooming",
    "blooper",
    "blot",
    "blouse",
    "blubber",
    "bluff",
    "bluish",
    "blunderer",
    "blunt",
    "blurb",
    "blurred",
    "blurry",
    "blurt",
    "blush",
    "blustery",
    "boaster",
    "boastful",
    "boasting",
    "boat",
    "bobbed",
    "bobbing",
    "bobble",
    "bobcat",
    "bobsled",
    "bobtail",
    "bodacious",
    "body",
    "bogged",
    "boggle",
    "bogus",
    "boil",
    "bok",
    "bolster",
    "bolt",
    "bonanza",
    "bonded",
    "bonding",
    "bondless",
    "boned",
    "bonehead",
    "boneless",
    "bonelike",
    "boney",
    "bonfire",
    "bonnet",
    "bonsai",
    "bonus",
    "bony",
    "boogeyman",
    "boogieman",
    "book",
    "boondocks",
    "booted",
    "booth",
    "bootie",
    "booting",
    "bootlace",
    "bootleg",
    "boots",
    "boozy",
    "borax",
    "boring",
    "borough",
    "borrower",
    "borrowing",
    "boss",
    "botanical",
    "botanist",
    "botany",
    "botch",
    "both",
    "bottle",
    "bottling",
    "bottom",
    "bounce",
    "bouncing",
    "bouncy",
    "bounding",
    "boundless",
    "bountiful",
    "bovine",
    "boxcar",
    "boxer",
    "boxing",
    "boxlike",
    "boxy",
    "breach",
    "breath",
    "breeches",
    "breeching",
    "breeder",
    "breeding",
    "breeze",
    "breezy",
    "brethren",
    "brewery",
    "brewing",
    "briar",
    "bribe",
    "brick",
    "bride",
    "bridged",
    "brigade",
    "bright",
    "brilliant",
    "brim",
    "bring",
    "brink",
    "brisket",
    "briskly",
    "briskness",
    "bristle",
    "brittle",
    "broadband",
    "broadcast",
    "broaden",
    "broadly",
    "broadness",
    "broadside",
    "broadways",
    "broiler",
    "broiling",
    "broken",
    "broker",
    "bronchial",
    "bronco",
    "bronze",
    "bronzing",
    "brook",
    "broom",
    "brought",
    "browbeat",
    "brownnose",
    "browse",
    "browsing",
    "bruising",
    "brunch",
    "brunette",
    "brunt",
    "brush",
    "brussels",
    "brute",
    "brutishly",
    "bubble",
    "bubbling",
    "bubbly",
    "buccaneer",
    "bucked",
    "bucket",
    "buckle",
    "buckshot",
    "buckskin",
    "bucktooth",
    "buckwheat",
    "buddhism",
    "buddhist",
    "budding",
    "buddy",
    "budget",
    "buffalo",
    "buffed",
    "buffer",
    "buffing",
    "buffoon",
    "buggy",
    "bulb",
    "bulge",
    "bulginess",
    "bulgur",
    "bulk",
    "bulldog",
    "bulldozer",
    "bullfight",
    "bullfrog",
    "bullhorn",
    "bullion",
    "bullish",
    "bullpen",
    "bullring",
    "bullseye",
    "bullwhip",
    "bully",
    "bunch",
    "bundle",
    "bungee",
    "bunion",
    "bunkbed",
    "bunkhouse",
    "bunkmate",
    "bunny",
    "bunt",
    "busboy",
    "bush",
    "busily",
    "busload",
    "bust",
    "busybody",
    "buzz",
    "cabana",
    "cabbage",
    "cabbie",
    "cabdriver",
    "cable",
    "caboose",
    "cache",
    "cackle",
    "cacti",
    "cactus",
    "caddie",
    "caddy",
    "cadet",
    "cadillac",
    "cadmium",
    "cage",
    "cahoots",
    "cake",
    "calamari",
    "calamity",
    "calcium",
    "calculate",
    "calculus",
    "caliber",
    "calibrate",
    "calm",
    "caloric",
    "calorie",
    "calzone",
    "camcorder",
    "cameo",
    "camera",
    "camisole",
    "camper",
    "campfire",
    "camping",
    "campsite",
    "campus",
    "canal",
    "canary",
    "cancel",
    "candied",
    "candle",
    "candy",
    "cane",
    "canine",
    "canister",
    "cannabis",
    "canned",
    "canning",
    "cannon",
    "cannot",
    "canola",
    "canon",
    "canopener",
    "canopy",
    "canteen",
    "canyon",
    "capable",
    "capably",
    "capacity",
    "cape",
    "capillary",
    "capital",
    "capitol",
    "capped",
    "capricorn",
    "capsize",
    "capsule",
    "caption",
    "captivate",
    "captive",
    "captivity",
    "capture",
    "caramel",
    "carat",
    "caravan",
    "carbon",
    "cardboard",
    "carded",
    "cardiac",
    "cardigan",
    "cardinal",
    "cardstock",
    "carefully",
    "caregiver",
    "careless",
    "caress",
    "caretaker",
    "cargo",
    "caring",
    "carless",
    "carload",
    "carmaker",
    "carnage",
    "carnation",
    "carnival",
    "carnivore",
    "carol",
    "carpenter",
    "carpentry",
    "carpool",
    "carport",
    "carried",
    "carrot",
    "carrousel",
    "carry",
    "cartel",
    "cartload",
    "carton",
    "cartoon",
    "cartridge",
    "cartwheel",
    "carve",
    "carving",
    "carwash",
    "cascade",
    "case",
    "cash",
    "casing",
    "casino",
    "casket",
    "cassette",
    "casually",
    "casualty",
    "catacomb",
    "catalog",
    "catalyst",
    "catalyze",
    "catapult",
    "cataract",
    "catatonic",
    "catcall",
    "catchable",
    "catcher",
    "catching",
    "catchy",
    "caterer",
    "catering",
    "catfight",
    "catfish",
    "cathedral",
    "cathouse",
    "catlike",
    "catnap",
    "catnip",
    "catsup",
    "cattail",
    "cattishly",
    "cattle",
    "catty",
    "catwalk",
    "caucasian",
    "caucus",
    "causal",
    "causation",
    "cause",
    "causing",
    "cauterize",
    "caution",
    "cautious",
    "cavalier",
    "cavalry",
    "caviar",
    "cavity",
    "cedar",
    "celery",
    "celestial",
    "celibacy",
    "celibate",
    "celtic",
    "cement",
    "census",
    "ceramics",
    "ceremony",
    "certainly",
    "certainty",
    "certified",
    "certify",
    "cesarean",
    "cesspool",
    "chafe",
    "chaffing",
    "chain",
    "chair",
    "chalice",
    "challenge",
    "chamber",
    "chamomile",
    "champion",
    "chance",
    "change",
    "channel",
    "chant",
    "chaos",
    "chaperone",
    "chaplain",
    "chapped",
    "chaps",
    "chapter",
    "character",
    "charbroil",
    "charcoal",
    "charger",
    "charging",
    "chariot",
    "charity",
    "charm",
    "charred",
    "charter",
    "charting",
    "chase",
    "chasing",
    "chaste",
    "chastise",
    "chastity",
    "chatroom",
    "chatter",
    "chatting",
    "chatty",
    "cheating",
    "cheddar",
    "cheek",
    "cheer",
    "cheese",
    "cheesy",
    "chef",
    "chemicals",
    "chemist",
    "chemo",
    "cherisher",
    "cherub",
    "chess",
    "chest",
    "chevron",
    "chevy",
    "chewable",
    "chewer",
    "chewing",
    "chewy",
    "chief",
    "chihuahua",
    "childcare",
    "childhood",
    "childish",
    "childless",
    "childlike",
    "chili",
    "chill",
    "chimp",
    "chip",
    "chirping",
    "chirpy",
    "chitchat",
    "chivalry",
    "chive",
    "chloride",
    "chlorine",
    "choice",
    "chokehold",
    "choking",
    "chomp",
    "chooser",
    "choosing",
    "choosy",
    "chop",
    "chosen",
    "chowder",
    "chowtime",
    "chrome",
    "chubby",
    "chuck",
    "chug",
    "chummy",
    "chump",
    "chunk",
    "churn",
    "chute",
    "cider",
    "cilantro",
    "cinch",
    "cinema",
    "cinnamon",
    "circle",
    "circling",
    "circular",
    "circulate",
    "circus",
    "citable",
    "citadel",
    "citation",
    "citizen",
    "citric",
    "citrus",
    "city",
    "civic",
    "civil",
    "clad",
    "claim",
    "clambake",
    "clammy",
    "clamor",
    "clamp",
    "clamshell",
    "clang",
    "clanking",
    "clapped",
    "clapper",
    "clapping",
    "clarify",
    "clarinet",
    "clarity",
    "clash",
    "clasp",
    "class",
    "clatter",
    "clause",
    "clavicle",
    "claw",
    "clay",
    "clean",
    "clear",
    "cleat",
    "cleaver",
    "cleft",
    "clench",
    "clergyman",
    "clerical",
    "clerk",
    "clever",
    "clicker",
    "client",
    "climate",
    "climatic",
    "cling",
    "clinic",
    "clinking",
    "clip",
    "clique",
    "cloak",
    "clobber",
    "clock",
    "clone",
    "cloning",
    "closable",
    "closure",
    "clothes",
    "clothing",
    "cloud",
    "clover",
    "clubbed",
    "clubbing",
    "clubhouse",
    "clump",
    "clumsily",
    "clumsy",
    "clunky",
    "clustered",
    "clutch",
    "clutter",
    "coach",
    "coagulant",
    "coastal",
    "coaster",
    "coasting",
    "coastland",
    "coastline",
    "coat",
    "coauthor",
    "cobalt",
    "cobbler",
    "cobweb",
    "cocoa",
    "coconut",
    "cod",
    "coeditor",
    "coerce",
    "coexist",
    "coffee",
    "cofounder",
    "cognition",
    "cognitive",
    "cogwheel",
    "coherence",
    "coherent",
    "cohesive",
    "coil",
    "coke",
    "cola",
    "cold",
    "coleslaw",
    "coliseum",
    "collage",
    "collapse",
    "collar",
    "collected",
    "collector",
    "collide",
    "collie",
    "collision",
    "colonial",
    "colonist",
    "colonize",
    "colony",
    "colossal",
    "colt",
    "coma",
    "come",
    "comfort",
    "comfy",
    "comic",
    "coming",
    "comma",
    "commence",
    "commend",
    "comment",
    "commerce",
    "commode",
    "commodity",
    "commodore",
    "common",
    "commotion",
    "commute",
    "commuting",
    "compacted",
    "compacter",
    "compactly",
    "compactor",
    "companion",
    "company",
    "compare",
    "compel",
    "compile",
    "comply",
    "component",
    "composed",
    "composer",
    "composite",
    "compost",
    "composure",
    "compound",
    "compress",
    "comprised",
    "computer",
    "computing",
    "comrade",
    "concave",
    "conceal",
    "conceded",
    "concept",
    "concerned",
    "concert",
    "conch",
    "concierge",
    "concise",
    "conclude",
    "concrete",
    "concur",
    "condense",
    "condiment",
    "condition",
    "condone",
    "conducive",
    "conductor",
    "conduit",
    "cone",
    "confess",
    "confetti",
    "confidant",
    "confident",
    "confider",
    "confiding",
    "configure",
    "confined",
    "confining",
    "confirm",
    "conflict",
    "conform",
    "confound",
    "confront",
    "confused",
    "confusing",
    "confusion",
    "congenial",
    "congested",
    "congrats",
    "congress",
    "conical",
    "conjoined",
    "conjure",
    "conjuror",
    "connected",
    "connector",
    "consensus",
    "consent",
    "console",
    "consoling",
    "consonant",
    "constable",
    "constant",
    "constrain",
    "constrict",
    "construct",
    "consult",
    "consumer",
    "consuming",
    "contact",
    "container",
    "contempt",
    "contend",
    "contented",
    "contently",
    "contents",
    "contest",
    "context",
    "contort",
    "contour",
    "contrite",
    "control",
    "contusion",
    "convene",
    "convent",
    "copartner",
    "cope",
    "copied",
    "copier",
    "copilot",
    "coping",
    "copious",
    "copper",
    "copy",
    "coral",
    "cork",
    "cornball",
    "cornbread",
    "corncob",
    "cornea",
    "corned",
    "corner",
    "cornfield",
    "cornflake",
    "cornhusk",
    "cornmeal",
    "cornstalk",
    "corny",
    "coronary",
    "coroner",
    "corporal",
    "corporate",
    "corral",
    "correct",
    "corridor",
    "corrode",
    "corroding",
    "corrosive",
    "corsage",
    "corset",
    "cortex",
    "cosigner",
    "cosmetics",
    "cosmic",
    "cosmos",
    "cosponsor",
    "cost",
    "cottage",
    "cotton",
    "couch",
    "cough",
    "could",
    "countable",
    "countdown",
    "counting",
    "countless",
    "country",
    "county",
    "courier",
    "covenant",
    "cover",
    "coveted",
    "coveting",
    "coyness",
    "cozily",
    "coziness",
    "cozy",
    "crabbing",
    "crabgrass",
    "crablike",
    "crabmeat",
    "cradle",
    "cradling",
    "crafter",
    "craftily",
    "craftsman",
    "craftwork",
    "crafty",
    "cramp",
    "cranberry",
    "crane",
    "cranial",
    "cranium",
    "crank",
    "crate",
    "crave",
    "craving",
    "crawfish",
    "crawlers",
    "crawling",
    "crayfish",
    "crayon",
    "crazed",
    "crazily",
    "craziness",
    "crazy",
    "creamed",
    "creamer",
    "creamlike",
    "crease",
    "creasing",
    "creatable",
    "create",
    "creation",
    "creative",
    "creature",
    "credible",
    "credibly",
    "credit",
    "creed",
    "creme",
    "creole",
    "crepe",
    "crept",
    "crescent",
    "crested",
    "cresting",
    "crestless",
    "crevice",
    "crewless",
    "crewman",
    "crewmate",
    "crib",
    "cricket",
    "cried",
    "crier",
    "crimp",
    "crimson",
    "cringe",
    "cringing",
    "crinkle",
    "crinkly",
    "crisped",
    "crisping",
    "crisply",
    "crispness",
    "crispy",
    "criteria",
    "critter",
    "croak",
    "crock",
    "crook",
    "croon",
    "crop",
    "cross",
    "crouch",
    "crouton",
    "crowbar",
    "crowd",
    "crown",
    "crucial",
    "crudely",
    "crudeness",
    "cruelly",
    "cruelness",
    "cruelty",
    "crumb",
    "crummiest",
    "crummy",
    "crumpet",
    "crumpled",
    "cruncher",
    "crunching",
    "crunchy",
    "crusader",
    "crushable",
    "crushed",
    "crusher",
    "crushing",
    "crust",
    "crux",
    "crying",
    "cryptic",
    "crystal",
    "cubbyhole",
    "cube",
    "cubical",
    "cubicle",
    "cucumber",
    "cuddle",
    "cuddly",
    "cufflink",
    "culinary",
    "culminate",
    "culpable",
    "culprit",
    "cultivate",
    "cultural",
    "culture",
    "cupbearer",
    "cupcake",
    "cupid",
    "cupped",
    "cupping",
    "curable",
    "curator",
    "curdle",
    "cure",
    "curfew",
    "curing",
    "curled",
    "curler",
    "curliness",
    "curling",
    "curly",
    "curry",
    "curse",
    "cursive",
    "cursor",
    "curtain",
    "curtly",
    "curtsy",
    "curvature",
    "curve",
    "curvy",
    "cushy",
    "cusp",
    "cussed",
    "custard",
    "custodian",
    "custody",
    "customary",
    "customer",
    "customize",
    "customs",
    "cut",
    "cycle",
    "cyclic",
    "cycling",
    "cyclist",
    "cylinder",
    "cymbal",
    "cytoplasm",
    "cytoplast",
    "dab",
    "dad",
    "daffodil",
    "dagger",
    "daily",
    "daintily",
    "dainty",
    "dairy",
    "daisy",
    "dallying",
    "dance",
    "dancing",
    "dandelion",
    "dander",
    "dandruff",
    "dandy",
    "danger",
    "dangle",
    "dangling",
    "daredevil",
    "dares",
    "daringly",
    "darkened",
    "darkening",
    "darkish",
    "darkness",
    "darkroom",
    "darling",
    "darn",
    "dart",
    "darwinism",
    "dash",
    "dastardly",
    "data",
    "datebook",
    "dating",
    "daughter",
    "daunting",
    "dawdler",
    "dawn",
    "daybed",
    "daybreak",
    "daycare",
    "daydream",
    "daylight",
    "daylong",
    "dayroom",
    "daytime",
    "dazzler",
    "dazzling",
    "deacon",
    "deafening",
    "deafness",
    "dealer",
    "dealing",
    "dealmaker",
    "dealt",
    "dean",
    "debatable",
    "debate",
    "debating",
    "debit",
    "debrief",
    "debtless",
    "debtor",
    "debug",
    "debunk",
    "decade",
    "decaf",
    "decal",
    "decathlon",
    "decay",
    "deceased",
    "deceit",
    "deceiver",
    "deceiving",
    "december",
    "decency",
    "decent",
    "deception",
    "deceptive",
    "decibel",
    "decidable",
    "decimal",
    "decimeter",
    "decipher",
    "deck",
    "declared",
    "decline",
    "decode",
    "decompose",
    "decorated",
    "decorator",
    "decoy",
    "decrease",
    "decree",
    "dedicate",
    "dedicator",
    "deduce",
    "deduct",
    "deed",
    "deem",
    "deepen",
    "deeply",
    "deepness",
    "deface",
    "defacing",
    "defame",
    "default",
    "defeat",
    "defection",
    "defective",
    "defendant",
    "defender",
    "defense",
    "defensive",
    "deferral",
    "deferred",
    "defiance",
    "defiant",
    "defile",
    "defiling",
    "define",
    "definite",
    "deflate",
    "deflation",
    "deflator",
    "deflected",
    "deflector",
    "defog",
    "deforest",
    "defraud",
    "defrost",
    "deftly",
    "defuse",
    "defy",
    "degraded",
    "degrading",
    "degrease",
    "degree",
    "dehydrate",
    "deity",
    "dejected",
    "delay",
    "delegate",
    "delegator",
    "delete",
    "deletion",
    "delicacy",
    "delicate",
    "delicious",
    "delighted",
    "delirious",
    "delirium",
    "deliverer",
    "delivery",
    "delouse",
    "delta",
    "deluge",
    "delusion",
    "deluxe",
    "demanding",
    "demeaning",
    "demeanor",
    "demise",
    "democracy",
    "democrat",
    "demote",
    "demotion",
    "demystify",
    "denatured",
    "deniable",
    "denial",
    "denim",
    "denote",
    "dense",
    "density",
    "dental",
    "dentist",
    "denture",
    "deny",
    "deodorant",
    "deodorize",
    "departed",
    "departure",
    "depict",
    "deplete",
    "depletion",
    "deplored",
    "deploy",
    "deport",
    "depose",
    "depraved",
    "depravity",
    "deprecate",
    "depress",
    "deprive",
    "depth",
    "deputize",
    "deputy",
    "derail",
    "deranged",
    "derby",
    "derived",
    "desecrate",
    "deserve",
    "deserving",
    "designate",
    "designed",
    "designer",
    "designing",
    "deskbound",
    "desktop",
    "deskwork",
    "desolate",
    "despair",
    "despise",
    "despite",
    "destiny",
    "destitute",
    "destruct",
    "detached",
    "detail",
    "detection",
    "detective",
    "detector",
    "detention",
    "detergent",
    "detest",
    "detonate",
    "detonator",
    "detoxify",
    "detract",
    "deuce",
    "devalue",
    "deviancy",
    "deviant",
    "deviate",
    "deviation",
    "deviator",
    "device",
    "devious",
    "devotedly",
    "devotee",
    "devotion",
    "devourer",
    "devouring",
    "devoutly",
    "dexterity",
    "dexterous",
    "diabetes",
    "diabetic",
    "diabolic",
    "diagnoses",
    "diagnosis",
    "diagram",
    "dial",
    "diameter",
    "diaper",
    "diaphragm",
    "diary",
    "dice",
    "dicing",
    "dictate",
    "dictation",
    "dictator",
    "difficult",
    "diffused",
    "diffuser",
    "diffusion",
    "diffusive",
    "dig",
    "dilation",
    "diligence",
    "diligent",
    "dill",
    "dilute",
    "dime",
    "diminish",
    "dimly",
    "dimmed",
    "dimmer",
    "dimness",
    "dimple",
    "diner",
    "dingbat",
    "dinghy",
    "dinginess",
    "dingo",
    "dingy",
    "dining",
    "dinner",
    "diocese",
    "dioxide",
    "diploma",
    "dipped",
    "dipper",
    "dipping",
    "directed",
    "direction",
    "directive",
    "directly",
    "directory",
    "direness",
    "dirtiness",
    "disabled",
    "disagree",
    "disallow",
    "disarm",
    "disarray",
    "disaster",
    "disband",
    "disbelief",
    "disburse",
    "discard",
    "discern",
    "discharge",
    "disclose",
    "discolor",
    "discount",
    "discourse",
    "discover",
    "discuss",
    "disdain",
    "disengage",
    "disfigure",
    "disgrace",
    "dish",
    "disinfect",
    "disjoin",
    "disk",
    "dislike",
    "disliking",
    "dislocate",
    "dislodge",
    "disloyal",
    "dismantle",
    "dismay",
    "dismiss",
    "dismount",
    "disobey",
    "disorder",
    "disown",
    "disparate",
    "disparity",
    "dispatch",
    "dispense",
    "dispersal",
    "dispersed",
    "disperser",
    "displace",
    "display",
    "displease",
    "disposal",
    "dispose",
    "disprove",
    "dispute",
    "disregard",
    "disrupt",
    "dissuade",
    "distance",
    "distant",
    "distaste",
    "distill",
    "distinct",
    "distort",
    "distract",
    "distress",
    "district",
    "distrust",
    "ditch",
    "ditto",
    "ditzy",
    "dividable",
    "divided",
    "dividend",
    "dividers",
    "dividing",
    "divinely",
    "diving",
    "divinity",
    "divisible",
    "divisibly",
    "division",
    "divisive",
    "divorcee",
    "dizziness",
    "dizzy",
    "doable",
    "docile",
    "dock",
    "doctrine",
    "document",
    "dodge",
    "dodgy",
    "doily",
    "doing",
    "dole",
    "dollar",
    "dollhouse",
    "dollop",
    "dolly",
    "dolphin",
    "domain",
    "domelike",
    "domestic",
    "dominion",
    "dominoes",
    "donated",
    "donation",
    "donator",
    "donor",
    "donut",
    "doodle",
    "doorbell",
    "doorframe",
    "doorknob",
    "doorman",
    "doormat",
    "doornail",
    "doorpost",
    "doorstep",
    "doorstop",
    "doorway",
    "doozy",
    "dork",
    "dormitory",
    "dorsal",
    "dosage",
    "dose",
    "dotted",
    "doubling",
    "douche",
    "dove",
    "down",
    "dowry",
    "doze",
    "drab",
    "dragging",
    "dragonfly",
    "dragonish",
    "dragster",
    "drainable",
    "drainage",
    "drained",
    "drainer",
    "drainpipe",
    "dramatic",
    "dramatize",
    "drank",
    "drapery",
    "drastic",
    "draw",
    "dreaded",
    "dreadful",
    "dreadlock",
    "dreamboat",
    "dreamily",
    "dreamland",
    "dreamless",
    "dreamlike",
    "dreamt",
    "dreamy",
    "drearily",
    "dreary",
    "drench",
    "dress",
    "drew",
    "dribble",
    "dried",
    "drier",
    "drift",
    "driller",
    "drilling",
    "drinkable",
    "drinking",
    "dripping",
    "drippy",
    "drivable",
    "driven",
    "driver",
    "driveway",
    "driving",
    "drizzle",
    "drizzly",
    "drone",
    "drool",
    "droop",
    "drop-down",
    "dropbox",
    "dropkick",
    "droplet",
    "dropout",
    "dropper",
    "drove",
    "drown",
    "drowsily",
    "drudge",
    "drum",
    "dry",
    "dubbed",
    "dubiously",
    "duchess",
    "duckbill",
    "ducking",
    "duckling",
    "ducktail",
    "ducky",
    "duct",
    "dude",
    "duffel",
    "dugout",
    "duh",
    "duke",
    "duller",
    "dullness",
    "duly",
    "dumping",
    "dumpling",
    "dumpster",
    "duo",
    "dupe",
    "duplex",
    "duplicate",
    "duplicity",
    "durable",
    "durably",
    "duration",
    "duress",
    "during",
    "dusk",
    "dust",
    "dutiful",
    "duty",
    "duvet",
    "dwarf",
    "dweeb",
    "dwelled",
    "dweller",
    "dwelling",
    "dwindle",
    "dwindling",
    "dynamic",
    "dynamite",
    "dynasty",
    "dyslexia",
    "dyslexic",
    "each",
    "eagle",
    "earache",
    "eardrum",
    "earflap",
    "earful",
    "earlobe",
    "early",
    "earmark",
    "earmuff",
    "earphone",
    "earpiece",
    "earplugs",
    "earring",
    "earshot",
    "earthen",
    "earthlike",
    "earthling",
    "earthly",
    "earthworm",
    "earthy",
    "earwig",
    "easeful",
    "easel",
    "easiest",
    "easily",
    "easiness",
    "easing",
    "eastbound",
    "eastcoast",
    "easter",
    "eastward",
    "eatable",
    "eaten",
    "eatery",
    "eating",
    "eats",
    "ebay",
    "ebony",
    "ebook",
    "ecard",
    "eccentric",
    "echo",
    "eclair",
    "eclipse",
    "ecologist",
    "ecology",
    "economic",
    "economist",
    "economy",
    "ecosphere",
    "ecosystem",
    "edge",
    "edginess",
    "edging",
    "edgy",
    "edition",
    "editor",
    "educated",
    "education",
    "educator",
    "eel",
    "effective",
    "effects",
    "efficient",
    "effort",
    "eggbeater",
    "egging",
    "eggnog",
    "eggplant",
    "eggshell",
    "egomaniac",
    "egotism",
    "egotistic",
    "either",
    "eject",
    "elaborate",
    "elastic",
    "elated",
    "elbow",
    "eldercare",
    "elderly",
    "eldest",
    "electable",
    "election",
    "elective",
    "elephant",
    "elevate",
    "elevating",
    "elevation",
    "elevator",
    "eleven",
    "elf",
    "eligible",
    "eligibly",
    "eliminate",
    "elite",
    "elitism",
    "elixir",
    "elk",
    "ellipse",
    "elliptic",
    "elm",
    "elongated",
    "elope",
    "eloquence",
    "eloquent",
    "elsewhere",
    "elude",
    "elusive",
    "elves",
    "email",
    "embargo",
    "embark",
    "embassy",
    "embattled",
    "embellish",
    "ember",
    "embezzle",
    "emblaze",
    "emblem",
    "embody",
    "embolism",
    "emboss",
    "embroider",
    "emcee",
    "emerald",
    "emergency",
    "emission",
    "emit",
    "emote",
    "emoticon",
    "emotion",
    "empathic",
    "empathy",
    "emperor",
    "emphases",
    "emphasis",
    "emphasize",
    "emphatic",
    "empirical",
    "employed",
    "employee",
    "employer",
    "emporium",
    "empower",
    "emptier",
    "emptiness",
    "empty",
    "emu",
    "enable",
    "enactment",
    "enamel",
    "enchanted",
    "enchilada",
    "encircle",
    "enclose",
    "enclosure",
    "encode",
    "encore",
    "encounter",
    "encourage",
    "encroach",
    "encrust",
    "encrypt",
    "endanger",
    "endeared",
    "endearing",
    "ended",
    "ending",
    "endless",
    "endnote",
    "endocrine",
    "endorphin",
    "endorse",
    "endowment",
    "endpoint",
    "endurable",
    "endurance",
    "enduring",
    "energetic",
    "energize",
    "energy",
    "enforced",
    "enforcer",
    "engaged",
    "engaging",
    "engine",
    "engorge",
    "engraved",
    "engraver",
    "engraving",
    "engross",
    "engulf",
    "enhance",
    "enigmatic",
    "enjoyable",
    "enjoyably",
    "enjoyer",
    "enjoying",
    "enjoyment",
    "enlarged",
    "enlarging",
    "enlighten",
    "enlisted",
    "enquirer",
    "enrage",
    "enrich",
    "enroll",
    "enslave",
    "ensnare",
    "ensure",
    "entail",
    "entangled",
    "entering",
    "entertain",
    "enticing",
    "entire",
    "entitle",
    "entity",
    "entomb",
    "entourage",
    "entrap",
    "entree",
    "entrench",
    "entrust",
    "entryway",
    "entwine",
    "enunciate",
    "envelope",
    "enviable",
    "enviably",
    "envious",
    "envision",
    "envoy",
    "envy",
    "enzyme",
    "epic",
    "epidemic",
    "epidermal",
    "epidermis",
    "epidural",
    "epilepsy",
    "epileptic",
    "epilogue",
    "epiphany",
    "episode",
    "equal",
    "equate",
    "equation",
    "equator",
    "equinox",
    "equipment",
    "equity",
    "equivocal",
    "eradicate",
    "erasable",
    "erased",
    "eraser",
    "erasure",
    "ergonomic",
    "errand",
    "errant",
    "erratic",
    "error",
    "erupt",
    "escalate",
    "escalator",
    "escapable",
    "escapade",
    "escapist",
    "escargot",
    "eskimo",
    "esophagus",
    "espionage",
    "espresso",
    "esquire",
    "essay",
    "essence",
    "essential",
    "establish",
    "estate",
    "esteemed",
    "estimate",
    "estimator",
    "estranged",
    "estrogen",
    "etching",
    "eternal",
    "eternity",
    "ethanol",
    "ether",
    "ethically",
    "ethics",
    "euphemism",
    "evacuate",
    "evacuee",
    "evade",
    "evaluate",
    "evaluator",
    "evaporate",
    "evasion",
    "evasive",
    "even",
    "everglade",
    "evergreen",
    "everybody",
    "everyday",
    "everyone",
    "evict",
    "evidence",
    "evident",
    "evil",
    "evoke",
    "evolution",
    "evolve",
    "exact",
    "exalted",
    "example",
    "excavate",
    "excavator",
    "exceeding",
    "exception",
    "excess",
    "exchange",
    "excitable",
    "exciting",
    "exclaim",
    "exclude",
    "excluding",
    "exclusion",
    "exclusive",
    "excretion",
    "excretory",
    "excursion",
    "excusable",
    "excusably",
    "excuse",
    "exemplary",
    "exemplify",
    "exemption",
    "exerciser",
    "exert",
    "exes",
    "exfoliate",
    "exhale",
    "exhaust",
    "exhume",
    "exile",
    "existing",
    "exit",
    "exodus",
    "exonerate",
    "exorcism",
    "exorcist",
    "expand",
    "expanse",
    "expansion",
    "expansive",
    "expectant",
    "expedited",
    "expediter",
    "expel",
    "expend",
    "expenses",
    "expensive",
    "expert",
    "expire",
    "expiring",
    "explain",
    "expletive",
    "explicit",
    "explode",
    "exploit",
    "explore",
    "exploring",
    "exponent",
    "exporter",
    "exposable",
    "expose",
    "exposure",
    "express",
    "expulsion",
    "exquisite",
    "extended",
    "extending",
    "extent",
    "extenuate",
    "exterior",
    "external",
    "extinct",
    "extortion",
    "extradite",
    "extras",
    "extrovert",
    "extrude",
    "extruding",
    "exuberant",
    "fable",
    "fabric",
    "fabulous",
    "facebook",
    "facecloth",
    "facedown",
    "faceless",
    "facelift",
    "faceplate",
    "faceted",
    "facial",
    "facility",
    "facing",
    "facsimile",
    "faction",
    "factoid",
    "factor",
    "factsheet",
    "factual",
    "faculty",
    "fade",
    "fading",
    "failing",
    "falcon",
    "fall",
    "false",
    "falsify",
    "fame",
    "familiar",
    "family",
    "famine",
    "famished",
    "fanatic",
    "fancied",
    "fanciness",
    "fancy",
    "fanfare",
    "fang",
    "fanning",
    "fantasize",
    "fantastic",
    "fantasy",
    "fascism",
    "fastball",
    "faster",
    "fasting",
    "fastness",
    "faucet",
    "favorable",
    "favorably",
    "favored",
    "favoring",
    "favorite",
    "fax",
    "feast",
    "federal",
    "fedora",
    "feeble",
    "feed",
    "feel",
    "feisty",
    "feline",
    "felt-tip",
    "feminine",
    "feminism",
    "feminist",
    "feminize",
    "femur",
    "fence",
    "fencing",
    "fender",
    "ferment",
    "fernlike",
    "ferocious",
    "ferocity",
    "ferret",
    "ferris",
    "ferry",
    "fervor",
    "fester",
    "festival",
    "festive",
    "festivity",
    "fetal",
    "fetch",
    "fever",
    "fiber",
    "fiction",
    "fiddle",
    "fiddling",
    "fidelity",
    "fidgeting",
    "fidgety",
    "fifteen",
    "fifth",
    "fiftieth",
    "fifty",
    "figment",
    "figure",
    "figurine",
    "filing",
    "filled",
    "filler",
    "filling",
    "film",
    "filter",
    "filth",
    "filtrate",
    "finale",
    "finalist",
    "finalize",
    "finally",
    "finance",
    "financial",
    "finch",
    "fineness",
    "finer",
    "finicky",
    "finished",
    "finisher",
    "finishing",
    "finite",
    "finless",
    "finlike",
    "fiscally",
    "fit",
    "five",
    "flaccid",
    "flagman",
    "flagpole",
    "flagship",
    "flagstick",
    "flagstone",
    "flail",
    "flakily",
    "flaky",
    "flame",
    "flammable",
    "flanked",
    "flanking",
    "flannels",
    "flap",
    "flaring",
    "flashback",
    "flashbulb",
    "flashcard",
    "flashily",
    "flashing",
    "flashy",
    "flask",
    "flatbed",
    "flatfoot",
    "flatly",
    "flatness",
    "flatten",
    "flattered",
    "flatterer",
    "flattery",
    "flattop",
    "flatware",
    "flatworm",
    "flavored",
    "flavorful",
    "flavoring",
    "flaxseed",
    "fled",
    "fleshed",
    "fleshy",
    "flick",
    "flier",
    "flight",
    "flinch",
    "fling",
    "flint",
    "flip",
    "flirt",
    "float",
    "flock",
    "flogging",
    "flop",
    "floral",
    "florist",
    "floss",
    "flounder",
    "flyable",
    "flyaway",
    "flyer",
    "flying",
    "flyover",
    "flypaper",
    "foam",
    "foe",
    "fog",
    "foil",
    "folic",
    "folk",
    "follicle",
    "follow",
    "fondling",
    "fondly",
    "fondness",
    "fondue",
    "font",
    "food",
    "fool",
    "footage",
    "football",
    "footbath",
    "footboard",
    "footer",
    "footgear",
    "foothill",
    "foothold",
    "footing",
    "footless",
    "footman",
    "footnote",
    "footpad",
    "footpath",
    "footprint",
    "footrest",
    "footsie",
    "footsore",
    "footwear",
    "footwork",
    "fossil",
    "foster",
    "founder",
    "founding",
    "fountain",
    "fox",
    "foyer",
    "fraction",
    "fracture",
    "fragile",
    "fragility",
    "fragment",
    "fragrance",
    "fragrant",
    "frail",
    "frame",
    "framing",
    "frantic",
    "fraternal",
    "frayed",
    "fraying",
    "frays",
    "freckled",
    "freckles",
    "freebase",
    "freebee",
    "freebie",
    "freedom",
    "freefall",
    "freehand",
    "freeing",
    "freeload",
    "freely",
    "freemason",
    "freeness",
    "freestyle",
    "freeware",
    "freeway",
    "freewill",
    "freezable",
    "freezing",
    "freight",
    "french",
    "frenzied",
    "frenzy",
    "frequency",
    "frequent",
    "fresh",
    "fretful",
    "fretted",
    "friction",
    "friday",
    "fridge",
    "fried",
    "friend",
    "frighten",
    "frightful",
    "frigidity",
    "frigidly",
    "frill",
    "fringe",
    "frisbee",
    "frisk",
    "fritter",
    "frivolous",
    "frolic",
    "from",
    "front",
    "frostbite",
    "frosted",
    "frostily",
    "frosting",
    "frostlike",
    "frosty",
    "froth",
    "frown",
    "frozen",
    "fructose",
    "frugality",
    "frugally",
    "fruit",
    "frustrate",
    "frying",
    "gab",
    "gaffe",
    "gag",
    "gainfully",
    "gaining",
    "gains",
    "gala",
    "gallantly",
    "galleria",
    "gallery",
    "galley",
    "gallon",
    "gallows",
    "gallstone",
    "galore",
    "galvanize",
    "gambling",
    "game",
    "gaming",
    "gamma",
    "gander",
    "gangly",
    "gangrene",
    "gangway",
    "gap",
    "garage",
    "garbage",
    "garden",
    "gargle",
    "garland",
    "garlic",
    "garment",
    "garnet",
    "garnish",
    "garter",
    "gas",
    "gatherer",
    "gathering",
    "gating",
    "gauging",
    "gauntlet",
    "gauze",
    "gave",
    "gawk",
    "gazing",
    "gear",
    "gecko",
    "geek",
    "geiger",
    "gem",
    "gender",
    "generic",
    "generous",
    "genetics",
    "genre",
    "gentile",
    "gentleman",
    "gently",
    "gents",
    "geography",
    "geologic",
    "geologist",
    "geology",
    "geometric",
    "geometry",
    "geranium",
    "gerbil",
    "geriatric",
    "germicide",
    "germinate",
    "germless",
    "germproof",
    "gestate",
    "gestation",
    "gesture",
    "getaway",
    "getting",
    "getup",
    "giant",
    "gibberish",
    "giblet",
    "giddily",
    "giddiness",
    "giddy",
    "gift",
    "gigabyte",
    "gigahertz",
    "gigantic",
    "giggle",
    "giggling",
    "giggly",
    "gigolo",
    "gilled",
    "gills",
    "gimmick",
    "girdle",
    "giveaway",
    "given",
    "giver",
    "giving",
    "gizmo",
    "gizzard",
    "glacial",
    "glacier",
    "glade",
    "gladiator",
    "gladly",
    "glamorous",
    "glamour",
    "glance",
    "glancing",
    "glandular",
    "glare",
    "glaring",
    "glass",
    "glaucoma",
    "glazing",
    "gleaming",
    "gleeful",
    "glider",
    "gliding",
    "glimmer",
    "glimpse",
    "glisten",
    "glitch",
    "glitter",
    "glitzy",
    "gloater",
    "gloating",
    "gloomily",
    "gloomy",
    "glorified",
    "glorifier",
    "glorify",
    "glorious",
    "glory",
    "gloss",
    "glove",
    "glowing",
    "glowworm",
    "glucose",
    "glue",
    "gluten",
    "glutinous",
    "glutton",
    "gnarly",
    "gnat",
    "goal",
    "goatskin",
    "goes",
    "goggles",
    "going",
    "goldfish",
    "goldmine",
    "goldsmith",
    "golf",
    "goliath",
    "gonad",
    "gondola",
    "gone",
    "gong",
    "good",
    "gooey",
    "goofball",
    "goofiness",
    "goofy",
    "google",
    "goon",
    "gopher",
    "gore",
    "gorged",
    "gorgeous",
    "gory",
    "gosling",
    "gossip",
    "gothic",
    "gotten",
    "gout",
    "gown",
    "grab",
    "graceful",
    "graceless",
    "gracious",
    "gradation",
    "graded",
    "grader",
    "gradient",
    "grading",
    "gradually",
    "graduate",
    "graffiti",
    "grafted",
    "grafting",
    "grain",
    "granddad",
    "grandkid",
    "grandly",
    "grandma",
    "grandpa",
    "grandson",
    "granite",
    "granny",
    "granola",
    "grant",
    "granular",
    "grape",
    "graph",
    "grapple",
    "grappling",
    "grasp",
    "grass",
    "gratified",
    "gratify",
    "grating",
    "gratitude",
    "gratuity",
    "gravel",
    "graveness",
    "graves",
    "graveyard",
    "gravitate",
    "gravity",
    "gravy",
    "gray",
    "grazing",
    "greasily",
    "greedily",
    "greedless",
    "greedy",
    "green",
    "greeter",
    "greeting",
    "grew",
    "greyhound",
    "grid",
    "grief",
    "grievance",
    "grieving",
    "grievous",
    "grill",
    "grimace",
    "grimacing",
    "grime",
    "griminess",
    "grimy",
    "grinch",
    "grinning",
    "grip",
    "gristle",
    "grit",
    "groggily",
    "groggy",
    "groin",
    "groom",
    "groove",
    "grooving",
    "groovy",
    "grope",
    "ground",
    "grouped",
    "grout",
    "grove",
    "grower",
    "growing",
    "growl",
    "grub",
    "grudge",
    "grudging",
    "grueling",
    "gruffly",
    "grumble",
    "grumbling",
    "grumbly",
    "grumpily",
    "grunge",
    "grunt",
    "guacamole",
    "guidable",
    "guidance",
    "guide",
    "guiding",
    "guileless",
    "guise",
    "gulf",
    "gullible",
    "gully",
    "gulp",
    "gumball",
    "gumdrop",
    "gumminess",
    "gumming",
    "gummy",
    "gurgle",
    "gurgling",
    "guru",
    "gush",
    "gusto",
    "gusty",
    "gutless",
    "guts",
    "gutter",
    "guy",
    "guzzler",
    "gyration",
    "habitable",
    "habitant",
    "habitat",
    "habitual",
    "hacked",
    "hacker",
    "hacking",
    "hacksaw",
    "had",
    "haggler",
    "haiku",
    "half",
    "halogen",
    "halt",
    "halved",
    "halves",
    "hamburger",
    "hamlet",
    "hammock",
    "hamper",
    "hamster",
    "hamstring",
    "handbag",
    "handball",
    "handbook",
    "handbrake",
    "handcart",
    "handclap",
    "handclasp",
    "handcraft",
    "handcuff",
    "handed",
    "handful",
    "handgrip",
    "handgun",
    "handheld",
    "handiness",
    "handiwork",
    "handlebar",
    "handled",
    "handler",
    "handling",
    "handmade",
    "handoff",
    "handpick",
    "handprint",
    "handrail",
    "handsaw",
    "handset",
    "handsfree",
    "handshake",
    "handstand",
    "handwash",
    "handwork",
    "handwoven",
    "handwrite",
    "handyman",
    "hangnail",
    "hangout",
    "hangover",
    "hangup",
    "hankering",
    "hankie",
    "hanky",
    "haphazard",
    "happening",
    "happier",
    "happiest",
    "happily",
    "happiness",
    "happy",
    "harbor",
    "hardcopy",
    "hardcore",
    "hardcover",
    "harddisk",
    "hardened",
    "hardener",
    "hardening",
    "hardhat",
    "hardhead",
    "hardiness",
    "hardly",
    "hardness",
    "hardship",
    "hardware",
    "hardwired",
    "hardwood",
    "hardy",
    "harmful",
    "harmless",
    "harmonica",
    "harmonics",
    "harmonize",
    "harmony",
    "harness",
    "harpist",
    "harsh",
    "harvest",
    "hash",
    "hassle",
    "haste",
    "hastily",
    "hastiness",
    "hasty",
    "hatbox",
    "hatchback",
    "hatchery",
    "hatchet",
    "hatching",
    "hatchling",
    "hate",
    "hatless",
    "hatred",
    "haunt",
    "haven",
    "hazard",
    "hazelnut",
    "hazily",
    "haziness",
    "hazing",
    "hazy",
    "headache",
    "headband",
    "headboard",
    "headcount",
    "headdress",
    "headed",
    "header",
    "headfirst",
    "headgear",
    "heading",
    "headlamp",
    "headless",
    "headlock",
    "headphone",
    "headpiece",
    "headrest",
    "headroom",
    "headscarf",
    "headset",
    "headsman",
    "headstand",
    "headstone",
    "headway",
    "headwear",
    "heap",
    "heat",
    "heave",
    "heavily",
    "heaviness",
    "heaving",
    "hedge",
    "hedging",
    "heftiness",
    "hefty",
    "helium",
    "helmet",
    "helper",
    "helpful",
    "helping",
    "helpless",
    "helpline",
    "hemlock",
    "hemstitch",
    "hence",
    "henchman",
    "henna",
    "herald",
    "herbal",
    "herbicide",
    "herbs",
    "heritage",
    "hermit",
    "heroics",
    "heroism",
    "herring",
    "herself",
    "hertz",
    "hesitancy",
    "hesitant",
    "hesitate",
    "hexagon",
    "hexagram",
    "hubcap",
    "huddle",
    "huddling",
    "huff",
    "hug",
    "hula",
    "hulk",
    "hull",
    "human",
    "humble",
    "humbling",
    "humbly",
    "humid",
    "humiliate",
    "humility",
    "humming",
    "hummus",
    "humongous",
    "humorist",
    "humorless",
    "humorous",
    "humpback",
    "humped",
    "humvee",
    "hunchback",
    "hundredth",
    "hunger",
    "hungrily",
    "hungry",
    "hunk",
    "hunter",
    "hunting",
    "huntress",
    "huntsman",
    "hurdle",
    "hurled",
    "hurler",
    "hurling",
    "hurray",
    "hurricane",
    "hurried",
    "hurry",
    "hurt",
    "husband",
    "hush",
    "husked",
    "huskiness",
    "hut",
    "hybrid",
    "hydrant",
    "hydrated",
    "hydration",
    "hydrogen",
    "hydroxide",
    "hyperlink",
    "hypertext",
    "hyphen",
    "hypnoses",
    "hypnosis",
    "hypnotic",
    "hypnotism",
    "hypnotist",
    "hypnotize",
    "hypocrisy",
    "hypocrite",
    "ibuprofen",
    "ice",
    "iciness",
    "icing",
    "icky",
    "icon",
    "icy",
    "idealism",
    "idealist",
    "idealize",
    "ideally",
    "idealness",
    "identical",
    "identify",
    "identity",
    "ideology",
    "idiocy",
    "idiom",
    "idly",
    "igloo",
    "ignition",
    "ignore",
    "iguana",
    "illicitly",
    "illusion",
    "illusive",
    "image",
    "imaginary",
    "imagines",
    "imaging",
    "imbecile",
    "imitate",
    "imitation",
    "immature",
    "immerse",
    "immersion",
    "imminent",
    "immobile",
    "immodest",
    "immorally",
    "immortal",
    "immovable",
    "immovably",
    "immunity",
    "immunize",
    "impaired",
    "impale",
    "impart",
    "impatient",
    "impeach",
    "impeding",
    "impending",
    "imperfect",
    "imperial",
    "impish",
    "implant",
    "implement",
    "implicate",
    "implicit",
    "implode",
    "implosion",
    "implosive",
    "imply",
    "impolite",
    "important",
    "importer",
    "impose",
    "imposing",
    "impotence",
    "impotency",
    "impotent",
    "impound",
    "imprecise",
    "imprint",
    "imprison",
    "impromptu",
    "improper",
    "improve",
    "improving",
    "improvise",
    "imprudent",
    "impulse",
    "impulsive",
    "impure",
    "impurity",
    "iodine",
    "iodize",
    "ion",
    "ipad",
    "iphone",
    "ipod",
    "irate",
    "irk",
    "iron",
    "irregular",
    "irrigate",
    "irritable",
    "irritably",
    "irritant",
    "irritate",
    "islamic",
    "islamist",
    "isolated",
    "isolating",
    "isolation",
    "isotope",
    "issue",
    "issuing",
    "italicize",
    "italics",
    "item",
    "itinerary",
    "itunes",
    "ivory",
    "ivy",
    "jab",
    "jackal",
    "jacket",
    "jackknife",
    "jackpot",
    "jailbird",
    "jailbreak",
    "jailer",
    "jailhouse",
    "jalapeno",
    "jam",
    "janitor",
    "january",
    "jargon",
    "jarring",
    "jasmine",
    "jaundice",
    "jaunt",
    "java",
    "jawed",
    "jawless",
    "jawline",
    "jaws",
    "jaybird",
    "jaywalker",
    "jazz",
    "jeep",
    "jeeringly",
    "jellied",
    "jelly",
    "jersey",
    "jester",
    "jet",
    "jiffy",
    "jigsaw",
    "jimmy",
    "jingle",
    "jingling",
    "jinx",
    "jitters",
    "jittery",
    "job",
    "jockey",
    "jockstrap",
    "jogger",
    "jogging",
    "john",
    "joining",
    "jokester",
    "jokingly",
    "jolliness",
    "jolly",
    "jolt",
    "jot",
    "jovial",
    "joyfully",
    "joylessly",
    "joyous",
    "joyride",
    "joystick",
    "jubilance",
    "jubilant",
    "judge",
    "judgingly",
    "judicial",
    "judiciary",
    "judo",
    "juggle",
    "juggling",
    "jugular",
    "juice",
    "juiciness",
    "juicy",
    "jujitsu",
    "jukebox",
    "july",
    "jumble",
    "jumbo",
    "jump",
    "junction",
    "juncture",
    "june",
    "junior",
    "juniper",
    "junkie",
    "junkman",
    "junkyard",
    "jurist",
    "juror",
    "jury",
    "justice",
    "justifier",
    "justify",
    "justly",
    "justness",
    "juvenile",
    "kabob",
    "kangaroo",
    "karaoke",
    "karate",
    "karma",
    "kebab",
    "keenly",
    "keenness",
    "keep",
    "keg",
    "kelp",
    "kennel",
    "kept",
    "kerchief",
    "kerosene",
    "kettle",
    "kick",
    "kiln",
    "kilobyte",
    "kilogram",
    "kilometer",
    "kilowatt",
    "kilt",
    "kimono",
    "kindle",
    "kindling",
    "kindly",
    "kindness",
    "kindred",
    "kinetic",
    "kinfolk",
    "king",
    "kinship",
    "kinsman",
    "kinswoman",
    "kissable",
    "kisser",
    "kissing",
    "kitchen",
    "kite",
    "kitten",
    "kitty",
    "kiwi",
    "kleenex",
    "knapsack",
    "knee",
    "knelt",
    "knickers",
    "knoll",
    "koala",
    "kooky",
    "kosher",
    "krypton",
    "kudos",
    "kung",
    "labored",
    "laborer",
    "laboring",
    "laborious",
    "labrador",
    "ladder",
    "ladies",
    "ladle",
    "ladybug",
    "ladylike",
    "lagged",
    "lagging",
    "lagoon",
    "lair",
    "lake",
    "lance",
    "landed",
    "landfall",
    "landfill",
    "landing",
    "landlady",
    "landless",
    "landline",
    "landlord",
    "landmark",
    "landmass",
    "landmine",
    "landowner",
    "landscape",
    "landside",
    "landslide",
    "language",
    "lankiness",
    "lanky",
    "lantern",
    "lapdog",
    "lapel",
    "lapped",
    "lapping",
    "laptop",
    "lard",
    "large",
    "lark",
    "lash",
    "lasso",
    "last",
    "latch",
    "late",
    "lather",
    "latitude",
    "latrine",
    "latter",
    "latticed",
    "launch",
    "launder",
    "laundry",
    "laurel",
    "lavender",
    "lavish",
    "laxative",
    "lazily",
    "laziness",
    "lazy",
    "lecturer",
    "left",
    "legacy",
    "legal",
    "legend",
    "legged",
    "leggings",
    "legible",
    "legibly",
    "legislate",
    "lego",
    "legroom",
    "legume",
    "legwarmer",
    "legwork",
    "lemon",
    "lend",
    "length",
    "lens",
    "lent",
    "leotard",
    "lesser",
    "letdown",
    "lethargic",
    "lethargy",
    "letter",
    "lettuce",
    "level",
    "leverage",
    "levers",
    "levitate",
    "levitator",
    "liability",
    "liable",
    "liberty",
    "librarian",
    "library",
    "licking",
    "licorice",
    "lid",
    "life",
    "lifter",
    "lifting",
    "liftoff",
    "ligament",
    "likely",
    "likeness",
    "likewise",
    "liking",
    "lilac",
    "lilly",
    "lily",
    "limb",
    "limeade",
    "limelight",
    "limes",
    "limit",
    "limping",
    "limpness",
    "line",
    "lingo",
    "linguini",
    "linguist",
    "lining",
    "linked",
    "linoleum",
    "linseed",
    "lint",
    "lion",
    "lip",
    "liquefy",
    "liqueur",
    "liquid",
    "lisp",
    "list",
    "litigate",
    "litigator",
    "litmus",
    "litter",
    "little",
    "livable",
    "lived",
    "lively",
    "liver",
    "livestock",
    "lividly",
    "living",
    "lizard",
    "lubricant",
    "lubricate",
    "lucid",
    "luckily",
    "luckiness",
    "luckless",
    "lucrative",
    "ludicrous",
    "lugged",
    "lukewarm",
    "lullaby",
    "lumber",
    "luminance",
    "luminous",
    "lumpiness",
    "lumping",
    "lumpish",
    "lunacy",
    "lunar",
    "lunchbox",
    "luncheon",
    "lunchroom",
    "lunchtime",
    "lung",
    "lurch",
    "lure",
    "luridness",
    "lurk",
    "lushly",
    "lushness",
    "luster",
    "lustfully",
    "lustily",
    "lustiness",
    "lustrous",
    "lusty",
    "luxurious",
    "luxury",
    "lying",
    "lyrically",
    "lyricism",
    "lyricist",
    "lyrics",
    "macarena",
    "macaroni",
    "macaw",
    "mace",
    "machine",
    "machinist",
    "magazine",
    "magenta",
    "maggot",
    "magical",
    "magician",
    "magma",
    "magnesium",
    "magnetic",
    "magnetism",
    "magnetize",
    "magnifier",
    "magnify",
    "magnitude",
    "magnolia",
    "mahogany",
    "maimed",
    "majestic",
    "majesty",
    "majorette",
    "majority",
    "makeover",
    "maker",
    "makeshift",
    "making",
    "malformed",
    "malt",
    "mama",
    "mammal",
    "mammary",
    "mammogram",
    "manager",
    "managing",
    "manatee",
    "mandarin",
    "mandate",
    "mandatory",
    "mandolin",
    "manger",
    "mangle",
    "mango",
    "mangy",
    "manhandle",
    "manhole",
    "manhood",
    "manhunt",
    "manicotti",
    "manicure",
    "manifesto",
    "manila",
    "mankind",
    "manlike",
    "manliness",
    "manly",
    "manmade",
    "manned",
    "mannish",
    "manor",
    "manpower",
    "mantis",
    "mantra",
    "manual",
    "many",
    "map",
    "marathon",
    "marauding",
    "marbled",
    "marbles",
    "marbling",
    "march",
    "mardi",
    "margarine",
    "margarita",
    "margin",
    "marigold",
    "marina",
    "marine",
    "marital",
    "maritime",
    "marlin",
    "marmalade",
    "maroon",
    "married",
    "marrow",
    "marry",
    "marshland",
    "marshy",
    "marsupial",
    "marvelous",
    "marxism",
    "mascot",
    "masculine",
    "mashed",
    "mashing",
    "massager",
    "masses",
    "massive",
    "mastiff",
    "matador",
    "matchbook",
    "matchbox",
    "matcher",
    "matching",
    "matchless",
    "material",
    "maternal",
    "maternity",
    "math",
    "mating",
    "matriarch",
    "matrimony",
    "matrix",
    "matron",
    "matted",
    "matter",
    "maturely",
    "maturing",
    "maturity",
    "mauve",
    "maverick",
    "maximize",
    "maximum",
    "maybe",
    "mayday",
    "mayflower",
    "moaner",
    "moaning",
    "mobile",
    "mobility",
    "mobilize",
    "mobster",
    "mocha",
    "mocker",
    "mockup",
    "modified",
    "modify",
    "modular",
    "modulator",
    "module",
    "moisten",
    "moistness",
    "moisture",
    "molar",
    "molasses",
    "mold",
    "molecular",
    "molecule",
    "molehill",
    "mollusk",
    "mom",
    "monastery",
    "monday",
    "monetary",
    "monetize",
    "moneybags",
    "moneyless",
    "moneywise",
    "mongoose",
    "mongrel",
    "monitor",
    "monkhood",
    "monogamy",
    "monogram",
    "monologue",
    "monopoly",
    "monorail",
    "monotone",
    "monotype",
    "monoxide",
    "monsieur",
    "monsoon",
    "monstrous",
    "monthly",
    "monument",
    "moocher",
    "moodiness",
    "moody",
    "mooing",
    "moonbeam",
    "mooned",
    "moonlight",
    "moonlike",
    "moonlit",
    "moonrise",
    "moonscape",
    "moonshine",
    "moonstone",
    "moonwalk",
    "mop",
    "morale",
    "morality",
    "morally",
    "morbidity",
    "morbidly",
    "morphine",
    "morphing",
    "morse",
    "mortality",
    "mortally",
    "mortician",
    "mortified",
    "mortify",
    "mortuary",
    "mosaic",
    "mossy",
    "most",
    "mothball",
    "mothproof",
    "motion",
    "motivate",
    "motivator",
    "motive",
    "motocross",
    "motor",
    "motto",
    "mountable",
    "mountain",
    "mounted",
    "mounting",
    "mourner",
    "mournful",
    "mouse",
    "mousiness",
    "moustache",
    "mousy",
    "mouth",
    "movable",
    "move",
    "movie",
    "moving",
    "mower",
    "mowing",
    "much",
    "muck",
    "mud",
    "mug",
    "mulberry",
    "mulch",
    "mule",
    "mulled",
    "mullets",
    "multiple",
    "multiply",
    "multitask",
    "multitude",
    "mumble",
    "mumbling",
    "mumbo",
    "mummified",
    "mummify",
    "mummy",
    "mumps",
    "munchkin",
    "mundane",
    "municipal",
    "muppet",
    "mural",
    "murkiness",
    "murky",
    "murmuring",
    "muscular",
    "museum",
    "mushily",
    "mushiness",
    "mushroom",
    "mushy",
    "music",
    "musket",
    "muskiness",
    "musky",
    "mustang",
    "mustard",
    "muster",
    "mustiness",
    "musty",
    "mutable",
    "mutate",
    "mutation",
    "mute",
    "mutilated",
    "mutilator",
    "mutiny",
    "mutt",
    "mutual",
    "muzzle",
    "myself",
    "myspace",
    "mystified",
    "mystify",
    "myth",
    "nacho",
    "nag",
    "nail",
    "name",
    "naming",
    "nanny",
    "nanometer",
    "nape",
    "napkin",
    "napped",
    "napping",
    "nappy",
    "narrow",
    "nastily",
    "nastiness",
    "national",
    "native",
    "nativity",
    "natural",
    "nature",
    "naturist",
    "nautical",
    "navigate",
    "navigator",
    "navy",
    "nearby",
    "nearest",
    "nearly",
    "nearness",
    "neatly",
    "neatness",
    "nebula",
    "nebulizer",
    "nectar",
    "negate",
    "negation",
    "negative",
    "neglector",
    "negligee",
    "negligent",
    "negotiate",
    "nemeses",
    "nemesis",
    "neon",
    "nephew",
    "nerd",
    "nervous",
    "nervy",
    "nest",
    "net",
    "neurology",
    "neuron",
    "neurosis",
    "neurotic",
    "neuter",
    "neutron",
    "never",
    "next",
    "nibble",
    "nickname",
    "nicotine",
    "niece",
    "nifty",
    "nimble",
    "nimbly",
    "nineteen",
    "ninetieth",
    "ninja",
    "nintendo",
    "ninth",
    "nuclear",
    "nuclei",
    "nucleus",
    "nugget",
    "nullify",
    "number",
    "numbing",
    "numbly",
    "numbness",
    "numeral",
    "numerate",
    "numerator",
    "numeric",
    "numerous",
    "nuptials",
    "nursery",
    "nursing",
    "nurture",
    "nutcase",
    "nutlike",
    "nutmeg",
    "nutrient",
    "nutshell",
    "nuttiness",
    "nutty",
    "nuzzle",
    "nylon",
    "oaf",
    "oak",
    "oasis",
    "oat",
    "obedience",
    "obedient",
    "obituary",
    "object",
    "obligate",
    "obliged",
    "oblivion",
    "oblivious",
    "oblong",
    "obnoxious",
    "oboe",
    "obscure",
    "obscurity",
    "observant",
    "observer",
    "observing",
    "obsessed",
    "obsession",
    "obsessive",
    "obsolete",
    "obstacle",
    "obstinate",
    "obstruct",
    "obtain",
    "obtrusive",
    "obtuse",
    "obvious",
    "occultist",
    "occupancy",
    "occupant",
    "occupier",
    "occupy",
    "ocean",
    "ocelot",
    "octagon",
    "octane",
    "october",
    "octopus",
    "ogle",
    "oil",
    "oink",
    "ointment",
    "okay",
    "old",
    "olive",
    "olympics",
    "omega",
    "omen",
    "ominous",
    "omission",
    "omit",
    "omnivore",
    "onboard",
    "oncoming",
    "ongoing",
    "onion",
    "online",
    "onlooker",
    "only",
    "onscreen",
    "onset",
    "onshore",
    "onslaught",
    "onstage",
    "onto",
    "onward",
    "onyx",
    "oops",
    "ooze",
    "oozy",
    "opacity",
    "opal",
    "open",
    "operable",
    "operate",
    "operating",
    "operation",
    "operative",
    "operator",
    "opium",
    "opossum",
    "opponent",
    "oppose",
    "opposing",
    "opposite",
    "oppressed",
    "oppressor",
    "opt",
    "opulently",
    "osmosis",
    "other",
    "otter",
    "ouch",
    "ought",
    "ounce",
    "outage",
    "outback",
    "outbid",
    "outboard",
    "outbound",
    "outbreak",
    "outburst",
    "outcast",
    "outclass",
    "outcome",
    "outdated",
    "outdoors",
    "outer",
    "outfield",
    "outfit",
    "outflank",
    "outgoing",
    "outgrow",
    "outhouse",
    "outing",
    "outlast",
    "outlet",
    "outline",
    "outlook",
    "outlying",
    "outmatch",
    "outmost",
    "outnumber",
    "outplayed",
    "outpost",
    "outpour",
    "output",
    "outrage",
    "outrank",
    "outreach",
    "outright",
    "outscore",
    "outsell",
    "outshine",
    "outshoot",
    "outsider",
    "outskirts",
    "outsmart",
    "outsource",
    "outspoken",
    "outtakes",
    "outthink",
    "outward",
    "outweigh",
    "outwit",
    "oval",
    "ovary",
    "oven",
    "overact",
    "overall",
    "overarch",
    "overbid",
    "overbill",
    "overbite",
    "overblown",
    "overboard",
    "overbook",
    "overbuilt",
    "overcast",
    "overcoat",
    "overcome",
    "overcook",
    "overcrowd",
    "overdraft",
    "overdrawn",
    "overdress",
    "overdrive",
    "overdue",
    "overeager",
    "overeater",
    "overexert",
    "overfed",
    "overfeed",
    "overfill",
    "overflow",
    "overfull",
    "overgrown",
    "overhand",
    "overhang",
    "overhaul",
    "overhead",
    "overhear",
    "overheat",
    "overhung",
    "overjoyed",
    "overkill",
    "overlabor",
    "overlaid",
    "overlap",
    "overlay",
    "overload",
    "overlook",
    "overlord",
    "overlying",
    "overnight",
    "overpass",
    "overpay",
    "overplant",
    "overplay",
    "overpower",
    "overprice",
    "overrate",
    "overreach",
    "overreact",
    "override",
    "overripe",
    "overrule",
    "overrun",
    "overshoot",
    "overshot",
    "oversight",
    "oversized",
    "oversleep",
    "oversold",
    "overspend",
    "overstate",
    "overstay",
    "overstep",
    "overstock",
    "overstuff",
    "oversweet",
    "overtake",
    "overthrow",
    "overtime",
    "overtly",
    "overtone",
    "overture",
    "overturn",
    "overuse",
    "overvalue",
    "overview",
    "overwrite",
    "owl",
    "oxford",
    "oxidant",
    "oxidation",
    "oxidize",
    "oxidizing",
    "oxygen",
    "oxymoron",
    "oyster",
    "ozone",
    "paced",
    "pacemaker",
    "pacific",
    "pacifier",
    "pacifism",
    "pacifist",
    "pacify",
    "padded",
    "padding",
    "paddle",
    "paddling",
    "padlock",
    "pagan",
    "pager",
    "paging",
    "pajamas",
    "palace",
    "palatable",
    "palm",
    "palpable",
    "palpitate",
    "paltry",
    "pampered",
    "pamperer",
    "pampers",
    "pamphlet",
    "panama",
    "pancake",
    "pancreas",
    "panda",
    "pandemic",
    "pang",
    "panhandle",
    "panic",
    "panning",
    "panorama",
    "panoramic",
    "panther",
    "pantomime",
    "pantry",
    "pants",
    "pantyhose",
    "paparazzi",
    "papaya",
    "paper",
    "paprika",
    "papyrus",
    "parabola",
    "parachute",
    "parade",
    "paradox",
    "paragraph",
    "parakeet",
    "paralegal",
    "paralyses",
    "paralysis",
    "paralyze",
    "paramedic",
    "parameter",
    "paramount",
    "parasail",
    "parasite",
    "parasitic",
    "parcel",
    "parched",
    "parchment",
    "pardon",
    "parish",
    "parka",
    "parking",
    "parkway",
    "parlor",
    "parmesan",
    "parole",
    "parrot",
    "parsley",
    "parsnip",
    "partake",
    "parted",
    "parting",
    "partition",
    "partly",
    "partner",
    "partridge",
    "party",
    "passable",
    "passably",
    "passage",
    "passcode",
    "passenger",
    "passerby",
    "passing",
    "passion",
    "passive",
    "passivism",
    "passover",
    "passport",
    "password",
    "pasta",
    "pasted",
    "pastel",
    "pastime",
    "pastor",
    "pastrami",
    "pasture",
    "pasty",
    "patchwork",
    "patchy",
    "paternal",
    "paternity",
    "path",
    "patience",
    "patient",
    "patio",
    "patriarch",
    "patriot",
    "patrol",
    "patronage",
    "patronize",
    "pauper",
    "pavement",
    "paver",
    "pavestone",
    "pavilion",
    "paving",
    "pawing",
    "payable",
    "payback",
    "paycheck",
    "payday",
    "payee",
    "payer",
    "paying",
    "payment",
    "payphone",
    "payroll",
    "pebble",
    "pebbly",
    "pecan",
    "pectin",
    "peculiar",
    "peddling",
    "pediatric",
    "pedicure",
    "pedigree",
    "pedometer",
    "pegboard",
    "pelican",
    "pellet",
    "pelt",
    "pelvis",
    "penalize",
    "penalty",
    "pencil",
    "pendant",
    "pending",
    "penholder",
    "penknife",
    "pennant",
    "penniless",
    "penny",
    "penpal",
    "pension",
    "pentagon",
    "pentagram",
    "pep",
    "perceive",
    "percent",
    "perch",
    "percolate",
    "perennial",
    "perfected",
    "perfectly",
    "perfume",
    "periscope",
    "perish",
    "perjurer",
    "perjury",
    "perkiness",
    "perky",
    "perm",
    "peroxide",
    "perpetual",
    "perplexed",
    "persecute",
    "persevere",
    "persuaded",
    "persuader",
    "pesky",
    "peso",
    "pessimism",
    "pessimist",
    "pester",
    "pesticide",
    "petal",
    "petite",
    "petition",
    "petri",
    "petroleum",
    "petted",
    "petticoat",
    "pettiness",
    "petty",
    "petunia",
    "phantom",
    "phobia",
    "phoenix",
    "phonebook",
    "phoney",
    "phonics",
    "phoniness",
    "phony",
    "phosphate",
    "photo",
    "phrase",
    "phrasing",
    "placard",
    "placate",
    "placidly",
    "plank",
    "planner",
    "plant",
    "plasma",
    "plaster",
    "plastic",
    "plated",
    "platform",
    "plating",
    "platinum",
    "platonic",
    "platter",
    "platypus",
    "plausible",
    "plausibly",
    "playable",
    "playback",
    "player",
    "playful",
    "playgroup",
    "playhouse",
    "playing",
    "playlist",
    "playmaker",
    "playmate",
    "playoff",
    "playpen",
    "playroom",
    "playset",
    "plaything",
    "playtime",
    "plaza",
    "pleading",
    "pleat",
    "pledge",
    "plentiful",
    "plenty",
    "plethora",
    "plexiglas",
    "pliable",
    "plod",
    "plop",
    "plot",
    "plow",
    "ploy",
    "pluck",
    "plug",
    "plunder",
    "plunging",
    "plural",
    "plus",
    "plutonium",
    "plywood",
    "poach",
    "pod",
    "poem",
    "poet",
    "pogo",
    "pointed",
    "pointer",
    "pointing",
    "pointless",
    "pointy",
    "poise",
    "poison",
    "poker",
    "poking",
    "polar",
    "police",
    "policy",
    "polio",
    "polish",
    "politely",
    "polka",
    "polo",
    "polyester",
    "polygon",
    "polygraph",
    "polymer",
    "poncho",
    "pond",
    "pony",
    "popcorn",
    "pope",
    "poplar",
    "popper",
    "poppy",
    "popsicle",
    "populace",
    "popular",
    "populate",
    "porcupine",
    "pork",
    "porous",
    "porridge",
    "portable",
    "portal",
    "portfolio",
    "porthole",
    "portion",
    "portly",
    "portside",
    "poser",
    "posh",
    "posing",
    "possible",
    "possibly",
    "possum",
    "postage",
    "postal",
    "postbox",
    "postcard",
    "posted",
    "poster",
    "posting",
    "postnasal",
    "posture",
    "postwar",
    "pouch",
    "pounce",
    "pouncing",
    "pound",
    "pouring",
    "pout",
    "powdered",
    "powdering",
    "powdery",
    "power",
    "powwow",
    "pox",
    "praising",
    "prance",
    "prancing",
    "pranker",
    "prankish",
    "prankster",
    "prayer",
    "praying",
    "preacher",
    "preaching",
    "preachy",
    "preamble",
    "precinct",
    "precise",
    "precision",
    "precook",
    "precut",
    "predator",
    "predefine",
    "predict",
    "preface",
    "prefix",
    "preflight",
    "preformed",
    "pregame",
    "pregnancy",
    "pregnant",
    "preheated",
    "prelaunch",
    "prelaw",
    "prelude",
    "premiere",
    "premises",
    "premium",
    "prenatal",
    "preoccupy",
    "preorder",
    "prepaid",
    "prepay",
    "preplan",
    "preppy",
    "preschool",
    "prescribe",
    "preseason",
    "preset",
    "preshow",
    "president",
    "presoak",
    "press",
    "presume",
    "presuming",
    "preteen",
    "pretended",
    "pretender",
    "pretense",
    "pretext",
    "pretty",
    "pretzel",
    "prevail",
    "prevalent",
    "prevent",
    "preview",
    "previous",
    "prewar",
    "prewashed",
    "prideful",
    "pried",
    "primal",
    "primarily",
    "primary",
    "primate",
    "primer",
    "primp",
    "princess",
    "print",
    "prior",
    "prism",
    "prison",
    "prissy",
    "pristine",
    "privacy",
    "private",
    "privatize",
    "prize",
    "proactive",
    "probable",
    "probably",
    "probation",
    "probe",
    "probing",
    "probiotic",
    "problem",
    "procedure",
    "process",
    "proclaim",
    "procreate",
    "procurer",
    "prodigal",
    "prodigy",
    "produce",
    "product",
    "profane",
    "profanity",
    "professed",
    "professor",
    "profile",
    "profound",
    "profusely",
    "progeny",
    "prognosis",
    "program",
    "progress",
    "projector",
    "prologue",
    "prolonged",
    "promenade",
    "prominent",
    "promoter",
    "promotion",
    "prompter",
    "promptly",
    "prone",
    "prong",
    "pronounce",
    "pronto",
    "proofing",
    "proofread",
    "proofs",
    "propeller",
    "properly",
    "property",
    "proponent",
    "proposal",
    "propose",
    "props",
    "prorate",
    "protector",
    "protegee",
    "proton",
    "prototype",
    "protozoan",
    "protract",
    "protrude",
    "proud",
    "provable",
    "proved",
    "proven",
    "provided",
    "provider",
    "providing",
    "province",
    "proving",
    "provoke",
    "provoking",
    "provolone",
    "prowess",
    "prowler",
    "prowling",
    "proximity",
    "proxy",
    "prozac",
    "prude",
    "prudishly",
    "prune",
    "pruning",
    "pry",
    "psychic",
    "public",
    "publisher",
    "pucker",
    "pueblo",
    "pug",
    "pull",
    "pulmonary",
    "pulp",
    "pulsate",
    "pulse",
    "pulverize",
    "puma",
    "pumice",
    "pummel",
    "punch",
    "punctual",
    "punctuate",
    "punctured",
    "pungent",
    "punisher",
    "punk",
    "pupil",
    "puppet",
    "puppy",
    "purchase",
    "pureblood",
    "purebred",
    "purely",
    "pureness",
    "purgatory",
    "purge",
    "purging",
    "purifier",
    "purify",
    "purist",
    "puritan",
    "purity",
    "purple",
    "purplish",
    "purposely",
    "purr",
    "purse",
    "pursuable",
    "pursuant",
    "pursuit",
    "purveyor",
    "pushcart",
    "pushchair",
    "pusher",
    "pushiness",
    "pushing",
    "pushover",
    "pushpin",
    "pushup",
    "pushy",
    "putdown",
    "putt",
    "puzzle",
    "puzzling",
    "pyramid",
    "pyromania",
    "python",
    "quack",
    "quadrant",
    "quail",
    "quaintly",
    "quake",
    "quaking",
    "qualified",
    "qualifier",
    "qualify",
    "quality",
    "qualm",
    "quantum",
    "quarrel",
    "quarry",
    "quartered",
    "quarterly",
    "quarters",
    "quartet",
    "quench",
    "query",
    "quicken",
    "quickly",
    "quickness",
    "quicksand",
    "quickstep",
    "quiet",
    "quill",
    "quilt",
    "quintet",
    "quintuple",
    "quirk",
    "quit",
    "quiver",
    "quizzical",
    "quotable",
    "quotation",
    "quote",
    "rabid",
    "race",
    "racing",
    "racism",
    "rack",
    "racoon",
    "radar",
    "radial",
    "radiance",
    "radiantly",
    "radiated",
    "radiation",
    "radiator",
    "radio",
    "radish",
    "raffle",
    "raft",
    "rage",
    "ragged",
    "raging",
    "ragweed",
    "raider",
    "railcar",
    "railing",
    "railroad",
    "railway",
    "raisin",
    "rake",
    "raking",
    "rally",
    "ramble",
    "rambling",
    "ramp",
    "ramrod",
    "ranch",
    "rancidity",
    "random",
    "ranged",
    "ranger",
    "ranging",
    "ranked",
    "ranking",
    "ransack",
    "ranting",
    "rants",
    "rare",
    "rarity",
    "rascal",
    "rash",
    "rasping",
    "ravage",
    "raven",
    "ravine",
    "raving",
    "ravioli",
    "ravishing",
    "reabsorb",
    "reach",
    "reacquire",
    "reaction",
    "reactive",
    "reactor",
    "reaffirm",
    "ream",
    "reanalyze",
    "reappear",
    "reapply",
    "reappoint",
    "reapprove",
    "rearrange",
    "rearview",
    "reason",
    "reassign",
    "reassure",
    "reattach",
    "reawake",
    "rebalance",
    "rebate",
    "rebel",
    "rebirth",
    "reboot",
    "reborn",
    "rebound",
    "rebuff",
    "rebuild",
    "rebuilt",
    "reburial",
    "rebuttal",
    "recall",
    "recant",
    "recapture",
    "recast",
    "recede",
    "recent",
    "recess",
    "recharger",
    "recipient",
    "recital",
    "recite",
    "reckless",
    "reclaim",
    "recliner",
    "reclining",
    "recluse",
    "reclusive",
    "recognize",
    "recoil",
    "recollect",
    "recolor",
    "reconcile",
    "reconfirm",
    "reconvene",
    "recopy",
    "record",
    "recount",
    "recoup",
    "recovery",
    "recreate",
    "rectal",
    "rectangle",
    "rectified",
    "rectify",
    "recycled",
    "recycler",
    "recycling",
    "reemerge",
    "reenact",
    "reenter",
    "reentry",
    "reexamine",
    "referable",
    "referee",
    "reference",
    "refill",
    "refinance",
    "refined",
    "refinery",
    "refining",
    "refinish",
    "reflected",
    "reflector",
    "reflex",
    "reflux",
    "refocus",
    "refold",
    "reforest",
    "reformat",
    "reformed",
    "reformer",
    "reformist",
    "refract",
    "refrain",
    "refreeze",
    "refresh",
    "refried",
    "refueling",
    "refund",
    "refurbish",
    "refurnish",
    "refusal",
    "refuse",
    "refusing",
    "refutable",
    "refute",
    "regain",
    "regalia",
    "regally",
    "reggae",
    "regime",
    "region",
    "register",
    "registrar",
    "registry",
    "regress",
    "regretful",
    "regroup",
    "regular",
    "regulate",
    "regulator",
    "rehab",
    "reheat",
    "rehire",
    "rehydrate",
    "reimburse",
    "reissue",
    "reiterate",
    "rejoice",
    "rejoicing",
    "rejoin",
    "rekindle",
    "relapse",
    "relapsing",
    "relatable",
    "related",
    "relation",
    "relative",
    "relax",
    "relay",
    "relearn",
    "release",
    "relenting",
    "reliable",
    "reliably",
    "reliance",
    "reliant",
    "relic",
    "relieve",
    "relieving",
    "relight",
    "relish",
    "relive",
    "reload",
    "relocate",
    "relock",
    "reluctant",
    "rely",
    "remake",
    "remark",
    "remarry",
    "rematch",
    "remedial",
    "remedy",
    "remember",
    "reminder",
    "remindful",
    "remission",
    "remix",
    "remnant",
    "remodeler",
    "remold",
    "remorse",
    "remote",
    "removable",
    "removal",
    "removed",
    "remover",
    "removing",
    "rename",
    "renderer",
    "rendering",
    "rendition",
    "renegade",
    "renewable",
    "renewably",
    "renewal",
    "renewed",
    "renounce",
    "renovate",
    "renovator",
    "rentable",
    "rental",
    "rented",
    "renter",
    "reoccupy",
    "reoccur",
    "reopen",
    "reorder",
    "repackage",
    "repacking",
    "repaint",
    "repair",
    "repave",
    "repaying",
    "repayment",
    "repeal",
    "repeated",
    "repeater",
    "repent",
    "rephrase",
    "replace",
    "replay",
    "replica",
    "reply",
    "reporter",
    "repose",
    "repossess",
    "repost",
    "repressed",
    "reprimand",
    "reprint",
    "reprise",
    "reproach",
    "reprocess",
    "reproduce",
    "reprogram",
    "reps",
    "reptile",
    "reptilian",
    "repugnant",
    "repulsion",
    "repulsive",
    "repurpose",
    "reputable",
    "reputably",
    "request",
    "require",
    "requisite",
    "reroute",
    "rerun",
    "resale",
    "resample",
    "rescuer",
    "reseal",
    "research",
    "reselect",
    "reseller",
    "resemble",
    "resend",
    "resent",
    "reset",
    "reshape",
    "reshoot",
    "reshuffle",
    "residence",
    "residency",
    "resident",
    "residual",
    "residue",
    "resigned",
    "resilient",
    "resistant",
    "resisting",
    "resize",
    "resolute",
    "resolved",
    "resonant",
    "resonate",
    "resort",
    "resource",
    "respect",
    "resubmit",
    "result",
    "resume",
    "resupply",
    "resurface",
    "resurrect",
    "retail",
    "retainer",
    "retaining",
    "retake",
    "retaliate",
    "retention",
    "rethink",
    "retinal",
    "retired",
    "retiree",
    "retiring",
    "retold",
    "retool",
    "retorted",
    "retouch",
    "retrace",
    "retract",
    "retrain",
    "retread",
    "retreat",
    "retrial",
    "retrieval",
    "retriever",
    "retry",
    "return",
    "retying",
    "retype",
    "reunion",
    "reunite",
    "reusable",
    "reuse",
    "reveal",
    "reveler",
    "revenge",
    "revenue",
    "reverb",
    "revered",
    "reverence",
    "reverend",
    "reversal",
    "reverse",
    "reversing",
    "reversion",
    "revert",
    "revisable",
    "revise",
    "revision",
    "revisit",
    "revivable",
    "revival",
    "reviver",
    "reviving",
    "revocable",
    "revoke",
    "revolt",
    "revolver",
    "revolving",
    "reward",
    "rewash",
    "rewind",
    "rewire",
    "reword",
    "rework",
    "rewrap",
    "rewrite",
    "rhyme",
    "ribbon",
    "ribcage",
    "rice",
    "riches",
    "richly",
    "richness",
    "rickety",
    "ricotta",
    "riddance",
    "ridden",
    "ride",
    "riding",
    "rifling",
    "rift",
    "rigging",
    "rigid",
    "rigor",
    "rimless",
    "rimmed",
    "rind",
    "rink",
    "rinse",
    "rinsing",
    "riot",
    "ripcord",
    "ripeness",
    "ripening",
    "ripping",
    "ripple",
    "rippling",
    "riptide",
    "rise",
    "rising",
    "risk",
    "risotto",
    "ritalin",
    "ritzy",
    "rival",
    "riverbank",
    "riverbed",
    "riverboat",
    "riverside",
    "riveter",
    "riveting",
    "roamer",
    "roaming",
    "roast",
    "robbing",
    "robe",
    "robin",
    "robotics",
    "robust",
    "rockband",
    "rocker",
    "rocket",
    "rockfish",
    "rockiness",
    "rocking",
    "rocklike",
    "rockslide",
    "rockstar",
    "rocky",
    "rogue",
    "roman",
    "romp",
    "rope",
    "roping",
    "roster",
    "rosy",
    "rotten",
    "rotting",
    "rotunda",
    "roulette",
    "rounding",
    "roundish",
    "roundness",
    "roundup",
    "roundworm",
    "routine",
    "routing",
    "rover",
    "roving",
    "royal",
    "rubbed",
    "rubber",
    "rubbing",
    "rubble",
    "rubdown",
    "ruby",
    "ruckus",
    "rudder",
    "rug",
    "ruined",
    "rule",
    "rumble",
    "rumbling",
    "rummage",
    "rumor",
    "runaround",
    "rundown",
    "runner",
    "running",
    "runny",
    "runt",
    "runway",
    "rupture",
    "rural",
    "ruse",
    "rush",
    "rust",
    "rut",
    "sabbath",
    "sabotage",
    "sacrament",
    "sacred",
    "sacrifice",
    "sadden",
    "saddlebag",
    "saddled",
    "saddling",
    "sadly",
    "sadness",
    "safari",
    "safeguard",
    "safehouse",
    "safely",
    "safeness",
    "saffron",
    "saga",
    "sage",
    "sagging",
    "saggy",
    "said",
    "saint",
    "sake",
    "salad",
    "salami",
    "salaried",
    "salary",
    "saline",
    "salon",
    "saloon",
    "salsa",
    "salt",
    "salutary",
    "salute",
    "salvage",
    "salvaging",
    "salvation",
    "same",
    "sample",
    "sampling",
    "sanction",
    "sanctity",
    "sanctuary",
    "sandal",
    "sandbag",
    "sandbank",
    "sandbar",
    "sandblast",
    "sandbox",
    "sanded",
    "sandfish",
    "sanding",
    "sandlot",
    "sandpaper",
    "sandpit",
    "sandstone",
    "sandstorm",
    "sandworm",
    "sandy",
    "sanitary",
    "sanitizer",
    "sank",
    "santa",
    "sapling",
    "sappiness",
    "sappy",
    "sarcasm",
    "sarcastic",
    "sardine",
    "sash",
    "sasquatch",
    "sassy",
    "satchel",
    "satiable",
    "satin",
    "satirical",
    "satisfied",
    "satisfy",
    "saturate",
    "saturday",
    "sauciness",
    "saucy",
    "sauna",
    "savage",
    "savanna",
    "saved",
    "savings",
    "savior",
    "savor",
    "saxophone",
    "say",
    "scabbed",
    "scabby",
    "scalded",
    "scalding",
    "scale",
    "scaling",
    "scallion",
    "scallop",
    "scalping",
    "scam",
    "scandal",
    "scanner",
    "scanning",
    "scant",
    "scapegoat",
    "scarce",
    "scarcity",
    "scarecrow",
    "scared",
    "scarf",
    "scarily",
    "scariness",
    "scarring",
    "scary",
    "scavenger",
    "scenic",
    "schedule",
    "schematic",
    "scheme",
    "scheming",
    "schilling",
    "schnapps",
    "scholar",
    "science",
    "scientist",
    "scion",
    "scoff",
    "scolding",
    "scone",
    "scoop",
    "scooter",
    "scope",
    "scorch",
    "scorebook",
    "scorecard",
    "scored",
    "scoreless",
    "scorer",
    "scoring",
    "scorn",
    "scorpion",
    "scotch",
    "scoundrel",
    "scoured",
    "scouring",
    "scouting",
    "scouts",
    "scowling",
    "scrabble",
    "scraggly",
    "scrambled",
    "scrambler",
    "scrap",
    "scratch",
    "scrawny",
    "screen",
    "scribble",
    "scribe",
    "scribing",
    "scrimmage",
    "script",
    "scroll",
    "scrooge",
    "scrounger",
    "scrubbed",
    "scrubber",
    "scruffy",
    "scrunch",
    "scrutiny",
    "scuba",
    "scuff",
    "sculptor",
    "sculpture",
    "scurvy",
    "scuttle",
    "secluded",
    "secluding",
    "seclusion",
    "second",
    "secrecy",
    "secret",
    "sectional",
    "sector",
    "secular",
    "securely",
    "security",
    "sedan",
    "sedate",
    "sedation",
    "sedative",
    "sediment",
    "seduce",
    "seducing",
    "segment",
    "seismic",
    "seizing",
    "seldom",
    "selected",
    "selection",
    "selective",
    "selector",
    "self",
    "seltzer",
    "semantic",
    "semester",
    "semicolon",
    "semifinal",
    "seminar",
    "semisoft",
    "semisweet",
    "senate",
    "senator",
    "send",
    "senior",
    "senorita",
    "sensation",
    "sensitive",
    "sensitize",
    "sensually",
    "sensuous",
    "sepia",
    "september",
    "septic",
    "septum",
    "sequel",
    "sequence",
    "sequester",
    "series",
    "sermon",
    "serotonin",
    "serpent",
    "serrated",
    "serve",
    "service",
    "serving",
    "sesame",
    "sessions",
    "setback",
    "setting",
    "settle",
    "settling",
    "setup",
    "sevenfold",
    "seventeen",
    "seventh",
    "seventy",
    "severity",
    "shabby",
    "shack",
    "shaded",
    "shadily",
    "shadiness",
    "shading",
    "shadow",
    "shady",
    "shaft",
    "shakable",
    "shakily",
    "shakiness",
    "shaking",
    "shaky",
    "shale",
    "shallot",
    "shallow",
    "shame",
    "shampoo",
    "shamrock",
    "shank",
    "shanty",
    "shape",
    "shaping",
    "share",
    "sharpener",
    "sharper",
    "sharpie",
    "sharply",
    "sharpness",
    "shawl",
    "sheath",
    "shed",
    "sheep",
    "sheet",
    "shelf",
    "shell",
    "shelter",
    "shelve",
    "shelving",
    "sherry",
    "shield",
    "shifter",
    "shifting",
    "shiftless",
    "shifty",
    "shimmer",
    "shimmy",
    "shindig",
    "shine",
    "shingle",
    "shininess",
    "shining",
    "shiny",
    "ship",
    "shirt",
    "shivering",
    "shock",
    "shone",
    "shoplift",
    "shopper",
    "shopping",
    "shoptalk",
    "shore",
    "shortage",
    "shortcake",
    "shortcut",
    "shorten",
    "shorter",
    "shorthand",
    "shortlist",
    "shortly",
    "shortness",
    "shorts",
    "shortwave",
    "shorty",
    "shout",
    "shove",
    "showbiz",
    "showcase",
    "showdown",
    "shower",
    "showgirl",
    "showing",
    "showman",
    "shown",
    "showoff",
    "showpiece",
    "showplace",
    "showroom",
    "showy",
    "shrank",
    "shrapnel",
    "shredder",
    "shredding",
    "shrewdly",
    "shriek",
    "shrill",
    "shrimp",
    "shrine",
    "shrink",
    "shrivel",
    "shrouded",
    "shrubbery",
    "shrubs",
    "shrug",
    "shrunk",
    "shucking",
    "shudder",
    "shuffle",
    "shuffling",
    "shun",
    "shush",
    "shut",
    "shy",
    "siamese",
    "siberian",
    "sibling",
    "siding",
    "sierra",
    "siesta",
    "sift",
    "sighing",
    "silenced",
    "silencer",
    "silent",
    "silica",
    "silicon",
    "silk",
    "silliness",
    "silly",
    "silo",
    "silt",
    "silver",
    "similarly",
    "simile",
    "simmering",
    "simple",
    "simplify",
    "simply",
    "sincere",
    "sincerity",
    "singer",
    "singing",
    "single",
    "singular",
    "sinister",
    "sinless",
    "sinner",
    "sinuous",
    "sip",
    "siren",
    "sister",
    "sitcom",
    "sitter",
    "sitting",
    "situated",
    "situation",
    "sixfold",
    "sixteen",
    "sixth",
    "sixties",
    "sixtieth",
    "sixtyfold",
    "sizable",
    "sizably",
    "size",
    "sizing",
    "sizzle",
    "sizzling",
    "skater",
    "skating",
    "skedaddle",
    "skeletal",
    "skeleton",
    "skeptic",
    "sketch",
    "skewed",
    "skewer",
    "skid",
    "skied",
    "skier",
    "skies",
    "skiing",
    "skilled",
    "skillet",
    "skillful",
    "skimmed",
    "skimmer",
    "skimming",
    "skimpily",
    "skincare",
    "skinhead",
    "skinless",
    "skinning",
    "skinny",
    "skintight",
    "skipper",
    "skipping",
    "skirmish",
    "skirt",
    "skittle",
    "skydiver",
    "skylight",
    "skyline",
    "skype",
    "skyrocket",
    "skyward",
    "slab",
    "slacked",
    "slacker",
    "slacking",
    "slackness",
    "slacks",
    "slain",
    "slam",
    "slander",
    "slang",
    "slapping",
    "slapstick",
    "slashed",
    "slashing",
    "slate",
    "slather",
    "slaw",
    "sled",
    "sleek",
    "sleep",
    "sleet",
    "sleeve",
    "slept",
    "sliceable",
    "sliced",
    "slicer",
    "slicing",
    "slick",
    "slider",
    "slideshow",
    "sliding",
    "slighted",
    "slighting",
    "slightly",
    "slimness",
    "slimy",
    "slinging",
    "slingshot",
    "slinky",
    "slip",
    "slit",
    "sliver",
    "slobbery",
    "slogan",
    "sloped",
    "sloping",
    "sloppily",
    "sloppy",
    "slot",
    "slouching",
    "slouchy",
    "sludge",
    "slug",
    "slum",
    "slurp",
    "slush",
    "sly",
    "small",
    "smartly",
    "smartness",
    "smasher",
    "smashing",
    "smashup",
    "smell",
    "smelting",
    "smile",
    "smilingly",
    "smirk",
    "smite",
    "smith",
    "smitten",
    "smock",
    "smog",
    "smoked",
    "smokeless",
    "smokiness",
    "smoking",
    "smoky",
    "smolder",
    "smooth",
    "smother",
    "smudge",
    "smudgy",
    "smuggler",
    "smuggling",
    "smugly",
    "smugness",
    "snack",
    "snagged",
    "snaking",
    "snap",
    "snare",
    "snarl",
    "snazzy",
    "sneak",
    "sneer",
    "sneeze",
    "sneezing",
    "snide",
    "sniff",
    "snippet",
    "snipping",
    "snitch",
    "snooper",
    "snooze",
    "snore",
    "snoring",
    "snorkel",
    "snort",
    "snout",
    "snowbird",
    "snowboard",
    "snowbound",
    "snowcap",
    "snowdrift",
    "snowdrop",
    "snowfall",
    "snowfield",
    "snowflake",
    "snowiness",
    "snowless",
    "snowman",
    "snowplow",
    "snowshoe",
    "snowstorm",
    "snowsuit",
    "snowy",
    "snub",
    "snuff",
    "snuggle",
    "snugly",
    "snugness",
    "speak",
    "spearfish",
    "spearhead",
    "spearman",
    "spearmint",
    "species",
    "specimen",
    "specked",
    "speckled",
    "specks",
    "spectacle",
    "spectator",
    "spectrum",
    "speculate",
    "speech",
    "speed",
    "spellbind",
    "speller",
    "spelling",
    "spendable",
    "spender",
    "spending",
    "spent",
    "spew",
    "sphere",
    "spherical",
    "sphinx",
    "spider",
    "spied",
    "spiffy",
    "spill",
    "spilt",
    "spinach",
    "spinal",
    "spindle",
    "spinner",
    "spinning",
    "spinout",
    "spinster",
    "spiny",
    "spiral",
    "spirited",
    "spiritism",
    "spirits",
    "spiritual",
    "splashed",
    "splashing",
    "splashy",
    "splatter",
    "spleen",
    "splendid",
    "splendor",
    "splice",
    "splicing",
    "splinter",
    "splotchy",
    "splurge",
    "spoilage",
    "spoiled",
    "spoiler",
    "spoiling",
    "spoils",
    "spoken",
    "spokesman",
    "sponge",
    "spongy",
    "sponsor",
    "spoof",
    "spookily",
    "spooky",
    "spool",
    "spoon",
    "spore",
    "sporting",
    "sports",
    "sporty",
    "spotless",
    "spotlight",
    "spotted",
    "spotter",
    "spotting",
    "spotty",
    "spousal",
    "spouse",
    "spout",
    "sprain",
    "sprang",
    "sprawl",
    "spray",
    "spree",
    "sprig",
    "spring",
    "sprinkled",
    "sprinkler",
    "sprint",
    "sprite",
    "sprout",
    "spruce",
    "sprung",
    "spry",
    "spud",
    "spur",
    "sputter",
    "spyglass",
    "squabble",
    "squad",
    "squall",
    "squander",
    "squash",
    "squatted",
    "squatter",
    "squatting",
    "squeak",
    "squealer",
    "squealing",
    "squeamish",
    "squeegee",
    "squeeze",
    "squeezing",
    "squid",
    "squiggle",
    "squiggly",
    "squint",
    "squire",
    "squirt",
    "squishier",
    "squishy",
    "stability",
    "stabilize",
    "stable",
    "stack",
    "stadium",
    "staff",
    "stage",
    "staging",
    "stagnant",
    "stagnate",
    "stainable",
    "stained",
    "staining",
    "stainless",
    "stalemate",
    "staleness",
    "stalling",
    "stallion",
    "stamina",
    "stammer",
    "stamp",
    "stand",
    "stank",
    "staple",
    "stapling",
    "starboard",
    "starch",
    "stardom",
    "stardust",
    "starfish",
    "stargazer",
    "staring",
    "stark",
    "starless",
    "starlet",
    "starlight",
    "starlit",
    "starring",
    "starry",
    "starship",
    "starter",
    "starting",
    "startle",
    "startling",
    "startup",
    "starved",
    "starving",
    "stash",
    "state",
    "static",
    "statistic",
    "statue",
    "stature",
    "status",
    "statute",
    "statutory",
    "staunch",
    "stays",
    "steadfast",
    "steadier",
    "steadily",
    "steadying",
    "steam",
    "steed",
    "steep",
    "steerable",
    "steering",
    "steersman",
    "stegosaur",
    "stellar",
    "stem",
    "stench",
    "stencil",
    "step",
    "stereo",
    "sterile",
    "sterility",
    "sterilize",
    "sterling",
    "sternness",
    "sternum",
    "stew",
    "stick",
    "stiffen",
    "stiffly",
    "stiffness",
    "stifle",
    "stifling",
    "stillness",
    "stilt",
    "stimulant",
    "stimulate",
    "stimuli",
    "stimulus",
    "stinger",
    "stingily",
    "stinging",
    "stingray",
    "stingy",
    "stinking",
    "stinky",
    "stipend",
    "stipulate",
    "stir",
    "stitch",
    "stock",
    "stoic",
    "stoke",
    "stole",
    "stomp",
    "stonewall",
    "stoneware",
    "stonework",
    "stoning",
    "stony",
    "stood",
    "stooge",
    "stool",
    "stoop",
    "stoplight",
    "stoppable",
    "stoppage",
    "stopped",
    "stopper",
    "stopping",
    "stopwatch",
    "storable",
    "storage",
    "storeroom",
    "storewide",
    "storm",
    "stout",
    "stove",
    "stowaway",
    "stowing",
    "straddle",
    "straggler",
    "strained",
    "strainer",
    "straining",
    "strangely",
    "stranger",
    "strangle",
    "strategic",
    "strategy",
    "stratus",
    "straw",
    "stray",
    "streak",
    "stream",
    "street",
    "strength",
    "strenuous",
    "strep",
    "stress",
    "stretch",
    "strewn",
    "stricken",
    "strict",
    "stride",
    "strife",
    "strike",
    "striking",
    "strive",
    "striving",
    "strobe",
    "strode",
    "stroller",
    "strongbox",
    "strongly",
    "strongman",
    "struck",
    "structure",
    "strudel",
    "struggle",
    "strum",
    "strung",
    "strut",
    "stubbed",
    "stubble",
    "stubbly",
    "stubborn",
    "stucco",
    "stuck",
    "student",
    "studied",
    "studio",
    "study",
    "stuffed",
    "stuffing",
    "stuffy",
    "stumble",
    "stumbling",
    "stump",
    "stung",
    "stunned",
    "stunner",
    "stunning",
    "stunt",
    "stupor",
    "sturdily",
    "sturdy",
    "styling",
    "stylishly",
    "stylist",
    "stylized",
    "stylus",
    "suave",
    "subarctic",
    "subatomic",
    "subdivide",
    "subdued",
    "subduing",
    "subfloor",
    "subgroup",
    "subheader",
    "subject",
    "sublease",
    "sublet",
    "sublevel",
    "sublime",
    "submarine",
    "submerge",
    "submersed",
    "submitter",
    "subpanel",
    "subpar",
    "subplot",
    "subprime",
    "subscribe",
    "subscript",
    "subsector",
    "subside",
    "subsiding",
    "subsidize",
    "subsidy",
    "subsoil",
    "subsonic",
    "substance",
    "subsystem",
    "subtext",
    "subtitle",
    "subtly",
    "subtotal",
    "subtract",
    "subtype",
    "suburb",
    "subway",
    "subwoofer",
    "subzero",
    "succulent",
    "such",
    "suction",
    "sudden",
    "sudoku",
    "suds",
    "sufferer",
    "suffering",
    "suffice",
    "suffix",
    "suffocate",
    "suffrage",
    "sugar",
    "suggest",
    "suing",
    "suitable",
    "suitably",
    "suitcase",
    "suitor",
    "sulfate",
    "sulfide",
    "sulfite",
    "sulfur",
    "sulk",
    "sullen",
    "sulphate",
    "sulphuric",
    "sultry",
    "superbowl",
    "superglue",
    "superhero",
    "superior",
    "superjet",
    "superman",
    "supermom",
    "supernova",
    "supervise",
    "supper",
    "supplier",
    "supply",
    "support",
    "supremacy",
    "supreme",
    "surcharge",
    "surely",
    "sureness",
    "surface",
    "surfacing",
    "surfboard",
    "surfer",
    "surgery",
    "surgical",
    "surging",
    "surname",
    "surpass",
    "surplus",
    "surprise",
    "surreal",
    "surrender",
    "surrogate",
    "surround",
    "survey",
    "survival",
    "survive",
    "surviving",
    "survivor",
    "sushi",
    "suspect",
    "suspend",
    "suspense",
    "sustained",
    "sustainer",
    "swab",
    "swaddling",
    "swagger",
    "swampland",
    "swan",
    "swapping",
    "swarm",
    "sway",
    "swear",
    "sweat",
    "sweep",
    "swell",
    "swept",
    "swerve",
    "swifter",
    "swiftly",
    "swiftness",
    "swimmable",
    "swimmer",
    "swimming",
    "swimsuit",
    "swimwear",
    "swinger",
    "swinging",
    "swipe",
    "swirl",
    "switch",
    "swivel",
    "swizzle",
    "swooned",
    "swoop",
    "swoosh",
    "swore",
    "sworn",
    "swung",
    "sycamore",
    "sympathy",
    "symphonic",
    "symphony",
    "symptom",
    "synapse",
    "syndrome",
    "synergy",
    "synopses",
    "synopsis",
    "synthesis",
    "synthetic",
    "syrup",
    "system",
    "t-shirt",
    "tabasco",
    "tabby",
    "tableful",
    "tables",
    "tablet",
    "tableware",
    "tabloid",
    "tackiness",
    "tacking",
    "tackle",
    "tackling",
    "tacky",
    "taco",
    "tactful",
    "tactical",
    "tactics",
    "tactile",
    "tactless",
    "tadpole",
    "taekwondo",
    "tag",
    "tainted",
    "take",
    "taking",
    "talcum",
    "talisman",
    "tall",
    "talon",
    "tamale",
    "tameness",
    "tamer",
    "tamper",
    "tank",
    "tanned",
    "tannery",
    "tanning",
    "tantrum",
    "tapeless",
    "tapered",
    "tapering",
    "tapestry",
    "tapioca",
    "tapping",
    "taps",
    "tarantula",
    "target",
    "tarmac",
    "tarnish",
    "tarot",
    "tartar",
    "tartly",
    "tartness",
    "task",
    "tassel",
    "taste",
    "tastiness",
    "tasting",
    "tasty",
    "tattered",
    "tattle",
    "tattling",
    "tattoo",
    "taunt",
    "tavern",
    "thank",
    "that",
    "thaw",
    "theater",
    "theatrics",
    "thee",
    "theft",
    "theme",
    "theology",
    "theorize",
    "thermal",
    "thermos",
    "thesaurus",
    "these",
    "thesis",
    "thespian",
    "thicken",
    "thicket",
    "thickness",
    "thieving",
    "thievish",
    "thigh",
    "thimble",
    "thing",
    "think",
    "thinly",
    "thinner",
    "thinness",
    "thinning",
    "thirstily",
    "thirsting",
    "thirsty",
    "thirteen",
    "thirty",
    "thong",
    "thorn",
    "those",
    "thousand",
    "thrash",
    "thread",
    "threaten",
    "threefold",
    "thrift",
    "thrill",
    "thrive",
    "thriving",
    "throat",
    "throbbing",
    "throng",
    "throttle",
    "throwaway",
    "throwback",
    "thrower",
    "throwing",
    "thud",
    "thumb",
    "thumping",
    "thursday",
    "thus",
    "thwarting",
    "thyself",
    "tiara",
    "tibia",
    "tidal",
    "tidbit",
    "tidiness",
    "tidings",
    "tidy",
    "tiger",
    "tighten",
    "tightly",
    "tightness",
    "tightrope",
    "tightwad",
    "tigress",
    "tile",
    "tiling",
    "till",
    "tilt",
    "timid",
    "timing",
    "timothy",
    "tinderbox",
    "tinfoil",
    "tingle",
    "tingling",
    "tingly",
    "tinker",
    "tinkling",
    "tinsel",
    "tinsmith",
    "tint",
    "tinwork",
    "tiny",
    "tipoff",
    "tipped",
    "tipper",
    "tipping",
    "tiptoeing",
    "tiptop",
    "tiring",
    "tissue",
    "trace",
    "tracing",
    "track",
    "traction",
    "tractor",
    "trade",
    "trading",
    "tradition",
    "traffic",
    "tragedy",
    "trailing",
    "trailside",
    "train",
    "traitor",
    "trance",
    "tranquil",
    "transfer",
    "transform",
    "translate",
    "transpire",
    "transport",
    "transpose",
    "trapdoor",
    "trapeze",
    "trapezoid",
    "trapped",
    "trapper",
    "trapping",
    "traps",
    "trash",
    "travel",
    "traverse",
    "travesty",
    "tray",
    "treachery",
    "treading",
    "treadmill",
    "treason",
    "treat",
    "treble",
    "tree",
    "trekker",
    "tremble",
    "trembling",
    "tremor",
    "trench",
    "trend",
    "trespass",
    "triage",
    "trial",
    "triangle",
    "tribesman",
    "tribunal",
    "tribune",
    "tributary",
    "tribute",
    "triceps",
    "trickery",
    "trickily",
    "tricking",
    "trickle",
    "trickster",
    "tricky",
    "tricolor",
    "tricycle",
    "trident",
    "tried",
    "trifle",
    "trifocals",
    "trillion",
    "trilogy",
    "trimester",
    "trimmer",
    "trimming",
    "trimness",
    "trinity",
    "trio",
    "tripod",
    "tripping",
    "triumph",
    "trivial",
    "trodden",
    "trolling",
    "trombone",
    "trophy",
    "tropical",
    "tropics",
    "trouble",
    "troubling",
    "trough",
    "trousers",
    "trout",
    "trowel",
    "truce",
    "truck",
    "truffle",
    "trump",
    "trunks",
    "trustable",
    "trustee",
    "trustful",
    "trusting",
    "trustless",
    "truth",
    "try",
    "tubby",
    "tubeless",
    "tubular",
    "tucking",
    "tuesday",
    "tug",
    "tuition",
    "tulip",
    "tumble",
    "tumbling",
    "tummy",
    "turban",
    "turbine",
    "turbofan",
    "turbojet",
    "turbulent",
    "turf",
    "turkey",
    "turmoil",
    "turret",
    "turtle",
    "tusk",
    "tutor",
    "tutu",
    "tux",
    "tweak",
    "tweed",
    "tweet",
    "tweezers",
    "twelve",
    "twentieth",
    "twenty",
    "twerp",
    "twice",
    "twiddle",
    "twiddling",
    "twig",
    "twilight",
    "twine",
    "twins",
    "twirl",
    "twistable",
    "twisted",
    "twister",
    "twisting",
    "twisty",
    "twitch",
    "twitter",
    "tycoon",
    "tying",
    "tyke",
    "udder",
    "ultimate",
    "ultimatum",
    "ultra",
    "umbilical",
    "umbrella",
    "umpire",
    "unabashed",
    "unable",
    "unadorned",
    "unadvised",
    "unafraid",
    "unaired",
    "unaligned",
    "unaltered",
    "unarmored",
    "unashamed",
    "unaudited",
    "unawake",
    "unaware",
    "unbaked",
    "unbalance",
    "unbeaten",
    "unbend",
    "unbent",
    "unbiased",
    "unbitten",
    "unblended",
    "unblessed",
    "unblock",
    "unbolted",
    "unbounded",
    "unboxed",
    "unbraided",
    "unbridle",
    "unbroken",
    "unbuckled",
    "unbundle",
    "unburned",
    "unbutton",
    "uncanny",
    "uncapped",
    "uncaring",
    "uncertain",
    "unchain",
    "unchanged",
    "uncharted",
    "uncheck",
    "uncivil",
    "unclad",
    "unclaimed",
    "unclamped",
    "unclasp",
    "uncle",
    "unclip",
    "uncloak",
    "unclog",
    "unclothed",
    "uncoated",
    "uncoiled",
    "uncolored",
    "uncombed",
    "uncommon",
    "uncooked",
    "uncork",
    "uncorrupt",
    "uncounted",
    "uncouple",
    "uncouth",
    "uncover",
    "uncross",
    "uncrown",
    "uncrushed",
    "uncured",
    "uncurious",
    "uncurled",
    "uncut",
    "undamaged",
    "undated",
    "undaunted",
    "undead",
    "undecided",
    "undefined",
    "underage",
    "underarm",
    "undercoat",
    "undercook",
    "undercut",
    "underdog",
    "underdone",
    "underfed",
    "underfeed",
    "underfoot",
    "undergo",
    "undergrad",
    "underhand",
    "underline",
    "underling",
    "undermine",
    "undermost",
    "underpaid",
    "underpass",
    "underpay",
    "underrate",
    "undertake",
    "undertone",
    "undertook",
    "undertow",
    "underuse",
    "underwear",
    "underwent",
    "underwire",
    "undesired",
    "undiluted",
    "undivided",
    "undocked",
    "undoing",
    "undone",
    "undrafted",
    "undress",
    "undrilled",
    "undusted",
    "undying",
    "unearned",
    "unearth",
    "unease",
    "uneasily",
    "uneasy",
    "uneatable",
    "uneaten",
    "unedited",
    "unelected",
    "unending",
    "unengaged",
    "unenvied",
    "unequal",
    "unethical",
    "uneven",
    "unexpired",
    "unexposed",
    "unfailing",
    "unfair",
    "unfasten",
    "unfazed",
    "unfeeling",
    "unfiled",
    "unfilled",
    "unfitted",
    "unfitting",
    "unfixable",
    "unfixed",
    "unflawed",
    "unfocused",
    "unfold",
    "unfounded",
    "unframed",
    "unfreeze",
    "unfrosted",
    "unfrozen",
    "unfunded",
    "unglazed",
    "ungloved",
    "unglue",
    "ungodly",
    "ungraded",
    "ungreased",
    "unguarded",
    "unguided",
    "unhappily",
    "unhappy",
    "unharmed",
    "unhealthy",
    "unheard",
    "unhearing",
    "unheated",
    "unhelpful",
    "unhidden",
    "unhinge",
    "unhitched",
    "unholy",
    "unhook",
    "unicorn",
    "unicycle",
    "unified",
    "unifier",
    "uniformed",
    "uniformly",
    "unify",
    "unimpeded",
    "uninjured",
    "uninstall",
    "uninsured",
    "uninvited",
    "union",
    "uniquely",
    "unisexual",
    "unison",
    "unissued",
    "unit",
    "universal",
    "universe",
    "unjustly",
    "unkempt",
    "unkind",
    "unknotted",
    "unknowing",
    "unknown",
    "unlaced",
    "unlatch",
    "unlawful",
    "unleaded",
    "unlearned",
    "unleash",
    "unless",
    "unleveled",
    "unlighted",
    "unlikable",
    "unlimited",
    "unlined",
    "unlinked",
    "unlisted",
    "unlit",
    "unlivable",
    "unloaded",
    "unloader",
    "unlocked",
    "unlocking",
    "unlovable",
    "unloved",
    "unlovely",
    "unloving",
    "unluckily",
    "unlucky",
    "unmade",
    "unmanaged",
    "unmanned",
    "unmapped",
    "unmarked",
    "unmasked",
    "unmasking",
    "unmatched",
    "unmindful",
    "unmixable",
    "unmixed",
    "unmolded",
    "unmoral",
    "unmovable",
    "unmoved",
    "unmoving",
    "unnamable",
    "unnamed",
    "unnatural",
    "unneeded",
    "unnerve",
    "unnerving",
    "unnoticed",
    "unopened",
    "unopposed",
    "unpack",
    "unpadded",
    "unpaid",
    "unpainted",
    "unpaired",
    "unpaved",
    "unpeeled",
    "unpicked",
    "unpiloted",
    "unpinned",
    "unplanned",
    "unplanted",
    "unpleased",
    "unpledged",
    "unplowed",
    "unplug",
    "unpopular",
    "unproven",
    "unquote",
    "unranked",
    "unrated",
    "unraveled",
    "unreached",
    "unread",
    "unreal",
    "unreeling",
    "unrefined",
    "unrelated",
    "unrented",
    "unrest",
    "unretired",
    "unrevised",
    "unrigged",
    "unripe",
    "unrivaled",
    "unroasted",
    "unrobed",
    "unroll",
    "unruffled",
    "unruly",
    "unrushed",
    "unsaddle",
    "unsafe",
    "unsaid",
    "unsalted",
    "unsaved",
    "unsavory",
    "unscathed",
    "unscented",
    "unscrew",
    "unsealed",
    "unseated",
    "unsecured",
    "unseeing",
    "unseemly",
    "unseen",
    "unselect",
    "unselfish",
    "unsent",
    "unsettled",
    "unshackle",
    "unshaken",
    "unshaved",
    "unshaven",
    "unsheathe",
    "unshipped",
    "unsightly",
    "unsigned",
    "unskilled",
    "unsliced",
    "unsmooth",
    "unsnap",
    "unsocial",
    "unsoiled",
    "unsold",
    "unsolved",
    "unsorted",
    "unspoiled",
    "unspoken",
    "unstable",
    "unstaffed",
    "unstamped",
    "unsteady",
    "unsterile",
    "unstirred",
    "unstitch",
    "unstopped",
    "unstuck",
    "unstuffed",
    "unstylish",
    "unsubtle",
    "unsubtly",
    "unsuited",
    "unsure",
    "unsworn",
    "untagged",
    "untainted",
    "untaken",
    "untamed",
    "untangled",
    "untapped",
    "untaxed",
    "unthawed",
    "unthread",
    "untidy",
    "untie",
    "until",
    "untimed",
    "untimely",
    "untitled",
    "untoasted",
    "untold",
    "untouched",
    "untracked",
    "untrained",
    "untreated",
    "untried",
    "untrimmed",
    "untrue",
    "untruth",
    "unturned",
    "untwist",
    "untying",
    "unusable",
    "unused",
    "unusual",
    "unvalued",
    "unvaried",
    "unvarying",
    "unveiled",
    "unveiling",
    "unvented",
    "unviable",
    "unvisited",
    "unvocal",
    "unwanted",
    "unwarlike",
    "unwary",
    "unwashed",
    "unwatched",
    "unweave",
    "unwed",
    "unwelcome",
    "unwell",
    "unwieldy",
    "unwilling",
    "unwind",
    "unwired",
    "unwitting",
    "unwomanly",
    "unworldly",
    "unworn",
    "unworried",
    "unworthy",
    "unwound",
    "unwoven",
    "unwrapped",
    "unwritten",
    "unzip",
    "upbeat",
    "upchuck",
    "upcoming",
    "upcountry",
    "update",
    "upfront",
    "upgrade",
    "upheaval",
    "upheld",
    "uphill",
    "uphold",
    "uplifted",
    "uplifting",
    "upload",
    "upon",
    "upper",
    "upright",
    "uprising",
    "upriver",
    "uproar",
    "uproot",
    "upscale",
    "upside",
    "upstage",
    "upstairs",
    "upstart",
    "upstate",
    "upstream",
    "upstroke",
    "upswing",
    "uptake",
    "uptight",
    "uptown",
    "upturned",
    "upward",
    "upwind",
    "uranium",
    "urban",
    "urchin",
    "urethane",
    "urgency",
    "urgent",
    "urging",
    "urologist",
    "urology",
    "usable",
    "usage",
    "useable",
    "used",
    "uselessly",
    "user",
    "usher",
    "usual",
    "utensil",
    "utility",
    "utilize",
    "utmost",
    "utopia",
    "utter",
    "vacancy",
    "vacant",
    "vacate",
    "vacation",
    "vagabond",
    "vagrancy",
    "vagrantly",
    "vaguely",
    "vagueness",
    "valiant",
    "valid",
    "valium",
    "valley",
    "valuables",
    "value",
    "vanilla",
    "vanish",
    "vanity",
    "vanquish",
    "vantage",
    "vaporizer",
    "variable",
    "variably",
    "varied",
    "variety",
    "various",
    "varmint",
    "varnish",
    "varsity",
    "varying",
    "vascular",
    "vaseline",
    "vastly",
    "vastness",
    "veal",
    "vegan",
    "veggie",
    "vehicular",
    "velcro",
    "velocity",
    "velvet",
    "vendetta",
    "vending",
    "vendor",
    "veneering",
    "vengeful",
    "venomous",
    "ventricle",
    "venture",
    "venue",
    "venus",
    "verbalize",
    "verbally",
    "verbose",
    "verdict",
    "verify",
    "verse",
    "version",
    "versus",
    "vertebrae",
    "vertical",
    "vertigo",
    "very",
    "vessel",
    "vest",
    "veteran",
    "veto",
    "vexingly",
    "viability",
    "viable",
    "vibes",
    "vice",
    "vicinity",
    "victory",
    "video",
    "viewable",
    "viewer",
    "viewing",
    "viewless",
    "viewpoint",
    "vigorous",
    "village",
    "villain",
    "vindicate",
    "vineyard",
    "vintage",
    "violate",
    "violation",
    "violator",
    "violet",
    "violin",
    "viper",
    "viral",
    "virtual",
    "virtuous",
    "virus",
    "visa",
    "viscosity",
    "viscous",
    "viselike",
    "visible",
    "visibly",
    "vision",
    "visiting",
    "visitor",
    "visor",
    "vista",
    "vitality",
    "vitalize",
    "vitally",
    "vitamins",
    "vivacious",
    "vividly",
    "vividness",
    "vixen",
    "vocalist",
    "vocalize",
    "vocally",
    "vocation",
    "voice",
    "voicing",
    "void",
    "volatile",
    "volley",
    "voltage",
    "volumes",
    "voter",
    "voting",
    "voucher",
    "vowed",
    "vowel",
    "voyage",
    "wackiness",
    "wad",
    "wafer",
    "waffle",
    "waged",
    "wager",
    "wages",
    "waggle",
    "wagon",
    "wake",
    "waking",
    "walk",
    "walmart",
    "walnut",
    "walrus",
    "waltz",
    "wand",
    "wannabe",
    "wanted",
    "wanting",
    "wasabi",
    "washable",
    "washbasin",
    "washboard",
    "washbowl",
    "washcloth",
    "washday",
    "washed",
    "washer",
    "washhouse",
    "washing",
    "washout",
    "washroom",
    "washstand",
    "washtub",
    "wasp",
    "wasting",
    "watch",
    "water",
    "waviness",
    "waving",
    "wavy",
    "whacking",
    "whacky",
    "wham",
    "wharf",
    "wheat",
    "whenever",
    "whiff",
    "whimsical",
    "whinny",
    "whiny",
    "whisking",
    "whoever",
    "whole",
    "whomever",
    "whoopee",
    "whooping",
    "whoops",
    "why",
    "wick",
    "widely",
    "widen",
    "widget",
    "widow",
    "width",
    "wieldable",
    "wielder",
    "wife",
    "wifi",
    "wikipedia",
    "wildcard",
    "wildcat",
    "wilder",
    "wildfire",
    "wildfowl",
    "wildland",
    "wildlife",
    "wildly",
    "wildness",
    "willed",
    "willfully",
    "willing",
    "willow",
    "willpower",
    "wilt",
    "wimp",
    "wince",
    "wincing",
    "wind",
    "wing",
    "winking",
    "winner",
    "winnings",
    "winter",
    "wipe",
    "wired",
    "wireless",
    "wiring",
    "wiry",
    "wisdom",
    "wise",
    "wish",
    "wisplike",
    "wispy",
    "wistful",
    "wizard",
    "wobble",
    "wobbling",
    "wobbly",
    "wok",
    "wolf",
    "wolverine",
    "womanhood",
    "womankind",
    "womanless",
    "womanlike",
    "womanly",
    "womb",
    "woof",
    "wooing",
    "wool",
    "woozy",
    "word",
    "work",
    "worried",
    "worrier",
    "worrisome",
    "worry",
    "worsening",
    "worshiper",
    "worst",
    "wound",
    "woven",
    "wow",
    "wrangle",
    "wrath",
    "wreath",
    "wreckage",
    "wrecker",
    "wrecking",
    "wrench",
    "wriggle",
    "wriggly",
    "wrinkle",
    "wrinkly",
    "wrist",
    "writing",
    "written",
    "wrongdoer",
    "wronged",
    "wrongful",
    "wrongly",
    "wrongness",
    "wrought",
    "xbox",
    "xerox",
    "yahoo",
    "yam",
    "yanking",
    "yapping",
    "yard",
    "yarn",
    "yeah",
    "yearbook",
    "yearling",
    "yearly",
    "yearning",
    "yeast",
    "yelling",
    "yelp",
    "yen",
    "yesterday",
    "yiddish",
    "yield",
    "yin",
    "yippee",
    "yo-yo",
    "yodel",
    "yoga",
    "yogurt",
    "yonder",
    "yoyo",
    "yummy",
    "zap",
    "zealous",
    "zebra",
    "zen",
    "zeppelin",
    "zero",
    "zestfully",
    "zesty",
    "zigzagged",
    "zipfile",
    "zipping",
    "zippy",
    "zips",
    "zit",
    "zodiac",
    "zombie",
    "zone",
    "zoning",
    "zookeeper",
    "zoologist",
    "zoology",
    "zoom",
];

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/encrypted-organization-key.ts
var encrypted_organization_key_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class BaseEncryptedOrganizationKey {
    static fromData(data) {
        switch (data.type) {
            case "organization":
                return new EncryptedOrganizationKey(data.key);
            case "provider":
                return new ProviderEncryptedOrganizationKey(data.key, data.providerId);
            default:
                return null;
        }
    }
}
class EncryptedOrganizationKey {
    constructor(key) {
        this.key = key;
    }
    decrypt(cryptoService) {
        return encrypted_organization_key_awaiter(this, void 0, void 0, function* () {
            const decValue = yield cryptoService.rsaDecrypt(this.key);
            return new SymmetricCryptoKey(decValue);
        });
    }
    toData() {
        return {
            type: "organization",
            key: this.key,
        };
    }
}
class ProviderEncryptedOrganizationKey {
    constructor(key, providerId) {
        this.key = key;
        this.providerId = providerId;
    }
    decrypt(cryptoService) {
        return encrypted_organization_key_awaiter(this, void 0, void 0, function* () {
            const providerKey = yield cryptoService.getProviderKey(this.providerId);
            const decValue = yield cryptoService.decryptToBytes(new EncString(this.key), providerKey);
            return new SymmetricCryptoKey(decValue);
        });
    }
    toData() {
        return {
            type: "provider",
            key: this.key,
            providerId: this.providerId,
        };
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/key-state/org-keys.state.ts
var org_keys_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const USER_ENCRYPTED_ORGANIZATION_KEYS = KeyDefinition.record(CRYPTO_DISK, "organizationKeys", {
    deserializer: (obj) => obj,
});
const USER_ORGANIZATION_KEYS = DeriveDefinition.from(USER_ENCRYPTED_ORGANIZATION_KEYS, {
    deserializer: (obj) => {
        const result = {};
        for (const orgId of Object.keys(obj !== null && obj !== void 0 ? obj : {})) {
            result[orgId] = SymmetricCryptoKey.fromJSON(obj[orgId]);
        }
        return result;
    },
    derive: (from, { cryptoService }) => org_keys_state_awaiter(void 0, void 0, void 0, function* () {
        const result = {};
        for (const orgId of Object.keys(from !== null && from !== void 0 ? from : {})) {
            if (result[orgId] != null) {
                continue;
            }
            const encrypted = BaseEncryptedOrganizationKey.fromData(from[orgId]);
            const decrypted = yield encrypted.decrypt(cryptoService);
            result[orgId] = decrypted;
        }
        return result;
    }),
});

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/key-state/user-key.state.ts

const USER_EVER_HAD_USER_KEY = new KeyDefinition(CRYPTO_DISK, "everHadUserKey", {
    deserializer: (obj) => obj,
});

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/crypto.service.ts
var crypto_service_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var crypto_service_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var crypto_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};










class CryptoService {
    constructor(cryptoFunctionService, encryptService, platformUtilService, logService, stateService, accountService, stateProvider) {
        this.cryptoFunctionService = cryptoFunctionService;
        this.encryptService = encryptService;
        this.platformUtilService = platformUtilService;
        this.logService = logService;
        this.stateService = stateService;
        this.accountService = accountService;
        this.stateProvider = stateProvider;
        this.activeUserEverHadUserKey = stateProvider.getActive(USER_EVER_HAD_USER_KEY);
        this.activeUserEncryptedOrgKeysState = stateProvider.getActive(USER_ENCRYPTED_ORGANIZATION_KEYS);
        this.activeUserOrgKeysState = stateProvider.getDerived(this.activeUserEncryptedOrgKeysState.state$, USER_ORGANIZATION_KEYS, { cryptoService: this });
        this.everHadUserKey$ = this.activeUserEverHadUserKey.state$.pipe((0,external_rxjs_namespaceObject.map)((x) => x !== null && x !== void 0 ? x : false));
        this.activeUserOrgKeys$ = this.activeUserOrgKeysState.state$; // null handled by `derive` function
    }
    setUserKey(key, userId) {
        var _a;
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            // TODO: make this non-nullable in signature
            userId !== null && userId !== void 0 ? userId : (userId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id);
            if (key != null) {
                // Key should never be null anyway
                yield this.stateProvider.getUser(userId, USER_EVER_HAD_USER_KEY).update(() => true);
            }
            yield this.stateService.setUserKey(key, { userId: userId });
            yield this.storeAdditionalKeys(key, userId);
        });
    }
    refreshAdditionalKeys() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const key = yield this.getUserKey();
            yield this.setUserKey(key);
        });
    }
    getUserKey(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            let userKey = yield this.stateService.getUserKey({ userId: userId });
            if (userKey) {
                return userKey;
            }
            // If the user has set their vault timeout to 'Never', we can load the user key from storage
            if (yield this.hasUserKeyStored(KeySuffixOptions.Auto, userId)) {
                userKey = yield this.getKeyFromStorage(KeySuffixOptions.Auto, userId);
                if (userKey) {
                    yield this.setUserKey(userKey, userId);
                    return userKey;
                }
            }
        });
    }
    isLegacyUser(masterKey, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return yield this.validateUserKey((masterKey !== null && masterKey !== void 0 ? masterKey : (yield this.getMasterKey(userId))));
        });
    }
    getUserKeyWithLegacySupport(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const userKey = yield this.getUserKey(userId);
            if (userKey) {
                return userKey;
            }
            // Legacy support: encryption used to be done with the master key (derived from master password).
            // Users who have not migrated will have a null user key and must use the master key instead.
            return (yield this.getMasterKey(userId));
        });
    }
    getUserKeyFromStorage(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const userKey = yield this.getKeyFromStorage(keySuffix, userId);
            if (userKey) {
                if (!(yield this.validateUserKey(userKey))) {
                    this.logService.warning("Invalid key, throwing away stored keys");
                    yield this.clearAllStoredUserKeys(userId);
                }
                return userKey;
            }
        });
    }
    hasUserKey() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return ((yield this.hasUserKeyInMemory()) || (yield this.hasUserKeyStored(KeySuffixOptions.Auto)));
        });
    }
    hasUserKeyInMemory(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.stateService.getUserKey({ userId: userId })) != null;
        });
    }
    hasUserKeyStored(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.getKeyFromStorage(keySuffix, userId)) != null;
        });
    }
    makeUserKey(masterKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            masterKey || (masterKey = yield this.getMasterKey());
            if (masterKey == null) {
                throw new Error("No Master Key found.");
            }
            const newUserKey = yield this.cryptoFunctionService.aesGenerateKey(512);
            return this.buildProtectedSymmetricKey(masterKey, newUserKey);
        });
    }
    clearUserKey(clearStoredKeys = true, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setUserKey(null, { userId: userId });
            if (clearStoredKeys) {
                yield this.clearAllStoredUserKeys(userId);
            }
        });
    }
    clearStoredUserKey(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (keySuffix === KeySuffixOptions.Auto) {
                this.stateService.setUserKeyAutoUnlock(null, { userId: userId });
                this.clearDeprecatedKeys(KeySuffixOptions.Auto, userId);
            }
            if (keySuffix === KeySuffixOptions.Pin) {
                this.stateService.setPinKeyEncryptedUserKeyEphemeral(null, { userId: userId });
                this.clearDeprecatedKeys(KeySuffixOptions.Pin, userId);
            }
        });
    }
    setMasterKeyEncryptedUserKey(userKeyMasterKey, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setMasterKeyEncryptedUserKey(userKeyMasterKey, { userId: userId });
        });
    }
    setMasterKey(key, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setMasterKey(key, { userId: userId });
        });
    }
    getMasterKey(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            let masterKey = yield this.stateService.getMasterKey({ userId: userId });
            if (!masterKey) {
                masterKey = (yield this.stateService.getCryptoMasterKey({ userId: userId }));
                // if master key was null/undefined and getCryptoMasterKey also returned null/undefined,
                // don't set master key as it is unnecessary
                if (masterKey) {
                    yield this.setMasterKey(masterKey, userId);
                }
            }
            return masterKey;
        });
    }
    getOrDeriveMasterKey(password, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            let masterKey = yield this.getMasterKey(userId);
            return (masterKey || (masterKey = yield this.makeMasterKey(password, yield this.stateService.getEmail({ userId: userId }), yield this.stateService.getKdfType({ userId: userId }), yield this.stateService.getKdfConfig({ userId: userId }))));
        });
    }
    /**
     * Derive a master key from a password and email.
     *
     * @remarks
     * Does not validate the kdf config to ensure it satisfies the minimum requirements for the given kdf type.
     */
    makeMasterKey(password, email, kdf, KdfConfig) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.makeKey(password, email, kdf, KdfConfig));
        });
    }
    clearMasterKey(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setMasterKey(null, { userId: userId });
        });
    }
    encryptUserKeyWithMasterKey(masterKey, userKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            userKey || (userKey = yield this.getUserKey());
            return yield this.buildProtectedSymmetricKey(masterKey, userKey.key);
        });
    }
    decryptUserKeyWithMasterKey(masterKey, userKey, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            masterKey || (masterKey = yield this.getMasterKey(userId));
            if (masterKey == null) {
                throw new Error("No master key found.");
            }
            if (!userKey) {
                let masterKeyEncryptedUserKey = yield this.stateService.getMasterKeyEncryptedUserKey({
                    userId: userId,
                });
                // Try one more way to get the user key if it still wasn't found.
                if (masterKeyEncryptedUserKey == null) {
                    masterKeyEncryptedUserKey = yield this.stateService.getEncryptedCryptoSymmetricKey({
                        userId: userId,
                    });
                }
                if (masterKeyEncryptedUserKey == null) {
                    throw new Error("No encrypted user key found.");
                }
                userKey = new EncString(masterKeyEncryptedUserKey);
            }
            let decUserKey;
            if (userKey.encryptionType === EncryptionType.AesCbc256_B64) {
                decUserKey = yield this.encryptService.decryptToBytes(userKey, masterKey);
            }
            else if (userKey.encryptionType === EncryptionType.AesCbc256_HmacSha256_B64) {
                const newKey = yield this.stretchKey(masterKey);
                decUserKey = yield this.encryptService.decryptToBytes(userKey, newKey);
            }
            else {
                throw new Error("Unsupported encryption type.");
            }
            if (decUserKey == null) {
                return null;
            }
            return new SymmetricCryptoKey(decUserKey);
        });
    }
    hashMasterKey(password, key, hashPurpose) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            key || (key = yield this.getMasterKey());
            if (password == null || key == null) {
                throw new Error("Invalid parameters.");
            }
            const iterations = hashPurpose === HashPurpose.LocalAuthorization ? 2 : 1;
            const hash = yield this.cryptoFunctionService.pbkdf2(key.key, password, "sha256", iterations);
            return utils_Utils.fromBufferToB64(hash);
        });
    }
    setMasterKeyHash(keyHash) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setKeyHash(keyHash);
        });
    }
    getMasterKeyHash() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getKeyHash();
        });
    }
    clearMasterKeyHash(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.setKeyHash(null, { userId: userId });
        });
    }
    compareAndUpdateKeyHash(masterPassword, masterKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const storedPasswordHash = yield this.getMasterKeyHash();
            if (masterPassword != null && storedPasswordHash != null) {
                const localKeyHash = yield this.hashMasterKey(masterPassword, masterKey, HashPurpose.LocalAuthorization);
                if (localKeyHash != null && storedPasswordHash === localKeyHash) {
                    return true;
                }
                // TODO: remove serverKeyHash check in 1-2 releases after everyone's keyHash has been updated
                const serverKeyHash = yield this.hashMasterKey(masterPassword, masterKey, HashPurpose.ServerAuthorization);
                if (serverKeyHash != null && storedPasswordHash === serverKeyHash) {
                    yield this.setMasterKeyHash(localKeyHash);
                    return true;
                }
            }
            return false;
        });
    }
    setOrgKeys(orgs = [], providerOrgs = []) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            this.activeUserEncryptedOrgKeysState.update((_) => {
                const encOrgKeyData = {};
                orgs.forEach((org) => {
                    encOrgKeyData[org.id] = {
                        type: "organization",
                        key: org.key,
                    };
                });
                providerOrgs.forEach((org) => {
                    encOrgKeyData[org.id] = {
                        type: "provider",
                        providerId: org.providerId,
                        key: org.key,
                    };
                });
                return encOrgKeyData;
            });
        });
    }
    getOrgKey(orgId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserOrgKeys$))[orgId];
        });
    }
    getOrgKeys() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            return yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserOrgKeys$);
        });
    }
    makeDataEncKey(key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No key provided");
            }
            const newSymKey = yield this.cryptoFunctionService.aesGenerateKey(512);
            return this.buildProtectedSymmetricKey(key, newSymKey);
        });
    }
    clearOrgKeys(memoryOnly, userId) {
        var _a;
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const activeUserId = (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.accountService.activeAccount$))) === null || _a === void 0 ? void 0 : _a.id;
            const userIdIsActive = userId == null || userId === activeUserId;
            if (memoryOnly && userIdIsActive) {
                // org keys are only cached for active users
                yield this.activeUserOrgKeysState.forceValue({});
            }
            else {
                if (userId == null && activeUserId == null) {
                    // nothing to do
                    return;
                }
                yield this.stateProvider
                    .getUser(userId !== null && userId !== void 0 ? userId : activeUserId, USER_ENCRYPTED_ORGANIZATION_KEYS)
                    .update(() => null);
            }
        });
    }
    setProviderKeys(providers) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const providerKeys = {};
            providers.forEach((provider) => {
                providerKeys[provider.id] = provider.key;
            });
            yield this.stateService.setDecryptedProviderKeys(null);
            return yield this.stateService.setEncryptedProviderKeys(providerKeys);
        });
    }
    getProviderKey(providerId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (providerId == null) {
                return null;
            }
            const providerKeys = yield this.getProviderKeys();
            if (providerKeys == null || !providerKeys.has(providerId)) {
                return null;
            }
            return providerKeys.get(providerId);
        });
    }
    getProviderKeys() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const providerKeys = new Map();
            const decryptedProviderKeys = yield this.stateService.getDecryptedProviderKeys();
            if (decryptedProviderKeys != null && decryptedProviderKeys.size > 0) {
                return decryptedProviderKeys;
            }
            const encProviderKeys = yield this.stateService.getEncryptedProviderKeys();
            if (encProviderKeys == null) {
                return null;
            }
            let setKey = false;
            for (const orgId in encProviderKeys) {
                // eslint-disable-next-line
                if (!encProviderKeys.hasOwnProperty(orgId)) {
                    continue;
                }
                const decValue = yield this.rsaDecrypt(encProviderKeys[orgId]);
                providerKeys.set(orgId, new SymmetricCryptoKey(decValue));
                setKey = true;
            }
            if (setKey) {
                yield this.stateService.setDecryptedProviderKeys(providerKeys);
            }
            return providerKeys;
        });
    }
    clearProviderKeys(memoryOnly, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setDecryptedProviderKeys(null, { userId: userId });
            if (!memoryOnly) {
                yield this.stateService.setEncryptedProviderKeys(null, { userId: userId });
            }
        });
    }
    getPublicKey() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const inMemoryPublicKey = yield this.stateService.getPublicKey();
            if (inMemoryPublicKey != null) {
                return inMemoryPublicKey;
            }
            const privateKey = yield this.getPrivateKey();
            if (privateKey == null) {
                return null;
            }
            const publicKey = yield this.cryptoFunctionService.rsaExtractPublicKey(privateKey);
            yield this.stateService.setPublicKey(publicKey);
            return publicKey;
        });
    }
    makeOrgKey() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const shareKey = yield this.cryptoFunctionService.aesGenerateKey(512);
            const publicKey = yield this.getPublicKey();
            const encShareKey = yield this.rsaEncrypt(shareKey, publicKey);
            return [encShareKey, new SymmetricCryptoKey(shareKey)];
        });
    }
    setPrivateKey(encPrivateKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (encPrivateKey == null) {
                return;
            }
            yield this.stateService.setDecryptedPrivateKey(null);
            yield this.stateService.setEncryptedPrivateKey(encPrivateKey);
        });
    }
    getPrivateKey() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const decryptedPrivateKey = yield this.stateService.getDecryptedPrivateKey();
            if (decryptedPrivateKey != null) {
                return decryptedPrivateKey;
            }
            const encPrivateKey = yield this.stateService.getEncryptedPrivateKey();
            if (encPrivateKey == null) {
                return null;
            }
            const privateKey = yield this.encryptService.decryptToBytes(new EncString(encPrivateKey), yield this.getUserKeyWithLegacySupport());
            yield this.stateService.setDecryptedPrivateKey(privateKey);
            return privateKey;
        });
    }
    getFingerprint(fingerprintMaterial, publicKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (publicKey == null) {
                publicKey = yield this.getPublicKey();
            }
            if (publicKey === null) {
                throw new Error("No public key available.");
            }
            const keyFingerprint = yield this.cryptoFunctionService.hash(publicKey, "sha256");
            const userFingerprint = yield this.cryptoFunctionService.hkdfExpand(keyFingerprint, fingerprintMaterial, 32, "sha256");
            return this.hashPhrase(userFingerprint);
        });
    }
    makeKeyPair(key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            // Default to user key
            key || (key = yield this.getUserKeyWithLegacySupport());
            const keyPair = yield this.cryptoFunctionService.rsaGenerateKeyPair(2048);
            const publicB64 = utils_Utils.fromBufferToB64(keyPair[0]);
            const privateEnc = yield this.encryptService.encrypt(keyPair[1], key);
            return [publicB64, privateEnc];
        });
    }
    clearKeyPair(memoryOnly, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const keysToClear = [
                this.stateService.setDecryptedPrivateKey(null, { userId: userId }),
                this.stateService.setPublicKey(null, { userId: userId }),
            ];
            if (!memoryOnly) {
                keysToClear.push(this.stateService.setEncryptedPrivateKey(null, { userId: userId }));
            }
            return Promise.all(keysToClear);
        });
    }
    makePinKey(pin, salt, kdf, kdfConfig) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const pinKey = yield this.makeKey(pin, salt, kdf, kdfConfig);
            return (yield this.stretchKey(pinKey));
        });
    }
    clearPinKeys(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setPinKeyEncryptedUserKey(null, { userId: userId });
            yield this.stateService.setPinKeyEncryptedUserKeyEphemeral(null, { userId: userId });
            yield this.stateService.setProtectedPin(null, { userId: userId });
            yield this.clearDeprecatedKeys(KeySuffixOptions.Pin, userId);
        });
    }
    decryptUserKeyWithPin(pin, salt, kdf, kdfConfig, pinProtectedUserKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            pinProtectedUserKey || (pinProtectedUserKey = yield this.stateService.getPinKeyEncryptedUserKey());
            pinProtectedUserKey || (pinProtectedUserKey = yield this.stateService.getPinKeyEncryptedUserKeyEphemeral());
            if (!pinProtectedUserKey) {
                throw new Error("No PIN protected key found.");
            }
            const pinKey = yield this.makePinKey(pin, salt, kdf, kdfConfig);
            const userKey = yield this.encryptService.decryptToBytes(pinProtectedUserKey, pinKey);
            return new SymmetricCryptoKey(userKey);
        });
    }
    // only for migration purposes
    decryptMasterKeyWithPin(pin, salt, kdf, kdfConfig, pinProtectedMasterKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (!pinProtectedMasterKey) {
                const pinProtectedMasterKeyString = yield this.stateService.getEncryptedPinProtected();
                if (pinProtectedMasterKeyString == null) {
                    throw new Error("No PIN protected key found.");
                }
                pinProtectedMasterKey = new EncString(pinProtectedMasterKeyString);
            }
            const pinKey = yield this.makePinKey(pin, salt, kdf, kdfConfig);
            const masterKey = yield this.encryptService.decryptToBytes(pinProtectedMasterKey, pinKey);
            return new SymmetricCryptoKey(masterKey);
        });
    }
    makeSendKey(keyMaterial) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const sendKey = yield this.cryptoFunctionService.hkdf(keyMaterial, "bitwarden-send", "send", 64, "sha256");
            return new SymmetricCryptoKey(sendKey);
        });
    }
    makeCipherKey() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const randomBytes = yield this.cryptoFunctionService.aesGenerateKey(512);
            return new SymmetricCryptoKey(randomBytes);
        });
    }
    clearKeys(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.clearUserKey(true, userId);
            yield this.clearMasterKeyHash(userId);
            yield this.clearOrgKeys(false, userId);
            yield this.clearProviderKeys(false, userId);
            yield this.clearKeyPair(false, userId);
            yield this.clearPinKeys(userId);
            yield this.activeUserEverHadUserKey.update(() => null);
        });
    }
    rsaEncrypt(data, publicKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (publicKey == null) {
                publicKey = yield this.getPublicKey();
            }
            if (publicKey == null) {
                throw new Error("Public key unavailable.");
            }
            const encBytes = yield this.cryptoFunctionService.rsaEncrypt(data, publicKey, "sha1");
            return new EncString(EncryptionType.Rsa2048_OaepSha1_B64, utils_Utils.fromBufferToB64(encBytes));
        });
    }
    rsaDecrypt(encValue, privateKeyValue) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const headerPieces = encValue.split(".");
            let encType = null;
            let encPieces;
            if (headerPieces.length === 1) {
                encType = EncryptionType.Rsa2048_OaepSha256_B64;
                encPieces = [headerPieces[0]];
            }
            else if (headerPieces.length === 2) {
                try {
                    encType = parseInt(headerPieces[0], null);
                    encPieces = headerPieces[1].split("|");
                }
                catch (e) {
                    this.logService.error(e);
                }
            }
            switch (encType) {
                case EncryptionType.Rsa2048_OaepSha256_B64:
                case EncryptionType.Rsa2048_OaepSha1_B64:
                case EncryptionType.Rsa2048_OaepSha256_HmacSha256_B64: // HmacSha256 types are deprecated
                case EncryptionType.Rsa2048_OaepSha1_HmacSha256_B64:
                    break;
                default:
                    throw new Error("encType unavailable.");
            }
            if (encPieces == null || encPieces.length <= 0) {
                throw new Error("encPieces unavailable.");
            }
            const data = utils_Utils.fromB64ToArray(encPieces[0]);
            const privateKey = privateKeyValue !== null && privateKeyValue !== void 0 ? privateKeyValue : (yield this.getPrivateKey());
            if (privateKey == null) {
                throw new Error("No private key.");
            }
            let alg = "sha1";
            switch (encType) {
                case EncryptionType.Rsa2048_OaepSha256_B64:
                case EncryptionType.Rsa2048_OaepSha256_HmacSha256_B64:
                    alg = "sha256";
                    break;
                case EncryptionType.Rsa2048_OaepSha1_B64:
                case EncryptionType.Rsa2048_OaepSha1_HmacSha256_B64:
                    break;
                default:
                    throw new Error("encType unavailable.");
            }
            return this.cryptoFunctionService.rsaDecrypt(data, privateKey, alg);
        });
    }
    // EFForg/OpenWireless
    // ref https://github.com/EFForg/OpenWireless/blob/master/app/js/diceware.js
    randomNumber(min, max) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            let rval = 0;
            const range = max - min + 1;
            const bitsNeeded = Math.ceil(Math.log2(range));
            if (bitsNeeded > 53) {
                throw new Error("We cannot generate numbers larger than 53 bits.");
            }
            const bytesNeeded = Math.ceil(bitsNeeded / 8);
            const mask = Math.pow(2, bitsNeeded) - 1;
            // 7776 -> (2^13 = 8192) -1 == 8191 or 0x00001111 11111111
            // Fill a byte array with N random numbers
            const byteArray = new Uint8Array(yield this.cryptoFunctionService.randomBytes(bytesNeeded));
            let p = (bytesNeeded - 1) * 8;
            for (let i = 0; i < bytesNeeded; i++) {
                rval += byteArray[i] * Math.pow(2, p);
                p -= 8;
            }
            // Use & to apply the mask and reduce the number of recursive lookups
            rval = rval & mask;
            if (rval >= range) {
                // Integer out of acceptable range
                return this.randomNumber(min, max);
            }
            // Return an integer that falls within the range
            return min + rval;
        });
    }
    // ---HELPERS---
    validateUserKey(key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (!key) {
                return false;
            }
            try {
                const encPrivateKey = yield this.stateService.getEncryptedPrivateKey();
                if (encPrivateKey == null) {
                    return false;
                }
                const privateKey = yield this.encryptService.decryptToBytes(new EncString(encPrivateKey), key);
                yield this.cryptoFunctionService.rsaExtractPublicKey(privateKey);
            }
            catch (e) {
                return false;
            }
            return true;
        });
    }
    /**
     * Initialize all necessary crypto keys needed for a new account.
     * Warning! This completely replaces any existing keys!
     */
    initAccount() {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const rawKey = yield this.cryptoFunctionService.aesGenerateKey(512);
            const userKey = new SymmetricCryptoKey(rawKey);
            const [publicKey, privateKey] = yield this.makeKeyPair(userKey);
            yield this.setUserKey(userKey);
            yield this.stateService.setEncryptedPrivateKey(privateKey.encryptedString);
            return {
                userKey,
                publicKey,
                privateKey,
            };
        });
    }
    /**
     * Generates any additional keys if needed. Additional keys are
     * keys such as biometrics, auto, and pin keys.
     * Useful to make sure other keys stay in sync when the user key
     * has been rotated.
     * @param key The user key
     * @param userId The desired user
     */
    storeAdditionalKeys(key, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const storeAuto = yield this.shouldStoreKey(KeySuffixOptions.Auto, userId);
            if (storeAuto) {
                yield this.stateService.setUserKeyAutoUnlock(key.keyB64, { userId: userId });
            }
            else {
                yield this.stateService.setUserKeyAutoUnlock(null, { userId: userId });
            }
            yield this.clearDeprecatedKeys(KeySuffixOptions.Auto, userId);
            const storePin = yield this.shouldStoreKey(KeySuffixOptions.Pin, userId);
            if (storePin) {
                yield this.storePinKey(key, userId);
                // We can't always clear deprecated keys because the pin is only
                // migrated once used to unlock
                yield this.clearDeprecatedKeys(KeySuffixOptions.Pin, userId);
            }
            else {
                yield this.stateService.setPinKeyEncryptedUserKey(null, { userId: userId });
                yield this.stateService.setPinKeyEncryptedUserKeyEphemeral(null, { userId: userId });
            }
        });
    }
    /**
     * Stores the pin key if needed. If MP on Reset is enabled, stores the
     * ephemeral version.
     * @param key The user key
     */
    storePinKey(key, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const pin = yield this.encryptService.decryptToUtf8(new EncString(yield this.stateService.getProtectedPin({ userId: userId })), key);
            const pinKey = yield this.makePinKey(pin, yield this.stateService.getEmail({ userId: userId }), yield this.stateService.getKdfType({ userId: userId }), yield this.stateService.getKdfConfig({ userId: userId }));
            const encPin = yield this.encryptService.encrypt(key.key, pinKey);
            if ((yield this.stateService.getPinKeyEncryptedUserKey({ userId: userId })) != null) {
                yield this.stateService.setPinKeyEncryptedUserKey(encPin, { userId: userId });
            }
            else {
                yield this.stateService.setPinKeyEncryptedUserKeyEphemeral(encPin, { userId: userId });
            }
        });
    }
    shouldStoreKey(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            let shouldStoreKey = false;
            switch (keySuffix) {
                case KeySuffixOptions.Auto: {
                    const vaultTimeout = yield this.stateService.getVaultTimeout({ userId: userId });
                    shouldStoreKey = vaultTimeout == null;
                    break;
                }
                case KeySuffixOptions.Pin: {
                    const protectedPin = yield this.stateService.getProtectedPin({ userId: userId });
                    shouldStoreKey = !!protectedPin;
                    break;
                }
            }
            return shouldStoreKey;
        });
    }
    getKeyFromStorage(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (keySuffix === KeySuffixOptions.Auto) {
                const userKey = yield this.stateService.getUserKeyAutoUnlock({ userId: userId });
                if (userKey) {
                    return new SymmetricCryptoKey(utils_Utils.fromB64ToArray(userKey));
                }
            }
            return null;
        });
    }
    /**
     * Validate that the KDF config follows the requirements for the given KDF type.
     *
     * @remarks
     * Should always be called before updating a users KDF config.
     */
    validateKdfConfig(kdf, kdfConfig) {
        switch (kdf) {
            case KdfType.PBKDF2_SHA256:
                if (!PBKDF2_ITERATIONS.inRange(kdfConfig.iterations)) {
                    throw new Error(`PBKDF2 iterations must be between ${PBKDF2_ITERATIONS.min} and ${PBKDF2_ITERATIONS.max}`);
                }
                break;
            case KdfType.Argon2id:
                if (!ARGON2_ITERATIONS.inRange(kdfConfig.iterations)) {
                    throw new Error(`Argon2 iterations must be between ${ARGON2_ITERATIONS.min} and ${ARGON2_ITERATIONS.max}`);
                }
                if (!ARGON2_MEMORY.inRange(kdfConfig.memory)) {
                    throw new Error(`Argon2 memory must be between ${ARGON2_MEMORY.min}mb and ${ARGON2_MEMORY.max}mb`);
                }
                if (!ARGON2_PARALLELISM.inRange(kdfConfig.parallelism)) {
                    throw new Error(`Argon2 parallelism must be between ${ARGON2_PARALLELISM.min} and ${ARGON2_PARALLELISM.max}.`);
                }
                break;
        }
    }
    clearAllStoredUserKeys(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setUserKeyAutoUnlock(null, { userId: userId });
            yield this.stateService.setPinKeyEncryptedUserKeyEphemeral(null, { userId: userId });
        });
    }
    stretchKey(key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const newKey = new Uint8Array(64);
            const encKey = yield this.cryptoFunctionService.hkdfExpand(key.key, "enc", 32, "sha256");
            const macKey = yield this.cryptoFunctionService.hkdfExpand(key.key, "mac", 32, "sha256");
            newKey.set(new Uint8Array(encKey));
            newKey.set(new Uint8Array(macKey), 32);
            return new SymmetricCryptoKey(newKey);
        });
    }
    hashPhrase(hash, minimumEntropy = 64) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const entropyPerWord = Math.log(EFFLongWordList.length) / Math.log(2);
            let numWords = Math.ceil(minimumEntropy / entropyPerWord);
            const hashArr = Array.from(new Uint8Array(hash));
            const entropyAvailable = hashArr.length * 4;
            if (numWords * entropyPerWord > entropyAvailable) {
                throw new Error("Output entropy of hash function is too small");
            }
            const phrase = [];
            let hashNumber = external_big_integer_namespaceObject.fromArray(hashArr, 256);
            while (numWords--) {
                const remainder = hashNumber.mod(EFFLongWordList.length);
                hashNumber = hashNumber.divide(EFFLongWordList.length);
                phrase.push(EFFLongWordList[remainder]);
            }
            return phrase;
        });
    }
    buildProtectedSymmetricKey(encryptionKey, newSymKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            let protectedSymKey = null;
            if (encryptionKey.key.byteLength === 32) {
                const stretchedEncryptionKey = yield this.stretchKey(encryptionKey);
                protectedSymKey = yield this.encryptService.encrypt(newSymKey, stretchedEncryptionKey);
            }
            else if (encryptionKey.key.byteLength === 64) {
                protectedSymKey = yield this.encryptService.encrypt(newSymKey, encryptionKey);
            }
            else {
                throw new Error("Invalid key size.");
            }
            return [new SymmetricCryptoKey(newSymKey), protectedSymKey];
        });
    }
    makeKey(password, salt, kdf, kdfConfig) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            let key = null;
            if (kdf == null || kdf === KdfType.PBKDF2_SHA256) {
                if (kdfConfig.iterations == null) {
                    kdfConfig.iterations = PBKDF2_ITERATIONS.defaultValue;
                }
                key = yield this.cryptoFunctionService.pbkdf2(password, salt, "sha256", kdfConfig.iterations);
            }
            else if (kdf == KdfType.Argon2id) {
                if (kdfConfig.iterations == null) {
                    kdfConfig.iterations = ARGON2_ITERATIONS.defaultValue;
                }
                if (kdfConfig.memory == null) {
                    kdfConfig.memory = ARGON2_MEMORY.defaultValue;
                }
                if (kdfConfig.parallelism == null) {
                    kdfConfig.parallelism = ARGON2_PARALLELISM.defaultValue;
                }
                const saltHash = yield this.cryptoFunctionService.hash(salt, "sha256");
                key = yield this.cryptoFunctionService.argon2(password, saltHash, kdfConfig.iterations, kdfConfig.memory * 1024, // convert to KiB from MiB
                kdfConfig.parallelism);
            }
            else {
                throw new Error("Unknown Kdf.");
            }
            return new SymmetricCryptoKey(key);
        });
    }
    // --LEGACY METHODS--
    // We previously used the master key for additional keys, but now we use the user key.
    // These methods support migrating the old keys to the new ones.
    // TODO: Remove after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3475)
    clearDeprecatedKeys(keySuffix, userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (keySuffix === KeySuffixOptions.Auto) {
                yield this.stateService.setCryptoMasterKeyAuto(null, { userId: userId });
            }
            else if (keySuffix === KeySuffixOptions.Pin) {
                yield this.stateService.setEncryptedPinProtected(null, { userId: userId });
                yield this.stateService.setDecryptedPinProtected(null, { userId: userId });
            }
        });
    }
    migrateAutoKeyIfNeeded(userId) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            const oldAutoKey = yield this.stateService.getCryptoMasterKeyAuto({ userId: userId });
            if (!oldAutoKey) {
                return;
            }
            // Decrypt
            const masterKey = new SymmetricCryptoKey(utils_Utils.fromB64ToArray(oldAutoKey));
            if (yield this.isLegacyUser(masterKey, userId)) {
                // Legacy users don't have a user key, so no need to migrate.
                // Instead, set the master key for additional isLegacyUser checks that will log the user out.
                yield this.setMasterKey(masterKey, userId);
                return;
            }
            const encryptedUserKey = yield this.stateService.getEncryptedCryptoSymmetricKey({
                userId: userId,
            });
            const userKey = yield this.decryptUserKeyWithMasterKey(masterKey, new EncString(encryptedUserKey), userId);
            // Migrate
            yield this.stateService.setUserKeyAutoUnlock(userKey.keyB64, { userId: userId });
            yield this.stateService.setCryptoMasterKeyAuto(null, { userId: userId });
            // Set encrypted user key in case user immediately locks without syncing
            yield this.setMasterKeyEncryptedUserKey(encryptedUserKey);
        });
    }
    decryptAndMigrateOldPinKey(masterPasswordOnRestart, pin, email, kdf, kdfConfig, oldPinKey) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            // Decrypt
            const masterKey = yield this.decryptMasterKeyWithPin(pin, email, kdf, kdfConfig, oldPinKey);
            const encUserKey = yield this.stateService.getEncryptedCryptoSymmetricKey();
            const userKey = yield this.decryptUserKeyWithMasterKey(masterKey, new EncString(encUserKey));
            // Migrate
            const pinKey = yield this.makePinKey(pin, email, kdf, kdfConfig);
            const pinProtectedKey = yield this.encryptService.encrypt(userKey.key, pinKey);
            if (masterPasswordOnRestart) {
                yield this.stateService.setDecryptedPinProtected(null);
                yield this.stateService.setPinKeyEncryptedUserKeyEphemeral(pinProtectedKey);
            }
            else {
                yield this.stateService.setEncryptedPinProtected(null);
                yield this.stateService.setPinKeyEncryptedUserKey(pinProtectedKey);
                // We previously only set the protected pin if MP on Restart was enabled
                // now we set it regardless
                const encPin = yield this.encryptService.encrypt(pin, userKey);
                yield this.stateService.setProtectedPin(encPin.encryptedString);
            }
            // This also clears the old Biometrics key since the new Biometrics key will
            // be created when the user key is set.
            yield this.stateService.setCryptoMasterKeyBiometric(null);
            return userKey;
        });
    }
    // --DEPRECATED METHODS--
    /**
     * @deprecated July 25 2022: Get the key you need from CryptoService (getKeyForUserEncryption or getOrgKey)
     * and then call encryptService.encrypt
     */
    encrypt(plainValue, key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            key || (key = yield this.getUserKeyWithLegacySupport());
            return yield this.encryptService.encrypt(plainValue, key);
        });
    }
    /**
     * @deprecated July 25 2022: Get the key you need from CryptoService (getKeyForUserEncryption or getOrgKey)
     * and then call encryptService.encryptToBytes
     */
    encryptToBytes(plainValue, key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            key || (key = yield this.getUserKeyWithLegacySupport());
            return this.encryptService.encryptToBytes(plainValue, key);
        });
    }
    /**
     * @deprecated July 25 2022: Get the key you need from CryptoService (getKeyForUserEncryption or getOrgKey)
     * and then call encryptService.decryptToBytes
     */
    decryptToBytes(encString, key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            key || (key = yield this.getUserKeyWithLegacySupport());
            return this.encryptService.decryptToBytes(encString, key);
        });
    }
    /**
     * @deprecated July 25 2022: Get the key you need from CryptoService (getKeyForUserEncryption or getOrgKey)
     * and then call encryptService.decryptToUtf8
     */
    decryptToUtf8(encString, key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            key || (key = yield this.getUserKeyWithLegacySupport());
            return yield this.encryptService.decryptToUtf8(encString, key);
        });
    }
    /**
     * @deprecated July 25 2022: Get the key you need from CryptoService (getKeyForUserEncryption or getOrgKey)
     * and then call encryptService.decryptToBytes
     */
    decryptFromBytes(encBuffer, key) {
        return crypto_service_awaiter(this, void 0, void 0, function* () {
            if (encBuffer == null) {
                throw new Error("No buffer provided for decryption.");
            }
            key || (key = yield this.getUserKeyWithLegacySupport());
            return this.encryptService.decryptToBytes(encBuffer, key);
        });
    }
}
crypto_service_decorate([
    sequentialize(() => "getOrgKeys"),
    crypto_service_metadata("design:type", Function),
    crypto_service_metadata("design:paramtypes", []),
    crypto_service_metadata("design:returntype", Promise)
], CryptoService.prototype, "getOrgKeys", null);
crypto_service_decorate([
    sequentialize(() => "getProviderKeys"),
    crypto_service_metadata("design:type", Function),
    crypto_service_metadata("design:paramtypes", []),
    crypto_service_metadata("design:returntype", Promise)
], CryptoService.prototype, "getProviderKeys", null);

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/enc-array-buffer.ts
var enc_array_buffer_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const ENC_TYPE_LENGTH = 1;
const IV_LENGTH = 16;
const MAC_LENGTH = 32;
const MIN_DATA_LENGTH = 1;
class EncArrayBuffer {
    constructor(buffer) {
        this.buffer = buffer;
        this.encryptionType = null;
        this.dataBytes = null;
        this.ivBytes = null;
        this.macBytes = null;
        const encBytes = buffer;
        const encType = encBytes[0];
        switch (encType) {
            case EncryptionType.AesCbc128_HmacSha256_B64:
            case EncryptionType.AesCbc256_HmacSha256_B64: {
                const minimumLength = ENC_TYPE_LENGTH + IV_LENGTH + MAC_LENGTH + MIN_DATA_LENGTH;
                if (encBytes.length < minimumLength) {
                    this.throwDecryptionError();
                }
                this.ivBytes = encBytes.slice(ENC_TYPE_LENGTH, ENC_TYPE_LENGTH + IV_LENGTH);
                this.macBytes = encBytes.slice(ENC_TYPE_LENGTH + IV_LENGTH, ENC_TYPE_LENGTH + IV_LENGTH + MAC_LENGTH);
                this.dataBytes = encBytes.slice(ENC_TYPE_LENGTH + IV_LENGTH + MAC_LENGTH);
                break;
            }
            case EncryptionType.AesCbc256_B64: {
                const minimumLength = ENC_TYPE_LENGTH + IV_LENGTH + MIN_DATA_LENGTH;
                if (encBytes.length < minimumLength) {
                    this.throwDecryptionError();
                }
                this.ivBytes = encBytes.slice(ENC_TYPE_LENGTH, ENC_TYPE_LENGTH + IV_LENGTH);
                this.dataBytes = encBytes.slice(ENC_TYPE_LENGTH + IV_LENGTH);
                break;
            }
            default:
                this.throwDecryptionError();
        }
        this.encryptionType = encType;
    }
    throwDecryptionError() {
        throw new Error("Error parsing encrypted ArrayBuffer: data is corrupted or has an invalid format.");
    }
    static fromResponse(response) {
        return enc_array_buffer_awaiter(this, void 0, void 0, function* () {
            const buffer = yield response.arrayBuffer();
            if (buffer == null) {
                throw new Error("Cannot create EncArrayBuffer from Response - Response is empty");
            }
            return new EncArrayBuffer(new Uint8Array(buffer));
        });
    }
    static fromB64(b64) {
        const buffer = utils_Utils.fromB64ToArray(b64);
        return new EncArrayBuffer(buffer);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/encrypted-object.ts
class EncryptedObject {
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/cryptography/encrypt.service.implementation.ts
var encrypt_service_implementation_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






class EncryptServiceImplementation {
    constructor(cryptoFunctionService, logService, logMacFailures) {
        this.cryptoFunctionService = cryptoFunctionService;
        this.logService = logService;
        this.logMacFailures = logMacFailures;
    }
    encrypt(plainValue, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No encryption key provided.");
            }
            if (plainValue == null) {
                return Promise.resolve(null);
            }
            let plainBuf;
            if (typeof plainValue === "string") {
                plainBuf = utils_Utils.fromUtf8ToArray(plainValue);
            }
            else {
                plainBuf = plainValue;
            }
            const encObj = yield this.aesEncrypt(plainBuf, key);
            const iv = utils_Utils.fromBufferToB64(encObj.iv);
            const data = utils_Utils.fromBufferToB64(encObj.data);
            const mac = encObj.mac != null ? utils_Utils.fromBufferToB64(encObj.mac) : null;
            return new EncString(encObj.key.encType, data, iv, mac);
        });
    }
    encryptToBytes(plainValue, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No encryption key provided.");
            }
            const encValue = yield this.aesEncrypt(plainValue, key);
            let macLen = 0;
            if (encValue.mac != null) {
                macLen = encValue.mac.byteLength;
            }
            const encBytes = new Uint8Array(1 + encValue.iv.byteLength + macLen + encValue.data.byteLength);
            encBytes.set([encValue.key.encType]);
            encBytes.set(new Uint8Array(encValue.iv), 1);
            if (encValue.mac != null) {
                encBytes.set(new Uint8Array(encValue.mac), 1 + encValue.iv.byteLength);
            }
            encBytes.set(new Uint8Array(encValue.data), 1 + encValue.iv.byteLength + macLen);
            return new EncArrayBuffer(encBytes);
        });
    }
    decryptToUtf8(encString, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No key provided for decryption.");
            }
            key = this.resolveLegacyKey(key, encString);
            if (key.macKey != null && (encString === null || encString === void 0 ? void 0 : encString.mac) == null) {
                this.logService.error("mac required.");
                return null;
            }
            if (key.encType !== encString.encryptionType) {
                this.logService.error("encType unavailable.");
                return null;
            }
            const fastParams = this.cryptoFunctionService.aesDecryptFastParameters(encString.data, encString.iv, encString.mac, key);
            if (fastParams.macKey != null && fastParams.mac != null) {
                const computedMac = yield this.cryptoFunctionService.hmacFast(fastParams.macData, fastParams.macKey, "sha256");
                const macsEqual = yield this.cryptoFunctionService.compareFast(fastParams.mac, computedMac);
                if (!macsEqual) {
                    this.logMacFailed("mac failed.");
                    return null;
                }
            }
            return yield this.cryptoFunctionService.aesDecryptFast(fastParams, "cbc");
        });
    }
    decryptToBytes(encThing, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (key == null) {
                throw new Error("No encryption key provided.");
            }
            if (encThing == null) {
                throw new Error("Nothing provided for decryption.");
            }
            key = this.resolveLegacyKey(key, encThing);
            if (key.macKey != null && encThing.macBytes == null) {
                return null;
            }
            if (key.encType !== encThing.encryptionType) {
                return null;
            }
            if (key.macKey != null && encThing.macBytes != null) {
                const macData = new Uint8Array(encThing.ivBytes.byteLength + encThing.dataBytes.byteLength);
                macData.set(new Uint8Array(encThing.ivBytes), 0);
                macData.set(new Uint8Array(encThing.dataBytes), encThing.ivBytes.byteLength);
                const computedMac = yield this.cryptoFunctionService.hmac(macData, key.macKey, "sha256");
                if (computedMac === null) {
                    return null;
                }
                const macsMatch = yield this.cryptoFunctionService.compare(encThing.macBytes, computedMac);
                if (!macsMatch) {
                    this.logMacFailed("mac failed.");
                    return null;
                }
            }
            const result = yield this.cryptoFunctionService.aesDecrypt(encThing.dataBytes, encThing.ivBytes, key.encKey, "cbc");
            return result !== null && result !== void 0 ? result : null;
        });
    }
    decryptItems(items, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            if (items == null || items.length < 1) {
                return [];
            }
            // don't use promise.all because this task is not io bound
            const results = [];
            for (let i = 0; i < items.length; i++) {
                results.push(yield items[i].decrypt(key));
            }
            return results;
        });
    }
    hash(value, algorithm) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            const hashArray = yield this.cryptoFunctionService.hash(value, algorithm);
            return utils_Utils.fromBufferToB64(hashArray);
        });
    }
    aesEncrypt(data, key) {
        return encrypt_service_implementation_awaiter(this, void 0, void 0, function* () {
            const obj = new EncryptedObject();
            obj.key = key;
            obj.iv = yield this.cryptoFunctionService.randomBytes(16);
            obj.data = yield this.cryptoFunctionService.aesEncrypt(data, obj.iv, obj.key.encKey);
            if (obj.key.macKey != null) {
                const macData = new Uint8Array(obj.iv.byteLength + obj.data.byteLength);
                macData.set(new Uint8Array(obj.iv), 0);
                macData.set(new Uint8Array(obj.data), obj.iv.byteLength);
                obj.mac = yield this.cryptoFunctionService.hmac(macData, obj.key.macKey, "sha256");
            }
            return obj;
        });
    }
    logMacFailed(msg) {
        if (this.logMacFailures) {
            this.logService.error(msg);
        }
    }
    /**
     * Transform into new key for the old encrypt-then-mac scheme if required, otherwise return the current key unchanged
     * @param encThing The encrypted object (e.g. encString or encArrayBuffer) that you want to decrypt
     */
    resolveLegacyKey(key, encThing) {
        if (encThing.encryptionType === EncryptionType.AesCbc128_HmacSha256_B64 &&
            key.encType === EncryptionType.AesCbc256_B64) {
            return new SymmetricCryptoKey(key.key, EncryptionType.AesCbc128_HmacSha256_B64);
        }
        return key;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/auth/models/domain/environment-urls.ts
class EnvironmentUrls {
    constructor() {
        this.base = null;
        this.api = null;
        this.identity = null;
        this.icons = null;
        this.notifications = null;
        this.events = null;
        this.webVault = null;
        this.keyConnector = null;
    }
    static fromJSON(obj) {
        return Object.assign(new EnvironmentUrls(), obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/abstractions/environment.service.ts
var Region;
(function (Region) {
    Region["US"] = "US";
    Region["EU"] = "EU";
    Region["SelfHosted"] = "Self-hosted";
})(Region || (Region = {}));
var RegionDomain;
(function (RegionDomain) {
    RegionDomain["US"] = "bitwarden.com";
    RegionDomain["EU"] = "bitwarden.eu";
    RegionDomain["USQA"] = "bitwarden.pw";
})(RegionDomain || (RegionDomain = {}));
class EnvironmentService {
    constructor() {
        this.initialized = true;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/environment.service.ts
var environment_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





const REGION_KEY = new KeyDefinition(ENVIRONMENT_DISK, "region", {
    deserializer: (s) => s,
});
const URLS_KEY = new KeyDefinition(ENVIRONMENT_DISK, "urls", {
    deserializer: EnvironmentUrls.fromJSON,
});
class environment_service_EnvironmentService {
    constructor(stateProvider, accountService) {
        this.stateProvider = stateProvider;
        this.accountService = accountService;
        this.urlsSubject = new external_rxjs_namespaceObject.ReplaySubject(1);
        this.urls = this.urlsSubject.asObservable();
        this.initialized = false;
        this.scimUrl = null;
        this.usUrls = {
            base: null,
            api: "https://api.bitwarden.com",
            identity: "https://identity.bitwarden.com",
            icons: "https://icons.bitwarden.net",
            webVault: "https://vault.bitwarden.com",
            notifications: "https://notifications.bitwarden.com",
            events: "https://events.bitwarden.com",
            scim: "https://scim.bitwarden.com",
        };
        this.euUrls = {
            base: null,
            api: "https://api.bitwarden.eu",
            identity: "https://identity.bitwarden.eu",
            icons: "https://icons.bitwarden.eu",
            webVault: "https://vault.bitwarden.eu",
            notifications: "https://notifications.bitwarden.eu",
            events: "https://events.bitwarden.eu",
            scim: "https://scim.bitwarden.eu",
        };
        // We intentionally don't want the helper on account service, we want the null back if there is no active user
        this.activeAccountId$ = this.accountService.activeAccount$.pipe((0,external_rxjs_namespaceObject.map)((a) => a === null || a === void 0 ? void 0 : a.id));
        // TODO: Get rid of early subscription during EnvironmentService refactor
        this.activeAccountId$
            .pipe(
        // Use == here to not trigger on undefined -> null transition
        (0,external_rxjs_namespaceObject.distinctUntilChanged)((oldUserId, newUserId) => oldUserId == newUserId), (0,external_rxjs_namespaceObject.concatMap)(() => environment_service_awaiter(this, void 0, void 0, function* () {
            if (!this.initialized) {
                return;
            }
            yield this.setUrlsFromStorage();
        })))
            .subscribe();
        this.regionGlobalState = this.stateProvider.getGlobal(REGION_KEY);
        this.urlsGlobalState = this.stateProvider.getGlobal(URLS_KEY);
    }
    hasBaseUrl() {
        return this.baseUrl != null;
    }
    getNotificationsUrl() {
        if (this.notificationsUrl != null) {
            return this.notificationsUrl;
        }
        if (this.baseUrl != null) {
            return this.baseUrl + "/notifications";
        }
        return "https://notifications.bitwarden.com";
    }
    getWebVaultUrl() {
        if (this.webVaultUrl != null) {
            return this.webVaultUrl;
        }
        if (this.baseUrl) {
            return this.baseUrl;
        }
        return "https://vault.bitwarden.com";
    }
    getCloudWebVaultUrl() {
        if (this.cloudWebVaultUrl != null) {
            return this.cloudWebVaultUrl;
        }
        return this.usUrls.webVault;
    }
    setCloudWebVaultUrl(region) {
        switch (region) {
            case Region.EU:
                this.cloudWebVaultUrl = this.euUrls.webVault;
                break;
            case Region.US:
            default:
                this.cloudWebVaultUrl = this.usUrls.webVault;
                break;
        }
    }
    getSendUrl() {
        return this.getWebVaultUrl() === "https://vault.bitwarden.com"
            ? "https://send.bitwarden.com/#"
            : this.getWebVaultUrl() + "/#/send/";
    }
    getIconsUrl() {
        if (this.iconsUrl != null) {
            return this.iconsUrl;
        }
        if (this.baseUrl) {
            return this.baseUrl + "/icons";
        }
        return "https://icons.bitwarden.net";
    }
    getApiUrl() {
        if (this.apiUrl != null) {
            return this.apiUrl;
        }
        if (this.baseUrl) {
            return this.baseUrl + "/api";
        }
        return "https://api.bitwarden.com";
    }
    getIdentityUrl() {
        if (this.identityUrl != null) {
            return this.identityUrl;
        }
        if (this.baseUrl) {
            return this.baseUrl + "/identity";
        }
        return "https://identity.bitwarden.com";
    }
    getEventsUrl() {
        if (this.eventsUrl != null) {
            return this.eventsUrl;
        }
        if (this.baseUrl) {
            return this.baseUrl + "/events";
        }
        return "https://events.bitwarden.com";
    }
    getKeyConnectorUrl() {
        return this.keyConnectorUrl;
    }
    getScimUrl() {
        if (this.scimUrl != null) {
            return this.scimUrl + "/v2";
        }
        return this.getWebVaultUrl() === "https://vault.bitwarden.com"
            ? "https://scim.bitwarden.com/v2"
            : this.getWebVaultUrl() + "/scim/v2";
    }
    setUrlsFromStorage() {
        return environment_service_awaiter(this, void 0, void 0, function* () {
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeAccountId$);
            const region = yield this.getRegion(activeUserId);
            const savedUrls = yield this.getEnvironmentUrls(activeUserId);
            const envUrls = new EnvironmentUrls();
            // In release `2023.5.0`, we set the `base` property of the environment URLs to the US web vault URL when a user clicked the "US" region.
            // This check will detect these cases and convert them to the proper region instead.
            // We are detecting this by checking for the presence of the web vault URL in the `base` and the absence of the `notifications` property.
            // This is because the `notifications` will not be `null` in the web vault, and we don't want to migrate the URLs in that case.
            if (savedUrls.base === "https://vault.bitwarden.com" && savedUrls.notifications == null) {
                yield this.setRegion(Region.US);
                return;
            }
            switch (region) {
                case Region.EU:
                    yield this.setRegion(Region.EU);
                    return;
                case Region.US:
                    yield this.setRegion(Region.US);
                    return;
                case Region.SelfHosted:
                case null:
                default:
                    this.baseUrl = envUrls.base = savedUrls.base;
                    this.webVaultUrl = savedUrls.webVault;
                    this.apiUrl = envUrls.api = savedUrls.api;
                    this.identityUrl = envUrls.identity = savedUrls.identity;
                    this.iconsUrl = savedUrls.icons;
                    this.notificationsUrl = savedUrls.notifications;
                    this.eventsUrl = envUrls.events = savedUrls.events;
                    this.keyConnectorUrl = savedUrls.keyConnector;
                    yield this.setRegion(Region.SelfHosted);
                    // scimUrl is not saved to storage
                    this.urlsSubject.next();
                    break;
            }
        });
    }
    setUrls(urls) {
        var _a;
        return environment_service_awaiter(this, void 0, void 0, function* () {
            urls.base = this.formatUrl(urls.base);
            urls.webVault = this.formatUrl(urls.webVault);
            urls.api = this.formatUrl(urls.api);
            urls.identity = this.formatUrl(urls.identity);
            urls.icons = this.formatUrl(urls.icons);
            urls.notifications = this.formatUrl(urls.notifications);
            urls.events = this.formatUrl(urls.events);
            urls.keyConnector = this.formatUrl(urls.keyConnector);
            // scimUrl cannot be cleared
            urls.scim = (_a = this.formatUrl(urls.scim)) !== null && _a !== void 0 ? _a : this.scimUrl;
            // Don't save scim url
            yield this.urlsGlobalState.update(() => ({
                base: urls.base,
                api: urls.api,
                identity: urls.identity,
                webVault: urls.webVault,
                icons: urls.icons,
                notifications: urls.notifications,
                events: urls.events,
                keyConnector: urls.keyConnector,
            }));
            this.baseUrl = urls.base;
            this.webVaultUrl = urls.webVault;
            this.apiUrl = urls.api;
            this.identityUrl = urls.identity;
            this.iconsUrl = urls.icons;
            this.notificationsUrl = urls.notifications;
            this.eventsUrl = urls.events;
            this.keyConnectorUrl = urls.keyConnector;
            this.scimUrl = urls.scim;
            yield this.setRegion(Region.SelfHosted);
            this.urlsSubject.next();
            return urls;
        });
    }
    getUrls() {
        return {
            base: this.baseUrl,
            webVault: this.webVaultUrl,
            cloudWebVault: this.cloudWebVaultUrl,
            api: this.apiUrl,
            identity: this.identityUrl,
            icons: this.iconsUrl,
            notifications: this.notificationsUrl,
            events: this.eventsUrl,
            keyConnector: this.keyConnectorUrl,
            scim: this.scimUrl,
        };
    }
    isEmpty() {
        return (this.baseUrl == null &&
            this.webVaultUrl == null &&
            this.apiUrl == null &&
            this.identityUrl == null &&
            this.iconsUrl == null &&
            this.notificationsUrl == null &&
            this.eventsUrl == null);
    }
    getHost(userId) {
        return environment_service_awaiter(this, void 0, void 0, function* () {
            const region = yield this.getRegion(userId);
            switch (region) {
                case Region.US:
                    return RegionDomain.US;
                case Region.EU:
                    return RegionDomain.EU;
                default: {
                    // Environment is self-hosted
                    const envUrls = yield this.getEnvironmentUrls(userId);
                    return utils_Utils.getHost(envUrls.webVault || envUrls.base);
                }
            }
        });
    }
    getRegion(userId) {
        return environment_service_awaiter(this, void 0, void 0, function* () {
            // Previous rules dictated that we only get from user scoped state if there is an active user.
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeAccountId$);
            return activeUserId == null
                ? yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.regionGlobalState.state$)
                : yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUser(userId !== null && userId !== void 0 ? userId : activeUserId, REGION_KEY).state$);
        });
    }
    getEnvironmentUrls(userId) {
        var _a, _b;
        return environment_service_awaiter(this, void 0, void 0, function* () {
            return userId == null
                ? (_a = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.urlsGlobalState.state$))) !== null && _a !== void 0 ? _a : new EnvironmentUrls()
                : (_b = (yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateProvider.getUser(userId, URLS_KEY).state$))) !== null && _b !== void 0 ? _b : new EnvironmentUrls();
        });
    }
    setRegion(region) {
        return environment_service_awaiter(this, void 0, void 0, function* () {
            this.selectedRegion = region;
            yield this.regionGlobalState.update(() => region);
            if (region === Region.SelfHosted) {
                // If user saves a self-hosted region with empty fields, default to US
                if (this.isEmpty()) {
                    yield this.setRegion(Region.US);
                }
            }
            else {
                // If we are setting the region to EU or US, clear the self-hosted URLs
                yield this.urlsGlobalState.update(() => new EnvironmentUrls());
                if (region === Region.EU) {
                    this.setUrlsInternal(this.euUrls);
                }
                else if (region === Region.US) {
                    this.setUrlsInternal(this.usUrls);
                }
            }
        });
    }
    seedUserEnvironment(userId) {
        return environment_service_awaiter(this, void 0, void 0, function* () {
            const globalRegion = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.regionGlobalState.state$);
            const globalUrls = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.urlsGlobalState.state$);
            yield this.stateProvider.getUser(userId, REGION_KEY).update(() => globalRegion);
            yield this.stateProvider.getUser(userId, URLS_KEY).update(() => globalUrls);
        });
    }
    setUrlsInternal(urls) {
        var _a;
        this.baseUrl = this.formatUrl(urls.base);
        this.webVaultUrl = this.formatUrl(urls.webVault);
        this.apiUrl = this.formatUrl(urls.api);
        this.identityUrl = this.formatUrl(urls.identity);
        this.iconsUrl = this.formatUrl(urls.icons);
        this.notificationsUrl = this.formatUrl(urls.notifications);
        this.eventsUrl = this.formatUrl(urls.events);
        this.keyConnectorUrl = this.formatUrl(urls.keyConnector);
        // scimUrl cannot be cleared
        this.scimUrl = (_a = this.formatUrl(urls.scim)) !== null && _a !== void 0 ? _a : this.scimUrl;
        this.urlsSubject.next();
    }
    formatUrl(url) {
        if (url == null || url === "") {
            return null;
        }
        url = url.replace(/\/+$/g, "");
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            url = "https://" + url;
        }
        return url.trim();
    }
    isCloud() {
        return [
            "https://api.bitwarden.com",
            "https://vault.bitwarden.com/api",
            "https://api.bitwarden.eu",
            "https://vault.bitwarden.eu/api",
        ].includes(this.getApiUrl());
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/file-upload/azure-file-upload.service.ts
var azure_file_upload_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const MAX_SINGLE_BLOB_UPLOAD_SIZE = 256 * 1024 * 1024; // 256 MiB
const MAX_BLOCKS_PER_BLOB = 50000;
class AzureFileUploadService {
    constructor(logService) {
        this.logService = logService;
    }
    upload(url, data, renewalCallback) {
        return azure_file_upload_service_awaiter(this, void 0, void 0, function* () {
            if (data.buffer.byteLength <= MAX_SINGLE_BLOB_UPLOAD_SIZE) {
                return yield this.azureUploadBlob(url, data);
            }
            else {
                return yield this.azureUploadBlocks(url, data, renewalCallback);
            }
        });
    }
    azureUploadBlob(url, data) {
        return azure_file_upload_service_awaiter(this, void 0, void 0, function* () {
            const urlObject = utils_Utils.getUrl(url);
            const headers = new Headers({
                "x-ms-date": new Date().toUTCString(),
                "x-ms-version": urlObject.searchParams.get("sv"),
                "Content-Length": data.buffer.byteLength.toString(),
                "x-ms-blob-type": "BlockBlob",
            });
            const request = new Request(url, {
                body: data.buffer,
                cache: "no-store",
                method: "PUT",
                headers: headers,
            });
            const blobResponse = yield fetch(request);
            if (blobResponse.status !== 201) {
                throw new Error(`Failed to create Azure blob: ${blobResponse.status}`);
            }
        });
    }
    azureUploadBlocks(url, data, renewalCallback) {
        return azure_file_upload_service_awaiter(this, void 0, void 0, function* () {
            const baseUrl = utils_Utils.getUrl(url);
            const blockSize = this.getMaxBlockSize(baseUrl.searchParams.get("sv"));
            let blockIndex = 0;
            const numBlocks = Math.ceil(data.buffer.byteLength / blockSize);
            const blocksStaged = [];
            if (numBlocks > MAX_BLOCKS_PER_BLOB) {
                throw new Error(`Cannot upload file, exceeds maximum size of ${blockSize * MAX_BLOCKS_PER_BLOB}`);
            }
            // eslint-disable-next-line
            try {
                while (blockIndex < numBlocks) {
                    url = yield this.renewUrlIfNecessary(url, renewalCallback);
                    const blockUrl = utils_Utils.getUrl(url);
                    const blockId = this.encodedBlockId(blockIndex);
                    blockUrl.searchParams.append("comp", "block");
                    blockUrl.searchParams.append("blockid", blockId);
                    const start = blockIndex * blockSize;
                    const blockData = data.buffer.slice(start, start + blockSize);
                    const blockHeaders = new Headers({
                        "x-ms-date": new Date().toUTCString(),
                        "x-ms-version": blockUrl.searchParams.get("sv"),
                        "Content-Length": blockData.byteLength.toString(),
                    });
                    const blockRequest = new Request(blockUrl.toString(), {
                        body: blockData,
                        cache: "no-store",
                        method: "PUT",
                        headers: blockHeaders,
                    });
                    const blockResponse = yield fetch(blockRequest);
                    if (blockResponse.status !== 201) {
                        const message = `Unsuccessful block PUT. Received status ${blockResponse.status}`;
                        this.logService.error(message + "\n" + (yield blockResponse.json()));
                        throw new Error(message);
                    }
                    blocksStaged.push(blockId);
                    blockIndex++;
                }
                url = yield this.renewUrlIfNecessary(url, renewalCallback);
                const blockListUrl = utils_Utils.getUrl(url);
                const blockListXml = this.blockListXml(blocksStaged);
                blockListUrl.searchParams.append("comp", "blocklist");
                const headers = new Headers({
                    "x-ms-date": new Date().toUTCString(),
                    "x-ms-version": blockListUrl.searchParams.get("sv"),
                    "Content-Length": blockListXml.length.toString(),
                });
                const request = new Request(blockListUrl.toString(), {
                    body: blockListXml,
                    cache: "no-store",
                    method: "PUT",
                    headers: headers,
                });
                const response = yield fetch(request);
                if (response.status !== 201) {
                    const message = `Unsuccessful block list PUT. Received status ${response.status}`;
                    this.logService.error(message + "\n" + (yield response.json()));
                    throw new Error(message);
                }
            }
            catch (e) {
                throw e;
            }
        });
    }
    renewUrlIfNecessary(url, renewalCallback) {
        var _a;
        return azure_file_upload_service_awaiter(this, void 0, void 0, function* () {
            const urlObject = utils_Utils.getUrl(url);
            const expiry = new Date((_a = urlObject.searchParams.get("se")) !== null && _a !== void 0 ? _a : "");
            if (isNaN(expiry.getTime())) {
                expiry.setTime(Date.now() + 3600000);
            }
            if (expiry.getTime() < Date.now() + 1000) {
                return yield renewalCallback();
            }
            return url;
        });
    }
    encodedBlockId(blockIndex) {
        // Encoded blockId max size is 64, so pre-encoding max size is 48
        const utfBlockId = ("000000000000000000000000000000000000000000000000" + blockIndex.toString()).slice(-48);
        return utils_Utils.fromUtf8ToB64(utfBlockId);
    }
    blockListXml(blockIdList) {
        let xml = '<?xml version="1.0" encoding="utf-8"?><BlockList>';
        blockIdList.forEach((blockId) => {
            xml += `<Latest>${blockId}</Latest>`;
        });
        xml += "</BlockList>";
        return xml;
    }
    getMaxBlockSize(version) {
        if (Version.compare(version, "2019-12-12") >= 0) {
            return 4000 * 1024 * 1024; // 4000 MiB
        }
        else if (Version.compare(version, "2016-05-31") >= 0) {
            return 100 * 1024 * 1024; // 100 MiB
        }
        else {
            return 4 * 1024 * 1024; // 4 MiB
        }
    }
}
class Version {
    /**
     * Compares two Azure Versions against each other
     * @param a Version to compare
     * @param b Version to compare
     * @returns a number less than zero if b is newer than a, 0 if equal,
     * and greater than zero if a is newer than b
     */
    static compare(a, b) {
        if (typeof a === "string") {
            a = new Version(a);
        }
        if (typeof b === "string") {
            b = new Version(b);
        }
        return a.year !== b.year
            ? a.year - b.year
            : a.month !== b.month
                ? a.month - b.month
                : a.day !== b.day
                    ? a.day - b.day
                    : 0;
    }
    constructor(version) {
        this.year = 0;
        this.month = 0;
        this.day = 0;
        try {
            const parts = version.split("-").map((v) => Number.parseInt(v, 10));
            this.year = parts[0];
            this.month = parts[1];
            this.day = parts[2];
        }
        catch (_a) {
            // Ignore error
        }
    }
    /**
     * Compares two Azure Versions against each other
     * @param compareTo Version to compare against
     * @returns a number less than zero if compareTo is newer, 0 if equal,
     * and greater than zero if this is greater than compareTo
     */
    compare(compareTo) {
        return Version.compare(this, compareTo);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/file-upload/bitwarden-file-upload.service.ts
var bitwarden_file_upload_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class BitwardenFileUploadService {
    upload(encryptedFileName, encryptedFileData, apiCall) {
        return bitwarden_file_upload_service_awaiter(this, void 0, void 0, function* () {
            const fd = new FormData();
            try {
                const blob = new Blob([encryptedFileData.buffer], { type: "application/octet-stream" });
                fd.append("data", blob, encryptedFileName);
            }
            catch (e) {
                if (utils_Utils.isNode && !utils_Utils.isBrowser) {
                    fd.append("data", Buffer.from(encryptedFileData.buffer), {
                        filepath: encryptedFileName,
                        contentType: "application/octet-stream",
                    });
                }
                else {
                    throw e;
                }
            }
            yield apiCall(fd);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/file-upload/file-upload.service.ts
var file_upload_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class FileUploadService {
    constructor(logService) {
        this.logService = logService;
        this.azureFileUploadService = new AzureFileUploadService(logService);
        this.bitwardenFileUploadService = new BitwardenFileUploadService();
    }
    upload(uploadData, fileName, encryptedFileData, fileUploadMethods) {
        return file_upload_service_awaiter(this, void 0, void 0, function* () {
            try {
                switch (uploadData.fileUploadType) {
                    case FileUploadType.Direct:
                        yield this.bitwardenFileUploadService.upload(fileName.encryptedString, encryptedFileData, (fd) => fileUploadMethods.postDirect(fd));
                        break;
                    case FileUploadType.Azure: {
                        yield this.azureFileUploadService.upload(uploadData.url, encryptedFileData, fileUploadMethods.renewFileUploadUrl);
                        break;
                    }
                    default:
                        throw new Error("Unknown file upload type");
                }
            }
            catch (e) {
                yield fileUploadMethods.rollback();
                throw e;
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/abstractions/storage.service.ts
class AbstractStorageService {
}
class AbstractMemoryStorageService extends AbstractStorageService {
    constructor() {
        super(...arguments);
        this.type = AbstractMemoryStorageService.TYPE;
    }
}
// Used to identify the service in the session sync decorator framework
AbstractMemoryStorageService.TYPE = "MemoryStorageService";

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/memory-storage.service.ts
var memory_storage_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class MemoryStorageService extends AbstractMemoryStorageService {
    constructor() {
        super(...arguments);
        this.store = new Map();
        this.updatesSubject = new external_rxjs_namespaceObject.Subject();
    }
    get valuesRequireDeserialization() {
        return false;
    }
    get updates$() {
        return this.updatesSubject.asObservable();
    }
    get(key) {
        if (this.store.has(key)) {
            const obj = this.store.get(key);
            return Promise.resolve(obj);
        }
        return Promise.resolve(null);
    }
    has(key) {
        return memory_storage_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.get(key)) != null;
        });
    }
    save(key, obj) {
        if (obj == null) {
            return this.remove(key);
        }
        // TODO: Remove once foreground/background contexts are separated in browser
        // Needed to ensure ownership of all memory by the context running the storage service
        const toStore = structuredClone(obj);
        this.store.set(key, toStore);
        this.updatesSubject.next({ key, updateType: "save" });
        return Promise.resolve();
    }
    remove(key) {
        this.store.delete(key);
        this.updatesSubject.next({ key, updateType: "remove" });
        return Promise.resolve();
    }
    getBypassCache(key) {
        return this.get(key);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/noop-messaging.service.ts
class NoopMessagingService {
    send(subscriber, arg = {}) {
        // Do nothing...
    }
}

;// CONCATENATED MODULE: ../browser/src/autofill/utils/autofill-overlay.enum.ts
const AutofillOverlayElement = {
    Button: "autofill-overlay-button",
    List: "autofill-overlay-list",
};
const AutofillOverlayPort = {
    Button: "autofill-overlay-button-port",
    List: "autofill-overlay-list-port",
};
const RedirectFocusDirection = {
    Current: "current",
    Previous: "previous",
    Next: "next",
};
const AutofillOverlayVisibility = {
    Off: 0,
    OnButtonClick: 1,
    OnFieldFocus: 2,
};


;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/data/provider.data.ts
class ProviderData {
    constructor(response) {
        this.id = response.id;
        this.name = response.name;
        this.status = response.status;
        this.type = response.type;
        this.enabled = response.enabled;
        this.userId = response.userId;
        this.useEvents = response.useEvents;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/enums/vault-timeout-action.enum.ts
var VaultTimeoutAction;
(function (VaultTimeoutAction) {
    VaultTimeoutAction["Lock"] = "lock";
    VaultTimeoutAction["LogOut"] = "logOut";
})(VaultTimeoutAction || (VaultTimeoutAction = {}));

;// CONCATENATED MODULE: ../../libs/common/src/models/data/event.data.ts
class EventData {
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migration-builder.ts
var migration_builder_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class MigrationBuilder {
    /** Create a new MigrationBuilder with an empty buffer of migrations to perform.
     *
     * Add migrations to the buffer with {@link with} and {@link rollback}.
     * @returns A new MigrationBuilder.
     */
    static create() {
        return new MigrationBuilder([]);
    }
    constructor(migrations) {
        this.migrations = migrations;
    }
    /** Add a migrator to the MigrationBuilder. Types are updated such that the chained MigrationBuilder must currently be
     * at state version equal to the from version of the migrator. Return as MigrationBuilder<TTo> where TTo is the to
     * version of the migrator, so that the next migrator can be chained.
     *
     * @param migrate A migrator class or a tuple of a migrator class, the from version, and the to version. A tuple is
     * required to instantiate version numbers unless a default constructor is defined.
     * @returns A new MigrationBuilder with the to version of the migrator as the current version.
     */
    with(...migrate) {
        return this.addMigrator(migrate, "up");
    }
    /** Add a migrator to rollback on the MigrationBuilder's list of migrations. As with {@link with}, types of
     * MigrationBuilder and Migrator must align. However, this time the migration is reversed so TCurrent of the
     * MigrationBuilder must be equal to the to version of the migrator. Return as MigrationBuilder<TFrom> where TFrom
     * is the from version of the migrator, so that the next migrator can be chained.
     *
     * @param migrate A migrator class or a tuple of a migrator class, the from version, and the to version. A tuple is
     * required to instantiate version numbers unless a default constructor is defined.
     * @returns A new MigrationBuilder with the from version of the migrator as the current version.
     */
    rollback(...migrate) {
        if (migrate.length === 3) {
            migrate = [migrate[0], migrate[2], migrate[1]];
        }
        return this.addMigrator(migrate, "down");
    }
    /** Execute the migrations as defined in the MigrationBuilder's migrator buffer */
    migrate(helper) {
        return this.migrations.reduce((promise, migrator) => promise.then(() => migration_builder_awaiter(this, void 0, void 0, function* () {
            yield this.runMigrator(migrator.migrator, helper, migrator.direction);
        })), Promise.resolve());
    }
    addMigrator(migrate, direction = "up") {
        const newMigration = migrate.length === 1
            ? { migrator: new migrate[0](), direction }
            : { migrator: new migrate[0](migrate[1], migrate[2]), direction };
        return new MigrationBuilder([...this.migrations, newMigration]);
    }
    runMigrator(migrator, helper, direction) {
        return migration_builder_awaiter(this, void 0, void 0, function* () {
            const shouldMigrate = yield migrator.shouldMigrate(helper, direction);
            helper.info(`Migrator ${migrator.constructor.name} (to version ${migrator.toVersion}) should migrate: ${shouldMigrate} - ${direction}`);
            if (shouldMigrate) {
                const method = direction === "up" ? migrator.migrate : migrator.rollback;
                yield method.bind(migrator)(helper);
                helper.info(`Migrator ${migrator.constructor.name} (to version ${migrator.toVersion}) migrated - ${direction}`);
                yield migrator.updateVersion(helper, direction);
                helper.info(`Migrator ${migrator.constructor.name} (to version ${migrator.toVersion}) updated version - ${direction}`);
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migration-helper.ts
var migration_helper_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class MigrationHelper {
    constructor(currentVersion, storageService, logService) {
        this.currentVersion = currentVersion;
        this.storageService = storageService;
        this.logService = logService;
    }
    /**
     * Gets a value from the storage service at the given key.
     *
     * This is a brute force method to just get a value from the storage service. If you can use {@link getFromGlobal} or {@link getFromUser}, you should.
     * @param key location
     * @returns the value at the location
     */
    get(key) {
        return this.storageService.get(key);
    }
    /**
     * Sets a value in the storage service at the given key.
     *
     * This is a brute force method to just set a value in the storage service. If you can use {@link setToGlobal} or {@link setToUser}, you should.
     * @param key location
     * @param value the value to set
     * @returns
     */
    set(key, value) {
        this.logService.info(`Setting ${key}`);
        return this.storageService.save(key, value);
    }
    /**
     * Gets a globally scoped value from a location derived through the key definition
     *
     * This is for use with the state providers framework, DO NOT use for values stored with {@link StateService},
     * use {@link get} for those.
     * @param keyDefinition unique key definition
     * @returns value from store
     */
    getFromGlobal(keyDefinition) {
        return this.get(this.getGlobalKey(keyDefinition));
    }
    /**
     * Sets a globally scoped value to a location derived through the key definition
     *
     * This is for use with the state providers framework, DO NOT use for values stored with {@link StateService},
     * use {@link set} for those.
     * @param keyDefinition unique key definition
     * @param value value to store
     * @returns void
     */
    setToGlobal(keyDefinition, value) {
        return this.set(this.getGlobalKey(keyDefinition), value);
    }
    /**
     * Gets a user scoped value from a location derived through the user id and key definition
     *
     * This is for use with the state providers framework, DO NOT use for values stored with {@link StateService},
     * use {@link get} for those.
     * @param userId userId to use in the key
     * @param keyDefinition unique key definition
     * @returns value from store
     */
    getFromUser(userId, keyDefinition) {
        return this.get(this.getUserKey(userId, keyDefinition));
    }
    /**
     * Sets a user scoped value to a location derived through the user id and key definition
     *
     * This is for use with the state providers framework, DO NOT use for values stored with {@link StateService},
     * use {@link set} for those.
     * @param userId userId to use in the key
     * @param keyDefinition unique key definition
     * @param value value to store
     * @returns void
     */
    setToUser(userId, keyDefinition, value) {
        return this.set(this.getUserKey(userId, keyDefinition), value);
    }
    info(message) {
        this.logService.info(message);
    }
    /**
     * Helper method to read all Account objects stored by the State Service.
     *
     * This is useful from creating migrations off of this paradigm, but should not be used once a value is migrated to a state provider.
     *
     * @returns a list of all accounts that have been authenticated with state service, cast the the expected type.
     */
    getAccounts() {
        var _a;
        return migration_helper_awaiter(this, void 0, void 0, function* () {
            const userIds = (_a = (yield this.get("authenticatedAccounts"))) !== null && _a !== void 0 ? _a : [];
            return Promise.all(userIds.map((userId) => migration_helper_awaiter(this, void 0, void 0, function* () {
                return ({
                    userId,
                    account: yield this.get(userId),
                });
            })));
        });
    }
    /**
     * Builds a user storage key appropriate for the current version.
     *
     * @param userId userId to use in the key
     * @param keyDefinition state and key to use in the key
     * @returns
     */
    getUserKey(userId, keyDefinition) {
        if (this.currentVersion < 9) {
            return userKeyBuilderPre9();
        }
        else {
            return migration_helper_userKeyBuilder(userId, keyDefinition);
        }
    }
    /**
     * Builds a global storage key appropriate for the current version.
     *
     * @param keyDefinition state and key to use in the key
     * @returns
     */
    getGlobalKey(keyDefinition) {
        if (this.currentVersion < 9) {
            return globalKeyBuilderPre9();
        }
        else {
            return migration_helper_globalKeyBuilder(keyDefinition);
        }
    }
}
/**
 * When this is updated, rename this function to `userKeyBuilderXToY` where `X` is the version number it
 * became relevant, and `Y` prior to the version it was updated.
 *
 * Be sure to update the map in `MigrationHelper` to point to the appropriate function for the current version.
 * @param userId The userId of the user you want the key to be for.
 * @param keyDefinition the key definition of which data the key should point to.
 * @returns
 */
function migration_helper_userKeyBuilder(userId, keyDefinition) {
    return `user_${userId}_${keyDefinition.stateDefinition.name}_${keyDefinition.key}`;
}
function userKeyBuilderPre9() {
    throw Error("No key builder should be used for versions prior to 9.");
}
/**
 * When this is updated, rename this function to `globalKeyBuilderXToY` where `X` is the version number
 * it became relevant, and `Y` prior to the version it was updated.
 *
 * Be sure to update the map in `MigrationHelper` to point to the appropriate function for the current version.
 * @param keyDefinition the key definition of which data the key should point to.
 * @returns
 */
function migration_helper_globalKeyBuilder(keyDefinition) {
    return `global_${keyDefinition.stateDefinition.name}_${keyDefinition.key}`;
}
function globalKeyBuilderPre9() {
    throw Error("No key builder should be used for versions prior to 9.");
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrator.ts
var migrator_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
const IRREVERSIBLE = new Error("Irreversible migration");
class Migrator {
    constructor(fromVersion, toVersion) {
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        if (fromVersion == null || toVersion == null) {
            throw new Error("Invalid migration");
        }
        if (fromVersion > toVersion) {
            throw new Error("Invalid migration");
        }
    }
    shouldMigrate(helper, direction) {
        const startVersion = direction === "up" ? this.fromVersion : this.toVersion;
        return Promise.resolve(helper.currentVersion === startVersion);
    }
    updateVersion(helper, direction) {
        return migrator_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            yield helper.set("stateVersion", endVersion);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/10-move-ever-had-user-key-to-state-providers.ts
var _10_move_ever_had_user_key_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _10_move_ever_had_user_key_to_state_providers_USER_EVER_HAD_USER_KEY = {
    key: "everHadUserKey",
    stateDefinition: {
        name: "crypto",
    },
};
class EverHadUserKeyMigrator extends Migrator {
    migrate(helper) {
        return _10_move_ever_had_user_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a;
                return _10_move_ever_had_user_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const value = (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.everHadUserKey;
                    yield helper.setToUser(userId, _10_move_ever_had_user_key_to_state_providers_USER_EVER_HAD_USER_KEY, value !== null && value !== void 0 ? value : false);
                    if (value != null) {
                        delete account.profile.everHadUserKey;
                    }
                    yield helper.set(userId, account);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _10_move_ever_had_user_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _10_move_ever_had_user_key_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, _10_move_ever_had_user_key_to_state_providers_USER_EVER_HAD_USER_KEY);
                    if (account) {
                        account.profile = Object.assign((_a = account.profile) !== null && _a !== void 0 ? _a : {}, {
                            everHadUserKey: value,
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, _10_move_ever_had_user_key_to_state_providers_USER_EVER_HAD_USER_KEY, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/11-move-org-keys-to-state-providers.ts
var _11_move_org_keys_to_state_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const _11_move_org_keys_to_state_providers_USER_ENCRYPTED_ORGANIZATION_KEYS = {
    key: "organizationKeys",
    stateDefinition: {
        name: "crypto",
    },
};
class OrganizationKeyMigrator extends Migrator {
    migrate(helper) {
        return _11_move_org_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function migrateAccount(userId, account) {
                var _a, _b;
                return _11_move_org_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const value = (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.organizationKeys) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (value != null) {
                        yield helper.setToUser(userId, _11_move_org_keys_to_state_providers_USER_ENCRYPTED_ORGANIZATION_KEYS, value);
                        delete account.keys.organizationKeys;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => migrateAccount(userId, account))]);
        });
    }
    rollback(helper) {
        return _11_move_org_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function rollbackAccount(userId, account) {
                var _a;
                return _11_move_org_keys_to_state_providers_awaiter(this, void 0, void 0, function* () {
                    const value = yield helper.getFromUser(userId, _11_move_org_keys_to_state_providers_USER_ENCRYPTED_ORGANIZATION_KEYS);
                    if (account && value) {
                        account.keys = Object.assign((_a = account.keys) !== null && _a !== void 0 ? _a : {}, {
                            organizationKeys: {
                                encrypted: value,
                            },
                        });
                        yield helper.set(userId, account);
                    }
                    yield helper.setToUser(userId, _11_move_org_keys_to_state_providers_USER_ENCRYPTED_ORGANIZATION_KEYS, null);
                });
            }
            yield Promise.all([...accounts.map(({ userId, account }) => rollbackAccount(userId, account))]);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/12-move-environment-state-to-providers.ts
var _12_move_environment_state_to_providers_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

const ENVIRONMENT_STATE = { name: "environment" };
const _12_move_environment_state_to_providers_REGION_KEY = { key: "region", stateDefinition: ENVIRONMENT_STATE };
const _12_move_environment_state_to_providers_URLS_KEY = { key: "urls", stateDefinition: ENVIRONMENT_STATE };
class MoveEnvironmentStateToProviders extends Migrator {
    migrate(helper) {
        return _12_move_environment_state_to_providers_awaiter(this, void 0, void 0, function* () {
            const legacyGlobal = yield helper.get("global");
            // Move global data
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.region) != null) {
                yield helper.setToGlobal(_12_move_environment_state_to_providers_REGION_KEY, legacyGlobal.region);
            }
            if ((legacyGlobal === null || legacyGlobal === void 0 ? void 0 : legacyGlobal.environmentUrls) != null) {
                yield helper.setToGlobal(_12_move_environment_state_to_providers_URLS_KEY, legacyGlobal.environmentUrls);
            }
            const legacyAccounts = yield helper.getAccounts();
            yield Promise.all(legacyAccounts.map(({ userId, account }) => _12_move_environment_state_to_providers_awaiter(this, void 0, void 0, function* () {
                var _a, _b, _c, _d;
                // Move account data
                if (((_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.region) != null) {
                    yield helper.setToUser(userId, _12_move_environment_state_to_providers_REGION_KEY, account.settings.region);
                }
                if (((_b = account === null || account === void 0 ? void 0 : account.settings) === null || _b === void 0 ? void 0 : _b.environmentUrls) != null) {
                    yield helper.setToUser(userId, _12_move_environment_state_to_providers_URLS_KEY, account.settings.environmentUrls);
                }
                // Delete old account data
                (_c = account === null || account === void 0 ? void 0 : account.settings) === null || _c === void 0 ? true : delete _c.region;
                (_d = account === null || account === void 0 ? void 0 : account.settings) === null || _d === void 0 ? true : delete _d.environmentUrls;
                yield helper.set(userId, account);
            })));
            // Delete legacy global data
            legacyGlobal === null || legacyGlobal === void 0 ? true : delete legacyGlobal.region;
            legacyGlobal === null || legacyGlobal === void 0 ? true : delete legacyGlobal.environmentUrls;
            yield helper.set("global", legacyGlobal);
        });
    }
    rollback(helper) {
        return _12_move_environment_state_to_providers_awaiter(this, void 0, void 0, function* () {
            let legacyGlobal = yield helper.get("global");
            let updatedLegacyGlobal = false;
            const globalRegion = yield helper.getFromGlobal(_12_move_environment_state_to_providers_REGION_KEY);
            if (globalRegion) {
                if (!legacyGlobal) {
                    legacyGlobal = {};
                }
                updatedLegacyGlobal = true;
                legacyGlobal.region = globalRegion;
                yield helper.setToGlobal(_12_move_environment_state_to_providers_REGION_KEY, null);
            }
            const globalUrls = yield helper.getFromGlobal(_12_move_environment_state_to_providers_URLS_KEY);
            if (globalUrls) {
                if (!legacyGlobal) {
                    legacyGlobal = {};
                }
                updatedLegacyGlobal = true;
                legacyGlobal.environmentUrls = globalUrls;
                yield helper.setToGlobal(_12_move_environment_state_to_providers_URLS_KEY, null);
            }
            if (updatedLegacyGlobal) {
                yield helper.set("global", legacyGlobal);
            }
            function rollbackUser(userId, account) {
                return _12_move_environment_state_to_providers_awaiter(this, void 0, void 0, function* () {
                    let updatedAccount = false;
                    const userRegion = yield helper.getFromUser(userId, _12_move_environment_state_to_providers_REGION_KEY);
                    if (userRegion) {
                        if (!account) {
                            account = {};
                        }
                        if (!account.settings) {
                            account.settings = {};
                        }
                        updatedAccount = true;
                        account.settings.region = userRegion;
                        yield helper.setToUser(userId, _12_move_environment_state_to_providers_REGION_KEY, null);
                    }
                    const userUrls = yield helper.getFromUser(userId, _12_move_environment_state_to_providers_URLS_KEY);
                    if (userUrls) {
                        if (!account) {
                            account = {};
                        }
                        if (!account.settings) {
                            account.settings = {};
                        }
                        updatedAccount = true;
                        account.settings.environmentUrls = userUrls;
                        yield helper.setToUser(userId, _12_move_environment_state_to_providers_URLS_KEY, null);
                    }
                    if (updatedAccount) {
                        yield helper.set(userId, account);
                    }
                });
            }
            const accounts = yield helper.getAccounts();
            yield Promise.all(accounts.map(({ userId, account }) => rollbackUser(userId, account)));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/3-fix-premium.ts
var _3_fix_premium_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// eslint-disable-next-line import/no-restricted-paths -- Used for token decoding, which are valid for days. We want the latest


class FixPremiumMigrator extends Migrator {
    migrate(helper) {
        return _3_fix_premium_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function fixPremium(userId, account) {
                var _a, _b;
                return _3_fix_premium_awaiter(this, void 0, void 0, function* () {
                    if (((_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.hasPremiumPersonally) === null && ((_b = account.tokens) === null || _b === void 0 ? void 0 : _b.accessToken) != null) {
                        let decodedToken;
                        try {
                            decodedToken = yield TokenService.decodeToken(account.tokens.accessToken);
                        }
                        catch (_c) {
                            return;
                        }
                        if ((decodedToken === null || decodedToken === void 0 ? void 0 : decodedToken.premium) == null) {
                            return;
                        }
                        account.profile.hasPremiumPersonally = decodedToken === null || decodedToken === void 0 ? void 0 : decodedToken.premium;
                        return helper.set(userId, account);
                    }
                });
            }
            yield Promise.all(accounts.map(({ userId, account }) => fixPremium(userId, account)));
        });
    }
    rollback(helper) {
        throw IRREVERSIBLE;
    }
    // Override is necessary because default implementation assumes `stateVersion` at the root, but for this version
    // it is nested inside a global object.
    updateVersion(helper, direction) {
        return _3_fix_premium_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            const global = (yield helper.get("global")) || {};
            yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: endVersion }));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/4-remove-ever-been-unlocked.ts
var _4_remove_ever_been_unlocked_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class RemoveEverBeenUnlockedMigrator extends Migrator {
    migrate(helper) {
        return _4_remove_ever_been_unlocked_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function removeEverBeenUnlocked(userId, account) {
                var _a;
                return _4_remove_ever_been_unlocked_awaiter(this, void 0, void 0, function* () {
                    if (((_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.everBeenUnlocked) != null) {
                        delete account.profile.everBeenUnlocked;
                        return helper.set(userId, account);
                    }
                });
            }
            Promise.all(accounts.map(({ userId, account }) => removeEverBeenUnlocked(userId, account)));
        });
    }
    rollback(helper) {
        throw IRREVERSIBLE;
    }
    // Override is necessary because default implementation assumes `stateVersion` at the root, but for this version
    // it is nested inside a global object.
    updateVersion(helper, direction) {
        return _4_remove_ever_been_unlocked_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            const global = (yield helper.get("global")) || {};
            yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: endVersion }));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/5-add-key-type-to-org-keys.ts
var _5_add_key_type_to_org_keys_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class AddKeyTypeToOrgKeysMigrator extends Migrator {
    migrate(helper) {
        return _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function updateOrgKey(userId, account) {
                var _a, _b;
                return _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () {
                    const encryptedOrgKeys = (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.organizationKeys) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (encryptedOrgKeys == null) {
                        return;
                    }
                    const newOrgKeys = {};
                    Object.entries(encryptedOrgKeys).forEach(([orgId, encKey]) => {
                        newOrgKeys[orgId] = {
                            type: "organization",
                            key: encKey,
                        };
                    });
                    account.keys.organizationKeys.encrypted = newOrgKeys;
                    yield helper.set(userId, account);
                });
            }
            Promise.all(accounts.map(({ userId, account }) => updateOrgKey(userId, account)));
        });
    }
    rollback(helper) {
        return _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function updateOrgKey(userId, account) {
                var _a, _b;
                return _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () {
                    const encryptedOrgKeys = (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.organizationKeys) === null || _b === void 0 ? void 0 : _b.encrypted;
                    if (encryptedOrgKeys == null) {
                        return;
                    }
                    const newOrgKeys = {};
                    Object.entries(encryptedOrgKeys).forEach(([orgId, encKey]) => {
                        newOrgKeys[orgId] = encKey.key;
                    });
                    account.keys.organizationKeys.encrypted = newOrgKeys;
                    yield helper.set(userId, account);
                });
            }
            Promise.all(accounts.map(({ userId, account }) => _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () { return updateOrgKey(userId, account); })));
        });
    }
    // Override is necessary because default implementation assumes `stateVersion` at the root, but for this version
    // it is nested inside a global object.
    updateVersion(helper, direction) {
        return _5_add_key_type_to_org_keys_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            const global = (yield helper.get("global")) || {};
            yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: endVersion }));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/6-remove-legacy-etm-key.ts
var _6_remove_legacy_etm_key_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class RemoveLegacyEtmKeyMigrator extends Migrator {
    migrate(helper) {
        return _6_remove_legacy_etm_key_awaiter(this, void 0, void 0, function* () {
            const accounts = yield helper.getAccounts();
            function updateAccount(userId, account) {
                var _a;
                return _6_remove_legacy_etm_key_awaiter(this, void 0, void 0, function* () {
                    if ((_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.legacyEtmKey) {
                        delete account.keys.legacyEtmKey;
                        yield helper.set(userId, account);
                    }
                });
            }
            yield Promise.all(accounts.map(({ userId, account }) => updateAccount(userId, account)));
        });
    }
    rollback(helper) {
        return _6_remove_legacy_etm_key_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
    // Override is necessary because default implementation assumes `stateVersion` at the root, but for this version
    // it is nested inside a global object.
    updateVersion(helper, direction) {
        return _6_remove_legacy_etm_key_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            const global = (yield helper.get("global")) || {};
            yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: endVersion }));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/7-move-biometric-auto-prompt-to-account.ts
var _7_move_biometric_auto_prompt_to_account_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class MoveBiometricAutoPromptToAccount extends Migrator {
    migrate(helper) {
        var _a;
        return _7_move_biometric_auto_prompt_to_account_awaiter(this, void 0, void 0, function* () {
            const global = yield helper.get("global");
            const noAutoPromptBiometrics = (_a = global === null || global === void 0 ? void 0 : global.noAutoPromptBiometrics) !== null && _a !== void 0 ? _a : false;
            const accounts = yield helper.getAccounts();
            function updateAccount(userId, account) {
                var _a;
                return _7_move_biometric_auto_prompt_to_account_awaiter(this, void 0, void 0, function* () {
                    if (account == null) {
                        return;
                    }
                    if (noAutoPromptBiometrics) {
                        account.settings = Object.assign((_a = account === null || account === void 0 ? void 0 : account.settings) !== null && _a !== void 0 ? _a : {}, {
                            disableAutoBiometricsPrompt: true,
                        });
                        yield helper.set(userId, account);
                    }
                });
            }
            delete global.noAutoPromptBiometrics;
            yield Promise.all([
                ...accounts.map(({ userId, account }) => updateAccount(userId, account)),
                helper.set("global", global),
            ]);
        });
    }
    rollback(helper) {
        return _7_move_biometric_auto_prompt_to_account_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
    // Override is necessary because default implementation assumes `stateVersion` at the root, but for this version
    // it is nested inside a global object.
    updateVersion(helper, direction) {
        return _7_move_biometric_auto_prompt_to_account_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            const global = (yield helper.get("global")) || {};
            yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: endVersion }));
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/8-move-state-version.ts
var _8_move_state_version_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class MoveStateVersionMigrator extends Migrator {
    migrate(helper) {
        return _8_move_state_version_awaiter(this, void 0, void 0, function* () {
            const global = yield helper.get("global");
            if (global.stateVersion) {
                yield helper.set("stateVersion", global.stateVersion);
                delete global.stateVersion;
                yield helper.set("global", global);
            }
            else {
                throw new Error("Migration failed, state version not found");
            }
        });
    }
    rollback(helper) {
        return _8_move_state_version_awaiter(this, void 0, void 0, function* () {
            const version = yield helper.get("stateVersion");
            const global = yield helper.get("global");
            yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: version }));
            yield helper.set("stateVersion", undefined);
        });
    }
    // Override is necessary because default implementation assumes `stateVersion` at the root, but this migration moves
    // it from a `global` object to root.This makes for unique rollback versioning.
    updateVersion(helper, direction) {
        return _8_move_state_version_awaiter(this, void 0, void 0, function* () {
            const endVersion = direction === "up" ? this.toVersion : this.fromVersion;
            helper.currentVersion = endVersion;
            if (direction === "up") {
                yield helper.set("stateVersion", endVersion);
            }
            else {
                const global = (yield helper.get("global")) || {};
                yield helper.set("global", Object.assign(Object.assign({}, global), { stateVersion: endVersion }));
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/9-move-browser-settings-to-global.ts
var _9_move_browser_settings_to_global_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class MoveBrowserSettingsToGlobal extends Migrator {
    // Will first check if any of the accounts have a value from the given accountSelector
    // if they do have a value it will set that value into global state but if multiple
    // users have differing values it will prefer the false setting,
    // if all users have true then it will take true.
    tryAddSetting(accounts, accountSelector, globalSetter) {
        const hasValue = accounts.some(({ account }) => {
            return accountSelector(account) !== undefined;
        });
        if (hasValue) {
            const value = !accounts.some(({ account }) => {
                var _a;
                return ((_a = accountSelector(account)) !== null && _a !== void 0 ? _a : false) === false;
            });
            globalSetter(value);
        }
    }
    migrate(helper) {
        return _9_move_browser_settings_to_global_awaiter(this, void 0, void 0, function* () {
            const global = yield helper.get("global");
            const accounts = yield helper.getAccounts();
            const globalNeverDomainsValue = accounts.reduce((accumulator, { account }) => {
                var _a, _b;
                const normalizedNeverDomains = (_b = (_a = account.settings) === null || _a === void 0 ? void 0 : _a.neverDomains) !== null && _b !== void 0 ? _b : {};
                for (const [id, value] of Object.entries(normalizedNeverDomains)) {
                    accumulator !== null && accumulator !== void 0 ? accumulator : (accumulator = {});
                    accumulator[id] = value;
                }
                return accumulator;
            }, undefined);
            const targetGlobalState = {};
            if (globalNeverDomainsValue != null) {
                targetGlobalState.neverDomains = globalNeverDomainsValue;
            }
            this.tryAddSetting(accounts, (a) => { var _a; return (_a = a.settings) === null || _a === void 0 ? void 0 : _a.disableAddLoginNotification; }, (v) => (targetGlobalState.disableAddLoginNotification = v));
            this.tryAddSetting(accounts, (a) => { var _a; return (_a = a.settings) === null || _a === void 0 ? void 0 : _a.disableChangedPasswordNotification; }, (v) => (targetGlobalState.disableChangedPasswordNotification = v));
            this.tryAddSetting(accounts, (a) => { var _a; return (_a = a.settings) === null || _a === void 0 ? void 0 : _a.disableContextMenuItem; }, (v) => (targetGlobalState.disableContextMenuItem = v));
            yield helper.set("global", Object.assign(Object.assign({}, global), targetGlobalState));
            yield Promise.all(accounts.map(({ userId, account }) => _9_move_browser_settings_to_global_awaiter(this, void 0, void 0, function* () {
                var _a, _b, _c, _d;
                (_a = account.settings) === null || _a === void 0 ? true : delete _a.disableAddLoginNotification;
                (_b = account.settings) === null || _b === void 0 ? true : delete _b.disableChangedPasswordNotification;
                (_c = account.settings) === null || _c === void 0 ? true : delete _c.disableContextMenuItem;
                (_d = account.settings) === null || _d === void 0 ? true : delete _d.neverDomains;
                yield helper.set(userId, account);
            })));
        });
    }
    rollback(helper) {
        throw new Error("Method not implemented.");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrations/min-version.ts
var min_version_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


function minVersionError(current) {
    return `Your local data is too old to be migrated. Your current state version is ${current}, but minimum version is ${MIN_VERSION}.`;
}
class MinVersionMigrator extends Migrator {
    constructor() {
        super(0, MIN_VERSION);
    }
    // Overrides the default implementation to catch any version that may be passed in.
    shouldMigrate(helper) {
        return Promise.resolve(helper.currentVersion < MIN_VERSION);
    }
    migrate(helper) {
        return min_version_awaiter(this, void 0, void 0, function* () {
            if (helper.currentVersion < MIN_VERSION) {
                throw new Error(minVersionError(helper.currentVersion));
            }
        });
    }
    rollback(helper) {
        return min_version_awaiter(this, void 0, void 0, function* () {
            throw IRREVERSIBLE;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/migrate.ts
var migrate_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};













const MIN_VERSION = 2;
const CURRENT_VERSION = 12;
function migrate(storageService, logService) {
    return migrate_awaiter(this, void 0, void 0, function* () {
        const migrationHelper = new MigrationHelper(yield currentVersion(storageService, logService), storageService, logService);
        if (migrationHelper.currentVersion < 0) {
            // Cannot determine state, assuming empty so we don't repeatedly apply a migration.
            yield storageService.save("stateVersion", CURRENT_VERSION);
            return;
        }
        yield MigrationBuilder.create()
            .with(MinVersionMigrator)
            .with(FixPremiumMigrator, 2, 3)
            .with(RemoveEverBeenUnlockedMigrator, 3, 4)
            .with(AddKeyTypeToOrgKeysMigrator, 4, 5)
            .with(RemoveLegacyEtmKeyMigrator, 5, 6)
            .with(MoveBiometricAutoPromptToAccount, 6, 7)
            .with(MoveStateVersionMigrator, 7, 8)
            .with(MoveBrowserSettingsToGlobal, 8, 9)
            .with(EverHadUserKeyMigrator, 9, 10)
            .with(OrganizationKeyMigrator, 10, 11)
            .with(MoveEnvironmentStateToProviders, 11, CURRENT_VERSION)
            .migrate(migrationHelper);
    });
}
function currentVersion(storageService, logService) {
    var _a;
    return migrate_awaiter(this, void 0, void 0, function* () {
        let state = yield storageService.get("stateVersion");
        if (state == null) {
            // Pre v8
            state = (_a = (yield storageService.get("global"))) === null || _a === void 0 ? void 0 : _a.stateVersion;
        }
        if (state == null) {
            logService.info("No state version found, assuming empty state.");
            return -1;
        }
        logService.info(`State version: ${state}`);
        return state;
    });
}

;// CONCATENATED MODULE: ../../libs/common/src/state-migrations/index.ts


;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/password-generator-options-evaluator.ts
function initializeBoundaries() {
    const length = Object.freeze({
        min: 5,
        max: 128,
    });
    const minDigits = Object.freeze({
        min: 0,
        max: 9,
    });
    const minSpecialCharacters = Object.freeze({
        min: 0,
        max: 9,
    });
    return Object.freeze({
        length,
        minDigits,
        minSpecialCharacters,
    });
}
/** Immutable default boundaries for password generation.
 * These are used when the policy does not override a value.
 */
const DefaultBoundaries = initializeBoundaries();
/** Enforces policy for password generation.
 */
class password_generator_options_evaluator_PasswordGeneratorOptionsEvaluator {
    /** Instantiates the evaluator.
     * @param policy The policy applied by the evaluator. When this conflicts with
     *               the defaults, the policy takes precedence.
     */
    constructor(policy) {
        function createBoundary(value, defaultBoundary) {
            const boundary = {
                min: Math.max(defaultBoundary.min, value),
                max: Math.max(defaultBoundary.max, value),
            };
            return boundary;
        }
        this.policy = structuredClone(policy);
        this.minDigits = createBoundary(policy.numberCount, DefaultBoundaries.minDigits);
        this.minSpecialCharacters = createBoundary(policy.specialCount, DefaultBoundaries.minSpecialCharacters);
        // the overall length should be at least as long as the sum of the minimums
        const minConsistentLength = this.minDigits.min + this.minSpecialCharacters.min;
        const minPolicyLength = policy.minLength > 0 ? policy.minLength : DefaultBoundaries.length.min;
        const minLength = Math.max(minPolicyLength, minConsistentLength, DefaultBoundaries.length.min);
        this.length = {
            min: minLength,
            max: Math.max(DefaultBoundaries.length.max, minLength),
        };
    }
    /** {@link PolicyEvaluator.policyInEffect} */
    get policyInEffect() {
        const policies = [
            this.policy.useUppercase,
            this.policy.useLowercase,
            this.policy.useNumbers,
            this.policy.useSpecial,
            this.policy.minLength > DefaultBoundaries.length.min,
            this.policy.numberCount > DefaultBoundaries.minDigits.min,
            this.policy.specialCount > DefaultBoundaries.minSpecialCharacters.min,
        ];
        return policies.includes(true);
    }
    /** {@link PolicyEvaluator.applyPolicy} */
    applyPolicy(options) {
        function fitToBounds(value, boundaries) {
            const { min, max } = boundaries;
            const withUpperBound = Math.min(value || 0, max);
            const withLowerBound = Math.max(withUpperBound, min);
            return withLowerBound;
        }
        // apply policy overrides
        const uppercase = this.policy.useUppercase || options.uppercase || false;
        const lowercase = this.policy.useLowercase || options.lowercase || false;
        // these overrides can cascade numeric fields to boolean fields
        const number = this.policy.useNumbers || options.number || options.minNumber > 0;
        const special = this.policy.useSpecial || options.special || options.minSpecial > 0;
        // apply boundaries; the boundaries can cascade boolean fields to numeric fields
        const length = fitToBounds(options.length, this.length);
        const minNumber = fitToBounds(options.minNumber, this.minDigits);
        const minSpecial = fitToBounds(options.minSpecial, this.minSpecialCharacters);
        return Object.assign(Object.assign({}, options), { length,
            uppercase,
            lowercase,
            number,
            minNumber,
            special,
            minSpecial });
    }
    /** {@link PolicyEvaluator.sanitize} */
    sanitize(options) {
        var _a;
        function cascade(enabled, value) {
            const enabledResult = enabled !== null && enabled !== void 0 ? enabled : value > 0;
            const valueResult = enabledResult ? value || 1 : 0;
            return [enabledResult, valueResult];
        }
        const [lowercase, minLowercase] = cascade(options.lowercase, options.minLowercase);
        const [uppercase, minUppercase] = cascade(options.uppercase, options.minUppercase);
        const [number, minNumber] = cascade(options.number, options.minNumber);
        const [special, minSpecial] = cascade(options.special, options.minSpecial);
        // minimums can only increase the length
        const minConsistentLength = minLowercase + minUppercase + minNumber + minSpecial;
        const minLength = Math.max(minConsistentLength, this.length.min);
        const length = Math.max((_a = options.length) !== null && _a !== void 0 ? _a : minLength, minLength);
        return Object.assign(Object.assign({}, options), { length,
            minLength,
            lowercase,
            minLowercase,
            uppercase,
            minUppercase,
            number,
            minNumber,
            special,
            minSpecial });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/password-generation-options.ts

/** The default options for password generation. */
const DefaultPasswordGenerationOptions = Object.freeze({
    length: 14,
    minLength: DefaultBoundaries.length.min,
    ambiguous: true,
    uppercase: true,
    lowercase: true,
    number: true,
    minNumber: 1,
    special: true,
    minSpecial: 1,
});

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/key-definitions.ts

/** plaintext password generation options */
const key_definitions_PASSWORD_SETTINGS = new KeyDefinition(GENERATOR_DISK, "passwordGeneratorSettings", {
    deserializer: (value) => value,
});
/** plaintext passphrase generation options */
const PASSPHRASE_SETTINGS = new KeyDefinition(GENERATOR_DISK, "passphraseGeneratorSettings", {
    deserializer: (value) => value,
});
/** plaintext username generation options */
const ENCRYPTED_USERNAME_SETTINGS = new KeyDefinition(GENERATOR_DISK, "usernameGeneratorSettings", {
    deserializer: (value) => value,
});
/** plaintext username generation options */
const PLAINTEXT_USERNAME_SETTINGS = new KeyDefinition(GENERATOR_MEMORY, "usernameGeneratorSettings", {
    deserializer: (value) => value,
});
/** encrypted password generation history */
const ENCRYPTED_HISTORY = new KeyDefinition(GENERATOR_DISK, "passwordGeneratorHistory", {
    deserializer: (value) => value,
});

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/password-generator-strategy.ts



const ONE_MINUTE = (/* unused pure expression or super */ null && (60 * 1000));
/** {@link GeneratorStrategy} */
class PasswordGeneratorStrategy {
    /** instantiates the password generator strategy.
     *  @param legacy generates the password
     */
    constructor(legacy) {
        this.legacy = legacy;
    }
    /** {@link GeneratorStrategy.disk} */
    get disk() {
        return PASSWORD_SETTINGS;
    }
    /** {@link GeneratorStrategy.policy} */
    get policy() {
        return PolicyType.PasswordGenerator;
    }
    get cache_ms() {
        return ONE_MINUTE;
    }
    /** {@link GeneratorStrategy.evaluator} */
    evaluator(policy) {
        if (policy.type !== this.policy) {
            const details = `Expected: ${this.policy}. Received: ${policy.type}`;
            throw Error("Mismatched policy type. " + details);
        }
        return new PasswordGeneratorOptionsEvaluator({
            minLength: policy.data.minLength,
            useUppercase: policy.data.useUpper,
            useLowercase: policy.data.useLower,
            useNumbers: policy.data.useNumbers,
            numberCount: policy.data.minNumbers,
            useSpecial: policy.data.useSpecial,
            specialCount: policy.data.minSpecial,
        });
    }
    /** {@link GeneratorStrategy.generate} */
    generate(options) {
        return this.legacy.generatePassword(Object.assign(Object.assign({}, options), { type: "password" }));
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/admin-console/models/domain/password-generator-policy-options.ts

/** Enterprise policy for the password generator.
 * @see PolicyType.PasswordGenerator
 */
class PasswordGeneratorPolicyOptions extends Domain {
    constructor() {
        super(...arguments);
        /** The default kind of credential to generate */
        this.defaultType = "";
        /** The minimum length of generated passwords.
         *  When this is less than or equal to zero, it is ignored.
         *  If this is less than the total number of characters required by
         *  the policy's other settings, then it is ignored.
         *  This field is not used for passphrases.
         */
        this.minLength = 0;
        /** When this is true, an uppercase character must be part of
         *  the generated password.
         *  This field is not used for passphrases.
         */
        this.useUppercase = false;
        /** When this is true, a lowercase character must be part of
         *  the generated password. This field is not used for passphrases.
         */
        this.useLowercase = false;
        /** When this is true, at least one digit must be part of the generated
         *  password. This field is not used for passphrases.
         */
        this.useNumbers = false;
        /** The quantity of digits to include in the generated password.
         *  When this is less than or equal to zero, it is ignored.
         *  This field is not used for passphrases.
         */
        this.numberCount = 0;
        /** When this is true, at least one digit must be part of the generated
         *  password. This field is not used for passphrases.
         */
        this.useSpecial = false;
        /** The quantity of special characters to include in the generated
         *  password. When this is less than or equal to zero, it is ignored.
         *  This field is not used for passphrases.
         */
        this.specialCount = 0;
        /** The minimum number of words required by generated passphrases.
         *  This field is not used for passwords.
         */
        this.minNumberWords = 0;
        /** When this is true, the first letter of each word in the passphrase
         *  is capitalized. This field is not used for passwords.
         */
        this.capitalize = false;
        /** When this is true, a number is included within the passphrase.
         *  This field is not used for passwords.
         */
        this.includeNumber = false;
    }
    /** Checks whether the policy affects the password generator.
     * @returns True if at least one password or passphrase requirement has been set.
     * If it returns False, then no requirements have been set and the policy should
     * not be enforced.
     */
    inEffect() {
        return (this.defaultType !== "" ||
            this.minLength > 0 ||
            this.numberCount > 0 ||
            this.specialCount > 0 ||
            this.useUppercase ||
            this.useLowercase ||
            this.useNumbers ||
            this.useSpecial ||
            this.minNumberWords > 0 ||
            this.capitalize ||
            this.includeNumber);
    }
    /** Creates a copy of the policy.
     */
    clone() {
        const policy = new PasswordGeneratorPolicyOptions();
        Object.assign(policy, this);
        return policy;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/generated-password-history.ts
class GeneratedPasswordHistory {
    constructor(password, date) {
        this.password = password;
        this.date = date;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/passphrase-generator-options-evaluator.ts
function passphrase_generator_options_evaluator_initializeBoundaries() {
    const numWords = Object.freeze({
        min: 3,
        max: 20,
    });
    return Object.freeze({
        numWords,
    });
}
/** Immutable default boundaries for passphrase generation.
 * These are used when the policy does not override a value.
 */
const passphrase_generator_options_evaluator_DefaultBoundaries = passphrase_generator_options_evaluator_initializeBoundaries();
/** Enforces policy for passphrase generation options.
 */
class PassphraseGeneratorOptionsEvaluator {
    /** Instantiates the evaluator.
     * @param policy The policy applied by the evaluator. When this conflicts with
     *               the defaults, the policy takes precedence.
     */
    constructor(policy) {
        function createBoundary(value, defaultBoundary) {
            const boundary = {
                min: Math.max(defaultBoundary.min, value),
                max: Math.max(defaultBoundary.max, value),
            };
            return boundary;
        }
        this.policy = policy.clone();
        this.numWords = createBoundary(policy.minNumberWords, passphrase_generator_options_evaluator_DefaultBoundaries.numWords);
    }
    /** Apply policy to the input options.
     *  @param options The options to build from. These options are not altered.
     *  @returns A new password generation request with policy applied.
     */
    applyPolicy(options) {
        function fitToBounds(value, boundaries) {
            const { min, max } = boundaries;
            const withUpperBound = Math.min(value !== null && value !== void 0 ? value : boundaries.min, max);
            const withLowerBound = Math.max(withUpperBound, min);
            return withLowerBound;
        }
        // apply policy overrides
        const capitalize = this.policy.capitalize || options.capitalize || false;
        const includeNumber = this.policy.includeNumber || options.includeNumber || false;
        // apply boundaries
        const numWords = fitToBounds(options.numWords, this.numWords);
        return Object.assign(Object.assign({}, options), { numWords,
            capitalize,
            includeNumber });
    }
    /** Ensures internal options consistency.
     *  @param options The options to cascade. These options are not altered.
     *  @returns A passphrase generation request with cascade applied.
     */
    sanitize(options) {
        var _a, _b;
        // ensure words are separated by a single character
        const wordSeparator = (_b = (_a = options.wordSeparator) === null || _a === void 0 ? void 0 : _a[0]) !== null && _b !== void 0 ? _b : "-";
        return Object.assign(Object.assign({}, options), { wordSeparator });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/password-generation.service.ts
var password_generation_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







const DefaultOptions = {
    length: 14,
    minLength: 5,
    ambiguous: false,
    number: true,
    minNumber: 1,
    uppercase: true,
    minUppercase: 0,
    lowercase: true,
    minLowercase: 0,
    special: false,
    minSpecial: 1,
    type: "password",
    numWords: 3,
    wordSeparator: "-",
    capitalize: false,
    includeNumber: false,
};
const DefaultPolicy = new PasswordGeneratorPolicyOptions();
const MaxPasswordsInHistory = 100;
class PasswordGenerationService {
    constructor(cryptoService, policyService, stateService) {
        this.cryptoService = cryptoService;
        this.policyService = policyService;
        this.stateService = stateService;
    }
    generatePassword(options) {
        var _a;
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            if (((_a = options.type) !== null && _a !== void 0 ? _a : DefaultOptions.type) === "passphrase") {
                return this.generatePassphrase(Object.assign(Object.assign({}, DefaultOptions), options));
            }
            const evaluator = new password_generator_options_evaluator_PasswordGeneratorOptionsEvaluator(DefaultPolicy);
            const o = evaluator.sanitize(Object.assign(Object.assign({}, DefaultOptions), options));
            const positions = [];
            if (o.lowercase && o.minLowercase > 0) {
                for (let i = 0; i < o.minLowercase; i++) {
                    positions.push("l");
                }
            }
            if (o.uppercase && o.minUppercase > 0) {
                for (let i = 0; i < o.minUppercase; i++) {
                    positions.push("u");
                }
            }
            if (o.number && o.minNumber > 0) {
                for (let i = 0; i < o.minNumber; i++) {
                    positions.push("n");
                }
            }
            if (o.special && o.minSpecial > 0) {
                for (let i = 0; i < o.minSpecial; i++) {
                    positions.push("s");
                }
            }
            while (positions.length < o.length) {
                positions.push("a");
            }
            // shuffle
            yield this.shuffleArray(positions);
            // build out the char sets
            let allCharSet = "";
            let lowercaseCharSet = "abcdefghijkmnopqrstuvwxyz";
            if (o.ambiguous) {
                lowercaseCharSet += "l";
            }
            if (o.lowercase) {
                allCharSet += lowercaseCharSet;
            }
            let uppercaseCharSet = "ABCDEFGHJKLMNPQRSTUVWXYZ";
            if (o.ambiguous) {
                uppercaseCharSet += "IO";
            }
            if (o.uppercase) {
                allCharSet += uppercaseCharSet;
            }
            let numberCharSet = "23456789";
            if (o.ambiguous) {
                numberCharSet += "01";
            }
            if (o.number) {
                allCharSet += numberCharSet;
            }
            const specialCharSet = "!@#$%^&*";
            if (o.special) {
                allCharSet += specialCharSet;
            }
            let password = "";
            for (let i = 0; i < o.length; i++) {
                let positionChars;
                switch (positions[i]) {
                    case "l":
                        positionChars = lowercaseCharSet;
                        break;
                    case "u":
                        positionChars = uppercaseCharSet;
                        break;
                    case "n":
                        positionChars = numberCharSet;
                        break;
                    case "s":
                        positionChars = specialCharSet;
                        break;
                    case "a":
                        positionChars = allCharSet;
                        break;
                    default:
                        break;
                }
                const randomCharIndex = yield this.cryptoService.randomNumber(0, positionChars.length - 1);
                password += positionChars.charAt(randomCharIndex);
            }
            return password;
        });
    }
    generatePassphrase(options) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            const evaluator = new PassphraseGeneratorOptionsEvaluator(DefaultPolicy);
            const o = evaluator.sanitize(Object.assign(Object.assign({}, DefaultOptions), options));
            if (o.numWords == null || o.numWords <= 2) {
                o.numWords = DefaultOptions.numWords;
            }
            if (o.wordSeparator == null || o.wordSeparator.length === 0 || o.wordSeparator.length > 1) {
                o.wordSeparator = " ";
            }
            if (o.capitalize == null) {
                o.capitalize = false;
            }
            if (o.includeNumber == null) {
                o.includeNumber = false;
            }
            const listLength = EFFLongWordList.length - 1;
            const wordList = new Array(o.numWords);
            for (let i = 0; i < o.numWords; i++) {
                const wordIndex = yield this.cryptoService.randomNumber(0, listLength);
                if (o.capitalize) {
                    wordList[i] = this.capitalize(EFFLongWordList[wordIndex]);
                }
                else {
                    wordList[i] = EFFLongWordList[wordIndex];
                }
            }
            if (o.includeNumber) {
                yield this.appendRandomNumberToRandomWord(wordList);
            }
            return wordList.join(o.wordSeparator);
        });
    }
    getOptions() {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            let options = yield this.stateService.getPasswordGenerationOptions();
            if (options == null) {
                options = Object.assign({}, DefaultOptions);
            }
            else {
                options = Object.assign({}, DefaultOptions, options);
            }
            yield this.stateService.setPasswordGenerationOptions(options);
            const enforcedOptions = yield this.enforcePasswordGeneratorPoliciesOnOptions(options);
            options = enforcedOptions[0];
            return [options, enforcedOptions[1]];
        });
    }
    enforcePasswordGeneratorPoliciesOnOptions(options) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            let policy = yield this.getPasswordGeneratorPolicyOptions();
            policy = policy !== null && policy !== void 0 ? policy : new PasswordGeneratorPolicyOptions();
            // Force default type if password/passphrase selected via policy
            if (policy.defaultType === "password" || policy.defaultType === "passphrase") {
                options.type = policy.defaultType;
            }
            const evaluator = options.type
                ? new password_generator_options_evaluator_PasswordGeneratorOptionsEvaluator(policy)
                : new PassphraseGeneratorOptionsEvaluator(policy);
            // Ensure the options to pass the current rules
            const withPolicy = evaluator.applyPolicy(options);
            const sanitized = evaluator.sanitize(withPolicy);
            // callers assume this function updates the options parameter
            const result = Object.assign(options, sanitized);
            return [result, policy];
        });
    }
    getPasswordGeneratorPolicyOptions() {
        var _a;
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            const policies = yield ((_a = this.policyService) === null || _a === void 0 ? void 0 : _a.getAll(policy_type_enum_PolicyType.PasswordGenerator));
            let enforcedOptions = null;
            if (policies == null || policies.length === 0) {
                return enforcedOptions;
            }
            policies.forEach((currentPolicy) => {
                if (!currentPolicy.enabled || currentPolicy.data == null) {
                    return;
                }
                if (enforcedOptions == null) {
                    enforcedOptions = new PasswordGeneratorPolicyOptions();
                }
                // Password wins in multi-org collisions
                if (currentPolicy.data.defaultType != null && enforcedOptions.defaultType !== "password") {
                    enforcedOptions.defaultType = currentPolicy.data.defaultType;
                }
                if (currentPolicy.data.minLength != null &&
                    currentPolicy.data.minLength > enforcedOptions.minLength) {
                    enforcedOptions.minLength = currentPolicy.data.minLength;
                }
                if (currentPolicy.data.useUpper) {
                    enforcedOptions.useUppercase = true;
                }
                if (currentPolicy.data.useLower) {
                    enforcedOptions.useLowercase = true;
                }
                if (currentPolicy.data.useNumbers) {
                    enforcedOptions.useNumbers = true;
                }
                if (currentPolicy.data.minNumbers != null &&
                    currentPolicy.data.minNumbers > enforcedOptions.numberCount) {
                    enforcedOptions.numberCount = currentPolicy.data.minNumbers;
                }
                if (currentPolicy.data.useSpecial) {
                    enforcedOptions.useSpecial = true;
                }
                if (currentPolicy.data.minSpecial != null &&
                    currentPolicy.data.minSpecial > enforcedOptions.specialCount) {
                    enforcedOptions.specialCount = currentPolicy.data.minSpecial;
                }
                if (currentPolicy.data.minNumberWords != null &&
                    currentPolicy.data.minNumberWords > enforcedOptions.minNumberWords) {
                    enforcedOptions.minNumberWords = currentPolicy.data.minNumberWords;
                }
                if (currentPolicy.data.capitalize) {
                    enforcedOptions.capitalize = true;
                }
                if (currentPolicy.data.includeNumber) {
                    enforcedOptions.includeNumber = true;
                }
            });
            return enforcedOptions;
        });
    }
    saveOptions(options) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setPasswordGenerationOptions(options);
        });
    }
    getHistory() {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            const hasKey = yield this.cryptoService.hasUserKey();
            if (!hasKey) {
                return new Array();
            }
            if ((yield this.stateService.getDecryptedPasswordGenerationHistory()) == null) {
                const encrypted = yield this.stateService.getEncryptedPasswordGenerationHistory();
                const decrypted = yield this.decryptHistory(encrypted);
                yield this.stateService.setDecryptedPasswordGenerationHistory(decrypted);
            }
            const passwordGenerationHistory = yield this.stateService.getDecryptedPasswordGenerationHistory();
            return passwordGenerationHistory != null
                ? passwordGenerationHistory
                : new Array();
        });
    }
    addHistory(password) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            // Cannot add new history if no key is available
            const hasKey = yield this.cryptoService.hasUserKey();
            if (!hasKey) {
                return;
            }
            const currentHistory = yield this.getHistory();
            // Prevent duplicates
            if (this.matchesPrevious(password, currentHistory)) {
                return;
            }
            currentHistory.unshift(new GeneratedPasswordHistory(password, Date.now()));
            // Remove old items.
            if (currentHistory.length > MaxPasswordsInHistory) {
                currentHistory.pop();
            }
            const newHistory = yield this.encryptHistory(currentHistory);
            yield this.stateService.setDecryptedPasswordGenerationHistory(currentHistory);
            return yield this.stateService.setEncryptedPasswordGenerationHistory(newHistory);
        });
    }
    clear(userId) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setEncryptedPasswordGenerationHistory(null, { userId: userId });
            yield this.stateService.setDecryptedPasswordGenerationHistory(null, { userId: userId });
        });
    }
    normalizeOptions(options, enforcedPolicyOptions) {
        const evaluator = options.type
            ? new password_generator_options_evaluator_PasswordGeneratorOptionsEvaluator(enforcedPolicyOptions)
            : new PassphraseGeneratorOptionsEvaluator(enforcedPolicyOptions);
        const evaluatedOptions = evaluator.applyPolicy(options);
        const santizedOptions = evaluator.sanitize(evaluatedOptions);
        // callers assume this function updates the options parameter
        Object.assign(options, santizedOptions);
        return options;
    }
    capitalize(str) {
        return str.charAt(0).toUpperCase() + str.slice(1);
    }
    appendRandomNumberToRandomWord(wordList) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            if (wordList == null || wordList.length <= 0) {
                return;
            }
            const index = yield this.cryptoService.randomNumber(0, wordList.length - 1);
            const num = yield this.cryptoService.randomNumber(0, 9);
            wordList[index] = wordList[index] + num;
        });
    }
    encryptHistory(history) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            if (history == null || history.length === 0) {
                return Promise.resolve([]);
            }
            const promises = history.map((item) => password_generation_service_awaiter(this, void 0, void 0, function* () {
                const encrypted = yield this.cryptoService.encrypt(item.password);
                return new GeneratedPasswordHistory(encrypted.encryptedString, item.date);
            }));
            return yield Promise.all(promises);
        });
    }
    decryptHistory(history) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            if (history == null || history.length === 0) {
                return Promise.resolve([]);
            }
            const promises = history.map((item) => password_generation_service_awaiter(this, void 0, void 0, function* () {
                const decrypted = yield this.cryptoService.decryptToUtf8(new EncString(item.password));
                return new GeneratedPasswordHistory(decrypted, item.date);
            }));
            return yield Promise.all(promises);
        });
    }
    matchesPrevious(password, history) {
        if (history == null || history.length === 0) {
            return false;
        }
        return history[history.length - 1].password === password;
    }
    // ref: https://stackoverflow.com/a/12646864/1090359
    shuffleArray(array) {
        return password_generation_service_awaiter(this, void 0, void 0, function* () {
            for (let i = array.length - 1; i > 0; i--) {
                const j = yield this.cryptoService.randomNumber(0, i);
                [array[i], array[j]] = [array[j], array[i]];
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/generator/password/index.ts
// password generator "v2" interfaces







;// CONCATENATED MODULE: ../../libs/common/src/tools/send/enums/send-type.ts
var SendType;
(function (SendType) {
    SendType[SendType["Text"] = 0] = "Text";
    SendType[SendType["File"] = 1] = "File";
})(SendType || (SendType = {}));

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/data/send-file.data.ts
class SendFileData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.id = data.id;
        this.fileName = data.fileName;
        this.size = data.size;
        this.sizeName = data.sizeName;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/data/send-text.data.ts
class SendTextData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.text = data.text;
        this.hidden = data.hidden;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/data/send.data.ts



class SendData {
    constructor(response) {
        if (response == null) {
            return;
        }
        this.id = response.id;
        this.accessId = response.accessId;
        this.type = response.type;
        this.name = response.name;
        this.notes = response.notes;
        this.key = response.key;
        this.maxAccessCount = response.maxAccessCount;
        this.accessCount = response.accessCount;
        this.revisionDate = response.revisionDate;
        this.expirationDate = response.expirationDate;
        this.deletionDate = response.deletionDate;
        this.password = response.password;
        this.disabled = response.disable;
        this.hideEmail = response.hideEmail;
        switch (this.type) {
            case SendType.Text:
                this.text = new SendTextData(response.text);
                break;
            case SendType.File:
                this.file = new SendFileData(response.file);
                break;
            default:
                break;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/view/send-file.view.ts
class SendFileView {
    constructor(f) {
        this.id = null;
        this.size = null;
        this.sizeName = null;
        this.fileName = null;
        if (!f) {
            return;
        }
        this.id = f.id;
        this.size = f.size;
        this.sizeName = f.sizeName;
    }
    get fileSize() {
        try {
            if (this.size != null) {
                return parseInt(this.size, null);
            }
        }
        catch (_a) {
            // Invalid file size.
        }
        return 0;
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new SendFileView(), json);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/view/send-text.view.ts
class SendTextView {
    constructor(t) {
        this.text = null;
        if (!t) {
            return;
        }
        this.hidden = t.hidden;
    }
    get maskedText() {
        return this.text != null ? "••••••••" : null;
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new SendTextView(), json);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/view/send.view.ts




class SendView {
    constructor(s) {
        this.id = null;
        this.accessId = null;
        this.name = null;
        this.notes = null;
        this.type = null;
        this.text = new SendTextView();
        this.file = new SendFileView();
        this.maxAccessCount = null;
        this.accessCount = 0;
        this.revisionDate = null;
        this.deletionDate = null;
        this.expirationDate = null;
        this.password = null;
        this.disabled = false;
        this.hideEmail = false;
        if (!s) {
            return;
        }
        this.id = s.id;
        this.accessId = s.accessId;
        this.type = s.type;
        this.maxAccessCount = s.maxAccessCount;
        this.accessCount = s.accessCount;
        this.revisionDate = s.revisionDate;
        this.deletionDate = s.deletionDate;
        this.expirationDate = s.expirationDate;
        this.disabled = s.disabled;
        this.password = s.password;
        this.hideEmail = s.hideEmail;
    }
    get urlB64Key() {
        return utils_Utils.fromBufferToUrlB64(this.key);
    }
    get maxAccessCountReached() {
        if (this.maxAccessCount == null) {
            return false;
        }
        return this.accessCount >= this.maxAccessCount;
    }
    get expired() {
        if (this.expirationDate == null) {
            return false;
        }
        return this.expirationDate <= new Date();
    }
    get pendingDelete() {
        return this.deletionDate <= new Date();
    }
    toJSON() {
        return utils_Utils.merge(Object.assign({}, this), {
            key: utils_Utils.fromBufferToB64(this.key),
        });
    }
    static fromJSON(json) {
        if (json == null) {
            return null;
        }
        return Object.assign(new SendView(), json, {
            key: utils_Utils.fromB64ToArray(json.key),
            cryptoKey: SymmetricCryptoKey.fromJSON(json.cryptoKey),
            text: SendTextView.fromJSON(json.text),
            file: SendFileView.fromJSON(json.file),
            revisionDate: json.revisionDate == null ? null : new Date(json.revisionDate),
            deletionDate: json.deletionDate == null ? null : new Date(json.deletionDate),
            expirationDate: json.expirationDate == null ? null : new Date(json.expirationDate),
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/attachment.data.ts
class AttachmentData {
    constructor(response) {
        if (response == null) {
            return;
        }
        this.id = response.id;
        this.url = response.url;
        this.fileName = response.fileName;
        this.key = response.key;
        this.size = response.size;
        this.sizeName = response.sizeName;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/card.data.ts
class CardData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.cardholderName = data.cardholderName;
        this.brand = data.brand;
        this.number = data.number;
        this.expMonth = data.expMonth;
        this.expYear = data.expYear;
        this.code = data.code;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/field.data.ts
class FieldData {
    constructor(response) {
        if (response == null) {
            return;
        }
        this.type = response.type;
        this.name = response.name;
        this.value = response.value;
        this.linkedId = response.linkedId;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/identity.data.ts
class IdentityData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.title = data.title;
        this.firstName = data.firstName;
        this.middleName = data.middleName;
        this.lastName = data.lastName;
        this.address1 = data.address1;
        this.address2 = data.address2;
        this.address3 = data.address3;
        this.city = data.city;
        this.state = data.state;
        this.postalCode = data.postalCode;
        this.country = data.country;
        this.company = data.company;
        this.email = data.email;
        this.phone = data.phone;
        this.ssn = data.ssn;
        this.username = data.username;
        this.passportNumber = data.passportNumber;
        this.licenseNumber = data.licenseNumber;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/fido2-credential.data.ts
class Fido2CredentialData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.credentialId = data.credentialId;
        this.keyType = data.keyType;
        this.keyAlgorithm = data.keyAlgorithm;
        this.keyCurve = data.keyCurve;
        this.keyValue = data.keyValue;
        this.rpId = data.rpId;
        this.userHandle = data.userHandle;
        this.userName = data.userName;
        this.counter = data.counter;
        this.rpName = data.rpName;
        this.userDisplayName = data.userDisplayName;
        this.discoverable = data.discoverable;
        this.creationDate = data.creationDate;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/login-uri.data.ts
class LoginUriData {
    constructor(data) {
        this.match = null;
        if (data == null) {
            return;
        }
        this.uri = data.uri;
        this.uriChecksum = data.uriChecksum;
        this.match = data.match;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/login.data.ts


class LoginData {
    constructor(data) {
        var _a;
        if (data == null) {
            return;
        }
        this.username = data.username;
        this.password = data.password;
        this.passwordRevisionDate = data.passwordRevisionDate;
        this.totp = data.totp;
        this.autofillOnPageLoad = data.autofillOnPageLoad;
        if (data.uris) {
            this.uris = data.uris.map((u) => new LoginUriData(u));
        }
        if (data.fido2Credentials) {
            this.fido2Credentials = (_a = data.fido2Credentials) === null || _a === void 0 ? void 0 : _a.map((key) => new Fido2CredentialData(key));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/password-history.data.ts
class PasswordHistoryData {
    constructor(response) {
        if (response == null) {
            return;
        }
        this.password = response.password;
        this.lastUsedDate = response.lastUsedDate;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/secure-note.data.ts
class SecureNoteData {
    constructor(data) {
        if (data == null) {
            return;
        }
        this.type = data.type;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/cipher.data.ts








class CipherData {
    constructor(response, collectionIds) {
        if (response == null) {
            return;
        }
        this.id = response.id;
        this.organizationId = response.organizationId;
        this.folderId = response.folderId;
        this.edit = response.edit;
        this.viewPassword = response.viewPassword;
        this.organizationUseTotp = response.organizationUseTotp;
        this.favorite = response.favorite;
        this.revisionDate = response.revisionDate;
        this.type = response.type;
        this.name = response.name;
        this.notes = response.notes;
        this.collectionIds = collectionIds != null ? collectionIds : response.collectionIds;
        this.creationDate = response.creationDate;
        this.deletedDate = response.deletedDate;
        this.reprompt = response.reprompt;
        this.key = response.key;
        switch (this.type) {
            case CipherType.Login:
                this.login = new LoginData(response.login);
                break;
            case CipherType.SecureNote:
                this.secureNote = new SecureNoteData(response.secureNote);
                break;
            case CipherType.Card:
                this.card = new CardData(response.card);
                break;
            case CipherType.Identity:
                this.identity = new IdentityData(response.identity);
                break;
            default:
                break;
        }
        if (response.fields != null) {
            this.fields = response.fields.map((f) => new FieldData(f));
        }
        if (response.attachments != null) {
            this.attachments = response.attachments.map((a) => new AttachmentData(a));
        }
        if (response.passwordHistory != null) {
            this.passwordHistory = response.passwordHistory.map((ph) => new PasswordHistoryData(ph));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/collection.data.ts
class CollectionData {
    constructor(response) {
        this.id = response.id;
        this.organizationId = response.organizationId;
        this.name = response.name;
        this.externalId = response.externalId;
        this.readOnly = response.readOnly;
        this.manage = response.manage;
        this.hidePasswords = response.hidePasswords;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/data/folder.data.ts
class FolderData {
    constructor(response) {
        this.name = response.name;
        this.id = response.id;
        this.revisionDate = response.revisionDate;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/collection.ts


class Collection extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            id: null,
            organizationId: null,
            name: null,
            externalId: null,
            readOnly: null,
            hidePasswords: null,
            manage: null,
        }, ["id", "organizationId", "externalId", "readOnly", "hidePasswords", "manage"]);
    }
    decrypt() {
        return this.decryptObj(new CollectionView(this), {
            name: null,
        }, this.organizationId);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/view/collection.view.ts

const NestingDelimiter = "/";
class CollectionView {
    constructor(c) {
        this.id = null;
        this.organizationId = null;
        this.name = null;
        this.externalId = null;
        // readOnly applies to the items within a collection
        this.readOnly = null;
        this.hidePasswords = null;
        this.manage = null;
        if (!c) {
            return;
        }
        this.id = c.id;
        this.organizationId = c.organizationId;
        this.externalId = c.externalId;
        if (c instanceof Collection) {
            this.readOnly = c.readOnly;
            this.hidePasswords = c.hidePasswords;
            this.manage = c.manage;
        }
    }
    // For editing collection details, not the items within it.
    canEdit(org) {
        if (org != null && org.id !== this.organizationId) {
            throw new Error("Id of the organization provided does not match the org id of the collection.");
        }
        return (org === null || org === void 0 ? void 0 : org.flexibleCollections)
            ? (org === null || org === void 0 ? void 0 : org.canEditAnyCollection) || this.manage
            : (org === null || org === void 0 ? void 0 : org.canEditAnyCollection) || (org === null || org === void 0 ? void 0 : org.canEditAssignedCollections);
    }
    // For deleting a collection, not the items within it.
    canDelete(org) {
        if (org != null && org.id !== this.organizationId) {
            throw new Error("Id of the organization provided does not match the org id of the collection.");
        }
        return (org === null || org === void 0 ? void 0 : org.flexibleCollections)
            ? (org === null || org === void 0 ? void 0 : org.canDeleteAnyCollection) || (!(org === null || org === void 0 ? void 0 : org.limitCollectionCreationDeletion) && this.manage)
            : (org === null || org === void 0 ? void 0 : org.canDeleteAnyCollection) || (org === null || org === void 0 ? void 0 : org.canDeleteAssignedCollections);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/models/domain/state.ts
class State {
    constructor(globals) {
        this.accounts = {};
        this.authenticatedAccounts = [];
        this.accountActivity = {};
        this.globals = globals;
    }
    // TODO, make Jsonify<State,TGlobalState,TAccount> work. It currently doesn't because Globals doesn't implement Jsonify.
    static fromJSON(obj, accountDeserializer) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new State(null), obj, {
            accounts: State.buildAccountMapFromJSON(obj === null || obj === void 0 ? void 0 : obj.accounts, accountDeserializer),
        });
    }
    static buildAccountMapFromJSON(jsonAccounts, accountDeserializer) {
        if (!jsonAccounts) {
            return {};
        }
        const accounts = {};
        for (const userId in jsonAccounts) {
            accounts[userId] = accountDeserializer(jsonAccounts[userId]);
        }
        return accounts;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/services/state.service.ts
var state_service_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var state_service_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var state_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



























const keys = {
    state: "state",
    stateVersion: "stateVersion",
    global: "global",
    authenticatedAccounts: "authenticatedAccounts",
    activeUserId: "activeUserId",
    tempAccountSettings: "tempAccountSettings",
    accountActivity: "accountActivity",
};
const partialKeys = {
    userAutoKey: "_user_auto",
    userBiometricKey: "_user_biometric",
    autoKey: "_masterkey_auto",
    biometricKey: "_masterkey_biometric",
    masterKey: "_masterkey",
};
const DDG_SHARED_KEY = "DuckDuckGoSharedKey";
class StateService {
    constructor(storageService, secureStorageService, memoryStorageService, logService, stateFactory, accountService, environmentService, useAccountCache = true) {
        this.storageService = storageService;
        this.secureStorageService = secureStorageService;
        this.memoryStorageService = memoryStorageService;
        this.logService = logService;
        this.stateFactory = stateFactory;
        this.accountService = accountService;
        this.environmentService = environmentService;
        this.useAccountCache = useAccountCache;
        this.accountsSubject = new external_rxjs_namespaceObject.BehaviorSubject({});
        this.accounts$ = this.accountsSubject.asObservable();
        this.activeAccountSubject = new external_rxjs_namespaceObject.BehaviorSubject(null);
        this.activeAccount$ = this.activeAccountSubject.asObservable();
        this.activeAccountUnlockedSubject = new external_rxjs_namespaceObject.BehaviorSubject(false);
        this.activeAccountUnlocked$ = this.activeAccountUnlockedSubject.asObservable();
        this.hasBeenInited = false;
        this.isRecoveredSession = false;
        this.accountDiskCache = new external_rxjs_namespaceObject.BehaviorSubject({});
        // default account serializer, must be overridden by child class
        this.accountDeserializer = Account.fromJSON;
        // If the account gets changed, verify the new account is unlocked
        this.activeAccountSubject
            .pipe((0,external_rxjs_namespaceObject.concatMap)((userId) => state_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null && this.activeAccountUnlockedSubject.getValue() == false) {
                return;
            }
            else if (userId == null) {
                this.activeAccountUnlockedSubject.next(false);
            }
            // FIXME: This should be refactored into AuthService or a similar service,
            //  as checking for the existence of the crypto key is a low level
            //  implementation detail.
            this.activeAccountUnlockedSubject.next((yield this.getUserKey()) != null);
        })))
            .subscribe();
    }
    init() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            if (this.hasBeenInited) {
                return;
            }
            yield migrate(this.storageService, this.logService);
            yield this.state().then((state) => state_service_awaiter(this, void 0, void 0, function* () {
                if (state == null) {
                    yield this.setState(new State(this.createGlobals()));
                }
                else {
                    this.isRecoveredSession = true;
                }
            }));
            yield this.initAccountState();
            this.hasBeenInited = true;
        });
    }
    initAccountState() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            if (this.isRecoveredSession) {
                return;
            }
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                var _a;
                state.authenticatedAccounts =
                    (_a = (yield this.storageService.get(keys.authenticatedAccounts))) !== null && _a !== void 0 ? _a : [];
                for (const i in state.authenticatedAccounts) {
                    if (i != null) {
                        state = yield this.syncAccountFromDisk(state.authenticatedAccounts[i]);
                    }
                }
                const storedActiveUser = yield this.storageService.get(keys.activeUserId);
                if (storedActiveUser != null) {
                    state.activeUserId = storedActiveUser;
                }
                yield this.pushAccounts();
                this.activeAccountSubject.next(state.activeUserId);
                // TODO: Temporary update to avoid routing all account status changes through account service for now.
                // account service tracks logged out accounts, but State service does not, so we need to add the active account
                // if it's not in the accounts list.
                if (state.activeUserId != null && this.accountsSubject.value[state.activeUserId] == null) {
                    const activeDiskAccount = yield this.getAccountFromDisk({ userId: state.activeUserId });
                    yield this.accountService.addAccount(state.activeUserId, {
                        name: activeDiskAccount.profile.name,
                        email: activeDiskAccount.profile.email,
                        status: AuthenticationStatus.LoggedOut,
                    });
                }
                yield this.accountService.switchAccount(state.activeUserId);
                // End TODO
                return state;
            }));
        });
    }
    syncAccountFromDisk(userId) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null) {
                return;
            }
            const diskAccount = yield this.getAccountFromDisk({ userId: userId });
            const state = yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                if (state.accounts == null) {
                    state.accounts = {};
                }
                state.accounts[userId] = this.createAccount();
                state.accounts[userId].profile = diskAccount.profile;
                return state;
            }));
            // TODO: Temporary update to avoid routing all account status changes through account service for now.
            // The determination of state should be handled by the various services that control those values.
            const token = yield this.getAccessToken({ userId: userId });
            const autoKey = yield this.getUserKeyAutoUnlock({ userId: userId });
            const accountStatus = token == null
                ? AuthenticationStatus.LoggedOut
                : autoKey == null
                    ? AuthenticationStatus.Locked
                    : AuthenticationStatus.Unlocked;
            yield this.accountService.addAccount(userId, {
                status: accountStatus,
                name: diskAccount.profile.name,
                email: diskAccount.profile.email,
            });
            return state;
        });
    }
    addAccount(account) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.environmentService.seedUserEnvironment(account.profile.userId);
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                state.authenticatedAccounts.push(account.profile.userId);
                yield this.storageService.save(keys.authenticatedAccounts, state.authenticatedAccounts);
                state.accounts[account.profile.userId] = account;
                return state;
            }));
            yield this.scaffoldNewAccountStorage(account);
            yield this.setLastActive(new Date().getTime(), { userId: account.profile.userId });
            // TODO: Temporary update to avoid routing all account status changes through account service for now.
            yield this.accountService.addAccount(account.profile.userId, {
                status: AuthenticationStatus.Locked,
                name: account.profile.name,
                email: account.profile.email,
            });
            yield this.setActiveUser(account.profile.userId);
        });
    }
    setActiveUser(userId) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.clearDecryptedDataForActiveUser();
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                state.activeUserId = userId;
                yield this.storageService.save(keys.activeUserId, userId);
                this.activeAccountSubject.next(state.activeUserId);
                // TODO: temporary update to avoid routing all account status changes through account service for now.
                yield this.accountService.switchAccount(userId);
                return state;
            }));
            yield this.pushAccounts();
        });
    }
    clean(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultInMemoryOptions());
            yield this.deAuthenticateAccount(options.userId);
            let currentUser = (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId;
            if (options.userId === currentUser) {
                currentUser = yield this.dynamicallySetActiveUser();
            }
            yield this.removeAccountFromDisk(options === null || options === void 0 ? void 0 : options.userId);
            yield this.removeAccountFromMemory(options === null || options === void 0 ? void 0 : options.userId);
            yield this.pushAccounts();
            return currentUser;
        });
    }
    getAccessToken(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = yield this.getTimeoutBasedStorageOptions(options);
            return (_b = (_a = (yield this.getAccount(options))) === null || _a === void 0 ? void 0 : _a.tokens) === null || _b === void 0 ? void 0 : _b.accessToken;
        });
    }
    setAccessToken(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = yield this.getTimeoutBasedStorageOptions(options);
            const account = yield this.getAccount(options);
            account.tokens.accessToken = value;
            yield this.saveAccount(account, options);
        });
    }
    getAddEditCipherInfo(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            // ensure prototype on cipher
            const raw = (_a = account === null || account === void 0 ? void 0 : account.data) === null || _a === void 0 ? void 0 : _a.addEditCipherInfo;
            return raw == null
                ? null
                : {
                    cipher: (raw === null || raw === void 0 ? void 0 : raw.cipher.toJSON) != null
                        ? raw.cipher
                        : CipherView.fromJSON(raw === null || raw === void 0 ? void 0 : raw.cipher),
                    collectionIds: raw === null || raw === void 0 ? void 0 : raw.collectionIds,
                };
        });
    }
    setAddEditCipherInfo(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.data.addEditCipherInfo = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getAlwaysShowDock(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.alwaysShowDock) !== null && _b !== void 0 ? _b : false);
        });
    }
    setAlwaysShowDock(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.alwaysShowDock = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getApiKeyClientId(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = yield this.getTimeoutBasedStorageOptions(options);
            return (_b = (_a = (yield this.getAccount(options))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.apiKeyClientId;
        });
    }
    setApiKeyClientId(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = yield this.getTimeoutBasedStorageOptions(options);
            const account = yield this.getAccount(options);
            account.profile.apiKeyClientId = value;
            yield this.saveAccount(account, options);
        });
    }
    getApiKeyClientSecret(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = yield this.getTimeoutBasedStorageOptions(options);
            return (_b = (_a = (yield this.getAccount(options))) === null || _a === void 0 ? void 0 : _a.keys) === null || _b === void 0 ? void 0 : _b.apiKeyClientSecret;
        });
    }
    setApiKeyClientSecret(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = yield this.getTimeoutBasedStorageOptions(options);
            const account = yield this.getAccount(options);
            account.keys.apiKeyClientSecret = value;
            yield this.saveAccount(account, options);
        });
    }
    getAutoConfirmFingerPrints(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.autoConfirmFingerPrints) !== null && _c !== void 0 ? _c : false);
        });
    }
    setAutoConfirmFingerprints(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.autoConfirmFingerPrints = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getAutoFillOnPageLoadDefault(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.autoFillOnPageLoadDefault) !== null && _c !== void 0 ? _c : true);
        });
    }
    setAutoFillOnPageLoadDefault(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.autoFillOnPageLoadDefault = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getBiometricAwaitingAcceptance(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.biometricAwaitingAcceptance) !== null && _b !== void 0 ? _b : false);
        });
    }
    setBiometricAwaitingAcceptance(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.biometricAwaitingAcceptance = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getBiometricFingerprintValidated(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.biometricFingerprintValidated) !== null && _b !== void 0 ? _b : false);
        });
    }
    setBiometricFingerprintValidated(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.biometricFingerprintValidated = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getBiometricText(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.biometricText;
        });
    }
    setBiometricText(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.biometricText = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getBiometricUnlock(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.biometricUnlock) !== null && _c !== void 0 ? _c : false);
        });
    }
    setBiometricUnlock(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.biometricUnlock = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getCanAccessPremium(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            if (!(yield this.getIsAuthenticated(options))) {
                return false;
            }
            return ((yield this.getHasPremiumPersonally(options)) ||
                (yield this.getHasPremiumFromOrganization(options)));
        });
    }
    getHasPremiumPersonally(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            return (_a = account === null || account === void 0 ? void 0 : account.profile) === null || _a === void 0 ? void 0 : _a.hasPremiumPersonally;
        });
    }
    setHasPremiumPersonally(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.profile.hasPremiumPersonally = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getHasPremiumFromOrganization(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            if ((_a = account.profile) === null || _a === void 0 ? void 0 : _a.hasPremiumFromOrganization) {
                return true;
            }
            // TODO: older server versions won't send the hasPremiumFromOrganization flag, so we're keeping the old logic
            // for backwards compatibility. It can be removed after everyone has upgraded.
            const organizations = yield this.getOrganizations(options);
            if (organizations == null) {
                return false;
            }
            for (const id of Object.keys(organizations)) {
                const o = organizations[id];
                if (o.enabled && o.usersGetPremium && !o.isProviderUser) {
                    return true;
                }
            }
            return false;
        });
    }
    setHasPremiumFromOrganization(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.profile.hasPremiumFromOrganization = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getClearClipboard(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.clearClipboard) !== null && _c !== void 0 ? _c : null);
        });
    }
    setClearClipboard(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.clearClipboard = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getCollapsedGroupings(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.collapsedGroupings;
        });
    }
    setCollapsedGroupings(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.collapsedGroupings = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getConvertAccountToKeyConnector(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.convertAccountToKeyConnector;
        });
    }
    setConvertAccountToKeyConnector(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.profile.convertAccountToKeyConnector = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    /**
     * @deprecated Do not save the Master Key. Use the User Symmetric Key instead
     */
    getCryptoMasterKey(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            return (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.cryptoMasterKey;
        });
    }
    /**
     * @deprecated Do not save the Master Key. Use the User Symmetric Key instead
     */
    setCryptoMasterKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.keys.cryptoMasterKey = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            const nextStatus = value != null ? AuthenticationStatus.Unlocked : AuthenticationStatus.Locked;
            yield this.accountService.setAccountStatus(options.userId, nextStatus);
            if (options.userId == this.activeAccountSubject.getValue()) {
                const nextValue = value != null;
                // Avoid emitting if we are already unlocked
                if (this.activeAccountUnlockedSubject.getValue() != nextValue) {
                    this.activeAccountUnlockedSubject.next(nextValue);
                }
            }
        });
    }
    /**
     * user key used to encrypt/decrypt data
     */
    getUserKey(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            return (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.userKey;
        });
    }
    /**
     * user key used to encrypt/decrypt data
     */
    setUserKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.keys.userKey = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            const nextStatus = value != null ? AuthenticationStatus.Unlocked : AuthenticationStatus.Locked;
            yield this.accountService.setAccountStatus(options.userId, nextStatus);
            if ((options === null || options === void 0 ? void 0 : options.userId) == this.activeAccountSubject.getValue()) {
                const nextValue = value != null;
                // Avoid emitting if we are already unlocked
                if (this.activeAccountUnlockedSubject.getValue() != nextValue) {
                    this.activeAccountUnlockedSubject.next(nextValue);
                }
            }
        });
    }
    /**
     * User's master key derived from MP, saved only if we decrypted with MP
     */
    getMasterKey(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            return (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.masterKey;
        });
    }
    /**
     * User's master key derived from MP, saved only if we decrypted with MP
     */
    setMasterKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.keys.masterKey = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    /**
     * The master key encrypted User symmetric key, saved on every auth
     * so we can unlock with MP offline
     */
    getMasterKeyEncryptedUserKey(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.keys.masterKeyEncryptedUserKey;
        });
    }
    /**
     * The master key encrypted User symmetric key, saved on every auth
     * so we can unlock with MP offline
     */
    setMasterKeyEncryptedUserKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.keys.masterKeyEncryptedUserKey = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    /**
     * user key when using the "never" option of vault timeout
     */
    getUserKeyAutoUnlock(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "auto" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            return yield this.secureStorageService.get(`${options.userId}${partialKeys.userAutoKey}`, options);
        });
    }
    /**
     * user key when using the "never" option of vault timeout
     */
    setUserKeyAutoUnlock(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "auto" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            yield this.saveSecureStorageKey(partialKeys.userAutoKey, value, options);
        });
    }
    /**
     * User's encrypted symmetric key when using biometrics
     */
    getUserKeyBiometric(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "biometric" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            return yield this.secureStorageService.get(`${options.userId}${partialKeys.userBiometricKey}`, options);
        });
    }
    hasUserKeyBiometric(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "biometric" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return false;
            }
            return yield this.secureStorageService.has(`${options.userId}${partialKeys.userBiometricKey}`, options);
        });
    }
    setUserKeyBiometric(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "biometric" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            yield this.saveSecureStorageKey(partialKeys.userBiometricKey, value, options);
        });
    }
    getPinKeyEncryptedUserKey(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return EncString.fromJSON((_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.pinKeyEncryptedUserKey);
        });
    }
    setPinKeyEncryptedUserKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.pinKeyEncryptedUserKey = value === null || value === void 0 ? void 0 : value.encryptedString;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getPinKeyEncryptedUserKeyEphemeral(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return EncString.fromJSON((_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.pinKeyEncryptedUserKeyEphemeral);
        });
    }
    setPinKeyEncryptedUserKeyEphemeral(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.settings.pinKeyEncryptedUserKeyEphemeral = value === null || value === void 0 ? void 0 : value.encryptedString;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    /**
     * @deprecated Use UserKeyAuto instead
     */
    getCryptoMasterKeyAuto(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "auto" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            return yield this.secureStorageService.get(`${options.userId}${partialKeys.autoKey}`, options);
        });
    }
    /**
     * @deprecated Use UserKeyAuto instead
     */
    setCryptoMasterKeyAuto(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "auto" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            yield this.saveSecureStorageKey(partialKeys.autoKey, value, options);
        });
    }
    /**
     * @deprecated I don't see where this is even used
     */
    getCryptoMasterKeyB64(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            return yield this.secureStorageService.get(`${options === null || options === void 0 ? void 0 : options.userId}${partialKeys.masterKey}`, options);
        });
    }
    /**
     * @deprecated I don't see where this is even used
     */
    setCryptoMasterKeyB64(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            yield this.saveSecureStorageKey(partialKeys.masterKey, value, options);
        });
    }
    /**
     * @deprecated Use UserKeyBiometric instead
     */
    getCryptoMasterKeyBiometric(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "biometric" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            return yield this.secureStorageService.get(`${options.userId}${partialKeys.biometricKey}`, options);
        });
    }
    /**
     * @deprecated Use UserKeyBiometric instead
     */
    hasCryptoMasterKeyBiometric(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "biometric" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return false;
            }
            return yield this.secureStorageService.has(`${options.userId}${partialKeys.biometricKey}`, options);
        });
    }
    /**
     * @deprecated Use UserKeyBiometric instead
     */
    setCryptoMasterKeyBiometric(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(this.reconcileOptions(options, { keySuffix: "biometric" }), yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            yield this.saveSecureStorageKey(partialKeys.biometricKey, value, options);
        });
    }
    getBiometricPromptCancelled(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            return (_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.biometricPromptCancelled;
        });
    }
    setBiometricPromptCancelled(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.biometricPromptCancelled = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDecryptedCiphers(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.ciphers) === null || _c === void 0 ? void 0 : _c.decrypted;
        });
    }
    setDecryptedCiphers(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.data.ciphers.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDecryptedCollections(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.collections) === null || _c === void 0 ? void 0 : _c.decrypted;
        });
    }
    setDecryptedCollections(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.data.collections.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    /**
     * @deprecated Use UserKey instead
     */
    getDecryptedCryptoSymmetricKey(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            return (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.cryptoSymmetricKey) === null || _b === void 0 ? void 0 : _b.decrypted;
        });
    }
    /**
     * @deprecated Use UserKey instead
     */
    setDecryptedCryptoSymmetricKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.keys.cryptoSymmetricKey.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDecryptedPasswordGenerationHistory(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.passwordGenerationHistory) === null || _c === void 0 ? void 0 : _c.decrypted;
        });
    }
    setDecryptedPasswordGenerationHistory(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.data.passwordGenerationHistory.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    /**
     * @deprecated Use getPinKeyEncryptedUserKeyEphemeral instead
     */
    getDecryptedPinProtected(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.pinProtected) === null || _c === void 0 ? void 0 : _c.decrypted;
        });
    }
    /**
     * @deprecated Use setPinKeyEncryptedUserKeyEphemeral instead
     */
    setDecryptedPinProtected(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.settings.pinProtected.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDecryptedPolicies(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.policies) === null || _c === void 0 ? void 0 : _c.decrypted;
        });
    }
    setDecryptedPolicies(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.data.policies.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDecryptedPrivateKey(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.keys) === null || _b === void 0 ? void 0 : _b.privateKey.decrypted;
        });
    }
    setDecryptedPrivateKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.keys.privateKey.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDecryptedProviderKeys(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            return utils_Utils.recordToMap((_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.providerKeys) === null || _b === void 0 ? void 0 : _b.decrypted);
        });
    }
    setDecryptedProviderKeys(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.keys.providerKeys.decrypted = utils_Utils.mapToRecord(value);
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDecryptedSends(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.sends) === null || _c === void 0 ? void 0 : _c.decrypted;
        });
    }
    setDecryptedSends(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.data.sends.decrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getDefaultUriMatch(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.defaultUriMatch;
        });
    }
    setDefaultUriMatch(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.defaultUriMatch = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDisableAddLoginNotification(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.disableAddLoginNotification) !== null && _b !== void 0 ? _b : false);
        });
    }
    setDisableAddLoginNotification(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.disableAddLoginNotification = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDisableAutoBiometricsPrompt(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.disableAutoBiometricsPrompt) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDisableAutoBiometricsPrompt(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.disableAutoBiometricsPrompt = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDisableAutoTotpCopy(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.disableAutoTotpCopy) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDisableAutoTotpCopy(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.disableAutoTotpCopy = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDisableBadgeCounter(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.disableBadgeCounter) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDisableBadgeCounter(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.disableBadgeCounter = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDisableChangedPasswordNotification(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.disableChangedPasswordNotification) !== null && _b !== void 0 ? _b : false);
        });
    }
    setDisableChangedPasswordNotification(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.disableChangedPasswordNotification = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnablePasskeys(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.enablePasskeys) !== null && _b !== void 0 ? _b : true);
        });
    }
    setEnablePasskeys(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enablePasskeys = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDisableContextMenuItem(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.disableContextMenuItem) !== null && _b !== void 0 ? _b : false);
        });
    }
    setDisableContextMenuItem(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.disableContextMenuItem = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDisableFavicon(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.disableFavicon) !== null && _b !== void 0 ? _b : false);
        });
    }
    setDisableFavicon(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            globals.disableFavicon = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getDisableGa(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.disableGa) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDisableGa(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.disableGa = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDismissedAutofillCallout(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.dismissedAutoFillOnPageLoadCallout) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDismissedAutofillCallout(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.dismissedAutoFillOnPageLoadCallout = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDontShowCardsCurrentTab(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.dontShowCardsCurrentTab) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDontShowCardsCurrentTab(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.dontShowCardsCurrentTab = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDontShowIdentitiesCurrentTab(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.dontShowIdentitiesCurrentTab) !== null && _c !== void 0 ? _c : false);
        });
    }
    setDontShowIdentitiesCurrentTab(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.dontShowIdentitiesCurrentTab = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getDuckDuckGoSharedKey(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            return yield this.secureStorageService.get(DDG_SHARED_KEY, options);
        });
    }
    setDuckDuckGoSharedKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultSecureStorageOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            value == null
                ? yield this.secureStorageService.remove(DDG_SHARED_KEY, options)
                : yield this.secureStorageService.save(DDG_SHARED_KEY, value, options);
        });
    }
    getDeviceKey(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            const account = yield this.getAccount(options);
            const existingDeviceKey = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.deviceKey;
            // Must manually instantiate the SymmetricCryptoKey class from the JSON object
            if (existingDeviceKey != null) {
                return SymmetricCryptoKey.fromJSON(existingDeviceKey);
            }
            else {
                return null;
            }
        });
    }
    setDeviceKey(value, options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            const account = yield this.getAccount(options);
            account.keys.deviceKey = (_a = value === null || value === void 0 ? void 0 : value.toJSON()) !== null && _a !== void 0 ? _a : null;
            yield this.saveAccount(account, options);
        });
    }
    getAdminAuthRequest(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            const account = yield this.getAccount(options);
            return (account === null || account === void 0 ? void 0 : account.adminAuthRequest)
                ? AdminAuthRequestStorable.fromJSON(account.adminAuthRequest)
                : null;
        });
    }
    setAdminAuthRequest(adminAuthRequest, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            const account = yield this.getAccount(options);
            account.adminAuthRequest = adminAuthRequest === null || adminAuthRequest === void 0 ? void 0 : adminAuthRequest.toJSON();
            yield this.saveAccount(account, options);
        });
    }
    getShouldTrustDevice(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            const account = yield this.getAccount(options);
            return (_b = (_a = account === null || account === void 0 ? void 0 : account.settings) === null || _a === void 0 ? void 0 : _a.trustDeviceChoiceForDecryption) !== null && _b !== void 0 ? _b : null;
        });
    }
    setShouldTrustDevice(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            const account = yield this.getAccount(options);
            account.settings.trustDeviceChoiceForDecryption = value;
            yield this.saveAccount(account, options);
        });
    }
    getAccountDecryptionOptions(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return null;
            }
            const account = yield this.getAccount(options);
            return account === null || account === void 0 ? void 0 : account.decryptionOptions;
        });
    }
    setAccountDecryptionOptions(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions());
            if ((options === null || options === void 0 ? void 0 : options.userId) == null) {
                return;
            }
            const account = yield this.getAccount(options);
            account.decryptionOptions = value;
            yield this.saveAccount(account, options);
        });
    }
    getEmail(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.email;
        });
    }
    setEmail(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.profile.email = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getEmailVerified(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.profile.emailVerified) !== null && _b !== void 0 ? _b : false);
        });
    }
    setEmailVerified(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.profile.emailVerified = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableAlwaysOnTop(options) {
        var _a, _b, _c, _d;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const accountPreference = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.enableAlwaysOnTop;
            const globalPreference = (_c = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _c === void 0 ? void 0 : _c.enableAlwaysOnTop;
            return (_d = accountPreference !== null && accountPreference !== void 0 ? accountPreference : globalPreference) !== null && _d !== void 0 ? _d : false;
        });
    }
    setEnableAlwaysOnTop(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.enableAlwaysOnTop = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enableAlwaysOnTop = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getAutoFillOverlayVisibility(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const locallyStoredOptions = yield this.defaultOnDiskLocalOptions();
            const reconciledOptions = this.reconcileOptions(options, locallyStoredOptions);
            const globals = yield this.getGlobals(reconciledOptions);
            return (_a = globals === null || globals === void 0 ? void 0 : globals.autoFillOverlayVisibility) !== null && _a !== void 0 ? _a : AutofillOverlayVisibility.Off;
        });
    }
    setAutoFillOverlayVisibility(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            globals.autoFillOverlayVisibility = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getEnableAutoFillOnPageLoad(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.enableAutoFillOnPageLoad) !== null && _c !== void 0 ? _c : false);
        });
    }
    setEnableAutoFillOnPageLoad(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.enableAutoFillOnPageLoad = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableBrowserIntegration(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.enableBrowserIntegration) !== null && _b !== void 0 ? _b : false);
        });
    }
    setEnableBrowserIntegration(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enableBrowserIntegration = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableBrowserIntegrationFingerprint(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.enableBrowserIntegrationFingerprint) !== null && _b !== void 0 ? _b : false);
        });
    }
    setEnableBrowserIntegrationFingerprint(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enableBrowserIntegrationFingerprint = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableCloseToTray(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.enableCloseToTray) !== null && _b !== void 0 ? _b : false);
        });
    }
    setEnableCloseToTray(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enableCloseToTray = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableDuckDuckGoBrowserIntegration(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.enableDuckDuckGoBrowserIntegration) !== null && _b !== void 0 ? _b : false);
        });
    }
    setEnableDuckDuckGoBrowserIntegration(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enableDuckDuckGoBrowserIntegration = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableFullWidth(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.enableFullWidth) !== null && _c !== void 0 ? _c : false);
        });
    }
    setEnableFullWidth(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.enableFullWidth = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getEnableMinimizeToTray(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.enableMinimizeToTray) !== null && _b !== void 0 ? _b : false);
        });
    }
    setEnableMinimizeToTray(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enableMinimizeToTray = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableStartToTray(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.enableStartToTray) !== null && _b !== void 0 ? _b : false);
        });
    }
    setEnableStartToTray(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enableStartToTray = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEnableTray(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.enableTray) !== null && _b !== void 0 ? _b : false);
        });
    }
    setEnableTray(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.enableTray = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEncryptedCiphers(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.ciphers) === null || _c === void 0 ? void 0 : _c.encrypted;
        });
    }
    setEncryptedCiphers(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
            account.data.ciphers.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
        });
    }
    getEncryptedCollections(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.collections) === null || _c === void 0 ? void 0 : _c.encrypted;
        });
    }
    setEncryptedCollections(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
            account.data.collections.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
        });
    }
    /**
     * @deprecated Use UserKey instead
     */
    getEncryptedCryptoSymmetricKey(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.keys.cryptoSymmetricKey.encrypted;
        });
    }
    /**
     * @deprecated Use UserKey instead
     */
    setEncryptedCryptoSymmetricKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.keys.cryptoSymmetricKey.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEncryptedFolders(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.folders) === null || _c === void 0 ? void 0 : _c.encrypted;
        });
    }
    setEncryptedFolders(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
            account.data.folders.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
        });
    }
    getEncryptedPasswordGenerationHistory(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.passwordGenerationHistory) === null || _c === void 0 ? void 0 : _c.encrypted;
        });
    }
    setEncryptedPasswordGenerationHistory(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.data.passwordGenerationHistory.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEncryptedPinProtected(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.pinProtected) === null || _c === void 0 ? void 0 : _c.encrypted;
        });
    }
    setEncryptedPinProtected(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.pinProtected.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEncryptedPolicies(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.policies) === null || _c === void 0 ? void 0 : _c.encrypted;
        });
    }
    setEncryptedPolicies(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.data.policies.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEncryptedPrivateKey(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            return (_b = (_a = account === null || account === void 0 ? void 0 : account.keys) === null || _a === void 0 ? void 0 : _a.privateKey) === null || _b === void 0 ? void 0 : _b.encrypted;
        });
    }
    setEncryptedPrivateKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.keys.privateKey.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEncryptedProviderKeys(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.keys) === null || _b === void 0 ? void 0 : _b.providerKeys) === null || _c === void 0 ? void 0 : _c.encrypted;
        });
    }
    setEncryptedProviderKeys(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.keys.providerKeys.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEncryptedSends(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.sends.encrypted;
        });
    }
    setEncryptedSends(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
            account.data.sends.encrypted = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
        });
    }
    getEntityId(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.entityId;
        });
    }
    setEntityId(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.profile.entityId = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getEntityType(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.entityType;
        });
    }
    setEntityType(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.profile.entityType = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getEquivalentDomains(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.equivalentDomains;
        });
    }
    setEquivalentDomains(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.equivalentDomains = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEventCollection(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.eventCollection;
        });
    }
    setEventCollection(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.data.eventCollection = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getEverBeenUnlocked(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.everBeenUnlocked) !== null && _c !== void 0 ? _c : false);
        });
    }
    setEverBeenUnlocked(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.profile.everBeenUnlocked = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getForceSetPasswordReason(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.forceSetPasswordReason) !== null && _c !== void 0 ? _c : ForceSetPasswordReason.None);
        });
    }
    setForceSetPasswordReason(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
            account.profile.forceSetPasswordReason = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
        });
    }
    getInstalledVersion(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.installedVersion;
        });
    }
    setInstalledVersion(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.installedVersion = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getIsAuthenticated(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.getAccessToken(options)) != null && (yield this.getUserId(options)) != null;
        });
    }
    getKdfConfig(options) {
        var _a, _b, _c, _d, _e, _f;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const iterations = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.kdfIterations;
            const memory = (_d = (_c = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _c === void 0 ? void 0 : _c.profile) === null || _d === void 0 ? void 0 : _d.kdfMemory;
            const parallelism = (_f = (_e = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _e === void 0 ? void 0 : _e.profile) === null || _f === void 0 ? void 0 : _f.kdfParallelism;
            return new KdfConfig(iterations, memory, parallelism);
        });
    }
    setKdfConfig(config, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.profile.kdfIterations = config.iterations;
            account.profile.kdfMemory = config.memory;
            account.profile.kdfParallelism = config.parallelism;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getKdfType(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.kdfType;
        });
    }
    setKdfType(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.profile.kdfType = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getKeyHash(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.keyHash;
        });
    }
    setKeyHash(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.profile.keyHash = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getLastActive(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultOnDiskOptions());
            const accountActivity = yield this.storageService.get(keys.accountActivity, options);
            if (accountActivity == null || Object.keys(accountActivity).length < 1) {
                return null;
            }
            return accountActivity[options.userId];
        });
    }
    setLastActive(value, options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = this.reconcileOptions(options, yield this.defaultOnDiskOptions());
            if (options.userId == null) {
                return;
            }
            const accountActivity = (_a = (yield this.storageService.get(keys.accountActivity, options))) !== null && _a !== void 0 ? _a : {};
            accountActivity[options.userId] = value;
            yield this.storageService.save(keys.accountActivity, accountActivity, options);
        });
    }
    getLastSync(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.lastSync;
        });
    }
    setLastSync(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
            account.profile.lastSync = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
        });
    }
    getLocalData(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.localData;
        });
    }
    setLocalData(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.data.localData = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getLocale(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.locale;
        });
    }
    setLocale(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            globals.locale = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getMainWindowSize(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.mainWindowSize;
        });
    }
    setMainWindowSize(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            globals.mainWindowSize = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getMinimizeOnCopyToClipboard(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_c = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.minimizeOnCopyToClipboard) !== null && _c !== void 0 ? _c : false);
        });
    }
    setMinimizeOnCopyToClipboard(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.minimizeOnCopyToClipboard = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getNeverDomains(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.neverDomains;
        });
    }
    setNeverDomains(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.neverDomains = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getNoAutoPromptBiometricsText(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.noAutoPromptBiometricsText;
        });
    }
    setNoAutoPromptBiometricsText(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.noAutoPromptBiometricsText = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getOpenAtLogin(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return ((_b = (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.openAtLogin) !== null && _b !== void 0 ? _b : false);
        });
    }
    setOpenAtLogin(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.openAtLogin = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getOrganizationInvitation(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.organizationInvitation;
        });
    }
    setOrganizationInvitation(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            globals.organizationInvitation = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    /**
     * @deprecated Do not call this directly, use OrganizationService
     */
    getOrganizations(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.organizations;
        });
    }
    /**
     * @deprecated Do not call this directly, use OrganizationService
     */
    setOrganizations(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.data.organizations = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getPasswordGenerationOptions(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.passwordGenerationOptions;
        });
    }
    setPasswordGenerationOptions(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.passwordGenerationOptions = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getUsernameGenerationOptions(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.usernameGenerationOptions;
        });
    }
    setUsernameGenerationOptions(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.usernameGenerationOptions = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getGeneratorOptions(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.generatorOptions;
        });
    }
    setGeneratorOptions(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.generatorOptions = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getProtectedPin(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.protectedPin;
        });
    }
    setProtectedPin(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.settings.protectedPin = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getProviders(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.providers;
        });
    }
    setProviders(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.data.providers = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getPublicKey(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const keys = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.keys;
            return keys === null || keys === void 0 ? void 0 : keys.publicKey;
        });
    }
    setPublicKey(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.keys.publicKey = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getRefreshToken(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = yield this.getTimeoutBasedStorageOptions(options);
            return (_b = (_a = (yield this.getAccount(options))) === null || _a === void 0 ? void 0 : _a.tokens) === null || _b === void 0 ? void 0 : _b.refreshToken;
        });
    }
    setRefreshToken(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            options = yield this.getTimeoutBasedStorageOptions(options);
            const account = yield this.getAccount(options);
            account.tokens.refreshToken = value;
            yield this.saveAccount(account, options);
        });
    }
    getRememberedEmail(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.rememberedEmail;
        });
    }
    setRememberedEmail(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            globals.rememberedEmail = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getSecurityStamp(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.tokens) === null || _b === void 0 ? void 0 : _b.securityStamp;
        });
    }
    setSecurityStamp(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
            account.tokens.securityStamp = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultInMemoryOptions()));
        });
    }
    getSettings(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.settings;
        });
    }
    setSettings(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
            account.settings.settings = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskMemoryOptions()));
        });
    }
    getSsoCodeVerifier(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.ssoCodeVerifier;
        });
    }
    setSsoCodeVerifier(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.ssoCodeVerifier = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getSsoOrgIdentifier(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.ssoOrganizationIdentifier;
        });
    }
    setSsoOrganizationIdentifier(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            globals.ssoOrganizationIdentifier = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getSsoState(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.ssoState;
        });
    }
    setSsoState(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.ssoState = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getUserSsoOrganizationIdentifier(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.loginState) === null || _b === void 0 ? void 0 : _b.ssoOrganizationIdentifier;
        });
    }
    setUserSsoOrganizationIdentifier(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.loginState.ssoOrganizationIdentifier = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getTheme(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.theme;
        });
    }
    setTheme(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            globals.theme = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getTwoFactorToken(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.twoFactorToken;
        });
    }
    setTwoFactorToken(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            globals.twoFactorToken = value;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getUserId(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.userId;
        });
    }
    getUsesKeyConnector(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.usesKeyConnector;
        });
    }
    setUsesKeyConnector(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            account.profile.usesKeyConnector = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getVaultTimeout(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const accountVaultTimeout = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.vaultTimeout;
            return accountVaultTimeout;
        });
    }
    setVaultTimeout(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.vaultTimeout = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getVaultTimeoutAction(options) {
        var _a, _b, _c;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const accountVaultTimeoutAction = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.vaultTimeoutAction;
            const globalVaultTimeoutAction = (_c = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _c === void 0 ? void 0 : _c.vaultTimeoutAction;
            return accountVaultTimeoutAction !== null && accountVaultTimeoutAction !== void 0 ? accountVaultTimeoutAction : globalVaultTimeoutAction;
        });
    }
    setVaultTimeoutAction(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.vaultTimeoutAction = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getApproveLoginRequests(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const approveLoginRequests = (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.approveLoginRequests;
            return approveLoginRequests;
        });
    }
    setApproveLoginRequests(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.approveLoginRequests = value;
            yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getWindow() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(yield this.defaultOnDiskOptions());
            return (globals === null || globals === void 0 ? void 0 : globals.window) != null && Object.keys(globals.window).length > 0
                ? globals.window
                : new WindowState();
        });
    }
    setWindow(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.window = value;
            return yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    setServerConfig(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.serverConfig = value;
            return yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getServerConfig(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.serverConfig;
        });
    }
    getAvatarColor(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.avatarColor;
        });
    }
    setAvatarColor(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.avatarColor = value;
            return yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getActivateAutoFillOnPageLoadFromPolicy(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.activateAutoFillOnPageLoadFromPolicy;
        });
    }
    setActivateAutoFillOnPageLoadFromPolicy(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.activateAutoFillOnPageLoadFromPolicy = value;
            return yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getSMOnboardingTasks(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_b = (_a = (yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions())))) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.smOnboardingTasks;
        });
    }
    setSMOnboardingTasks(value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const account = yield this.getAccount(this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
            account.settings.smOnboardingTasks = value;
            return yield this.saveAccount(account, this.reconcileOptions(options, yield this.defaultOnDiskLocalOptions()));
        });
    }
    getDeepLinkRedirectUrl(options) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (_a = (yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions())))) === null || _a === void 0 ? void 0 : _a.deepLinkRedirectUrl;
        });
    }
    setDeepLinkRedirectUrl(url, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const globals = yield this.getGlobals(this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
            globals.deepLinkRedirectUrl = url;
            yield this.saveGlobals(globals, this.reconcileOptions(options, yield this.defaultOnDiskOptions()));
        });
    }
    getGlobals(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            let globals;
            if (this.useMemory(options.storageLocation)) {
                globals = yield this.getGlobalsFromMemory();
            }
            if (this.useDisk && globals == null) {
                globals = yield this.getGlobalsFromDisk(options);
            }
            if (globals == null) {
                globals = this.createGlobals();
            }
            return globals;
        });
    }
    saveGlobals(globals, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return this.useMemory(options.storageLocation)
                ? this.saveGlobalsToMemory(globals)
                : yield this.saveGlobalsToDisk(globals, options);
        });
    }
    getGlobalsFromMemory() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return (yield this.state()).globals;
        });
    }
    getGlobalsFromDisk(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return yield this.storageService.get(keys.global, options);
        });
    }
    saveGlobalsToMemory(globals) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                state.globals = globals;
                return state;
            }));
        });
    }
    saveGlobalsToDisk(globals, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            if (options.useSecureStorage) {
                yield this.secureStorageService.save(keys.global, globals, options);
            }
            else {
                yield this.storageService.save(keys.global, globals, options);
            }
        });
    }
    getAccount(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            try {
                let account;
                if (this.useMemory(options.storageLocation)) {
                    account = yield this.getAccountFromMemory(options);
                }
                if (this.useDisk(options.storageLocation) && account == null) {
                    account = yield this.getAccountFromDisk(options);
                }
                return account;
            }
            catch (e) {
                this.logService.error(e);
            }
        });
    }
    getAccountFromMemory(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return yield this.state().then((state) => state_service_awaiter(this, void 0, void 0, function* () {
                if (state.accounts == null) {
                    return null;
                }
                return state.accounts[yield this.getUserIdFromMemory(options)];
            }));
        });
    }
    getUserIdFromMemory(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return yield this.state().then((state) => {
                var _a, _b;
                return (options === null || options === void 0 ? void 0 : options.userId) != null
                    ? (_b = (_a = state.accounts[options.userId]) === null || _a === void 0 ? void 0 : _a.profile) === null || _b === void 0 ? void 0 : _b.userId
                    : state.activeUserId;
            });
        });
    }
    getAccountFromDisk(options) {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            if ((options === null || options === void 0 ? void 0 : options.userId) == null && ((_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId) == null) {
                return null;
            }
            if (this.useAccountCache) {
                const cachedAccount = this.accountDiskCache.value[options.userId];
                if (cachedAccount != null) {
                    return cachedAccount;
                }
            }
            const account = (options === null || options === void 0 ? void 0 : options.useSecureStorage)
                ? (_b = (yield this.secureStorageService.get(options.userId, options))) !== null && _b !== void 0 ? _b : (yield this.storageService.get(options.userId, this.reconcileOptions(options, { htmlStorageLocation: HtmlStorageLocation.Local })))
                : yield this.storageService.get(options.userId, options);
            this.setDiskCache(options.userId, account);
            return account;
        });
    }
    useMemory(storageLocation) {
        return storageLocation === StorageLocation.Memory || storageLocation === StorageLocation.Both;
    }
    useDisk(storageLocation) {
        return storageLocation === StorageLocation.Disk || storageLocation === StorageLocation.Both;
    }
    saveAccount(account, options = {
        storageLocation: StorageLocation.Both,
        useSecureStorage: false,
    }) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return this.useMemory(options.storageLocation)
                ? yield this.saveAccountToMemory(account)
                : yield this.saveAccountToDisk(account, options);
        });
    }
    saveAccountToDisk(account, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const storageLocation = options.useSecureStorage
                ? this.secureStorageService
                : this.storageService;
            yield storageLocation.save(`${options.userId}`, account, options);
            this.deleteDiskCache(options.userId);
        });
    }
    saveAccountToMemory(account) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            if ((yield this.getAccountFromMemory({ userId: account.profile.userId })) !== null) {
                yield this.updateState((state) => {
                    return new Promise((resolve) => {
                        state.accounts[account.profile.userId] = account;
                        resolve(state);
                    });
                });
            }
            yield this.pushAccounts();
        });
    }
    scaffoldNewAccountStorage(account) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            // We don't want to manipulate the referenced in memory account
            const deepClone = JSON.parse(JSON.stringify(account));
            yield this.scaffoldNewAccountLocalStorage(deepClone);
            yield this.scaffoldNewAccountSessionStorage(deepClone);
            yield this.scaffoldNewAccountMemoryStorage(deepClone);
        });
    }
    // TODO: There is a tech debt item for splitting up these methods - only Web uses multiple storage locations in its storageService.
    // For now these methods exist with some redundancy to facilitate this special web requirement.
    scaffoldNewAccountLocalStorage(account) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const storedAccount = yield this.getAccount(this.reconcileOptions({ userId: account.profile.userId }, yield this.defaultOnDiskLocalOptions()));
            if ((storedAccount === null || storedAccount === void 0 ? void 0 : storedAccount.settings) != null) {
                account.settings = storedAccount.settings;
            }
            else if (yield this.storageService.has(keys.tempAccountSettings)) {
                account.settings = yield this.storageService.get(keys.tempAccountSettings);
                yield this.storageService.remove(keys.tempAccountSettings);
            }
            if (account.settings.vaultTimeoutAction === VaultTimeoutAction.LogOut &&
                account.settings.vaultTimeout != null) {
                account.tokens.accessToken = null;
                account.tokens.refreshToken = null;
                account.profile.apiKeyClientId = null;
                account.keys.apiKeyClientSecret = null;
            }
            yield this.saveAccount(account, this.reconcileOptions({ userId: account.profile.userId }, yield this.defaultOnDiskLocalOptions()));
        });
    }
    scaffoldNewAccountMemoryStorage(account) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const storedAccount = yield this.getAccount(this.reconcileOptions({ userId: account.profile.userId }, yield this.defaultOnDiskMemoryOptions()));
            if ((storedAccount === null || storedAccount === void 0 ? void 0 : storedAccount.settings) != null) {
                account.settings = storedAccount.settings;
            }
            yield this.storageService.save(account.profile.userId, account, yield this.defaultOnDiskMemoryOptions());
            yield this.saveAccount(account, this.reconcileOptions({ userId: account.profile.userId }, yield this.defaultOnDiskMemoryOptions()));
        });
    }
    scaffoldNewAccountSessionStorage(account) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const storedAccount = yield this.getAccount(this.reconcileOptions({ userId: account.profile.userId }, yield this.defaultOnDiskOptions()));
            if ((storedAccount === null || storedAccount === void 0 ? void 0 : storedAccount.settings) != null) {
                account.settings = storedAccount.settings;
            }
            yield this.storageService.save(account.profile.userId, account, yield this.defaultOnDiskMemoryOptions());
            yield this.saveAccount(account, this.reconcileOptions({ userId: account.profile.userId }, yield this.defaultOnDiskOptions()));
        });
    }
    pushAccounts() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.state().then((state) => {
                if (state.accounts == null || Object.keys(state.accounts).length < 1) {
                    this.accountsSubject.next({});
                    return;
                }
                this.accountsSubject.next(state.accounts);
            });
        });
    }
    reconcileOptions(requestedOptions, defaultOptions) {
        var _a, _b, _c, _d, _e;
        if (requestedOptions == null) {
            return defaultOptions;
        }
        requestedOptions.userId = (_a = requestedOptions === null || requestedOptions === void 0 ? void 0 : requestedOptions.userId) !== null && _a !== void 0 ? _a : defaultOptions.userId;
        requestedOptions.storageLocation =
            (_b = requestedOptions === null || requestedOptions === void 0 ? void 0 : requestedOptions.storageLocation) !== null && _b !== void 0 ? _b : defaultOptions.storageLocation;
        requestedOptions.useSecureStorage =
            (_c = requestedOptions === null || requestedOptions === void 0 ? void 0 : requestedOptions.useSecureStorage) !== null && _c !== void 0 ? _c : defaultOptions.useSecureStorage;
        requestedOptions.htmlStorageLocation =
            (_d = requestedOptions === null || requestedOptions === void 0 ? void 0 : requestedOptions.htmlStorageLocation) !== null && _d !== void 0 ? _d : defaultOptions.htmlStorageLocation;
        requestedOptions.keySuffix = (_e = requestedOptions === null || requestedOptions === void 0 ? void 0 : requestedOptions.keySuffix) !== null && _e !== void 0 ? _e : defaultOptions.keySuffix;
        return requestedOptions;
    }
    defaultInMemoryOptions() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return {
                storageLocation: StorageLocation.Memory,
                userId: (yield this.state()).activeUserId,
            };
        });
    }
    defaultOnDiskOptions() {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return {
                storageLocation: StorageLocation.Disk,
                htmlStorageLocation: HtmlStorageLocation.Session,
                userId: (_b = (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId) !== null && _b !== void 0 ? _b : (yield this.getActiveUserIdFromStorage()),
                useSecureStorage: false,
            };
        });
    }
    defaultOnDiskLocalOptions() {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return {
                storageLocation: StorageLocation.Disk,
                htmlStorageLocation: HtmlStorageLocation.Local,
                userId: (_b = (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId) !== null && _b !== void 0 ? _b : (yield this.getActiveUserIdFromStorage()),
                useSecureStorage: false,
            };
        });
    }
    defaultOnDiskMemoryOptions() {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return {
                storageLocation: StorageLocation.Disk,
                htmlStorageLocation: HtmlStorageLocation.Memory,
                userId: (_b = (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId) !== null && _b !== void 0 ? _b : (yield this.getUserId()),
                useSecureStorage: false,
            };
        });
    }
    defaultSecureStorageOptions() {
        var _a, _b;
        return state_service_awaiter(this, void 0, void 0, function* () {
            return {
                storageLocation: StorageLocation.Disk,
                useSecureStorage: true,
                userId: (_b = (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId) !== null && _b !== void 0 ? _b : (yield this.getActiveUserIdFromStorage()),
            };
        });
    }
    getActiveUserIdFromStorage() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return yield this.storageService.get(keys.activeUserId);
        });
    }
    removeAccountFromLocalStorage(userId = null) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            userId = userId !== null && userId !== void 0 ? userId : (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId;
            const storedAccount = yield this.getAccount(this.reconcileOptions({ userId: userId }, yield this.defaultOnDiskLocalOptions()));
            yield this.saveAccount(this.resetAccount(storedAccount), this.reconcileOptions({ userId: userId }, yield this.defaultOnDiskLocalOptions()));
        });
    }
    removeAccountFromSessionStorage(userId = null) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            userId = userId !== null && userId !== void 0 ? userId : (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId;
            const storedAccount = yield this.getAccount(this.reconcileOptions({ userId: userId }, yield this.defaultOnDiskOptions()));
            yield this.saveAccount(this.resetAccount(storedAccount), this.reconcileOptions({ userId: userId }, yield this.defaultOnDiskOptions()));
        });
    }
    removeAccountFromSecureStorage(userId = null) {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            userId = userId !== null && userId !== void 0 ? userId : (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.activeUserId;
            yield this.setUserKeyAutoUnlock(null, { userId: userId });
            yield this.setUserKeyBiometric(null, { userId: userId });
            yield this.setCryptoMasterKeyAuto(null, { userId: userId });
            yield this.setCryptoMasterKeyBiometric(null, { userId: userId });
            yield this.setCryptoMasterKeyB64(null, { userId: userId });
        });
    }
    removeAccountFromMemory(userId = null) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                userId = userId !== null && userId !== void 0 ? userId : state.activeUserId;
                delete state.accounts[userId];
                this.deleteDiskCache(userId);
                return state;
            }));
            // TODO: Invert this logic, we should remove accounts based on logged out emit
            yield this.accountService.setAccountStatus(userId, AuthenticationStatus.LoggedOut);
        });
    }
    // settings persist even on reset, and are not affected by this method
    resetAccount(account) {
        const persistentAccountInformation = {
            settings: account.settings,
            keys: { deviceKey: account.keys.deviceKey },
            adminAuthRequest: account.adminAuthRequest,
        };
        return Object.assign(this.createAccount(), persistentAccountInformation);
    }
    clearDecryptedDataForActiveUser() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                var _a;
                const userId = state === null || state === void 0 ? void 0 : state.activeUserId;
                if (userId != null && ((_a = state === null || state === void 0 ? void 0 : state.accounts[userId]) === null || _a === void 0 ? void 0 : _a.data) != null) {
                    state.accounts[userId].data = new AccountData();
                }
                return state;
            }));
        });
    }
    createAccount(init = null) {
        return this.stateFactory.createAccount(init);
    }
    createGlobals(init = null) {
        return this.stateFactory.createGlobal(init);
    }
    deAuthenticateAccount(userId) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.setAccessToken(null, { userId: userId });
            yield this.setLastActive(null, { userId: userId });
            yield this.updateState((state) => state_service_awaiter(this, void 0, void 0, function* () {
                state.authenticatedAccounts = state.authenticatedAccounts.filter((id) => id !== userId);
                yield this.storageService.save(keys.authenticatedAccounts, state.authenticatedAccounts);
                return state;
            }));
        });
    }
    removeAccountFromDisk(userId) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.removeAccountFromSessionStorage(userId);
            yield this.removeAccountFromLocalStorage(userId);
            yield this.removeAccountFromSecureStorage(userId);
        });
    }
    nextUpActiveUser() {
        var _a;
        return state_service_awaiter(this, void 0, void 0, function* () {
            const accounts = (_a = (yield this.state())) === null || _a === void 0 ? void 0 : _a.accounts;
            if (accounts == null || Object.keys(accounts).length < 1) {
                return null;
            }
            let newActiveUser;
            for (const userId in accounts) {
                if (userId == null) {
                    continue;
                }
                if (yield this.getIsAuthenticated({ userId: userId })) {
                    newActiveUser = userId;
                    break;
                }
                newActiveUser = null;
            }
            return newActiveUser;
        });
    }
    dynamicallySetActiveUser() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const newActiveUser = yield this.nextUpActiveUser();
            yield this.setActiveUser(newActiveUser);
            return newActiveUser;
        });
    }
    getTimeoutBasedStorageOptions(options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const timeoutAction = yield this.getVaultTimeoutAction({ userId: options === null || options === void 0 ? void 0 : options.userId });
            const timeout = yield this.getVaultTimeout({ userId: options === null || options === void 0 ? void 0 : options.userId });
            const defaultOptions = timeoutAction === VaultTimeoutAction.LogOut && timeout != null
                ? yield this.defaultInMemoryOptions()
                : yield this.defaultOnDiskOptions();
            return this.reconcileOptions(options, defaultOptions);
        });
    }
    saveSecureStorageKey(key, value, options) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return value == null
                ? yield this.secureStorageService.remove(`${options.userId}${key}`, options)
                : yield this.secureStorageService.save(`${options.userId}${key}`, value, options);
        });
    }
    state() {
        return state_service_awaiter(this, void 0, void 0, function* () {
            const state = yield this.memoryStorageService.get(keys.state, {
                deserializer: (s) => State.fromJSON(s, this.accountDeserializer),
            });
            return state;
        });
    }
    setState(state) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            yield this.memoryStorageService.save(keys.state, state);
            return state;
        });
    }
    updateState(stateUpdater) {
        return state_service_awaiter(this, void 0, void 0, function* () {
            return yield this.state().then((state) => state_service_awaiter(this, void 0, void 0, function* () {
                const updatedState = yield stateUpdater(state);
                if (updatedState == null) {
                    throw new Error("Attempted to update state to null value");
                }
                return yield this.setState(updatedState);
            }));
        });
    }
    setDiskCache(key, value, options) {
        if (this.useAccountCache) {
            this.accountDiskCache.value[key] = value;
            this.accountDiskCache.next(this.accountDiskCache.value);
        }
    }
    deleteDiskCache(key) {
        if (this.useAccountCache) {
            delete this.accountDiskCache.value[key];
            this.accountDiskCache.next(this.accountDiskCache.value);
        }
    }
}
state_service_decorate([
    withPrototypeForArrayMembers(CipherView, CipherView.fromJSON),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getDecryptedCiphers", null);
state_service_decorate([
    withPrototypeForArrayMembers(CollectionView),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getDecryptedCollections", null);
state_service_decorate([
    withPrototypeForArrayMembers(GeneratedPasswordHistory),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getDecryptedPasswordGenerationHistory", null);
state_service_decorate([
    withPrototypeForArrayMembers(Policy),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getDecryptedPolicies", null);
state_service_decorate([
    withPrototypeForArrayMembers(SendView),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getDecryptedSends", null);
state_service_decorate([
    withPrototypeForObjectValues(CipherData),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getEncryptedCiphers", null);
state_service_decorate([
    withPrototypeForObjectValues(CollectionData),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getEncryptedCollections", null);
state_service_decorate([
    withPrototypeForObjectValues(FolderData),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getEncryptedFolders", null);
state_service_decorate([
    withPrototypeForArrayMembers(GeneratedPasswordHistory),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getEncryptedPasswordGenerationHistory", null);
state_service_decorate([
    withPrototypeForObjectValues(PolicyData),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getEncryptedPolicies", null);
state_service_decorate([
    withPrototypeForObjectValues(SendData),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getEncryptedSends", null);
state_service_decorate([
    withPrototypeForArrayMembers(EventData),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getEventCollection", null);
state_service_decorate([
    withPrototypeForObjectValues(ProviderData),
    state_service_metadata("design:type", Function),
    state_service_metadata("design:paramtypes", [Object]),
    state_service_metadata("design:returntype", Promise)
], StateService.prototype, "getProviders", null);
function withPrototypeForArrayMembers(memberConstructor, memberConverter = (i) => i) {
    return (target, propertyKey, descriptor) => {
        const originalMethod = descriptor.value;
        return {
            value: function (...args) {
                const originalResult = originalMethod.apply(this, args);
                if (!utils_Utils.isPromise(originalResult)) {
                    throw new Error(`Error applying prototype to stored value -- result is not a promise for method ${String(propertyKey)}`);
                }
                return originalResult.then((result) => {
                    if (result == null) {
                        return null;
                    }
                    else if (!(result instanceof Array)) {
                        throw new Error(`Attempted to retrieve non array type from state as an array for method ${String(propertyKey)}`);
                    }
                    else {
                        return result.map((r) => {
                            return r == null ||
                                r.constructor.name === memberConstructor.prototype.constructor.name
                                ? r
                                : memberConverter(Object.create(memberConstructor.prototype, Object.getOwnPropertyDescriptors(r)));
                        });
                    }
                });
            },
        };
    };
}
function withPrototypeForObjectValues(valuesConstructor, valuesConverter = (i) => i) {
    return (target, propertyKey, descriptor) => {
        const originalMethod = descriptor.value;
        return {
            value: function (...args) {
                const originalResult = originalMethod.apply(this, args);
                if (!utils_Utils.isPromise(originalResult)) {
                    throw new Error(`Error applying prototype to stored value -- result is not a promise for method ${String(propertyKey)}`);
                }
                return originalResult.then((result) => {
                    if (result == null) {
                        return null;
                    }
                    else {
                        for (const [key, val] of Object.entries(result)) {
                            result[key] =
                                val == null || val.constructor.name === valuesConstructor.prototype.constructor.name
                                    ? valuesConverter(val)
                                    : valuesConverter(Object.create(valuesConstructor.prototype, Object.getOwnPropertyDescriptors(val)));
                        }
                        return result;
                    }
                });
            },
        };
    };
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/state-update-options.ts
const DEFAULT_OPTIONS = {
    shouldUpdate: () => true,
    combineLatestWith: null,
    msTimeout: 1000,
};
function populateOptionsWithDefault(options) {
    return Object.assign(Object.assign({}, DEFAULT_OPTIONS), options);
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/user-state.ts
const activeMarker = Symbol("active");

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/implementations/util.ts
var util_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
function getStoredValue(key, storage, deserializer) {
    return util_awaiter(this, void 0, void 0, function* () {
        if (storage.valuesRequireDeserialization) {
            const jsonValue = yield storage.get(key);
            const value = deserializer(jsonValue);
            return value;
        }
        else {
            const value = yield storage.get(key);
            return value !== null && value !== void 0 ? value : null;
        }
    });
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/implementations/default-active-user-state.ts
var default_active_user_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





const FAKE = Symbol("fake");
class DefaultActiveUserState {
    constructor(keyDefinition, accountService, chosenStorageLocation) {
        this.keyDefinition = keyDefinition;
        this.accountService = accountService;
        this.chosenStorageLocation = chosenStorageLocation;
        this.updatePromise = null;
        this.activeUserId$ = this.accountService.activeAccount$.pipe(
        // We only care about the UserId but we do want to know about no user as well.
        (0,external_rxjs_namespaceObject.map)((a) => a === null || a === void 0 ? void 0 : a.id), 
        // To avoid going to storage when we don't need to, only get updates when there is a true change.
        (0,external_rxjs_namespaceObject.distinctUntilChanged)((a, b) => (a == null || b == null ? a == b : a === b)));
        const userChangeAndInitial$ = this.activeUserId$.pipe(
        // If the user has changed, we no longer need to lock an update call
        // since that call will be for a user that is no longer active.
        (0,external_rxjs_namespaceObject.tap)(() => (this.updatePromise = null)), (0,external_rxjs_namespaceObject.switchMap)((userId) => default_active_user_state_awaiter(this, void 0, void 0, function* () {
            // We've switched or started off with no active user. So,
            // emit a fake value so that we can fill our share buffer.
            if (userId == null) {
                return FAKE;
            }
            const fullKey = userKeyBuilder(userId, this.keyDefinition);
            const data = yield getStoredValue(fullKey, this.chosenStorageLocation, this.keyDefinition.deserializer);
            return [userId, data];
        })));
        const latestStorage$ = this.chosenStorageLocation.updates$.pipe(
        // Use withLatestFrom so that we do NOT emit when activeUserId changes because that
        // is taken care of above, but we do want to have the latest user id
        // when we get a storage update so we can filter the full key
        (0,external_rxjs_namespaceObject.withLatestFrom)(this.activeUserId$.pipe(
        // Null userId is already taken care of through the userChange observable above
        (0,external_rxjs_namespaceObject.filter)((u) => u != null), 
        // Take the userId and build the fullKey that we can now create
        (0,external_rxjs_namespaceObject.map)((userId) => [userId, userKeyBuilder(userId, this.keyDefinition)]))), 
        // Filter to only storage updates that pertain to our key
        (0,external_rxjs_namespaceObject.filter)(([storageUpdate, [_userId, fullKey]]) => storageUpdate.key === fullKey), (0,external_rxjs_namespaceObject.switchMap)(([storageUpdate, [userId, fullKey]]) => default_active_user_state_awaiter(this, void 0, void 0, function* () {
            // We can shortcut on updateType of "remove"
            // and just emit null.
            if (storageUpdate.updateType === "remove") {
                return [userId, null];
            }
            return [
                userId,
                yield getStoredValue(fullKey, this.chosenStorageLocation, this.keyDefinition.deserializer),
            ];
        })));
        this.combinedState$ = (0,external_rxjs_namespaceObject.merge)(userChangeAndInitial$, latestStorage$).pipe((0,external_rxjs_namespaceObject.share)({
            connector: () => new external_rxjs_namespaceObject.ReplaySubject(1),
            resetOnRefCountZero: () => (0,external_rxjs_namespaceObject.timer)(this.keyDefinition.cleanupDelayMs),
        }), 
        // Filter out FAKE AFTER the share so that we can fill the ReplaySubjects
        // buffer with something and avoid emitting when there is no active user.
        (0,external_rxjs_namespaceObject.filter)((d) => d !== FAKE));
        // State should just be combined state without the user id
        this.state$ = this.combinedState$.pipe((0,external_rxjs_namespaceObject.map)(([_userId, state]) => state));
    }
    update(configureState, options = {}) {
        return default_active_user_state_awaiter(this, void 0, void 0, function* () {
            options = populateOptionsWithDefault(options);
            try {
                if (this.updatePromise != null) {
                    yield this.updatePromise;
                }
                this.updatePromise = this.internalUpdate(configureState, options);
                const newState = yield this.updatePromise;
                return newState;
            }
            finally {
                this.updatePromise = null;
            }
        });
    }
    internalUpdate(configureState, options) {
        return default_active_user_state_awaiter(this, void 0, void 0, function* () {
            const [key, currentState] = yield this.getStateForUpdate();
            const combinedDependencies = options.combineLatestWith != null
                ? yield (0,external_rxjs_namespaceObject.firstValueFrom)(options.combineLatestWith.pipe((0,external_rxjs_namespaceObject.timeout)(options.msTimeout)))
                : null;
            if (!options.shouldUpdate(currentState, combinedDependencies)) {
                return currentState;
            }
            const newState = configureState(currentState, combinedDependencies);
            yield this.saveToStorage(key, newState);
            return newState;
        });
    }
    /** For use in update methods, does not wait for update to complete before yielding state.
     * The expectation is that that await is already done
     */
    getStateForUpdate() {
        return default_active_user_state_awaiter(this, void 0, void 0, function* () {
            const userId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.activeUserId$.pipe((0,external_rxjs_namespaceObject.timeout)({
                first: 1000,
                with: () => (0,external_rxjs_namespaceObject.throwError)(() => new Error("Timeout while retrieving active user.")),
            })));
            if (userId == null) {
                throw new Error("No active user at this time.");
            }
            const fullKey = userKeyBuilder(userId, this.keyDefinition);
            return [
                fullKey,
                yield getStoredValue(fullKey, this.chosenStorageLocation, this.keyDefinition.deserializer),
            ];
        });
    }
    saveToStorage(key, data) {
        return this.chosenStorageLocation.save(key, data);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/implementations/default-active-user-state.provider.ts

class DefaultActiveUserStateProvider {
    constructor(accountService, memoryStorage, diskStorage) {
        this.accountService = accountService;
        this.memoryStorage = memoryStorage;
        this.diskStorage = diskStorage;
        this.cache = {};
    }
    get(keyDefinition) {
        const cacheKey = this.buildCacheKey(keyDefinition);
        const existingUserState = this.cache[cacheKey];
        if (existingUserState != null) {
            // I have to cast out of the unknown generic but this should be safe if rules
            // around domain token are made
            return existingUserState;
        }
        const newUserState = this.buildActiveUserState(keyDefinition);
        this.cache[cacheKey] = newUserState;
        return newUserState;
    }
    buildCacheKey(keyDefinition) {
        return `${this.getLocationString(keyDefinition)}_${keyDefinition.fullName}`;
    }
    buildActiveUserState(keyDefinition) {
        return new DefaultActiveUserState(keyDefinition, this.accountService, this.getLocation(keyDefinition.stateDefinition));
    }
    getLocationString(keyDefinition) {
        return keyDefinition.stateDefinition.defaultStorageLocation;
    }
    getLocation(stateDefinition) {
        // The default implementations don't support the client overrides
        // it is up to the client to extend this class and add that support
        const location = stateDefinition.defaultStorageLocation;
        switch (location) {
            case "disk":
                return this.diskStorage;
            case "memory":
                return this.memoryStorage;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/implementations/default-derived-state.ts
var default_derived_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

/**
 * Default derived state
 */
class DefaultDerivedState {
    constructor(parentState$, deriveDefinition, memoryStorage, dependencies) {
        this.parentState$ = parentState$;
        this.deriveDefinition = deriveDefinition;
        this.memoryStorage = memoryStorage;
        this.dependencies = dependencies;
        this.forcedValueSubject = new external_rxjs_namespaceObject.Subject();
        this.storageKey = deriveDefinition.storageKey;
        const derivedState$ = this.parentState$.pipe((0,external_rxjs_namespaceObject.concatMap)((state) => default_derived_state_awaiter(this, void 0, void 0, function* () {
            let derivedStateOrPromise = this.deriveDefinition.derive(state, this.dependencies);
            if (derivedStateOrPromise instanceof Promise) {
                derivedStateOrPromise = yield derivedStateOrPromise;
            }
            const derivedState = derivedStateOrPromise;
            yield this.memoryStorage.save(this.storageKey, derivedState);
            return derivedState;
        })));
        this.state$ = (0,external_rxjs_namespaceObject.merge)(this.forcedValueSubject, derivedState$).pipe((0,external_rxjs_namespaceObject.share)({
            connector: () => {
                return new external_rxjs_namespaceObject.ReplaySubject(1);
            },
            resetOnRefCountZero: () => (0,external_rxjs_namespaceObject.timer)(this.deriveDefinition.cleanupDelayMs),
        }));
    }
    forceValue(value) {
        return default_derived_state_awaiter(this, void 0, void 0, function* () {
            yield this.memoryStorage.save(this.storageKey, value);
            this.forcedValueSubject.next(value);
            return value;
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/implementations/default-derived-state.provider.ts

class DefaultDerivedStateProvider {
    constructor(memoryStorage) {
        this.memoryStorage = memoryStorage;
        this.cache = {};
    }
    get(parentState$, deriveDefinition, dependencies) {
        const cacheKey = deriveDefinition.buildCacheKey();
        const existingDerivedState = this.cache[cacheKey];
        if (existingDerivedState != null) {
            // I have to cast out of the unknown generic but this should be safe if rules
            // around domain token are made
            return existingDerivedState;
        }
        const newDerivedState = this.buildDerivedState(parentState$, deriveDefinition, dependencies);
        this.cache[cacheKey] = newDerivedState;
        return newDerivedState;
    }
    buildDerivedState(parentState$, deriveDefinition, dependencies) {
        return new DefaultDerivedState(parentState$, deriveDefinition, this.memoryStorage, dependencies);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/implementations/default-global-state.ts
var default_global_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class DefaultGlobalState {
    constructor(keyDefinition, chosenLocation) {
        this.keyDefinition = keyDefinition;
        this.chosenLocation = chosenLocation;
        this.updatePromise = null;
        this.storageKey = globalKeyBuilder(this.keyDefinition);
        const initialStorageGet$ = (0,external_rxjs_namespaceObject.defer)(() => {
            return getStoredValue(this.storageKey, this.chosenLocation, this.keyDefinition.deserializer);
        });
        const latestStorage$ = this.chosenLocation.updates$.pipe((0,external_rxjs_namespaceObject.filter)((s) => s.key === this.storageKey), (0,external_rxjs_namespaceObject.switchMap)((storageUpdate) => default_global_state_awaiter(this, void 0, void 0, function* () {
            if (storageUpdate.updateType === "remove") {
                return null;
            }
            return yield getStoredValue(this.storageKey, this.chosenLocation, this.keyDefinition.deserializer);
        })));
        this.state$ = (0,external_rxjs_namespaceObject.merge)(initialStorageGet$, latestStorage$).pipe((0,external_rxjs_namespaceObject.share)({
            connector: () => new external_rxjs_namespaceObject.ReplaySubject(1),
            resetOnRefCountZero: () => (0,external_rxjs_namespaceObject.timer)(this.keyDefinition.cleanupDelayMs),
        }));
    }
    update(configureState, options = {}) {
        return default_global_state_awaiter(this, void 0, void 0, function* () {
            options = populateOptionsWithDefault(options);
            if (this.updatePromise != null) {
                yield this.updatePromise;
            }
            try {
                this.updatePromise = this.internalUpdate(configureState, options);
                const newState = yield this.updatePromise;
                return newState;
            }
            finally {
                this.updatePromise = null;
            }
        });
    }
    internalUpdate(configureState, options) {
        return default_global_state_awaiter(this, void 0, void 0, function* () {
            const currentState = yield this.getStateForUpdate();
            const combinedDependencies = options.combineLatestWith != null
                ? yield (0,external_rxjs_namespaceObject.firstValueFrom)(options.combineLatestWith.pipe((0,external_rxjs_namespaceObject.timeout)(options.msTimeout)))
                : null;
            if (!options.shouldUpdate(currentState, combinedDependencies)) {
                return currentState;
            }
            const newState = configureState(currentState, combinedDependencies);
            yield this.chosenLocation.save(this.storageKey, newState);
            return newState;
        });
    }
    /** For use in update methods, does not wait for update to complete before yielding state.
     * The expectation is that that await is already done
     */
    getStateForUpdate() {
        return default_global_state_awaiter(this, void 0, void 0, function* () {
            return yield getStoredValue(this.storageKey, this.chosenLocation, this.keyDefinition.deserializer);
        });
    }
    getFromState() {
        return default_global_state_awaiter(this, void 0, void 0, function* () {
            if (this.updatePromise != null) {
                return yield this.updatePromise;
            }
            return yield getStoredValue(this.storageKey, this.chosenLocation, this.keyDefinition.deserializer);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/implementations/default-global-state.provider.ts

class DefaultGlobalStateProvider {
    constructor(memoryStorage, diskStorage) {
        this.memoryStorage = memoryStorage;
        this.diskStorage = diskStorage;
        this.globalStateCache = {};
    }
    get(keyDefinition) {
        const cacheKey = this.buildCacheKey(keyDefinition);
        const existingGlobalState = this.globalStateCache[cacheKey];
        if (existingGlobalState != null) {
            // The cast into the actual generic is safe because of rules around key definitions
            // being unique.
            return existingGlobalState;
        }
        const newGlobalState = new DefaultGlobalState(keyDefinition, this.getLocation(keyDefinition.stateDefinition));
        this.globalStateCache[cacheKey] = newGlobalState;
        return newGlobalState;
    }
    buildCacheKey(keyDefinition) {
        return `${this.getLocationString(keyDefinition)}_${keyDefinition.fullName}`;
    }
    getLocationString(keyDefinition) {
        return keyDefinition.stateDefinition.defaultStorageLocation;
    }
    getLocation(stateDefinition) {
        const location = stateDefinition.defaultStorageLocation;
        switch (location) {
            case "disk":
                return this.diskStorage;
            case "memory":
                return this.memoryStorage;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/implementations/default-single-user-state.ts
var default_single_user_state_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class DefaultSingleUserState {
    constructor(userId, keyDefinition, chosenLocation) {
        this.userId = userId;
        this.keyDefinition = keyDefinition;
        this.chosenLocation = chosenLocation;
        this.updatePromise = null;
        this.storageKey = userKeyBuilder(this.userId, this.keyDefinition);
        const initialStorageGet$ = (0,external_rxjs_namespaceObject.defer)(() => {
            return getStoredValue(this.storageKey, this.chosenLocation, this.keyDefinition.deserializer);
        });
        const latestStorage$ = chosenLocation.updates$.pipe((0,external_rxjs_namespaceObject.filter)((s) => s.key === this.storageKey), (0,external_rxjs_namespaceObject.switchMap)((storageUpdate) => default_single_user_state_awaiter(this, void 0, void 0, function* () {
            if (storageUpdate.updateType === "remove") {
                return null;
            }
            return yield getStoredValue(this.storageKey, this.chosenLocation, this.keyDefinition.deserializer);
        })));
        this.state$ = (0,external_rxjs_namespaceObject.merge)(initialStorageGet$, latestStorage$).pipe((0,external_rxjs_namespaceObject.share)({
            connector: () => new external_rxjs_namespaceObject.ReplaySubject(1),
            resetOnRefCountZero: () => (0,external_rxjs_namespaceObject.timer)(this.keyDefinition.cleanupDelayMs),
        }));
        this.combinedState$ = (0,external_rxjs_namespaceObject.combineLatest)([(0,external_rxjs_namespaceObject.of)(userId), this.state$]);
    }
    update(configureState, options = {}) {
        return default_single_user_state_awaiter(this, void 0, void 0, function* () {
            options = populateOptionsWithDefault(options);
            if (this.updatePromise != null) {
                yield this.updatePromise;
            }
            try {
                this.updatePromise = this.internalUpdate(configureState, options);
                const newState = yield this.updatePromise;
                return newState;
            }
            finally {
                this.updatePromise = null;
            }
        });
    }
    internalUpdate(configureState, options) {
        return default_single_user_state_awaiter(this, void 0, void 0, function* () {
            const currentState = yield this.getStateForUpdate();
            const combinedDependencies = options.combineLatestWith != null
                ? yield (0,external_rxjs_namespaceObject.firstValueFrom)(options.combineLatestWith.pipe((0,external_rxjs_namespaceObject.timeout)(options.msTimeout)))
                : null;
            if (!options.shouldUpdate(currentState, combinedDependencies)) {
                return currentState;
            }
            const newState = configureState(currentState, combinedDependencies);
            yield this.chosenLocation.save(this.storageKey, newState);
            return newState;
        });
    }
    /** For use in update methods, does not wait for update to complete before yielding state.
     * The expectation is that that await is already done
     */
    getStateForUpdate() {
        return default_single_user_state_awaiter(this, void 0, void 0, function* () {
            return yield getStoredValue(this.storageKey, this.chosenLocation, this.keyDefinition.deserializer);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/implementations/default-single-user-state.provider.ts

class DefaultSingleUserStateProvider {
    constructor(memoryStorage, diskStorage) {
        this.memoryStorage = memoryStorage;
        this.diskStorage = diskStorage;
        this.cache = {};
    }
    get(userId, keyDefinition) {
        const cacheKey = this.buildCacheKey(userId, keyDefinition);
        const existingUserState = this.cache[cacheKey];
        if (existingUserState != null) {
            // I have to cast out of the unknown generic but this should be safe if rules
            // around domain token are made
            return existingUserState;
        }
        const newUserState = this.buildSingleUserState(userId, keyDefinition);
        this.cache[cacheKey] = newUserState;
        return newUserState;
    }
    buildCacheKey(userId, keyDefinition) {
        return `${this.getLocationString(keyDefinition)}_${keyDefinition.fullName}_${userId}`;
    }
    buildSingleUserState(userId, keyDefinition) {
        return new DefaultSingleUserState(userId, keyDefinition, this.getLocation(keyDefinition.stateDefinition));
    }
    getLocationString(keyDefinition) {
        return keyDefinition.stateDefinition.defaultStorageLocation;
    }
    getLocation(stateDefinition) {
        // The default implementations don't support the client overrides
        // it is up to the client to extend this class and add that support
        switch (stateDefinition.defaultStorageLocation) {
            case "disk":
                return this.diskStorage;
            case "memory":
                return this.memoryStorage;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/state/implementations/default-state.provider.ts
class DefaultStateProvider {
    constructor(activeUserStateProvider, singleUserStateProvider, globalStateProvider, derivedStateProvider) {
        this.activeUserStateProvider = activeUserStateProvider;
        this.singleUserStateProvider = singleUserStateProvider;
        this.globalStateProvider = globalStateProvider;
        this.derivedStateProvider = derivedStateProvider;
        this.getActive = this.activeUserStateProvider.get.bind(this.activeUserStateProvider);
        this.getUser = this.singleUserStateProvider.get.bind(this.singleUserStateProvider);
        this.getGlobal = this.globalStateProvider.get.bind(this.globalStateProvider);
        this.getDerived = this.derivedStateProvider.get.bind(this.derivedStateProvider);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/platform/misc/throttle.ts
/**
 * Use as a Decorator on async functions, it will limit how many times the function can be
 * in-flight at a time.
 *
 * Calls beyond the limit will be queued, and run when one of the active calls finishes
 */
function throttle(limit, throttleKey) {
    return (target, propertyKey, descriptor) => {
        const originalMethod = descriptor.value;
        const allThrottles = new Map();
        const getThrottles = (obj) => {
            let throttles = allThrottles.get(obj);
            if (throttles != null) {
                return throttles;
            }
            throttles = new Map();
            allThrottles.set(obj, throttles);
            return throttles;
        };
        return {
            value: function (...args) {
                const throttles = getThrottles(this);
                const argsThrottleKey = throttleKey(args);
                let queue = throttles.get(argsThrottleKey);
                if (queue == null) {
                    queue = [];
                    throttles.set(argsThrottleKey, queue);
                }
                return new Promise((resolve, reject) => {
                    const exec = () => {
                        const onFinally = () => {
                            queue.splice(queue.indexOf(exec), 1);
                            if (queue.length >= limit) {
                                queue[limit - 1]();
                            }
                            else if (queue.length === 0) {
                                throttles.delete(argsThrottleKey);
                                if (throttles.size === 0) {
                                    allThrottles.delete(this);
                                }
                            }
                        };
                        originalMethod
                            .apply(this, args)
                            .then((val) => {
                            onFinally();
                            return val;
                        })
                            .catch((err) => {
                            onFinally();
                            throw err;
                        })
                            .then(resolve, reject);
                    };
                    queue.push(exec);
                    if (queue.length <= limit) {
                        exec();
                    }
                });
            },
        };
    };
}

;// CONCATENATED MODULE: ../../libs/common/src/services/audit.service.ts
var audit_service_decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var audit_service_metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var audit_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const PwnedPasswordsApi = "https://api.pwnedpasswords.com/range/";
class AuditService {
    constructor(cryptoFunctionService, apiService) {
        this.cryptoFunctionService = cryptoFunctionService;
        this.apiService = apiService;
    }
    passwordLeaked(password) {
        return audit_service_awaiter(this, void 0, void 0, function* () {
            const hashBytes = yield this.cryptoFunctionService.hash(password, "sha1");
            const hash = utils_Utils.fromBufferToHex(hashBytes).toUpperCase();
            const hashStart = hash.substr(0, 5);
            const hashEnding = hash.substr(5);
            const response = yield this.apiService.nativeFetch(new Request(PwnedPasswordsApi + hashStart));
            const leakedHashes = yield response.text();
            const match = leakedHashes.split(/\r?\n/).find((v) => {
                return v.split(":")[0] === hashEnding;
            });
            return match != null ? parseInt(match.split(":")[1], 10) : 0;
        });
    }
    breachedAccounts(username) {
        return audit_service_awaiter(this, void 0, void 0, function* () {
            try {
                return yield this.apiService.getHibpBreach(username);
            }
            catch (e) {
                const error = e;
                if (error.statusCode === 404) {
                    return [];
                }
                throw new Error();
            }
        });
    }
}
audit_service_decorate([
    throttle(100, () => "passwordLeaked"),
    audit_service_metadata("design:type", Function),
    audit_service_metadata("design:paramtypes", [String]),
    audit_service_metadata("design:returntype", Promise)
], AuditService.prototype, "passwordLeaked", null);

;// CONCATENATED MODULE: ../../libs/common/src/services/event/event-collection.service.ts
var event_collection_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class EventCollectionService {
    constructor(cipherService, stateService, organizationService, eventUploadService) {
        this.cipherService = cipherService;
        this.stateService = stateService;
        this.organizationService = organizationService;
        this.eventUploadService = eventUploadService;
    }
    collect(eventType, cipherId = null, uploadImmediately = false, organizationId = null) {
        return event_collection_service_awaiter(this, void 0, void 0, function* () {
            const authed = yield this.stateService.getIsAuthenticated();
            if (!authed) {
                return;
            }
            const organizations = yield this.organizationService.getAll();
            if (organizations == null) {
                return;
            }
            const orgIds = new Set(organizations.filter((o) => o.useEvents).map((o) => o.id));
            if (orgIds.size === 0) {
                return;
            }
            if (cipherId != null) {
                const cipher = yield this.cipherService.get(cipherId);
                if (cipher == null || cipher.organizationId == null || !orgIds.has(cipher.organizationId)) {
                    return;
                }
            }
            if (organizationId != null) {
                if (!orgIds.has(organizationId)) {
                    return;
                }
            }
            let eventCollection = yield this.stateService.getEventCollection();
            if (eventCollection == null) {
                eventCollection = [];
            }
            const event = new EventData();
            event.type = eventType;
            event.cipherId = cipherId;
            event.date = new Date().toISOString();
            event.organizationId = organizationId;
            eventCollection.push(event);
            yield this.stateService.setEventCollection(eventCollection);
            if (uploadImmediately) {
                yield this.eventUploadService.uploadEvents();
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/models/request/event.request.ts
class EventRequest {
}

;// CONCATENATED MODULE: ../../libs/common/src/services/event/event-upload.service.ts
var event_upload_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};

class EventUploadService {
    constructor(apiService, stateService, logService) {
        this.apiService = apiService;
        this.stateService = stateService;
        this.logService = logService;
        this.inited = false;
    }
    init(checkOnInterval) {
        if (this.inited) {
            return;
        }
        this.inited = true;
        if (checkOnInterval) {
            this.uploadEvents();
            setInterval(() => this.uploadEvents(), 60 * 1000); // check every 60 seconds
        }
    }
    uploadEvents(userId) {
        return event_upload_service_awaiter(this, void 0, void 0, function* () {
            const authed = yield this.stateService.getIsAuthenticated({ userId: userId });
            if (!authed) {
                return;
            }
            const eventCollection = yield this.stateService.getEventCollection({ userId: userId });
            if (eventCollection == null || eventCollection.length === 0) {
                return;
            }
            const request = eventCollection.map((e) => {
                const req = new EventRequest();
                req.type = e.type;
                req.cipherId = e.cipherId;
                req.date = e.date;
                req.organizationId = e.organizationId;
                return req;
            });
            try {
                yield this.apiService.postEventsCollect(request);
                this.clearEvents(userId);
            }
            catch (e) {
                this.logService.error(e);
            }
        });
    }
    clearEvents(userId) {
        return event_upload_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setEventCollection(null, { userId: userId });
        });
    }
}

;// CONCATENATED MODULE: external "lunr"
const external_lunr_namespaceObject = require("lunr");
;// CONCATENATED MODULE: ../../libs/common/src/services/search.service.ts
var search_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class SearchService {
    constructor(logService, i18nService) {
        this.logService = logService;
        this.i18nService = i18nService;
        this.indexedEntityId = null;
        this.indexing = false;
        this.index = null;
        this.immediateSearchLocales = ["zh-CN", "zh-TW", "ja", "ko", "vi"];
        this.defaultSearchableMinLength = 2;
        this.searchableMinLength = this.defaultSearchableMinLength;
        this.i18nService.locale$.subscribe((locale) => {
            if (this.immediateSearchLocales.indexOf(locale) !== -1) {
                this.searchableMinLength = 1;
            }
            else {
                this.searchableMinLength = this.defaultSearchableMinLength;
            }
        });
        // Currently have to ensure this is only done a single time. Lunr allows you to register a function
        // multiple times but they will add a warning message to the console. The way they do that breaks when ran on a service worker.
        if (!SearchService.registeredPipeline) {
            SearchService.registeredPipeline = true;
            //register lunr pipeline function
            external_lunr_namespaceObject.Pipeline.registerFunction(this.normalizeAccentsPipelineFunction, "normalizeAccents");
        }
    }
    clearIndex() {
        this.indexedEntityId = null;
        this.index = null;
    }
    isSearchable(query) {
        query = SearchService.normalizeSearchQuery(query);
        const notSearchable = query == null ||
            (this.index == null && query.length < this.searchableMinLength) ||
            (this.index != null && query.length < this.searchableMinLength && query.indexOf(">") !== 0);
        return !notSearchable;
    }
    indexCiphers(ciphers, indexedEntityId) {
        if (this.indexing) {
            return;
        }
        this.indexing = true;
        this.indexedEntityId = indexedEntityId;
        this.index = null;
        const builder = new external_lunr_namespaceObject.Builder();
        builder.pipeline.add(this.normalizeAccentsPipelineFunction);
        builder.ref("id");
        builder.field("shortid", { boost: 100, extractor: (c) => c.id.substr(0, 8) });
        builder.field("name", {
            boost: 10,
        });
        builder.field("subtitle", {
            boost: 5,
            extractor: (c) => {
                if (c.subTitle != null && c.type === CipherType.Card) {
                    return c.subTitle.replace(/\*/g, "");
                }
                return c.subTitle;
            },
        });
        builder.field("notes");
        builder.field("login.username", {
            extractor: (c) => c.type === CipherType.Login && c.login != null ? c.login.username : null,
        });
        builder.field("login.uris", { boost: 2, extractor: (c) => this.uriExtractor(c) });
        builder.field("fields", { extractor: (c) => this.fieldExtractor(c, false) });
        builder.field("fields_joined", { extractor: (c) => this.fieldExtractor(c, true) });
        builder.field("attachments", {
            extractor: (c) => this.attachmentExtractor(c, false),
        });
        builder.field("attachments_joined", {
            extractor: (c) => this.attachmentExtractor(c, true),
        });
        builder.field("organizationid", { extractor: (c) => c.organizationId });
        ciphers = ciphers || [];
        ciphers.forEach((c) => builder.add(c));
        this.index = builder.build();
        this.indexing = false;
        this.logService.info("Finished search indexing");
    }
    searchCiphers(query, filter = null, ciphers) {
        return search_service_awaiter(this, void 0, void 0, function* () {
            const results = [];
            if (query != null) {
                query = SearchService.normalizeSearchQuery(query.trim().toLowerCase());
            }
            if (query === "") {
                query = null;
            }
            if (ciphers == null) {
                ciphers = [];
            }
            if (filter != null && Array.isArray(filter) && filter.length > 0) {
                ciphers = ciphers.filter((c) => filter.every((f) => f == null || f(c)));
            }
            else if (filter != null) {
                ciphers = ciphers.filter(filter);
            }
            if (!this.isSearchable(query)) {
                return ciphers;
            }
            if (this.indexing) {
                yield new Promise((r) => setTimeout(r, 250));
                if (this.indexing) {
                    yield new Promise((r) => setTimeout(r, 500));
                }
            }
            const index = this.getIndexForSearch();
            if (index == null) {
                // Fall back to basic search if index is not available
                return this.searchCiphersBasic(ciphers, query);
            }
            const ciphersMap = new Map();
            ciphers.forEach((c) => ciphersMap.set(c.id, c));
            let searchResults = null;
            const isQueryString = query != null && query.length > 1 && query.indexOf(">") === 0;
            if (isQueryString) {
                try {
                    searchResults = index.search(query.substr(1).trim());
                }
                catch (e) {
                    this.logService.error(e);
                }
            }
            else {
                const soWild = external_lunr_namespaceObject.Query.wildcard.LEADING | external_lunr_namespaceObject.Query.wildcard.TRAILING;
                searchResults = index.query((q) => {
                    external_lunr_namespaceObject.tokenizer(query).forEach((token) => {
                        const t = token.toString();
                        q.term(t, { fields: ["name"], wildcard: soWild });
                        q.term(t, { fields: ["subtitle"], wildcard: soWild });
                        q.term(t, { fields: ["login.uris"], wildcard: soWild });
                        q.term(t, {});
                    });
                });
            }
            if (searchResults != null) {
                searchResults.forEach((r) => {
                    if (ciphersMap.has(r.ref)) {
                        results.push(ciphersMap.get(r.ref));
                    }
                });
            }
            return results;
        });
    }
    searchCiphersBasic(ciphers, query, deleted = false) {
        query = SearchService.normalizeSearchQuery(query.trim().toLowerCase());
        return ciphers.filter((c) => {
            if (deleted !== c.isDeleted) {
                return false;
            }
            if (c.name != null && c.name.toLowerCase().indexOf(query) > -1) {
                return true;
            }
            if (query.length >= 8 && c.id.startsWith(query)) {
                return true;
            }
            if (c.subTitle != null && c.subTitle.toLowerCase().indexOf(query) > -1) {
                return true;
            }
            if (c.login &&
                c.login.hasUris &&
                c.login.uris.some((loginUri) => { var _a; return ((_a = loginUri === null || loginUri === void 0 ? void 0 : loginUri.uri) === null || _a === void 0 ? void 0 : _a.toLowerCase().indexOf(query)) > -1; })) {
                return true;
            }
            return false;
        });
    }
    searchSends(sends, query) {
        query = SearchService.normalizeSearchQuery(query.trim().toLocaleLowerCase());
        if (query === null) {
            return sends;
        }
        const sendsMatched = [];
        const lowPriorityMatched = [];
        sends.forEach((s) => {
            var _a, _b, _c;
            if (s.name != null && s.name.toLowerCase().indexOf(query) > -1) {
                sendsMatched.push(s);
            }
            else if (query.length >= 8 &&
                (s.id.startsWith(query) ||
                    s.accessId.toLocaleLowerCase().startsWith(query) ||
                    (((_a = s.file) === null || _a === void 0 ? void 0 : _a.id) != null && s.file.id.startsWith(query)))) {
                lowPriorityMatched.push(s);
            }
            else if (s.notes != null && s.notes.toLowerCase().indexOf(query) > -1) {
                lowPriorityMatched.push(s);
            }
            else if (((_b = s.text) === null || _b === void 0 ? void 0 : _b.text) != null && s.text.text.toLowerCase().indexOf(query) > -1) {
                lowPriorityMatched.push(s);
            }
            else if (((_c = s.file) === null || _c === void 0 ? void 0 : _c.fileName) != null && s.file.fileName.toLowerCase().indexOf(query) > -1) {
                lowPriorityMatched.push(s);
            }
        });
        return sendsMatched.concat(lowPriorityMatched);
    }
    getIndexForSearch() {
        return this.index;
    }
    fieldExtractor(c, joined) {
        if (!c.hasFields) {
            return null;
        }
        let fields = [];
        c.fields.forEach((f) => {
            if (f.name != null) {
                fields.push(f.name);
            }
            if (f.type === FieldType.Text && f.value != null) {
                fields.push(f.value);
            }
        });
        fields = fields.filter((f) => f.trim() !== "");
        if (fields.length === 0) {
            return null;
        }
        return joined ? fields.join(" ") : fields;
    }
    attachmentExtractor(c, joined) {
        if (!c.hasAttachments) {
            return null;
        }
        let attachments = [];
        c.attachments.forEach((a) => {
            if (a != null && a.fileName != null) {
                if (joined && a.fileName.indexOf(".") > -1) {
                    attachments.push(a.fileName.substr(0, a.fileName.lastIndexOf(".")));
                }
                else {
                    attachments.push(a.fileName);
                }
            }
        });
        attachments = attachments.filter((f) => f.trim() !== "");
        if (attachments.length === 0) {
            return null;
        }
        return joined ? attachments.join(" ") : attachments;
    }
    uriExtractor(c) {
        if (c.type !== CipherType.Login || c.login == null || !c.login.hasUris) {
            return null;
        }
        const uris = [];
        c.login.uris.forEach((u) => {
            if (u.uri == null || u.uri === "") {
                return;
            }
            if (u.hostname != null) {
                uris.push(u.hostname);
                return;
            }
            let uri = u.uri;
            if (u.match !== UriMatchType.RegularExpression) {
                const protocolIndex = uri.indexOf("://");
                if (protocolIndex > -1) {
                    uri = uri.substr(protocolIndex + 3);
                }
                const queryIndex = uri.search(/\?|&|#/);
                if (queryIndex > -1) {
                    uri = uri.substring(0, queryIndex);
                }
            }
            uris.push(uri);
        });
        return uris.length > 0 ? uris : null;
    }
    normalizeAccentsPipelineFunction(token) {
        const searchableFields = ["name", "login.username", "subtitle", "notes"];
        const fields = token.metadata["fields"];
        const checkFields = fields.every((i) => searchableFields.includes(i));
        if (checkFields) {
            return SearchService.normalizeSearchQuery(token.toString());
        }
        return token;
    }
    // Remove accents/diacritics characters from text. This regex is equivalent to the Diacritic unicode property escape, i.e. it will match all diacritic characters.
    static normalizeSearchQuery(query) {
        return query === null || query === void 0 ? void 0 : query.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
    }
}
SearchService.registeredPipeline = false;

;// CONCATENATED MODULE: ../../libs/common/src/services/settings.service.ts
var settings_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


class SettingsService {
    constructor(stateService) {
        this.stateService = stateService;
        this._settings = new external_rxjs_namespaceObject.BehaviorSubject({});
        this._disableFavicon = new external_rxjs_namespaceObject.BehaviorSubject(null);
        this.settings$ = this._settings.asObservable();
        this.disableFavicon$ = this._disableFavicon.asObservable();
        this.stateService.activeAccountUnlocked$
            .pipe((0,external_rxjs_namespaceObject.concatMap)((unlocked) => settings_service_awaiter(this, void 0, void 0, function* () {
            if (utils_Utils.global.bitwardenContainerService == null) {
                return;
            }
            if (!unlocked) {
                this._settings.next({});
                return;
            }
            const data = yield this.stateService.getSettings();
            const disableFavicon = yield this.stateService.getDisableFavicon();
            this._settings.next(data);
            this._disableFavicon.next(disableFavicon);
        })))
            .subscribe();
    }
    setEquivalentDomains(equivalentDomains) {
        var _a;
        return settings_service_awaiter(this, void 0, void 0, function* () {
            const settings = (_a = this._settings.getValue()) !== null && _a !== void 0 ? _a : {};
            settings.equivalentDomains = equivalentDomains;
            this._settings.next(settings);
            yield this.stateService.setSettings(settings);
        });
    }
    getEquivalentDomains(url) {
        const domain = utils_Utils.getDomain(url);
        if (domain == null) {
            return new Set();
        }
        const settings = this._settings.getValue();
        let result = [];
        if ((settings === null || settings === void 0 ? void 0 : settings.equivalentDomains) != null) {
            settings.equivalentDomains
                .filter((ed) => ed.length > 0 && ed.includes(domain))
                .forEach((ed) => {
                result = result.concat(ed);
            });
        }
        return new Set(result);
    }
    setDisableFavicon(value) {
        return settings_service_awaiter(this, void 0, void 0, function* () {
            this._disableFavicon.next(value);
            yield this.stateService.setDisableFavicon(value);
        });
    }
    getDisableFavicon() {
        return this._disableFavicon.getValue();
    }
    setAutoFillOverlayVisibility(value) {
        return settings_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.setAutoFillOverlayVisibility(value);
        });
    }
    getAutoFillOverlayVisibility() {
        return settings_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getAutoFillOverlayVisibility();
        });
    }
    clear(userId) {
        return settings_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null || userId == (yield this.stateService.getUserId())) {
                this._settings.next({});
            }
            yield this.stateService.setSettings(null, { userId: userId });
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/vault-timeout/vault-timeout-settings.service.ts
var vault_timeout_settings_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class VaultTimeoutSettingsService {
    constructor(cryptoService, tokenService, policyService, stateService) {
        this.cryptoService = cryptoService;
        this.tokenService = tokenService;
        this.policyService = policyService;
        this.stateService = stateService;
    }
    setVaultTimeoutOptions(timeout, action) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            // We swap these tokens from being on disk for lock actions, and in memory for logout actions
            // Get them here to set them to their new location after changing the timeout action and clearing if needed
            const token = yield this.tokenService.getToken();
            const refreshToken = yield this.tokenService.getRefreshToken();
            const clientId = yield this.tokenService.getClientId();
            const clientSecret = yield this.tokenService.getClientSecret();
            yield this.stateService.setVaultTimeout(timeout);
            const currentAction = yield this.stateService.getVaultTimeoutAction();
            if ((timeout != null || timeout === 0) &&
                action === VaultTimeoutAction.LogOut &&
                action !== currentAction) {
                // if we have a vault timeout and the action is log out, reset tokens
                yield this.tokenService.clearToken();
            }
            yield this.stateService.setVaultTimeoutAction(action);
            yield this.tokenService.setToken(token);
            yield this.tokenService.setRefreshToken(refreshToken);
            yield this.tokenService.setClientId(clientId);
            yield this.tokenService.setClientSecret(clientSecret);
            yield this.cryptoService.refreshAdditionalKeys();
        });
    }
    availableVaultTimeoutActions$(userId) {
        return (0,external_rxjs_namespaceObject.defer)(() => this.getAvailableVaultTimeoutActions(userId));
    }
    isPinLockSet(userId) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            // we can't check the protected pin for both because old accounts only
            // used it for MP on Restart
            const pinIsEnabled = !!(yield this.stateService.getProtectedPin({ userId }));
            const aUserKeyPinIsSet = !!(yield this.stateService.getPinKeyEncryptedUserKey({ userId }));
            const anOldUserKeyPinIsSet = !!(yield this.stateService.getEncryptedPinProtected({ userId }));
            if (aUserKeyPinIsSet || anOldUserKeyPinIsSet) {
                return "PERSISTANT";
            }
            else if (pinIsEnabled && !aUserKeyPinIsSet && !anOldUserKeyPinIsSet) {
                return "TRANSIENT";
            }
            else {
                return "DISABLED";
            }
        });
    }
    isBiometricLockSet(userId) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            return yield this.stateService.getBiometricUnlock({ userId });
        });
    }
    getVaultTimeout(userId) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            const vaultTimeout = yield this.stateService.getVaultTimeout({ userId });
            if (yield this.policyService.policyAppliesToUser(policy_type_enum_PolicyType.MaximumVaultTimeout, null, userId)) {
                const policy = yield this.policyService.getAll(policy_type_enum_PolicyType.MaximumVaultTimeout, userId);
                // Remove negative values, and ensure it's smaller than maximum allowed value according to policy
                let timeout = Math.min(vaultTimeout, policy[0].data.minutes);
                if (vaultTimeout == null || timeout < 0) {
                    timeout = policy[0].data.minutes;
                }
                // TODO @jlf0dev: Can we move this somwhere else? Maybe add it to the initialization process?
                // ( Apparently I'm the one that reviewed the original PR that added this :) )
                // We really shouldn't need to set the value here, but multiple services relies on this value being correct.
                if (vaultTimeout !== timeout) {
                    yield this.stateService.setVaultTimeout(timeout, { userId });
                }
                return timeout;
            }
            return vaultTimeout;
        });
    }
    vaultTimeoutAction$(userId) {
        return (0,external_rxjs_namespaceObject.defer)(() => this.getVaultTimeoutAction(userId));
    }
    getVaultTimeoutAction(userId) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            const availableActions = yield this.getAvailableVaultTimeoutActions();
            if (availableActions.length === 1) {
                return availableActions[0];
            }
            const vaultTimeoutAction = yield this.stateService.getVaultTimeoutAction({ userId: userId });
            if (yield this.policyService.policyAppliesToUser(policy_type_enum_PolicyType.MaximumVaultTimeout, null, userId)) {
                const policy = yield this.policyService.getAll(policy_type_enum_PolicyType.MaximumVaultTimeout, userId);
                const action = policy[0].data.action;
                // We really shouldn't need to set the value here, but multiple services relies on this value being correct.
                if (action && vaultTimeoutAction !== action) {
                    yield this.stateService.setVaultTimeoutAction(action, { userId: userId });
                }
                if (action && availableActions.includes(action)) {
                    return action;
                }
            }
            if (vaultTimeoutAction == null) {
                // Depends on whether or not the user has a master password
                const defaultValue = (yield this.userHasMasterPassword(userId))
                    ? VaultTimeoutAction.Lock
                    : VaultTimeoutAction.LogOut;
                // We really shouldn't need to set the value here, but multiple services relies on this value being correct.
                yield this.stateService.setVaultTimeoutAction(defaultValue, { userId: userId });
                return defaultValue;
            }
            return vaultTimeoutAction === VaultTimeoutAction.LogOut
                ? VaultTimeoutAction.LogOut
                : VaultTimeoutAction.Lock;
        });
    }
    getAvailableVaultTimeoutActions(userId) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            const availableActions = [VaultTimeoutAction.LogOut];
            const canLock = (yield this.userHasMasterPassword(userId)) ||
                (yield this.isPinLockSet(userId)) !== "DISABLED" ||
                (yield this.isBiometricLockSet(userId));
            if (canLock) {
                availableActions.push(VaultTimeoutAction.Lock);
            }
            return availableActions;
        });
    }
    clear(userId) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            yield this.stateService.setEverBeenUnlocked(false, { userId: userId });
            yield this.cryptoService.clearPinKeys(userId);
        });
    }
    userHasMasterPassword(userId) {
        return vault_timeout_settings_service_awaiter(this, void 0, void 0, function* () {
            const acctDecryptionOpts = yield this.stateService.getAccountDecryptionOptions({
                userId: userId,
            });
            if ((acctDecryptionOpts === null || acctDecryptionOpts === void 0 ? void 0 : acctDecryptionOpts.hasMasterPassword) != undefined) {
                return acctDecryptionOpts.hasMasterPassword;
            }
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/services/vault-timeout/vault-timeout.service.ts
var vault_timeout_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class VaultTimeoutService {
    constructor(cipherService, folderService, collectionService, cryptoService, platformUtilsService, messagingService, searchService, stateService, authService, vaultTimeoutSettingsService, lockedCallback = null, loggedOutCallback = null) {
        this.cipherService = cipherService;
        this.folderService = folderService;
        this.collectionService = collectionService;
        this.cryptoService = cryptoService;
        this.platformUtilsService = platformUtilsService;
        this.messagingService = messagingService;
        this.searchService = searchService;
        this.stateService = stateService;
        this.authService = authService;
        this.vaultTimeoutSettingsService = vaultTimeoutSettingsService;
        this.lockedCallback = lockedCallback;
        this.loggedOutCallback = loggedOutCallback;
        this.inited = false;
    }
    init(checkOnInterval) {
        return vault_timeout_service_awaiter(this, void 0, void 0, function* () {
            if (this.inited) {
                return;
            }
            // TODO: Remove after 2023.10 release (https://bitwarden.atlassian.net/browse/PM-3483)
            yield this.migrateKeyForNeverLockIfNeeded();
            this.inited = true;
            if (checkOnInterval) {
                this.startCheck();
            }
        });
    }
    startCheck() {
        this.checkVaultTimeout();
        setInterval(() => this.checkVaultTimeout(), 10 * 1000); // check every 10 seconds
    }
    checkVaultTimeout() {
        return vault_timeout_service_awaiter(this, void 0, void 0, function* () {
            // Get whether or not the view is open a single time so it can be compared for each user
            const isViewOpen = yield this.platformUtilsService.isViewOpen();
            const activeUserId = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateService.activeAccount$.pipe((0,external_rxjs_namespaceObject.timeout)(500)));
            const accounts = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateService.accounts$);
            for (const userId in accounts) {
                if (userId != null && (yield this.shouldLock(userId, activeUserId, isViewOpen))) {
                    yield this.executeTimeoutAction(userId);
                }
            }
        });
    }
    lock(userId) {
        return vault_timeout_service_awaiter(this, void 0, void 0, function* () {
            const authed = yield this.stateService.getIsAuthenticated({ userId: userId });
            if (!authed) {
                return;
            }
            const availableActions = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.vaultTimeoutSettingsService.availableVaultTimeoutActions$(userId));
            const supportsLock = availableActions.includes(VaultTimeoutAction.Lock);
            if (!supportsLock) {
                yield this.logOut(userId);
            }
            if (userId == null || userId === (yield this.stateService.getUserId())) {
                this.searchService.clearIndex();
                yield this.folderService.clearCache();
            }
            yield this.stateService.setEverBeenUnlocked(true, { userId: userId });
            yield this.stateService.setUserKeyAutoUnlock(null, { userId: userId });
            yield this.stateService.setCryptoMasterKeyAuto(null, { userId: userId });
            yield this.cryptoService.clearUserKey(false, userId);
            yield this.cryptoService.clearMasterKey(userId);
            yield this.cryptoService.clearOrgKeys(true, userId);
            yield this.cryptoService.clearKeyPair(true, userId);
            yield this.cipherService.clearCache(userId);
            yield this.collectionService.clearCache(userId);
            this.messagingService.send("locked", { userId: userId });
            if (this.lockedCallback != null) {
                yield this.lockedCallback(userId);
            }
        });
    }
    logOut(userId) {
        return vault_timeout_service_awaiter(this, void 0, void 0, function* () {
            if (this.loggedOutCallback != null) {
                yield this.loggedOutCallback(false, userId);
            }
        });
    }
    shouldLock(userId, activeUserId, isViewOpen) {
        return vault_timeout_service_awaiter(this, void 0, void 0, function* () {
            if (isViewOpen && userId === activeUserId) {
                // We know a view is open and this is the currently active user
                // which means they are likely looking at their vault
                // and they should not lock.
                return false;
            }
            const authStatus = yield this.authService.getAuthStatus(userId);
            if (authStatus === AuthenticationStatus.Locked ||
                authStatus === AuthenticationStatus.LoggedOut) {
                return false;
            }
            const vaultTimeout = yield this.vaultTimeoutSettingsService.getVaultTimeout(userId);
            if (vaultTimeout == null || vaultTimeout < 0) {
                return false;
            }
            const lastActive = yield this.stateService.getLastActive({ userId: userId });
            if (lastActive == null) {
                return false;
            }
            const vaultTimeoutSeconds = vaultTimeout * 60;
            const diffSeconds = (new Date().getTime() - lastActive) / 1000;
            return diffSeconds >= vaultTimeoutSeconds;
        });
    }
    executeTimeoutAction(userId) {
        return vault_timeout_service_awaiter(this, void 0, void 0, function* () {
            const timeoutAction = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.vaultTimeoutSettingsService.vaultTimeoutAction$(userId));
            timeoutAction === VaultTimeoutAction.LogOut
                ? yield this.logOut(userId)
                : yield this.lock(userId);
        });
    }
    migrateKeyForNeverLockIfNeeded() {
        return vault_timeout_service_awaiter(this, void 0, void 0, function* () {
            // Web can't set vault timeout to never
            if (this.platformUtilsService.getClientType() == ClientType.Web) {
                return;
            }
            const accounts = yield (0,external_rxjs_namespaceObject.firstValueFrom)(this.stateService.accounts$);
            for (const userId in accounts) {
                if (userId != null) {
                    yield this.cryptoService.migrateAutoKeyIfNeeded(userId);
                    // Legacy users should be logged out since we're not on the web vault and can't migrate.
                    if (yield this.cryptoService.isLegacyUser(null, userId)) {
                        yield this.logOut(userId);
                    }
                }
            }
        });
    }
}

;// CONCATENATED MODULE: external "zxcvbn"
const external_zxcvbn_namespaceObject = require("zxcvbn");
;// CONCATENATED MODULE: ../../libs/common/src/tools/password-strength/password-strength.service.ts

class PasswordStrengthService {
    /**
     * Calculates a password strength score using zxcvbn.
     * @param password The password to calculate the strength of.
     * @param emailInput An unparsed email address to use as user input.
     * @param userInputs An array of additional user inputs to use when calculating the strength.
     */
    getPasswordStrength(password, emailInput = null, userInputs = null) {
        if (password == null || password.length === 0) {
            return null;
        }
        const globalUserInputs = [
            "bitwarden",
            "bit",
            "warden",
            ...(userInputs !== null && userInputs !== void 0 ? userInputs : []),
            ...this.emailToUserInputs(emailInput),
        ];
        // Use a hash set to get rid of any duplicate user inputs
        const finalUserInputs = Array.from(new Set(globalUserInputs));
        const result = external_zxcvbn_namespaceObject(password, finalUserInputs);
        return result;
    }
    /**
     * Convert an email address into a list of user inputs for zxcvbn by
     * taking the local part of the email address and splitting it into words.
     * @param email
     * @private
     */
    emailToUserInputs(email) {
        if (email == null || email.length === 0) {
            return [];
        }
        const atPosition = email.indexOf("@");
        if (atPosition < 0) {
            return [];
        }
        return email
            .substring(0, atPosition)
            .trim()
            .toLowerCase()
            .split(/[^A-Za-z0-9]/);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/password-strength/index.ts



;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/api/send-file.api.ts

class SendFileApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.id = this.getResponseProperty("Id");
        this.fileName = this.getResponseProperty("FileName");
        this.size = this.getResponseProperty("Size");
        this.sizeName = this.getResponseProperty("SizeName");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/api/send-text.api.ts

class SendTextApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.text = this.getResponseProperty("Text");
        this.hidden = this.getResponseProperty("Hidden") || false;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/request/send.request.ts



class SendRequest {
    constructor(send, fileLength) {
        this.type = send.type;
        this.fileLength = fileLength;
        this.name = send.name ? send.name.encryptedString : null;
        this.notes = send.notes ? send.notes.encryptedString : null;
        this.maxAccessCount = send.maxAccessCount;
        this.expirationDate = send.expirationDate != null ? send.expirationDate.toISOString() : null;
        this.deletionDate = send.deletionDate != null ? send.deletionDate.toISOString() : null;
        this.key = send.key != null ? send.key.encryptedString : null;
        this.password = send.password;
        this.disabled = send.disabled;
        this.hideEmail = send.hideEmail;
        switch (this.type) {
            case SendType.Text:
                this.text = new SendTextApi();
                this.text.text = send.text.text != null ? send.text.text.encryptedString : null;
                this.text.hidden = send.text.hidden;
                break;
            case SendType.File:
                this.file = new SendFileApi();
                this.file.fileName = send.file.fileName != null ? send.file.fileName.encryptedString : null;
                break;
            default:
                break;
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/response/send-access.response.ts



class SendAccessResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.type = this.getResponseProperty("Type");
        this.name = this.getResponseProperty("Name");
        const text = this.getResponseProperty("Text");
        if (text != null) {
            this.text = new SendTextApi(text);
        }
        const file = this.getResponseProperty("File");
        if (file != null) {
            this.file = new SendFileApi(file);
        }
        this.expirationDate = this.getResponseProperty("ExpirationDate");
        this.creatorIdentifier = this.getResponseProperty("CreatorIdentifier");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/response/send-file-download-data.response.ts

class SendFileDownloadDataResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = null;
        this.url = null;
        this.id = this.getResponseProperty("Id");
        this.url = this.getResponseProperty("Url");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/response/send.response.ts



class SendResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.id = this.getResponseProperty("Id");
        this.accessId = this.getResponseProperty("AccessId");
        this.type = this.getResponseProperty("Type");
        this.name = this.getResponseProperty("Name");
        this.notes = this.getResponseProperty("Notes");
        this.key = this.getResponseProperty("Key");
        this.maxAccessCount = this.getResponseProperty("MaxAccessCount");
        this.accessCount = this.getResponseProperty("AccessCount");
        this.revisionDate = this.getResponseProperty("RevisionDate");
        this.expirationDate = this.getResponseProperty("ExpirationDate");
        this.deletionDate = this.getResponseProperty("DeletionDate");
        this.password = this.getResponseProperty("Password");
        this.disable = this.getResponseProperty("Disabled") || false;
        this.hideEmail = this.getResponseProperty("HideEmail") || false;
        const text = this.getResponseProperty("Text");
        if (text != null) {
            this.text = new SendTextApi(text);
        }
        const file = this.getResponseProperty("File");
        if (file != null) {
            this.file = new SendFileApi(file);
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/response/send-file-upload-data.response.ts


class SendFileUploadDataResponse extends BaseResponse {
    constructor(response) {
        super(response);
        this.url = null;
        this.fileUploadType = this.getResponseProperty("FileUploadType");
        const sendResponse = this.getResponseProperty("SendResponse");
        this.sendResponse = sendResponse == null ? null : new SendResponse(sendResponse);
        this.url = this.getResponseProperty("Url");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/services/send-api.service.ts
var send_api_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};










class SendApiService {
    constructor(apiService, fileUploadService, sendService) {
        this.apiService = apiService;
        this.fileUploadService = fileUploadService;
        this.sendService = sendService;
    }
    getSend(id) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/sends/" + id, null, true, true);
            return new SendResponse(r);
        });
    }
    postSendAccess(id, request, apiUrl) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const addSendIdHeader = (headers) => {
                headers.set("Send-Id", id);
            };
            const r = yield this.apiService.send("POST", "/sends/access/" + id, request, false, true, apiUrl, addSendIdHeader);
            return new SendAccessResponse(r);
        });
    }
    getSendFileDownloadData(send, request, apiUrl) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const addSendIdHeader = (headers) => {
                headers.set("Send-Id", send.id);
            };
            const r = yield this.apiService.send("POST", "/sends/" + send.id + "/access/file/" + send.file.id, request, false, true, apiUrl, addSendIdHeader);
            return new SendFileDownloadDataResponse(r);
        });
    }
    getSends() {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/sends", null, true, true);
            return new ListResponse(r, SendResponse);
        });
    }
    postSend(request) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/sends", request, true, true);
            return new SendResponse(r);
        });
    }
    postFileTypeSend(request) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/sends/file/v2", request, true, true);
            return new SendFileUploadDataResponse(r);
        });
    }
    renewSendFileUploadUrl(sendId, fileId) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("GET", "/sends/" + sendId + "/file/" + fileId, null, true, true);
            return new SendFileUploadDataResponse(r);
        });
    }
    postSendFile(sendId, fileId, data) {
        return this.apiService.send("POST", "/sends/" + sendId + "/file/" + fileId, data, true, false);
    }
    /**
     * @deprecated Mar 25 2021: This method has been deprecated in favor of direct uploads.
     * This method still exists for backward compatibility with old server versions.
     */
    postSendFileLegacy(data) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("POST", "/sends/file", data, true, true);
            return new SendResponse(r);
        });
    }
    putSend(id, request) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/sends/" + id, request, true, true);
            return new SendResponse(r);
        });
    }
    putSendRemovePassword(id) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const r = yield this.apiService.send("PUT", "/sends/" + id + "/remove-password", null, true, true);
            return new SendResponse(r);
        });
    }
    deleteSend(id) {
        return this.apiService.send("DELETE", "/sends/" + id, null, true, false);
    }
    save(sendData) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const response = yield this.upload(sendData);
            const data = new SendData(response);
            yield this.sendService.upsert(data);
        });
    }
    delete(id) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            yield this.deleteSend(id);
            yield this.sendService.delete(id);
        });
    }
    removePassword(id) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const response = yield this.putSendRemovePassword(id);
            const data = new SendData(response);
            yield this.sendService.upsert(data);
        });
    }
    // Send File Upload methods
    upload(sendData) {
        var _a;
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const request = new SendRequest(sendData[0], (_a = sendData[1]) === null || _a === void 0 ? void 0 : _a.buffer.byteLength);
            let response;
            if (sendData[0].id == null) {
                if (sendData[0].type === SendType.Text) {
                    response = yield this.postSend(request);
                }
                else {
                    try {
                        const uploadDataResponse = yield this.postFileTypeSend(request);
                        response = uploadDataResponse.sendResponse;
                        yield this.fileUploadService.upload(uploadDataResponse, sendData[0].file.fileName, sendData[1], this.generateMethods(uploadDataResponse, response));
                    }
                    catch (e) {
                        if (e instanceof ErrorResponse && e.statusCode === 404) {
                            response = yield this.legacyServerSendFileUpload(sendData, request);
                        }
                        else if (e instanceof ErrorResponse) {
                            throw new Error(e.getSingleMessage());
                        }
                        else {
                            throw e;
                        }
                    }
                }
                sendData[0].id = response.id;
                sendData[0].accessId = response.accessId;
            }
            else {
                response = yield this.putSend(sendData[0].id, request);
            }
            return response;
        });
    }
    generateMethods(uploadData, response) {
        return {
            postDirect: this.generatePostDirectCallback(response),
            renewFileUploadUrl: this.generateRenewFileUploadUrlCallback(response.id, response.file.id),
            rollback: this.generateRollbackCallback(response.id),
        };
    }
    generatePostDirectCallback(sendResponse) {
        return (data) => {
            return this.postSendFile(sendResponse.id, sendResponse.file.id, data);
        };
    }
    generateRenewFileUploadUrlCallback(sendId, fileId) {
        return () => send_api_service_awaiter(this, void 0, void 0, function* () {
            const renewResponse = yield this.renewSendFileUploadUrl(sendId, fileId);
            return renewResponse === null || renewResponse === void 0 ? void 0 : renewResponse.url;
        });
    }
    generateRollbackCallback(sendId) {
        return () => {
            return this.deleteSend(sendId);
        };
    }
    /**
     * @deprecated Mar 25 2021: This method has been deprecated in favor of direct uploads.
     * This method still exists for backward compatibility with old server versions.
     */
    legacyServerSendFileUpload(sendData, request) {
        return send_api_service_awaiter(this, void 0, void 0, function* () {
            const fd = new FormData();
            try {
                const blob = new Blob([sendData[1].buffer], { type: "application/octet-stream" });
                fd.append("model", JSON.stringify(request));
                fd.append("data", blob, sendData[0].file.fileName.encryptedString);
            }
            catch (e) {
                if (utils_Utils.isNode && !utils_Utils.isBrowser) {
                    fd.append("model", JSON.stringify(request));
                    fd.append("data", Buffer.from(sendData[1].buffer), {
                        filepath: sendData[0].file.fileName.encryptedString,
                        contentType: "application/octet-stream",
                    });
                }
                else {
                    throw e;
                }
            }
            return yield this.postSendFileLegacy(fd);
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/domain/send-file.ts
var send_file_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



class SendFile extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.size = obj.size;
        this.buildDomainModel(this, obj, {
            id: null,
            sizeName: null,
            fileName: null,
        }, ["id", "sizeName"]);
    }
    decrypt(key) {
        return send_file_awaiter(this, void 0, void 0, function* () {
            const view = yield this.decryptObj(new SendFileView(this), {
                fileName: null,
            }, null, key);
            return view;
        });
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new SendFile(), obj, {
            fileName: EncString.fromJSON(obj.fileName),
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/domain/send-text.ts



class SendText extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.hidden = obj.hidden;
        this.buildDomainModel(this, obj, {
            text: null,
        }, []);
    }
    decrypt(key) {
        return this.decryptObj(new SendTextView(this), {
            text: null,
        }, null, key);
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new SendText(), obj, {
            text: EncString.fromJSON(obj.text),
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/domain/send.ts
var send_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};







class Send extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            id: null,
            accessId: null,
            name: null,
            notes: null,
            key: null,
        }, ["id", "accessId"]);
        this.type = obj.type;
        this.maxAccessCount = obj.maxAccessCount;
        this.accessCount = obj.accessCount;
        this.password = obj.password;
        this.disabled = obj.disabled;
        this.revisionDate = obj.revisionDate != null ? new Date(obj.revisionDate) : null;
        this.deletionDate = obj.deletionDate != null ? new Date(obj.deletionDate) : null;
        this.expirationDate = obj.expirationDate != null ? new Date(obj.expirationDate) : null;
        this.hideEmail = obj.hideEmail;
        switch (this.type) {
            case SendType.Text:
                this.text = new SendText(obj.text);
                break;
            case SendType.File:
                this.file = new SendFile(obj.file);
                break;
            default:
                break;
        }
    }
    decrypt() {
        return send_awaiter(this, void 0, void 0, function* () {
            const model = new SendView(this);
            const cryptoService = utils_Utils.getContainerService().getCryptoService();
            try {
                model.key = yield cryptoService.decryptToBytes(this.key, null);
                model.cryptoKey = yield cryptoService.makeSendKey(model.key);
            }
            catch (e) {
                // TODO: error?
            }
            yield this.decryptObj(model, {
                name: null,
                notes: null,
            }, null, model.cryptoKey);
            switch (this.type) {
                case SendType.File:
                    model.file = yield this.file.decrypt(model.cryptoKey);
                    break;
                case SendType.Text:
                    model.text = yield this.text.decrypt(model.cryptoKey);
                    break;
                default:
                    break;
            }
            return model;
        });
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        const expirationDate = obj.expirationDate == null ? null : new Date(obj.expirationDate);
        const deletionDate = obj.deletionDate == null ? null : new Date(obj.deletionDate);
        return Object.assign(new Send(), obj, {
            key: EncString.fromJSON(obj.key),
            name: EncString.fromJSON(obj.name),
            notes: EncString.fromJSON(obj.notes),
            text: SendText.fromJSON(obj.text),
            file: SendFile.fromJSON(obj.file),
            revisionDate,
            expirationDate,
            deletionDate,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/models/request/send-with-id.request.ts

class SendWithIdRequest extends SendRequest {
    constructor(send) {
        super(send);
        this.id = send.id;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/send-kdf.ts
const SEND_KDF_ITERATIONS = 100000;

;// CONCATENATED MODULE: ../../libs/common/src/tools/send/services/send.service.ts
var send_service_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};









class SendService {
    constructor(cryptoService, i18nService, cryptoFunctionService, stateService) {
        this.cryptoService = cryptoService;
        this.i18nService = i18nService;
        this.cryptoFunctionService = cryptoFunctionService;
        this.stateService = stateService;
        this._sends = new external_rxjs_namespaceObject.BehaviorSubject([]);
        this._sendViews = new external_rxjs_namespaceObject.BehaviorSubject([]);
        this.sends$ = this._sends.asObservable();
        this.sendViews$ = this._sendViews.asObservable();
        this.stateService.activeAccountUnlocked$
            .pipe((0,external_rxjs_namespaceObject.concatMap)((unlocked) => send_service_awaiter(this, void 0, void 0, function* () {
            if (utils_Utils.global.bitwardenContainerService == null) {
                return;
            }
            if (!unlocked) {
                this._sends.next([]);
                this._sendViews.next([]);
                return;
            }
            const data = yield this.stateService.getEncryptedSends();
            yield this.updateObservables(data);
        })))
            .subscribe();
    }
    clearCache() {
        return send_service_awaiter(this, void 0, void 0, function* () {
            yield this._sendViews.next([]);
        });
    }
    encrypt(model, file, password, key) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            let fileData = null;
            const send = new Send();
            send.id = model.id;
            send.type = model.type;
            send.disabled = model.disabled;
            send.hideEmail = model.hideEmail;
            send.maxAccessCount = model.maxAccessCount;
            if (model.key == null) {
                model.key = yield this.cryptoFunctionService.aesGenerateKey(128);
                model.cryptoKey = yield this.cryptoService.makeSendKey(model.key);
            }
            if (password != null) {
                const passwordHash = yield this.cryptoFunctionService.pbkdf2(password, model.key, "sha256", SEND_KDF_ITERATIONS);
                send.password = utils_Utils.fromBufferToB64(passwordHash);
            }
            send.key = yield this.cryptoService.encrypt(model.key, key);
            send.name = yield this.cryptoService.encrypt(model.name, model.cryptoKey);
            send.notes = yield this.cryptoService.encrypt(model.notes, model.cryptoKey);
            if (send.type === SendType.Text) {
                send.text = new SendText();
                send.text.text = yield this.cryptoService.encrypt(model.text.text, model.cryptoKey);
                send.text.hidden = model.text.hidden;
            }
            else if (send.type === SendType.File) {
                send.file = new SendFile();
                if (file != null) {
                    if (file instanceof ArrayBuffer) {
                        const [name, data] = yield this.encryptFileData(model.file.fileName, file, model.cryptoKey);
                        send.file.fileName = name;
                        fileData = data;
                    }
                    else {
                        fileData = yield this.parseFile(send, file, model.cryptoKey);
                    }
                }
            }
            return [send, fileData];
        });
    }
    get(id) {
        const sends = this._sends.getValue();
        return sends.find((send) => send.id === id);
    }
    getFromState(id) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            const sends = yield this.stateService.getEncryptedSends();
            // eslint-disable-next-line
            if (sends == null || !sends.hasOwnProperty(id)) {
                return null;
            }
            return new Send(sends[id]);
        });
    }
    getAll() {
        return send_service_awaiter(this, void 0, void 0, function* () {
            const sends = yield this.stateService.getEncryptedSends();
            const response = [];
            for (const id in sends) {
                // eslint-disable-next-line
                if (sends.hasOwnProperty(id)) {
                    response.push(new Send(sends[id]));
                }
            }
            return response;
        });
    }
    getAllDecryptedFromState() {
        return send_service_awaiter(this, void 0, void 0, function* () {
            let decSends = yield this.stateService.getDecryptedSends();
            if (decSends != null) {
                return decSends;
            }
            decSends = [];
            const hasKey = yield this.cryptoService.hasUserKey();
            if (!hasKey) {
                throw new Error("No user key found.");
            }
            const promises = [];
            const sends = yield this.getAll();
            sends.forEach((send) => {
                promises.push(send.decrypt().then((f) => decSends.push(f)));
            });
            yield Promise.all(promises);
            decSends.sort(utils_Utils.getSortFunction(this.i18nService, "name"));
            yield this.stateService.setDecryptedSends(decSends);
            return decSends;
        });
    }
    upsert(send) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            let sends = yield this.stateService.getEncryptedSends();
            if (sends == null) {
                sends = {};
            }
            if (send instanceof SendData) {
                const s = send;
                sends[s.id] = s;
            }
            else {
                send.forEach((s) => {
                    sends[s.id] = s;
                });
            }
            yield this.replace(sends);
        });
    }
    clear(userId) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            if (userId == null || userId == (yield this.stateService.getUserId())) {
                this._sends.next([]);
                this._sendViews.next([]);
            }
            yield this.stateService.setDecryptedSends(null, { userId: userId });
            yield this.stateService.setEncryptedSends(null, { userId: userId });
        });
    }
    delete(id) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            const sends = yield this.stateService.getEncryptedSends();
            if (sends == null) {
                return;
            }
            if (typeof id === "string") {
                if (sends[id] == null) {
                    return;
                }
                delete sends[id];
            }
            else {
                id.forEach((i) => {
                    delete sends[i];
                });
            }
            yield this.replace(sends);
        });
    }
    replace(sends) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            yield this.updateObservables(sends);
            yield this.stateService.setEncryptedSends(sends);
        });
    }
    getRotatedKeys(newUserKey) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            if (newUserKey == null) {
                throw new Error("New user key is required for rotation.");
            }
            const requests = yield Promise.all(this._sends.value.map((send) => send_service_awaiter(this, void 0, void 0, function* () {
                const sendKey = yield this.cryptoService.decryptToBytes(send.key);
                send.key = yield this.cryptoService.encrypt(sendKey, newUserKey);
                return new SendWithIdRequest(send);
            })));
            // separate return for easier debugging
            return requests;
        });
    }
    parseFile(send, file, key) {
        return new Promise((resolve, reject) => {
            const reader = new FileReader();
            reader.readAsArrayBuffer(file);
            reader.onload = (evt) => send_service_awaiter(this, void 0, void 0, function* () {
                try {
                    const [name, data] = yield this.encryptFileData(file.name, evt.target.result, key);
                    send.file.fileName = name;
                    resolve(data);
                }
                catch (e) {
                    reject(e);
                }
            });
            reader.onerror = () => {
                reject("Error reading file.");
            };
        });
    }
    encryptFileData(fileName, data, key) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            const encFileName = yield this.cryptoService.encrypt(fileName, key);
            const encFileData = yield this.cryptoService.encryptToBytes(new Uint8Array(data), key);
            return [encFileName, encFileData];
        });
    }
    updateObservables(sendsMap) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            const sends = Object.values(sendsMap || {}).map((f) => new Send(f));
            this._sends.next(sends);
            if (yield this.cryptoService.hasUserKey()) {
                this._sendViews.next(yield this.decryptSends(sends));
            }
        });
    }
    decryptSends(sends) {
        return send_service_awaiter(this, void 0, void 0, function* () {
            const decryptSendPromises = sends.map((s) => s.decrypt());
            const decryptedSends = yield Promise.all(decryptSendPromises);
            decryptedSends.sort(utils_Utils.getSortFunction(this.i18nService, "name"));
            return decryptedSends;
        });
    }
}

;// CONCATENATED MODULE: external "semver"
const external_semver_namespaceObject = require("semver");
;// CONCATENATED MODULE: ../../libs/common/src/platform/misc/flags.ts
function getFlags(envFlags) {
    if (typeof envFlags === "string") {
        return JSON.parse(envFlags);
    }
    else {
        return envFlags;
    }
}
/**
 * Gets the value of a feature flag from environment.
 * All flags default to "on" (true).
 * Only use for shared code in `libs`, otherwise use the client-specific function.
 * @param flag The name of the feature flag to check
 * @returns The value of the flag
 */
function flagEnabled(flag) {
    const flags = getFlags({"enableCipherKeyEncryption":false});
    return flags[flag] == null || !!flags[flag];
}
/**
 * Gets the value of a dev flag from environment.
 * Will always return false unless in development.
 * Only use for shared code in `libs`, otherwise use the client-specific function.
 * @param flag The name of the dev flag to check
 * @returns The value of the flag
 */
function devFlagEnabled(flag) {
    if (process.env.ENV !== "development") {
        return false;
    }
    const devFlags = getFlags(process.env.DEV_FLAGS);
    return (devFlags === null || devFlags === void 0 ? void 0 : devFlags[flag]) == null ? false : !!devFlags[flag];
}
/**
 * Gets the value of a dev flag from environment.
 * Will always return false unless in development.
 * @param flag The name of the dev flag to check
 * @returns The value of the flag
 * @throws Error if the flag is not enabled
 */
function devFlagValue(flag) {
    if (!devFlagEnabled(flag)) {
        throw new Error(`This method should not be called, it is protected by a disabled dev flag.`);
    }
    const devFlags = getFlags(process.env.DEV_FLAGS);
    return devFlags[flag];
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/attachment.ts
var attachment_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






class Attachment extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.size = obj.size;
        this.buildDomainModel(this, obj, {
            id: null,
            url: null,
            sizeName: null,
            fileName: null,
            key: null,
        }, ["id", "url", "sizeName"]);
    }
    decrypt(orgId, encKey) {
        return attachment_awaiter(this, void 0, void 0, function* () {
            const view = yield this.decryptObj(new AttachmentView(this), {
                fileName: null,
            }, orgId, encKey);
            if (this.key != null) {
                view.key = yield this.decryptAttachmentKey(orgId, encKey);
            }
            return view;
        });
    }
    decryptAttachmentKey(orgId, encKey) {
        return attachment_awaiter(this, void 0, void 0, function* () {
            try {
                if (encKey == null) {
                    encKey = yield this.getKeyForDecryption(orgId);
                }
                const encryptService = utils_Utils.getContainerService().getEncryptService();
                const decValue = yield encryptService.decryptToBytes(this.key, encKey);
                return new SymmetricCryptoKey(decValue);
            }
            catch (e) {
                // TODO: error?
            }
        });
    }
    getKeyForDecryption(orgId) {
        return attachment_awaiter(this, void 0, void 0, function* () {
            const cryptoService = utils_Utils.getContainerService().getCryptoService();
            return orgId != null
                ? yield cryptoService.getOrgKey(orgId)
                : yield cryptoService.getUserKeyWithLegacySupport();
        });
    }
    toAttachmentData() {
        const a = new AttachmentData();
        a.size = this.size;
        this.buildDataModel(this, a, {
            id: null,
            url: null,
            sizeName: null,
            fileName: null,
            key: null,
        }, ["id", "url", "sizeName"]);
        return a;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const key = EncString.fromJSON(obj.key);
        const fileName = EncString.fromJSON(obj.fileName);
        return Object.assign(new Attachment(), obj, {
            key,
            fileName,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/card.ts




class Card extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            cardholderName: null,
            brand: null,
            number: null,
            expMonth: null,
            expYear: null,
            code: null,
        }, []);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(new CardView(), {
            cardholderName: null,
            brand: null,
            number: null,
            expMonth: null,
            expYear: null,
            code: null,
        }, orgId, encKey);
    }
    toCardData() {
        const c = new CardData();
        this.buildDataModel(this, c, {
            cardholderName: null,
            brand: null,
            number: null,
            expMonth: null,
            expYear: null,
            code: null,
        });
        return c;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const cardholderName = EncString.fromJSON(obj.cardholderName);
        const brand = EncString.fromJSON(obj.brand);
        const number = EncString.fromJSON(obj.number);
        const expMonth = EncString.fromJSON(obj.expMonth);
        const expYear = EncString.fromJSON(obj.expYear);
        const code = EncString.fromJSON(obj.code);
        return Object.assign(new Card(), obj, {
            cardholderName,
            brand,
            number,
            expMonth,
            expYear,
            code,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/field.ts




class Field extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.type = obj.type;
        this.linkedId = obj.linkedId;
        this.buildDomainModel(this, obj, {
            name: null,
            value: null,
        }, []);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(new FieldView(this), {
            name: null,
            value: null,
        }, orgId, encKey);
    }
    toFieldData() {
        const f = new FieldData();
        this.buildDataModel(this, f, {
            name: null,
            value: null,
            type: null,
            linkedId: null,
        }, ["type", "linkedId"]);
        return f;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const name = EncString.fromJSON(obj.name);
        const value = EncString.fromJSON(obj.value);
        return Object.assign(new Field(), obj, {
            name,
            value,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/identity.ts




class Identity extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            title: null,
            firstName: null,
            middleName: null,
            lastName: null,
            address1: null,
            address2: null,
            address3: null,
            city: null,
            state: null,
            postalCode: null,
            country: null,
            company: null,
            email: null,
            phone: null,
            ssn: null,
            username: null,
            passportNumber: null,
            licenseNumber: null,
        }, []);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(new IdentityView(), {
            title: null,
            firstName: null,
            middleName: null,
            lastName: null,
            address1: null,
            address2: null,
            address3: null,
            city: null,
            state: null,
            postalCode: null,
            country: null,
            company: null,
            email: null,
            phone: null,
            ssn: null,
            username: null,
            passportNumber: null,
            licenseNumber: null,
        }, orgId, encKey);
    }
    toIdentityData() {
        const i = new IdentityData();
        this.buildDataModel(this, i, {
            title: null,
            firstName: null,
            middleName: null,
            lastName: null,
            address1: null,
            address2: null,
            address3: null,
            city: null,
            state: null,
            postalCode: null,
            country: null,
            company: null,
            email: null,
            phone: null,
            ssn: null,
            username: null,
            passportNumber: null,
            licenseNumber: null,
        });
        return i;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const title = EncString.fromJSON(obj.title);
        const firstName = EncString.fromJSON(obj.firstName);
        const middleName = EncString.fromJSON(obj.middleName);
        const lastName = EncString.fromJSON(obj.lastName);
        const address1 = EncString.fromJSON(obj.address1);
        const address2 = EncString.fromJSON(obj.address2);
        const address3 = EncString.fromJSON(obj.address3);
        const city = EncString.fromJSON(obj.city);
        const state = EncString.fromJSON(obj.state);
        const postalCode = EncString.fromJSON(obj.postalCode);
        const country = EncString.fromJSON(obj.country);
        const company = EncString.fromJSON(obj.company);
        const email = EncString.fromJSON(obj.email);
        const phone = EncString.fromJSON(obj.phone);
        const ssn = EncString.fromJSON(obj.ssn);
        const username = EncString.fromJSON(obj.username);
        const passportNumber = EncString.fromJSON(obj.passportNumber);
        const licenseNumber = EncString.fromJSON(obj.licenseNumber);
        return Object.assign(new Identity(), obj, {
            title,
            firstName,
            middleName,
            lastName,
            address1,
            address2,
            address3,
            city,
            state,
            postalCode,
            country,
            company,
            email,
            phone,
            ssn,
            username,
            passportNumber,
            licenseNumber,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/fido2-credential.ts
var fido2_credential_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};




class Fido2Credential extends Domain {
    constructor(obj) {
        super();
        this.credentialId = null;
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            credentialId: null,
            keyType: null,
            keyAlgorithm: null,
            keyCurve: null,
            keyValue: null,
            rpId: null,
            userHandle: null,
            userName: null,
            counter: null,
            rpName: null,
            userDisplayName: null,
            discoverable: null,
        }, []);
        this.creationDate = obj.creationDate != null ? new Date(obj.creationDate) : null;
    }
    decrypt(orgId, encKey) {
        return fido2_credential_awaiter(this, void 0, void 0, function* () {
            const view = yield this.decryptObj(new Fido2CredentialView(), {
                credentialId: null,
                keyType: null,
                keyAlgorithm: null,
                keyCurve: null,
                keyValue: null,
                rpId: null,
                userHandle: null,
                userName: null,
                rpName: null,
                userDisplayName: null,
                discoverable: null,
            }, orgId, encKey);
            const { counter } = yield this.decryptObj({ counter: "" }, {
                counter: null,
            }, orgId, encKey);
            // Counter will end up as NaN if this fails
            view.counter = parseInt(counter);
            const { discoverable } = yield this.decryptObj({ discoverable: "" }, {
                discoverable: null,
            }, orgId, encKey);
            view.discoverable = discoverable === "true";
            view.creationDate = this.creationDate;
            return view;
        });
    }
    toFido2CredentialData() {
        const i = new Fido2CredentialData();
        i.creationDate = this.creationDate.toISOString();
        this.buildDataModel(this, i, {
            credentialId: null,
            keyType: null,
            keyAlgorithm: null,
            keyCurve: null,
            keyValue: null,
            rpId: null,
            userHandle: null,
            userName: null,
            counter: null,
            rpName: null,
            userDisplayName: null,
            discoverable: null,
        });
        return i;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const credentialId = EncString.fromJSON(obj.credentialId);
        const keyType = EncString.fromJSON(obj.keyType);
        const keyAlgorithm = EncString.fromJSON(obj.keyAlgorithm);
        const keyCurve = EncString.fromJSON(obj.keyCurve);
        const keyValue = EncString.fromJSON(obj.keyValue);
        const rpId = EncString.fromJSON(obj.rpId);
        const userHandle = EncString.fromJSON(obj.userHandle);
        const userName = EncString.fromJSON(obj.userName);
        const counter = EncString.fromJSON(obj.counter);
        const rpName = EncString.fromJSON(obj.rpName);
        const userDisplayName = EncString.fromJSON(obj.userDisplayName);
        const discoverable = EncString.fromJSON(obj.discoverable);
        const creationDate = obj.creationDate != null ? new Date(obj.creationDate) : null;
        return Object.assign(new Fido2Credential(), obj, {
            credentialId,
            keyType,
            keyAlgorithm,
            keyCurve,
            keyValue,
            rpId,
            userHandle,
            userName,
            counter,
            rpName,
            userDisplayName,
            discoverable,
            creationDate,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/login-uri.ts
var login_uri_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};





class LoginUri extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.match = obj.match;
        this.buildDomainModel(this, obj, {
            uri: null,
            uriChecksum: null,
        }, []);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(new LoginUriView(this), {
            uri: null,
        }, orgId, encKey);
    }
    validateChecksum(clearTextUri, orgId, encKey) {
        return login_uri_awaiter(this, void 0, void 0, function* () {
            if (this.uriChecksum == null) {
                return false;
            }
            const cryptoService = utils_Utils.getContainerService().getEncryptService();
            const localChecksum = yield cryptoService.hash(clearTextUri, "sha256");
            const remoteChecksum = yield this.uriChecksum.decrypt(orgId, encKey);
            return remoteChecksum === localChecksum;
        });
    }
    toLoginUriData() {
        const u = new LoginUriData();
        this.buildDataModel(this, u, {
            uri: null,
            uriChecksum: null,
            match: null,
        }, ["match"]);
        return u;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const uri = EncString.fromJSON(obj.uri);
        const uriChecksum = EncString.fromJSON(obj.uriChecksum);
        return Object.assign(new LoginUri(), obj, {
            uri,
            uriChecksum,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/login.ts
var login_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};






class Login extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.passwordRevisionDate =
            obj.passwordRevisionDate != null ? new Date(obj.passwordRevisionDate) : null;
        this.autofillOnPageLoad = obj.autofillOnPageLoad;
        this.buildDomainModel(this, obj, {
            username: null,
            password: null,
            totp: null,
        }, []);
        if (obj.uris) {
            this.uris = [];
            obj.uris.forEach((u) => {
                this.uris.push(new LoginUri(u));
            });
        }
        if (obj.fido2Credentials) {
            this.fido2Credentials = obj.fido2Credentials.map((key) => new Fido2Credential(key));
        }
    }
    decrypt(orgId, bypassValidation, encKey) {
        return login_awaiter(this, void 0, void 0, function* () {
            const view = yield this.decryptObj(new LoginView(this), {
                username: null,
                password: null,
                totp: null,
            }, orgId, encKey);
            if (this.uris != null) {
                view.uris = [];
                for (let i = 0; i < this.uris.length; i++) {
                    const uri = yield this.uris[i].decrypt(orgId, encKey);
                    // URIs are shared remotely after decryption
                    // we need to validate that the string hasn't been changed by a compromised server
                    // This validation is tied to the existence of cypher.key for backwards compatibility
                    // So we bypass the validation if there's no cipher.key or procceed with the validation and
                    // Skip the value if it's been tampered with.
                    if (bypassValidation || (yield this.uris[i].validateChecksum(uri.uri, orgId, encKey))) {
                        view.uris.push(uri);
                    }
                }
            }
            if (this.fido2Credentials != null) {
                view.fido2Credentials = yield Promise.all(this.fido2Credentials.map((key) => key.decrypt(orgId, encKey)));
            }
            return view;
        });
    }
    toLoginData() {
        const l = new LoginData();
        l.passwordRevisionDate =
            this.passwordRevisionDate != null ? this.passwordRevisionDate.toISOString() : null;
        l.autofillOnPageLoad = this.autofillOnPageLoad;
        this.buildDataModel(this, l, {
            username: null,
            password: null,
            totp: null,
        });
        if (this.uris != null && this.uris.length > 0) {
            l.uris = [];
            this.uris.forEach((u) => {
                l.uris.push(u.toLoginUriData());
            });
        }
        if (this.fido2Credentials != null && this.fido2Credentials.length > 0) {
            l.fido2Credentials = this.fido2Credentials.map((key) => key.toFido2CredentialData());
        }
        return l;
    }
    static fromJSON(obj) {
        var _a, _b, _c;
        if (obj == null) {
            return null;
        }
        const username = EncString.fromJSON(obj.username);
        const password = EncString.fromJSON(obj.password);
        const totp = EncString.fromJSON(obj.totp);
        const passwordRevisionDate = obj.passwordRevisionDate == null ? null : new Date(obj.passwordRevisionDate);
        const uris = (_a = obj.uris) === null || _a === void 0 ? void 0 : _a.map((uri) => LoginUri.fromJSON(uri));
        const fido2Credentials = (_c = (_b = obj.fido2Credentials) === null || _b === void 0 ? void 0 : _b.map((key) => Fido2Credential.fromJSON(key))) !== null && _c !== void 0 ? _c : [];
        return Object.assign(new Login(), obj, {
            username,
            password,
            totp,
            passwordRevisionDate,
            uris,
            fido2Credentials,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/password.ts




class Password extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            password: null,
        });
        this.lastUsedDate = new Date(obj.lastUsedDate);
    }
    decrypt(orgId, encKey) {
        return this.decryptObj(new PasswordHistoryView(this), {
            password: null,
        }, orgId, encKey);
    }
    toPasswordHistoryData() {
        const ph = new PasswordHistoryData();
        ph.lastUsedDate = this.lastUsedDate.toISOString();
        this.buildDataModel(this, ph, {
            password: null,
        });
        return ph;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        const password = EncString.fromJSON(obj.password);
        const lastUsedDate = obj.lastUsedDate == null ? null : new Date(obj.lastUsedDate);
        return Object.assign(new Password(), obj, {
            password,
            lastUsedDate,
        });
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/secure-note.ts



class SecureNote extends Domain {
    constructor(obj) {
        super();
        if (obj == null) {
            return;
        }
        this.type = obj.type;
    }
    decrypt(orgId, encKey) {
        return Promise.resolve(new SecureNoteView(this));
    }
    toSecureNoteData() {
        const n = new SecureNoteData();
        n.type = this.type;
        return n;
    }
    static fromJSON(obj) {
        if (obj == null) {
            return null;
        }
        return Object.assign(new SecureNote(), obj);
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/cipher.ts
var cipher_awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};















class Cipher extends Domain {
    constructor(obj, localData = null) {
        super();
        this.initializerKey = InitializerKey.Cipher;
        if (obj == null) {
            return;
        }
        this.buildDomainModel(this, obj, {
            id: null,
            organizationId: null,
            folderId: null,
            name: null,
            notes: null,
            key: null,
        }, ["id", "organizationId", "folderId"]);
        this.type = obj.type;
        this.favorite = obj.favorite;
        this.organizationUseTotp = obj.organizationUseTotp;
        this.edit = obj.edit;
        if (obj.viewPassword != null) {
            this.viewPassword = obj.viewPassword;
        }
        else {
            this.viewPassword = true; // Default for already synced Ciphers without viewPassword
        }
        this.revisionDate = obj.revisionDate != null ? new Date(obj.revisionDate) : null;
        this.collectionIds = obj.collectionIds;
        this.localData = localData;
        this.creationDate = obj.creationDate != null ? new Date(obj.creationDate) : null;
        this.deletedDate = obj.deletedDate != null ? new Date(obj.deletedDate) : null;
        this.reprompt = obj.reprompt;
        switch (this.type) {
            case CipherType.Login:
                this.login = new Login(obj.login);
                break;
            case CipherType.SecureNote:
                this.secureNote = new SecureNote(obj.secureNote);
                break;
            case CipherType.Card:
                this.card = new Card(obj.card);
                break;
            case CipherType.Identity:
                this.identity = new Identity(obj.identity);
                break;
            default:
                break;
        }
        if (obj.attachments != null) {
            this.attachments = obj.attachments.map((a) => new Attachment(a));
        }
        else {
            this.attachments = null;
        }
        if (obj.fields != null) {
            this.fields = obj.fields.map((f) => new Field(f));
        }
        else {
            this.fields = null;
        }
        if (obj.passwordHistory != null) {
            this.passwordHistory = obj.passwordHistory.map((ph) => new Password(ph));
        }
        else {
            this.passwordHistory = null;
        }
    }
    // We are passing the organizationId into the EncString.decrypt() method here, but because the encKey will always be
    // present and so the organizationId will not be used.
    // We will refactor the EncString.decrypt() in https://bitwarden.atlassian.net/browse/PM-3762 to remove the dependency on the organizationId.
    decrypt(encKey) {
        return cipher_awaiter(this, void 0, void 0, function* () {
            const model = new CipherView(this);
            let bypassValidation = true;
            if (this.key != null) {
                const encryptService = utils_Utils.getContainerService().getEncryptService();
                encKey = new SymmetricCryptoKey(yield encryptService.decryptToBytes(this.key, encKey));
                bypassValidation = false;
            }
            yield this.decryptObj(model, {
                name: null,
                notes: null,
            }, this.organizationId, encKey);
            switch (this.type) {
                case CipherType.Login:
                    model.login = yield this.login.decrypt(this.organizationId, bypassValidation, encKey);
                    break;
                case CipherType.SecureNote:
                    model.secureNote = yield this.secureNote.decrypt(this.organizationId, encKey);
                    break;
                case CipherType.Card:
                    model.card = yield this.card.decrypt(this.organizationId, encKey);
                    break;
                case CipherType.Identity:
                    model.identity = yield this.identity.decrypt(this.organizationId, encKey);
                    break;
                default:
                    break;
            }
            if (this.attachments != null && this.attachments.length > 0) {
                const attachments = [];
                yield this.attachments.reduce((promise, attachment) => {
                    return promise
                        .then(() => {
                        return attachment.decrypt(this.organizationId, encKey);
                    })
                        .then((decAttachment) => {
                        attachments.push(decAttachment);
                    });
                }, Promise.resolve());
                model.attachments = attachments;
            }
            if (this.fields != null && this.fields.length > 0) {
                const fields = [];
                yield this.fields.reduce((promise, field) => {
                    return promise
                        .then(() => {
                        return field.decrypt(this.organizationId, encKey);
                    })
                        .then((decField) => {
                        fields.push(decField);
                    });
                }, Promise.resolve());
                model.fields = fields;
            }
            if (this.passwordHistory != null && this.passwordHistory.length > 0) {
                const passwordHistory = [];
                yield this.passwordHistory.reduce((promise, ph) => {
                    return promise
                        .then(() => {
                        return ph.decrypt(this.organizationId, encKey);
                    })
                        .then((decPh) => {
                        passwordHistory.push(decPh);
                    });
                }, Promise.resolve());
                model.passwordHistory = passwordHistory;
            }
            return model;
        });
    }
    toCipherData() {
        var _a;
        const c = new CipherData();
        c.id = this.id;
        c.organizationId = this.organizationId;
        c.folderId = this.folderId;
        c.edit = this.edit;
        c.viewPassword = this.viewPassword;
        c.organizationUseTotp = this.organizationUseTotp;
        c.favorite = this.favorite;
        c.revisionDate = this.revisionDate != null ? this.revisionDate.toISOString() : null;
        c.type = this.type;
        c.collectionIds = this.collectionIds;
        c.creationDate = this.creationDate != null ? this.creationDate.toISOString() : null;
        c.deletedDate = this.deletedDate != null ? this.deletedDate.toISOString() : null;
        c.reprompt = this.reprompt;
        c.key = (_a = this.key) === null || _a === void 0 ? void 0 : _a.encryptedString;
        this.buildDataModel(this, c, {
            name: null,
            notes: null,
        });
        switch (c.type) {
            case CipherType.Login:
                c.login = this.login.toLoginData();
                break;
            case CipherType.SecureNote:
                c.secureNote = this.secureNote.toSecureNoteData();
                break;
            case CipherType.Card:
                c.card = this.card.toCardData();
                break;
            case CipherType.Identity:
                c.identity = this.identity.toIdentityData();
                break;
            default:
                break;
        }
        if (this.fields != null) {
            c.fields = this.fields.map((f) => f.toFieldData());
        }
        if (this.attachments != null) {
            c.attachments = this.attachments.map((a) => a.toAttachmentData());
        }
        if (this.passwordHistory != null) {
            c.passwordHistory = this.passwordHistory.map((ph) => ph.toPasswordHistoryData());
        }
        return c;
    }
    static fromJSON(obj) {
        var _a, _b, _c;
        if (obj == null) {
            return null;
        }
        const domain = new Cipher();
        const name = EncString.fromJSON(obj.name);
        const notes = EncString.fromJSON(obj.notes);
        const revisionDate = obj.revisionDate == null ? null : new Date(obj.revisionDate);
        const deletedDate = obj.deletedDate == null ? null : new Date(obj.deletedDate);
        const attachments = (_a = obj.attachments) === null || _a === void 0 ? void 0 : _a.map((a) => Attachment.fromJSON(a));
        const fields = (_b = obj.fields) === null || _b === void 0 ? void 0 : _b.map((f) => Field.fromJSON(f));
        const passwordHistory = (_c = obj.passwordHistory) === null || _c === void 0 ? void 0 : _c.map((ph) => Password.fromJSON(ph));
        const key = EncString.fromJSON(obj.key);
        Object.assign(domain, obj, {
            name,
            notes,
            revisionDate,
            deletedDate,
            attachments,
            fields,
            passwordHistory,
            key,
        });
        switch (obj.type) {
            case CipherType.Card:
                domain.card = Card.fromJSON(obj.card);
                break;
            case CipherType.Identity:
                domain.identity = Identity.fromJSON(obj.identity);
                break;
            case CipherType.Login:
                domain.login = Login.fromJSON(obj.login);
                break;
            case CipherType.SecureNote:
                domain.secureNote = SecureNote.fromJSON(obj.secureNote);
                break;
            default:
                break;
        }
        return domain;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/domain/sorted-ciphers-cache.ts
const CacheTTL = 3000;
class SortedCiphersCache {
    constructor(comparator) {
        this.comparator = comparator;
        this.sortedCiphersByUrl = new Map();
        this.timeouts = new Map();
    }
    isCached(url) {
        return this.sortedCiphersByUrl.has(url);
    }
    addCiphers(url, ciphers) {
        ciphers.sort(this.comparator);
        this.sortedCiphersByUrl.set(url, new Ciphers(ciphers));
        this.resetTimer(url);
    }
    getLastUsed(url) {
        this.resetTimer(url);
        return this.isCached(url) ? this.sortedCiphersByUrl.get(url).getLastUsed() : null;
    }
    getLastLaunched(url) {
        return this.isCached(url) ? this.sortedCiphersByUrl.get(url).getLastLaunched() : null;
    }
    getNext(url) {
        this.resetTimer(url);
        return this.isCached(url) ? this.sortedCiphersByUrl.get(url).getNext() : null;
    }
    updateLastUsedIndex(url) {
        if (this.isCached(url)) {
            this.sortedCiphersByUrl.get(url).updateLastUsedIndex();
        }
    }
    clear() {
        this.sortedCiphersByUrl.clear();
        this.timeouts.clear();
    }
    resetTimer(url) {
        clearTimeout(this.timeouts.get(url));
        this.timeouts.set(url, setTimeout(() => {
            this.sortedCiphersByUrl.delete(url);
            this.timeouts.delete(url);
        }, CacheTTL));
    }
}
class Ciphers {
    constructor(ciphers) {
        this.ciphers = ciphers;
        this.lastUsedIndex = -1;
    }
    getLastUsed() {
        this.lastUsedIndex = Math.max(this.lastUsedIndex, 0);
        return this.ciphers[this.lastUsedIndex];
    }
    getLastLaunched() {
        const usedCiphers = this.ciphers.filter((cipher) => { var _a; return (_a = cipher.localData) === null || _a === void 0 ? void 0 : _a.lastLaunched; });
        const sortedCiphers = usedCiphers.sort((x, y) => y.localData.lastLaunched.valueOf() - x.localData.lastLaunched.valueOf());
        return sortedCiphers[0];
    }
    getNextIndex() {
        return (this.lastUsedIndex + 1) % this.ciphers.length;
    }
    getNext() {
        return this.ciphers[this.getNextIndex()];
    }
    updateLastUsedIndex() {
        this.lastUsedIndex = this.getNextIndex();
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/cipher-bulk-delete.request.ts
class CipherBulkDeleteRequest {
    constructor(ids, organizationId) {
        this.ids = ids == null ? [] : ids;
        this.organizationId = organizationId;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/cipher-bulk-move.request.ts
class CipherBulkMoveRequest {
    constructor(ids, folderId) {
        this.ids = ids == null ? [] : ids;
        this.folderId = folderId;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/cipher-bulk-restore.request.ts
class CipherBulkRestoreRequest {
    constructor(ids, organizationId) {
        this.ids = ids == null ? [] : ids;
        this.organizationId = organizationId;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/api/card.api.ts

class CardApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.cardholderName = this.getResponseProperty("CardholderName");
        this.brand = this.getResponseProperty("Brand");
        this.number = this.getResponseProperty("Number");
        this.expMonth = this.getResponseProperty("ExpMonth");
        this.expYear = this.getResponseProperty("ExpYear");
        this.code = this.getResponseProperty("Code");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/api/fido2-credential.api.ts

class Fido2CredentialApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.credentialId = this.getResponseProperty("CredentialId");
        this.keyType = this.getResponseProperty("KeyType");
        this.keyAlgorithm = this.getResponseProperty("KeyAlgorithm");
        this.keyCurve = this.getResponseProperty("KeyCurve");
        this.keyValue = this.getResponseProperty("keyValue");
        this.rpId = this.getResponseProperty("RpId");
        this.userHandle = this.getResponseProperty("UserHandle");
        this.userName = this.getResponseProperty("UserName");
        this.counter = this.getResponseProperty("Counter");
        this.rpName = this.getResponseProperty("RpName");
        this.userDisplayName = this.getResponseProperty("UserDisplayName");
        this.discoverable = this.getResponseProperty("Discoverable");
        this.creationDate = this.getResponseProperty("CreationDate");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/api/field.api.ts

class FieldApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.type = this.getResponseProperty("Type");
        this.name = this.getResponseProperty("Name");
        this.value = this.getResponseProperty("Value");
        this.linkedId = this.getResponseProperty("linkedId");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/api/identity.api.ts

class IdentityApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.title = this.getResponseProperty("Title");
        this.firstName = this.getResponseProperty("FirstName");
        this.middleName = this.getResponseProperty("MiddleName");
        this.lastName = this.getResponseProperty("LastName");
        this.address1 = this.getResponseProperty("Address1");
        this.address2 = this.getResponseProperty("Address2");
        this.address3 = this.getResponseProperty("Address3");
        this.city = this.getResponseProperty("City");
        this.state = this.getResponseProperty("State");
        this.postalCode = this.getResponseProperty("PostalCode");
        this.country = this.getResponseProperty("Country");
        this.company = this.getResponseProperty("Company");
        this.email = this.getResponseProperty("Email");
        this.phone = this.getResponseProperty("Phone");
        this.ssn = this.getResponseProperty("SSN");
        this.username = this.getResponseProperty("Username");
        this.passportNumber = this.getResponseProperty("PassportNumber");
        this.licenseNumber = this.getResponseProperty("LicenseNumber");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/api/login-uri.api.ts

class LoginUriApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        this.match = null;
        if (data == null) {
            return;
        }
        this.uri = this.getResponseProperty("Uri");
        this.uriChecksum = this.getResponseProperty("UriChecksum");
        const match = this.getResponseProperty("Match");
        this.match = match != null ? match : null;
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/api/login.api.ts



class LoginApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.username = this.getResponseProperty("Username");
        this.password = this.getResponseProperty("Password");
        this.passwordRevisionDate = this.getResponseProperty("PasswordRevisionDate");
        this.totp = this.getResponseProperty("Totp");
        this.autofillOnPageLoad = this.getResponseProperty("AutofillOnPageLoad");
        const uris = this.getResponseProperty("Uris");
        if (uris != null) {
            this.uris = uris.map((u) => new LoginUriApi(u));
        }
        const fido2Credentials = this.getResponseProperty("Fido2Credentials");
        if (fido2Credentials != null) {
            this.fido2Credentials = fido2Credentials.map((key) => new Fido2CredentialApi(key));
        }
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/api/secure-note.api.ts

class SecureNoteApi extends BaseResponse {
    constructor(data = null) {
        super(data);
        if (data == null) {
            return;
        }
        this.type = this.getResponseProperty("Type");
    }
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/attachment.request.ts
class AttachmentRequest {
}

;// CONCATENATED MODULE: ../../libs/common/src/vault/models/request/cipher.request.ts









class CipherRequest {
    constructor(cipher) {
        var _a, _b, _c;
        this.type = cipher.type;
        this.folderId = cipher.folderId;
        this.organizationId = cipher.organizationId;
        this.name = cipher.name ? cipher.name.encryptedString : null;
        this.notes = cipher.notes ? cipher.notes.encryptedString : null;
        this.favorite = cipher.favorite;
        this.lastKnownRevisionDate = cipher.revisionDate;
        this.reprompt = cipher.reprompt;
        this.key = (_a = cipher.key) === null || _a === void 0 ? void 0 : _a.encryptedString;
        switch (this.type) {
            case CipherType.Login:
                this.login = new LoginApi();
                this.login.uris =
                    (_c = (_b = cipher.login.uris) === null || _b === void 0 ? void 0 : _b.map((u) => {
                        const uri = new LoginUriApi();
                        uri.uri = u.uri != null ? u.uri.encryptedString : null;
                        uri.match = u.match != null ? u.match : null;
                        uri.uriChecksum = u.uriChecksum != null ? u.uriChecksum.encryptedString : null;
                        return uri;
                    })) !== null && _c !== void 0 ? _c : [];
                this.login.username = cipher.login.username ? cipher.login.username.encryptedString : null;
                this.login.password = cipher.login.password ? cipher.login.password.encryptedString : null;
                this.login.passwordRevisionDate =
                    cipher.login.passwordRevisionDate != null
                        ? cipher.login.passwordRevisionDate.toISOString()
                        : null;
                this.login.totp = cipher.login.totp ? cipher.login.totp.encryptedString : null;
                this.login.autofillOnPageLoad = cipher.login.autofillOnPageLoad;
                if (cipher.login.fido2Credentials != null) {
                    this.login.fido2Credentials = cipher.login.fido2Credentials.map((key) => {
                        const keyApi = new Fido2CredentialApi();
                        keyApi.credentialId =
                            key.credentialId != null ? key.credentialId.encryptedString : null;
                        keyApi.keyType =
                            key.keyType != null ? key.keyType.encryptedString : null;
                        keyApi.keyAlgorithm =
                            key.keyAlgorithm != null ? key.keyAlgorithm.encryptedString : null;
                        keyApi.keyCurve =
                            key.keyCurve != null ? key.keyCurve.encryptedString : null;
                        keyApi.keyValue = key.keyValue != null ? key.keyValue.encryptedString : null;
                        keyApi.rpId = key.rpId != null ? key.rpId.encryptedString : null;
                        keyApi.rpName = key.rpName != null ? key.rpName.encryptedString : null;
                        keyApi.counter = key.counter != null ? key.counter.encryptedString : null;
                        keyApi.userHandle = key.userHandle != null ? key.userHandle.encryptedString : null;
                        keyApi.userName = key.userName != null ? key.userName.encrypted