/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (c) 2012 Samsung Electronics Co., Ltd
 *              http://www.samsung.com
 */

#ifndef __LINUX_MFD_SEC_IRQ_H
#define __LINUX_MFD_SEC_IRQ_H

enum s2mpa01_irq {
	S2MPA01_IRQ_PWRONF,
	S2MPA01_IRQ_PWRONR,
	S2MPA01_IRQ_JIGONBF,
	S2MPA01_IRQ_JIGONBR,
	S2MPA01_IRQ_ACOKBF,
	S2MPA01_IRQ_ACOKBR,
	S2MPA01_IRQ_PWRON1S,
	S2MPA01_IRQ_MRB,

	S2MPA01_IRQ_RTC60S,
	S2MPA01_IRQ_RTCA1,
	S2MPA01_IRQ_RTCA0,
	S2MPA01_IRQ_SMPL,
	S2MPA01_IRQ_RTC1S,
	S2MPA01_IRQ_WTSR,

	S2MPA01_IRQ_INT120C,
	S2MPA01_IRQ_INT140C,
	S2MPA01_IRQ_LDO3_TSD,
	S2MPA01_IRQ_B16_TSD,
	S2MPA01_IRQ_B24_TSD,
	S2MPA01_IRQ_B35_TSD,

	S2MPA01_IRQ_NR,
};

#define S2MPA01_IRQ_PWRONF_MASK		(1 << 0)
#define S2MPA01_IRQ_PWRONR_MASK		(1 << 1)
#define S2MPA01_IRQ_JIGONBF_MASK	(1 << 2)
#define S2MPA01_IRQ_JIGONBR_MASK	(1 << 3)
#define S2MPA01_IRQ_ACOKBF_MASK		(1 << 4)
#define S2MPA01_IRQ_ACOKBR_MASK		(1 << 5)
#define S2MPA01_IRQ_PWRON1S_MASK	(1 << 6)
#define S2MPA01_IRQ_MRB_MASK		(1 << 7)

#define S2MPA01_IRQ_RTC60S_MASK		(1 << 0)
#define S2MPA01_IRQ_RTCA1_MASK		(1 << 1)
#define S2MPA01_IRQ_RTCA0_MASK		(1 << 2)
#define S2MPA01_IRQ_SMPL_MASK		(1 << 3)
#define S2MPA01_IRQ_RTC1S_MASK		(1 << 4)
#define S2MPA01_IRQ_WTSR_MASK		(1 << 5)

#define S2MPA01_IRQ_INT120C_MASK	(1 << 0)
#define S2MPA01_IRQ_INT140C_MASK	(1 << 1)
#define S2MPA01_IRQ_LDO3_TSD_MASK	(1 << 2)
#define S2MPA01_IRQ_B16_TSD_MASK	(1 << 3)
#define S2MPA01_IRQ_B24_TSD_MASK	(1 << 4)
#define S2MPA01_IRQ_B35_TSD_MASK	(1 << 5)

enum s2mpg10_common_irq {
	/* Top-level (common) block */
	S2MPG10_COMMON_IRQ_PMIC,
	S2MPG10_COMMON_IRQ_UNUSED,
};

enum s2mpg10_irq {
	/* PMIC */
	S2MPG10_IRQ_PWRONF,
	S2MPG10_IRQ_PWRONR,
	S2MPG10_IRQ_JIGONBF,
	S2MPG10_IRQ_JIGONBR,
	S2MPG10_IRQ_ACOKBF,
	S2MPG10_IRQ_ACOKBR,
	S2MPG10_IRQ_PWRON1S,
	S2MPG10_IRQ_MRB,
#define S2MPG10_IRQ_PWRONF_MASK		BIT(0)
#define S2MPG10_IRQ_PWRONR_MASK		BIT(1)
#define S2MPG10_IRQ_JIGONBF_MASK	BIT(2)
#define S2MPG10_IRQ_JIGONBR_MASK	BIT(3)
#define S2MPG10_IRQ_ACOKBF_MASK		BIT(4)
#define S2MPG10_IRQ_ACOKBR_MASK		BIT(5)
#define S2MPG10_IRQ_PWRON1S_MASK	BIT(6)
#define S2MPG10_IRQ_MRB_MASK		BIT(7)

	S2MPG10_IRQ_RTC60S,
	S2MPG10_IRQ_RTCA1,
	S2MPG10_IRQ_RTCA0,
	S2MPG10_IRQ_RTC1S,
	S2MPG10_IRQ_WTSR_COLDRST,
	S2MPG10_IRQ_WTSR,
	S2MPG10_IRQ_WRST,
	S2MPG10_IRQ_SMPL,
#define S2MPG10_IRQ_RTC60S_MASK		BIT(0)
#define S2MPG10_IRQ_RTCA1_MASK		BIT(1)
#define S2MPG10_IRQ_RTCA0_MASK		BIT(2)
#define S2MPG10_IRQ_RTC1S_MASK		BIT(3)
#define S2MPG10_IRQ_WTSR_COLDRST_MASK	BIT(4)
#define S2MPG10_IRQ_WTSR_MASK		BIT(5)
#define S2MPG10_IRQ_WRST_MASK		BIT(6)
#define S2MPG10_IRQ_SMPL_MASK		BIT(7)

	S2MPG10_IRQ_120C,
	S2MPG10_IRQ_140C,
	S2MPG10_IRQ_TSD,
	S2MPG10_IRQ_PIF_TIMEOUT1,
	S2MPG10_IRQ_PIF_TIMEOUT2,
	S2MPG10_IRQ_SPD_PARITY_ERR,
	S2MPG10_IRQ_SPD_ABNORMAL_STOP,
	S2MPG10_IRQ_PMETER_OVERF,
#define S2MPG10_IRQ_INT120C_MASK		BIT(0)
#define S2MPG10_IRQ_INT140C_MASK		BIT(1)
#define S2MPG10_IRQ_TSD_MASK			BIT(2)
#define S2MPG10_IRQ_PIF_TIMEOUT1_MASK		BIT(3)
#define S2MPG10_IRQ_PIF_TIMEOUT2_MASK		BIT(4)
#define S2MPG10_IRQ_SPD_PARITY_ERR_MASK		BIT(5)
#define S2MPG10_IRQ_SPD_ABNORMAL_STOP_MASK	BIT(6)
#define S2MPG10_IRQ_PMETER_OVERF_MASK		BIT(7)

	S2MPG10_IRQ_OCP_B1M,
	S2MPG10_IRQ_OCP_B2M,
	S2MPG10_IRQ_OCP_B3M,
	S2MPG10_IRQ_OCP_B4M,
	S2MPG10_IRQ_OCP_B5M,
	S2MPG10_IRQ_OCP_B6M,
	S2MPG10_IRQ_OCP_B7M,
	S2MPG10_IRQ_OCP_B8M,
#define S2MPG10_IRQ_OCP_B1M_MASK	BIT(0)
#define S2MPG10_IRQ_OCP_B2M_MASK	BIT(1)
#define S2MPG10_IRQ_OCP_B3M_MASK	BIT(2)
#define S2MPG10_IRQ_OCP_B4M_MASK	BIT(3)
#define S2MPG10_IRQ_OCP_B5M_MASK	BIT(4)
#define S2MPG10_IRQ_OCP_B6M_MASK	BIT(5)
#define S2MPG10_IRQ_OCP_B7M_MASK	BIT(6)
#define S2MPG10_IRQ_OCP_B8M_MASK	BIT(7)

	S2MPG10_IRQ_OCP_B9M,
	S2MPG10_IRQ_OCP_B10M,
	S2MPG10_IRQ_WLWP_ACC,
	S2MPG10_IRQ_SMPL_TIMEOUT,
	S2MPG10_IRQ_WTSR_TIMEOUT,
	S2MPG10_IRQ_SPD_SRP_PKT_RST,
#define S2MPG10_IRQ_OCP_B9M_MASK		BIT(0)
#define S2MPG10_IRQ_OCP_B10M_MASK		BIT(1)
#define S2MPG10_IRQ_WLWP_ACC_MASK		BIT(2)
#define S2MPG10_IRQ_SMPL_TIMEOUT_MASK		BIT(5)
#define S2MPG10_IRQ_WTSR_TIMEOUT_MASK		BIT(6)
#define S2MPG10_IRQ_SPD_SRP_PKT_RST_MASK	BIT(7)

	S2MPG10_IRQ_PWR_WARN_CH0,
	S2MPG10_IRQ_PWR_WARN_CH1,
	S2MPG10_IRQ_PWR_WARN_CH2,
	S2MPG10_IRQ_PWR_WARN_CH3,
	S2MPG10_IRQ_PWR_WARN_CH4,
	S2MPG10_IRQ_PWR_WARN_CH5,
	S2MPG10_IRQ_PWR_WARN_CH6,
	S2MPG10_IRQ_PWR_WARN_CH7,
#define S2MPG10_IRQ_PWR_WARN_CH0_MASK	BIT(0)
#define S2MPG10_IRQ_PWR_WARN_CH1_MASK	BIT(1)
#define S2MPG10_IRQ_PWR_WARN_CH2_MASK	BIT(2)
#define S2MPG10_IRQ_PWR_WARN_CH3_MASK	BIT(3)
#define S2MPG10_IRQ_PWR_WARN_CH4_MASK	BIT(4)
#define S2MPG10_IRQ_PWR_WARN_CH5_MASK	BIT(5)
#define S2MPG10_IRQ_PWR_WARN_CH6_MASK	BIT(6)
#define S2MPG10_IRQ_PWR_WARN_CH7_MASK	BIT(7)

	S2MPG10_IRQ_NR,
};

enum s2mpg11_common_irq {
	/* Top-level (common) block */
	S2MPG11_COMMON_IRQ_PMIC,
	S2MPG11_COMMON_IRQ_UNUSED,
};

enum s2mpg11_irq {
	/* PMIC */
	S2MPG11_IRQ_PWRONF,
	S2MPG11_IRQ_PWRONR,
	S2MPG11_IRQ_PIF_TIMEOUT_MIF,
	S2MPG11_IRQ_PIF_TIMEOUTS,
	S2MPG11_IRQ_WTSR,
	S2MPG11_IRQ_SPD_ABNORMAL_STOP,
	S2MPG11_IRQ_SPD_PARITY_ERR,
#define S2MPG11_IRQ_PWRONF_MASK			BIT(0)
#define S2MPG11_IRQ_PWRONR_MASK			BIT(1)
#define S2MPG11_IRQ_PIF_TIMEOUT_MIF_MASK	BIT(3)
#define S2MPG11_IRQ_PIF_TIMEOUTS_MASK		BIT(4)
#define S2MPG11_IRQ_WTSR_MASK			BIT(5)
#define S2MPG11_IRQ_SPD_ABNORMAL_STOP_MASK	BIT(6)
#define S2MPG11_IRQ_SPD_PARITY_ERR_MASK		BIT(7)

	S2MPG11_IRQ_140C,
	S2MPG11_IRQ_120C,
	S2MPG11_IRQ_TSD,
	S2MPG11_IRQ_WRST,
	S2MPG11_IRQ_NTC_CYCLE_DONE,
	S2MPG11_IRQ_PMETER_OVERF,
#define S2MPG11_IRQ_INT140C_MASK	BIT(0)
#define S2MPG11_IRQ_INT120C_MASK	BIT(1)
#define S2MPG11_IRQ_TSD_MASK		BIT(2)
#define S2MPG11_IRQ_WRST_MASK		BIT(5)
#define S2MPG11_IRQ_NTC_CYCLE_DONE_MASK	BIT(6)
#define S2MPG11_IRQ_PMETER_OVERF_MASK	BIT(7)

	S2MPG11_IRQ_OCP_B1S,
	S2MPG11_IRQ_OCP_B2S,
	S2MPG11_IRQ_OCP_B3S,
	S2MPG11_IRQ_OCP_B4S,
	S2MPG11_IRQ_OCP_B5S,
	S2MPG11_IRQ_OCP_B6S,
	S2MPG11_IRQ_OCP_B7S,
	S2MPG11_IRQ_OCP_B8S,
#define S2MPG11_IRQ_OCP_B1S_MASK	BIT(0)
#define S2MPG11_IRQ_OCP_B2S_MASK	BIT(1)
#define S2MPG11_IRQ_OCP_B3S_MASK	BIT(2)
#define S2MPG11_IRQ_OCP_B4S_MASK	BIT(3)
#define S2MPG11_IRQ_OCP_B5S_MASK	BIT(4)
#define S2MPG11_IRQ_OCP_B6S_MASK	BIT(5)
#define S2MPG11_IRQ_OCP_B7S_MASK	BIT(6)
#define S2MPG11_IRQ_OCP_B8S_MASK	BIT(7)

	S2MPG11_IRQ_OCP_B9S,
	S2MPG11_IRQ_OCP_B10S,
	S2MPG11_IRQ_OCP_BDS,
	S2MPG11_IRQ_OCP_BAS,
	S2MPG11_IRQ_OCP_BBS,
	S2MPG11_IRQ_WLWP_ACC,
	S2MPG11_IRQ_SPD_SRP_PKT_RST,
#define S2MPG11_IRQ_OCP_B9S_MASK		BIT(0)
#define S2MPG11_IRQ_OCP_B10S_MASK		BIT(1)
#define S2MPG11_IRQ_OCP_BDS_MASK		BIT(2)
#define S2MPG11_IRQ_OCP_BAS_MASK		BIT(3)
#define S2MPG11_IRQ_OCP_BBS_MASK		BIT(4)
#define S2MPG11_IRQ_WLWP_ACC_MASK		BIT(5)
#define S2MPG11_IRQ_SPD_SRP_PKT_RST_MASK	BIT(7)

	S2MPG11_IRQ_PWR_WARN_CH0,
	S2MPG11_IRQ_PWR_WARN_CH1,
	S2MPG11_IRQ_PWR_WARN_CH2,
	S2MPG11_IRQ_PWR_WARN_CH3,
	S2MPG11_IRQ_PWR_WARN_CH4,
	S2MPG11_IRQ_PWR_WARN_CH5,
	S2MPG11_IRQ_PWR_WARN_CH6,
	S2MPG11_IRQ_PWR_WARN_CH7,
#define S2MPG11_IRQ_PWR_WARN_CH0_MASK	BIT(0)
#define S2MPG11_IRQ_PWR_WARN_CH1_MASK	BIT(1)
#define S2MPG11_IRQ_PWR_WARN_CH2_MASK	BIT(2)
#define S2MPG11_IRQ_PWR_WARN_CH3_MASK	BIT(3)
#define S2MPG11_IRQ_PWR_WARN_CH4_MASK	BIT(4)
#define S2MPG11_IRQ_PWR_WARN_CH5_MASK	BIT(5)
#define S2MPG11_IRQ_PWR_WARN_CH6_MASK	BIT(6)
#define S2MPG11_IRQ_PWR_WARN_CH7_MASK	BIT(7)

	S2MPG11_IRQ_NTC_WARN_CH0,
	S2MPG11_IRQ_NTC_WARN_CH1,
	S2MPG11_IRQ_NTC_WARN_CH2,
	S2MPG11_IRQ_NTC_WARN_CH3,
	S2MPG11_IRQ_NTC_WARN_CH4,
	S2MPG11_IRQ_NTC_WARN_CH5,
	S2MPG11_IRQ_NTC_WARN_CH6,
	S2MPG11_IRQ_NTC_WARN_CH7,
#define S2MPG11_IRQ_NTC_WARN_CH0_MASK	BIT(0)
#define S2MPG11_IRQ_NTC_WARN_CH1_MASK	BIT(1)
#define S2MPG11_IRQ_NTC_WARN_CH2_MASK	BIT(2)
#define S2MPG11_IRQ_NTC_WARN_CH3_MASK	BIT(3)
#define S2MPG11_IRQ_NTC_WARN_CH4_MASK	BIT(4)
#define S2MPG11_IRQ_NTC_WARN_CH5_MASK	BIT(5)
#define S2MPG11_IRQ_NTC_WARN_CH6_MASK	BIT(6)
#define S2MPG11_IRQ_NTC_WARN_CH7_MASK	BIT(7)

	S2MPG11_IRQ_NR,
};

enum s2mps11_irq {
	S2MPS11_IRQ_PWRONF,
	S2MPS11_IRQ_PWRONR,
	S2MPS11_IRQ_JIGONBF,
	S2MPS11_IRQ_JIGONBR,
	S2MPS11_IRQ_ACOKBF,
	S2MPS11_IRQ_ACOKBR,
	S2MPS11_IRQ_PWRON1S,
	S2MPS11_IRQ_MRB,

	S2MPS11_IRQ_RTC60S,
	S2MPS11_IRQ_RTCA1,
	S2MPS11_IRQ_RTCA0,
	S2MPS11_IRQ_SMPL,
	S2MPS11_IRQ_RTC1S,
	S2MPS11_IRQ_WTSR,

	S2MPS11_IRQ_INT120C,
	S2MPS11_IRQ_INT140C,

	S2MPS11_IRQ_NR,
};

#define S2MPS11_IRQ_PWRONF_MASK		(1 << 0)
#define S2MPS11_IRQ_PWRONR_MASK		(1 << 1)
#define S2MPS11_IRQ_JIGONBF_MASK	(1 << 2)
#define S2MPS11_IRQ_JIGONBR_MASK	(1 << 3)
#define S2MPS11_IRQ_ACOKBF_MASK		(1 << 4)
#define S2MPS11_IRQ_ACOKBR_MASK		(1 << 5)
#define S2MPS11_IRQ_PWRON1S_MASK	(1 << 6)
#define S2MPS11_IRQ_MRB_MASK		(1 << 7)

#define S2MPS11_IRQ_RTC60S_MASK		(1 << 0)
#define S2MPS11_IRQ_RTCA1_MASK		(1 << 1)
#define S2MPS11_IRQ_RTCA0_MASK		(1 << 2)
#define S2MPS11_IRQ_SMPL_MASK		(1 << 3)
#define S2MPS11_IRQ_RTC1S_MASK		(1 << 4)
#define S2MPS11_IRQ_WTSR_MASK		(1 << 5)

#define S2MPS11_IRQ_INT120C_MASK	(1 << 0)
#define S2MPS11_IRQ_INT140C_MASK	(1 << 1)

enum s2mps14_irq {
	S2MPS14_IRQ_PWRONF,
	S2MPS14_IRQ_PWRONR,
	S2MPS14_IRQ_JIGONBF,
	S2MPS14_IRQ_JIGONBR,
	S2MPS14_IRQ_ACOKBF,
	S2MPS14_IRQ_ACOKBR,
	S2MPS14_IRQ_PWRON1S,
	S2MPS14_IRQ_MRB,

	S2MPS14_IRQ_RTC60S,
	S2MPS14_IRQ_RTCA1,
	S2MPS14_IRQ_RTCA0,
	S2MPS14_IRQ_SMPL,
	S2MPS14_IRQ_RTC1S,
	S2MPS14_IRQ_WTSR,

	S2MPS14_IRQ_INT120C,
	S2MPS14_IRQ_INT140C,
	S2MPS14_IRQ_TSD,

	S2MPS14_IRQ_NR,
};

enum s2mpu02_irq {
	S2MPU02_IRQ_PWRONF,
	S2MPU02_IRQ_PWRONR,
	S2MPU02_IRQ_JIGONBF,
	S2MPU02_IRQ_JIGONBR,
	S2MPU02_IRQ_ACOKBF,
	S2MPU02_IRQ_ACOKBR,
	S2MPU02_IRQ_PWRON1S,
	S2MPU02_IRQ_MRB,

	S2MPU02_IRQ_RTC60S,
	S2MPU02_IRQ_RTCA1,
	S2MPU02_IRQ_RTCA0,
	S2MPU02_IRQ_SMPL,
	S2MPU02_IRQ_RTC1S,
	S2MPU02_IRQ_WTSR,

	S2MPU02_IRQ_INT120C,
	S2MPU02_IRQ_INT140C,
	S2MPU02_IRQ_TSD,

	S2MPU02_IRQ_NR,
};

/* Masks for interrupts are the same as in s2mps11 */
#define S2MPS14_IRQ_TSD_MASK		(1 << 2)

enum s2mpu05_irq {
	S2MPU05_IRQ_PWRONF,
	S2MPU05_IRQ_PWRONR,
	S2MPU05_IRQ_JIGONBF,
	S2MPU05_IRQ_JIGONBR,
	S2MPU05_IRQ_ACOKF,
	S2MPU05_IRQ_ACOKR,
	S2MPU05_IRQ_PWRON1S,
	S2MPU05_IRQ_MRB,

	S2MPU05_IRQ_RTC60S,
	S2MPU05_IRQ_RTCA1,
	S2MPU05_IRQ_RTCA0,
	S2MPU05_IRQ_SMPL,
	S2MPU05_IRQ_RTC1S,
	S2MPU05_IRQ_WTSR,

	S2MPU05_IRQ_INT120C,
	S2MPU05_IRQ_INT140C,
	S2MPU05_IRQ_TSD,

	S2MPU05_IRQ_NR,
};

#define S2MPU05_IRQ_PWRONF_MASK		BIT(0)
#define S2MPU05_IRQ_PWRONR_MASK		BIT(1)
#define S2MPU05_IRQ_JIGONBF_MASK	BIT(2)
#define S2MPU05_IRQ_JIGONBR_MASK	BIT(3)
#define S2MPU05_IRQ_ACOKF_MASK		BIT(4)
#define S2MPU05_IRQ_ACOKR_MASK		BIT(5)
#define S2MPU05_IRQ_PWRON1S_MASK	BIT(6)
#define S2MPU05_IRQ_MRB_MASK		BIT(7)

#define S2MPU05_IRQ_RTC60S_MASK		BIT(0)
#define S2MPU05_IRQ_RTCA1_MASK		BIT(1)
#define S2MPU05_IRQ_RTCA0_MASK		BIT(2)
#define S2MPU05_IRQ_SMPL_MASK		BIT(3)
#define S2MPU05_IRQ_RTC1S_MASK		BIT(4)
#define S2MPU05_IRQ_WTSR_MASK		BIT(5)

#define S2MPU05_IRQ_INT120C_MASK	BIT(0)
#define S2MPU05_IRQ_INT140C_MASK	BIT(1)
#define S2MPU05_IRQ_TSD_MASK		BIT(2)

enum s5m8767_irq {
	S5M8767_IRQ_PWRR,
	S5M8767_IRQ_PWRF,
	S5M8767_IRQ_PWR1S,
	S5M8767_IRQ_JIGR,
	S5M8767_IRQ_JIGF,
	S5M8767_IRQ_LOWBAT2,
	S5M8767_IRQ_LOWBAT1,

	S5M8767_IRQ_MRB,
	S5M8767_IRQ_DVSOK2,
	S5M8767_IRQ_DVSOK3,
	S5M8767_IRQ_DVSOK4,

	S5M8767_IRQ_RTC60S,
	S5M8767_IRQ_RTCA1,
	S5M8767_IRQ_RTCA2,
	S5M8767_IRQ_SMPL,
	S5M8767_IRQ_RTC1S,
	S5M8767_IRQ_WTSR,

	S5M8767_IRQ_NR,
};

#define S5M8767_IRQ_PWRR_MASK		(1 << 0)
#define S5M8767_IRQ_PWRF_MASK		(1 << 1)
#define S5M8767_IRQ_PWR1S_MASK		(1 << 3)
#define S5M8767_IRQ_JIGR_MASK		(1 << 4)
#define S5M8767_IRQ_JIGF_MASK		(1 << 5)
#define S5M8767_IRQ_LOWBAT2_MASK	(1 << 6)
#define S5M8767_IRQ_LOWBAT1_MASK	(1 << 7)

#define S5M8767_IRQ_MRB_MASK		(1 << 2)
#define S5M8767_IRQ_DVSOK2_MASK		(1 << 3)
#define S5M8767_IRQ_DVSOK3_MASK		(1 << 4)
#define S5M8767_IRQ_DVSOK4_MASK		(1 << 5)

#define S5M8767_IRQ_RTC60S_MASK		(1 << 0)
#define S5M8767_IRQ_RTCA1_MASK		(1 << 1)
#define S5M8767_IRQ_RTCA2_MASK		(1 << 2)
#define S5M8767_IRQ_SMPL_MASK		(1 << 3)
#define S5M8767_IRQ_RTC1S_MASK		(1 << 4)
#define S5M8767_IRQ_WTSR_MASK		(1 << 5)

#endif /*  __LINUX_MFD_SEC_IRQ_H */
