"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Overlay = exports.OverlayBackground = exports.overlayBackgroundStyle = exports.OverlayContent = exports.OverlayWrapper = exports.overlayWrapperStyle = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const Identity_1 = require("../Identity");
const motions_1 = require("../Identity/motions");
const mediaQueries_1 = require("../mediaQueries");
const util_1 = require("../util");
const overlayWrapperStyle = () => ({
    bottom: 0,
    display: 'flex',
    left: 0,
    overflowY: 'auto',
    padding: '24px',
    position: 'fixed',
    right: 0,
    top: 0,
    zIndex: 9997,
});
exports.overlayWrapperStyle = overlayWrapperStyle;
const OverlayWrapper = (props) => (0, jsx_runtime_1.jsx)("div", Object.assign({ css: exports.overlayWrapperStyle }, props));
exports.OverlayWrapper = OverlayWrapper;
const OverlayContent = (props) => ((0, jsx_runtime_1.jsx)("div", Object.assign({ css: {
        '*': {
            color: Identity_1.COLOR.WHITE,
        },
        alignItems: 'center',
        display: 'flex',
        flexDirection: 'column',
        justifyContent: 'space-between',
        margin: 'auto',
        maxWidth: '100%',
        overflowY: 'auto',
        position: 'relative',
        transform: 'translate3d(0, 0, 0)',
        zIndex: 9999,
        [mediaQueries_1.media[mediaQueries_1.QueryKeys.TABLET_DOWN]]: {
            width: '100%',
        },
    } }, props)));
exports.OverlayContent = OverlayContent;
const overlayBackgroundStyle = () => ({
    animation: `${motions_1.ANIMATION.fadeIn} ${motions_1.DURATION.PROACTIVE_SLOW}ms ${motions_1.EASE.QUART}`,
    background: 'rgba(0, 0, 0, 0.88)',
    height: '100vh',
    left: 0,
    position: 'fixed',
    top: 0,
    width: '100vw',
    zIndex: 9998,
});
exports.overlayBackgroundStyle = overlayBackgroundStyle;
const OverlayBackground = (props) => (0, jsx_runtime_1.jsx)("div", Object.assign({ css: exports.overlayBackgroundStyle }, props));
exports.OverlayBackground = OverlayBackground;
const Overlay = (_a) => {
    var { onBackgroundClick = util_1.noop, children = null } = _a, props = __rest(_a, ["onBackgroundClick", "children"]);
    return ((0, jsx_runtime_1.jsxs)(exports.OverlayWrapper, Object.assign({}, props, { "data-uie-name": "modal" }, { children: [(0, jsx_runtime_1.jsx)(exports.OverlayContent, { children: children }), (0, jsx_runtime_1.jsx)(exports.OverlayBackground, { onClick: onBackgroundClick, "data-uie-name": "overlay-background" })] })));
};
exports.Overlay = Overlay;
