# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class InlineObject15(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'display_name': 'str',
        'thumbnailfile': 'file',
        'privacy': 'VideoPlaylistPrivacySet',
        'description': 'str',
        'video_channel_id': 'int'
    }

    attribute_map = {
        'display_name': 'displayName',
        'thumbnailfile': 'thumbnailfile',
        'privacy': 'privacy',
        'description': 'description',
        'video_channel_id': 'videoChannelId'
    }

    def __init__(self, display_name=None, thumbnailfile=None, privacy=None, description=None, video_channel_id=None, local_vars_configuration=None):  # noqa: E501
        """InlineObject15 - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._display_name = None
        self._thumbnailfile = None
        self._privacy = None
        self._description = None
        self._video_channel_id = None
        self.discriminator = None

        if display_name is not None:
            self.display_name = display_name
        if thumbnailfile is not None:
            self.thumbnailfile = thumbnailfile
        if privacy is not None:
            self.privacy = privacy
        if description is not None:
            self.description = description
        if video_channel_id is not None:
            self.video_channel_id = video_channel_id

    @property
    def display_name(self):
        """Gets the display_name of this InlineObject15.  # noqa: E501

        Video playlist display name  # noqa: E501

        :return: The display_name of this InlineObject15.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this InlineObject15.

        Video playlist display name  # noqa: E501

        :param display_name: The display_name of this InlineObject15.  # noqa: E501
        :type display_name: str
        """

        self._display_name = display_name

    @property
    def thumbnailfile(self):
        """Gets the thumbnailfile of this InlineObject15.  # noqa: E501

        Video playlist thumbnail file  # noqa: E501

        :return: The thumbnailfile of this InlineObject15.  # noqa: E501
        :rtype: file
        """
        return self._thumbnailfile

    @thumbnailfile.setter
    def thumbnailfile(self, thumbnailfile):
        """Sets the thumbnailfile of this InlineObject15.

        Video playlist thumbnail file  # noqa: E501

        :param thumbnailfile: The thumbnailfile of this InlineObject15.  # noqa: E501
        :type thumbnailfile: file
        """

        self._thumbnailfile = thumbnailfile

    @property
    def privacy(self):
        """Gets the privacy of this InlineObject15.  # noqa: E501


        :return: The privacy of this InlineObject15.  # noqa: E501
        :rtype: VideoPlaylistPrivacySet
        """
        return self._privacy

    @privacy.setter
    def privacy(self, privacy):
        """Sets the privacy of this InlineObject15.


        :param privacy: The privacy of this InlineObject15.  # noqa: E501
        :type privacy: VideoPlaylistPrivacySet
        """

        self._privacy = privacy

    @property
    def description(self):
        """Gets the description of this InlineObject15.  # noqa: E501

        Video playlist description  # noqa: E501

        :return: The description of this InlineObject15.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this InlineObject15.

        Video playlist description  # noqa: E501

        :param description: The description of this InlineObject15.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def video_channel_id(self):
        """Gets the video_channel_id of this InlineObject15.  # noqa: E501

        Video channel in which the playlist will be published  # noqa: E501

        :return: The video_channel_id of this InlineObject15.  # noqa: E501
        :rtype: int
        """
        return self._video_channel_id

    @video_channel_id.setter
    def video_channel_id(self, video_channel_id):
        """Sets the video_channel_id of this InlineObject15.

        Video channel in which the playlist will be published  # noqa: E501

        :param video_channel_id: The video_channel_id of this InlineObject15.  # noqa: E501
        :type video_channel_id: int
        """

        self._video_channel_id = video_channel_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InlineObject15):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InlineObject15):
            return True

        return self.to_dict() != other.to_dict()
