/* history_dialog.c generated by valac 0.56.18, the Vala compiler
 * generated from history_dialog.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2014-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PAMAC_TYPE_HISTORY_DIALOG (pamac_history_dialog_get_type ())
#define PAMAC_HISTORY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_HISTORY_DIALOG, PamacHistoryDialog))
#define PAMAC_HISTORY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_HISTORY_DIALOG, PamacHistoryDialogClass))
#define PAMAC_IS_HISTORY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_HISTORY_DIALOG))
#define PAMAC_IS_HISTORY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_HISTORY_DIALOG))
#define PAMAC_HISTORY_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_HISTORY_DIALOG, PamacHistoryDialogClass))

typedef struct _PamacHistoryDialog PamacHistoryDialog;
typedef struct _PamacHistoryDialogClass PamacHistoryDialogClass;
typedef struct _PamacHistoryDialogPrivate PamacHistoryDialogPrivate;
enum  {
	PAMAC_HISTORY_DIALOG_0_PROPERTY,
	PAMAC_HISTORY_DIALOG_NUM_PROPERTIES
};
static GParamSpec* pamac_history_dialog_properties[PAMAC_HISTORY_DIALOG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PamacHistoryDialog {
	AdwWindow parent_instance;
	PamacHistoryDialogPrivate * priv;
};

struct _PamacHistoryDialogClass {
	AdwWindowClass parent_class;
};

struct _PamacHistoryDialogPrivate {
	GtkTextView* textview;
	GtkSearchEntry* search_entry;
	GtkTextIter search_start;
};

static gint PamacHistoryDialog_private_offset;
static gpointer pamac_history_dialog_parent_class = NULL;

VALA_EXTERN GType pamac_history_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacHistoryDialog, g_object_unref)
VALA_EXTERN PamacHistoryDialog* pamac_history_dialog_new (GtkApplicationWindow* window);
VALA_EXTERN PamacHistoryDialog* pamac_history_dialog_construct (GType object_type,
                                                    GtkApplicationWindow* window);
static void pamac_history_dialog_set_cursor_at_start (PamacHistoryDialog* self);
static void pamac_history_dialog_on_search_entry_search_changed (PamacHistoryDialog* self);
static void pamac_history_dialog_search_forward (PamacHistoryDialog* self);
static void _pamac_history_dialog_on_search_entry_search_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                           gpointer self);
static void pamac_history_dialog_on_search_entry_next_match (PamacHistoryDialog* self);
static void pamac_history_dialog_on_go_down_button_clicked (PamacHistoryDialog* self);
static void _pamac_history_dialog_on_search_entry_next_match_gtk_search_entry_next_match (GtkSearchEntry* _sender,
                                                                                   gpointer self);
static void pamac_history_dialog_on_search_entry_previous_match (PamacHistoryDialog* self);
static void pamac_history_dialog_on_go_up_button_clicked (PamacHistoryDialog* self);
static void _pamac_history_dialog_on_search_entry_previous_match_gtk_search_entry_previous_match (GtkSearchEntry* _sender,
                                                                                           gpointer self);
static void pamac_history_dialog_search_backward (PamacHistoryDialog* self);
static void _pamac_history_dialog_on_go_up_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _pamac_history_dialog_on_go_down_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self);
static void pamac_history_dialog_scroll_to_cursor (PamacHistoryDialog* self);
static void pamac_history_dialog_set_cursor_at_end (PamacHistoryDialog* self);
static void pamac_history_dialog_finalize (GObject * obj);
static GType pamac_history_dialog_get_type_once (void);

static inline gpointer
pamac_history_dialog_get_instance_private (PamacHistoryDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PamacHistoryDialog_private_offset);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

PamacHistoryDialog*
pamac_history_dialog_construct (GType object_type,
                                GtkApplicationWindow* window)
{
	PamacHistoryDialog * self = NULL;
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (PamacHistoryDialog*) g_object_new (object_type, "transient-for", window, NULL);
	_tmp0_ = g_file_new_for_path ("/var/log/pacman.log");
	file = _tmp0_;
	_tmp1_ = file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		FILE* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = stderr;
		_tmp3_ = file;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		fprintf (_tmp2_, "File '%s' doesn't exist.\n", _tmp5_);
		_g_free0 (_tmp5_);
	} else {
		{
			GString* text = NULL;
			GString* _tmp6_;
			GFileInputStream* _tmp7_ = NULL;
			GFile* _tmp8_;
			GFileInputStream* _tmp9_;
			GDataInputStream* dis = NULL;
			GDataInputStream* _tmp10_;
			gchar* line = NULL;
			GtkTextView* _tmp27_;
			GtkTextBuffer* _tmp28_;
			GtkTextBuffer* _tmp29_;
			GString* _tmp30_;
			const gchar* _tmp31_;
			_tmp6_ = g_string_new ("");
			text = _tmp6_;
			_tmp8_ = file;
			_tmp9_ = g_file_read (_tmp8_, NULL, &_inner_error0_);
			_tmp7_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_string_free0 (text);
				goto __catch0_g_error;
			}
			_tmp10_ = g_data_input_stream_new ((GInputStream*) _tmp7_);
			dis = _tmp10_;
			while (TRUE) {
				gchar* _tmp11_ = NULL;
				GDataInputStream* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				const gchar* _tmp19_;
				_tmp12_ = dis;
				_tmp13_ = g_data_input_stream_read_line (_tmp12_, NULL, NULL, &_inner_error0_);
				_tmp11_ = _tmp13_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp7_);
					_g_string_free0 (text);
					goto __catch0_g_error;
				}
				_tmp14_ = _tmp11_;
				_tmp11_ = NULL;
				_g_free0 (line);
				line = _tmp14_;
				_tmp15_ = line;
				if (!(_tmp15_ != NULL)) {
					_g_free0 (_tmp11_);
					break;
				}
				_tmp19_ = line;
				if (string_contains (_tmp19_, "installed")) {
					_tmp18_ = TRUE;
				} else {
					const gchar* _tmp20_;
					_tmp20_ = line;
					_tmp18_ = string_contains (_tmp20_, "removed");
				}
				if (_tmp18_) {
					_tmp17_ = TRUE;
				} else {
					const gchar* _tmp21_;
					_tmp21_ = line;
					_tmp17_ = string_contains (_tmp21_, "upgraded");
				}
				if (_tmp17_) {
					_tmp16_ = TRUE;
				} else {
					const gchar* _tmp22_;
					_tmp22_ = line;
					_tmp16_ = string_contains (_tmp22_, "downgraded");
				}
				if (_tmp16_) {
					GString* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp23_ = text;
					_tmp24_ = line;
					_tmp25_ = g_strconcat (_tmp24_, "\n", NULL);
					_tmp26_ = _tmp25_;
					g_string_prepend (_tmp23_, _tmp26_);
					_g_free0 (_tmp26_);
				}
				_g_free0 (_tmp11_);
			}
			_tmp27_ = self->priv->textview;
			_tmp28_ = gtk_text_view_get_buffer (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = text;
			_tmp31_ = _tmp30_->str;
			gtk_text_buffer_set_text (_tmp29_, _tmp31_, -1);
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp7_);
			_g_string_free0 (text);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp32_;
			const gchar* _tmp33_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp32_ = e;
			_tmp33_ = _tmp32_->message;
			g_warning ("history_dialog.vala:58: %s", _tmp33_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	pamac_history_dialog_set_cursor_at_start (self);
	_g_object_unref0 (file);
	return self;
}

PamacHistoryDialog*
pamac_history_dialog_new (GtkApplicationWindow* window)
{
	return pamac_history_dialog_construct (PAMAC_TYPE_HISTORY_DIALOG, window);
}

static void
pamac_history_dialog_on_search_entry_search_changed (PamacHistoryDialog* self)
{
	g_return_if_fail (self != NULL);
	pamac_history_dialog_search_forward (self);
}

static void
_pamac_history_dialog_on_search_entry_search_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                      gpointer self)
{
	pamac_history_dialog_on_search_entry_search_changed ((PamacHistoryDialog*) self);
}

static void
pamac_history_dialog_on_search_entry_next_match (PamacHistoryDialog* self)
{
	g_return_if_fail (self != NULL);
	pamac_history_dialog_on_go_down_button_clicked (self);
}

static void
_pamac_history_dialog_on_search_entry_next_match_gtk_search_entry_next_match (GtkSearchEntry* _sender,
                                                                              gpointer self)
{
	pamac_history_dialog_on_search_entry_next_match ((PamacHistoryDialog*) self);
}

static void
pamac_history_dialog_on_search_entry_previous_match (PamacHistoryDialog* self)
{
	g_return_if_fail (self != NULL);
	pamac_history_dialog_on_go_up_button_clicked (self);
}

static void
_pamac_history_dialog_on_search_entry_previous_match_gtk_search_entry_previous_match (GtkSearchEntry* _sender,
                                                                                      gpointer self)
{
	pamac_history_dialog_on_search_entry_previous_match ((PamacHistoryDialog*) self);
}

static void
pamac_history_dialog_on_go_up_button_clicked (PamacHistoryDialog* self)
{
	GtkTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->textview;
	_tmp1_ = gtk_text_view_get_buffer (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_text_buffer_get_selection_bounds (_tmp2_, &_tmp3_, NULL);
	self->priv->search_start = _tmp3_;
	pamac_history_dialog_search_backward (self);
}

static void
_pamac_history_dialog_on_go_up_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	pamac_history_dialog_on_go_up_button_clicked ((PamacHistoryDialog*) self);
}

static void
pamac_history_dialog_on_go_down_button_clicked (PamacHistoryDialog* self)
{
	GtkTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->textview;
	_tmp1_ = gtk_text_view_get_buffer (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_text_buffer_get_selection_bounds (_tmp2_, NULL, &_tmp3_);
	self->priv->search_start = _tmp3_;
	pamac_history_dialog_search_forward (self);
}

static void
_pamac_history_dialog_on_go_down_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self)
{
	pamac_history_dialog_on_go_down_button_clicked ((PamacHistoryDialog*) self);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
pamac_history_dialog_search_forward (PamacHistoryDialog* self)
{
	gchar* search_string = NULL;
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = string_strip (_tmp1_);
	search_string = _tmp2_;
	_tmp3_ = search_string;
	if (g_strcmp0 (_tmp3_, "") != 0) {
		GtkTextIter match_start = {0};
		GtkTextIter match_end = {0};
		GtkTextSearchFlags flags = 0U;
		const gchar* _tmp4_;
		GtkTextIter _tmp5_ = {0};
		GtkTextIter _tmp6_ = {0};
		gboolean _tmp7_;
		flags = GTK_TEXT_SEARCH_CASE_INSENSITIVE | GTK_TEXT_SEARCH_TEXT_ONLY;
		_tmp4_ = search_string;
		_tmp7_ = gtk_text_iter_forward_search (&self->priv->search_start, _tmp4_, flags, &_tmp5_, &_tmp6_, NULL);
		match_start = _tmp5_;
		match_end = _tmp6_;
		if (_tmp7_) {
			GtkTextView* _tmp8_;
			GtkTextBuffer* _tmp9_;
			GtkTextBuffer* _tmp10_;
			GtkTextIter _tmp11_;
			GtkTextIter _tmp12_;
			_tmp8_ = self->priv->textview;
			_tmp9_ = gtk_text_view_get_buffer (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = match_start;
			_tmp12_ = match_end;
			gtk_text_buffer_select_range (_tmp10_, &_tmp11_, &_tmp12_);
			pamac_history_dialog_scroll_to_cursor (self);
		} else {
			const gchar* _tmp13_;
			GtkTextIter _tmp14_ = {0};
			GtkTextIter _tmp15_ = {0};
			gboolean _tmp16_;
			pamac_history_dialog_set_cursor_at_start (self);
			_tmp13_ = search_string;
			_tmp16_ = gtk_text_iter_forward_search (&self->priv->search_start, _tmp13_, flags, &_tmp14_, &_tmp15_, NULL);
			match_start = _tmp14_;
			match_end = _tmp15_;
			if (_tmp16_) {
				GtkTextView* _tmp17_;
				GtkTextBuffer* _tmp18_;
				GtkTextBuffer* _tmp19_;
				GtkTextIter _tmp20_;
				GtkTextIter _tmp21_;
				_tmp17_ = self->priv->textview;
				_tmp18_ = gtk_text_view_get_buffer (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = match_start;
				_tmp21_ = match_end;
				gtk_text_buffer_select_range (_tmp19_, &_tmp20_, &_tmp21_);
				pamac_history_dialog_scroll_to_cursor (self);
			}
		}
	} else {
		GtkTextView* _tmp22_;
		GtkTextBuffer* _tmp23_;
		GtkTextBuffer* _tmp24_;
		GtkTextView* _tmp25_;
		GtkTextBuffer* _tmp26_;
		GtkTextBuffer* _tmp27_;
		GtkTextMark* _tmp28_;
		GtkTextIter _tmp29_ = {0};
		GtkTextView* _tmp30_;
		GtkTextBuffer* _tmp31_;
		GtkTextBuffer* _tmp32_;
		GtkTextIter _tmp33_;
		_tmp22_ = self->priv->textview;
		_tmp23_ = gtk_text_view_get_buffer (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->textview;
		_tmp26_ = gtk_text_view_get_buffer (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = gtk_text_buffer_get_insert (_tmp27_);
		gtk_text_buffer_get_iter_at_mark (_tmp24_, &_tmp29_, _tmp28_);
		self->priv->search_start = _tmp29_;
		_tmp30_ = self->priv->textview;
		_tmp31_ = gtk_text_view_get_buffer (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = self->priv->search_start;
		gtk_text_buffer_place_cursor (_tmp32_, &_tmp33_);
	}
	_g_free0 (search_string);
}

static void
pamac_history_dialog_search_backward (PamacHistoryDialog* self)
{
	gchar* search_string = NULL;
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = string_strip (_tmp1_);
	search_string = _tmp2_;
	_tmp3_ = search_string;
	if (g_strcmp0 (_tmp3_, "") != 0) {
		GtkTextIter match_start = {0};
		GtkTextIter match_end = {0};
		GtkTextSearchFlags flags = 0U;
		const gchar* _tmp4_;
		GtkTextIter _tmp5_ = {0};
		GtkTextIter _tmp6_ = {0};
		gboolean _tmp7_;
		flags = GTK_TEXT_SEARCH_CASE_INSENSITIVE | GTK_TEXT_SEARCH_TEXT_ONLY;
		_tmp4_ = search_string;
		_tmp7_ = gtk_text_iter_backward_search (&self->priv->search_start, _tmp4_, flags, &_tmp5_, &_tmp6_, NULL);
		match_start = _tmp5_;
		match_end = _tmp6_;
		if (_tmp7_) {
			GtkTextView* _tmp8_;
			GtkTextBuffer* _tmp9_;
			GtkTextBuffer* _tmp10_;
			GtkTextIter _tmp11_;
			GtkTextIter _tmp12_;
			_tmp8_ = self->priv->textview;
			_tmp9_ = gtk_text_view_get_buffer (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = match_start;
			_tmp12_ = match_end;
			gtk_text_buffer_select_range (_tmp10_, &_tmp11_, &_tmp12_);
			pamac_history_dialog_scroll_to_cursor (self);
		} else {
			const gchar* _tmp13_;
			GtkTextIter _tmp14_ = {0};
			GtkTextIter _tmp15_ = {0};
			gboolean _tmp16_;
			pamac_history_dialog_set_cursor_at_end (self);
			_tmp13_ = search_string;
			_tmp16_ = gtk_text_iter_backward_search (&self->priv->search_start, _tmp13_, flags, &_tmp14_, &_tmp15_, NULL);
			match_start = _tmp14_;
			match_end = _tmp15_;
			if (_tmp16_) {
				GtkTextView* _tmp17_;
				GtkTextBuffer* _tmp18_;
				GtkTextBuffer* _tmp19_;
				GtkTextIter _tmp20_;
				GtkTextIter _tmp21_;
				_tmp17_ = self->priv->textview;
				_tmp18_ = gtk_text_view_get_buffer (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = match_start;
				_tmp21_ = match_end;
				gtk_text_buffer_select_range (_tmp19_, &_tmp20_, &_tmp21_);
				pamac_history_dialog_scroll_to_cursor (self);
			}
		}
	} else {
		GtkTextView* _tmp22_;
		GtkTextBuffer* _tmp23_;
		GtkTextBuffer* _tmp24_;
		GtkTextView* _tmp25_;
		GtkTextBuffer* _tmp26_;
		GtkTextBuffer* _tmp27_;
		GtkTextMark* _tmp28_;
		GtkTextIter _tmp29_ = {0};
		GtkTextView* _tmp30_;
		GtkTextBuffer* _tmp31_;
		GtkTextBuffer* _tmp32_;
		GtkTextIter _tmp33_;
		_tmp22_ = self->priv->textview;
		_tmp23_ = gtk_text_view_get_buffer (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->textview;
		_tmp26_ = gtk_text_view_get_buffer (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = gtk_text_buffer_get_insert (_tmp27_);
		gtk_text_buffer_get_iter_at_mark (_tmp24_, &_tmp29_, _tmp28_);
		self->priv->search_start = _tmp29_;
		_tmp30_ = self->priv->textview;
		_tmp31_ = gtk_text_view_get_buffer (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = self->priv->search_start;
		gtk_text_buffer_place_cursor (_tmp32_, &_tmp33_);
	}
	_g_free0 (search_string);
}

static void
pamac_history_dialog_set_cursor_at_start (PamacHistoryDialog* self)
{
	GtkTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	GtkTextView* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextIter _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->textview;
	_tmp1_ = gtk_text_view_get_buffer (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_text_buffer_get_start_iter (_tmp2_, &_tmp3_);
	self->priv->search_start = _tmp3_;
	_tmp4_ = self->priv->textview;
	_tmp5_ = gtk_text_view_get_buffer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->search_start;
	gtk_text_buffer_place_cursor (_tmp6_, &_tmp7_);
}

static void
pamac_history_dialog_set_cursor_at_end (PamacHistoryDialog* self)
{
	GtkTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	GtkTextView* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextIter _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->textview;
	_tmp1_ = gtk_text_view_get_buffer (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_text_buffer_get_end_iter (_tmp2_, &_tmp3_);
	self->priv->search_start = _tmp3_;
	_tmp4_ = self->priv->textview;
	_tmp5_ = gtk_text_view_get_buffer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->search_start;
	gtk_text_buffer_place_cursor (_tmp6_, &_tmp7_);
}

static void
pamac_history_dialog_scroll_to_cursor (PamacHistoryDialog* self)
{
	GtkTextView* _tmp0_;
	GtkTextView* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextMark* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->textview;
	_tmp1_ = self->priv->textview;
	_tmp2_ = gtk_text_view_get_buffer (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_text_buffer_get_insert (_tmp3_);
	gtk_text_view_scroll_to_mark (_tmp0_, _tmp4_, 0.1, FALSE, (gdouble) 0, (gdouble) 0);
}

static void
pamac_history_dialog_class_init (PamacHistoryDialogClass * klass,
                                 gpointer klass_data)
{
	pamac_history_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacHistoryDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = pamac_history_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/manjaro/pamac/manager/history_dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "textview", FALSE, PamacHistoryDialog_private_offset + G_STRUCT_OFFSET (PamacHistoryDialogPrivate, textview));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_entry", FALSE, PamacHistoryDialog_private_offset + G_STRUCT_OFFSET (PamacHistoryDialogPrivate, search_entry));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_search_entry_search_changed", G_CALLBACK(_pamac_history_dialog_on_search_entry_search_changed_gtk_search_entry_search_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_search_entry_next_match", G_CALLBACK(_pamac_history_dialog_on_search_entry_next_match_gtk_search_entry_next_match));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_search_entry_previous_match", G_CALLBACK(_pamac_history_dialog_on_search_entry_previous_match_gtk_search_entry_previous_match));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_go_up_button_clicked", G_CALLBACK(_pamac_history_dialog_on_go_up_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_go_down_button_clicked", G_CALLBACK(_pamac_history_dialog_on_go_down_button_clicked_gtk_button_clicked));
}

static void
pamac_history_dialog_instance_init (PamacHistoryDialog * self,
                                    gpointer klass)
{
	self->priv = pamac_history_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
pamac_history_dialog_finalize (GObject * obj)
{
	PamacHistoryDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_HISTORY_DIALOG, PamacHistoryDialog);
	G_OBJECT_CLASS (pamac_history_dialog_parent_class)->finalize (obj);
}

static GType
pamac_history_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacHistoryDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_history_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacHistoryDialog), 0, (GInstanceInitFunc) pamac_history_dialog_instance_init, NULL };
	GType pamac_history_dialog_type_id;
	pamac_history_dialog_type_id = g_type_register_static (adw_window_get_type (), "PamacHistoryDialog", &g_define_type_info, 0);
	PamacHistoryDialog_private_offset = g_type_add_instance_private (pamac_history_dialog_type_id, sizeof (PamacHistoryDialogPrivate));
	return pamac_history_dialog_type_id;
}

GType
pamac_history_dialog_get_type (void)
{
	static volatile gsize pamac_history_dialog_type_id__once = 0;
	if (g_once_init_enter (&pamac_history_dialog_type_id__once)) {
		GType pamac_history_dialog_type_id;
		pamac_history_dialog_type_id = pamac_history_dialog_get_type_once ();
		g_once_init_leave (&pamac_history_dialog_type_id__once, pamac_history_dialog_type_id);
	}
	return pamac_history_dialog_type_id__once;
}

