/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.support;

import com.amazon.dlic.auth.ldap.LdapUser;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.ldaptive.AbstractLdapBean;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchEntry;
import org.opensearch.security.auth.UserInjector;
import org.opensearch.security.support.SourceFieldsContext;
import org.opensearch.security.user.User;

public final class SafeSerializationUtils {
    private static final Set<Class<?>> SAFE_CLASSES = ImmutableSet.of(String.class, SocketAddress.class, InetSocketAddress.class, Pattern.class, User.class, UserInjector.InjectedUser.class, (Object[])new Class[]{SourceFieldsContext.class, LdapUser.class, SearchEntry.class, LdapEntry.class, AbstractLdapBean.class, LdapAttribute.class});
    private static final Set<Class<?>> SAFE_ASSIGNABLE_FROM_CLASSES = ImmutableSet.of(InetAddress.class, Number.class, Collection.class, Map.class, Enum.class);
    private static final Set<String> SAFE_CLASS_NAMES = Collections.singleton("org.ldaptive.LdapAttribute$LdapAttributeValues");
    static final Map<Class<?>, Boolean> safeClassCache = new ConcurrentHashMap();

    static boolean isSafeClass(Class<?> cls) {
        return safeClassCache.computeIfAbsent(cls, SafeSerializationUtils::computeIsSafeClass);
    }

    static boolean computeIsSafeClass(Class<?> cls) {
        return cls.isArray() || SAFE_CLASSES.contains(cls) || SAFE_CLASS_NAMES.contains(cls.getName()) || SafeSerializationUtils.isAssignableFromSafeClass(cls);
    }

    private static boolean isAssignableFromSafeClass(Class<?> cls) {
        for (Class<?> safeClass : SAFE_ASSIGNABLE_FROM_CLASSES) {
            if (!safeClass.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    static void prohibitUnsafeClasses(Class<?> clazz) throws IOException {
        if (!SafeSerializationUtils.isSafeClass(clazz)) {
            throw new IOException("Unauthorized serialization attempt " + clazz.getName());
        }
    }
}

