/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auditlog.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Map;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.SpecialPermission;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.env.Environment;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.get.GetResult;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.auditlog.impl.AbstractAuditLog;
import org.opensearch.security.auditlog.impl.AuditMessage;
import org.opensearch.security.auditlog.routing.AuditMessageRouter;
import org.opensearch.security.filter.SecurityRequest;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequest;

public final class AuditLogImpl
extends AbstractAuditLog {
    private final AuditMessageRouter messageRouter;
    private final Settings settings;
    private final boolean messageRouterEnabled;
    private volatile boolean enabled;
    private final Thread shutdownHook;

    public AuditLogImpl(Settings settings, Path configPath, Client clientProvider, ThreadPool threadPool, IndexNameExpressionResolver resolver, ClusterService clusterService) {
        this(settings, configPath, clientProvider, threadPool, resolver, clusterService, null);
    }

    public AuditLogImpl(Settings settings, Path configPath, Client clientProvider, ThreadPool threadPool, IndexNameExpressionResolver resolver, ClusterService clusterService, Environment environment) {
        super(settings, threadPool, resolver, clusterService, environment);
        this.settings = settings;
        this.messageRouter = new AuditMessageRouter(settings, clientProvider, threadPool, configPath);
        this.messageRouterEnabled = this.messageRouter.isEnabled();
        this.log.info("Message routing enabled: {}", (Object)this.messageRouterEnabled);
        SpecialPermission.check();
        this.shutdownHook = AccessController.doPrivileged(this::addShutdownHook);
        this.log.debug("Shutdown hook {} registered", (Object)this.shutdownHook);
    }

    @Override
    @Subscribe
    public void setConfig(AuditConfig auditConfig) {
        this.enabled = auditConfig.isEnabled() && this.messageRouterEnabled;
        this.onAuditConfigFilterChanged(auditConfig.getFilter());
        this.onComplianceConfigChanged(auditConfig.getCompliance());
    }

    @Override
    protected void enableRoutes() {
        if (this.messageRouterEnabled) {
            this.messageRouter.enableRoutes(this.settings);
        }
    }

    private Thread addShutdownHook() {
        Thread shutdownHook = new Thread(() -> this.messageRouter.close());
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        return shutdownHook;
    }

    private Boolean removeShutdownHook() {
        return Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
    }

    @Override
    public void close() throws IOException {
        this.log.info("Closing {}", (Object)this.getClass().getSimpleName());
        SpecialPermission.check();
        try {
            boolean removed = AccessController.doPrivileged(this::removeShutdownHook);
            if (removed) {
                this.log.debug("Shutdown hook {} unregistered", (Object)this.shutdownHook);
                this.shutdownHook.run();
            } else {
                this.log.warn("Shutdown hook {} is not registered", (Object)this.shutdownHook);
            }
        }
        catch (IllegalStateException e) {
            this.log.debug("Fail to unregister shutdown hook {}. Shutdown is in progress.", (Object)this.shutdownHook, (Object)e);
        }
    }

    @Override
    protected void save(AuditMessage msg) {
        if (this.enabled) {
            this.messageRouter.route(msg);
        }
    }

    @Override
    public void logFailedLogin(String effectiveUser, boolean securityAdmin, String initiatingUser, SecurityRequest request) {
        if (this.enabled) {
            super.logFailedLogin(effectiveUser, securityAdmin, initiatingUser, request);
        }
    }

    @Override
    public void logSucceededLogin(String effectiveUser, boolean securityAdmin, String initiatingUser, SecurityRequest request) {
        if (this.enabled) {
            super.logSucceededLogin(effectiveUser, securityAdmin, initiatingUser, request);
        }
    }

    @Override
    public void logMissingPrivileges(String privilege, String effectiveUser, SecurityRequest request) {
        if (this.enabled) {
            super.logMissingPrivileges(privilege, effectiveUser, request);
        }
    }

    @Override
    public void logGrantedPrivileges(String effectiveUser, SecurityRequest request) {
        if (this.enabled) {
            super.logGrantedPrivileges(effectiveUser, request);
        }
    }

    @Override
    public void logMissingPrivileges(String privilege, TransportRequest request, Task task) {
        if (this.enabled) {
            super.logMissingPrivileges(privilege, request, task);
        }
    }

    @Override
    public void logGrantedPrivileges(String privilege, TransportRequest request, Task task) {
        if (this.enabled) {
            super.logGrantedPrivileges(privilege, request, task);
        }
    }

    @Override
    public void logIndexEvent(String privilege, TransportRequest request, Task task) {
        if (this.enabled) {
            super.logIndexEvent(privilege, request, task);
        }
    }

    @Override
    public void logBadHeaders(TransportRequest request, String action, Task task) {
        if (this.enabled) {
            super.logBadHeaders(request, action, task);
        }
    }

    @Override
    public void logBadHeaders(SecurityRequest request) {
        if (this.enabled) {
            super.logBadHeaders(request);
        }
    }

    @Override
    public void logSecurityIndexAttempt(TransportRequest request, String action, Task task) {
        if (this.enabled) {
            super.logSecurityIndexAttempt(request, action, task);
        }
    }

    @Override
    public void logSSLException(TransportRequest request, Throwable t, String action, Task task) {
        if (this.enabled) {
            super.logSSLException(request, t, action, task);
        }
    }

    @Override
    public void logSSLException(SecurityRequest request, Throwable t) {
        if (this.enabled) {
            super.logSSLException(request, t);
        }
    }

    @Override
    public void logDocumentRead(String index, String id, ShardId shardId, Map<String, String> fieldNameValues) {
        if (this.enabled) {
            super.logDocumentRead(index, id, shardId, fieldNameValues);
        }
    }

    @Override
    public void logDocumentWritten(ShardId shardId, GetResult originalResult, Engine.Index currentIndex, Engine.IndexResult result) {
        if (this.enabled) {
            super.logDocumentWritten(shardId, originalResult, currentIndex, result);
        }
    }

    @Override
    public void logDocumentDeleted(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        if (this.enabled) {
            super.logDocumentDeleted(shardId, delete, result);
        }
    }

    @Override
    protected void logExternalConfig() {
        if (this.enabled) {
            super.logExternalConfig();
        }
    }
}

