/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.lang.reflect.Constructor;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.jcajce.provider.ProvPBEPBKDF2;
import org.bouncycastle.jcajce.provider.ProvSecretKeySpec;

class BaseSecretKeyFactory
extends SecretKeyFactorySpi {
    protected final String algorithmName;
    protected final Algorithm algorithm;
    protected final Validator validator;

    BaseSecretKeyFactory(String string, Algorithm algorithm, Validator validator) {
        this.algorithmName = string;
        this.algorithm = algorithm;
        this.validator = validator;
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        if (clazz == null) {
            throw new InvalidKeySpecException("keySpec parameter is null");
        }
        if (secretKey == null) {
            throw new InvalidKeySpecException("key parameter is null");
        }
        return this.genericGetKeySpec(secretKey, clazz);
    }

    protected KeySpec genericGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        if (SecretKeySpec.class.isAssignableFrom(clazz)) {
            return new SecretKeySpec(secretKey.getEncoded(), this.algorithmName);
        }
        if (KeySpec.class.isAssignableFrom(clazz)) {
            try {
                Class[] classArray = new Class[]{byte[].class};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{this.validator.validated(secretKey.getEncoded())};
                return (KeySpec)constructor.newInstance(objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InvalidKeySpecException("Unable to transform encoded key to KeySpec: " + clazz.getName());
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("Exception transforming to KeySpec: " + exception.toString(), exception);
            }
        }
        throw new InvalidKeySpecException("Passed in class is not a KeySpec: " + clazz.getName());
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (secretKey == null) {
            throw new InvalidKeyException("Secret key parameter cannot be null");
        }
        try {
            return new SecretKeySpec(this.validator.validated(secretKey.getEncoded()), this.algorithmName);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(invalidKeySpecException.getMessage());
        }
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof SecretKeySpec) {
            SecretKeySpec secretKeySpec = (SecretKeySpec)keySpec;
            return new ProvSecretKeySpec(new ValidatedSymmetricKey(this.algorithm, this.validator.validated(secretKeySpec.getEncoded())), this.algorithmName);
        }
        if (keySpec instanceof PBEKeySpec) {
            ProvPBEPBKDF2.BasePBKDF2 basePBKDF2 = new ProvPBEPBKDF2.BasePBKDF2(this.algorithmName, PasswordConverter.UTF8, FipsSHS.Algorithm.SHA256_HMAC);
            SecretKey secretKey = basePBKDF2.engineGenerateSecret(keySpec);
            return new ProvSecretKeySpec(new ValidatedSymmetricKey(this.algorithm, this.validator.validated(secretKey.getEncoded())), this.algorithmName);
        }
        if (keySpec == null) {
            throw new InvalidKeySpecException("null KeySpec passed to SecretKeyFactory");
        }
        throw new InvalidKeySpecException("Unknown KeySpec passed to SecretKeyFactory: " + keySpec.getClass().getName());
    }

    static interface Validator {
        public byte[] validated(byte[] var1) throws InvalidKeySpecException;
    }
}

