/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import org.jsmpp.PDUStringException;
import org.jsmpp.util.StringParameter;
import org.jsmpp.util.StringType;

public final class StringValidator {
    private static final String ACTUAL_LENGTH_IS = ". Actual length is ";
    private static final String C_OCTET_STRING_VALUE = "C-Octet String value '";

    private StringValidator() {
        throw new InstantiationError("This class must not be instantiated");
    }

    public static void validateString(String value, StringParameter param) throws PDUStringException {
        if (param.getType() == StringType.C_OCTET_STRING) {
            if (param.isRangeMinAndMax()) {
                if (!StringValidator.isCOctetStringValid(value, param.getMax())) {
                    throw new PDUStringException(C_OCTET_STRING_VALUE + value + "' length must be less than " + param.getMax() + ACTUAL_LENGTH_IS + value.length(), param);
                }
            } else if (!StringValidator.isCOctetStringNullOrNValValid(value, param.getMax())) {
                throw new PDUStringException(C_OCTET_STRING_VALUE + value + "' length should be 1 or " + (param.getMax() - 1) + ACTUAL_LENGTH_IS + value.length(), param);
            }
        } else if (param.getType() == StringType.OCTET_STRING && !StringValidator.isOctetStringValid(value, param.getMax())) {
            throw new PDUStringException("Octet String value '" + value + "' length must be less than or equal to " + param.getMax() + ACTUAL_LENGTH_IS + value.length(), param);
        }
    }

    public static void validateString(byte[] value, StringParameter param) throws PDUStringException {
        if (param.getType() == StringType.C_OCTET_STRING) {
            if (param.isRangeMinAndMax()) {
                if (!StringValidator.isCOctetStringValid(value, param.getMax())) {
                    throw new PDUStringException(C_OCTET_STRING_VALUE + new String(value) + "' length must be less than " + param.getMax() + ACTUAL_LENGTH_IS + value.length, param);
                }
            } else if (!StringValidator.isCOctetStringNullOrNValValid(value, param.getMax())) {
                throw new PDUStringException(C_OCTET_STRING_VALUE + new String(value) + "' length should be 1 or " + (param.getMax() - 1) + ACTUAL_LENGTH_IS + value.length, param);
            }
        } else if (param.getType() == StringType.OCTET_STRING && !StringValidator.isOctetStringValid(value, param.getMax())) {
            throw new PDUStringException("Octet String value '" + new String(value) + "' length must be less than or equal to " + param.getMax() + ACTUAL_LENGTH_IS + value.length, param);
        }
    }

    static boolean isCOctetStringValid(String value, int maxLength) {
        if (value == null) {
            return true;
        }
        return value.length() < maxLength;
    }

    static boolean isCOctetStringValid(byte[] value, int maxLength) {
        if (value == null) {
            return true;
        }
        return value.length < maxLength;
    }

    static boolean isCOctetStringNullOrNValValid(String value, int length) {
        if (value == null) {
            return true;
        }
        if (value.length() == 0) {
            return true;
        }
        return value.length() == length - 1;
    }

    static boolean isCOctetStringNullOrNValValid(byte[] value, int length) {
        if (value == null) {
            return true;
        }
        if (value.length == 0) {
            return true;
        }
        return value.length == length - 1;
    }

    static boolean isOctetStringValid(String value, int maxLength) {
        if (value == null) {
            return true;
        }
        return value.length() <= maxLength;
    }

    static boolean isOctetStringValid(byte[] value, int maxLength) {
        if (value == null) {
            return true;
        }
        return value.length <= maxLength;
    }
}

