/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance.plugin.palette;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;

public class PaletteGenerator {
    private static final float[] DEFAULT_FILTER = new float[]{0.0f, 360.0f, 0.0f, 3.0f, 0.0f, 1.5f};

    public static Color[] generatePalette(int colorsCount, int quality) {
        return PaletteGenerator.generatePalette(colorsCount, quality, false, null, null);
    }

    public static Color[] generatePalette(int colorsCount, int quality, Random random) {
        return PaletteGenerator.generatePalette(colorsCount, quality, false, random, null);
    }

    public static Color[] generatePalette(int colorsCount, int quality, float[] filter) {
        return PaletteGenerator.generatePalette(colorsCount, quality, false, null, filter);
    }

    public static Color[] generatePalette(int colorsCount, int quality, boolean ultraPrecision, Random random, float[] filter) {
        double b;
        double a;
        double l;
        if (filter == null) {
            filter = DEFAULT_FILTER;
        }
        if (random == null) {
            random = new Random();
        }
        double[][] kMeans = PaletteGenerator.generateRandomKmeans(colorsCount, random, filter);
        ArrayList<double[]> colorSamples = new ArrayList<double[]>();
        if (ultraPrecision) {
            for (l = 0.0; l <= 1.0; l += 0.01) {
                for (a = -1.0; a <= 1.0; a += 0.05) {
                    for (b = -1.0; b <= 1.0; b += 0.05) {
                        if (!PaletteGenerator.checkColor2(l, a, b, filter)) continue;
                        colorSamples.add(new double[]{l, a, b});
                    }
                }
            }
        } else {
            for (l = 0.0; l <= 1.0; l += 0.05) {
                for (a = -1.0; a <= 1.0; a += 0.1) {
                    for (b = -1.0; b <= 1.0; b += 0.1) {
                        if (!PaletteGenerator.checkColor2(l, a, b, filter)) continue;
                        colorSamples.add(new double[]{l, a, b});
                    }
                }
            }
        }
        int[] samplesClosest = new int[colorSamples.size()];
        int steps = quality;
        while (steps-- > 0) {
            for (int i = 0; i < colorSamples.size(); ++i) {
                double[] lab = (double[])colorSamples.get(i);
                double minDistance = 1000000.0;
                for (int j = 0; j < kMeans.length; ++j) {
                    double[] kMean = kMeans[j];
                    double distance = Math.sqrt(Math.pow(lab[0] - kMean[0], 2.0) + Math.pow(lab[1] - kMean[1], 2.0) + Math.pow(lab[2] - kMean[2], 2.0));
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                    samplesClosest[i] = j;
                }
            }
            ArrayList<double[]> freeColorSamples = colorSamples;
            for (int j = 0; j < kMeans.length; ++j) {
                double distance;
                int i;
                int closest;
                int count = 0;
                double[] candidateKMean = new double[]{0.0, 0.0, 0.0};
                for (int i2 = 0; i2 < colorSamples.size(); ++i2) {
                    if (samplesClosest[i2] != j) continue;
                    ++count;
                    double[] colorSample = (double[])colorSamples.get(i2);
                    candidateKMean[0] = candidateKMean[0] + colorSample[0];
                    candidateKMean[1] = candidateKMean[1] + colorSample[1];
                    candidateKMean[2] = candidateKMean[2] + colorSample[2];
                }
                if (count != 0) {
                    candidateKMean[0] = candidateKMean[0] / (double)count;
                    candidateKMean[1] = candidateKMean[1] / (double)count;
                    candidateKMean[2] = candidateKMean[2] / (double)count;
                }
                if (count != 0 && PaletteGenerator.checkColor2(candidateKMean[0], candidateKMean[1], candidateKMean[2], filter)) {
                    kMeans[j] = candidateKMean;
                } else if (freeColorSamples.size() > 0) {
                    double minDistance = 1.0E10;
                    closest = -1;
                    for (i = 0; i < freeColorSamples.size(); ++i) {
                        distance = Math.sqrt(Math.pow(((double[])freeColorSamples.get(i))[0] - candidateKMean[0], 2.0) + Math.pow(((double[])freeColorSamples.get(i))[1] - candidateKMean[1], 2.0) + Math.pow(((double[])freeColorSamples.get(i))[2] - candidateKMean[2], 2.0));
                        if (!(distance < minDistance)) continue;
                        minDistance = distance;
                        closest = i;
                    }
                    kMeans[j] = (double[])colorSamples.get(closest);
                } else {
                    double minDistance = 1.0E10;
                    closest = -1;
                    for (i = 0; i < colorSamples.size(); ++i) {
                        distance = Math.sqrt(Math.pow(((double[])colorSamples.get(i))[0] - candidateKMean[0], 2.0) + Math.pow(((double[])colorSamples.get(i))[1] - candidateKMean[1], 2.0) + Math.pow(((double[])colorSamples.get(i))[2] - candidateKMean[2], 2.0));
                        if (!(distance < minDistance)) continue;
                        minDistance = distance;
                        closest = i;
                    }
                    kMeans[j] = (double[])colorSamples.get(closest);
                }
                ArrayList<double[]> newFreeColorSamples = new ArrayList<double[]>();
                for (double[] color : freeColorSamples) {
                    double[] kMean;
                    if (color[0] == (kMean = kMeans[j])[0] && color[1] == kMean[1] && color[2] == kMean[2]) continue;
                    newFreeColorSamples.add(color);
                }
                freeColorSamples = newFreeColorSamples;
            }
        }
        kMeans = PaletteGenerator.sortColors(kMeans);
        Color[] res = new Color[kMeans.length];
        for (int i = 0; i < kMeans.length; ++i) {
            double[] kmean = kMeans[i];
            int[] rgb = PaletteGenerator.lab2rgb(kmean[0], kmean[1], kmean[2]);
            res[i] = new Color(rgb[0], rgb[1], rgb[2]);
        }
        return res;
    }

    private static double[][] generateRandomKmeans(int colorsCount, Random random, float[] filter) {
        double[][] kMeans = new double[colorsCount][];
        for (int i = 0; i < colorsCount; ++i) {
            double[] lab = new double[]{random.nextDouble(), 2.0 * random.nextDouble() - 1.0, 2.0 * random.nextDouble() - 1.0};
            while (!PaletteGenerator.checkColor2(lab, filter)) {
                lab = new double[]{random.nextDouble(), 2.0 * random.nextDouble() - 1.0, 2.0 * random.nextDouble() - 1.0};
            }
            kMeans[i] = lab;
        }
        return kMeans;
    }

    private static double[][] sortColors(double[][] colors) {
        LinkedList colorsToSort = new LinkedList(Arrays.asList(colors));
        ArrayList<double[]> diffColors = new ArrayList<double[]>();
        diffColors.add((double[])colorsToSort.pop());
        while (colorsToSort.size() > 0) {
            int index = -1;
            double maxDistance = -1.0;
            for (int candidate_index = 0; candidate_index < colorsToSort.size(); ++candidate_index) {
                double d = 1.0E9;
                for (int i = 0; i < diffColors.size(); ++i) {
                    double[] colorA = (double[])colorsToSort.get(candidate_index);
                    double[] colorB = (double[])diffColors.get(i);
                    double dl = colorA[0] - colorB[0];
                    double da = colorA[1] - colorB[1];
                    double db = colorA[2] - colorB[2];
                    d = Math.min(d, Math.sqrt(Math.pow(dl, 2.0) + Math.pow(da, 2.0) + Math.pow(db, 2.0)));
                }
                if (!(d > maxDistance)) continue;
                maxDistance = d;
                index = candidate_index;
            }
            double[] color = (double[])colorsToSort.get(index);
            diffColors.add(color);
            colorsToSort.remove(index);
        }
        double[][] res = new double[diffColors.size()][];
        for (int i = 0; i < diffColors.size(); ++i) {
            res[i] = (double[])diffColors.get(i);
        }
        return res;
    }

    private static boolean checkColor2(double[] lab, float[] filter) {
        return PaletteGenerator.checkColor2(lab[0], lab[1], lab[2], filter);
    }

    private static boolean checkColor2(double l, double a, double b, float[] filter) {
        int[] rgb = PaletteGenerator.lab2rgb(l, a, b);
        double[] hcl = PaletteGenerator.lab2hcl(l, a, b);
        return !Double.isNaN(rgb[0]) && rgb[0] >= 0 && rgb[1] >= 0 && rgb[2] >= 0 && rgb[0] < 256 && rgb[1] < 256 && rgb[2] < 256 && (filter[0] < filter[1] ? hcl[0] >= (double)filter[0] && hcl[0] <= (double)filter[1] : hcl[0] >= (double)filter[0] || hcl[0] <= (double)filter[1]) && hcl[1] >= (double)filter[2] && hcl[1] <= (double)filter[3] && hcl[2] >= (double)filter[4] && hcl[2] <= (double)filter[5];
    }

    private static int[] lab2rgb(double l, double a, double b) {
        double[] xyz = PaletteGenerator.lab2xyz(l, a, b);
        return PaletteGenerator.xyz2rgb(xyz[0], xyz[1], xyz[2]);
    }

    private static double[] lab2xyz(double l, double a, double b) {
        double sl = (l + 0.16) / 1.16;
        double[] ill = new double[]{0.96421, 1.0, 0.82519};
        double y = ill[1] * PaletteGenerator.finv(sl);
        double x = ill[0] * PaletteGenerator.finv(sl + a / 5.0);
        double z = ill[2] * PaletteGenerator.finv(sl - b / 2.0);
        return new double[]{x, y, z};
    }

    private static int[] xyz2rgb(double x, double y, double z) {
        boolean clip;
        double rl = 3.2406 * x - 1.5372 * y - 0.4986 * z;
        double gl = -0.9689 * x + 1.8758 * y + 0.0415 * z;
        double bl = 0.0557 * x - 0.204 * y + 1.057 * z;
        boolean bl2 = clip = Math.min(rl, Math.min(gl, bl)) < -0.001 || Math.max(rl, Math.max(gl, bl)) > 1.001;
        if (clip) {
            double d = rl < 0.0 ? 0.0 : (rl = rl > 1.0 ? 1.0 : rl);
            double d2 = gl < 0.0 ? 0.0 : (gl = gl > 1.0 ? 1.0 : gl);
            bl = bl < 0.0 ? 0.0 : (bl > 1.0 ? 1.0 : bl);
        }
        int r = (int)Math.round(255.0 * PaletteGenerator.correct1(rl));
        int g = (int)Math.round(255.0 * PaletteGenerator.correct1(gl));
        int b = (int)Math.round(255.0 * PaletteGenerator.correct1(bl));
        return new int[]{r, g, b};
    }

    private static double[] rgb2lab(int r, int g, int b) {
        double[] xyz = PaletteGenerator.rgb2xyz(r, g, b);
        return PaletteGenerator.xyz2lab(xyz[0], xyz[1], xyz[2]);
    }

    private static double[] rgb2xyz(int r, int g, int b) {
        double rl = PaletteGenerator.correct2((double)r / 255.0);
        double gl = PaletteGenerator.correct2((double)g / 255.0);
        double bl = PaletteGenerator.correct2((double)b / 255.0);
        double x = 0.4124 * rl + 0.3576 * gl + 0.1805 * bl;
        double y = 0.2126 * rl + 0.7152 * gl + 0.0722 * bl;
        double z = 0.0193 * rl + 0.1192 * gl + 0.9505 * bl;
        return new double[]{x, y, z};
    }

    private static double[] xyz2lab(double x, double y, double z) {
        double[] ill = new double[]{0.96421, 1.0, 0.82519};
        double l = 1.16 * PaletteGenerator.flab(y / ill[1]) - 0.16;
        double a = 5.0 * (PaletteGenerator.flab(x / ill[0]) - PaletteGenerator.flab(y / ill[1]));
        double b = 2.0 * (PaletteGenerator.flab(y / ill[1]) - PaletteGenerator.flab(z / ill[2]));
        return new double[]{l, a, b};
    }

    private static double[] lab2hcl(double l, double a, double b) {
        l = (l - 0.09) / 0.61;
        double r = Math.sqrt(a * a + b * b);
        double s = r / (l * 0.311 + 0.125);
        double TAU = Math.PI * 2;
        double angle = Math.atan2(a, b);
        double c = (TAU / 6.0 - angle) / TAU;
        if ((c *= 360.0) < 0.0) {
            c += 360.0;
        }
        return new double[]{c, s, l};
    }

    private static double finv(double t) {
        if (t > 0.20689655172413793) {
            return t * t * t;
        }
        return 0.12841854934601665 * (t - 0.13793103448275862);
    }

    private static double flab(double t) {
        if (t > Math.pow(0.20689655172413793, 3.0)) {
            return Math.pow(t, 0.3333333333333333);
        }
        return 7.787037037037035 * t + 0.13793103448275862;
    }

    private static double correct1(double cl) {
        double a = 0.055;
        if (cl <= 0.0031308) {
            return 12.92 * cl;
        }
        return (1.0 + a) * Math.pow(cl, 0.4166666666666667) - a;
    }

    private static double correct2(double c) {
        double a = 0.055;
        if (c <= 0.04045) {
            return c / 12.92;
        }
        return Math.pow((c + a) / (1.0 + a), 2.4);
    }
}

