/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.gephi.datalab.api.DataLaboratoryHelper;
import org.gephi.datalab.spi.ContextMenuItemManipulator;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.edges.EdgesManipulator;
import org.gephi.datalab.spi.nodes.NodesManipulator;
import org.gephi.datalab.spi.values.AttributeValueManipulator;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class PopupMenuUtils {
    public static JMenuItem createMenuItemFromNodesManipulator(final NodesManipulator item, Node clickedNode, Node[] nodes) {
        ContextMenuItemManipulator[] subItems = item.getSubItems();
        if (subItems != null && item.canExecute()) {
            JMenu subMenu = new JMenu();
            subMenu.setText(item.getName());
            if (item.getDescription() != null && !item.getDescription().isEmpty()) {
                subMenu.setToolTipText(item.getDescription());
            }
            subMenu.setIcon(item.getIcon());
            Integer lastItemType = null;
            for (ContextMenuItemManipulator subItem : subItems) {
                ((NodesManipulator)subItem).setup(nodes, clickedNode);
                if (lastItemType == null) {
                    lastItemType = subItem.getType();
                }
                if (lastItemType.intValue() != subItem.getType()) {
                    subMenu.addSeparator();
                }
                lastItemType = subItem.getType();
                if (!subItem.isAvailable()) continue;
                subMenu.add(PopupMenuUtils.createMenuItemFromNodesManipulator((NodesManipulator)subItem, clickedNode, nodes));
            }
            if (item.getMnemonicKey() != null) {
                subMenu.setMnemonic(item.getMnemonicKey());
            }
            return subMenu;
        }
        JMenuItem menuItem = new JMenuItem();
        menuItem.setText(item.getName());
        if (item.getDescription() != null && !item.getDescription().isEmpty()) {
            menuItem.setToolTipText(item.getDescription());
        }
        menuItem.setIcon(item.getIcon());
        if (item.canExecute()) {
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(){

                        @Override
                        public void run() {
                            DataLaboratoryHelper.getDefault().executeManipulator((Manipulator)item);
                        }
                    }.start();
                }
            });
        } else {
            menuItem.setEnabled(false);
        }
        if (item.getMnemonicKey() != null) {
            menuItem.setMnemonic(item.getMnemonicKey());
            menuItem.setAccelerator(KeyStroke.getKeyStroke(item.getMnemonicKey(), 128));
        }
        return menuItem;
    }

    public static JMenuItem createMenuItemFromEdgesManipulator(final EdgesManipulator item, Edge clickedEdge, Edge[] edges) {
        ContextMenuItemManipulator[] subItems = item.getSubItems();
        if (subItems != null && item.canExecute()) {
            JMenu subMenu = new JMenu();
            subMenu.setText(item.getName());
            if (item.getDescription() != null && !item.getDescription().isEmpty()) {
                subMenu.setToolTipText(item.getDescription());
            }
            subMenu.setIcon(item.getIcon());
            Integer lastItemType = null;
            for (ContextMenuItemManipulator subItem : subItems) {
                ((EdgesManipulator)subItem).setup(edges, clickedEdge);
                if (lastItemType == null) {
                    lastItemType = subItem.getType();
                }
                if (lastItemType.intValue() != subItem.getType()) {
                    subMenu.addSeparator();
                }
                lastItemType = subItem.getType();
                if (!subItem.isAvailable()) continue;
                subMenu.add(PopupMenuUtils.createMenuItemFromEdgesManipulator((EdgesManipulator)subItem, clickedEdge, edges));
            }
            if (item.getMnemonicKey() != null) {
                subMenu.setMnemonic(item.getMnemonicKey());
            }
            return subMenu;
        }
        JMenuItem menuItem = new JMenuItem();
        menuItem.setText(item.getName());
        if (item.getDescription() != null && !item.getDescription().isEmpty()) {
            menuItem.setToolTipText(item.getDescription());
        }
        menuItem.setIcon(item.getIcon());
        if (item.canExecute()) {
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(){

                        @Override
                        public void run() {
                            DataLaboratoryHelper.getDefault().executeManipulator((Manipulator)item);
                        }
                    }.start();
                }
            });
        } else {
            menuItem.setEnabled(false);
        }
        if (item.getMnemonicKey() != null) {
            menuItem.setMnemonic(item.getMnemonicKey());
            menuItem.setAccelerator(KeyStroke.getKeyStroke(item.getMnemonicKey(), 128));
        }
        return menuItem;
    }

    public static JMenuItem createMenuItemFromManipulator(final Manipulator nm) {
        JMenuItem menuItem = new JMenuItem();
        menuItem.setText(nm.getName());
        if (nm.getDescription() != null && !nm.getDescription().isEmpty()) {
            menuItem.setToolTipText(nm.getDescription());
        }
        menuItem.setIcon(nm.getIcon());
        if (nm.canExecute()) {
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataLaboratoryHelper dlh = DataLaboratoryHelper.getDefault();
                    dlh.executeManipulator(nm);
                }
            });
        } else {
            menuItem.setEnabled(false);
        }
        return menuItem;
    }

    public static JMenu createSubMenuFromRowColumn(Element row, Column column) {
        DataLaboratoryHelper dlh = DataLaboratoryHelper.getDefault();
        JMenu subMenu = new JMenu(NbBundle.getMessage(PopupMenuUtils.class, (String)"Cell.Popup.subMenu.text"));
        subMenu.setIcon(ImageUtilities.loadImageIcon((String)"DesktopDataLaboratory/table-select.png", (boolean)true));
        Integer lastManipulatorType = null;
        for (AttributeValueManipulator am : dlh.getAttributeValueManipulators()) {
            am.setup(row, column);
            if (lastManipulatorType == null) {
                lastManipulatorType = am.getType();
            }
            if (lastManipulatorType.intValue() != am.getType()) {
                subMenu.addSeparator();
            }
            lastManipulatorType = am.getType();
            subMenu.add(PopupMenuUtils.createMenuItemFromManipulator((Manipulator)am));
        }
        if (subMenu.getMenuComponentCount() == 0) {
            subMenu.setEnabled(false);
        }
        return subMenu;
    }
}

