/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.FontMappers;
import org.apache.pdfbox.pdmodel.font.FontMapping;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.util.Matrix;
import org.gephi.preview.AbstractRenderTarget;
import org.gephi.preview.api.CanvasSize;
import org.gephi.preview.api.PDFTarget;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.RenderTarget;
import org.gephi.preview.spi.RenderTargetBuilder;
import org.openide.util.Exceptions;

public class PDFRenderTargetBuilder
implements RenderTargetBuilder {
    @Override
    public String getName() {
        return "pdf";
    }

    @Override
    public RenderTarget buildRenderTarget(PreviewModel previewModel) {
        CanvasSize cs = previewModel.getGraphicsCanvasSize();
        PreviewProperties properties = previewModel.getProperties();
        float marginBottom = properties.getFloatValue("pfd.margin.bottom");
        float marginLeft = properties.getFloatValue("pdf.margin.left");
        float marginRight = properties.getFloatValue("pdf.margin.right");
        float marginTop = properties.getFloatValue("pdf.margin.top");
        PDRectangle pageSize = (PDRectangle)properties.getValue("pdf.pagesize");
        boolean landscape = properties.getBooleanValue("pdf.landscape");
        boolean transparentBackground = properties.getBooleanValue("pdf.transparent.background");
        Color backgroundColor = transparentBackground ? null : properties.getColorValue("background-color");
        PDPageContentStream cb = (PDPageContentStream)properties.getValue("pdf.contentbyte");
        PDDocument doc = (PDDocument)properties.getValue("pdf.document");
        PDFRenderTargetImpl renderTarget = new PDFRenderTargetImpl(doc, cb, cs, pageSize, backgroundColor, marginLeft, marginRight, marginTop, marginBottom, landscape);
        return renderTarget;
    }

    public static class PDFRenderTargetImpl
    extends AbstractRenderTarget
    implements PDFTarget {
        private final PDPageContentStream cb;
        private final PDDocument document;
        private final float marginTop;
        private final float marginBottom;
        private final float marginLeft;
        private final float marginRight;
        private final boolean landscape;
        private final PDRectangle pageSize;
        private Map<String, PDFont> fontMap;

        public PDFRenderTargetImpl(PDDocument doc, PDPageContentStream cb, CanvasSize cs, PDRectangle size, Color backgroundColor, float marginLeft, float marginRight, float marginTop, float marginBottom, boolean landscape) {
            this.document = doc;
            this.cb = cb;
            this.marginTop = marginTop;
            this.marginLeft = marginLeft;
            this.marginBottom = marginBottom;
            this.marginRight = marginRight;
            this.pageSize = size;
            this.landscape = landscape;
            this.fontMap = new HashMap<String, PDFont>();
            double centerX = cs.getX() + cs.getWidth() / 2.0f;
            double centerY = cs.getY() + cs.getHeight() / 2.0f;
            double pageWidth = size.getWidth() - marginLeft - marginRight;
            double pageHeight = size.getHeight() - marginTop - marginBottom;
            double ratioWidth = pageWidth / (double)cs.getWidth();
            double ratioHeight = pageHeight / (double)cs.getHeight();
            double scale = (float)(ratioWidth < ratioHeight ? ratioWidth : ratioHeight);
            double translateX = ((double)marginLeft + pageWidth / 2.0) / scale;
            double translateY = ((double)marginBottom + pageHeight / 2.0) / scale;
            try {
                if (backgroundColor != null) {
                    cb.setNonStrokingColor(backgroundColor);
                    cb.addRect(0.0f, 0.0f, size.getWidth(), size.getHeight());
                    cb.fill();
                }
                cb.transform(Matrix.getTranslateInstance((float)((float)(-centerX * scale)), (float)((float)(centerY * scale))));
                cb.transform(Matrix.getScaleInstance((float)((float)scale), (float)((float)scale)));
                cb.transform(Matrix.getTranslateInstance((float)((float)translateX), (float)((float)translateY)));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public PDPageContentStream getContentStream() {
            return this.cb;
        }

        @Override
        public PDFont getPDFont(Font font) {
            String fontKey = PDFRenderTargetImpl.getFontKey(font);
            return this.fontMap.computeIfAbsent(fontKey, key -> {
                FontMapping mapping = FontMappers.instance().getTrueTypeFont(fontKey, null);
                if (mapping != null) {
                    try {
                        return PDType0Font.load((PDDocument)this.document, (TrueTypeFont)((TrueTypeFont)mapping.getFont()), (boolean)true);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                return PDType1Font.HELVETICA;
            });
        }

        private static String getFontKey(Font font) {
            StringBuilder name = new StringBuilder(font.getName().replace(" ", "-"));
            if (font.isBold()) {
                name.append("-Bold");
            }
            if (font.isItalic()) {
                name.append("-Italic");
            }
            return name.toString();
        }

        @Override
        public float getMarginBottom() {
            return this.marginBottom;
        }

        @Override
        public float getMarginLeft() {
            return this.marginLeft;
        }

        @Override
        public float getMarginRight() {
            return this.marginRight;
        }

        @Override
        public float getMarginTop() {
            return this.marginTop;
        }

        @Override
        public boolean isLandscape() {
            return this.landscape;
        }

        @Override
        public PDRectangle getPageSize() {
            return this.pageSize;
        }
    }
}

