/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.util.Arrays;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterator;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.MapFactory;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedMapOps;
import scala.collection.generic.DefaultSerializable;
import scala.collection.mutable.AbstractMap;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.LinkedHashSet$;
import scala.collection.mutable.SeqMap;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class LinkedHashMap<K, V>
extends AbstractMap<K, V>
implements StrictOptimizedMapOps<K, V, LinkedHashMap, LinkedHashMap<K, V>>,
DefaultSerializable,
SeqMap<K, V> {
    private LinkedEntry<K, V> firstEntry = null;
    private LinkedEntry<K, V> lastEntry = null;
    public LinkedEntry<K, V>[] scala$collection$mutable$LinkedHashMap$$table = new LinkedEntry[this.tableSizeFor(16)];
    private int threshold = (int)((double)this.scala$collection$mutable$LinkedHashMap$$table.length * 0.75);
    private int contentSize = 0;

    /*
     * WARNING - void declaration
     */
    @Override
    public IterableOps map(Function1 f) {
        void var1_1;
        return StrictOptimizedMapOps.map$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IterableOps concat(IterableOnce suffix) {
        void var1_1;
        return StrictOptimizedMapOps.concat$(this, (IterableOnce)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IterableOps collect(PartialFunction pf) {
        void var1_1;
        return StrictOptimizedMapOps.collect$(this, (PartialFunction)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tuple2<LinkedHashMap<K, V>, LinkedHashMap<K, V>> partition(Function1<Tuple2<K, V>, Object> p) {
        void var1_1;
        return StrictOptimizedIterableOps.partition$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<Tuple2<K, V>, Tuple2<A1, A2>> asPair) {
        void var1_1;
        return StrictOptimizedIterableOps.unzip$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object map(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.map$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object flatMap(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.flatMap$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object collect(PartialFunction pf) {
        void var1_1;
        return StrictOptimizedIterableOps.collect$(this, (PartialFunction)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object flatten(Function1 toIterableOnce) {
        void var1_1;
        return StrictOptimizedIterableOps.flatten$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object zip(IterableOnce that) {
        void var1_1;
        return StrictOptimizedIterableOps.zip$(this, (IterableOnce)var1_1);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filter(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filter$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filterNot(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filterNot$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        void var2_2;
        void var1_1;
        return StrictOptimizedIterableOps.filterImpl$(this, (Function1)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object dropRight(int n) {
        void var1_1;
        return StrictOptimizedIterableOps.dropRight$(this, (int)var1_1);
    }

    @Override
    public MapFactory<LinkedHashMap> mapFactory() {
        return LinkedHashMap$.MODULE$;
    }

    public LinkedEntry<K, V> _firstEntry() {
        return this.firstEntry();
    }

    public LinkedEntry<K, V> firstEntry() {
        return this.firstEntry;
    }

    /*
     * WARNING - void declaration
     */
    public void firstEntry_$eq(LinkedEntry<K, V> x$1) {
        void var1_1;
        this.firstEntry = var1_1;
    }

    public LinkedEntry<K, V> lastEntry() {
        return this.lastEntry;
    }

    /*
     * WARNING - void declaration
     */
    public void lastEntry_$eq(LinkedEntry<K, V> x$1) {
        void var1_1;
        this.lastEntry = var1_1;
    }

    @Override
    public Tuple2<K, V> last() {
        if (this.size() > 0) {
            return new Tuple2<K, V>(this.lastEntry().key(), this.lastEntry().value());
        }
        throw new NoSuchElementException("Cannot call .last on empty LinkedHashMap");
    }

    @Override
    public Option<Tuple2<K, V>> lastOption() {
        if (this.size() > 0) {
            return new Some<Tuple2<K, V>>(new Tuple2<K, V>(this.lastEntry().key(), this.lastEntry().value()));
        }
        return None$.MODULE$;
    }

    @Override
    public Tuple2<K, V> head() {
        if (this.size() > 0) {
            return new Tuple2<K, V>(this.firstEntry().key(), this.firstEntry().value());
        }
        throw new NoSuchElementException("Cannot call .head on empty LinkedHashMap");
    }

    @Override
    public Option<Tuple2<K, V>> headOption() {
        if (this.size() > 0) {
            return new Some<Tuple2<K, V>>(new Tuple2<K, V>(this.firstEntry().key(), this.firstEntry().value()));
        }
        return None$.MODULE$;
    }

    @Override
    public int size() {
        return this.contentSize;
    }

    @Override
    public int knownSize() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Option<V> get(K key) {
        void var1_1;
        void var2_2;
        int findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash = Statics.anyHash(key);
        int findEntry_hash = findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash ^ findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash >>> 16;
        LinkedEntry<K, V> linkedEntry = this.scala$collection$mutable$LinkedHashMap$$table[findEntry_hash & this.scala$collection$mutable$LinkedHashMap$$table.length - 1];
        LinkedEntry<K, V> e = linkedEntry == null ? null : linkedEntry.findEntry(key, (int)var2_2);
        if (e == null) {
            return None$.MODULE$;
        }
        return new Some(var1_1.value());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sizeHint(int size) {
        int target = this.tableSizeFor((int)((double)(size + 1) / 0.75));
        if (target > this.scala$collection$mutable$LinkedHashMap$$table.length) {
            void var1_1;
            this.growTable((int)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(K key) {
        void var1_1;
        if (this.getClass() == LinkedHashMap.class) {
            void var2_2;
            int findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash = Statics.anyHash(key);
            int findEntry_hash = findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash ^ findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash >>> 16;
            LinkedEntry<K, V> linkedEntry = this.scala$collection$mutable$LinkedHashMap$$table[findEntry_hash & this.scala$collection$mutable$LinkedHashMap$$table.length - 1];
            return (linkedEntry == null ? null : linkedEntry.findEntry(key, (int)var2_2)) != null;
        }
        return MapOps.contains$(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Option<V> put(K key, V value) {
        void var2_2;
        Some<void> some;
        if ((some = this.put0(some, var2_2, true)) == null) {
            return None$.MODULE$;
        }
        return some;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(K key, V value) {
        void var2_2;
        void var1_1;
        this.put0(var1_1, var2_2, false);
    }

    @Override
    public Option<V> remove(K key) {
        LinkedEntry<void, V> linkedEntry;
        if ((linkedEntry = this.removeEntry0(linkedEntry)) == null) {
            return None$.MODULE$;
        }
        return new Some<V>(linkedEntry.value());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <V1> V1 getOrElse(K key, Function0<V1> function0) {
        void var1_1;
        void var3_4;
        Class<?> clazz = this.getClass();
        Class<LinkedHashMap> clazz2 = LinkedHashMap.class;
        if (clazz == null || !clazz.equals(clazz2)) {
            if ((key = this.get(key)) instanceof Some) {
                return (V1)((Some)key).value();
            }
            if (None$.MODULE$.equals(key)) {
                return function0.apply();
            }
            throw new MatchError(key);
        }
        int findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash = Statics.anyHash(key);
        int findEntry_hash = findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash ^ findEntry_scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash >>> 16;
        LinkedEntry<K, V> linkedEntry = this.scala$collection$mutable$LinkedHashMap$$table[findEntry_hash & this.scala$collection$mutable$LinkedHashMap$$table.length - 1];
        LinkedEntry<K, V> nd = linkedEntry == null ? null : linkedEntry.findEntry(key, (int)var3_4);
        if (nd == null) {
            void var2_2;
            return (V1)var2_2.apply();
        }
        return (V1)var1_1.value();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getOrElseUpdate(K key, Function0<V> defaultValue) {
        void var2_2;
        void var3_4;
        void var1_1;
        V getOrElseUpdate_d;
        Class<?> clazz = this.getClass();
        Option option = LinkedHashMap.class;
        if (clazz == null || !clazz.equals(option)) {
            option = this.get(key);
            if (option instanceof Some) {
                return (V)((Some)option).value();
            }
            if (None$.MODULE$.equals(option)) {
                getOrElseUpdate_d = defaultValue.apply();
                this.update(key, getOrElseUpdate_d);
                return getOrElseUpdate_d;
            }
            throw new MatchError(option);
        }
        int scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash = Statics.anyHash(key);
        int hash = scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash ^ scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash >>> 16;
        int idx = hash & this.scala$collection$mutable$LinkedHashMap$$table.length - 1;
        LinkedEntry<K, V> linkedEntry = this.scala$collection$mutable$LinkedHashMap$$table[idx];
        LinkedEntry<K, V> nd = linkedEntry == null ? null : linkedEntry.findEntry(key, hash);
        if (nd != null) {
            return nd.value();
        }
        LinkedEntry<K, V>[] table0 = this.scala$collection$mutable$LinkedHashMap$$table;
        Object r = getOrElseUpdate_d.apply();
        if (this.contentSize + 1 >= this.threshold) {
            LinkedHashMap linkedHashMap = this;
            linkedHashMap.growTable(linkedHashMap.scala$collection$mutable$LinkedHashMap$$table.length << 1);
        }
        int newIdx = table0 == this.scala$collection$mutable$LinkedHashMap$$table ? idx : hash & this.scala$collection$mutable$LinkedHashMap$$table.length - 1;
        this.put0(var1_1, r, false, (int)var3_4, newIdx);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private LinkedEntry<K, V> removeEntry0(K elem) {
        void var1_2;
        K k = elem;
        int scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash = Statics.anyHash(k);
        return this.removeEntry0(k, scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash ^ var1_2 >>> 16);
    }

    private LinkedEntry<K, V> removeEntry0(K elem, int hash) {
        int idx = hash & this.scala$collection$mutable$LinkedHashMap$$table.length - 1;
        LinkedEntry<K, V> linkedEntry = this.scala$collection$mutable$LinkedHashMap$$table[idx];
        if (linkedEntry == null) {
            return null;
        }
        if (linkedEntry.hash() == hash && BoxesRunTime.equals(linkedEntry.key(), elem)) {
            this.scala$collection$mutable$LinkedHashMap$$table[idx] = linkedEntry.next();
            this.deleteEntry(linkedEntry);
            --this.contentSize;
            return linkedEntry;
        }
        LinkedEntry<K, V> prev = linkedEntry;
        for (LinkedEntry<K, V> next = linkedEntry.next(); next != null && next.hash() <= hash; next = next.next()) {
            if (next.hash() == hash && BoxesRunTime.equals(next.key(), elem)) {
                prev.next_$eq(next.next());
                this.deleteEntry(next);
                --this.contentSize;
                return next;
            }
            prev = next;
        }
        return null;
    }

    public int unimproveHash(int improvedHash) {
        int n = improvedHash;
        return n ^ n >>> 16;
    }

    /*
     * WARNING - void declaration
     */
    public LinkedHashMap<K, V> addOne(Tuple2<K, V> kv) {
        void var1_1;
        this.put(kv._1(), var1_1._2());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LinkedHashMap<K, V> subtractOne(K key) {
        void var1_1;
        this.remove(var1_1);
        return this;
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator() {
        if (this.size() == 0) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new LinkedHashMapIterator<Tuple2<K, V>>(this){

            /*
             * WARNING - void declaration
             */
            public final Tuple2<K, V> extract(LinkedEntry<K, V> nd) {
                void var1_1;
                return new Tuple2<K, V>(nd.key(), var1_1.value());
            }
            {
                void var1_1;
            }
        };
    }

    @Override
    public Set<K> keySet() {
        return new LinkedKeySet(this);
    }

    @Override
    public Iterator<K> keysIterator() {
        if (this.size() == 0) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new LinkedHashMapIterator<K>(this){

            public final K extract(LinkedEntry<K, V> nd) {
                return nd.key();
            }
            {
                void var1_1;
            }
        };
    }

    public Iterator<LinkedEntry<K, V>> entryIterator() {
        if (this.size() == 0) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new LinkedHashMapIterator<LinkedEntry<K, V>>(this){

            public final LinkedEntry<K, V> extract(LinkedEntry<K, V> nd) {
                return nd;
            }
            {
                void var1_1;
            }
        };
    }

    @Override
    public Iterator<V> valuesIterator() {
        if (this.size() == 0) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new LinkedHashMapIterator<V>(this){

            public final V extract(LinkedEntry<K, V> nd) {
                return nd.value();
            }
            {
                void var1_1;
            }
        };
    }

    @Override
    public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
        for (LinkedEntry<K, V> cur = this.firstEntry(); cur != null; cur = cur.later()) {
            f.apply(new Tuple2<K, V>(cur.key(), cur.value()));
        }
    }

    @Override
    public <U> void foreachEntry(Function2<K, V, U> f) {
        for (LinkedEntry<K, V> cur = this.firstEntry(); cur != null; cur = cur.later()) {
            f.apply(cur.key(), cur.value());
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.scala$collection$mutable$LinkedHashMap$$table, null);
        this.contentSize = 0;
        this.firstEntry_$eq(null);
        this.lastEntry_$eq(null);
    }

    private int tableSizeFor(int capacity) {
        int n;
        --n;
        n = Integer.highestOneBit(Math.max(n, 4)) << 1;
        return Math.min(n, 0x40000000);
    }

    /*
     * WARNING - void declaration
     */
    private LinkedEntry<K, V> createNewEntry(K key, int hash, V value) {
        void var1_1;
        void var3_3;
        void var2_2;
        LinkedEntry<K, void> e = new LinkedEntry<K, void>(key, (int)var2_2, var3_3);
        if (this.firstEntry() == null) {
            this.firstEntry_$eq(e);
        } else {
            this.lastEntry().later_$eq(e);
            e.earlier_$eq(this.lastEntry());
        }
        this.lastEntry_$eq(e);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void deleteEntry(LinkedEntry<K, V> e) {
        void var1_1;
        if (e.earlier() == null) {
            this.firstEntry_$eq(e.later());
        } else {
            e.earlier().later_$eq(e.later());
        }
        if (e.later() == null) {
            this.lastEntry_$eq(e.earlier());
        } else {
            e.later().earlier_$eq(e.earlier());
        }
        e.earlier_$eq(null);
        e.later_$eq(null);
        var1_1.next_$eq(null);
    }

    /*
     * WARNING - void declaration
     */
    private Some<V> put0(K key, V value, boolean getOld) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.contentSize + 1 >= this.threshold) {
            LinkedHashMap linkedHashMap = this;
            linkedHashMap.growTable(linkedHashMap.scala$collection$mutable$LinkedHashMap$$table.length << 1);
        }
        int scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash = Statics.anyHash(key);
        int hash = scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash ^ scala$collection$mutable$LinkedHashMap$$computeHash_scala$collection$mutable$LinkedHashMap$$improveHash_originalHash >>> 16;
        int idx = hash & this.scala$collection$mutable$LinkedHashMap$$table.length - 1;
        return this.put0(var1_1, var2_2, (boolean)var3_3, hash, idx);
    }

    /*
     * WARNING - void declaration
     */
    private Some<V> put0(K key, V value, boolean getOld, int hash, int idx) {
        LinkedEntry<K, V> linkedEntry = this.scala$collection$mutable$LinkedHashMap$$table[idx];
        if (linkedEntry == null) {
            this.scala$collection$mutable$LinkedHashMap$$table[idx] = this.createNewEntry(key, hash, value);
        } else {
            void var2_2;
            V old;
            LinkedEntry<K, V> prev = null;
            for (LinkedEntry<K, V> n = linkedEntry; n != null && n.hash() <= hash; n = n.next()) {
                if (n.hash() == hash && BoxesRunTime.equals(key, n.key())) {
                    old = n.value();
                    n.value_$eq(value);
                    if (getOld) {
                        return new Some<V>(old);
                    }
                    return null;
                }
                prev = n;
            }
            LinkedEntry<void, void> nnode = this.createNewEntry(old, hash, var2_2);
            if (prev == null) {
                nnode.next_$eq(linkedEntry);
                this.scala$collection$mutable$LinkedHashMap$$table[idx] = nnode;
            } else {
                void var1_1;
                nnode.next_$eq(prev.next());
                prev.next_$eq((LinkedEntry<K, V>)var1_1);
            }
        }
        ++this.contentSize;
        return null;
    }

    private void growTable(int newlen) {
        if (newlen < 0) {
            throw new RuntimeException(new StringBuilder(36).append("new hash table size ").append(newlen).append(" exceeds maximum").toString());
        }
        this.threshold = (int)((double)newlen * 0.75);
        if (this.size() == 0) {
            this.scala$collection$mutable$LinkedHashMap$$table = new LinkedEntry[newlen];
            return;
        }
        this.scala$collection$mutable$LinkedHashMap$$table = Arrays.copyOf(this.scala$collection$mutable$LinkedHashMap$$table, newlen);
        LinkedEntry<Object, Object> preLow = new LinkedEntry<Object, Object>(null, 0, null);
        LinkedEntry<Object, Object> preHigh = new LinkedEntry<Object, Object>(null, 0, null);
        for (int oldlen = this.scala$collection$mutable$LinkedHashMap$$table.length; oldlen < newlen; oldlen <<= 1) {
            for (int i = 0; i < oldlen; ++i) {
                LinkedEntry<K, V> old = this.scala$collection$mutable$LinkedHashMap$$table[i];
                if (old == null) continue;
                preLow.next_$eq(null);
                preHigh.next_$eq(null);
                LinkedEntry<Object, Object> lastLow = preLow;
                LinkedEntry<Object, Object> lastHigh = preHigh;
                LinkedEntry<K, V> n = old;
                while (n != null) {
                    LinkedEntry<K, V> next = n.next();
                    if ((n.hash() & oldlen) == 0) {
                        lastLow.next_$eq(n);
                        lastLow = n;
                    } else {
                        lastHigh.next_$eq(n);
                        lastHigh = n;
                    }
                    n = next;
                }
                lastLow.next_$eq(null);
                if (old != preLow.next()) {
                    this.scala$collection$mutable$LinkedHashMap$$table[i] = preLow.next();
                }
                if (preHigh.next() == null) continue;
                this.scala$collection$mutable$LinkedHashMap$$table[i + oldlen] = preHigh.next();
                lastHigh.next_$eq(null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        if (this.isEmpty()) {
            return MurmurHash3$.MODULE$.emptyMapHash();
        }
        LinkedHashMapIterator<Object> tupleHashIterator = new LinkedHashMapIterator<Object>(this){
            private int hash;
            private final /* synthetic */ LinkedHashMap $outer;

            public final int hash() {
                return this.hash;
            }

            /*
             * WARNING - void declaration
             */
            public final void hash_$eq(int x$1) {
                void var1_1;
                this.hash = var1_1;
            }

            public final int hashCode() {
                return this.hash();
            }

            /*
             * WARNING - void declaration
             */
            public final Object extract(LinkedEntry<K, V> nd) {
                void var1_1;
                this.hash_$eq(MurmurHash3$.MODULE$.tuple2Hash(this.$outer.unimproveHash(nd.hash()), Statics.anyHash(var1_1.value())));
                return this;
            }
            {
                void var1_1;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hash = 0;
            }
        };
        return MurmurHash3$.MODULE$.unorderedHash((IterableOnce<Object>)var1_1, MurmurHash3$.MODULE$.mapSeed());
    }

    @Override
    public String stringPrefix() {
        return "LinkedHashMap";
    }

    public static final class LinkedEntry<K, V> {
        private final K key;
        private final int hash;
        private V value;
        private LinkedEntry<K, V> earlier;
        private LinkedEntry<K, V> later;
        private LinkedEntry<K, V> next;

        public final K key() {
            return this.key;
        }

        public final int hash() {
            return this.hash;
        }

        public final V value() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        public final void value_$eq(V x$1) {
            void var1_1;
            this.value = var1_1;
        }

        public final LinkedEntry<K, V> earlier() {
            return this.earlier;
        }

        /*
         * WARNING - void declaration
         */
        public final void earlier_$eq(LinkedEntry<K, V> x$1) {
            void var1_1;
            this.earlier = var1_1;
        }

        public final LinkedEntry<K, V> later() {
            return this.later;
        }

        /*
         * WARNING - void declaration
         */
        public final void later_$eq(LinkedEntry<K, V> x$1) {
            void var1_1;
            this.later = var1_1;
        }

        public final LinkedEntry<K, V> next() {
            return this.next;
        }

        /*
         * WARNING - void declaration
         */
        public final void next_$eq(LinkedEntry<K, V> x$1) {
            void var1_1;
            this.next = var1_1;
        }

        public final LinkedEntry<K, V> findEntry(K k, int h) {
            while (h != this_.hash() || !BoxesRunTime.equals(k, this_.key())) {
                if (this_.next() == null || this_.hash() > h) {
                    return null;
                }
                LinkedEntry<K, V> this_ = this_.next();
            }
            return this_;
        }

        /*
         * WARNING - void declaration
         */
        public LinkedEntry(K key, int hash, V value) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.hash = var2_2;
            this.value = var3_3;
            this.earlier = null;
            this.later = null;
            this.next = null;
        }
    }

    private abstract class LinkedHashMapIterator<T>
    extends AbstractIterator<T> {
        private LinkedEntry<K, V> cur;

        public abstract T extract(LinkedEntry<K, V> var1);

        @Override
        public boolean hasNext() {
            return this.cur != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T next() {
            if (this.hasNext()) {
                void var1_1;
                LinkedHashMapIterator linkedHashMapIterator = this;
                T r = linkedHashMapIterator.extract(linkedHashMapIterator.cur);
                this.cur = this.cur.later();
                return var1_1;
            }
            return (T)Iterator$.scala$collection$Iterator$$_empty.next();
        }

        /*
         * WARNING - void declaration
         */
        public LinkedHashMapIterator() {
            void var1_1;
            if (LinkedHashMap.this == null) {
                throw null;
            }
            this.cur = var1_1.firstEntry();
        }
    }

    public class LinkedKeySet
    extends MapOps.KeySet {
        @Override
        public IterableFactory<Set> iterableFactory() {
            return LinkedHashSet$.MODULE$;
        }

        /*
         * WARNING - void declaration
         */
        public LinkedKeySet(LinkedHashMap $outer) {
            super((MapOps)var1_1);
            void var1_1;
        }
    }
}

