/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.ConfigurationGroup;
import org.apache.ivy.core.module.descriptor.ConfigurationIntersection;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.extendable.ExtendableItem;

public class DefaultDependencyDescriptor
implements DependencyDescriptor {
    private static final Pattern SELF_FALLBACK_PATTERN = Pattern.compile("@(\\+[^\\(]+)?(\\(.*\\))?");
    private static final Pattern THIS_FALLBACK_PATTERN = Pattern.compile("#(\\+[^\\(]+)?(\\(.*\\))?");
    private final ModuleRevisionId revId;
    private ModuleRevisionId dynamicRevId;
    private Map confs;
    private Map dependencyArtifacts;
    private Map includeRules;
    private Map excludeRules;
    private boolean isForce;
    private boolean isChanging;
    private ModuleRevisionId parentId;
    private boolean isTransitive;
    private Namespace namespace;
    private final ModuleDescriptor md;
    private DependencyDescriptor asSystem;
    private ModuleRevisionId sourceModule;
    private Map doesExcludeCache;

    public static DependencyDescriptor transformInstance(DependencyDescriptor dependencyDescriptor, Namespace namespace) {
        NamespaceTransformer namespaceTransformer = namespace.getToSystemTransformer();
        if (namespaceTransformer.isIdentity()) {
            return dependencyDescriptor;
        }
        dependencyDescriptor = DefaultDependencyDescriptor.transformInstance(dependencyDescriptor, namespaceTransformer, false);
        v0.namespace = namespace;
        return dependencyDescriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultDependencyDescriptor transformInstance(DependencyDescriptor dependencyDescriptor, NamespaceTransformer stringArray, boolean bl) {
        ExtendableItem extendableItem = stringArray.transform(dependencyDescriptor.getParentRevisionId());
        ExtendableItem extendableItem2 = stringArray.transform(dependencyDescriptor.getDependencyRevisionId());
        ModuleRevisionId moduleRevisionId = stringArray.transform(dependencyDescriptor.getDynamicConstraintDependencyRevisionId());
        extendableItem2 = new DefaultDependencyDescriptor(null, (ModuleRevisionId)extendableItem2, moduleRevisionId, dependencyDescriptor.isForce(), dependencyDescriptor.isChanging(), dependencyDescriptor.isTransitive());
        v0.parentId = extendableItem;
        extendableItem = dependencyDescriptor.getSourceModule();
        if (extendableItem != null) {
            ((DefaultDependencyDescriptor)extendableItem2).sourceModule = stringArray.transform((ModuleRevisionId)extendableItem);
        }
        if ((stringArray = dependencyDescriptor.getModuleConfigurations()).length == 1 && "*".equals(stringArray[0])) {
            if (!(dependencyDescriptor instanceof DefaultDependencyDescriptor)) throw new IllegalArgumentException("dependency descriptor transformation does not support * module confs with descriptors which aren't DefaultDependencyDescriptor");
            extendableItem = (DefaultDependencyDescriptor)dependencyDescriptor;
            ((DefaultDependencyDescriptor)extendableItem2).confs = new LinkedHashMap(((DefaultDependencyDescriptor)extendableItem).confs);
            super.setExcludeRules(new LinkedHashMap(super.getExcludeRules()));
            super.setIncludeRules(new LinkedHashMap(super.getIncludeRules()));
            super.setDependencyArtifacts(new LinkedHashMap(super.getDependencyArtifacts()));
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                ((DefaultDependencyDescriptor)extendableItem2).confs.put(stringArray[i], new ArrayList<String>(Arrays.asList(dependencyDescriptor.getDependencyConfigurations(stringArray[i]))));
                super.getExcludeRules().put(stringArray[i], new ArrayList<ExcludeRule>(Arrays.asList(dependencyDescriptor.getExcludeRules(stringArray[i]))));
                super.getIncludeRules().put(stringArray[i], new ArrayList<IncludeRule>(Arrays.asList(dependencyDescriptor.getIncludeRules(stringArray[i]))));
                super.getDependencyArtifacts().put(stringArray[i], new ArrayList<DependencyArtifactDescriptor>(Arrays.asList(dependencyDescriptor.getDependencyArtifacts(stringArray[i]))));
            }
        }
        if (!bl) return extendableItem2;
        ((DefaultDependencyDescriptor)extendableItem2).asSystem = dependencyDescriptor;
        return extendableItem2;
    }

    private DefaultDependencyDescriptor(DefaultDependencyDescriptor defaultDependencyDescriptor, ModuleRevisionId moduleRevisionId) {
        this.confs = new LinkedHashMap();
        this.isTransitive = true;
        this.namespace = null;
        this.asSystem = this;
        this.doesExcludeCache = new HashMap();
        Checks.checkNotNull(defaultDependencyDescriptor, "dd");
        Checks.checkNotNull(moduleRevisionId, "revision");
        if (!moduleRevisionId.getModuleId().equals(defaultDependencyDescriptor.getDependencyId())) {
            throw new IllegalArgumentException("new ModuleRevisionId MUST have the same ModuleId as original one. original = " + defaultDependencyDescriptor.getDependencyId() + " new = " + moduleRevisionId.getModuleId());
        }
        this.md = defaultDependencyDescriptor.md;
        this.parentId = defaultDependencyDescriptor.parentId;
        this.revId = moduleRevisionId;
        this.dynamicRevId = defaultDependencyDescriptor.dynamicRevId;
        this.isForce = defaultDependencyDescriptor.isForce;
        this.isChanging = defaultDependencyDescriptor.isChanging;
        this.isTransitive = defaultDependencyDescriptor.isTransitive;
        this.namespace = defaultDependencyDescriptor.namespace;
        this.confs.putAll(defaultDependencyDescriptor.confs);
        this.excludeRules = defaultDependencyDescriptor.excludeRules == null ? null : new LinkedHashMap(defaultDependencyDescriptor.excludeRules);
        this.includeRules = defaultDependencyDescriptor.includeRules == null ? null : new LinkedHashMap(defaultDependencyDescriptor.includeRules);
        this.dependencyArtifacts = defaultDependencyDescriptor.dependencyArtifacts == null ? null : new LinkedHashMap(defaultDependencyDescriptor.dependencyArtifacts);
        this.sourceModule = defaultDependencyDescriptor.sourceModule;
    }

    public DefaultDependencyDescriptor(ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId, boolean bl, boolean bl2, boolean bl3) {
        ModuleRevisionId moduleRevisionId2 = moduleRevisionId;
        this(moduleDescriptor, moduleRevisionId2, moduleRevisionId2, bl, bl2, bl3);
    }

    public DefaultDependencyDescriptor(ModuleRevisionId moduleRevisionId, boolean bl) {
        this(moduleRevisionId, bl, false);
    }

    public DefaultDependencyDescriptor(ModuleRevisionId moduleRevisionId, boolean bl, boolean bl2) {
        ModuleRevisionId moduleRevisionId2 = moduleRevisionId;
        this(null, moduleRevisionId2, moduleRevisionId2, bl, bl2, true);
    }

    public DefaultDependencyDescriptor(ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2, boolean bl, boolean bl2, boolean bl3) {
        this.confs = new LinkedHashMap();
        this.isTransitive = true;
        this.namespace = null;
        this.asSystem = this;
        this.doesExcludeCache = new HashMap();
        Checks.checkNotNull(moduleRevisionId, "mrid");
        Checks.checkNotNull(moduleRevisionId2, "dynamicConstraint");
        this.md = moduleDescriptor;
        this.revId = moduleRevisionId;
        this.dynamicRevId = moduleRevisionId2;
        this.isForce = bl;
        this.isChanging = bl2;
        this.isTransitive = bl3;
        this.sourceModule = moduleDescriptor == null ? null : moduleDescriptor.getModuleRevisionId();
    }

    @Override
    public ModuleId getDependencyId() {
        return this.getDependencyRevisionId().getModuleId();
    }

    @Override
    public ModuleRevisionId getDependencyRevisionId() {
        return this.revId;
    }

    @Override
    public ModuleRevisionId getDynamicConstraintDependencyRevisionId() {
        return this.dynamicRevId;
    }

    @Override
    public String[] getModuleConfigurations() {
        return this.confs.keySet().toArray(new String[this.confs.keySet().size()]);
    }

    @Override
    public String[] getDependencyConfigurations(String string) {
        String string2 = string;
        return this.getDependencyConfigurations(string2, string2);
    }

    @Override
    public String[] getDependencyConfigurations(String string, String string2) {
        String string3;
        Object object;
        Object object2;
        if (this.md != null) {
            object2 = this.md.getConfiguration(string);
            if (object2 instanceof ConfigurationIntersection) {
                Collection collection;
                ConfigurationIntersection configurationIntersection = (ConfigurationIntersection)object2;
                HashSet<Object> hashSet = new HashSet<Object>();
                object2 = configurationIntersection.getIntersectedConfigurationNames();
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    collection = this.getDependencyConfigurationsIncludingExtending(object2[i], string2);
                    if (hashSet.isEmpty()) {
                        hashSet.addAll(collection);
                        continue;
                    }
                    if (hashSet.contains("*")) {
                        hashSet.remove("*");
                        hashSet.addAll(collection);
                        continue;
                    }
                    if (collection.contains("*")) continue;
                    Object object3 = hashSet;
                    hashSet = new HashSet();
                    Object object4 = object3.iterator();
                    while (object4.hasNext()) {
                        object3 = (String)object4.next();
                        if (!collection.contains(object3)) continue;
                        hashSet.add(object3);
                    }
                }
                List list = (List)this.confs.get(string);
                if (list != null) {
                    hashSet.addAll(list);
                }
                if (hashSet.isEmpty() && (collection = (List)this.confs.get("*")) != null) {
                    for (Object object4 : collection) {
                        if (object4 != null && ((String)object4).startsWith("@+")) {
                            return new String[]{string + ((String)object4).substring(1)};
                        }
                        if (object4 == null || !((String)object4).equals("@")) continue;
                        return new String[]{string};
                    }
                }
                HashSet<Object> hashSet2 = hashSet;
                return hashSet2.toArray(new String[hashSet2.size()]);
            }
            if (object2 instanceof ConfigurationGroup) {
                ConfigurationGroup configurationGroup = (ConfigurationGroup)object2;
                HashSet hashSet = new HashSet();
                object2 = configurationGroup.getMembersConfigurationNames();
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    Collection collection = this.getDependencyConfigurationsIncludingExtending(object2[i], string2);
                    hashSet.addAll(collection);
                }
                HashSet hashSet3 = hashSet;
                return hashSet3.toArray(new String[hashSet3.size()]);
            }
        }
        if ((object2 = (List)this.confs.get(string)) == null) {
            object2 = (List)this.confs.get("%");
        }
        Object object5 = (List)this.confs.get("*");
        Object object6 = new LinkedHashSet();
        if (object2 != null) {
            object6.addAll(object2);
        }
        if (object5 != null) {
            object6.addAll(object5);
        }
        object2 = new LinkedHashSet();
        object5 = object6.iterator();
        while (object5.hasNext()) {
            object = (String)object5.next();
            string3 = DefaultDependencyDescriptor.replaceSelfFallbackPattern((String)object, string);
            if (string3 == null) {
                string3 = DefaultDependencyDescriptor.replaceThisFallbackPattern((String)object, string2);
            }
            if (string3 != null) {
                object = string3;
            }
            object2.add(object);
        }
        object6 = object2;
        if (object6.remove("*")) {
            object5 = new StringBuffer("*");
            object = object6.iterator();
            while (object.hasNext()) {
                string3 = (String)object.next();
                if (!string3.startsWith("!")) continue;
                ((StringBuffer)object5).append(string3);
            }
            return new String[]{((StringBuffer)object5).toString()};
        }
        Object object7 = object6;
        return object7.toArray(new String[object7.size()]);
    }

    private Collection getDependencyConfigurationsIncludingExtending(String iterator, String string) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(Arrays.asList(this.getDependencyConfigurations((String)((Object)iterator), string)));
        iterator = Configuration.findConfigurationExtending((String)((Object)iterator), this.md.getConfigurations());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Configuration configuration = (Configuration)iterator.next();
            linkedHashSet.addAll(Arrays.asList(this.getDependencyConfigurations(configuration.getName(), string)));
        }
        return linkedHashSet;
    }

    protected static String replaceSelfFallbackPattern(String string, String string2) {
        return DefaultDependencyDescriptor.replaceFallbackConfigurationPattern(SELF_FALLBACK_PATTERN, string, string2);
    }

    protected static String replaceThisFallbackPattern(String string, String string2) {
        return DefaultDependencyDescriptor.replaceFallbackConfigurationPattern(THIS_FALLBACK_PATTERN, string, string2);
    }

    protected static String replaceFallbackConfigurationPattern(Pattern object, String string, String string2) {
        if (((Matcher)(object = ((Pattern)object).matcher(string))).matches()) {
            string = string2;
            if (((Matcher)object).group(1) != null) {
                string = string + ((Matcher)object).group(1);
            }
            if (((Matcher)object).group(2) != null) {
                string = string + ((Matcher)object).group(2);
            }
            return string;
        }
        return null;
    }

    @Override
    public DependencyArtifactDescriptor[] getDependencyArtifacts(String object) {
        object = this.getCollectionForConfiguration((String)object, this.dependencyArtifacts);
        return object.toArray(new DependencyArtifactDescriptor[object.size()]);
    }

    @Override
    public IncludeRule[] getIncludeRules(String object) {
        object = this.getCollectionForConfiguration((String)object, this.includeRules);
        return object.toArray(new IncludeRule[object.size()]);
    }

    @Override
    public ExcludeRule[] getExcludeRules(String object) {
        object = this.getCollectionForConfiguration((String)object, this.excludeRules);
        return object.toArray(new ExcludeRule[object.size()]);
    }

    private Set getCollectionForConfiguration(String object, Map object2) {
        if (object2 == null || object2.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        object = (Collection)object2.get(object);
        object2 = (Collection)object2.get("*");
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        if (object != null) {
            linkedHashSet.addAll(object);
        }
        if (object2 != null) {
            linkedHashSet.addAll(object2);
        }
        return linkedHashSet;
    }

    public ExcludeRule[] getExcludeRules(String[] stringArray) {
        LinkedHashSet<ExcludeRule> linkedHashSet = new LinkedHashSet<ExcludeRule>();
        for (int i = 0; i < stringArray.length; ++i) {
            linkedHashSet.addAll(Arrays.asList(this.getExcludeRules(stringArray[i])));
        }
        LinkedHashSet<ExcludeRule> linkedHashSet2 = linkedHashSet;
        return linkedHashSet2.toArray(new ExcludeRule[linkedHashSet2.size()]);
    }

    @Override
    public DependencyArtifactDescriptor[] getAllDependencyArtifacts() {
        if (this.dependencyArtifacts == null) {
            return new DependencyArtifactDescriptor[0];
        }
        DefaultDependencyDescriptor defaultDependencyDescriptor = this;
        Set set = defaultDependencyDescriptor.mergeAll(defaultDependencyDescriptor.dependencyArtifacts);
        return set.toArray(new DependencyArtifactDescriptor[set.size()]);
    }

    @Override
    public IncludeRule[] getAllIncludeRules() {
        if (this.includeRules == null) {
            return new IncludeRule[0];
        }
        DefaultDependencyDescriptor defaultDependencyDescriptor = this;
        Set set = defaultDependencyDescriptor.mergeAll(defaultDependencyDescriptor.includeRules);
        return set.toArray(new IncludeRule[set.size()]);
    }

    @Override
    public ExcludeRule[] getAllExcludeRules() {
        if (this.excludeRules == null) {
            return new ExcludeRule[0];
        }
        DefaultDependencyDescriptor defaultDependencyDescriptor = this;
        Set set = defaultDependencyDescriptor.mergeAll(defaultDependencyDescriptor.excludeRules);
        return set.toArray(new ExcludeRule[set.size()]);
    }

    private Set mergeAll(Map object) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Collection collection : object.values()) {
            linkedHashSet.addAll(collection);
        }
        return linkedHashSet;
    }

    public void addDependencyConfiguration(String stringArray, String string) {
        Object object;
        if (this.md != null && !"*".equals(stringArray) && !"%".equals(stringArray)) {
            object = stringArray.startsWith("!") ? this.md.getConfiguration(stringArray.substring(1)) : this.md.getConfiguration((String)stringArray);
            if (object == null) {
                throw new IllegalArgumentException("Cannot add dependency '" + this.revId + "' to configuration '" + (String)stringArray + "' of module " + this.md.getModuleRevisionId() + " because this configuration doesn't exist!");
            }
            if (object instanceof ConfigurationGroup) {
                stringArray = (ConfigurationGroup)object;
                stringArray = stringArray.getMembersConfigurationNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addDependencyConfiguration(stringArray[i], string);
                }
                return;
            }
        }
        if ((object = (ArrayList<String>)this.confs.get(stringArray)) == null) {
            object = new ArrayList<String>();
            this.confs.put(stringArray, object);
        }
        if (!object.contains(string)) {
            object.add(string);
        }
    }

    public void addDependencyArtifact(String string, DependencyArtifactDescriptor dependencyArtifactDescriptor) {
        this.addObjectToConfiguration(string, dependencyArtifactDescriptor, this.getDependencyArtifacts());
    }

    public void addIncludeRule(String string, IncludeRule includeRule) {
        this.addObjectToConfiguration(string, includeRule, this.getIncludeRules());
    }

    public void addExcludeRule(String string, ExcludeRule excludeRule) {
        this.doesExcludeCache.clear();
        this.addObjectToConfiguration(string, excludeRule, this.getExcludeRules());
    }

    private void addObjectToConfiguration(String string, Object object, Map map) {
        ArrayList<Object> arrayList = (ArrayList<Object>)map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
            map.put(string, arrayList);
        }
        arrayList.add(object);
    }

    private boolean doDoesExclude(String[] objectArray, ArtifactId artifactId) {
        objectArray = this.getExcludeRules((String[])objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!MatcherHelper.matches(objectArray[i].getMatcher(), objectArray[i].getId(), artifactId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean doesExclude(String[] stringArray, ArtifactId artifactId) {
        String string;
        Boolean bl;
        if (this.namespace != null) {
            artifactId = NameSpaceHelper.transform(artifactId, this.namespace.getFromSystemTransformer());
        }
        if ((bl = (Boolean)this.doesExcludeCache.get(string = Arrays.toString(stringArray) + ":" + artifactId.toString())) == null) {
            bl = this.doDoesExclude(stringArray, artifactId);
            this.doesExcludeCache.put(string, bl);
        }
        return bl;
    }

    @Override
    public boolean canExclude() {
        return this.excludeRules != null && !this.excludeRules.isEmpty();
    }

    public String toString() {
        return "dependency: " + this.revId + " " + this.confs;
    }

    @Override
    public boolean isForce() {
        return this.isForce;
    }

    @Override
    public ModuleRevisionId getParentRevisionId() {
        if (this.md != null) {
            return this.md.getResolvedModuleRevisionId();
        }
        return this.parentId;
    }

    @Override
    public boolean isChanging() {
        return this.isChanging;
    }

    @Override
    public boolean isTransitive() {
        return this.isTransitive;
    }

    public String getAttribute(String string) {
        return this.revId.getAttribute(string);
    }

    @Override
    public Map getAttributes() {
        return this.revId.getAttributes();
    }

    @Override
    public String getExtraAttribute(String string) {
        return this.revId.getExtraAttribute(string);
    }

    @Override
    public Map getExtraAttributes() {
        return this.revId.getExtraAttributes();
    }

    @Override
    public Map getQualifiedExtraAttributes() {
        return this.revId.getQualifiedExtraAttributes();
    }

    private void setDependencyArtifacts(Map map) {
        this.dependencyArtifacts = map;
    }

    private Map getDependencyArtifacts() {
        if (this.dependencyArtifacts == null) {
            this.dependencyArtifacts = new LinkedHashMap();
        }
        return this.dependencyArtifacts;
    }

    private void setIncludeRules(Map map) {
        this.includeRules = map;
    }

    private Map getIncludeRules() {
        if (this.includeRules == null) {
            this.includeRules = new LinkedHashMap();
        }
        return this.includeRules;
    }

    private void setExcludeRules(Map map) {
        this.doesExcludeCache.clear();
        this.excludeRules = map;
    }

    private Map getExcludeRules() {
        if (this.excludeRules == null) {
            this.excludeRules = new LinkedHashMap();
        }
        return this.excludeRules;
    }

    @Override
    public ModuleRevisionId getSourceModule() {
        return this.sourceModule;
    }

    @Override
    public DependencyDescriptor clone(ModuleRevisionId moduleRevisionId) {
        return new DefaultDependencyDescriptor(this, moduleRevisionId);
    }
}

