#!/usr/bin/python

# ----------------------------------------------------------------------------
#
#  Copyright (C) 2008-2022 Fons Adriaensen <fons@linuxaudio.org>
#    
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# ----------------------------------------------------------------------------


import numpy as np
from math import *
from time import sleep
from zita_jacktools.jacksignal import JackSignal


# ----------------------- 1 kHz bursts to test jkmeter --------------------------
#
# Make sure jkmeter is running.

# Create a JackSignal object with 1 output.
#
J = JackSignal("JackSignal")
if J.get_state() < 0:
    print ("Failed to create JackSignal -- is Jack running ?")
    exit(1)

J.create_output (0, "out_1")
J.silence()
J.connect_output (0, "jkmeter:in-1")

# Get Jack info.
#
name, fsamp, period = J.get_jack_info ()

# Create output buffer.
#
size = int (0.5 * fsamp + 0.1)
A = np.empty ([size,], dtype = np.float32)

# Generate 1 kHz sine wave
#
w = 1e3 * 2 * pi / fsamp
for i in range (size):
    A [i] = sin (w * i)

# Generate burst of size t in seconds.
#
def burst (t):
    print ("t = %5.3f" % (t,))
    n = int (t * fsamp + 0.5)
    if n > size: n = size
    J.set_output_data (0, A [0:n])
    J.process()
    J.wait ()

# Run the test.
#
tburst = [0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5]
twait = 5.0 # Let jkmeter fall back.
for t in tburst:
    burst (t)
    sleep (twait)
