# coding: utf-8

"""
    NetHSM
    All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All [base64](https://tools.ietf.org/html/rfc4648#section-4) encoded values are Big Endian.   # noqa: E501
    The version of the OpenAPI document: v1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

from __future__ import annotations
from nethsm.client.shared_imports.schema_imports import *  # pyright: ignore [reportWildcardImportFromLibrary]


from nethsm.client.components.schema import base64
Properties = typing.TypedDict(
    'Properties',
    {
        "modulus": typing.Type[base64.Base64],
        "publicExponent": typing.Type[base64.Base64],
        "data": typing.Type[base64.Base64],
    }
)


class KeyPublicDataDict(schemas.immutabledict[str, schemas.OUTPUT_BASE_TYPES]):

    __required_keys__: typing.FrozenSet[str] = frozenset({
    })
    __optional_keys__: typing.FrozenSet[str] = frozenset({
        "modulus",
        "publicExponent",
        "data",
    })
    
    def __new__(
        cls,
        *,
        modulus: typing.Union[
            str,
            schemas.Unset
        ] = schemas.unset,
        publicExponent: typing.Union[
            str,
            schemas.Unset
        ] = schemas.unset,
        data: typing.Union[
            str,
            schemas.Unset
        ] = schemas.unset,
        configuration_: typing.Optional[schema_configuration.SchemaConfiguration] = None,
        **kwargs: schemas.INPUT_TYPES_ALL,
    ):
        arg_: typing.Dict[str, typing.Any] = {}
        for key_, val in (
            ("modulus", modulus),
            ("publicExponent", publicExponent),
            ("data", data),
        ):
            if isinstance(val, schemas.Unset):
                continue
            arg_[key_] = val
        arg_.update(kwargs)
        used_arg_ = typing.cast(KeyPublicDataDictInput, arg_)
        return KeyPublicData.validate(used_arg_, configuration=configuration_)
    
    @staticmethod
    def from_dict_(
        arg: typing.Union[
            KeyPublicDataDictInput,
            KeyPublicDataDict
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> KeyPublicDataDict:
        return KeyPublicData.validate(arg, configuration=configuration)
    
    @property
    def modulus(self) -> typing.Union[str, schemas.Unset]:
        val = self.get("modulus", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            str,
            val
        )
    
    @property
    def publicExponent(self) -> typing.Union[str, schemas.Unset]:
        val = self.get("publicExponent", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            str,
            val
        )
    
    @property
    def data(self) -> typing.Union[str, schemas.Unset]:
        val = self.get("data", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            str,
            val
        )
    
    def get_additional_property_(self, name: str) -> typing.Union[schemas.OUTPUT_BASE_TYPES, schemas.Unset]:
        schemas.raise_if_key_known(name, self.__required_keys__, self.__optional_keys__)
        return self.get(name, schemas.unset)
KeyPublicDataDictInput = typing.Mapping[str, schemas.INPUT_TYPES_ALL]


@dataclasses.dataclass(frozen=True)
class KeyPublicData(
    schemas.Schema[KeyPublicDataDict, tuple]
):
    """NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
    Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator

    Do not edit the class manually.

    The public key data is either a *modulus* and a *publicExponent* or
a *data* field. The *data* field is used for EC keys.
This field is null for Generic keys.

    """
    types: typing.FrozenSet[typing.Type] = frozenset({schemas.immutabledict})
    properties: Properties = dataclasses.field(default_factory=lambda: schemas.typed_dict_to_instance(Properties)) # type: ignore
    type_to_output_cls: typing.Mapping[
        typing.Type,
        typing.Type
    ] = dataclasses.field(
        default_factory=lambda: {
            schemas.immutabledict: KeyPublicDataDict
        }
    )

    @classmethod
    def validate(
        cls,
        arg: typing.Union[
            KeyPublicDataDictInput,
            KeyPublicDataDict,
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> KeyPublicDataDict:
        return super().validate_base(
            arg,
            configuration=configuration,
        )

