/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.signer.model.RevokedEntitiesCopier;
import software.amazon.awssdk.services.signer.model.SignerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRevocationStatusResponse
extends SignerResponse
implements ToCopyableBuilder<Builder, GetRevocationStatusResponse> {
    private static final SdkField<List<String>> REVOKED_ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("revokedEntities").getter(GetRevocationStatusResponse.getter(GetRevocationStatusResponse::revokedEntities)).setter(GetRevocationStatusResponse.setter(Builder::revokedEntities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revokedEntities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVOKED_ENTITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRevocationStatusResponse.memberNameToFieldInitializer();
    private final List<String> revokedEntities;

    private GetRevocationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.revokedEntities = builder.revokedEntities;
    }

    public final boolean hasRevokedEntities() {
        return this.revokedEntities != null && !(this.revokedEntities instanceof SdkAutoConstructList);
    }

    public final List<String> revokedEntities() {
        return this.revokedEntities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevokedEntities() ? this.revokedEntities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRevocationStatusResponse)) {
            return false;
        }
        GetRevocationStatusResponse other = (GetRevocationStatusResponse)((Object)obj);
        return this.hasRevokedEntities() == other.hasRevokedEntities() && Objects.equals(this.revokedEntities(), other.revokedEntities());
    }

    public final String toString() {
        return ToString.builder((String)"GetRevocationStatusResponse").add("RevokedEntities", this.hasRevokedEntities() ? this.revokedEntities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "revokedEntities": {
                return Optional.ofNullable(clazz.cast(this.revokedEntities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("revokedEntities", REVOKED_ENTITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRevocationStatusResponse, T> g) {
        return obj -> g.apply((GetRevocationStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SignerResponse.BuilderImpl
    implements Builder {
        private List<String> revokedEntities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRevocationStatusResponse model) {
            super(model);
            this.revokedEntities(model.revokedEntities);
        }

        public final Collection<String> getRevokedEntities() {
            if (this.revokedEntities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.revokedEntities;
        }

        public final void setRevokedEntities(Collection<String> revokedEntities) {
            this.revokedEntities = RevokedEntitiesCopier.copy(revokedEntities);
        }

        @Override
        public final Builder revokedEntities(Collection<String> revokedEntities) {
            this.revokedEntities = RevokedEntitiesCopier.copy(revokedEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokedEntities(String ... revokedEntities) {
            this.revokedEntities(Arrays.asList(revokedEntities));
            return this;
        }

        @Override
        public GetRevocationStatusResponse build() {
            return new GetRevocationStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SignerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRevocationStatusResponse> {
        public Builder revokedEntities(Collection<String> var1);

        public Builder revokedEntities(String ... var1);
    }
}

