/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.jcajce.BCLoadStoreParameter;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.ProvBCFKS;
import org.bouncycastle.jcajce.provider.ProvJKS;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.util.io.Streams;

class ProvFipsKS
extends AlgorithmProvider {
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.keystore.FipsKS.";

    ProvFipsKS() {
    }

    @Override
    void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.FIPS", "org.bouncycastle.jcajce.provider.keystore.FipsKS.FIPSKeyStore", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new FIPSKeyStore(false, bouncyCastleFipsProvider);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.IFIPS", "org.bouncycastle.jcajce.provider.keystore.FipsKS.IFIPSKeyStore", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new FIPSKeyStore(true, bouncyCastleFipsProvider);
            }
        });
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.FIPS-DEF", "org.bouncycastle.jcajce.provider.keystore.FipsKS.FIPSDefKeyStore", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new FIPSKeyStore(false, null);
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.IFIPS-DEF", "org.bouncycastle.jcajce.provider.keystore.FipsKS.IFIPDefSKeyStore", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new FIPSKeyStore(true, null);
                }
            }));
        }
    }

    private static class FIPSKeyStore
    extends KeyStoreSpi {
        private final boolean isImmutable;
        private final BouncyCastleFipsProvider provider;
        private KeyStoreSpi keyStore;

        public FIPSKeyStore(boolean bl, BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            this.isImmutable = bl;
            this.provider = bouncyCastleFipsProvider;
        }

        public Enumeration engineAliases() {
            return this.keyStore.engineAliases();
        }

        @Override
        public boolean engineContainsAlias(String string) {
            return this.keyStore.engineContainsAlias(string);
        }

        @Override
        public void engineDeleteEntry(String string) throws KeyStoreException {
            if (this.isImmutable) {
                throw new KeyStoreException("delete operation not supported in immutable mode");
            }
            this.keyStore.engineDeleteEntry(string);
        }

        @Override
        public Certificate engineGetCertificate(String string) {
            return this.keyStore.engineGetCertificate(string);
        }

        @Override
        public String engineGetCertificateAlias(Certificate certificate) {
            return this.keyStore.engineGetCertificateAlias(certificate);
        }

        @Override
        public Certificate[] engineGetCertificateChain(String string) {
            return this.keyStore.engineGetCertificateChain(string);
        }

        @Override
        public Date engineGetCreationDate(String string) {
            return this.keyStore.engineGetCreationDate(string);
        }

        @Override
        public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            return this.keyStore.engineGetKey(string, cArray);
        }

        @Override
        public boolean engineIsCertificateEntry(String string) {
            return this.keyStore.engineIsCertificateEntry(string);
        }

        @Override
        public boolean engineIsKeyEntry(String string) {
            return this.keyStore.engineIsKeyEntry(string);
        }

        @Override
        public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
            if (this.isImmutable) {
                throw new KeyStoreException("set operation not supported in immutable mode");
            }
            this.keyStore.engineSetCertificateEntry(string, certificate);
        }

        @Override
        public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
            if (this.isImmutable) {
                throw new KeyStoreException("set operation not supported in immutable mode");
            }
            this.keyStore.engineSetKeyEntry(string, byArray, certificateArray);
        }

        @Override
        public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
            if (this.isImmutable) {
                throw new KeyStoreException("set operation not supported in immutable mode");
            }
            this.keyStore.engineSetKeyEntry(string, key, cArray, certificateArray);
        }

        @Override
        public int engineSize() {
            return this.keyStore.engineSize();
        }

        @Override
        public void engineSetEntry(String string, KeyStore.Entry entry, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
            if (this.isImmutable) {
                throw new KeyStoreException("set operation not supported in immutable mode");
            }
            this.keyStore.engineSetEntry(string, entry, protectionParameter);
        }

        @Override
        public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
            if (this.keyStore != null && this.isImmutable) {
                throw new IOException("immutable keystore already loaded");
            }
            if (loadStoreParameter == null) {
                this.engineLoad(null, null);
            } else if (loadStoreParameter instanceof BCLoadStoreParameter) {
                BCLoadStoreParameter bCLoadStoreParameter = (BCLoadStoreParameter)loadStoreParameter;
                this.engineLoad(bCLoadStoreParameter.getInputStream(), Utils.extractPassword(loadStoreParameter));
            } else {
                throw new IllegalArgumentException("no support for 'param' of type " + loadStoreParameter.getClass().getName());
            }
        }

        @Override
        public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, CertificateException, NoSuchAlgorithmException {
            if (this.keyStore != null && this.isImmutable) {
                throw new IOException("immutable keystore already loaded");
            }
            if (inputStream == null) {
                if (this.isImmutable) {
                    this.keyStore = new ProvBCFKS.BCFIPSImmutableKeyStoreSpi(this.provider);
                    this.keyStore.engineLoad(null, cArray);
                } else {
                    this.keyStore = new ProvBCFKS.BCFIPSKeyStoreSpi(false, this.provider);
                    this.keyStore.engineLoad(null, cArray);
                }
                return;
            }
            byte[] byArray = Streams.readAll(inputStream);
            if (this.isImmutable) {
                try {
                    this.keyStore = new ProvBCFKS.BCFIPSImmutableKeyStoreSpi(this.provider);
                    this.keyStore.engineLoad((InputStream)new ByteArrayInputStream(byArray), cArray);
                }
                catch (Exception exception) {
                    this.keyStore = new ProvJKS.JKSKeyStoreSpi(false, this.provider);
                    this.keyStore.engineLoad((InputStream)new ByteArrayInputStream(byArray), cArray);
                }
            } else {
                try {
                    this.keyStore = new ProvBCFKS.BCFIPSKeyStoreSpi(false, this.provider);
                    this.keyStore.engineLoad((InputStream)new ByteArrayInputStream(byArray), cArray);
                }
                catch (Exception exception) {
                    this.keyStore = new ProvJKS.JKSKeyStoreSpi(false, this.provider);
                    this.keyStore.engineLoad((InputStream)new ByteArrayInputStream(byArray), cArray);
                }
            }
        }

        @Override
        public void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
            this.keyStore.engineStore(loadStoreParameter);
        }

        @Override
        public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, CertificateException, NoSuchAlgorithmException {
            this.keyStore.engineStore(outputStream, cArray);
        }
    }
}

