/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.checksums.internal;

import java.util.zip.Checksum;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.SdkChecksum;
import software.amazon.awssdk.checksums.internal.CrcCombineFunction;
import software.amazon.awssdk.utils.NumericUtils;

@SdkInternalApi
public class CrcCombineOnMarkChecksum
implements SdkChecksum {
    private final Checksum crc;
    private long dataLengthForChecksum = 0L;
    private Long crcAtMark;
    private long markedDataLength = 0L;
    private boolean isResetDone = false;
    private final CrcCombineFunction crcCombineFunction;

    public CrcCombineOnMarkChecksum(Checksum checksum, CrcCombineFunction crcCombineFunction) {
        this.crc = checksum;
        this.crcCombineFunction = crcCombineFunction;
    }

    @Override
    public byte[] getChecksumBytes() {
        byte[] valueBytes = NumericUtils.longToByte((Long)this.getValue());
        return new byte[]{valueBytes[4], valueBytes[5], valueBytes[6], valueBytes[7]};
    }

    @Override
    public void mark(int readLimit) {
        if (this.dataLengthForChecksum > 0L) {
            this.saveMarkState();
        }
    }

    @Override
    public void update(int b) {
        this.crc.update(b);
        ++this.dataLengthForChecksum;
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.crc.update(b, off, len);
        this.dataLengthForChecksum += (long)len;
    }

    @Override
    public long getValue() {
        if (this.canRestoreMarkedState()) {
            return this.crcCombineFunction.combine(this.crcAtMark, this.crc.getValue(), this.dataLengthForChecksum - this.markedDataLength);
        }
        return this.crc.getValue();
    }

    @Override
    public void reset() {
        if (this.crcAtMark != null) {
            this.crc.reset();
            this.dataLengthForChecksum = this.markedDataLength;
        } else {
            this.crc.reset();
            this.dataLengthForChecksum = 0L;
        }
        this.isResetDone = true;
    }

    private void saveMarkState() {
        this.crcAtMark = this.crc.getValue();
        this.markedDataLength = this.dataLengthForChecksum;
    }

    private boolean canRestoreMarkedState() {
        return this.crcAtMark != null && this.isResetDone;
    }
}

