"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sampleVisualizations = exports.sampleQueries = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const sampleVisualizations = exports.sampleVisualizations = [{
  name: '[Logs] Daily average bytes',
  description: '',
  query: 'source = opensearch_dashboards_sample_data_logs | stats avg(bytes) by span(timestamp,1d)',
  type: 'line',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Daily count for error response codes',
  description: '',
  query: "source = opensearch_dashboards_sample_data_logs | where response='503' or response='404' | stats count() by span(timestamp,1d)",
  type: 'bar',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Average ram usage by operating systems',
  description: '',
  query: 'source = opensearch_dashboards_sample_data_logs |  stats avg(machine.ram) by machine.os',
  type: 'horizontal_bar',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Average ram usage per day by apple os',
  description: '',
  query: "source = opensearch_dashboards_sample_data_logs | where machine.os='osx' or  machine.os='ios' |  stats avg(machine.ram) by span(timestamp,1d)",
  type: 'line',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Average ram usage per day by windows os ',
  description: '',
  query: "source = opensearch_dashboards_sample_data_logs | where match(machine.os,'win')  |  stats avg(machine.ram) by span(timestamp,1d)",
  type: 'line',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Count requests from US to CN, IN and JP',
  description: '',
  query: "source = opensearch_dashboards_sample_data_logs | where geo.src='US' | where geo.dest='JP' or geo.dest='CN' or geo.dest='IN' | stats count() by geo.dest",
  type: 'bar',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Count total requests by tags ',
  description: '',
  query: 'source = opensearch_dashboards_sample_data_logs | stats count() by tags',
  type: 'bar',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Max and average bytes by host',
  description: '',
  query: 'source = opensearch_dashboards_sample_data_logs | stats max(bytes), avg(bytes) by host',
  type: 'line',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}];
const sampleQueries = exports.sampleQueries = [{
  name: '[Flights] Show all flights sorted by most delayed',
  description: '',
  query: 'source=opensearch_dashboards_sample_data_flights  | sort -FlightDelayMin',
  selected_date_range: {
    start: 'now/M',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: [{
      name: 'Carrier',
      type: 'string'
    }, {
      name: 'Dest',
      type: 'string'
    }, {
      name: 'DestAirportID',
      type: 'string'
    }, {
      name: 'FlightDelayMin',
      type: 'integer'
    }, {
      name: 'OriginAirportID',
      type: 'string'
    }]
  }
}, {
  name: '[Logs] Show all logs lines where error code is 404 or 503',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs | where response='503' or response='404'",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show all logs lines where error code is 404 or 503 and deduplicate consecutive entries only',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs | where response='503' or response='404' | dedup host consecutive=true",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show all hosts with errors  aggregated by response, count of ips and tags',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs |  where response='503' or response='404' |  stats count() as ip_count by response , host , tags",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Flights] Show the count of flights by Destination and Country',
  description: '',
  query: 'source=opensearch_dashboards_sample_data_flights  | stats count() by DestCountry , Dest',
  selected_date_range: {
    start: 'now/M',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Flights] Show all Carriers sorted by average delay',
  description: '',
  query: 'source=opensearch_dashboards_sample_data_flights |where FlightDelayMin > 0 | stats sum(FlightDelayMin) as total_delay_min, count() as total_delayed by Carrier |eval avg_delay=total_delay_min / total_delayed | sort - avg_delay',
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show errors sorted by list of hostnames and average bytes per ip',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs  | where response='503' or response='404' |      stats count() as ip_count, sum(bytes)       as sum_bytes by host, response |       rename response as resp_code |       sort - ip_count, + sum_bytes |       eval per_ip_bytes=sum_bytes/ip_count",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show errors sorted by list of hostnames, by summation of bytes',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs | where response='503' or response='404' |      stats count() as ip_count, sum(bytes)      as sum_bytes by host, response | sort -sum_bytes",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show errors sorted by list of hostnames, by summation of bytes and complex evals',
  description: '',
  query: "source=opensearch_dashboards_sample_data_logs | where response='503' or response='404' |      stats count() as ip_count, sum(bytes)      as sum_bytes by host, response |      rename response as resp_code |      sort - ip_count, + sum_bytes |      eval per_ip_bytes=sum_bytes/ip_count,       double_per_ip_bytes = 2 * per_ip_bytes",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: []
  }
}, {
  name: '[Logs] Show all logs where request matches filebeat',
  description: '',
  query: "source = opensearch_dashboards_sample_data_logs | where match(request,'filebeat')",
  selected_date_range: {
    start: 'now/y',
    end: 'now',
    text: ''
  },
  selected_timestamp: {
    name: 'timestamp',
    type: 'timestamp'
  },
  selected_fields: {
    text: '',
    tokens: [{
      name: 'message',
      type: 'string'
    }]
  }
}];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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