/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import java.io.IOException;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.notifications.model.BaseConfigData;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.commons.notifications.model.ConfigType;
import org.opensearch.commons.notifications.model.config.ConfigDataProperties;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.XContentHelpersKt;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B1\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\rH\u00c6\u0003J=\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0006H\u00d6\u0001J\u001c\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010$2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006-"}, d2={"Lorg/opensearch/commons/notifications/model/NotificationConfig;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "name", "", "description", "configType", "Lorg/opensearch/commons/notifications/model/ConfigType;", "configData", "Lorg/opensearch/commons/notifications/model/BaseConfigData;", "isEnabled", "", "(Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/commons/notifications/model/ConfigType;Lorg/opensearch/commons/notifications/model/BaseConfigData;Z)V", "getConfigData", "()Lorg/opensearch/commons/notifications/model/BaseConfigData;", "getConfigType", "()Lorg/opensearch/commons/notifications/model/ConfigType;", "getDescription", "()Ljava/lang/String;", "()Z", "getName", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "output", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
@SourceDebugExtension(value={"SMAP\nNotificationConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationConfig.kt\norg/opensearch/commons/notifications/model/NotificationConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1#2:144\n*E\n"})
public final class NotificationConfig
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @NotNull
    private final ConfigType configType;
    @Nullable
    private final BaseConfigData configData;
    private final boolean isEnabled;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(NotificationConfig.class);
    @NotNull
    private static final Writeable.Reader<NotificationConfig> reader = NotificationConfig::reader$lambda$1;

    public NotificationConfig(@NotNull String name, @NotNull String description, @NotNull ConfigType configType, @Nullable BaseConfigData configData, boolean isEnabled) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)((Object)configType), (String)"configType");
        this.name = name;
        this.description = description;
        this.configType = configType;
        this.configData = configData;
        this.isEnabled = isEnabled;
        if (!(!Strings.isNullOrEmpty((String)this.name))) {
            boolean bl = false;
            String string = "name is null or empty";
            throw new IllegalArgumentException(string.toString());
        }
        if (!ConfigDataProperties.INSTANCE.validateConfigData(this.configType, this.configData)) {
            throw new IllegalArgumentException("ConfigType: " + this.configType + " and data doesn't match");
        }
        if (this.configType == ConfigType.NONE) {
            NotificationConfig.Companion.getLog().info("Some config field not recognized");
        }
    }

    public /* synthetic */ NotificationConfig(String string, String string2, ConfigType configType, BaseConfigData baseConfigData, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(string, string2, configType, baseConfigData, bl);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final ConfigType getConfigType() {
        return this.configType;
    }

    @Nullable
    public final BaseConfigData getConfigData() {
        return this.configData;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        XContentBuilder xContentBuilder = builder.startObject().field("name", this.name).field("description", this.description).field("config_type", this.configType.getTag()).field("is_enabled", this.isEnabled);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026S_ENABLED_TAG, isEnabled)");
        XContentBuilder xContentBuilder2 = XContentHelpersKt.fieldIfNotNull(xContentBuilder, this.configType.getTag(), this.configData).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.startObject()\n  \u2026\n            .endObject()");
        return xContentBuilder2;
    }

    public NotificationConfig(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input.readString();
        String string2 = input.readString();
        ConfigType configType = (ConfigType)input.readEnum(ConfigType.class);
        boolean bl = input.readBoolean();
        Enum enum_ = input.readEnum(ConfigType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"input.readEnum(ConfigType::class.java)");
        BaseConfigData baseConfigData = (BaseConfigData)input.readOptionalWriteable(ConfigDataProperties.INSTANCE.getReaderForConfigType((ConfigType)enum_));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString()");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString()");
        Intrinsics.checkNotNullExpressionValue((Object)((Object)configType), (String)"readEnum(ConfigType::class.java)");
        this(string, string2, configType, baseConfigData, bl);
    }

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeString(this.name);
        output.writeString(this.description);
        output.writeEnum((Enum)this.configType);
        output.writeBoolean(this.isEnabled);
        output.writeEnum((Enum)this.configType);
        output.writeOptionalWriteable((Writeable)this.configData);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.description;
    }

    @NotNull
    public final ConfigType component3() {
        return this.configType;
    }

    @Nullable
    public final BaseConfigData component4() {
        return this.configData;
    }

    public final boolean component5() {
        return this.isEnabled;
    }

    @NotNull
    public final NotificationConfig copy(@NotNull String name, @NotNull String description, @NotNull ConfigType configType, @Nullable BaseConfigData configData, boolean isEnabled) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)((Object)configType), (String)"configType");
        return new NotificationConfig(name, description, configType, configData, isEnabled);
    }

    public static /* synthetic */ NotificationConfig copy$default(NotificationConfig notificationConfig, String string, String string2, ConfigType configType, BaseConfigData baseConfigData, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = notificationConfig.name;
        }
        if ((n & 2) != 0) {
            string2 = notificationConfig.description;
        }
        if ((n & 4) != 0) {
            configType = notificationConfig.configType;
        }
        if ((n & 8) != 0) {
            baseConfigData = notificationConfig.configData;
        }
        if ((n & 0x10) != 0) {
            bl = notificationConfig.isEnabled;
        }
        return notificationConfig.copy(string, string2, configType, baseConfigData, bl);
    }

    @NotNull
    public String toString() {
        return "NotificationConfig(name=" + this.name + ", description=" + this.description + ", configType=" + this.configType + ", configData=" + this.configData + ", isEnabled=" + this.isEnabled + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.description.hashCode();
        result = result * 31 + this.configType.hashCode();
        result = result * 31 + (this.configData == null ? 0 : this.configData.hashCode());
        int n = this.isEnabled ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NotificationConfig)) {
            return false;
        }
        NotificationConfig notificationConfig = (NotificationConfig)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)notificationConfig.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)notificationConfig.description)) {
            return false;
        }
        if (this.configType != notificationConfig.configType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.configData, (Object)notificationConfig.configData)) {
            return false;
        }
        return this.isEnabled == notificationConfig.isEnabled;
    }

    private static final NotificationConfig reader$lambda$1(StreamInput it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return new NotificationConfig(it);
    }

    @JvmStatic
    @NotNull
    public static final NotificationConfig parse(@NotNull XContentParser parser) throws IOException {
        return Companion.parse(parser);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/commons/notifications/model/NotificationConfig$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/NotificationConfig;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "parse", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<NotificationConfig> getReader() {
            return reader;
        }

        @JvmStatic
        @NotNull
        public final NotificationConfig parse(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            String name = null;
            String description = "";
            ConfigType configType = null;
            boolean isEnabled = true;
            BaseConfigData configData = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block20: {
                    fieldName = parser.currentName();
                    parser.nextToken();
                    String string = fieldName;
                    if (string == null) break block20;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -109284052: {
                            if (string.equals("is_enabled")) {
                                n = 1;
                            }
                            break;
                        }
                        case 3373707: {
                            if (string.equals("name")) {
                                n = 2;
                            }
                            break;
                        }
                        case -1724546052: {
                            if (string.equals("description")) {
                                n = 3;
                            }
                            break;
                        }
                        case 17530391: {
                            if (string.equals("config_type")) {
                                n = 4;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            name = parser.text();
                            continue block12;
                        }
                        case 3: {
                            Intrinsics.checkNotNullExpressionValue((Object)parser.text(), (String)"parser.text()");
                            continue block12;
                        }
                        case 4: {
                            String string2 = parser.text();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parser.text()");
                            configType = ConfigType.Companion.fromTagOrDefault(string2);
                            continue block12;
                        }
                        case 1: {
                            isEnabled = parser.booleanValue();
                            continue block12;
                        }
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)fieldName, (String)"fieldName");
                ConfigType configTypeForTag = ConfigType.Companion.fromTagOrDefault(fieldName);
                if (configTypeForTag != ConfigType.NONE && configData == null) {
                    configData = ConfigDataProperties.INSTANCE.createConfigData(configTypeForTag, parser);
                    continue;
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing configuration");
            }
            if (name == null) {
                throw new IllegalArgumentException("name field absent");
            }
            if (configType == null) {
                throw new IllegalArgumentException("config_type field absent");
            }
            return new NotificationConfig(name, description, configType, configData, isEnabled);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

