/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.indices;

import java.util.function.Supplier;
import org.opensearch.forecast.indices.ForecastIndexManagement;
import org.opensearch.timeseries.function.ThrowingSupplierWrapper;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.indices.TimeSeriesIndex;

public enum ForecastIndex implements TimeSeriesIndex
{
    RESULT("opensearch-forecast-results", true, ThrowingSupplierWrapper.throwingSupplierWrapper(ForecastIndexManagement::getResultMappings)),
    CONFIG(".opensearch-forecasters", false, ThrowingSupplierWrapper.throwingSupplierWrapper(IndexManagement::getConfigMappings)),
    JOB(".opendistro-anomaly-detector-jobs", false, ThrowingSupplierWrapper.throwingSupplierWrapper(IndexManagement::getJobMappings)),
    CHECKPOINT(".opensearch-forecast-checkpoints", false, ThrowingSupplierWrapper.throwingSupplierWrapper(ForecastIndexManagement::getCheckpointMappings)),
    STATE(".opensearch-forecast-state", false, ThrowingSupplierWrapper.throwingSupplierWrapper(ForecastIndexManagement::getStateMappings)),
    CUSTOM_RESULT("custom_result_index", true, ThrowingSupplierWrapper.throwingSupplierWrapper(ForecastIndexManagement::getResultMappings));

    private final String indexName;
    private final boolean alias;
    private final String mapping;

    private ForecastIndex(String name, boolean alias, Supplier<String> mappingSupplier) {
        this.indexName = name;
        this.alias = alias;
        this.mapping = mappingSupplier.get();
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public boolean isAlias() {
        return this.alias;
    }

    @Override
    public String getMapping() {
        return this.mapping;
    }

    @Override
    public boolean isConfigIndex() {
        return ".opensearch-forecasters".equals(this.getIndexName());
    }
}

