/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.util.ArrayList;
import org.directwebremoting.ConversionException;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.ErrorOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;

public class ScriptBufferUtil {
    private ScriptBufferUtil() {
    }

    public static String createOutput(ScriptBuffer buffer, ConverterManager converterManager) throws ConversionException {
        return ScriptBufferUtil.createOutput(buffer, converterManager, false);
    }

    public static String createOutput(ScriptBuffer script, ConverterManager converterManager, boolean jsonOutput) throws ConversionException {
        OutboundContext context = new OutboundContext(jsonOutput);
        ArrayList<OutboundVariable> scriptParts = new ArrayList<OutboundVariable>();
        boolean outboundError = false;
        int variableCount = 0;
        for (Object part : script.getParts()) {
            OutboundVariable ov = converterManager.convertOutbound(part, context);
            if (ov instanceof ErrorOutboundVariable) {
                outboundError = true;
            }
            scriptParts.add(ov);
            ++variableCount;
        }
        StringBuilder buffer = new StringBuilder();
        for (OutboundVariable ov : scriptParts) {
            buffer.append(ov.getDeclareCode());
        }
        for (OutboundVariable ov : scriptParts) {
            buffer.append(ov.getBuildCode());
        }
        for (OutboundVariable ov : scriptParts) {
            String assignCode = ov.getAssignCode();
            if (assignCode == null) {
                throw new NullPointerException();
            }
            buffer.append(assignCode);
        }
        String output = buffer.toString();
        if (jsonOutput && !output.startsWith("{") && !output.startsWith("[")) {
            if (outboundError) {
                output = output.replaceFirst("null", "{}");
                output = "{\"error\":" + output + "}";
            } else {
                output = "{ \"reply\":" + output + "}";
            }
        }
        return output;
    }
}

