/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public abstract class ValueSourceScorer
extends Scorer {
    private static final int DEF_COST = 5;
    protected final FunctionValues values;
    private final TwoPhaseIterator twoPhaseIterator;
    private final DocIdSetIterator disi;

    protected ValueSourceScorer(Weight weight, LeafReaderContext readerContext, FunctionValues values2) {
        super(weight);
        this.values = values2;
        DocIdSetIterator approximation = DocIdSetIterator.all(readerContext.reader().maxDoc());
        this.twoPhaseIterator = new TwoPhaseIterator(approximation){

            @Override
            public boolean matches() throws IOException {
                return ValueSourceScorer.this.matches(this.approximation.docID());
            }

            @Override
            public float matchCost() {
                return ValueSourceScorer.this.matchCost();
            }
        };
        this.disi = TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator);
    }

    public abstract boolean matches(int var1) throws IOException;

    @Override
    public DocIdSetIterator iterator() {
        return this.disi;
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return this.twoPhaseIterator;
    }

    @Override
    public int docID() {
        return this.disi.docID();
    }

    @Override
    public float score() throws IOException {
        float score = this.values.floatVal(this.disi.docID());
        return score > Float.NEGATIVE_INFINITY ? score : -3.4028235E38f;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return Float.POSITIVE_INFINITY;
    }

    protected float matchCost() {
        return 5.0f + this.values.cost();
    }
}

