/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.document.LongHashSet;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

abstract class SortedNumericDocValuesSetQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(SortedNumericDocValuesSetQuery.class);
    private final String field;
    private final LongHashSet numbers;

    SortedNumericDocValuesSetQuery(String field, long[] numbers) {
        this.field = Objects.requireNonNull(field);
        this.numbers = new LongHashSet(numbers);
    }

    @Override
    public boolean equals(Object other) {
        if (!this.sameClassAs(other)) {
            return false;
        }
        SortedNumericDocValuesSetQuery that = (SortedNumericDocValuesSetQuery)other;
        return this.field.equals(that.field) && this.numbers.equals(that.numbers);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + Objects.hash(this.field, this.numbers);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String defaultField) {
        return this.field + ": " + this.numbers.toString();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.field) + RamUsageEstimator.sizeOfObject(this.numbers);
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        if (this.numbers.size() == 0) {
            return new MatchNoDocsQuery();
        }
        return super.rewrite(indexReader);
    }

    abstract SortedNumericDocValues getValues(LeafReader var1, String var2) throws IOException;

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, SortedNumericDocValuesSetQuery.this.field);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values2 = SortedNumericDocValuesSetQuery.this.getValues(context.reader(), SortedNumericDocValuesSetQuery.this.field);
                if (values2 == null) {
                    return null;
                }
                final NumericDocValues singleton = DocValues.unwrapSingleton(values2);
                TwoPhaseIterator iterator2 = singleton != null ? new TwoPhaseIterator(singleton){

                    @Override
                    public boolean matches() throws IOException {
                        return SortedNumericDocValuesSetQuery.this.numbers.contains(singleton.longValue());
                    }

                    @Override
                    public float matchCost() {
                        return 5.0f;
                    }
                } : new TwoPhaseIterator(values2){

                    @Override
                    public boolean matches() throws IOException {
                        int count = values2.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            if (!SortedNumericDocValuesSetQuery.this.numbers.contains(values2.nextValue())) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 5.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, iterator2);
            }
        };
    }
}

