/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mainwindow;

import com.sun.jna.platform.win32.VersionHelpers;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Taskbar;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.stage.Stage;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mediathek.Main;
import mediathek.config.Config;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.Konstanten;
import mediathek.config.MVColor;
import mediathek.config.StandardLocations;
import mediathek.controller.history.SeenHistoryController;
import mediathek.controller.starter.Start;
import mediathek.daten.DatenDownload;
import mediathek.daten.IndexedFilmList;
import mediathek.daten.ListeFilme;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.filmlisten.FilmeLaden;
import mediathek.filmlisten.reader.FilmListReader;
import mediathek.gui.MVTray;
import mediathek.gui.actions.CreateNewAboAction;
import mediathek.gui.actions.DeleteLocalFilmlistAction;
import mediathek.gui.actions.EditBlacklistAction;
import mediathek.gui.actions.LoadFilmListAction;
import mediathek.gui.actions.ManageAboAction;
import mediathek.gui.actions.ManageBookmarkAction;
import mediathek.gui.actions.MemoryMonitorAction;
import mediathek.gui.actions.QuitAction;
import mediathek.gui.actions.ResetFilterDialogPosition;
import mediathek.gui.actions.ResetSettingsAction;
import mediathek.gui.actions.SearchProgramUpdateAction;
import mediathek.gui.actions.SettingsAction;
import mediathek.gui.actions.ShowAboHistoryAction;
import mediathek.gui.actions.ShowAboutAction;
import mediathek.gui.actions.ShowBandwidthUsageAction;
import mediathek.gui.actions.ShowFilmInformationAction;
import mediathek.gui.actions.ShowOnlineHelpAction;
import mediathek.gui.actions.ShowProgramInfosAction;
import mediathek.gui.actions.ToggleBlacklistAction;
import mediathek.gui.actions.ToggleDarkModeAction;
import mediathek.gui.actions.export.ExportDecompressedFilmlistAction;
import mediathek.gui.actions.export.ExportReadableFilmlistAction;
import mediathek.gui.actions.import_actions.ImportOldAbosAction;
import mediathek.gui.actions.import_actions.ImportOldBlacklistAction;
import mediathek.gui.actions.import_actions.ImportOldReplacementListAction;
import mediathek.gui.dialog.DialogBeenden;
import mediathek.gui.dialog.LoadFilmListDialog;
import mediathek.gui.dialogEinstellungen.DialogEinstellungen;
import mediathek.gui.filmInformation.InfoDialog;
import mediathek.gui.history.ResetAboHistoryAction;
import mediathek.gui.history.ResetDownloadHistoryAction;
import mediathek.gui.messages.BaseEvent;
import mediathek.gui.messages.DownloadFinishedEvent;
import mediathek.gui.messages.DownloadStartEvent;
import mediathek.gui.messages.FilmListReadStartEvent;
import mediathek.gui.messages.FilmListReadStopEvent;
import mediathek.gui.messages.FilmListWriteStartEvent;
import mediathek.gui.messages.FilmListWriteStopEvent;
import mediathek.gui.messages.InstallTabSwitchListenerEvent;
import mediathek.gui.messages.NotificationCenterChangeEvent;
import mediathek.gui.messages.TabVisualSettingsChangedEvent;
import mediathek.gui.messages.TableModelChangeEvent;
import mediathek.gui.messages.UpdateStateChangedEvent;
import mediathek.gui.tabs.tab_downloads.GuiDownloads;
import mediathek.gui.tabs.tab_film.GuiFilme;
import mediathek.gui.tasks.BlacklistFilterWorker;
import mediathek.gui.tasks.LuceneIndexWorker;
import mediathek.gui.tasks.RefreshAboWorker;
import mediathek.javafx.tool.JFXHiddenApplication;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.mainwindow.FixedRedrawStatusBar;
import mediathek.mainwindow.FontManager;
import mediathek.mainwindow.ListSelectedItemsProperty;
import mediathek.mainwindow.Log4jShutdownHookThread;
import mediathek.mainwindow.MenuTabSwitchListener;
import mediathek.mainwindow.PositionSavingTabbedPane;
import mediathek.mainwindow.ShutdownDialogController;
import mediathek.mainwindow.WindowLocationConfigSaverListener;
import mediathek.res.GetIcon;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.FilmListUpdateType;
import mediathek.tool.Filter;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MessageBus;
import mediathek.tool.RuntimeStatistics;
import mediathek.tool.ShutdownState;
import mediathek.tool.TABS;
import mediathek.tool.TimerPool;
import mediathek.tool.UIProgressState;
import mediathek.tool.notification.GenericNotificationCenter;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.NullNotificationCenter;
import mediathek.tool.threads.IndicatorThread;
import mediathek.update.AutomaticFilmlistUpdate;
import mediathek.update.ProgramUpdateCheck;
import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexWriter;
import org.jetbrains.annotations.NotNull;

public class MediathekGui
extends JFrame {
    protected static final Logger logger = LogManager.getLogger();
    private static final String ICON_NAME = "MediathekView.png";
    private static final String ICON_PATH = "/mediathek/res/";
    private static final int ICON_WIDTH = 58;
    private static final int ICON_HEIGHT = 58;
    private static final String KEY_F10 = "F10";
    private static final String NONE = "none";
    private static final int MIN_WINDOW_WIDTH = 800;
    private static final int MIN_WINDOW_HEIGHT = 600;
    private static MediathekGui ui;
    public final LoadFilmListAction loadFilmListAction;
    protected final AtomicInteger numDownloadsStarted = new AtomicInteger(0);
    protected final Daten daten = Daten.getInstance();
    protected final PositionSavingTabbedPane tabbedPane = new PositionSavingTabbedPane();
    protected final JMenu jMenuHilfe = new JMenu();
    protected final SettingsAction settingsAction = new SettingsAction(this);
    final JMenu fontMenu = new JMenu("Schrift");
    private final JMenu jMenuDatei = new JMenu();
    private final JMenu jMenuFilme = new JMenu();
    private final JMenuBar jMenuBar = new JMenuBar();
    private final JMenu jMenuDownload = new JMenu();
    private final JMenu jMenuAbos = new JMenu();
    private final JMenu jMenuAnsicht = new JMenu();
    private final HashMap<JMenu, MenuTabSwitchListener> menuListeners = new HashMap();
    private final SearchProgramUpdateAction searchProgramUpdateAction;
    private final MemoryMonitorAction showMemoryMonitorAction = new MemoryMonitorAction(this);
    private final InfoDialog filmInfo;
    private final ManageAboAction manageAboAction = new ManageAboAction();
    private final ShowBandwidthUsageAction showBandwidthUsageAction = new ShowBandwidthUsageAction(this);
    public FixedRedrawStatusBar swingStatusBar;
    public GuiFilme tabFilme;
    public GuiDownloads tabDownloads;
    public EditBlacklistAction editBlacklistAction = new EditBlacklistAction(this);
    public ToggleBlacklistAction toggleBlacklistAction = new ToggleBlacklistAction();
    public ShowFilmInformationAction showFilmInformationAction = new ShowFilmInformationAction();
    public ListSelectedItemsProperty selectedListItemsProperty = new ListSelectedItemsProperty(0L);
    public JLabel progressLabel = new JLabel();
    public JProgressBar progressBar = new JProgressBar();
    protected Configuration config = ApplicationConfiguration.getConfiguration();
    protected JToolBar commonToolBar = new JToolBar();
    protected ManageBookmarkAction manageBookmarkAction = new ManageBookmarkAction(this);
    protected FontManager fontManager = new FontManager(this);
    protected ToggleDarkModeAction toggleDarkModeAction = new ToggleDarkModeAction();
    private MVTray tray;
    private DialogEinstellungen dialogEinstellungen;
    private ProgramUpdateCheck programUpdateChecker;
    private IndicatorThread progressIndicatorThread;
    private AutomaticFilmlistUpdate automaticFilmlistUpdate;
    private boolean shutdownRequested;

    public MediathekGui() {
        ui = this;
        this.setDefaultCloseOperation(0);
        this.setupScrollBarWidth();
        UIManager.put("TabbedPane.showTabSeparators", true);
        this.setupAlternatingRowColors();
        this.loadFilmListAction = new LoadFilmListAction(this);
        this.searchProgramUpdateAction = new SearchProgramUpdateAction();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_MAINWINDOW));
        this.getContentPane().setLayout(new BorderLayout());
        this.setIconAndWindowImage();
        this.createMenuBar();
        this.remapF10Key();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.WAIT_FOR_HISTORY_DATA));
        try {
            this.daten.waitForHistoryDataLoadingToComplete();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("waitForHistoryDataLoadingToComplete()", (Throwable)e);
        }
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.CREATE_STATUS_BAR));
        this.createStatusBar();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.SETUP_FILM_LISTENERS));
        this.setupFilmListListener();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_TABS));
        this.initTabs();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.INIT_MENUS));
        this.initMenus();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_MEMORY_MONITOR));
        this.createMemoryMonitor();
        this.setupNotificationCenter();
        this.createCommonToolBar();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.FINISHED));
        this.workaroundJavaFxInitializationBug();
        MBassador<BaseEvent> messageBus = MessageBus.getMessageBus();
        messageBus.publishAsync(new TableModelChangeEvent(true));
        messageBus.subscribe(this);
        SwingUtilities.invokeLater(() -> {
            if (Taskbar.isTaskbarSupported()) {
                this.setupTaskbarMenu();
            }
        });
        this.setupSystemTray();
        SwingUtilities.invokeLater(this::setApplicationWindowSize);
        this.loadFilmlist();
        this.setupUpdateCheck(this.config.getBoolean("application.automatic_update_check", true));
        this.setupShutdownHook();
        this.checkInvalidRegularExpressions();
        logger.trace("Loading bandwidth monitor");
        if (this.config.getBoolean("application.ui.bandwidth_monitor.visible", false)) {
            this.showBandwidthUsageAction.actionPerformed(null);
        }
        logger.trace("Finished loading bandwidth monitor");
        logger.trace("Loading info dialog");
        this.filmInfo = new InfoDialog((Window)this);
        logger.trace("Finished loading info dialog");
    }

    public static MediathekGui ui() {
        return ui;
    }

    protected void setupScrollBarWidth() {
        UIManager.put("ScrollBar.width", 16);
    }

    public void setupAlternatingRowColors() {
        boolean installAlternateRowColor;
        if (SystemUtils.IS_OS_WINDOWS && VersionHelpers.IsWindows8OrGreater()) {
            installAlternateRowColor = true;
        } else {
            boolean bl = installAlternateRowColor = SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_LINUX;
        }
        if (installAlternateRowColor) {
            UIManager.put("Table.alternateRowColor", MVColor.getAlternatingRowColor());
        }
    }

    protected void createCommonToolBar() {
        this.commonToolBar.add(this.loadFilmListAction);
        this.commonToolBar.add(this.showFilmInformationAction);
        this.commonToolBar.add(this.toggleBlacklistAction);
        this.commonToolBar.addSeparator();
        this.commonToolBar.add(this.editBlacklistAction);
        this.commonToolBar.add(this.manageAboAction);
        this.commonToolBar.add(this.manageBookmarkAction);
        this.commonToolBar.addSeparator();
        this.commonToolBar.add(this.settingsAction);
        this.commonToolBar.add(Box.createHorizontalGlue());
        this.commonToolBar.add(this.toggleDarkModeAction);
        if (!SystemUtils.IS_OS_MAC_OSX) {
            this.commonToolBar.setFloatable(true);
            this.commonToolBar.setName("Allgemein");
        }
        if (!SystemUtils.IS_OS_MAC_OSX) {
            this.tabbedPane.putClientProperty("JTabbedPane.trailingComponent", this.commonToolBar);
        } else {
            this.getContentPane().add((Component)this.commonToolBar, "First");
        }
    }

    private void checkInvalidRegularExpressions() {
        TimerPool.getTimerPool().schedule(() -> {
            if (Filter.regExpErrorsOccured()) {
                String regexStr = Filter.regExpErrorList.stream().reduce("", (p, e) -> p + "\n" + e);
                String message = String.format("W\u00e4hrend des Starts wurden ung\u00fcltige regul\u00e4re Ausdr\u00fccke (RegExp) in Ihrer Blacklist und/oder Abos entdeckt.\nSie m\u00fcssen diese korrigieren, ansonsten funktioniert das Programm nicht fehlerfrei!\n\nNachfolgende Ausdr\u00fccke sind fehlerbehaftet: %s\n", regexStr);
                Filter.regExpErrorList.clear();
                JOptionPane.showMessageDialog(this, message, "MediathekView", 0);
            }
        }, 15L, TimeUnit.SECONDS);
    }

    private void setupNotificationCenter() {
        INotificationCenter notificationCenter = this.daten.notificationCenter();
        boolean showNotifications = this.config.getBoolean("application.notifications.show", true);
        if (notificationCenter != null) {
            try {
                notificationCenter.close();
            }
            catch (IOException e) {
                logger.error("Failed to close old notification center", (Throwable)e);
            }
        }
        if (!showNotifications) {
            this.daten.setNotificationCenter(new NullNotificationCenter());
        } else {
            this.daten.setNotificationCenter(this.getNotificationCenter());
        }
    }

    protected INotificationCenter getNotificationCenter() {
        return new GenericNotificationCenter();
    }

    @Handler
    protected void handleNotificationCenterChangeEvent(NotificationCenterChangeEvent e) {
        this.setupNotificationCenter();
    }

    protected void closeNotificationCenter() {
        try {
            INotificationCenter center = this.daten.notificationCenter();
            if (center != null) {
                center.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setupShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Log4jShutdownHookThread());
    }

    private void setupSystemTray() {
        SwingUtilities.invokeLater(() -> {
            this.initializeSystemTray();
            this.initWindowListenerForTray();
        });
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    private void setupTaskbarMenu() {
        Taskbar taskbar = Taskbar.getTaskbar();
        if (taskbar.isSupported(Taskbar.Feature.MENU)) {
            PopupMenu popupMenu = taskbar.getMenu();
            if (popupMenu == null) {
                popupMenu = new PopupMenu();
            }
            MenuItem miLoadNewFilmlist = new MenuItem("Neue Filmliste laden");
            miLoadNewFilmlist.addActionListener(e -> this.performFilmListLoadOperation(false));
            popupMenu.addSeparator();
            popupMenu.add(miLoadNewFilmlist);
            taskbar.setMenu(popupMenu);
        }
    }

    private void setIconAndWindowImage() {
        this.setWindowTitle();
        this.setIconImage(GetIcon.getIcon(ICON_NAME, ICON_PATH, 58, 58).getImage());
    }

    private void remapF10Key() {
        InputMap im = this.jMenuBar.getInputMap(2);
        im.put(KeyStroke.getKeyStroke(KEY_F10), NONE);
    }

    private void createMenuBar() {
        this.jMenuDatei.setMnemonic('d');
        this.jMenuDatei.setText("Datei");
        this.jMenuBar.add(this.jMenuDatei);
        this.jMenuFilme.setMnemonic('F');
        this.jMenuFilme.setText("Filme");
        this.jMenuBar.add(this.jMenuFilme);
        this.jMenuDownload.setMnemonic('O');
        this.jMenuDownload.setText("Downloads");
        this.jMenuBar.add(this.jMenuDownload);
        this.jMenuAbos.setMnemonic('b');
        this.jMenuAbos.setText("Abos");
        this.jMenuBar.add(this.jMenuAbos);
        if (!SystemUtils.IS_OS_MAC_OSX) {
            this.jMenuBar.add(this.fontMenu);
        }
        this.jMenuAnsicht.setMnemonic('a');
        this.jMenuAnsicht.setText("Ansicht");
        this.jMenuBar.add(this.jMenuAnsicht);
        this.jMenuHilfe.setMnemonic('h');
        this.jMenuHilfe.setText("Hilfe");
        this.jMenuBar.add(this.jMenuHilfe);
        this.setJMenuBar(this.jMenuBar);
    }

    protected void workaroundJavaFxInitializationBug() {
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            Stage window = new Stage();
            window.setWidth(10.0);
            window.setHeight(10.0);
            window.show();
            window.hide();
        });
    }

    private void createMemoryMonitor() {
        boolean visible = ApplicationConfiguration.getConfiguration().getBoolean("memory_monitor.visible", false);
        if (visible) {
            this.showMemoryMonitorAction.showMemoryMonitor();
        }
    }

    private void loadFilmlist() {
        boolean writeCondition = GuiFunktionen.getFilmListUpdateType() != FilmListUpdateType.AUTOMATIC || !this.daten.getListeFilme().needsUpdate();
        Daten.dontWriteFilmlistOnStartup.set(writeCondition);
        this.swingStatusBar.add(this.progressLabel);
        this.swingStatusBar.add(this.progressBar);
        CompletionStage worker = ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> {
            logger.trace("Reading local filmlist");
            MessageBus.getMessageBus().publishAsync(new FilmListReadStartEvent());
            try (FilmListReader reader = new FilmListReader();){
                int num_days = ApplicationConfiguration.getConfiguration().getInt("filmlist.load.days", 0);
                reader.readFilmListe(StandardLocations.getFilmlistFilePathString(), this.daten.getListeFilme(), num_days);
            }
            MessageBus.getMessageBus().publishAsync(new FilmListReadStopEvent());
        }).thenRun(() -> {
            logger.trace("Check for filmlist updates");
            if (GuiFunktionen.getFilmListUpdateType() == FilmListUpdateType.AUTOMATIC && this.daten.getListeFilme().needsUpdate()) {
                this.daten.getFilmeLaden().loadFilmlist("", true);
            }
        })).thenRun(new RefreshAboWorker(this.progressLabel, this.progressBar))).thenRun(new BlacklistFilterWorker(this.progressLabel, this.progressBar));
        if (this.daten.getListeFilmeNachBlackList() instanceof IndexedFilmList) {
            worker = ((CompletableFuture)worker).thenRun(new LuceneIndexWorker(this.progressLabel, this.progressBar));
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)worker).thenRun(() -> SwingUtilities.invokeLater(() -> Daten.getInstance().getFilmeLaden().notifyFertig(new ListenerFilmeLadenEvent("", "", 100, 100, false))))).thenRun(() -> Daten.dontWriteFilmlistOnStartup.set(false))).thenRun(() -> SwingUtilities.invokeLater(() -> {
            this.swingStatusBar.remove(this.progressBar);
            this.swingStatusBar.remove(this.progressLabel);
        }));
    }

    private void createStatusBar() {
        this.swingStatusBar = new FixedRedrawStatusBar(this);
        this.getContentPane().add((Component)this.swingStatusBar, "South");
        this.createFilmlistDownloadProgress();
    }

    private void createFilmlistDownloadProgress() {
        this.daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void start(ListenerFilmeLadenEvent event) {
                MediathekGui.this.swingStatusBar.add(MediathekGui.this.progressLabel);
                MediathekGui.this.swingStatusBar.add(MediathekGui.this.progressBar);
            }

            @Override
            public void progress(ListenerFilmeLadenEvent event) {
                if (event.max == 0 || event.progress == event.max) {
                    MediathekGui.this.progressBar.setIndeterminate(true);
                } else {
                    MediathekGui.this.progressBar.setIndeterminate(false);
                    MediathekGui.this.progressBar.setMinimum(0);
                    MediathekGui.this.progressBar.setMaximum(event.max);
                    MediathekGui.this.progressBar.setValue(event.progress);
                }
                MediathekGui.this.progressLabel.setText(event.text);
            }
        });
    }

    public InfoDialog getFilmInfoDialog() {
        return this.filmInfo;
    }

    @Handler
    private void handleTabVisualSettingsChangedEvent(TabVisualSettingsChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.configureTabPlacement();
            this.configureTabIcons();
        });
    }

    private void setWindowTitle() {
        this.setTitle("MediathekView " + String.valueOf(Konstanten.MVVERSION));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSizeFromConfig() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.READ);
            int width = config.getInt("application.ui.mainwindow.width", 800);
            int height = config.getInt("application.ui.mainwindow.height", 600);
            int x = config.getInt("application.ui.mainwindow.location.x");
            int y = config.getInt("application.ui.mainwindow.location.y");
            if (width < 800) {
                width = 800;
            }
            if (height < 600) {
                height = 600;
            }
            this.setBounds(x, y, width, height);
        }
        catch (NoSuchElementException e) {
            this.setExtendedState(6);
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    private void setApplicationWindowSize() {
        if (Config.isStartMaximized() || ApplicationConfiguration.getConfiguration().getBoolean("application.ui.mainwindow.maximized", true)) {
            this.setExtendedState(6);
        } else {
            this.restoreSizeFromConfig();
        }
        SwingUtilities.invokeLater(() -> this.addComponentListener(new WindowLocationConfigSaverListener()));
    }

    private void setupFilmListListener() {
        this.daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void start(ListenerFilmeLadenEvent event) {
                MediathekGui.this.loadFilmListAction.setEnabled(false);
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                MediathekGui.this.loadFilmListAction.setEnabled(true);
                MediathekGui.this.daten.allesSpeichern();
            }

            @Override
            public void fertigOnlyOne(ListenerFilmeLadenEvent event) {
                MediathekGui.this.setupAutomaticFilmlistReload();
            }
        });
    }

    private void setupAutomaticFilmlistReload() {
        AutomaticFilmlistUpdate.IUpdateAction performUpdate = () -> {
            if (GuiFunktionen.getFilmListUpdateType() == FilmListUpdateType.AUTOMATIC) {
                this.loadFilmListAction.setEnabled(false);
                if (this.daten.getListeDownloads().unfinishedDownloads() == 0L) {
                    this.performFilmListLoadOperation(false);
                }
                this.loadFilmListAction.setEnabled(true);
            }
        };
        this.automaticFilmlistUpdate = new AutomaticFilmlistUpdate(performUpdate);
        this.automaticFilmlistUpdate.start();
    }

    protected void initWindowListenerForTray() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (MediathekGui.this.tray != null && MediathekGui.this.config.getBoolean("application.ui.tray.use", false)) {
                    MediathekGui.this.setVisible(false);
                } else {
                    MediathekGui.this.quitApplication();
                }
            }
        });
    }

    @Handler
    private void handleUpdateStateChanged(UpdateStateChangedEvent e) {
        SwingUtilities.invokeLater(() -> this.setupUpdateCheck(e.isActive()));
    }

    private void setupUpdateCheck(boolean newState) {
        if (newState) {
            this.programUpdateChecker = new ProgramUpdateCheck();
            this.programUpdateChecker.start();
        } else {
            this.endProgramUpdateChecker();
        }
    }

    private void endProgramUpdateChecker() {
        if (this.programUpdateChecker != null) {
            this.programUpdateChecker.close();
            this.programUpdateChecker = null;
        }
    }

    public void initializeSystemTray() {
        boolean useTray = this.config.getBoolean("application.ui.tray.use", false);
        if (this.tray == null && useTray) {
            this.tray = new MVTray().systemTray();
        } else if (this.tray != null && !useTray) {
            this.tray.beenden();
            this.tray = null;
        }
    }

    protected JPanel createTabFilme(@NotNull Daten daten) {
        return new GuiFilme(daten, this);
    }

    protected JPanel createTabDownloads(@NotNull Daten daten) {
        return new GuiDownloads(daten, this);
    }

    private void initTabs() {
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.tabbedPane, "Center");
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_DOWNLOAD_TAB));
        this.tabDownloads = (GuiDownloads)this.createTabDownloads(this.daten);
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_FILM_TAB));
        this.tabFilme = (GuiFilme)this.createTabFilme(this.daten);
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.ADD_TABS_TO_UI));
        this.tabbedPane.addTab("Filme", this.tabFilme);
        this.tabbedPane.addTab("Downloads", this.tabDownloads);
        if (ApplicationConfiguration.getConfiguration().getBoolean("application.ui.restore_selected_tab", false)) {
            this.tabbedPane.restoreSavedTabPosition();
        }
        this.tabbedPane.installChangeListener();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.CONFIGURE_TABS));
        this.configureTabPlacement();
        this.configureTabIcons();
    }

    public void enableUpdateMenuItem(boolean enable) {
        this.searchProgramUpdateAction.setEnabled(enable);
    }

    private void configureTabPlacement() {
        boolean topPosition = this.config.getBoolean("application.ui.tab_position.top", true);
        if (topPosition) {
            this.tabbedPane.setTabPlacement(1);
        } else {
            this.tabbedPane.setTabPlacement(2);
        }
    }

    private void configureTabIcons() {
        boolean icon = this.config.getBoolean("application.ui.mainwindow.tab_icons", false);
        if (!icon) {
            this.setTabIcon(this.tabFilme, null);
            this.setTabIcon(this.tabDownloads, null);
        } else {
            this.setTabIcon(this.tabFilme, Icons.ICON_TAB_FILM);
            this.setTabIcon(this.tabDownloads, Icons.ICON_TAB_DOWNLOAD);
        }
    }

    private void setTabIcon(Component tab, Icon icon) {
        int index = this.tabbedPane.indexOfComponent(tab);
        this.tabbedPane.setIconAt(index, icon);
    }

    protected IndicatorThread createProgressIndicatorThread() throws Exception {
        throw new Exception("Unsupported Platform");
    }

    @Handler
    protected void handleDownloadStart(DownloadStartEvent msg) {
        this.numDownloadsStarted.incrementAndGet();
        if (this.progressIndicatorThread == null) {
            try {
                this.progressIndicatorThread = this.createProgressIndicatorThread();
                this.progressIndicatorThread.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Handler
    protected void handleDownloadFinishedEvent(DownloadFinishedEvent msg) {
        int numDL = this.numDownloadsStarted.decrementAndGet();
        if (numDL == 0 && this.progressIndicatorThread != null) {
            this.progressIndicatorThread.interrupt();
            this.progressIndicatorThread = null;
        }
    }

    protected void installMenuTabSwitchListener() {
        this.menuListeners.put(this.jMenuFilme, new MenuTabSwitchListener(this, TABS.TAB_FILME));
        this.menuListeners.put(this.jMenuDownload, new MenuTabSwitchListener(this, TABS.TAB_DOWNLOADS));
        if (this.config.getBoolean("application.ui.install_tab_listeners", true)) {
            this.jMenuFilme.addMenuListener(this.menuListeners.get(this.jMenuFilme));
            this.jMenuDownload.addMenuListener(this.menuListeners.get(this.jMenuDownload));
        }
    }

    @Handler
    protected void handleInstallTabSwitchListenerEvent(InstallTabSwitchListenerEvent msg) {
        switch (msg.event) {
            case INSTALL: {
                SwingUtilities.invokeLater(() -> {
                    this.jMenuFilme.addMenuListener(this.menuListeners.get(this.jMenuFilme));
                    this.jMenuDownload.addMenuListener(this.menuListeners.get(this.jMenuDownload));
                });
                break;
            }
            case REMOVE: {
                SwingUtilities.invokeLater(() -> {
                    this.jMenuFilme.removeMenuListener(this.menuListeners.get(this.jMenuFilme));
                    this.jMenuDownload.removeMenuListener(this.menuListeners.get(this.jMenuDownload));
                });
            }
        }
    }

    private void createFileMenu() {
        this.jMenuDatei.add(this.loadFilmListAction);
        this.jMenuDatei.addSeparator();
        JMenu exportMenu = new JMenu("Export");
        exportMenu.add(new ExportReadableFilmlistAction());
        exportMenu.add(new ExportDecompressedFilmlistAction());
        JMenu importMenu = new JMenu("Import");
        importMenu.add(new ImportOldAbosAction());
        importMenu.add(new ImportOldBlacklistAction());
        importMenu.add(new ImportOldReplacementListAction());
        this.jMenuDatei.add(exportMenu);
        this.jMenuDatei.add(importMenu);
        if (!SystemUtils.IS_OS_MAC_OSX) {
            this.jMenuDatei.addSeparator();
            this.jMenuDatei.add(this.settingsAction);
            this.jMenuDatei.addSeparator();
            this.jMenuDatei.add(new QuitAction(this));
        }
    }

    private void createViewMenu() {
        this.jMenuAnsicht.addSeparator();
        this.jMenuAnsicht.add(this.showMemoryMonitorAction);
        this.jMenuAnsicht.add(this.showBandwidthUsageAction);
        this.jMenuAnsicht.addSeparator();
        this.jMenuAnsicht.add(this.tabFilme.toggleFilterDialogVisibilityAction);
        this.jMenuAnsicht.addSeparator();
        this.jMenuAnsicht.add(this.showFilmInformationAction);
        this.jMenuAnsicht.addSeparator();
        this.jMenuAnsicht.add(this.manageBookmarkAction);
    }

    private void createFontMenu() {
        JMenuItem restoreFontMenuItem = new JMenuItem();
        restoreFontMenuItem.setText("Schrift zur\u00fccksetzen");
        restoreFontMenuItem.setAccelerator(KeyStroke.getKeyStroke(48, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        restoreFontMenuItem.addActionListener(e -> this.fontManager.resetFont());
        this.fontMenu.add(restoreFontMenuItem);
        JMenuItem incrFontMenuItem = new JMenuItem();
        incrFontMenuItem.setText("Schrift vergr\u00f6\u00dfern");
        incrFontMenuItem.setAccelerator(KeyStroke.getKeyStroke(521, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        incrFontMenuItem.addActionListener(e -> this.fontManager.increaseFontSize());
        this.fontMenu.add(incrFontMenuItem);
        JMenuItem decrFontMenuItem = new JMenuItem();
        decrFontMenuItem.setText("Schrift verkleinern");
        decrFontMenuItem.setAccelerator(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        decrFontMenuItem.addActionListener(e -> this.fontManager.decreaseFontSize());
        this.fontMenu.add(decrFontMenuItem);
        this.fontManager.updateFontMenuItems();
    }

    @Handler
    private void handleFilmlistWriteStartEvent(FilmListWriteStartEvent e) {
        SwingUtilities.invokeLater(() -> this.loadFilmListAction.setEnabled(false));
    }

    @Handler
    private void handleFilmlistWriteStopEvent(FilmListWriteStopEvent e) {
        SwingUtilities.invokeLater(() -> this.loadFilmListAction.setEnabled(true));
    }

    private void createHelpMenu() {
        this.jMenuHilfe.add(new ShowOnlineHelpAction());
        this.jMenuHilfe.addSeparator();
        this.jMenuHilfe.add(new ResetSettingsAction(this, this.daten));
        this.jMenuHilfe.add(new ResetDownloadHistoryAction(this));
        this.jMenuHilfe.add(new ResetAboHistoryAction(this));
        this.jMenuHilfe.add(new DeleteLocalFilmlistAction(this));
        this.jMenuHilfe.addSeparator();
        this.jMenuHilfe.add(new ResetFilterDialogPosition(this));
        this.jMenuHilfe.addSeparator();
        if (GuiFunktionen.isNotUsingExternalUpdater()) {
            this.jMenuHilfe.add(this.searchProgramUpdateAction);
        }
        this.jMenuHilfe.add(new ShowProgramInfosAction());
        this.installAdditionalHelpEntries();
    }

    protected void installAdditionalHelpEntries() {
        this.jMenuHilfe.addSeparator();
        this.jMenuHilfe.add(new ShowAboutAction());
    }

    protected void initMenus() {
        this.installMenuTabSwitchListener();
        this.createFileMenu();
        this.tabFilme.installMenuEntries(this.jMenuFilme);
        this.tabDownloads.installMenuEntries(this.jMenuDownload);
        this.createFontMenu();
        this.createViewMenu();
        this.tabFilme.installViewMenuEntry(this.jMenuAnsicht);
        this.createAboMenu();
        if (Config.isDebugModeEnabled()) {
            this.createDeveloperMenu();
        }
        this.createHelpMenu();
    }

    private void createDeveloperMenu() {
        JMenu devMenu = new JMenu("Entwickler");
        JMenuItem miGc = new JMenuItem("GC ausf\u00fchren");
        miGc.addActionListener(l -> System.gc());
        devMenu.add(miGc);
        this.jMenuBar.add(devMenu);
    }

    private void createAboMenu() {
        this.jMenuAbos.add(new CreateNewAboAction(this.daten.getListeAbo()));
        this.jMenuAbos.add(new ShowAboHistoryAction(MediathekGui.ui()));
        this.jMenuAbos.addSeparator();
        this.jMenuAbos.add(this.manageAboAction);
    }

    public void performFilmListLoadOperation(boolean manualMode) {
        if (manualMode || GuiFunktionen.getFilmListUpdateType() == FilmListUpdateType.MANUAL) {
            LoadFilmListDialog dlg = new LoadFilmListDialog(this);
            dlg.setVisible(true);
        } else {
            FilmeLaden filmeLaden = new FilmeLaden(this.daten);
            filmeLaden.loadFilmlist("", false);
        }
    }

    public DialogEinstellungen getSettingsDialog() {
        if (this.dialogEinstellungen == null) {
            this.dialogEinstellungen = new DialogEinstellungen();
        }
        return this.dialogEinstellungen;
    }

    public boolean isShutdownRequested() {
        return this.shutdownRequested;
    }

    public void setShutdownRequested(boolean shutdownRequested) {
        this.shutdownRequested = shutdownRequested;
    }

    public boolean quitApplication() {
        if (this.daten.getListeDownloads().unfinishedDownloads() > 0L) {
            DialogBeenden dialogBeenden = new DialogBeenden(this);
            dialogBeenden.setVisible(true);
            if (!dialogBeenden.getApplicationCanTerminate()) {
                return false;
            }
            this.setShutdownRequested(dialogBeenden.isShutdownRequested());
        }
        if (this.automaticFilmlistUpdate != null) {
            this.automaticFilmlistUpdate.close();
        }
        this.endProgramUpdateChecker();
        this.showMemoryMonitorAction.closeMemoryMonitor();
        this.showBandwidthUsageAction.getDialogOptional().ifPresent(dlg -> {
            dlg.dispose();
            this.config.setProperty("application.ui.bandwidth_monitor.visible", true);
        });
        this.manageAboAction.closeDialog();
        ShutdownDialogController shutdownProgress = new ShutdownDialogController(this);
        shutdownProgress.show();
        CompletableFuture<Void> historyWorker = CompletableFuture.runAsync(() -> {
            try (SeenHistoryController history = new SeenHistoryController();){
                history.performMaintenance();
            }
        });
        CompletableFuture<Void> bookmarkWorker = CompletableFuture.runAsync(() -> this.daten.getListeBookmarkList().saveToFile(StandardLocations.getBookmarkFilePath()));
        shutdownProgress.setStatus(ShutdownState.TERMINATE_STARTER_THREAD);
        this.daten.getStarterClass().getStarterThread().interrupt();
        shutdownProgress.setStatus(ShutdownState.SHUTDOWN_NOTIFICATION_CENTER);
        this.closeNotificationCenter();
        shutdownProgress.setStatus(ShutdownState.SAVE_FILM_DATA);
        this.tabFilme.tabelleSpeichern();
        this.tabFilme.saveSettings();
        this.tabFilme.filmActionPanel.getFilterDialog().dispose();
        shutdownProgress.setStatus(ShutdownState.SAVE_DOWNLOAD_DATA);
        this.tabDownloads.tabelleSpeichern();
        shutdownProgress.setStatus(ShutdownState.STOP_DOWNLOADS);
        this.stopDownloads();
        shutdownProgress.setStatus(ShutdownState.SAVE_APP_DATA);
        this.daten.allesSpeichern();
        shutdownProgress.setStatus(ShutdownState.SHUTDOWN_THREAD_POOL);
        this.shutdownTimerPool();
        this.waitForCommonPoolToComplete();
        shutdownProgress.setStatus(ShutdownState.TERMINATE_JAVAFX_SUPPORT);
        this.shutdownJavaFx();
        try {
            shutdownProgress.setStatus(ShutdownState.SAVE_BOOKMARKS);
            bookmarkWorker.get();
            shutdownProgress.setStatus(ShutdownState.PERFORM_SEEN_HISTORY_MAINTENANCE);
            historyWorker.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Async task error", (Throwable)e);
        }
        this.dispose();
        ApplicationConfiguration.getInstance().writeConfiguration();
        RuntimeStatistics.printRuntimeStatistics();
        RuntimeStatistics.printDataUsageStatistics();
        shutdownProgress.setStatus(ShutdownState.COMPLETE);
        this.cleanupLuceneIndex();
        if (this.isShutdownRequested()) {
            this.shutdownComputer();
        }
        System.exit(0);
        return true;
    }

    private void cleanupLuceneIndex() {
        ListeFilme listeFilme = this.daten.getListeFilmeNachBlackList();
        if (listeFilme instanceof IndexedFilmList) {
            IndexedFilmList filmList = (IndexedFilmList)listeFilme;
            try (IndexWriter writer = filmList.getWriter();){
                writer.deleteAll();
                writer.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void shutdownJavaFx() {
        JavaFxUtils.invokeInFxThreadAndWait(() -> JFXHiddenApplication.getPrimaryStage().close());
        Platform.exit();
    }

    private void shutdownTimerPool() {
        ScheduledThreadPoolExecutor timerPool = TimerPool.getTimerPool();
        timerPool.shutdown();
        try {
            if (!timerPool.awaitTermination(3L, TimeUnit.SECONDS)) {
                logger.warn("Time out occured before pool final termination");
            }
        }
        catch (InterruptedException e) {
            logger.warn("timerPool shutdown exception", (Throwable)e);
        }
        List<Runnable> taskList = timerPool.shutdownNow();
        if (!taskList.isEmpty()) {
            logger.trace("timerPool taskList was not empty");
            logger.trace(taskList.toString());
        }
    }

    private void stopDownloads() {
        if (this.daten.getListeDownloads() != null) {
            for (DatenDownload download : this.daten.getListeDownloads()) {
                Start s2 = download.start;
                if (s2 == null) continue;
                s2.stoppen = true;
            }
        }
    }

    private void waitForCommonPoolToComplete() {
        while (ForkJoinPool.commonPool().hasQueuedSubmissions()) {
            try {
                logger.debug("POOL SUBMISSIONS: {}", (Object)ForkJoinPool.commonPool().getQueuedSubmissionCount());
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void shutdownComputer() {
    }
}

