/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.SimpleScrollPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.border.Border;

class SimpleScrollPaneLayout
extends ScrollPaneLayout {
    protected AbstractButton _scrollUp;
    protected AbstractButton _scrollDown;
    protected AbstractButton _scrollLeft;
    protected AbstractButton _scrollRight;

    SimpleScrollPaneLayout() {
    }

    @Override
    public void syncWithScrollPane(JScrollPane sp) {
        super.syncWithScrollPane(sp);
        if (sp instanceof SimpleScrollPane) {
            this._scrollUp = ((SimpleScrollPane)sp).getScrollUpButton();
            this._scrollDown = ((SimpleScrollPane)sp).getScrollDownButton();
            this._scrollLeft = ((SimpleScrollPane)sp).getScrollLeftButton();
            this._scrollRight = ((SimpleScrollPane)sp).getScrollRightButton();
        }
    }

    @Override
    public void addLayoutComponent(String s2, Component c) {
        if ("SCROLL_UP_BUTTON".equals(s2)) {
            this._scrollUp = (AbstractButton)this.addSingletonComponent(this._scrollUp, c);
        } else if ("SCROLL_DOWN_BUTTON".equals(s2)) {
            this._scrollDown = (AbstractButton)this.addSingletonComponent(this._scrollDown, c);
        } else if ("SCROLL_LEFT_BUTTON".equals(s2)) {
            this._scrollLeft = (AbstractButton)this.addSingletonComponent(this._scrollLeft, c);
        } else if ("SCROLL_RIGHT_BUTTON".equals(s2)) {
            this._scrollRight = (AbstractButton)this.addSingletonComponent(this._scrollRight, c);
        } else {
            super.addLayoutComponent(s2, c);
        }
    }

    @Override
    public void removeLayoutComponent(Component c) {
        if (c == this._scrollUp) {
            this._scrollUp = null;
        } else if (c == this._scrollDown) {
            this._scrollDown = null;
        } else if (c == this._scrollLeft) {
            this._scrollLeft = null;
        } else if (c == this._scrollRight) {
            this._scrollRight = null;
        } else {
            super.removeLayoutComponent(c);
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Border viewportBorder;
        JScrollPane scrollPane = (JScrollPane)parent;
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        Insets insets = parent.getInsets();
        int prefWidth = insets.left + insets.right;
        int prefHeight = insets.top + insets.bottom;
        Dimension extentSize = null;
        Dimension viewSize = null;
        Component view = null;
        if (this.viewport != null) {
            extentSize = this.viewport.getPreferredSize();
            viewSize = this.viewport.getViewSize();
            view = this.viewport.getView();
        }
        if (extentSize != null) {
            prefWidth += extentSize.width;
            prefHeight += extentSize.height;
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            Insets vpbInsets = viewportBorder.getBorderInsets(parent);
            prefWidth += vpbInsets.left + vpbInsets.right;
            prefHeight += vpbInsets.top + vpbInsets.bottom;
        }
        if (this._scrollUp != null && this._scrollDown != null && this.vsbPolicy != 21) {
            if (this.vsbPolicy == 22) {
                prefHeight += this._scrollUp.isVisible() ? this._scrollUp.getPreferredSize().height : 0;
                prefHeight += this._scrollDown.isVisible() ? this._scrollDown.getPreferredSize().height : 0;
            } else if (viewSize != null && extentSize != null) {
                boolean canScroll = true;
                if (view instanceof Scrollable) {
                    boolean bl = canScroll = !((Scrollable)((Object)view)).getScrollableTracksViewportHeight();
                }
                if (canScroll && viewSize.height > extentSize.height) {
                    prefHeight += this._scrollUp.isVisible() ? this._scrollUp.getPreferredSize().height : 0;
                    prefHeight += this._scrollDown.isVisible() ? this._scrollDown.getPreferredSize().height : 0;
                }
            }
        }
        if (this._scrollLeft != null && this._scrollRight != null && this.hsbPolicy != 31) {
            if (this.hsbPolicy == 32) {
                prefWidth += this._scrollLeft.isVisible() ? this._scrollLeft.getPreferredSize().width : 0;
                prefWidth += this._scrollRight.isVisible() ? this._scrollRight.getPreferredSize().width : 0;
            } else if (viewSize != null && extentSize != null) {
                boolean canScroll = true;
                if (view instanceof Scrollable) {
                    boolean bl = canScroll = !((Scrollable)((Object)view)).getScrollableTracksViewportWidth();
                }
                if (canScroll && viewSize.width > extentSize.width) {
                    prefWidth += this._scrollLeft.isVisible() ? this._scrollLeft.getPreferredSize().width : 0;
                    prefWidth += this._scrollRight.isVisible() ? this._scrollRight.getPreferredSize().width : 0;
                }
            }
        }
        return new Dimension(prefWidth, prefHeight);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension size;
        Border viewportBorder;
        JScrollPane scrollPane = (JScrollPane)parent;
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        Insets insets = parent.getInsets();
        int minWidth = insets.left + insets.right;
        int minHeight = insets.top + insets.bottom;
        if (this.viewport != null) {
            Dimension size2 = this.viewport.getMinimumSize();
            minWidth += size2.width;
            minHeight += size2.height;
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            Insets vpbInsets = viewportBorder.getBorderInsets(parent);
            minWidth += vpbInsets.left + vpbInsets.right;
            minHeight += vpbInsets.top + vpbInsets.bottom;
        }
        if (this._scrollUp != null && this._scrollDown != null && this.vsbPolicy != 21) {
            size = new Dimension(Math.max(this._scrollUp.getMinimumSize().width, this._scrollDown.getMinimumSize().width), 0);
            size.height = size.height + (this._scrollUp.isVisible() ? this._scrollUp.getMinimumSize().height : 0);
            size.height = size.height + (this._scrollDown.isVisible() ? this._scrollDown.getMinimumSize().height : 0);
            minHeight += size.height;
            minWidth = Math.max(minWidth, size.width);
        }
        if (this._scrollLeft != null && this._scrollLeft != null && this.hsbPolicy != 31) {
            size = new Dimension(0, Math.max(this._scrollLeft.getMinimumSize().height, this._scrollRight.getMinimumSize().height));
            size.width = size.width + (this._scrollLeft.isVisible() ? this._scrollLeft.getMinimumSize().width : 0);
            size.width = size.width + (this._scrollRight.isVisible() ? this._scrollRight.getMinimumSize().width : 0);
            minWidth += size.width;
            minHeight = Math.max(minHeight, size.height);
        }
        return new Dimension(minWidth, minHeight);
    }

    @Override
    public void layoutContainer(Container parent) {
        boolean hsbNeeded;
        boolean vsbNeeded;
        Scrollable sv;
        boolean isEmpty;
        Insets vpbInsets;
        JScrollPane scrollPane = (JScrollPane)parent;
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        Rectangle availR = scrollPane.getBounds();
        availR.y = 0;
        availR.x = 0;
        Insets insets = parent.getInsets();
        availR.x = insets.left;
        availR.y = insets.top;
        availR.width -= insets.left + insets.right;
        availR.height -= insets.top + insets.bottom;
        Border viewportBorder = scrollPane.getViewportBorder();
        if (viewportBorder != null) {
            vpbInsets = viewportBorder.getBorderInsets(parent);
            availR.x += vpbInsets.left;
            availR.y += vpbInsets.top;
            availR.width -= vpbInsets.left + vpbInsets.right;
            availR.height -= vpbInsets.top + vpbInsets.bottom;
        } else {
            vpbInsets = new Insets(0, 0, 0, 0);
        }
        Component view = this.viewport != null ? this.viewport.getView() : null;
        Dimension viewPrefSize = view != null ? view.getPreferredSize() : new Dimension(0, 0);
        Dimension extentSize = this.viewport != null ? this.viewport.toViewCoordinates(availR.getSize()) : new Dimension(0, 0);
        boolean viewTracksViewportWidth = false;
        boolean viewTracksViewportHeight = false;
        boolean bl = isEmpty = availR.width < 0 || availR.height < 0;
        if (!isEmpty && view instanceof Scrollable) {
            sv = (Scrollable)((Object)view);
            viewTracksViewportWidth = sv.getScrollableTracksViewportWidth();
            viewTracksViewportHeight = sv.getScrollableTracksViewportHeight();
        } else {
            sv = null;
        }
        Rectangle scrollUpR = new Rectangle(0, 0, 0, this._scrollUp.getPreferredSize().height);
        Rectangle scrollDownR = new Rectangle(0, 0, 0, this._scrollDown.getPreferredSize().height);
        if (isEmpty) {
            vsbNeeded = false;
        } else if (this.vsbPolicy == 22) {
            vsbNeeded = true;
        } else if (this.vsbPolicy == 21) {
            vsbNeeded = false;
        } else {
            if (!this._scrollUp.isEnabled()) {
                scrollUpR.height = 0;
            }
            if (!this._scrollDown.isEnabled()) {
                scrollDownR.height = 0;
            }
            boolean bl2 = vsbNeeded = !viewTracksViewportHeight && viewPrefSize.height > extentSize.height;
        }
        if (this._scrollUp != null && this._scrollDown != null && vsbNeeded) {
            this.adjustForScrollUpAndDown(true, availR, scrollUpR, scrollDownR, vpbInsets);
            extentSize = this.viewport.toViewCoordinates(availR.getSize());
        }
        Rectangle scrollLeftR = new Rectangle(0, 0, this._scrollLeft.getPreferredSize().width, 0);
        Rectangle scrollRightR = new Rectangle(0, 0, this._scrollRight.getPreferredSize().width, 0);
        if (isEmpty) {
            hsbNeeded = false;
        } else if (this.hsbPolicy == 32) {
            hsbNeeded = true;
        } else if (this.hsbPolicy == 31) {
            hsbNeeded = false;
        } else {
            if (!this._scrollLeft.isEnabled()) {
                scrollLeftR.width = 0;
            }
            if (!this._scrollRight.isEnabled()) {
                scrollRightR.width = 0;
            }
            boolean bl3 = hsbNeeded = !viewTracksViewportWidth && viewPrefSize.width > extentSize.width;
        }
        if (this.hsb != null && hsbNeeded) {
            this.adjustForScrollLeftAndRight(true, availR, scrollLeftR, scrollRightR, vpbInsets);
            if (this._scrollUp != null && this._scrollDown != null && !vsbNeeded && this.vsbPolicy != 21) {
                extentSize = this.viewport.toViewCoordinates(availR.getSize());
                boolean bl4 = vsbNeeded = viewPrefSize.height > extentSize.height;
                if (vsbNeeded) {
                    this.adjustForScrollUpAndDown(true, availR, scrollUpR, scrollDownR, vpbInsets);
                }
            }
        }
        if (this.viewport != null) {
            this.viewport.setBounds(availR);
            if (sv != null) {
                extentSize = this.viewport.toViewCoordinates(availR.getSize());
                boolean oldHSBNeeded = hsbNeeded;
                boolean oldVSBNeeded = vsbNeeded;
                viewTracksViewportWidth = sv.getScrollableTracksViewportWidth();
                viewTracksViewportHeight = sv.getScrollableTracksViewportHeight();
                if (this.vsb != null && this.vsbPolicy == 20) {
                    boolean newVSBNeeded;
                    boolean bl5 = newVSBNeeded = !viewTracksViewportHeight && viewPrefSize.height > extentSize.height;
                    if (newVSBNeeded != vsbNeeded) {
                        vsbNeeded = newVSBNeeded;
                        this.adjustForScrollUpAndDown(vsbNeeded, availR, scrollUpR, scrollDownR, vpbInsets);
                        extentSize = this.viewport.toViewCoordinates(availR.getSize());
                    }
                }
                if (this.hsb != null && this.hsbPolicy == 30) {
                    boolean newHSBbNeeded;
                    boolean bl6 = newHSBbNeeded = !viewTracksViewportWidth && viewPrefSize.width > extentSize.width;
                    if (newHSBbNeeded != hsbNeeded) {
                        hsbNeeded = newHSBbNeeded;
                        this.adjustForScrollLeftAndRight(hsbNeeded, availR, scrollLeftR, scrollRightR, vpbInsets);
                        if (this.vsb != null && !vsbNeeded && this.vsbPolicy != 21) {
                            extentSize = this.viewport.toViewCoordinates(availR.getSize());
                            boolean bl7 = vsbNeeded = viewPrefSize.height > extentSize.height;
                            if (vsbNeeded) {
                                this.adjustForScrollUpAndDown(true, availR, scrollUpR, scrollDownR, vpbInsets);
                            }
                        }
                    }
                }
                if (oldHSBNeeded != hsbNeeded || oldVSBNeeded != vsbNeeded) {
                    this.viewport.setBounds(availR);
                }
            }
        }
        if (this._scrollUp != null && this._scrollDown != null) {
            if (vsbNeeded) {
                this._scrollUp.setVisible(true);
                this._scrollDown.setVisible(true);
                this._scrollUp.setBounds(scrollUpR);
                this._scrollDown.setBounds(scrollDownR);
            } else {
                this._scrollUp.setVisible(false);
                this._scrollDown.setVisible(false);
                this._scrollUp.setBounds(scrollUpR.x, scrollUpR.y, 0, 0);
                this._scrollDown.setBounds(scrollDownR.x, scrollDownR.y, 0, 0);
            }
        }
        if (this._scrollLeft != null && this._scrollRight != null) {
            if (hsbNeeded) {
                this._scrollLeft.setVisible(true);
                this._scrollRight.setVisible(true);
                this._scrollLeft.setBounds(scrollLeftR);
                this._scrollRight.setBounds(scrollRightR);
            } else {
                this._scrollLeft.setVisible(false);
                this._scrollRight.setVisible(false);
                this._scrollLeft.setBounds(scrollLeftR.x, scrollLeftR.y, 0, 0);
                this._scrollRight.setBounds(scrollRightR.x, scrollRightR.y, 0, 0);
            }
        }
    }

    private void adjustForScrollUpAndDown(boolean wantsVSB, Rectangle available, Rectangle upR, Rectangle downR, Insets vpbInsets) {
        if (wantsVSB) {
            int buttonWidth = Math.max(0, Math.max(available.width + vpbInsets.left + vpbInsets.right, Math.max(this._scrollUp.getPreferredSize().width, this._scrollDown.getPreferredSize().width)));
            available.height -= upR.height;
            available.height -= downR.height;
            upR.width = buttonWidth;
            downR.width = buttonWidth;
            upR.x = available.x - vpbInsets.left;
            downR.x = available.x - vpbInsets.left;
            upR.y = available.y - vpbInsets.top;
            available.y += upR.height;
            downR.y = available.y + available.height + vpbInsets.bottom;
        }
    }

    private void adjustForScrollLeftAndRight(boolean wantsHSB, Rectangle available, Rectangle leftR, Rectangle rightR, Insets vpbInsets) {
        if (wantsHSB) {
            int buttonHeight = Math.max(0, Math.max(available.height + vpbInsets.top + vpbInsets.bottom, Math.max(this._scrollLeft.getPreferredSize().height, this._scrollRight.getPreferredSize().height)));
            available.width -= leftR.width;
            available.width -= rightR.width;
            leftR.height = buttonHeight;
            rightR.height = buttonHeight;
            leftR.y = available.y - vpbInsets.top;
            rightR.y = available.y - vpbInsets.top;
            leftR.x = available.x - vpbInsets.left;
            available.x += leftR.width;
            rightR.x = available.x + available.width + vpbInsets.right;
        }
    }

    static class UIResource
    extends SimpleScrollPaneLayout
    implements javax.swing.plaf.UIResource {
        UIResource() {
        }
    }
}

