/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.ButtonEvent;
import com.jidesoft.dialog.ButtonListener;
import com.jidesoft.dialog.ButtonNames;
import com.jidesoft.dialog.ButtonPanelLayout;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ArrowKeyNavigationSupport;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class ButtonPanel
extends JPanel
implements ButtonListener,
ButtonNames {
    private static final long serialVersionUID = -7840551457656712357L;
    public static final int SAME_SIZE = 0;
    public static final int NO_LESS_THAN = 1;
    public static final String KEEP_PREFERRED_WIDTH = "keepPreferredWidth";
    public static final String AFFIRMATIVE_BUTTON = "AFFIRMATIVE";
    public static final String CANCEL_BUTTON = "CANCEL";
    public static final String HELP_BUTTON = "HELP";
    public static final String OTHER_BUTTON = "ALTERNATIVE";
    private String _defaultOrder = UIDefaultsLookup.getString("ButtonPanel.order");
    private String _defaultOppositeOrder = UIDefaultsLookup.getString("ButtonPanel.oppositeOrder");
    private int _defaultButtonGap = UIDefaultsLookup.getInt("ButtonPanel.buttonGap");
    private int _defaultGroupGap = UIDefaultsLookup.getInt("ButtonPanel.groupGap");
    private int _defaultButtonWidth = UIDefaultsLookup.getInt("ButtonPanel.minButtonWidth");
    private int _alignment;
    private ButtonPanelLayout _layout;
    private boolean _addNotify = false;
    private JButton _defaultButton;

    public ButtonPanel() {
        this(11);
    }

    public ButtonPanel(int alignment) {
        this(alignment, 0);
    }

    public ButtonPanel(int alignment, int sizeConstrains) {
        this._alignment = alignment;
        if (alignment != 2 && alignment != 4 && alignment != 10 && alignment != 11 && alignment != 1 && alignment != 3 && alignment != 0) {
            throw new IllegalArgumentException("Invalid alignment");
        }
        int axis = this._alignment == 0 || this._alignment == 2 || this._alignment == 4 || this._alignment == 11 || this._alignment == 10 ? 0 : 1;
        this._layout = new ButtonPanelLayout(this, axis, this._alignment, sizeConstrains, this._defaultOrder, this._defaultOppositeOrder, this._defaultButtonGap, this._defaultGroupGap);
        this.setLayout(this._layout);
        new ArrowKeyNavigationSupport(new Class[]{AbstractButton.class}).install(this);
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get("ButtonPanel.buttonGap") == null && UIDefaultsLookup.get("ButtonPanel.order") == null && UIDefaultsLookup.get("ButtonPanel.groupGap") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        super.updateUI();
        this.reinstallDefaults();
    }

    protected void reinstallDefaults() {
        if (this._layout != null) {
            if (this._defaultButtonGap == this._layout.getButtonGap()) {
                this._defaultButtonGap = UIDefaultsLookup.getInt("ButtonPanel.buttonGap");
                this._layout.setButtonGap(this._defaultButtonGap);
            }
            if (this._defaultGroupGap == this._layout.getGroupGap()) {
                this._defaultGroupGap = UIDefaultsLookup.getInt("ButtonPanel.groupGap");
                this._layout.setGroupGap(this._defaultGroupGap);
            }
            if (this._defaultOrder.equals(this._layout.getButtonOrder())) {
                this._defaultOrder = UIDefaultsLookup.getString("ButtonPanel.order");
                this._layout.setButtonOrder(this._defaultOrder);
            }
            if (this._defaultOppositeOrder.equals(this._layout.getOppositeButtonOrder())) {
                this._defaultOppositeOrder = UIDefaultsLookup.getString("ButtonPanel.oppositeOrder");
                this._layout.setOppositeButtonOrder(this._defaultOppositeOrder);
            }
            if (this._defaultButtonWidth == this._layout.getMinButtonWidth()) {
                this._defaultButtonWidth = UIDefaultsLookup.getInt("ButtonPanel.minButtonWidth");
                this._layout.setMinButtonWidth(this._defaultButtonWidth);
            }
        }
    }

    public void setAlignment(int alignment) {
        this._alignment = alignment;
        int axis = this._alignment == 0 || this._alignment == 2 || this._alignment == 4 || this._alignment == 10 || this._alignment == 11 ? 0 : 1;
        this._layout.setAlignment(this._alignment);
        this._layout.setAxis(axis);
        this._layout.layoutContainer(this);
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void addButton(AbstractButton button) {
        this.addButton(button, AFFIRMATIVE_BUTTON);
    }

    public void addButton(AbstractButton button, int index) {
        this.addButton(button, AFFIRMATIVE_BUTTON, index);
    }

    public void addButton(AbstractButton button, Object constraint) {
        this.addButton(button, constraint, -1);
    }

    public void addButton(AbstractButton button, Object constraint, int index) {
        this.add(button, constraint, index);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (constraints == null) {
            constraints = AFFIRMATIVE_BUTTON;
        }
        super.addImpl(comp, constraints, index);
    }

    public void removeButton(AbstractButton button) {
        this.remove(button);
    }

    public String getButtonOrder() {
        return this._layout.getButtonOrder();
    }

    public void setButtonOrder(String buttonOrder) {
        this._layout.setButtonOrder(buttonOrder);
    }

    public String getOppositeButtonOrder() {
        return this._layout.getOppositeButtonOrder();
    }

    public void setOppositeButtonOrder(String oppositeButtonOrder) {
        this._layout.setOppositeButtonOrder(oppositeButtonOrder);
    }

    public int getSizeConstraint() {
        return this._layout.getSizeConstraint();
    }

    public void setSizeConstraint(int sizeConstrains) {
        this._layout.setSizeConstraint(sizeConstrains);
    }

    public int getGroupGap() {
        return this._layout.getGroupGap();
    }

    public void setGroupGap(int groupGap) {
        this._layout.setGroupGap(groupGap);
    }

    public int getButtonGap() {
        return this._layout.getButtonGap();
    }

    public void setButtonGap(int buttonGap) {
        this._layout.setButtonGap(buttonGap);
    }

    public int getMinButtonWidth() {
        return this._layout.getMinButtonWidth();
    }

    public void setMinButtonWidth(int minButtonWidth) {
        this._layout.setMinButtonWidth(minButtonWidth);
    }

    @Override
    public void buttonEventFired(ButtonEvent e) {
        block17: {
            block16: {
                if (e.getID() != 3308) break block16;
                JRootPane rootPane = this.getRootPane();
                if (rootPane == null || rootPane.getDefaultButton() == null) break block17;
                rootPane.setDefaultButton(null);
                break block17;
            }
            for (int i = 0; i < this.getComponentCount(); ++i) {
                final Component component = this.getComponent(i);
                if (!e.getButtonName().equals(component.getName())) continue;
                switch (e.getID()) {
                    case 3301: {
                        component.setVisible(true);
                        if (component instanceof JButton && ((JButton)component).getAction() != null) {
                            ((JButton)component).getAction().setEnabled(true);
                        }
                        component.setEnabled(true);
                        break;
                    }
                    case 3302: {
                        component.setEnabled(false);
                        if (component instanceof JButton && ((JButton)component).getAction() != null) {
                            ((JButton)component).getAction().setEnabled(false);
                        }
                        component.setVisible(true);
                        break;
                    }
                    case 3299: {
                        component.setVisible(true);
                        break;
                    }
                    case 3300: {
                        component.setVisible(false);
                        JRootPane rootPane = this.getRootPane();
                        if (rootPane != null && rootPane.getDefaultButton() == component) {
                            rootPane.setDefaultButton(null);
                        }
                        if (rootPane == null || rootPane.getClientProperty("initialDefaultButton") != component) break;
                        rootPane.putClientProperty("initialDefaultButton", null);
                        break;
                    }
                    case 3303: {
                        if (!(component instanceof AbstractButton)) break;
                        ((AbstractButton)component).setText(e.getUserObject());
                        break;
                    }
                    case 3304: {
                        if (!(component instanceof AbstractButton)) break;
                        ((AbstractButton)component).setMnemonic(e.getUserObject().charAt(0));
                        break;
                    }
                    case 3305: {
                        if (!(component instanceof AbstractButton)) break;
                        ((AbstractButton)component).setToolTipText(e.getUserObject());
                        break;
                    }
                    case 3306: {
                        Runnable runnable2 = new Runnable(){

                            @Override
                            public void run() {
                                component.requestFocus();
                            }
                        };
                        SwingUtilities.invokeLater(runnable2);
                        break;
                    }
                    case 3307: {
                        if (!(component instanceof JButton)) break;
                        if (this.getRootPane() != null) {
                            this.getRootPane().setDefaultButton((JButton)component);
                            break;
                        }
                        this._defaultButton = (JButton)component;
                        this._addNotify = true;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._addNotify) {
            JRootPane pane = this.getRootPane();
            if (this._defaultButton != null && pane != null) {
                pane.setDefaultButton(this._defaultButton);
                this._addNotify = false;
                this._defaultButton = null;
            }
        }
    }

    public Component getButtonByName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("name cannot be null or empty");
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!name.equals(component.getName())) continue;
            return component;
        }
        return null;
    }
}

