/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.UndoRedoSupport;
import ca.odell.glazedlists.event.ListEvent;
import java.util.ArrayList;
import java.util.List;

public class TransactionList<E>
extends TransformedList<E, E> {
    private UndoRedoSupport rollbackSupport;
    private final List<Context> txContextStack = new ArrayList<Context>();

    public TransactionList(EventList<E> source2) {
        this(source2, true);
    }

    TransactionList(EventList<E> source2, boolean rollbackSupport) {
        super(source2);
        if (rollbackSupport) {
            this.rollbackSupport = UndoRedoSupport.install(source2);
            this.rollbackSupport.addUndoSupportListener(new RollbackSupportListener());
        }
        source2.addListEventListener(this);
    }

    public void beginEvent() {
        this.beginEvent(true);
    }

    public void beginEvent(boolean buffered) {
        if (buffered) {
            this.updates.beginEvent(true);
        }
        this.txContextStack.add(new Context(buffered));
    }

    public void commitEvent() {
        if (this.rollbackSupport != null && this.txContextStack.isEmpty()) {
            throw new IllegalStateException("No ListEvent exists to commit");
        }
        this.txContextStack.remove(this.txContextStack.size() - 1).commit();
    }

    public void rollbackEvent() {
        if (this.rollbackSupport == null) {
            throw new IllegalStateException("This TransactionList does not support rollback");
        }
        if (this.txContextStack.isEmpty()) {
            throw new IllegalStateException("No ListEvent exists to roll back");
        }
        this.txContextStack.remove(this.txContextStack.size() - 1).rollback();
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    @Override
    public void dispose() {
        if (this.rollbackSupport != null) {
            this.rollbackSupport.uninstall();
        }
        this.rollbackSupport = null;
        this.txContextStack.clear();
        super.dispose();
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        this.updates.forwardEvent(listChanges);
    }

    private final class Context {
        private UndoRedoSupport.CompositeEdit rollbackEdit;
        private boolean eventStarted;

        public Context(boolean eventStarted) {
            this.rollbackEdit = TransactionList.this.rollbackSupport == null ? null : new UndoRedoSupport.CompositeEdit(TransactionList.this.rollbackSupport);
            this.eventStarted = false;
            this.eventStarted = eventStarted;
        }

        public void add(UndoRedoSupport.Edit edit) {
            if (this.rollbackEdit != null) {
                this.rollbackEdit.add(edit);
            }
        }

        public void commit() {
            this.rollbackEdit = null;
            if (this.eventStarted) {
                TransactionList.this.updates.commitEvent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback() {
            if (this.rollbackEdit != null) {
                TransactionList.this.updates.beginEvent(true);
                try {
                    this.rollbackEdit.undo();
                }
                finally {
                    TransactionList.this.updates.commitEvent();
                }
                this.rollbackEdit = null;
            }
            if (this.eventStarted) {
                TransactionList.this.updates.discardEvent();
            }
        }
    }

    private class RollbackSupportListener
    implements UndoRedoSupport.Listener {
        private RollbackSupportListener() {
        }

        @Override
        public void undoableEditHappened(UndoRedoSupport.Edit edit) {
            if (!TransactionList.this.txContextStack.isEmpty()) {
                ((Context)TransactionList.this.txContextStack.get(TransactionList.this.txContextStack.size() - 1)).add(edit);
            }
        }
    }
}

