/*
 * This file is part of gtkD.
 *
 * gtkD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * gtkD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities the gir-to-d pakage


module gio.ActionMapIF;

private import gio.ActionIF;
private import gio.c.functions;
public  import gio.c.types;
private import glib.Str;
private import gobject.ObjectG;


/**
 * `GActionMap` is an interface for action containers.
 * 
 * The `GActionMap` interface is implemented by [iface@Gio.ActionGroup]
 * implementations that operate by containing a number of named
 * [iface@Gio.Action] instances, such as [class@Gio.SimpleActionGroup].
 * 
 * One useful application of this interface is to map the
 * names of actions from various action groups to unique,
 * prefixed names (e.g. by prepending "app." or "win.").
 * This is the motivation for the ‘Map’ part of the interface
 * name.
 *
 * Since: 2.32
 */
public interface ActionMapIF{
	/** Get the main Gtk struct */
	public GActionMap* getActionMapStruct(bool transferOwnership = false);

	/** the main Gtk struct as a void* */
	protected void* getStruct();


	/** */
	public static GType getType()
	{
		return g_action_map_get_type();
	}

	/**
	 * Adds an action to the @action_map.
	 *
	 * If the action map already contains an action with the same name
	 * as @action then the old action is dropped from the action map.
	 *
	 * The action map takes its own reference on @action.
	 *
	 * Params:
	 *     action = a [iface@Gio.Action]
	 *
	 * Since: 2.32
	 */
	public void addAction(ActionIF action);

	/**
	 * A convenience function for creating multiple [class@Gio.SimpleAction]
	 * instances and adding them to a [iface@Gio.ActionMap].
	 *
	 * Each action is constructed as per one [struct@Gio.ActionEntry].
	 *
	 * ```c
	 * static void
	 * activate_quit (GSimpleAction *simple,
	 * GVariant      *parameter,
	 * gpointer       user_data)
	 * {
	 * exit (0);
	 * }
	 *
	 * static void
	 * activate_print_string (GSimpleAction *simple,
	 * GVariant      *parameter,
	 * gpointer       user_data)
	 * {
	 * g_print ("%s\n", g_variant_get_string (parameter, NULL));
	 * }
	 *
	 * static GActionGroup *
	 * create_action_group (void)
	 * {
	 * const GActionEntry entries[] = {
	 * { "quit",         activate_quit              },
	 * { "print-string", activate_print_string, "s" }
	 * };
	 * GSimpleActionGroup *group;
	 *
	 * group = g_simple_action_group_new ();
	 * g_action_map_add_action_entries (G_ACTION_MAP (group), entries, G_N_ELEMENTS (entries), NULL);
	 *
	 * return G_ACTION_GROUP (group);
	 * }
	 * ```
	 *
	 * Params:
	 *     entries = a pointer to
	 *         the first item in an array of [struct@Gio.ActionEntry] structs
	 *     userData = the user data for signal connections
	 *
	 * Since: 2.32
	 */
	public void addActionEntries(GActionEntry[] entries, void* userData);

	/**
	 * Looks up the action with the name @action_name in @action_map.
	 *
	 * If no such action exists, returns `NULL`.
	 *
	 * Params:
	 *     actionName = the name of an action
	 *
	 * Returns: a [iface@Gio.Action]
	 *
	 * Since: 2.32
	 */
	public ActionIF lookupAction(string actionName);

	/**
	 * Removes the named action from the action map.
	 *
	 * If no action of this name is in the map then nothing happens.
	 *
	 * Params:
	 *     actionName = the name of the action
	 *
	 * Since: 2.32
	 */
	public void removeAction(string actionName);

	/**
	 * Remove actions from a [iface@Gio.ActionMap]. This is meant as the reverse of
	 * [method@Gio.ActionMap.add_action_entries].
	 *
	 *
	 * ```c
	 * static const GActionEntry entries[] = {
	 * { "quit",         activate_quit              },
	 * { "print-string", activate_print_string, "s" }
	 * };
	 *
	 * void
	 * add_actions (GActionMap *map)
	 * {
	 * g_action_map_add_action_entries (map, entries, G_N_ELEMENTS (entries), NULL);
	 * }
	 *
	 * void
	 * remove_actions (GActionMap *map)
	 * {
	 * g_action_map_remove_action_entries (map, entries, G_N_ELEMENTS (entries));
	 * }
	 * ```
	 *
	 * Params:
	 *     entries = a pointer to
	 *         the first item in an array of [struct@Gio.ActionEntry] structs
	 *
	 * Since: 2.78
	 */
	public void removeActionEntries(GActionEntry[] entries);
}
